<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:variable name="IsCLICmdNew">
  <xsl:choose>
    <xsl:when test="/OMA/OMACMDNEW='0'">false</xsl:when>
    <xsl:otherwise>true</xsl:otherwise>
  </xsl:choose>
</xsl:variable>
<xsl:template match="OMA">
	<xsl:choose>
		<xsl:when test="/OMA/@cli = 'true'">
		     <xsl:choose>
				<xsl:when test="SMStatus != '0'">
					<xsl:call-template name="failure"/>
				</xsl:when>
				<xsl:otherwise>
     					<DataArea>
						<PageTitle>
							<xsl:attribute name="display"><xsl:value-of select="$strTemperatureProbes"/></xsl:attribute>
						</PageTitle>
						<xsl:for-each select="Chassis">
							<xsl:call-template name="ChassisTemps"/>
						</xsl:for-each>
					</DataArea>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
		     <xsl:choose>
				<xsl:when test="TemperatureProbeList/@count = '0' or SMStatus != '0'">
					<xsl:call-template name="failure"/>
				</xsl:when>
				<xsl:otherwise>
					<DataArea>
						<PageTitle>
							<xsl:attribute name="display"><xsl:value-of select="$strTemperatureProbes1"/></xsl:attribute>
							<xsl:attribute name="status"><xsl:value-of select="/OMA/ObjStatus"/></xsl:attribute>
						</PageTitle>
						<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
							<PromptText><xsl:value-of select="$strClickTheProbe"/></PromptText>
						</xsl:if>
						<CustomButton>
							<Data name="Refresh">
								<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
								<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.ListTemperatureWebPlugin&amp;help=Temperatures&amp;poid=<xsl:value-of select="/OMA/TemperatureProbeList/@poid"/></xsl:attribute>

							</Data>
						</CustomButton>
						<TableData columnspacing="true">
							<xsl:apply-templates select="TemperatureProbeList"/>
						</TableData>
					</DataArea>
				</xsl:otherwise>
			</xsl:choose>
          </xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="ChassisTemps">
		<xsl:choose>
			<xsl:when test="Redundancy !=''">
				<xsl:variable name="redundata"><xsl:value-of select="Redundancy"/></xsl:variable>
				<xsl:choose>
					<xsl:when test="$redundata != '' ">
						<TableData name="reduntable">
							<xsl:attribute name="display"><xsl:value-of select="$strRedundancy"/></xsl:attribute>
						    <xsl:if test="/OMA/@cli = 'true'">
							     <SubHeader banner='true'>
                     <xsl:choose>
                       <xsl:when test="$IsCLICmdNew='true'">
                         <xsl:attribute name="display"><xsl:value-of select="$strMainSystem"/><xsl:value-of select="$strTemperatures"/></xsl:attribute>
                       </xsl:when>
                       <xsl:otherwise>
                         <xsl:attribute name="display"><xsl:value-of select="@display"/><xsl:value-of select="$strTemperatures"/></xsl:attribute>
                       </xsl:otherwise>
                     </xsl:choose>
								     
								     <xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
							     </SubHeader>
							</xsl:if>
							<SubHeader>
								<xsl:attribute name="display"><xsl:value-of select="$strTemperatureRedundancy"/></xsl:attribute>
								<xsl:attribute name="status"><xsl:value-of select="Redundancy/@status"/></xsl:attribute>
							</SubHeader>
							<xsl:apply-templates select="Redundancy"/>
						</TableData>
						<TableData columnspacing="true" name="probestable">
							<xsl:attribute name="display"><xsl:value-of select="$strProbeList"/></xsl:attribute>
							<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
								<xsl:choose>
									<xsl:when test="/OMA/@cli = 'true'"></xsl:when>
									<xsl:otherwise>
										<PromptText><xsl:value-of select="$strClickTheProbe1"/></PromptText>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:if>
							<xsl:apply-templates select="TemperatureProbeList"/>
						</TableData>
					</xsl:when>
					<xsl:otherwise>
						<TableData columnspacing="true" name="probestable">
							<xsl:attribute name="display"><xsl:value-of select="$strProbeList1"/></xsl:attribute>
							<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
								<xsl:choose>
									<xsl:when test="/OMA/@cli = 'true'"></xsl:when>
									<xsl:otherwise>
										<PromptText><xsl:value-of select="$strClickTheProbe2"/></PromptText>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:if>
						    <xsl:if test="/OMA/@cli = 'true'">
							     <SubHeader banner='true'>
                    <xsl:choose>
                       <xsl:when test="$IsCLICmdNew='true'">
                         <xsl:attribute name="display"><xsl:value-of select="$strMainSystem"/><xsl:value-of select="$strTemperatures"/></xsl:attribute>
                       </xsl:when>
                       <xsl:otherwise>
                         <xsl:attribute name="display"><xsl:value-of select="@display"/><xsl:value-of select="$strTemperatures"/></xsl:attribute>
                       </xsl:otherwise>
                    </xsl:choose>

								     <xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
							     </SubHeader>
							</xsl:if>
							<xsl:apply-templates select="TemperatureProbeList"/>
						</TableData>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
					<xsl:choose>
						<xsl:when test="/OMA/@cli = 'true'"></xsl:when>
						<xsl:otherwise>
							<PromptText><xsl:value-of select="$strClickTheProbe3"/></PromptText>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<TableData columnspacing="true" name="probestable">
		     <xsl:choose>
             <xsl:when test="$IsCLICmdNew='true'">
               <xsl:attribute name="display"><xsl:value-of select="$strMainSystem"/><xsl:value-of select="$strTemperatures"/></xsl:attribute>
             </xsl:when>
             <xsl:otherwise>
               <xsl:attribute name="display"><xsl:value-of select="@display"/><xsl:value-of select="$strTemperatures"/></xsl:attribute>
             </xsl:otherwise>
          </xsl:choose>
					<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
					<xsl:if test="/OMA/@cli = 'true'">
						<SubHeader banner='true'>
	       	   <xsl:choose>
             <xsl:when test="$IsCLICmdNew='true'">
               <xsl:attribute name="display"><xsl:value-of select="$strMainSystem"/><xsl:value-of select="$strTemperatures"/></xsl:attribute>
             </xsl:when>
             <xsl:otherwise>
               <xsl:attribute name="display"><xsl:value-of select="@display"/><xsl:value-of select="$strTemperatures"/></xsl:attribute>
             </xsl:otherwise>
             </xsl:choose>

						    	<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
	                              	</SubHeader>
	                           </xsl:if>
				       <xsl:apply-templates select="TemperatureProbeList"/>
				</TableData>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

<xsl:template name="failure">
	<DataArea>
		<TableData>
			<Header>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strError"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strError1"/></xsl:attribute>
				</Data>
			</Header>
			<Row>
				<Data>
				 	<xsl:attribute name="value"><xsl:value-of select="$strNoTemperatureProbe"/></xsl:attribute>
				</Data>
			</Row>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template match="TemperatureProbeList">
	<xsl:choose>
		<xsl:when test="/OMA/@cli = 'true'">
			<Header>
				<Data name="index">
					<xsl:attribute name="ignoreonweb">true</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strIndex1"/></xsl:attribute>
				</Data>
				<Data name="Status" align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStatus1"/></xsl:attribute>
				</Data>
				<Data name="ProbeName">
					<xsl:attribute name="display"><xsl:value-of select="$strProbeName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strProbeName1"/></xsl:attribute>
				</Data>
				<Data name="Reading" align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strReading"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strReading1"/></xsl:attribute>
				</Data>
				<Data name="min" align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strMinimumWarningThreshold"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMinimumWarningThreshold1"/></xsl:attribute>
				</Data>
				<Data name="max" align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strMaximumWarningThreshold"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMaximumWarningThreshold1"/></xsl:attribute>
				</Data>
				<Data name="min" align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strMinimumFailureThreshold"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMinimumFailureThreshold1"/></xsl:attribute>
				</Data>
				<Data name="max" align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strMaximumFailureThreshold"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMaximumFailureThreshold1"/></xsl:attribute>
				</Data>
			</Header>
		</xsl:when>
		<xsl:otherwise>
			<Header>
				<Data name="" ignoreonweb="true"><xsl:attribute name="value"><xsl:value-of select="$str"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str1"/></xsl:attribute></Data>
				<Data name=""><xsl:attribute name="value"><xsl:value-of select="$str2"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str3"/></xsl:attribute></Data>
				<Data name=""><xsl:attribute name="value"><xsl:value-of select="$str4"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str5"/></xsl:attribute></Data>
				<Data name=""><xsl:attribute name="value"><xsl:value-of select="$str6"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str7"/></xsl:attribute></Data>
				<Data name="WarningThreshold"  colspan="2" align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strWarningThreshold"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strWarningThreshold1"/></xsl:attribute>
				</Data>
				<Data name="FailureThreshold" colspan="2" align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strFailureThreshold"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strFailureThreshold1"/></xsl:attribute>
				</Data>
			</Header>
			<Header>
				<Data name="index">
					<xsl:attribute name="ignoreonweb">true</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strIndex2"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strIndex3"/></xsl:attribute>
				</Data>
				<Data name="Status" align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strStatus2"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStatus3"/></xsl:attribute>
				</Data>
				<Data name="ProbeName">
					<xsl:attribute name="display"><xsl:value-of select="$strProbeName2"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strProbeName3"/></xsl:attribute>
				</Data>
				<Data name="Reading" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strReading2"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strReading3"/></xsl:attribute>
				</Data>
				<Data name="min" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strMinimum"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMinimum1"/></xsl:attribute>
					<xsl:attribute name="append"><xsl:value-of select="$strWarningThreshold2"/></xsl:attribute>
          <xsl:attribute name="noborder">true</xsl:attribute>
				</Data>
				<Data name="max" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strMaximum"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMaximum1"/></xsl:attribute>
					<xsl:attribute name="append"><xsl:value-of select="$strWarningThreshold3"/></xsl:attribute>
				</Data>
				<Data name="min" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strMinimum2"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMinimum3"/></xsl:attribute>
					<xsl:attribute name="append"><xsl:value-of select="$strFailureThreshold2"/></xsl:attribute>
          <xsl:attribute name="noborder">true</xsl:attribute>
				</Data>
				<Data name="max" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strMaximum2"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMaximum3"/></xsl:attribute>
					<xsl:attribute name="append"><xsl:value-of select="$strFailureThreshold3"/></xsl:attribute>
				</Data>
			</Header>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
		<xsl:when test="/OMA/@cli = 'true'">
			<xsl:apply-templates select="TemperatureProbe">
				<xsl:sort data-type="number" select="@index" order="ascending"/>
				<xsl:with-param name="poid"><xsl:value-of select="@poid"/></xsl:with-param>
			</xsl:apply-templates>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="TemperatureProbe">
				<xsl:sort data-type="number" select="@index" order="ascending"/>
				<xsl:with-param name="poid"><xsl:value-of select="@poid"/></xsl:with-param>
			</xsl:apply-templates>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="TemperatureProbe">
	<xsl:param name="poid"/>
	<Row>
		<xsl:element name="Data">
			<xsl:attribute name="ignoreonweb">true</xsl:attribute>
			<xsl:attribute name="display" ><xsl:value-of select="@index"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
		</xsl:element>
		<xsl:element name="Data">
			<xsl:attribute name="align">center</xsl:attribute>
			<xsl:attribute name="type">status</xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
		</xsl:element>
			<xsl:element name="Data">
			<xsl:attribute name="value"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
			<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
				<xsl:if test="(ProbeThresholds/LCThreshold != '-2147483648') and (ProbeThresholds/UCThreshold != '-2147483648') and (ProbeThresholds/LNCThreshold != '-2147483648') and (ProbeThresholds/UNCThreshold != '-2147483648') and (ProbeReading != '-2147483648') and (SubType != '16') and (SubType != '20')">
					<xsl:choose>
						<xsl:when test="(Capabilities/ProbeUNCDefSetEnabled = 'false') and (Capabilities/ProbeLNCDefSetEnabled  = 'false') and (Capabilities/ProbeUNCSetEnabled = 'false') and (Capabilities/ProbeLNCSetEnabled = 'false')">
							<!-- need not provide a link to the editable page -->
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="link">true</xsl:attribute>
							<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.TemperatureWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;help=EditTemperatureProbes&amp;poid=<xsl:value-of select="@poid"/>&amp;help=Temperatures</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:if>
			<xsl:attribute name="align">left</xsl:attribute>
		</xsl:element>
		<xsl:choose>
			<xsl:when test="SubType='16'">
				<xsl:element name="Data">
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="ProbeReading='true'"><xsl:value-of select="$strYes"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNo"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="ProbeReading"/></xsl:attribute>
					<xsl:attribute name="align">left</xsl:attribute>
				</xsl:element>
				<Data name="LNCThreshhold" align="left"><xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute></Data>
				<Data name="UNCThreshhold" align="left"><xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute></Data>
				<Data name="LCThreshhold" align="left"><xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute></Data>
				<Data name="UCThreshhold" align="left"><xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute></Data>
			</xsl:when>
			<xsl:when test="SubType='20'">
				<xsl:element name="Data">
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="ProbeReading = '1'"><xsl:value-of select="$strGood"/></xsl:when>
                            <xsl:when test="ProbeReading = '2'"><xsl:value-of select="$strBad"/></xsl:when>
						</xsl:choose>
					</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="ProbeReading"/></xsl:attribute>
					<xsl:attribute name="align">left</xsl:attribute>
				</xsl:element>
				<Data name="LNCThreshhold" align="left"><xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute></Data>
				<Data name="UNCThreshhold" align="left"><xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute></Data>
				<Data name="LCThreshhold" align="left"><xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute></Data>
				<Data name="UCThreshhold" align="left"><xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute></Data>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="Data">
					<xsl:attribute name="value">
						<xsl:call-template name="calVolt">
							<xsl:with-param name="volt"><xsl:value-of select="ProbeReading"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="ProbeReading"/></xsl:attribute>
					<xsl:attribute name="type">ustring</xsl:attribute>
					<xsl:attribute name="editable">false</xsl:attribute>
					<xsl:attribute name="align">left</xsl:attribute>
				</xsl:element>
				<xsl:element name="Data">
					<xsl:attribute name="value">
						<xsl:call-template name="calVolt">
							<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LNCThreshold"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/LNCThreshold"/></xsl:attribute>
					<xsl:attribute name="type">ustring</xsl:attribute>
					<xsl:attribute name="editable">false</xsl:attribute>
					<xsl:attribute name="align">left</xsl:attribute>
				</xsl:element>
				<xsl:element name="Data">
					<xsl:attribute name="value">
						<xsl:call-template name="calVolt">
							<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:attribute>
					<xsl:attribute name="type">ustring</xsl:attribute>
					<xsl:attribute name="editable">false</xsl:attribute>
					<xsl:attribute name="align">left</xsl:attribute>
				</xsl:element>
				<xsl:element name="Data">
					<xsl:attribute name="value">
						<xsl:call-template name="calVolt">
							<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LCThreshold"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/LCThreshold"/></xsl:attribute>
					<xsl:attribute name="type">ustring</xsl:attribute>
					<xsl:attribute name="editable">false</xsl:attribute>
					<xsl:attribute name="align">left</xsl:attribute>
				</xsl:element>
				<xsl:element name="Data">
					<xsl:attribute name="value">
						<xsl:call-template name="calVolt">
							<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UCThreshold"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/UCThreshold"/></xsl:attribute>
					<xsl:attribute name="type">ustring</xsl:attribute>
					<xsl:attribute name="editable">false</xsl:attribute>
					<xsl:attribute name="align">left</xsl:attribute>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</Row>
</xsl:template>

<xsl:template name="calVolt">
	<xsl:param name="volt"/>
	<xsl:choose>
		<xsl:when test="$volt = '-2147483648'"><xsl:value-of select="$strNA"/></xsl:when>
		<xsl:otherwise>
			<xsl:variable name="formatval"><xsl:value-of select="format-number($volt div 10,'##0.0')"/></xsl:variable>
			<xsl:variable name="univdecsep">
				<xsl:choose>
					<xsl:when test="contains($formatval , '.') and string-length(substring-after($formatval , '.')) = 1">.</xsl:when>
					<xsl:when test="contains($formatval , ',') and string-length(substring-after($formatval , ',')) = 1">,</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="localdecsep"><xsl:value-of select="$strDecimalFractionSeperatorPart2"/></xsl:variable>
			<xsl:value-of select="translate($formatval, $univdecsep,$localdecsep)"/><xsl:value-of select="$strC"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template match="*"/>
</xsl:stylesheet>
