<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

<xsl:template match="/">
	<xsl:choose>
    	<xsl:when test="OMA/ObjCount = '0' or OMA/SMStatus != '0'">
			<xsl:call-template name="NoLicenseDeviceObj"/>
		</xsl:when>
		
		 <xsl:when test = "/OMA/@cli = 'true' ">

              <DataArea>
				<PageTitle>
					<xsl:attribute name="display">Licenses information</xsl:attribute>
					<xsl:attribute name="status"><xsl:value-of select="ObjCount"/></xsl:attribute>
				</PageTitle>
				<ListData columnspacing="true">
					<xsl:apply-templates select="OMA/LicenseDeviceObj">
					<xsl:sort data-type="number" select="LicenseDeviceObj/@instance" order="ascending"/>
	                    </xsl:apply-templates>
				</ListData>
			</DataArea>			
		</xsl:when>
		<xsl:otherwise>
			<DataArea>
				<PageTitle>
					<xsl:attribute name="display"><xsl:value-of select="$strLicenseInformation"/></xsl:attribute>
					<xsl:attribute name="status"><xsl:value-of select="ObjCount"/></xsl:attribute>
				</PageTitle>
				<PromptText>
					<xsl:value-of select="$strInstruction"/>
				</PromptText>
				<CustomButton>
					<Data name="Refresh">
						<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
						<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.LicenseReportWebPlugin&amp;help=LicenseReport</xsl:attribute>
					</Data>
				</CustomButton>
				<TableData columnspacing="true">
					<xsl:attribute name="staticcols">4</xsl:attribute>
					<xsl:attribute name="expandable">true</xsl:attribute>
					<xsl:attribute name="expandableheader">
						<xsl:choose>
							<xsl:when test="/OMA/LicenseDeviceObj/deviceType = '1'">
								<xsl:value-of select="$strDeviceDescValue1"/>
							</xsl:when>
						</xsl:choose>
					</xsl:attribute>
					<xsl:apply-templates select="OMA"/>
				</TableData>
			</DataArea>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="OMA">
	<Header>
		<Data name="index" columnspacing="true">
			<xsl:attribute name="ignoreonweb">true</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strIndex1"/></xsl:attribute>
		</Data>
		<Data name="status" align="center" columnspacing="true">
			<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStatus1"/></xsl:attribute>
		</Data>
		<Data name="deviceType" align="center" columnspacing="true">
			<xsl:attribute name="display"><xsl:value-of select="$strDeviceType"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strDeviceType1"/></xsl:attribute>
		</Data>
		<Data name="deviceDesc" align="center" columnspacing="true">
			<xsl:attribute name="display"><xsl:value-of select="$strDeviceDesc"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strDeviceDesc1"/></xsl:attribute>
		</Data>
		<Data name="deviceID" columnspacing="true" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strdeviceID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strdeviceID1"/></xsl:attribute>
		</Data>
		<Data name="NoValDesc" columnspacing="true" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strNoValue"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strNoValue"/></xsl:attribute>
		</Data>	
		
		<xsl:apply-templates select="LicenseDeviceObj/Licensesarray/Licenses"></xsl:apply-templates>

	</Header>
	<xsl:apply-templates select="LicenseDeviceObj">
		<xsl:sort data-type="number" select="LicenseDeviceObj/@instance" order="ascending"/>
	</xsl:apply-templates>
</xsl:template>


<xsl:template match="LicenseDeviceObj">
<xsl:choose>
<xsl:when test=" /OMA/@cli = 'true'">
       <Data name="Test" columnspacing="true" editable="false" type="ustring" align="left">
		    <xsl:attribute name="display">Device Index</xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@instance"/></xsl:attribute>
		</Data>
		 <Data name="Test" columnspacing="true" editable="false" type="ustring" align="left">
		 <xsl:attribute name="type">status</xsl:attribute>
		<xsl:attribute name="display">Device Status</xsl:attribute>
			<xsl:choose>
				<xsl:when test="deviceStatus = '0'" >
					<xsl:attribute name="value"><xsl:value-of select="$strDeviceStatus0"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="deviceStatus = '1'" >
					<xsl:attribute name="value"><xsl:value-of select="$strDeviceStatus1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="deviceStatus = '2'" >
					<xsl:attribute name="value"><xsl:value-of select="$strDeviceStatus2"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="deviceStatus = '3'" >
					<xsl:attribute name="value"><xsl:value-of select="$strDeviceStatus3"/></xsl:attribute>
				</xsl:when>
			</xsl:choose>
		</Data>
		 <Data name="Test" columnspacing="true" editable="false" type="ustring" align="left">

		<xsl:attribute name="display"><xsl:value-of select="$strDeviceType"/></xsl:attribute>

		<xsl:choose>
			<xsl:when test="deviceType = '1' or deviceType = '3'" >
				<xsl:attribute name="value"><xsl:value-of select="$strDeviceTypeValue1"/></xsl:attribute>
			</xsl:when>
		</xsl:choose>
		</Data>
        <Data name="Test" columnspacing="true" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strDeviceDesc"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="deviceType = '1'" >
					<xsl:attribute name="value"><xsl:value-of select="$strDeviceDescValue1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="deviceType = '3'" >
					<xsl:attribute name="value"><xsl:value-of select="$strDeviceDescValue3"/></xsl:attribute>
				</xsl:when>
			</xsl:choose>
		</Data>

		<Data name="Test" columnspacing="true" editable="false" type="ustring" align="left">
		        <xsl:attribute name="display"><xsl:value-of select="$strdeviceID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="DeviceIDStr"/></xsl:attribute>
		</Data>		
		<xsl:apply-templates select="Licensesarray/Licenses"></xsl:apply-templates>
</xsl:when>
<xsl:otherwise>
	<Row>
		<xsl:element name="Data" columnspacing="true">
			<xsl:attribute name="ignoreonweb">true</xsl:attribute>
			<xsl:attribute name="display" ><xsl:value-of select="@instance"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@instance"/></xsl:attribute>
		</xsl:element>
		<xsl:element name="Data" columnspacing="true">
			<xsl:attribute name="align">center</xsl:attribute>
			<xsl:attribute name="type">status</xsl:attribute>
			<!-- Adding status code mapping, as the status obtained for licensing from Disney is different from standard status codes in DataArea.xsl. -->
			<xsl:choose>
				<xsl:when test="deviceStatus = '0'" >
					<xsl:attribute name="value"><xsl:value-of select="$strDeviceStatus0"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="deviceStatus = '1'" >
					<xsl:attribute name="value"><xsl:value-of select="$strDeviceStatus1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="deviceStatus = '2'" >
					<xsl:attribute name="value"><xsl:value-of select="$strDeviceStatus2"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="deviceStatus = '3'" >
					<xsl:attribute name="value"><xsl:value-of select="$strDeviceStatus3"/></xsl:attribute>
				</xsl:when>
			</xsl:choose>
		</xsl:element>
		<xsl:element name="Data" columnspacing="true">
			<xsl:attribute name="align">center</xsl:attribute>
			<xsl:attribute name="type">ustring</xsl:attribute>
			<xsl:choose>
				<xsl:when test="deviceType = '1' or deviceType = '3'" >
					<xsl:attribute name="value"><xsl:value-of select="$strDeviceTypeValue1"/></xsl:attribute>
				</xsl:when>
			</xsl:choose>
		</xsl:element>
		<xsl:element name="Data" columnspacing="true">
			<xsl:attribute name="align">center</xsl:attribute>
			<xsl:attribute name="type">ustring</xsl:attribute>
			<xsl:choose>
				<xsl:when test="deviceType = '1'" >
					<xsl:attribute name="value"><xsl:value-of select="$strDeviceDescValue1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="deviceType = '3'" >
					<xsl:attribute name="value"><xsl:value-of select="$strDeviceDescValue3"/></xsl:attribute>
				</xsl:when>
			</xsl:choose>
		</xsl:element>
		<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
			<xsl:attribute name="value"><xsl:value-of select="DeviceIDStr"/></xsl:attribute>
		</Data>
		<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
			<xsl:attribute name="value"><xsl:value-of select="$strNoValue"/></xsl:attribute>
		</Data>
		<xsl:apply-templates select="Licensesarray/Licenses"></xsl:apply-templates>
	</Row>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="Licensesarray/Licenses">
<xsl:choose>
    <xsl:when test=" /OMA/@cli = 'true'">
	  <Data name="Test" columnspacing="true" editable="false" type="ustring" align="left">
	      <xsl:attribute name="display">License Index</xsl:attribute>
	      <xsl:attribute name="value"><xsl:value-of select="./@index"/></xsl:attribute>
	   </Data>
	</xsl:when>
          <xsl:otherwise>
            <Data name="Test" columnspacing="true" editable="false" type="ustring" align="left">
	      <xsl:attribute name="display"><xsl:value-of select="$strLicense"/></xsl:attribute>
	   </Data>
          </xsl:otherwise>
</xsl:choose>	
	<Data name="Test" columnspacing="true" editable="false" type="ustring" align="left">
	<xsl:choose>
    <xsl:when test=" /OMA/@cli = 'true'">
    <xsl:attribute name="display"><xsl:value-of select="$strLicenseDesc"/></xsl:attribute>
    </xsl:when>
    <xsl:otherwise>
		<xsl:attribute name="display"><xsl:value-of select="concat($hyphenInd,$strLicenseDesc)"/></xsl:attribute>
    </xsl:otherwise>
    </xsl:choose>	
	<xsl:attribute name="value"><xsl:value-of select="LicenseDescStr"/></xsl:attribute>
	</Data>
	<Data name="Test" columnspacing="true" editable="false" type="ustring" align="left">
	<xsl:choose>
    <xsl:when test=" /OMA/@cli = 'true'">
    <xsl:attribute name="display"><xsl:value-of select="$strActionReqDescrip2"/></xsl:attribute>
    </xsl:when>
    <xsl:otherwise>
		<xsl:attribute name="display"><xsl:value-of select="concat($hyphenInd,$strActionReqDescrip2)"/></xsl:attribute>
    </xsl:otherwise>
    </xsl:choose>
		<xsl:choose>
		<xsl:when test="licenseStatus = '0'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc00"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '1'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc1"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '2'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc2"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '3'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc3"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '4'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc4"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '5'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc5"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '6'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc6"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '7'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc7"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '8'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc8"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '9'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc9"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '10'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc10"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '11'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc11"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '12'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc12"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '13'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc13"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '14'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc14"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '15'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc15"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '16'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc16"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '17'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc17"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '18'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc18"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '19'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc19"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '20'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc20"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '21'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc21"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '22'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc22"/></xsl:attribute>
		</xsl:when>
		<xsl:otherwise>
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqCodeDesc0"/></xsl:attribute>
		</xsl:otherwise>
		</xsl:choose>
	</Data>
	<Data name="Test" columnspacing="true" editable="false" type="ustring" align="left">	
	<xsl:choose>
    <xsl:when test=" /OMA/@cli = 'true'">
    <xsl:attribute name="display"><xsl:value-of select="$strLicenseStatusDesc"/></xsl:attribute>
    </xsl:when>
    <xsl:otherwise>		
		<xsl:attribute name="display"><xsl:value-of select="concat($hyphenInd,$strLicenseStatusDesc)"/></xsl:attribute>
    </xsl:otherwise>
    </xsl:choose>
		<xsl:choose>
		<xsl:when test="licenseStatus = '1'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc1"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '2'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc2"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '3'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc3"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '4'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc4"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '5'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc5"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '6'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc6"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '7'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc7"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '8'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc8"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '9'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc9"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '10'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc10"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '11'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc11"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '12'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc12"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '13'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc13"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '14'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc14"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '15'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc15"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '16'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc16"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '17'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc17"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '18'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc18"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '19'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc19"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '20'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc20"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '21'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc21"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="licenseStatus = '22'">
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc22"/></xsl:attribute>
		</xsl:when>
		<xsl:otherwise>
			<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc0"/></xsl:attribute>
		</xsl:otherwise>
		</xsl:choose>
	</Data>
	<Data name="Test" columnspacing="true" editable="false" type="ustring" align="left">
	<xsl:choose>
    <xsl:when test=" /OMA/@cli = 'true'">
    <xsl:attribute name="display"><xsl:value-of select="$strLicenseType"/></xsl:attribute>
    </xsl:when>
    <xsl:otherwise>		
		<xsl:attribute name="display"><xsl:value-of select="concat($hyphenInd,$strLicenseType)"/></xsl:attribute>
    </xsl:otherwise>
    </xsl:choose>
		  <xsl:choose>
			<xsl:when test="licenseType='0'">
				<xsl:attribute name="value"><xsl:value-of select="$strlicenseType0"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="licenseType='1'">
				<xsl:attribute name="value"><xsl:value-of select="$strlicenseType1"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="licenseType='2'">
				<xsl:attribute name="value"><xsl:value-of select="$strlicenseType2"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="licenseType='3'">
				<xsl:attribute name="value"><xsl:value-of select="$strlicenseType3"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="licenseType='4'">
				<xsl:attribute name="value"><xsl:value-of select="$strlicenseType4"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="$strlicenseType5"/></xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</Data>
	<Data name="Test" columnspacing="true" editable="false" type="ustring" align="left">
	<xsl:choose>
    <xsl:when test=" /OMA/@cli = 'true'">
    <xsl:attribute name="display"><xsl:value-of select="$strLicenseEnt"/></xsl:attribute>
    </xsl:when>
    <xsl:otherwise>		
		<xsl:attribute name="display"><xsl:value-of select="concat($hyphenInd,$strLicenseEnt)"/></xsl:attribute>
    </xsl:otherwise>
    </xsl:choose>
		<xsl:attribute name="value"><xsl:value-of select="EntitlementIDStr"/></xsl:attribute>
	</Data>
	<Data name="Test" columnspacing="true" editable="false" type="ustring" align="left">
	
		<xsl:choose>
    <xsl:when test=" /OMA/@cli = 'true'">
    <xsl:attribute name="display"><xsl:value-of select="$strLicenseExpiration"/></xsl:attribute>
    </xsl:when>
    <xsl:otherwise>		
		<xsl:attribute name="display"><xsl:value-of select="concat($hyphenInd,$strLicenseExpiration)"/></xsl:attribute>
    </xsl:otherwise>
    </xsl:choose>		
		<xsl:choose>
			<xsl:when test="concat(expireYear,'-',expireMon,'-',expireDay,' ',expireHour,':',expireMin,':',expireSec)='255-255-255 255:255:255'">
				<xsl:attribute name="value"><xsl:value-of select="$strActionReqDesc0"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="concat('20',expireYear,'-',expireMon,'-',expireDay,' ',expireHour,':',expireMin,':',expireSec)"/></xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</Data>
	<xsl:if test="not(/OMA/@cli) or /OMA/@cli != 'true'">
	<Data name="NoValDesc" columnspacing="true" editable="false" type="ustring" align="left">
		<xsl:attribute name="display"><xsl:value-of select="$strNoValue"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="$strNoValue"/></xsl:attribute>
	</Data>
	</xsl:if>	
</xsl:template>

<xsl:template name="NoLicenseDeviceObj">
	<DataArea>
		<PageTitle>
		<xsl:choose>
		<xsl:when test=" /OMA/@cli = 'true'">
		<xsl:attribute name="display">Licenses information</xsl:attribute>
		</xsl:when>
		<xsl:otherwise>
			<xsl:attribute name="display"><xsl:value-of select="$strLicenseInformation"/></xsl:attribute>
		</xsl:otherwise>
		</xsl:choose>
			<xsl:attribute name="status"><xsl:value-of select="ObjCount"/></xsl:attribute>
		</PageTitle>
		<CustomButton>
			<Data name="Refresh">
				<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.LicenseReportWebPlugin&amp;help=LicenseReport</xsl:attribute>
			</Data>
		</CustomButton>			
		<PromptText>
				<xsl:value-of select="$strLicenseDeviceObj"/>
		</PromptText>

	</DataArea>
</xsl:template>

</xsl:stylesheet>