<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml" />
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA">
		<xsl:choose>
			<xsl:when test="SMStatus != '0'">
				<DataArea printable="false" exportdata="false">
					<PageTitle>
						<xsl:attribute name="display">
							<xsl:call-template name="smstatus">
								<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</PageTitle>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea validate="true" onLoad="true" exportdata="false">
				<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strFanProbes"/></xsl:attribute>
					<xsl:apply-templates select="ServletArguments"/>
					<xsl:apply-templates select="FanProbe"/>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="FanProbe">
		<PageTitle></PageTitle>
		
		<xsl:choose>
			<xsl:when test="(ProbeThresholds/LCThreshold &gt; 0) and (ProbeThresholds/UCThreshold &gt; 0) and (ProbeThresholds/LNCThreshold &gt; 0) and (ProbeThresholds/UNCThreshold &gt; 0) and (ProbeReading &gt;= 0)">
				<Guage  digits="0">
			<SubHeader >
			<xsl:attribute name="display"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
			<xsl:attribute name="status"><xsl:value-of select="@status"/></xsl:attribute>
			</SubHeader>
				<xsl:attribute name="units"> <xsl:value-of select="$strRPM"/></xsl:attribute>
					<Reading><xsl:value-of select="ProbeReading"/></Reading>
					<Probe>Fans</Probe>
					<MFThresh><xsl:value-of select="ProbeThresholds/LCThreshold"/></MFThresh>
					<MXFThresh><xsl:value-of select="ProbeThresholds/UCThreshold"/></MXFThresh>
					<MWThresh><xsl:value-of select="ProbeThresholds/LNCThreshold"/></MWThresh>
					<MXWThresh><xsl:value-of select="ProbeThresholds/UNCThreshold"/></MXWThresh>
					<ListData>
						<Data type="status-text"><xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
						</Data>
						<Data reading="true"><xsl:attribute name="display"><xsl:value-of select="$strReading"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="ProbeReading"/> <xsl:value-of select="$strRPM1"/></xsl:attribute>
						</Data>
						<Data><xsl:attribute name="display"><xsl:value-of select="$strMinFailureThreshold"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="ProbeThresholds/LCThreshold"/><xsl:value-of select="$strRPM2"/></xsl:attribute>
						</Data>
						<Data><xsl:attribute name="display"><xsl:value-of select="$strMaxFailureThreshold"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="ProbeThresholds/UCThreshold"/><xsl:value-of select="$strRPM3"/></xsl:attribute>
						</Data>
						<xsl:choose>
							<xsl:when test="(Capabilities/ProbeUNCDefSetEnabled = 'true') or (Capabilities/ProbeLNCDefSetEnabled = 'true')">
								<Data type="radio"  state="1"><xsl:attribute name="display"><xsl:value-of select="$strThresholdSettings"/></xsl:attribute>
									<xsl:attribute name="name">threshsetting</xsl:attribute>
									<xsl:attribute name="returnvalue">default</xsl:attribute>
									<xsl:attribute name="handler">javascript:setToDef()</xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$strSetToDefault"/></xsl:attribute>
								</Data>
								<xsl:if test="(Capabilities/ProbeUNCSetEnabled = 'true') or (Capabilities/ProbeLNCSetEnabled = 'true')">
									<Data type="radio">
										<xsl:attribute name="name">threshsetting</xsl:attribute>
										<xsl:attribute name="returnvalue">uservalues</xsl:attribute>
										<xsl:attribute name="handler">javascript:setToVal()</xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="$strSetToValues"/></xsl:attribute>
									</Data>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<xsl:if test="(Capabilities/ProbeUNCSetEnabled = 'true') or (Capabilities/ProbeLNCSetEnabled = 'true')">
									<Data type="radio"  state="1"><xsl:attribute name="display"><xsl:value-of select="$strThresholdSettings1"/></xsl:attribute>
										<xsl:attribute name="name">threshsetting</xsl:attribute>
										<xsl:attribute name="returnvalue">uservalues</xsl:attribute>
										<xsl:attribute name="handler">javascript:setToVal()</xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="$strSetToValues1"/></xsl:attribute>
									</Data>
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="(Capabilities/ProbeLNCSetEnabled = 'true')">
							<Data type="editbox"><xsl:attribute name="display"><xsl:value-of select="$strMinWarningThreshold"/></xsl:attribute>
								<xsl:attribute name="textboxname">LNCVal</xsl:attribute>
								<xsl:attribute name="textboxvalue"><xsl:value-of select="ProbeThresholds/LNCThreshold"/></xsl:attribute>
								<xsl:attribute name="unit"><xsl:value-of select="$strRPM4"/></xsl:attribute>
							</Data>
						</xsl:if>
						<xsl:if test="(Capabilities/ProbeUNCSetEnabled = 'true')">
							<Data type="editbox"><xsl:attribute name="display"><xsl:value-of select="$strMaxWarningThreshold"/></xsl:attribute>
								<xsl:attribute name="textboxname">UNCVal</xsl:attribute>
								<xsl:attribute name="textboxvalue"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:attribute>
								<xsl:attribute name="unit"><xsl:value-of select="$strRPM5"/></xsl:attribute>
							</Data>
						</xsl:if>
					</ListData>
				</Guage>
			</xsl:when>
			<xsl:otherwise>
				<ListData>
					<Data type="status-text"><xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
						</Data>
					<Data><xsl:attribute name="display"><xsl:value-of select="$strReading1"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="ProbeReading"/><xsl:value-of select="$strRPM6"/></xsl:attribute>
					</Data>
					<Data><xsl:attribute name="display"><xsl:value-of select="$strMinimumFailureThreshold"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="ProbeThresholds/LCThreshold &gt; 0">
								<xsl:attribute name="value"><xsl:value-of select="ProbeThresholds/LCThreshold"/><xsl:value-of select="$strRPM7"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value"><xsl:value-of select="$strUnknown"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</Data>
					<Data><xsl:attribute name="display"><xsl:value-of select="$strMaximumFailureThreshold"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="ProbeThresholds/UCThreshold &gt; 0">
								<xsl:attribute name="value"><xsl:value-of select="ProbeThresholds/UCThreshold"/><xsl:value-of select="$strRPM8"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value"><xsl:value-of select="$strUnknown1"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</Data>
					<Data type="radio"  state="1"><xsl:attribute name="display"><xsl:value-of select="$strThresholdSettings2"/></xsl:attribute>
						<xsl:attribute name="name">threshsetting</xsl:attribute>
						<xsl:attribute name="returnvalue">default</xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:setToDef()</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSetToDefault1"/></xsl:attribute>
					</Data>
					<Data type="radio">
						<xsl:attribute name="name">threshsetting</xsl:attribute>
						<xsl:attribute name="returnvalue">uservalues</xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:setToVal()</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSetToValues2"/></xsl:attribute>
					</Data>
					<Data type="editbox" size="5"><xsl:attribute name="display"><xsl:value-of select="$strMinWarningThreshold1"/></xsl:attribute>
						<xsl:attribute name="name">LNCVal</xsl:attribute>
						<xsl:choose>
							<xsl:when test="ProbeThresholds/LNCThreshold &gt; 0">
								<xsl:attribute name="value"><xsl:value-of select="ProbeThresholds/LNCThreshold"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value">0</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:attribute name="unit"><xsl:value-of select="$strRPM9"/></xsl:attribute>
					</Data>
					<Data type="editbox" size="5"><xsl:attribute name="display"><xsl:value-of select="$strMaxWarningThreshold1"/></xsl:attribute>
						<xsl:attribute name="name">UNCVal</xsl:attribute>
						<xsl:choose>
							<xsl:when test="ProbeThresholds/UNCThreshold &gt; 0">
								<xsl:attribute name="value"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value">0</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:attribute name="unit"><xsl:value-of select="$strRPM10"/></xsl:attribute>
					</Data>
				</ListData>
			</xsl:otherwise>
		</xsl:choose>
		<script language="javascript">
			isProbeUNCSetEnabled 		= <xsl:value-of select="Capabilities/ProbeUNCSetEnabled"/>;
			isProbeLNCSetEnabled 		= <xsl:value-of select="Capabilities/ProbeLNCSetEnabled"/>;
			isProbeUNCDefSetEnabled 	= <xsl:value-of select="Capabilities/ProbeUNCDefSetEnabled"/>;
			isProbeLNCDefSetEnabled 	= <xsl:value-of select="Capabilities/ProbeLNCDefSetEnabled"/>;

			setToDefault	= true;
			setToValues	= false;

if( (( ! isProbeUNCDefSetEnabled )  &amp;&amp; (! isProbeLNCDefSetEnabled)) &amp;&amp; ( isProbeUNCSetEnabled || isProbeLNCSetEnabled ) )
{
	setToValues	= true;
}

			function initializationRoutine()
			{
				if( isProbeUNCSetEnabled )
				{
					document.getElementById("UNCVal").value = <xsl:value-of select="ProbeThresholds/UNCThreshold"/>;
					document.getElementById("UNCVal").disabled = false;
					if ( ( isProbeUNCDefSetEnabled || isProbeLNCDefSetEnabled ) &amp;&amp; setToDefault )
					{
						document.getElementById("UNCVal").disabled = true;
					}
				}

				if( isProbeLNCSetEnabled )
				{
					document.getElementById("LNCVal").value = <xsl:value-of select="ProbeThresholds/LNCThreshold"/>;
					document.getElementById("LNCVal").disabled = false;
					if ( ( isProbeUNCDefSetEnabled || isProbeLNCDefSetEnabled ) &amp;&amp; setToDefault )
					{
						document.getElementById("LNCVal").disabled = true;
					}
				}

				if( isProbeUNCDefSetEnabled || isProbeLNCDefSetEnabled )
				{
					document.getElementById("threshsetting").checked = true;
				}
			}

			function setToVal()
			{
				setToValues = true;
				setToDefault = false;
				if( isProbeUNCSetEnabled )
				{
					document.getElementById("UNCVal").disabled = false;
				}

				if( isProbeLNCSetEnabled )
				{
					document.getElementById("LNCVal").disabled = false;
				}
			}

			function setToDef()
			{
				setToDefault = true;
				setToValues = false;
				if( isProbeUNCSetEnabled )
				{
					document.getElementById("UNCVal").disabled = true;
				}

				if( isProbeLNCSetEnabled )
				{
					document.getElementById("LNCVal").disabled = true;
				}
			}

			function validate()
			{
				<xsl:choose>
					<xsl:when test="ProbeThresholds/UCThreshold &gt; 0 ">
						var UC 	= parseFloat("<xsl:value-of select="ProbeThresholds/UCThreshold"/>");
						var preUNC = <xsl:value-of select="ProbeThresholds/UNCThreshold"/>;
					</xsl:when>
					<xsl:otherwise>
						var UC 	= 0;
						var preUNC = <xsl:value-of select="ProbeThresholds/UNCThreshold"/>;
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="ProbeThresholds/LCThreshold &gt; 0 ">
						var LC = parseFloat("<xsl:value-of select="ProbeThresholds/LCThreshold"/>");
						var preLNC = <xsl:value-of select="ProbeThresholds/LNCThreshold"/>;
					</xsl:when>
					<xsl:otherwise>
						var LC = 0;
						var preLNC = <xsl:value-of select="ProbeThresholds/LNCThreshold"/>;
					</xsl:otherwise>
				</xsl:choose>

				if(setToValues)
				{
					// user has changed the threshold settings.

					<xsl:if test="Capabilities/ProbeUNCSetEnabled = 'true' ">
						document.getElementById("UNCVal").disabled = false;
						var tempUNC = document.getElementById("UNCVal").value;

						if(isNaN(tempUNC) == true)
						{
							alert(<xsl:value-of select="$strErrorNumberExpected"/>);
							document.getElementById("UNCVal").value = preUNC;
							document.getElementById("LNCVal").value = preLNC;
							return false;
						}

						if(isNaN(parseFloat(tempUNC)) == true)
						{
							alert(<xsl:value-of select="$strErrorWholeNumber"/>);
							document.getElementById("UNCVal").value = preUNC;
							document.getElementById("LNCVal").value = preLNC;
							return false;
						}
						else
						{
							if(tempUNC.indexOf(".") != "-1")
							{
								alert(<xsl:value-of select="$strErrorWholeNumber1"/>);
								document.getElementById("UNCVal").value = preUNC;
								return false;
							}
						}

						var UNC 	= parseFloat(document.getElementById("UNCVal").value);
					</xsl:if>

					<xsl:if test="Capabilities/ProbeLNCSetEnabled = 'true' ">
						document.getElementById("LNCVal").disabled = false;
						var tempLNC 	= document.getElementById("LNCVal").value;

						if( isNaN(tempLNC) == true)
						{
							alert(<xsl:value-of select="$strErrorNumberExpected1"/>);
							document.getElementById("UNCVal").value = preUNC;
							document.getElementById("LNCVal").value = preLNC;
							return false;
						}


						if( isNaN(parseFloat(tempLNC)) == true)
						{
							alert(<xsl:value-of select="$strErrorWholeNumber2"/>);
							document.getElementById("UNCVal").value = preUNC;
							document.getElementById("LNCVal").value = preLNC;
							return false;
						}
						else
						{
							if(tempLNC.indexOf(".") != "-1")
							{
								alert(<xsl:value-of select="$strErrorWholeNumber3"/>);
								document.getElementById("LNCVal").value = preLNC;
								return false;
							}
						}

						var LNC 	= parseFloat(document.getElementById("LNCVal").value);
					</xsl:if>

					if( isProbeUNCSetEnabled &amp;&amp; (! isProbeLNCSetEnabled) )
					{
						// only upper warning threshold is settable.

						if((UC &gt; 0) &amp;&amp; (LC &gt; 0))
						{
							if((UC &gt; UNC) &amp;&amp; (UNC &gt; LC))
							{
								return true;
							}
							else
							{
								// [pp 9/10/03] DFCT 92912- Cuurent error message was causing confusion since the end points of the range were not acceptable value
								// Hence, increasing lower limit by 1 and decreasing upper limit by 1 so that range displayed would show acceptable values correctly.
								LC++;
								UC--;
								alert(<xsl:value-of select="$strErrorTheValue"/>);
							}
						}
						else
						{
							// UC and LC are not available to do validation of UNC value.
							return true;
						}

						document.getElementById("UNCVal").value = preUNC;
					}
					else if( (! isProbeUNCSetEnabled ) &amp;&amp; isProbeLNCSetEnabled )
					{
						// only lower warning threshold is settable.

						if((UC &gt; 0) &amp;&amp; (LC &gt; 0))
						{
							if((UC &gt; LNC) &amp;&amp; (LNC &gt; LC))
							{
								return true;
							}
							else
							{
								// [pp 9/10/03] DFCT 92912
								LC++;
								UC--;
								alert(<xsl:value-of select="$strErrorTheValue1"/>);
							}
						}
						else
						{
							// UC and LC are not available to do validation of LNC value.
							return true;
						}

						document.getElementById("LNCVal").value = preLNC;
					}
					else
					{
						// both are settable

						if((UC &gt; 0) &amp;&amp; (LC &gt; 0))
						{
							if((UC &gt; UNC) &amp;&amp; (UNC &gt; LC))
							{
								if(UNC &gt; LNC)
								{
									if(LNC &gt; LC)
									{
										return true;
									}
									else
									{
										// [pp 9/10/03] DFCT 92912 
										LC++;
										UNC--;
										alert(<xsl:value-of select="$strErrorTheValue2"/>);
									}
								}
								else
								{
									alert("<xsl:value-of select="$strErrorMinimumWarning"/>" );
								}
							}
							else
							{
								if((UC &gt; LNC) &amp;&amp; (LNC &gt; LC))
								{
									// [pp 9/10/03] DFCT 92912
									LNC++;
									UC--;
									alert(<xsl:value-of select="$strErrorTheValue3"/>);
								}
								else
								{
									// [pp 9/10/03] DFCT 92912
									preLNC++;
									UC--;
									alert(<xsl:value-of select="$strErrorTheValue4"/>);
								}
							}
						}
						else
						{
							<!-- UC and LC have invalid values. Accept the user values if they are positive-->
							if( UNC &gt; 0)
							{
								if( LNC &gt; 0)
								{
									if(UNC &gt; LNC)
									{
										return true;
									}
									else
									{
										alert("<xsl:value-of select="$strErrorMinimumWarning1"/>" );
									}
								}
								else
								{
									alert(<xsl:value-of select="$strErrorUnsignedNumber"/>);
								}
							}
							else
							{
								alert(<xsl:value-of select="$strErrorUnsignedNumber1"/>);
							}
						}

						document.getElementById("UNCVal").value = preUNC;
						document.getElementById("LNCVal").value = preLNC;
					}
				}
				else
				{
					// do not validate the values if user has selected default threshold settings.
					return true;
				}

				<!--  returning false doesn't submit the form -->
				return false;
			}
		</script>
	</xsl:template>
	<xsl:template match="ServletArguments">
		<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetFanWebPlugin&amp;oid=<xsl:value-of select="@OID"/>&amp;poid=<xsl:value-of select="@POID"/>&amp;objtype=<xsl:value-of select="@PObjType"/>
</xsl:attribute>
		<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.FanProbesWebPlugin&amp;poid=<xsl:value-of select="@POID"/>&amp;help=Fans</xsl:attribute>
<PageTitle/>

		<CustomButton>
			<Data  name="" >
			<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.EditFanProbeWebPlugin&amp;oid=<xsl:value-of select="@OID"/>&amp;poid=<xsl:value-of select="@POID"/>&amp;help=EditFanProbe</xsl:attribute>
			</Data>
		</CustomButton>
	</xsl:template>
		<xsl:template name="StatusToStr">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status = 1">
				<xsl:attribute name="value"><xsl:value-of select="$strUnknown"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 2">
				<xsl:attribute name="value"><xsl:value-of select="$strOK"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 3">
				<xsl:attribute name="value"><xsl:value-of select="$strNonCritical"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 4">
				<xsl:attribute name="value"><xsl:value-of select="$strCritical"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 5">
				<xsl:attribute name="value"><xsl:value-of select="$strNonRecoverable"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="$strOther"/></xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DataType">
		<xsl:param name="name"/>
		<xsl:param name="display"/>
		<xsl:param name="value"/>
		<xsl:param name="type"/>
		<xsl:param name="link"/>
		<xsl:param name="href"/>
		<Data >
			<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$display"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
			<xsl:attribute name="link"><xsl:value-of select="$link"/></xsl:attribute>
			<xsl:attribute name="href"><xsl:value-of select="$href"/></xsl:attribute>
			<xsl:attribute name="type"><xsl:value-of select="$type"/></xsl:attribute>
		</Data>
	</xsl:template>
		<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '0'"><xsl:value-of select="$strCommandSuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strFanObjectNot"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strFanObjectMalformed"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strFanObjectAlready"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
