<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:template match="/OMA">
	<xsl:choose>
		<xsl:when test="SMStatus='0'"><xsl:call-template name="success"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="failure"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="failure">
	<xsl:choose>
		<xsl:when test="@cli='true'">
			<DataArea>
				<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strErrorProcessorNot"/></xsl:attribute></PageTitle>
			</DataArea>
		</xsl:when>
		<xsl:otherwise>
			<DataArea>
				<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strProcessors"/></xsl:attribute>
				<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.ProcessorWebPlugin&amp;poid=2&amp;help=Processor</xsl:attribute>
				<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strCache"/></xsl:attribute></PageTitle>
				<TableData>
					<Header>
						<Data name="">
							<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
						</Data>
					</Header>
					<Row>
						<Data name="" ><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
							<xsl:attribute name="value">
								<xsl:call-template name="smstatus">
									<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
								</xsl:call-template>
							</xsl:attribute>
						</Data>
					</Row>
				</TableData>
			</DataArea>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="success">
	<xsl:variable name="FoundExternal" select="count(CacheList/DevCache[Location='4'])"/>
	<DataArea backpagetarget="./DataArea?plugin=com.dell.hip.webplugins.ProcessorWebPlugin&amp;poid=2&amp;help=Processor">
		<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strProcessors1"/></xsl:attribute>
		<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strPageTitle"/></xsl:attribute></PageTitle>		
		<CustomButton>
			<Data name="Refresh">
				<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.CacheWebPlugin&amp;oid=<xsl:value-of select="ServletArguments/@oid"/>&amp;help=Cache</xsl:attribute>
			</Data>
		</CustomButton>	
		
    <TableData name="Capabilities">
      <xsl:attribute name="display"><xsl:value-of select="$strSubTitle1"/><xsl:text disable-output-escaping="yes"> </xsl:text><xsl:value-of select="ProcessorConn/ExtName"/></xsl:attribute>
      <SubHeader>
        <xsl:attribute name="display"><xsl:value-of select="$strSubTitle1"/><xsl:text disable-output-escaping="yes"> </xsl:text><xsl:value-of select="ProcessorConn/ExtName"/></xsl:attribute>
      </SubHeader>
      <Header>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strAttributes"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strAttributes1"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strCapable"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strCapable"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strEnabled"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
        </Data>
      </Header>
      
      <Row>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$str64Bit"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$str64Bit"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$str64Bit"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="ShowCapability">
              <xsl:with-param name="Field">
                <xsl:value-of select="DevProcessor/CapableOf64bit"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$str64Bit"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="ShowCapability">
              <xsl:with-param name="Field">
                <xsl:value-of select="DevProcessor/Enabled64bit"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
      </Row>
      
      <xsl:if test="contains(DevProcessor/Manufacturer, 'Intel')">
      <Row>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strHT"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strHT"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strHT"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="ShowCapability">
              <xsl:with-param name="Field">
                <xsl:value-of select="DevProcessor/CapableOfHT"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strHT"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="ShowCapability">
              <xsl:with-param name="Field">
                <xsl:value-of select="DevProcessor/EnabledHT"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
      </Row>
      </xsl:if>
      
      <xsl:if test="DevProcessor/Manufacturer !=''">      
      <Row>
        <xsl:choose>
		  <xsl:when test="contains(DevProcessor/Manufacturer,'Intel')">
          <Data>
              <xsl:attribute name="display"><xsl:value-of select="$strVT"/></xsl:attribute>
              <xsl:attribute name="value"><xsl:value-of select="$strVT"/></xsl:attribute>
          </Data>
		   </xsl:when>
		   <xsl:when test="contains(DevProcessor/Manufacturer, 'AMD')">
          <Data>
             <xsl:attribute name="display"><xsl:value-of select="$strAMD_V"/></xsl:attribute>
             <xsl:attribute name="value"><xsl:value-of select="$strAMD_V"/></xsl:attribute>
          </Data>
		   </xsl:when>
	    </xsl:choose>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strVT"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="ShowCapability">
              <xsl:with-param name="Field">
                <xsl:value-of select="DevProcessor/CapableOfVT"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strVT"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="ShowCapability">
              <xsl:with-param name="Field">
                <xsl:value-of select="DevProcessor/EnabledVT"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
      </Row>
      </xsl:if>
      
      <xsl:if test="DevProcessor/Manufacturer !=''">
      <Row>
        <xsl:choose>
		  <xsl:when test="contains(DevProcessor/Manufacturer,'Intel')">
          <Data>
             <xsl:attribute name="display"><xsl:value-of select="$strDBS"/></xsl:attribute>
             <xsl:attribute name="value"><xsl:value-of select="$strDBS"/></xsl:attribute>
          </Data>
		   </xsl:when>
		   <xsl:when test="contains(DevProcessor/Manufacturer, 'AMD')">
          <Data>
             <xsl:attribute name="display"><xsl:value-of select="$strPowerNow"/></xsl:attribute>
             <xsl:attribute name="value"><xsl:value-of select="$strPowerNow"/></xsl:attribute>
          </Data>
		   </xsl:when>
	    </xsl:choose>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strDBS"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="ShowCapability">
              <xsl:with-param name="Field">
                <xsl:value-of select="DevProcessor/CapableOfDBS"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strDBS"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="ShowCapability">
              <xsl:with-param name="Field">
                <xsl:value-of select="DevProcessor/EnabledDBS"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
      </Row>
      </xsl:if>
      
      <xsl:if test="DevProcessor/Manufacturer !=''">      
      <Row>
        <xsl:choose>
		  <xsl:when test="contains(DevProcessor/Manufacturer,'Intel')">
          <Data>
             <xsl:attribute name="display"><xsl:value-of select="$strXD"/></xsl:attribute>
             <xsl:attribute name="value"><xsl:value-of select="$strXD"/></xsl:attribute>
          </Data>
		  </xsl:when>
		  <xsl:when test="contains(DevProcessor/Manufacturer, 'AMD')">
          <Data>
             <xsl:attribute name="display"><xsl:value-of select="$strNX"/></xsl:attribute>
             <xsl:attribute name="value"><xsl:value-of select="$strNX"/></xsl:attribute>
          </Data>
		  </xsl:when>
	    </xsl:choose>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strNX"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="ShowCapability">
              <xsl:with-param name="Field">
                <xsl:value-of select="DevProcessor/CapableOfNX"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strNX"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="ShowCapability">
              <xsl:with-param name="Field">
                <xsl:value-of select="DevProcessor/EnabledNX"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
      </Row>
      </xsl:if>

      <xsl:if test="contains(DevProcessor/Manufacturer,'Intel')">      
      <Row>
          <Data>
             <xsl:attribute name="display"><xsl:value-of select="$strTRB"/></xsl:attribute>
             <xsl:attribute name="value"><xsl:value-of select="$strTRB"/></xsl:attribute>
          </Data>
		
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strTRB"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="ShowCapability">
              <xsl:with-param name="Field">
                <xsl:value-of select="DevProcessor/CapableOfTRB"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strTRB"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="ShowCapability">
              <xsl:with-param name="Field">
                <xsl:value-of select="DevProcessor/EnabledTRB"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
      </Row>
      </xsl:if>

    </TableData>

    <TableData name="Cache">
		    <xsl:attribute name="display"><xsl:value-of select="$strSubTitle2"/><xsl:text disable-output-escaping="yes"> </xsl:text><xsl:value-of select="ProcessorConn/ExtName"/></xsl:attribute>	
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strSubTitle2"/><xsl:text disable-output-escaping="yes"> </xsl:text><xsl:value-of select="ProcessorConn/ExtName"/></xsl:attribute>	
			</SubHeader>
			<Header>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strAttributes"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strAttributes1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="CacheList/DevCache">
					<Data>
						<xsl:attribute name="display">Cache <xsl:call-template name="count"/></xsl:attribute>
						<xsl:attribute name="value">Cache <xsl:call-template name="count"/></xsl:attribute>
					</Data>		
				</xsl:for-each>
			</Header>		
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStatus1"/></xsl:attribute>
				</Data>
					<xsl:for-each select="CacheList/DevCache">
						<Data>
							<xsl:attribute name="display"><xsl:call-template name="desc"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:call-template name="desc"/></xsl:attribute>
						</Data>			
					</xsl:for-each>		
			</Row>		
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strLevel"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strLevel1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="CacheList/DevCache">
					<Data>
						<xsl:attribute name="display"><xsl:call-template name="level"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="level"/></xsl:attribute>
					</Data>			
				</xsl:for-each>
			</Row>	
			<xsl:if test="$FoundExternal > '0'">
				<Row>
					<Data >
						<xsl:attribute name="display"><xsl:value-of select="$strSpeed"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSpeed1"/></xsl:attribute>
					</Data>
					<xsl:for-each select="CacheList/DevCache">
						<Data>
							<xsl:attribute name="display"><xsl:call-template name="speed"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:call-template name="speed"/></xsl:attribute>
						</Data>
					</xsl:for-each>
				</Row>
			</xsl:if>	
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strMaxSize"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMaxSize1"/></xsl:attribute>
				</Data>
					<xsl:for-each select="CacheList/DevCache">
						<Data>
							<xsl:attribute name="display"><xsl:call-template name="maxsize"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:call-template name="maxsize"/></xsl:attribute>
						</Data>
					</xsl:for-each>
			</Row>		
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strInstalledSize"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strInstalledSize1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="CacheList/DevCache">
					<Data>
						<xsl:attribute name="display"><xsl:call-template name="installedsize"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="installedsize"/></xsl:attribute>
					</Data>
				</xsl:for-each>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strType1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="CacheList/DevCache">
					<Data>
						<xsl:attribute name="display"><xsl:call-template name="type"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="type"/></xsl:attribute>
					</Data>		
				</xsl:for-each>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strLocation"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strLocation1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="CacheList/DevCache">
					<Data>
						<xsl:attribute name="display"><xsl:call-template name="location"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="location"/></xsl:attribute>
					</Data>		
				</xsl:for-each>
			</Row>		
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strWritePolicy"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strWritePolicy1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="CacheList/DevCache">
					<Data>
						<xsl:attribute name="display"><xsl:call-template name="writepolicy"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="writepolicy"/></xsl:attribute>
					</Data>		
				</xsl:for-each>
			</Row>		
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strAssociativity"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strAssociativity1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="CacheList/DevCache">
					<Data>
						<xsl:attribute name="display"><xsl:call-template name="associativity"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="associativity"/></xsl:attribute>
					</Data>		
				</xsl:for-each>
			</Row>
			<xsl:if test="$FoundExternal > '0'">
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strCacheDeviceSupported"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strCacheDeviceSupported1"/></xsl:attribute>
					</Data>
					<xsl:for-each select="CacheList/DevCache">
						<Data>
							<xsl:attribute name="display">
								<xsl:for-each select="SupSRAMTypeMap/*"><xsl:call-template name="supsram"/></xsl:for-each>
							</xsl:attribute>
							<xsl:attribute name="value">
								<xsl:for-each select="SupSRAMTypeMap/*"><xsl:call-template name="supsram"/></xsl:for-each>
							</xsl:attribute>
						</Data>		
					</xsl:for-each>
				</Row>
			</xsl:if>
			<xsl:if test="$FoundExternal > '0'">
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strCacheDeviceCurrent"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strCacheDeviceCurrent1"/></xsl:attribute>
					</Data>
					<xsl:for-each select="CacheList/DevCache">
						<Data>
							<xsl:attribute name="display">
								<xsl:for-each select="CurSRAMTypeMap/*"><xsl:call-template name="cursram"/></xsl:for-each>
							</xsl:attribute>
							<xsl:attribute name="value">
								<xsl:for-each select="CurSRAMTypeMap/*"><xsl:call-template name="cursram"/></xsl:for-each>
							</xsl:attribute>
						</Data>		
					</xsl:for-each>
				</Row>
			</xsl:if>
			<xsl:if test="$FoundExternal > '0'">
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strExternalSocketName"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strExternalSocketName1"/></xsl:attribute>
					</Data>
					<xsl:for-each select="CacheList/DevCache">
						<Data>
							<xsl:attribute name="display"><xsl:call-template name="extsock"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:call-template name="extsock"/></xsl:attribute>
						</Data>	
					</xsl:for-each>
				</Row>	
			</xsl:if>	
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strErrorCorrectionType"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strErrorCorrectionType1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="CacheList/DevCache">
					<Data>
						<xsl:attribute name="display"><xsl:call-template name="errcorr"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="errcorr"/></xsl:attribute>
					</Data>		
				</xsl:for-each>
			</Row>
		</TableData>	
	</DataArea>
</xsl:template>
<xsl:template name="count">
	<xsl:choose>
		<xsl:when test="/OMA/CacheList/@count='1'"></xsl:when>
		<xsl:otherwise>
			<xsl:variable name="index" select="@index"/>
			<xsl:value-of select="number($index)+1"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="desc">
	<xsl:if test="CacheStatus='1'"><xsl:value-of select="$strOther"/></xsl:if>
	<xsl:if test="CacheStatus='2'"><xsl:value-of select="$strUnknown"/></xsl:if>
	<xsl:if test="CacheStatus='3'"><xsl:value-of select="$strEnabled"/></xsl:if>
	<xsl:if test="CacheStatus='4'"><xsl:value-of select="$strUserDisabled"/></xsl:if>
	<xsl:if test="CacheStatus='5'"><xsl:value-of select="$strBIOSDisabled"/></xsl:if>
</xsl:template>
<xsl:template name="level">
	<xsl:choose>
		<xsl:when test="CacheLevel= '1'"><xsl:value-of select="$strOther1"/></xsl:when>
		<xsl:when test="CacheLevel= '2'"><xsl:value-of select="$strUnknown1"/></xsl:when>
		<xsl:when test="CacheLevel= '3'"><xsl:value-of select="$strPrimary"/></xsl:when>
		<xsl:when test="CacheLevel= '4'"><xsl:value-of select="$strSecondary"/></xsl:when>
		<xsl:when test="CacheLevel= '5'"><xsl:value-of select="$strTertiary"/></xsl:when>
	</xsl:choose>
</xsl:template>
<xsl:template name="type">
	<xsl:choose>
		<xsl:when test="CacheType= '1'"><xsl:value-of select="$strOther2"/></xsl:when>
		<xsl:when test="CacheType= '2'"><xsl:value-of select="$strUnknown2"/></xsl:when>
		<xsl:when test="CacheType= '3'"><xsl:value-of select="$strInstruction"/></xsl:when>
		<xsl:when test="CacheType= '4'"><xsl:value-of select="$strData"/></xsl:when>
		<xsl:when test="CacheType= '5'"><xsl:value-of select="$strUnified"/></xsl:when>
	</xsl:choose>
</xsl:template>
<xsl:template name="location">
	<xsl:choose>
		<xsl:when test="Location= '1'"><xsl:value-of select="$strOther3"/></xsl:when>
		<xsl:when test="Location= '2'"><xsl:value-of select="$strUnknown3"/></xsl:when>
		<xsl:when test="Location= '3'"><xsl:value-of select="$strInternal"/></xsl:when>
		<xsl:when test="Location= '4'"><xsl:value-of select="$strExternal"/></xsl:when>
	</xsl:choose>
</xsl:template>
<xsl:template name="writepolicy">
	<xsl:choose>
		<xsl:when test="WritePolicy= '1'"><xsl:value-of select="$strOther4"/></xsl:when>
		<xsl:when test="WritePolicy= '2'"><xsl:value-of select="$strUnknown4"/></xsl:when>
		<xsl:when test="WritePolicy= '3'"><xsl:value-of select="$strWriteBack"/></xsl:when>
		<xsl:when test="WritePolicy= '4'"><xsl:value-of select="$strWriteThrough"/></xsl:when>
		<xsl:when test="WritePolicy= '5'"><xsl:value-of select="$strVariesWithAddress"/></xsl:when>
	</xsl:choose>
</xsl:template>
<xsl:template name="associativity">
	<xsl:choose>
		<xsl:when test="Associativity= '1'"><xsl:value-of select="$strOther5"/></xsl:when>
		<xsl:when test="Associativity= '2'"><xsl:value-of select="$strUnknown5"/></xsl:when>
		<xsl:when test="Associativity= '3'"><xsl:value-of select="$strDirectMapped"/></xsl:when>
		<xsl:when test="Associativity= '4'"><xsl:value-of select="$str2waySetAssociative"/></xsl:when>
		<xsl:when test="Associativity= '5'"><xsl:value-of select="$str4waySetAssociative"/></xsl:when>
		<xsl:when test="Associativity= '6'"><xsl:value-of select="$strFullyAssociative"/></xsl:when>
		<xsl:when test="Associativity= '7'"><xsl:value-of select="$str8waySetAssociative"/></xsl:when>
		<xsl:when test="Associativity= '8'"><xsl:value-of select="$str16waySetAssociative"/></xsl:when>
		<xsl:when test="Associativity= '9'"><xsl:value-of select="$str12waySetAssociative"/></xsl:when>
		<xsl:when test="Associativity= '10'"><xsl:value-of select="$str24waySetAssociative"/></xsl:when>
		<xsl:when test="Associativity= '11'"><xsl:value-of select="$str32waySetAssociative"/></xsl:when>
		<xsl:when test="Associativity= '12'"><xsl:value-of select="$str48waySetAssociative"/></xsl:when>
		<xsl:when test="Associativity= '13'"><xsl:value-of select="$str64waySetAssociative"/></xsl:when>
    <xsl:when test="Associativity= '14'"><xsl:value-of select="$str20waySetAssociative"/></xsl:when>

		<xsl:otherwise><xsl:value-of select="$strUnknown6"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="supsram"><xsl:if test=".='true'"><xsl:value-of select="name()"/><xsl:text disable-output-escaping="yes">  </xsl:text></xsl:if></xsl:template>
<xsl:template name="cursram"><xsl:if test=".='true'"><xsl:value-of select="name()"/><xsl:text disable-output-escaping="yes">  </xsl:text></xsl:if></xsl:template>
<xsl:template name="extsock">
	<xsl:choose>
		<xsl:when test="IsSocketed='false'"><xsl:value-of select="$strUnknown7"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="SocketExtName"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="errcorr">
	<xsl:choose>
		<xsl:when test="ErrCorrType= '1'"><xsl:value-of select="$strOther6"/></xsl:when>
		<xsl:when test="ErrCorrType= '2'"><xsl:value-of select="$strUnknown8"/></xsl:when>
		<xsl:when test="ErrCorrType= '3'"><xsl:value-of select="$strNone"/></xsl:when>
		<xsl:when test="ErrCorrType= '4'"><xsl:value-of select="$strParity"/></xsl:when>
		<xsl:when test="ErrCorrType= '5'"><xsl:value-of select="$strSingleBitECC"/></xsl:when>
		<xsl:when test="ErrCorrType= '6'"><xsl:value-of select="$strMultiBitECC"/></xsl:when>
	</xsl:choose>
</xsl:template>
<xsl:template name="speed">
	<xsl:choose>
		<xsl:when test="Speed='0'"><xsl:value-of select="$strUnknown9"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="Speed"/><xsl:text disable-output-escaping="yes">  </xsl:text><xsl:value-of select="Speed/@unit"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="maxsize">
	<xsl:choose>
		<xsl:when test="MaxSize='0'"><xsl:value-of select="$strUnknown10"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="MaxSize"/><xsl:text disable-output-escaping="yes">  </xsl:text>
			<xsl:call-template name="displayunits"><xsl:with-param name="unit"><xsl:value-of select="MaxSize/@unit"/></xsl:with-param></xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="installedsize">
	<xsl:choose>
		<xsl:when test="InstalledSize='0'"><xsl:value-of select="$strUnknownNotInstalled"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="InstalledSize"/><xsl:text disable-output-escaping="yes">  </xsl:text>
			<xsl:call-template name="displayunits"><xsl:with-param name="unit"><xsl:value-of select="InstalledSize/@unit"/></xsl:with-param></xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="pindex">		
	<xsl:variable name="pindex" select="CacheList/@pindex"/>
	<xsl:value-of select="number($pindex)+1"/>	
</xsl:template>
<xsl:template name="displayunits">
	<xsl:param name="unit"/>
	<xsl:choose>
		<xsl:when test="$unit='MB'"><xsl:value-of select="$strMB"/></xsl:when>
		<xsl:when test="$unit='KB'"><xsl:value-of select="$strKB"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="$unit"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="ShowCapability">
  <xsl:param name="Field"/>
    <xsl:choose>
      <xsl:when test="$Field='true'">
        <xsl:value-of select="$strYes"/>
      </xsl:when>
      <xsl:when test="$Field='false'">
        <xsl:value-of select="$strNo"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$strNA"/>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

  <xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strCacheNotFoundabsent"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strCacheMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strCacheAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
</xsl:template>

<xsl:template match="*"/>
</xsl:stylesheet>
