<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" />
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:choose>
			<xsl:when test="SMStatus != '0'">
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><!--XLATESTART-->&#12456;&#12521;&#12540;! <!--XLATESTOP--><xsl:call-template name="smstatus"><xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</PageTitle>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><!--XLATESTART-->&#12471;&#12515;&#12540;&#12471;&#24773;&#22577;<!--XLATESTOP--></xsl:attribute>
					</PageTitle>
					<ListData>
						<Data>
							<xsl:attribute name="display"><!--XLATESTART-->&#12452;&#12531;&#12487;&#12483;&#12463;&#12473;<!--XLATESTOP--></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Chassis/@index"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><!--XLATESTART-->&#12471;&#12515;&#12540;&#12471;&#21517;<!--XLATESTOP--></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Chassis/@display"/></xsl:attribute>
						</Data>
						<xsl:apply-templates select="ChassisInfo"/>
					</ListData>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="ChassisInfo">
		<xsl:if test="SystemInfo/SystemName">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->&#12507;&#12473;&#12488;&#21517;<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="SystemInfo/SystemName"/></xsl:attribute>
			</Data>			
		</xsl:if>
		<xsl:if test="FirmwareList">
			<xsl:for-each select="FirmwareList/Firmware">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="FWText"/><!--XLATESTART--> &#12496;&#12540;&#12472;&#12519;&#12531;<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="FWVersion"/></xsl:attribute>
				</Data>
			</xsl:for-each>			
		</xsl:if>
		<xsl:if test="ChassisProps1/ChassModel">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->&#12471;&#12515;&#12540;&#12471; &#12514;&#12487;&#12523;<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps1/ChassModel"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps1/ChassLockPresent">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->&#12471;&#12515;&#12540;&#12471; &#12525;&#12483;&#12463;<!--XLATESTOP--></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ChassisProps1/ChassLockPresent = 'true'">
						<xsl:attribute name="value"><!--XLATESTART-->&#12354;&#12426;<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><!--XLATESTART-->&#12394;&#12375;<!--XLATESTOP--></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/ServiceTag">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->&#12469;&#12540;&#12499;&#12473; &#12479;&#12464;<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps2/ServiceTag"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/AssetTag">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->&#31649;&#29702;&#12479;&#12464;<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps2/AssetTag"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/FaultLEDControl != '0'">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->&#37325;&#22823;&#12524;&#12505;&#12523;&#12391;&#12501;&#12457;&#12540;&#12523;&#12488; LED &#12364;&#28857;&#28357;<!--XLATESTOP--></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ChassisProps2/FaultLEDControl = '8'">
						<xsl:attribute name="value"><!--XLATESTART-->&#35686;&#21578;<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:when test="ChassisProps2/FaultLEDControl = '16'">
						<xsl:attribute name="value"><!--XLATESTART-->&#37325;&#35201;<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><!--XLATESTART-->&#26410;&#23450;&#32681;<!--XLATESTOP--></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>
		<xsl:if test="BaseBoardList/@count > '0'">
			<xsl:call-template name="BaseBoard"/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="BaseBoard">
		<xsl:for-each select="/OMA/BaseBoardList/BaseBoard">
			<xsl:if test="FeatureFlags/HostingBoard='true'">
				<Data name="BladeServiceTag" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->&#12502;&#12524;&#12540;&#12489;&#12469;&#12540;&#12499;&#12473;&#12479;&#12464;<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
				</Data>
				<Data name="BladeServiceTag" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->&#12502;&#12524;&#12540;&#12489;&#31649;&#29702;&#12479;&#12464;<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
				</Data>
				<Data name="BladeLocation" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->&#12502;&#12524;&#12540;&#12489;&#12398;&#22580;&#25152;<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><!--XLATESTART-->&#12467;&#12510;&#12531;&#12489;&#22833;&#25943;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '0'"><!--XLATESTART-->&#12467;&#12510;&#12531;&#12489;&#25104;&#21151;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '1'"><!--XLATESTART-->&#12467;&#12510;&#12531;&#12489;&#26410;&#23455;&#35013;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '2'"><!--XLATESTART-->&#19981;&#27491;&#12467;&#12510;&#12531;&#12489;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '3'"><!--XLATESTART-->&#12467;&#12510;&#12531;&#12489; &#12479;&#12452;&#12512;&#12450;&#12454;&#12488;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '4'"><!--XLATESTART-->&#12467;&#12510;&#12531;&#12489; &#12461;&#12515;&#12531;&#12475;&#12523;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '5'"><!--XLATESTART-->&#12467;&#12510;&#12531;&#12489;&#20013;&#27490;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '6'"><!--XLATESTART-->&#12467;&#12510;&#12531;&#12489;&#20445;&#30041;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '7'"><!--XLATESTART-->&#12487;&#12496;&#12452;&#12473;&#12364;&#12354;&#12426;&#12414;&#12379;&#12435;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '8'"><!--XLATESTART-->&#12487;&#12496;&#12452;&#12473;&#12399;&#20351;&#29992;&#20013;&#12391;&#12377;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '9'"><!--XLATESTART-->&#19981;&#27491;&#12394;&#12487;&#12496;&#12452;&#12473;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '10'"><!--XLATESTART-->&#19981;&#27491;&#12394;&#20013;&#26029;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '11'"><!--XLATESTART-->&#12522;&#12477;&#12540;&#12473;&#12364;&#12525;&#12483;&#12463;&#12373;&#12428;&#12390;&#12356;&#12414;&#12377;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '12'"><!--XLATESTART-->&#28961;&#21177;&#12394;&#12452;&#12531;&#12487;&#12483;&#12463;&#12473;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '13'"><!--XLATESTART-->SMB &#12456;&#12521;&#12540;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '14'"><!--XLATESTART-->&#35201;&#27714;&#12373;&#12428;&#12383;&#12487;&#12540;&#12479;&#12399;&#20837;&#25163;&#12391;&#12365;&#12414;&#12379;&#12435;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '15'"><!--XLATESTART-->&#35201;&#27714;&#12373;&#12428;&#12383;&#12487;&#12540;&#12479;&#12399;&#20351;&#29992;&#12391;&#12365;&#12427;&#12487;&#12540;&#12479;&#12434;&#19978;&#22238;&#12387;&#12390;&#12356;&#12414;&#12377;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '16'"><!--XLATESTART-->&#35201;&#27714;&#12373;&#12428;&#12383;&#12487;&#12540;&#12479;&#12399;&#20351;&#29992;&#12391;&#12365;&#12427;&#12487;&#12540;&#12479;&#12434;&#19979;&#22238;&#12387;&#12390;&#12356;&#12414;&#12377;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '17'"><!--XLATESTART-->&#12487;&#12496;&#12452;&#12473;&#12391;&#12467;&#12510;&#12531;&#12489;&#12434;&#21463;&#29702;&#12377;&#12427;&#28310;&#20633;&#12364;&#12391;&#12365;&#12390;&#12356;&#12414;&#12379;&#12435; &#20877;&#35430;&#34892;&#12375;&#12390;&#12367;&#12384;&#12373;&#12356;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '18'"><!--XLATESTART-->&#12487;&#12496;&#12452;&#12473;&#12395;&#12487;&#12540;&#12479;&#12364;&#12354;&#12426;&#12414;&#12379;&#12435;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '19'"><!--XLATESTART-->&#12487;&#12496;&#12452;&#12473;&#12364;&#12513;&#12514;&#12522;&#19981;&#36275;&#12391;&#12377;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '20'"><!--XLATESTART-->&#12487;&#12496;&#12452;&#12473;&#12399;&#26082;&#12395;&#23384;&#22312;&#12375;&#12414;&#12377;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '256'"><!--XLATESTART-->&#12458;&#12502;&#12472;&#12455;&#12463;&#12488;&#12364;&#35211;&#12388;&#12363;&#12426;&#12414;&#12379;&#12435;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '257'"><!--XLATESTART-->&#12458;&#12502;&#12472;&#12455;&#12463;&#12488;&#12398;&#24418;&#24335;&#12364;&#35492;&#12387;&#12390;&#12356;&#12427;&#12363;&#12289;&#30772;&#25613;&#12375;&#12390;&#12356;&#12427;&#12363;&#19981;&#27491;&#12391;&#12377;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '258'"><!--XLATESTART-->&#12458;&#12502;&#12472;&#12455;&#12463;&#12488;&#12399;&#26082;&#12395;&#23384;&#22312;&#12375;&#12414;&#12377;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '260'"><!--XLATESTART-->INI &#12501;&#12449;&#12452;&#12523;&#12364;&#35211;&#12388;&#12363;&#12426;&#12414;&#12379;&#12435;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '261'"><!--XLATESTART-->INI &#12398;&#24418;&#24335;&#12364;&#35492;&#12387;&#12390;&#12356;&#12427;&#12363;&#12289;&#30772;&#25613;&#12375;&#12390;&#12356;&#12427;&#12363;&#19981;&#27491;&#12391;&#12377;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '262'"><!--XLATESTART-->INI &#12475;&#12463;&#12471;&#12519;&#12531;&#12364;&#23384;&#22312;&#12375;&#12414;&#12379;&#12435;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '263'"><!--XLATESTART-->INI &#12461;&#12540;&#12364;&#23384;&#22312;&#12375;&#12414;&#12379;&#12435;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '264'"><!--XLATESTART-->INI &#12398;&#20516;&#12398;&#24418;&#24335;&#12364;&#35492;&#12387;&#12390;&#12356;&#12427;&#12363;&#12289;&#30772;&#25613;&#12375;&#12390;&#12356;&#12427;&#12363;&#19981;&#27491;&#12391;&#12377;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '270'"><!--XLATESTART-->&#12450;&#12463;&#12475;&#12473;&#27177;&#12364;&#21313;&#20998;&#12391;&#12399;&#12354;&#12426;&#12414;&#12379;&#12435;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '271'"><!--XLATESTART-->&#12497;&#12521;&#12513;&#12540;&#12479;&#21517;&#12414;&#12383;&#12399;&#20516;&#12364;&#28961;&#21177;&#12391;&#12377;: <!--XLATESTOP--><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><!--XLATESTART-->&#12513;&#12514;&#12522;&#19981;&#36275;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '280'"><!--XLATESTART-->XML &#12501;&#12449;&#12452;&#12523;&#12364;&#35211;&#12388;&#12363;&#12426;&#12414;&#12379;&#12435;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '281'"><!--XLATESTART-->XML &#12398;&#24418;&#24335;&#12364;&#35492;&#12387;&#12390;&#12356;&#12427;&#12363;&#12289;&#30772;&#25613;&#12375;&#12390;&#12356;&#12427;&#12363;&#19981;&#27491;&#12391;&#12377;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '282'"><!--XLATESTART-->XML &#12494;&#12540;&#12489;&#12364;&#23384;&#22312;&#12375;&#12414;&#12379;&#12435;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '283'"><!--XLATESTART-->XML &#12398;&#20516;&#12398;&#24418;&#24335;&#12364;&#35492;&#12387;&#12390;&#12356;&#12427;&#12363;&#12289;&#30772;&#25613;&#12375;&#12390;&#12356;&#12427;&#12363;&#19981;&#27491;&#12391;&#12377;<!--XLATESTOP--></xsl:when>
		<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>