<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="xml" omit-xml-declaration="yes"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA1">
		<Summary>
			<Section name="MainChassis" display="Main System Chassis">
				<xsl:call-template name="SystemBIOS"/>
				<xsl:call-template name="Firmware"/>
				<xsl:call-template name="DRSCInfo"/>
				
				<!-- AB for NIC Updates -->
				<!-- xsl:call-template name="NICDriverInfo"/ -->
				
			</Section>
			<Section name="Software" display="Software">
				<xsl:call-template name="OSInfo"/>
				<xsl:call-template name="OEMInfo"/>
			</Section>
			<Section name="PERC" display="PERC Firmware">
				<xsl:call-template name="PERCAdaptersInfo"/>
			</Section>
		</Summary>
	</xsl:template>
	<xsl:template name="SystemBIOS">
		<xsl:if test="count(BIOSVerInfo/SystemBIOS) != '0'">
			<ListData name="BIOS Info">
				<xsl:attribute name="display"/>
				<Data name="Name">
					<xsl:attribute name="display"><!--XLATESTART-->Name<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value">BIOS</xsl:attribute>
				</Data>
				<Data name="Version">
					<xsl:attribute name="display"><!--XLATESTART-->Version<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="BIOSVerInfo/SystemBIOS/Version"/></xsl:attribute>
				</Data>
				
			</ListData>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Firmware">
		<xsl:variable name="admin" select="UserAdmin"/>
		<xsl:for-each select="FWVerInfo/FirmwareList/Firmware">
			<ListData name="Firmware Info">
				<xsl:attribute name="display"/>
				<Data name="Name">
					<xsl:attribute name="display"><!--XLATESTART-->Name<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="FWText"/></xsl:attribute>
				</Data>
				<Data name="Version">
					<xsl:attribute name="display"><!--XLATESTART-->Version<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="FWVersion"/></xsl:attribute>
				</Data>
				
			</ListData>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="OSInfo">
		<xsl:if test="count(OSVerInfo/OSInfo) != '0'">
			<ListData name="OS">
				<xsl:attribute name="display"/>
				<Data name="Name">
					<xsl:attribute name="display"><!--XLATESTART-->Name<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="OSVerInfo/OSInfo/OSName"/></xsl:attribute>
				</Data>
				<Data name="Version">
					<xsl:attribute name="display"><!--XLATESTART-->Version<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="OSVerInfo/OSInfo/OSVersion"/></xsl:attribute>
				</Data>
				
			</ListData>
		</xsl:if>
	</xsl:template>
	<xsl:template name="OEMInfo">
		<xsl:if test="count(OEMInfo/OEM/Name) != '0'">
			<ListData name="System Management">
				<xsl:attribute name="display"/>
				<Data name="Name">
					<xsl:attribute name="display"><!--XLATESTART-->Name<!--XLATESTOP--></xsl:attribute>
					<xsl:choose>
						<xsl:when test="OEMInfo/OEM/Name/@display = 'Dell'">
							<xsl:attribute name="value">Dell <xsl:value-of select="OEMInfo/OEM/ProdName"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="value"><xsl:value-of select="OEMInfo/OEM/ProdName"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Data>
				<Data name="Version">
					<xsl:attribute name="display"><!--XLATESTART-->Version<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="AboutInfo/About/ProductVersion"/></xsl:attribute>
				</Data>
				
			</ListData>
		</xsl:if>
	</xsl:template>
	<xsl:template name="DRSCInfo">
		<xsl:if test="count(DRSCInfo/DRSIdentificationObj) != '0'">
			<xsl:if test="DRSCInfo/DRSIdentificationObj/DrsType = '4'">
			<ListData name="Remote Access Controller">
				<xsl:attribute name="display"/>
				<Data name="Name">
					<xsl:attribute name="display"><!--XLATESTART-->Name<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->RAC Firmware<!--XLATESTOP--></xsl:attribute>
				</Data>
				<Data name="Version">
					<xsl:attribute name="display"><!--XLATESTART-->Version<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="DRSCInfo/DRSIdentificationObj/VersionInfo"/></xsl:attribute>
				</Data>
				
			</ListData>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="PERCAdaptersInfo">
	
		<xsl:variable name="admin" select="UserAdmin"/>
		<xsl:for-each select="PERCAdaptersInfo/DCStorageObject">
			<ListData name="PERC Firmware">
				<xsl:attribute name="display"/>
				<Data name="Name">
					<xsl:attribute name="display"><!--XLATESTART-->Name<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Name"/></xsl:attribute>
				</Data>
				<Data name="Version">
					<xsl:attribute name="display"><!--XLATESTART-->Version<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->Firmware Version <!--XLATESTOP--><xsl:value-of select="FirmwareVer"/></xsl:attribute>
				</Data>
				
			</ListData>
		</xsl:for-each>
	</xsl:template>

	<!-- AB for NIC Updates -->
	<!-- xsl:template name="NICDriverInfo">
		<xsl:variable name="updatable" select="LUUpdateable"/>
		<xsl:variable name="admin" select="UserAdmin"/>
		<xsl:for-each select="NICDriverVerInfo/NicDriverInfo/Result/Inventory/Entry" -->
		<!--xsl:for-each select="NICDriverVerInfo/NICList/NICCard" ///////////////////////////////////// -->
			<!-- ListData name="Network Driver Info">
				<xsl:attribute name="display"/>
				<Data name="Name">
					<xsl:attribute name="display"--><!--XLATESTART--><!-- Name --><!--XLATESTOP--><!-- /xsl:attribute -->
					<!--xsl:attribute name="value"><xsl:value-of select="Description"/></xsl:attribute ////////////////////////////////// -->
					<!--xsl:attribute name="value"><xsl:value-of select="@name"/></xsl:attribute>
				</Data>
				<Data name="Version">
					<xsl:attribute name="display"--><!--XLATESTART--><!--Version--><!--XLATESTOP--><!--/xsl:attribute-->
					<!--xsl:attribute name="value"><xsl:value-of select="DriverVersion"/></xsl:attribute ////////////////////////////////////////// -->
					<!--xsl:attribute name="value">Dell Version: <xsl:value-of select="@familyVersion"/>, OEM Version: <xsl:value-of select="@vendorVersion"/></xsl:attribute>
				</Data>
				<Data name="Update">
					<xsl:attribute name="display"--><!--XLATESTART--><!--Updateable--><!--XLATESTOP--><!--/xsl:attribute-->
					<!--xsl:if test="$updatable = '1'">
						<xsl:if test="$admin = '1'">
							<xsl:attribute name="value">Yes</xsl:attribute>
						</xsl:if>
						<xsl:if test="$admin != '1'">
							<xsl:attribute name="value">N/A</xsl:attribute>
						</xsl:if>
					</xsl:if>
					<xsl:if test="$updatable != '1'">
						<xsl:attribute name="value">N/A</xsl:attribute>
					</xsl:if>
				</Data>
			</ListData>
		</xsl:for-each>
	</xsl:template-->	
	<!-- AB for NIC Updates -->

	<xsl:template match="*"/>
</xsl:stylesheet>
