<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:strip-space elements="*"/>
	<xsl:output method="xml"/>
	  <xsl:variable name="IsBlade">
		<xsl:choose>
		  <xsl:when test="/OMA/Parent/ParentName/ChassisProps1/ChassType='25'">true</xsl:when>
		  <xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	  </xsl:variable>
	  <xsl:variable name="IsCLICmdNew">
		<xsl:choose>
		  <xsl:when test="/OMA/Parent/ParentName/OMACMDNEW='0'">false</xsl:when>
		  <xsl:otherwise>true</xsl:otherwise>
		</xsl:choose>
	  </xsl:variable>
	<xsl:template match="/OMA">
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><!--XLATESTART-->Health<!--XLATESTOP--></xsl:attribute>
			</PageTitle>
			<xsl:apply-templates select="Parent"/>
			<PromptText>
				<!--XLATESTART-->For further help, type the command followed by -?<!--XLATESTOP-->
			</PromptText>
		</DataArea>
	</xsl:template>
	<xsl:template match="Parent">
		<SubHeader>
      <xsl:choose>
        <xsl:when test="$IsBlade='true' and $IsCLICmdNew='true'">
          <xsl:attribute name="display">Main System</xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="display"><xsl:value-of select="ParentName/ChassisProps1/ChassName"/></xsl:attribute>
        </xsl:otherwise>
      </xsl:choose>
		</SubHeader>
		<ListData type="noheader" restoreformat="true">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->SEVERITY<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><!--XLATESTART-->COMPONENT<!--XLATESTOP--></xsl:attribute>
			</Data>
			<xsl:apply-templates select="acswitch"/>
			<xsl:apply-templates select="fans"/>
			<xsl:apply-templates select="intrusion"/>
			<xsl:apply-templates select="memory"/>
			<xsl:apply-templates select="network"/>
			<xsl:apply-templates select="powersupply"/>
      			<xsl:apply-templates select="currents"/>
			<xsl:apply-templates select="processor"/>
			<xsl:apply-templates select="temperatures"/>
			<xsl:apply-templates select="voltages"/>
			<xsl:apply-templates select="esmlog"/>
			<xsl:apply-templates select="batteries"/>
			<xsl:apply-templates select="sdcard"/>			
		</ListData>
	</xsl:template>
	<xsl:template match="network">
		<xsl:if test="ObjCount > '0'">
			<xsl:if test="SMStatus = '0'">
				<Data>
					<xsl:call-template name="Image">
						<xsl:with-param name="status">
							<xsl:value-of select="computedobjstatus"/>
						</xsl:with-param>
					</xsl:call-template>
					<xsl:attribute name="value"><!--XLATESTART-->Network<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="intrusion">
		<xsl:if test="ObjCount > '0'">
			<xsl:if test="SMStatus = '0'">
				<Data>
					<xsl:call-template name="Image">
						<xsl:with-param name="status">
							<xsl:value-of select="computedobjstatus"/>
						</xsl:with-param>
					</xsl:call-template>
					<xsl:attribute name="value"><!--XLATESTART-->Intrusion<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="voltages">
		<xsl:if test="ObjCount > '0'">
			<xsl:if test="SMStatus = '0'">
				<Data>
					<xsl:call-template name="Image">
						<xsl:with-param name="status">
							<xsl:value-of select="computedobjstatus"/>
						</xsl:with-param>
					</xsl:call-template>
					<xsl:attribute name="value"><!--XLATESTART-->Voltages<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="temperatures">
		<xsl:if test="ObjCount > '0'">
			<xsl:if test="SMStatus = '0'">
				<Data>
					<xsl:call-template name="Image">
						<xsl:with-param name="status">
							<xsl:value-of select="computedobjstatus"/>
						</xsl:with-param>
					</xsl:call-template>
					<xsl:attribute name="value"><!--XLATESTART-->Temperatures<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="batteries">
		<xsl:if test="ObjCount > '0'">
			<xsl:if test="SMStatus = '0'">
				<Data>
					<xsl:call-template name="Image">
						<xsl:with-param name="status">
							<xsl:value-of select="computedobjstatus"/>
						</xsl:with-param>
					</xsl:call-template>
					<xsl:attribute name="value"><!--XLATESTART-->Batteries<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<xsl:template match="sdcard">
		<xsl:if test="ObjCount > '0'">
		<xsl:if test="SMStatus = '0' and (Redundancy or count(SDCard[Type='3'])> 0)  ">				
				<Data>
					<xsl:call-template name="Image">
						<xsl:with-param name="status">
							<xsl:value-of select="computedobjstatus"/>
						</xsl:with-param>
					</xsl:call-template>
					<xsl:attribute name="value"><!--XLATESTART-->Removable Flash Media<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<xsl:template match="fans">
		<xsl:if test="ObjCount > '0'">
			<xsl:if test="SMStatus = '0'">
				<Data>
					<xsl:call-template name="Image">
						<xsl:with-param name="status">
							<xsl:value-of select="computedobjstatus"/>
						</xsl:with-param>
					</xsl:call-template>
					<xsl:attribute name="value"><!--XLATESTART-->Fans<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="acswitch">
		<xsl:if test="ObjCount > '0'">
			<xsl:if test="SMStatus = '0'">
				<Data>
					<xsl:call-template name="Image">
						<xsl:with-param name="status">
							<xsl:value-of select="computedobjstatus"/>
						</xsl:with-param>
					</xsl:call-template>
					<xsl:attribute name="value"><!--XLATESTART-->AC Switch<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="currents">
		<xsl:if test="ObjCount > '0'">
			<xsl:if test="SMStatus = '0'">
				<Data>
					<xsl:call-template name="Image">
						<xsl:with-param name="status">
							<xsl:value-of select="computedobjstatus"/>
						</xsl:with-param>
					</xsl:call-template>
					<xsl:attribute name="value"><!--XLATESTART-->Power Management<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="powersupply">
		<xsl:if test="ObjCount > '0'">
			<xsl:if test="SMStatus = '0'">
				<Data>
					<xsl:call-template name="Image">
						<xsl:with-param name="status">
							<xsl:value-of select="computedobjstatus"/>
						</xsl:with-param>
					</xsl:call-template>
					<xsl:attribute name="value"><!--XLATESTART-->Power Supplies<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
	</xsl:template>
  <xsl:template match="processor">
		<xsl:if test="ObjCount > '0'">
			<xsl:if test="SMStatus = '0'">
				<Data>
					<xsl:call-template name="Image">
						<xsl:with-param name="status">
							<xsl:value-of select="computedobjstatus"/>
						</xsl:with-param>
					</xsl:call-template>
					<xsl:attribute name="value"><!--XLATESTART-->Processors<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="memory">
		<xsl:if test="ObjCount > '0'">
			<xsl:if test="SMStatus = '0'">
				<Data>
					<xsl:call-template name="Image">
						<xsl:with-param name="status">
							<xsl:value-of select="computedobjstatus"/>
						</xsl:with-param>
					</xsl:call-template>
					<xsl:attribute name="value"><!--XLATESTART-->Memory<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="esmlog">
		<xsl:if test="ObjCount > '0'">
			<xsl:if test="SMStatus = '0'">
				<xsl:if test="computedobjstatus != '1'">
					<Data>
						<xsl:call-template name="Image">
							<xsl:with-param name="status">
								<xsl:value-of select="computedobjstatus"/>
							</xsl:with-param>
						</xsl:call-template>
						<xsl:attribute name="value"><!--XLATESTART-->Hardware Log<!--XLATESTOP--></xsl:attribute>
					</Data>
				</xsl:if>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Image">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status=1">
				<xsl:attribute name="display"><!--XLATESTART-->Unknown<!--XLATESTOP--></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status=2">
				<xsl:attribute name="display"><!--XLATESTART-->Ok<!--XLATESTOP--></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status=3">
				<xsl:attribute name="display"><!--XLATESTART-->Non-Critical<!--XLATESTOP--></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status=4">
				<xsl:attribute name="display"><!--XLATESTART-->Critical<!--XLATESTOP--></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status=5">
				<xsl:attribute name="display"><!--XLATESTART-->Critical<!--XLATESTOP--></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="display"><!--XLATESTART-->Unknown<!--XLATESTOP--></xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
