<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- the xsl included below contains messages for error codes-->
	<xsl:import href="smmsgs.xsl"/>
	<xsl:template match="OMA">
	    <xsl:variable name="StatusID">
		  <xsl:call-template name="GetStatusID">
			  <xsl:with-param name="StatusID" select="ErrorCode"/>
		  </xsl:call-template>
	    </xsl:variable>  

		<DataArea exportdata="false">
			<xsl:choose>
				<xsl:when test="WSManError != 0 and WSManError !='' and WSManError != 'null'">
					<xsl:attribute name="email">false</xsl:attribute>
					<xsl:attribute name="printable">false</xsl:attribute>

					<AlertMessage alert="false">
						<xsl:attribute name="display"><xsl:value-of select="$strActionPerformed"/><xsl:call-template name="GetMessage"><xsl:with-param name="ErrorID" select="ErrorCode"/><xsl:with-param name="WSManError" select="WSManError"/></xsl:call-template></xsl:attribute>
					</AlertMessage>

				</xsl:when>
				<xsl:otherwise>
				     <AlertMessage alert="true">
					    <xsl:choose>
					        <xsl:when test="contains(normalize-space($StatusID) , '3')">
					   	        <xsl:attribute name="display"><xsl:value-of select="$strTitle1"/></xsl:attribute>
						    </xsl:when>
							<xsl:otherwise>
							     <xsl:attribute name="display"><xsl:call-template name="GetMessage"><xsl:with-param name="ErrorID" select="ErrorCode"/><xsl:with-param name="WSManError" select="WSManError"/></xsl:call-template></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:attribute name="status">
						   <xsl:choose>
						      <!-- sev(1)  means 'ok' and sev(2) means 'non-critical' and sev(3) means 'critical'-->
						      <xsl:when test="contains(normalize-space($StatusID) , '1')">2</xsl:when>
							  <xsl:when test="contains(normalize-space($StatusID) , '2')">3</xsl:when>
							  <xsl:when test="contains(normalize-space($StatusID) , '3')">4</xsl:when>
							  <xsl:otherwise>4</xsl:otherwise>
						   </xsl:choose>
						</xsl:attribute>
				  	</AlertMessage>
					 <xsl:choose>
					<xsl:when test="contains(normalize-space($StatusID) , '3')">
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle2"/><xsl:call-template name="GetMessage"><xsl:with-param name="ErrorID" select="ErrorCode"/><xsl:with-param name="WSManError" select="WSManError"/></xsl:call-template></xsl:attribute>
					</SubHeader>
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strWhy"/></xsl:attribute>
					</SubHeader>
					<ListData>
						<Data>
							<xsl:attribute name="display">-</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strWhy1"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display">-</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strWhy2"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display">-</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strWhy3"/></xsl:attribute>
						</Data>
					</ListData>
				   </xsl:when>
                  </xsl:choose>				   
				</xsl:otherwise>
			</xsl:choose>

			<BottomCustomButton>
				<Data>
					<xsl:choose>
						<xsl:when test="BackTo != 'null'">
					               <xsl:attribute name="href"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin&amp;help=adprin</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="display"><xsl:value-of select="$strExitWizard"/></xsl:attribute>
				</Data>
			</BottomCustomButton>
		</DataArea>
	</xsl:template>
<xsl:template name="ReturnPage">
          <xsl:param name="defaultBackPage">./DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin&amp;help=stprhl</xsl:param>
          <xsl:param name="BackTo">
          </xsl:param>
          <xsl:choose>
            <xsl:when test="BackTo and BackTo='/'"><xsl:value-of select="$defaultBackPage"/></xsl:when>
            <xsl:when test="BackTo and BackTo!=''"><xsl:value-of select="translate($BackTo,'!','&amp;')"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$defaultBackPage"/></xsl:otherwise>
          </xsl:choose>
        </xsl:template>

</xsl:stylesheet>
