<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to prompt the user for confirmation of a reset configuration for a controller.  The associated web plugin is the ConfirmResetConfWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="vdtbl.xsl"/>
	<xsl:import href="Utils.xsl"/>
	<xsl:template match="OMA">
		<xsl:variable name="VDCount">
			<xsl:value-of select="count(VirtualDisks/DCStorageObject)"/>
		</xsl:variable>

		<!-- check if controller has VDs with boot partitions-->
		<xsl:variable name="NumBootPart">
			<xsl:value-of select="count(VirtualDisks/DCStorageObject/NumBootPart)"/>
		</xsl:variable>

		<!-- Create a variable to set the appropriate reset config action.  This is used when setting the submit 		button href on the DataArea tag -->
		<xsl:variable name="ResetConfAction">
			<xsl:choose>
				<xsl:when test="$NumBootPart>0">resetconfforce</xsl:when>
				<xsl:otherwise>resetconf</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<DataArea  email="true" validate="true">

		<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;VDiskOID=<xsl:value-of select="VDiskOID"/>&amp;VDiskName=<xsl:value-of select="VDiskName"/>&amp;Action=<xsl:value-of select="$ResetConfAction"/>&amp;help=cnprin";</xsl:attribute>
		<xsl:attribute name="submitdisplay"><xsl:value-of select="$strResetConfigButton"/></xsl:attribute>


		<!-- check to see if blink is an option and show blink button accordingly <xsl:if test="substring(//MasterMethodMask,24,1)!='0'">1</xsl:if>-->
		<xsl:variable name="blink">
			<xsl:call-template name="CanVDBlink">
				<xsl:with-param name="Mask">
					<xsl:value-of select="//MasterMethodMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="$blink=1">
			<!-- We needed the ability to disable (hide) the bottom buttons when a user executes an action (DFCT117103) -->
			<!-- but we currently only have the ability to hide the submit, cancel, and back buttons.  Since this page only -->
			<!-- uses the cancel and submit buttons, I’ve changed the <BottomCustomButton> for Blink to be a cancel -->
			<!-- button as a way to hide it when the user selects submit.  This will need to change when the framework allows -->
			<!-- other buttons to be disabled.   - Michael Regert, 06/15/04 -->
			<xsl:attribute name="cancel">true</xsl:attribute>
			<xsl:attribute name="canceldisplay"><xsl:value-of select="$strBlinkButton"/></xsl:attribute>
			<xsl:attribute name="canceltarget">javascript:callBlinkforVDs()</xsl:attribute>
		</xsl:if>



		<xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
			<xsl:attribute name="backpagetarget"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>


			<xsl:choose>
				<xsl:when test="$NumBootPart>0">
					<AlertMessage alert="true" status="3">
						<xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="/*/VirtualDisks/@ControllerName"/><xsl:value-of select="$strTitlePart3"/></xsl:attribute>
					</AlertMessage>
				</xsl:when>
				<xsl:otherwise>
					<AlertMessage alert="true" status="3">
						<xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="/*/VirtualDisks/@ControllerName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
					</AlertMessage>
				</xsl:otherwise>
			</xsl:choose>
			
			<AlertMessage status="3">
				<xsl:attribute name="display"><xsl:value-of select="$strSubHeader"/></xsl:attribute>
			</AlertMessage>
			<TableData columnspacing="true" name="T1" display="Virtual Disks">
				<xsl:variable name="showtasks">false</xsl:variable>
				<PromptText><xsl:value-of select="$strExplText1"/></PromptText>
				<!--SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strTableSubHeader1"/></xsl:attribute>
				</SubHeader-->
				<AlertMessage>
			     	<xsl:attribute name="display"><xsl:value-of select="$strTableSubHeader1"/></xsl:attribute>
			    </AlertMessage>
				<xsl:choose>
					<xsl:when test="count(VirtualDisks/DCStorageObject)>0">
						<Header>
							<xsl:call-template name="VirtualDiskTableHeader">
								<xsl:with-param name="tasks" select="$showtasks"/>
							</xsl:call-template>
						</Header>
						<xsl:for-each select="VirtualDisks/DCStorageObject">
							<xsl:call-template name="VirtualDiskTableRows">
								<xsl:with-param name="tasks" select="$showtasks"/>
								<xsl:with-param name="caller">./DataArea?plugin=com.dell.sm.webplugins.ConfirmResetConfWebPlugin!ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>!ControllerName=<xsl:value-of select="/OMA/ControllerName"/>!help=cntkrset!</xsl:with-param>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<!--Row>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strTableSubHeader2"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strTableSubHeader2"/></xsl:attribute>
							</Data>
						</Row-->
						<AlertMessage>
						   <xsl:attribute name="display"><xsl:value-of select="$strTableSubHeader2"/></xsl:attribute>
						</AlertMessage>
					</xsl:otherwise>
				</xsl:choose>
			</TableData>
			<HiddenTable>
				<xsl:call-template name="ObjIDHiddenTable"/>
			</HiddenTable>
                 <CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">javascript:reloadPage()</xsl:attribute>
					
				</Data>
			</CustomButton>

			<!-- check to see if blink is an option and show blink button accordingly <xsl:if test="substring(//MasterMethodMask,24,1)!='0'">1</xsl:if>-->
			<!--xsl:variable name="blink">
				<xsl:call-template name="CanVDBlink">
					<xsl:with-param name="Mask">
						<xsl:value-of select="//MasterMethodMask"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="$blink=1">
				<BottomCustomButton>
					<Data display="{$strBlinkButton}" formSubmit="true" href="javascript:callBlinkforVDs()"/>
				</BottomCustomButton>
			</xsl:if-->

			<script language="javascript">
                   function reloadPage()
      			{
          			document.location.href = top.gnv.appendVID(document.URL+"&amp;Refresh=true");
      			}

			function callBlinkforVDs() {
				var count = <xsl:value-of select="$VDCount"/>;
				var index;
				var objID;
				var vdlist="";
				for (index=0; index &lt; count; index++) 
                        {
                            objID = document.getElementById("OBJOID"+(index+1)).value;
                            vdlist = vdlist + objID + ":";
                        }
                        document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.VDBlinkBeforeResetWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=" + vdlist + "&amp;VDiskName=" + name + "&amp;vdcount=" + count + "&amp;Action=blinkvd" + "&amp;help=cntkrset&amp;Refresh=true");
			}

			function validate()
			{
					var delmsg = "<xsl:value-of select="$strRUSure"/>";

					var cfrm = confirm(delmsg);

					if(cfrm)
					{
						var canBlink = <xsl:value-of select="$blink"/>;
						if(canBlink == 1)
						{
							disableButtons("submit","back" ,"cancel");
						}
						else
						{
							disableButtons("submit","back" ,"");
						}
					}
					return (cfrm);
			}

		</script>
		</DataArea>
	</xsl:template>
	<xsl:template name="ObjIDHiddenTable">
		<xsl:for-each select="VirtualDisks/DCStorageObject">
			<Data>
				<xsl:attribute name="name">OBJOID<xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="returnvalue"><xsl:value-of select="Nexus"/></xsl:attribute>
			</Data>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
