<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render replace member summary page for copyback feature. The associated web plugin is ReplaceMemberSummaryWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc which can be resused/-->
	<xsl:include href="Utils.xsl"/>

	<xsl:variable name="PARAM_PREV_VDNAME"><xsl:value-of select="/OMA/VDiskName"/></xsl:variable>
	<xsl:variable name="PARAM_SOURCE_DISK"><xsl:value-of select="/OMA/SourceDiskOID"/></xsl:variable>
	<xsl:variable name="PARAM_DESTINATION_DISK"><xsl:value-of select="/OMA/DestinationDiskOID"/></xsl:variable>
	<!-- Get channel OID from destination disk ID -->
	<xsl:variable name="DestinationCOID">
		<xsl:call-template name="GetChannelOrEnclosureOID">
			<xsl:with-param name="diskOID" select="/OMA/DestinationDiskOID"/>
			<xsl:with-param name="IsEnclosure">false</xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<!-- Get enclosure OID from destination disk ID -->
	<xsl:variable name="DestinationEOIDForEnc">
		<xsl:call-template name="GetChannelOrEnclosureOID">
			<xsl:with-param name="diskOID" select="/OMA/DestinationDiskOID"/>
			<xsl:with-param name="IsEnclosure">true</xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<!-- Put enclosure OID as blank if it does not have an enclosure -->
	<xsl:variable name="DestinationEOID">
		<xsl:choose>
			<xsl:when test="$DestinationCOID != $DestinationEOIDForEnc">
				<xsl:value-of select="$DestinationEOIDForEnc"/>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

  <!-- Main template -->
  <xsl:template match="OMA">
		<DataArea onLoad="false" validate="false" exportdata="false" email="false" printable="false" ignoreJumpBar="true">
				<xsl:attribute name="cancel">true</xsl:attribute>
				<xsl:attribute name="canceltarget">./DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;HREF=<xsl:value-of select="HREF"/>&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;help=vdprin</xsl:attribute>
				<xsl:attribute name="canceldisplay"><xsl:value-of select="$strCancelRMSummary"/></xsl:attribute>
				<xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strBackPageButton"/></xsl:attribute>
				<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.sm.webplugins.ReplaceMemberSelectWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=<xsl:value-of select="/OMA/VDiskOID"/>&amp;VDiskName=<xsl:value-of select="$PARAM_PREV_VDNAME"/>&amp;SourceDiskOID=<xsl:value-of select="$PARAM_SOURCE_DISK"/>&amp;DestinationDiskOID=<xsl:value-of select="$PARAM_DESTINATION_DISK"/>&amp;help=vdtkrep1</xsl:attribute>
				<xsl:attribute name="submitdisplay"><xsl:value-of select="$strFinishRMSummary"/></xsl:attribute>
				<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.sm.webplugins.SubmitReplaceMemberWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=<xsl:value-of select="/OMA/VDiskOID"/>&amp;VDiskName=<xsl:value-of select="$PARAM_PREV_VDNAME"/>&amp;SourceDiskOID=<xsl:value-of select="$PARAM_SOURCE_DISK"/>&amp;DestinationDiskOID=<xsl:value-of select="$PARAM_DESTINATION_DISK"/>&amp;ChannelOID=<xsl:value-of select="$DestinationCOID"/>&amp;EnclosureOID=<xsl:value-of select="$DestinationEOID"/>&amp;help=adprin</xsl:attribute>

			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitleRMSummary"/><xsl:value-of select="$PARAM_PREV_VDNAME"/><xsl:value-of select="$strTitleEndRMSummary"/></xsl:attribute>
			</PageTitle>

            <!-- Table to display selected Virtual disk properties -->
			<TableData name="T1" display="{$strVDAttribsRMSummary}">
				<SubHeader><xsl:attribute name="display"><xsl:value-of select="$strPromptTextVDAttribsRMSummary"/></xsl:attribute></SubHeader>
				<Header><Data value="{$strAttributeRMSummary}" width="400"/><Data value="{$strValueRMSummary}"/></Header>
				<Row>
					<Data value="{$strTypeRMSummary}" name="RaidLevel"/>
					<Data name="RaidLevelValue">
						<xsl:attribute name="value">
							<!--The Template in Utils.xsl is called below/-->
							<xsl:call-template name="GetRaidLayout">
								<xsl:with-param name="RaidType">
									<xsl:value-of select="VirtualDisks/DCStorageObject/Layout"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</Data>
				</Row>

				<Row>
					<Data value="{$strSizeRMSummary}" name="Size"/>
					<Data name="SizeValue"><xsl:attribute name="value"><xsl:value-of select="format-number((VirtualDisks/DCStorageObject/Length div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute></Data>
				</Row>

				<Row>
					<Data value="{$strType}" name="Protocol"/>
					<Data name="ProtocolValue">
						<xsl:attribute name="value">
							<!--The Template in Utils.xsl is called below/-->
							<xsl:call-template name="GetBusProtocol">
								<xsl:with-param name="Bus">
									<xsl:value-of select="VirtualDisks/DCStorageObject/BusProtocol"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</Data>
				</Row>

				<Row>
					<Data value="{$strNameRMSummary}" name="Name"/>
					<Data name="NameValue"><xsl:attribute name="value"><xsl:value-of select="VirtualDisks/DCStorageObject/Name"/></xsl:attribute></Data>
				</Row>
			</TableData>

                       <!-- Table to display selected source disk properties -->
                       <TableData name="T2" display="{$strArrayDisksRMSummary}">
				<SubHeader><xsl:attribute name="display"><xsl:value-of select="$strPromptTextDiskSelSource"/></xsl:attribute></SubHeader>
				<Header><Data value="{$strArrayDiskRMSummary}" width="400"/><Data value="{$strFreeSpaceRMSummary}" /></Header>
				<xsl:apply-templates select="SourceDisk/ArrayDisks/DCStorageObject"/>
			</TableData>

                        <!-- Table to display selected destination disk properties -->
                        <TableData name="T3" display="{$strArrayDisksRMSummary}">
				<SubHeader><xsl:attribute name="display"><xsl:value-of select="$strPromptTextDiskSelDestination"/></xsl:attribute></SubHeader>
				<Header><Data value="{$strArrayDiskRMSummary}" width="400"/><Data value="{$strFreeSpaceRMSummary}" /></Header>
				<xsl:apply-templates select="DestinationDisk/ArrayDisks/DCStorageObject"/>
			</TableData>

		</DataArea>
	</xsl:template>

        <!-- Generic template which actually displays values for both source and destination disks -->
	<xsl:template match="DCStorageObject">
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="AdiskTitle">
			<xsl:choose>
				<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
					<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<Row>
			<Data>
				<xsl:attribute name="name">Adisk<xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$AdiskTitle"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="name">AdiskFreeSpace<xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="format-number((Length div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>

	<!-- Template that fetches Channel or Enclosure OID based on a disk OID -->
	<xsl:template name="GetChannelOrEnclosureOID">
		<xsl:param name="diskOID"/>
		<xsl:param name="IsEnclosure"/>
		<xsl:param name="count" select="0"/>
		<xsl:if test="contains($diskOID, '.') and (($IsEnclosure ='false' and $count != 3) or ($IsEnclosure ='true' and $count != 4))">
			<xsl:variable name="val"><xsl:value-of select="substring-before($diskOID, '.')"/></xsl:variable>
			<xsl:if test="$val !=''">
				<xsl:text>.</xsl:text><xsl:value-of select="$val"/>
			</xsl:if>
			
			<xsl:call-template name="GetChannelOrEnclosureOID">
				<xsl:with-param name="diskOID" select="substring-after($diskOID, '.')"/>
				<xsl:with-param name="IsEnclosure" select="$IsEnclosure"/>
				<xsl:with-param name="count" select="$count+1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
