<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc which can be reused/-->
	<xsl:include href="Utils.xsl"/>
	<xsl:include href="cvdutils.xsl"/>
	<!-- In case of VDOCE there will be only one DCStorageObject under SSDAResponse -->
	<xsl:variable name="VDOCEPossible" select="/OMA/SSDAResponse/DCStorageObject/IsVDOCEPossible"/>
	<xsl:variable name="VDHSSize" select="/OMA/SSDAResponse/DCStorageObject/SSHotspareSize"/>
	<xsl:variable name="VDColumnCount" select="/OMA/SSDAResponse/DCStorageObject/SSColumnCount"/>
	<xsl:variable name="VDLayout" select="/OMA/SSDAResponse/DCStorageObject/Layout"/>
	
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="/OMA/SSDAResponse/DCStorageObject">
				<!-- Check that DA didn't return an empty set -->
				<xsl:call-template name="RenderMainFrame"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="RenderErrorFrame"/>
			</xsl:otherwise>			
		</xsl:choose>

	</xsl:template>


	<xsl:template name="RenderErrorFrame">
		<!--Error page -->
		<DataArea validate="false" Refresh="false">
		
			<AlertMessage alert="true" status="4">
				<xsl:attribute name="display"><xsl:value-of select="//VirtualDisks/DCStorageObject/Name"/> <xsl:value-of select="$strReconfigureErr"/> </xsl:attribute>
			</AlertMessage>
			<PromptText>
					<xsl:value-of select="$strNoReconfig"/>
			</PromptText>
			<ListData>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strReason1"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strReason2"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strReason3"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strReason4"/></xsl:attribute>
				</Data>
			</ListData>
			
			<BottomCustomButton>
					<Data>
						<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.ReconfigureVDWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;VDiskName=<xsl:value-of select="//VDiskName"/>&amp;VDeviceName=<xsl:value-of select="DeviceName"/>&amp;help=vdtkrcn1
						</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strBack"/></xsl:attribute>
				</Data>
			</BottomCustomButton>

			<BottomCustomButton>
				<Data>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;Action=blank&amp;help=vdprin</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strExitWizard"/></xsl:attribute>
				</Data>
			</BottomCustomButton>
		</DataArea>
	</xsl:template>
	
	
	<xsl:template name="RenderMainFrame">
		<!-- Page 2 of Reconfig -->
			<DataArea onLoad="true" validate="true" exportdata="false" printable="false" email="false">
			<xsl:attribute name="submit">javascript:submitReconfigureVD()</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strContinue"/></xsl:attribute>
			<xsl:variable name="GLOBAL_PARAM_Oslimit"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxOsLimitForLogicalDriveSize"/></xsl:variable>
			<script language="javascript">
				<xsl:call-template name="getCommonScripts"/>
				<xsl:call-template name="getScriptsForAdvanced"/>
			</script>
			<script language="javascript">
				var isVDOCEPossible = "<xsl:value-of select="$VDOCEPossible"/>";
				var vdlayout = "<xsl:value-of select="$VDLayout"/>";
				var vdOriginalSize = "<xsl:value-of select="//VirtualDisks/DCStorageObject/Length"/>";
				var vdHotspareSize = "<xsl:value-of select="$VDHSSize"/>";
				var vdColumnCount = "<xsl:value-of select="$VDColumnCount"/>";
                                
				function initializationRoutine()
				{
					if (isVDOCEPossible == 1)
					{
						setInputRaidLayoutValue(vdlayout);
						
					}
					else
					{       disableInputVDSizeField(); 
					        setValueForMinField("");
					        setValueForMaxField("");
				       }
                               OnRaidLayoutSelected();

				}
				function submitReconfigureVD()
				{
					var layout=Reconfig_getInputRaidLayoutValue();										
					var size = "";

					if (isVDOCEPossible == 1)
					{
						var maxSizeInBytes = getMaxSizeForGivenLayout(layout,"BYTES");
						var sizeInPercentageValue = getInputVDSizeValue();
						var sizeVal = parseInt(sizeInPercentageValue * (maxSizeInBytes / 100));
						size = (sizeVal + parseInt(vdOriginalSize));

					}
					else
					{
						size = ConvertInputSizeToBytesForExpress(layout);
					}
										
					var userInputSize = ConvertInputSizeToBytes();
					var sizeCalc = parseInt (userInputSize / vdColumnCount);

					if (sizeCalc &gt;  vdHotspareSize)
					{
						if (confirm ("<xsl:value-of select="$strSWRAIDDHSWarning"/>") == false)
						{
							return;
						}
					}
										
					var IDList = "<xsl:value-of select="/OMA/IDList"/>";
          				document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.ReconfigureVDSummaryWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;Layout="+layout+"&amp;Length="+size+"&amp;IDList="+IDList+"&amp;VDOCEPossible="+isVDOCEPossible+"&amp;PercentageValue="+sizeInPercentageValue+"&amp;help=vdtkrcn3");
				}

				function setValueForMaxFieldVDOCE(maxValue)
				{
					document.getElementById("Max").innerHTML = "<xsl:value-of select="$strMaxSizeLabelCVDUVDOCE"/>"+getFormattedStringForMinMaxFields(maxValue)+" <xsl:value-of select="$strGBUnitCVDU"/>";
				}
                        
                        function Reconfig_getInputRaidLayoutValue()
				{
					var elemName = getElementNameForRaidLayout();
					var SelectBox=document.getElementById(elemName);
					if(SelectBox)
					{
						return(SelectBox.value);
					}
					return -1;
				}

				function OnRaidLayoutSelected()
				{
					var layoutValue = Reconfig_getInputRaidLayoutValue();
					
					//UpdateRaidDescriptionTextBox(layoutValue);
					
					<!--get min and max values in GB-->
					var minValue = getMinSizeForGivenLayout(layoutValue,"GB");
					var maxValue = getMaxSizeForGivenLayout(layoutValue,"GB");
                              
					if (isVDOCEPossible != 1)
					{
					        <!--Set user input VD size field to max value-->
					        setInputVDSizeValue(maxValue);
					}

					if ( getMinSizeForGivenLayout(layoutValue,"BYTES") == getMaxSizeForGivenLayout(layoutValue,"BYTES"))
					{
						if (isVDOCEPossible != 1)
						{
							setValueForMinField(maxValue);
							setValueForMaxField(maxValue);
						}
						else
						{
							setValueForMaxFieldVDOCE(maxValue);
						}
						disableInputVDSizeField();
					}
					else
					{
						if (isVDOCEPossible != 1)
						{
							setValueForMinField(minValue);
							setValueForMaxField(maxValue);
						}
						else
						{
							setValueForMaxFieldVDOCE(maxValue);
						}
						enableInputVDSizeField();
					}
				}
				function ConvertInputSizeToBytes()
				{
					var layoutValue=Reconfig_getInputRaidLayoutValue();
					var maxSizeInBytes = getMaxSizeForGivenLayout(layoutValue,"BYTES");
					var maxSize = getMaxSizeForGivenLayout(layoutValue,"GB");
					var sizeValue = getInputVDSizeValue();
					if( (maxSize-sizeValue) &lt;= 0.01)
					{
						sizeValue=maxSizeInBytes;
					}
					else
					{
						sizeValue=parseInt(sizeValue*1024*1024*1024);
					}
					return sizeValue;
				}

				function validate()
				{
					if(IsRaidLayoutSelected()==false)
					{
						HandleRaidLayoutNotSelectedError();
						return false;
					}

					if(IsInputSizeForVDSpecified()==false)
					{
						HandleInputSizeNotSpecifiedError();
						return false;
					}

					if(IsInputSizeForVDNaN()==true)
					{
						if (isVDOCEPossible == 1)
						{
							HandleInputSizeNotANumberErrorForReconfig(true);
						}
						else
						{
							HandleInputSizeNotANumberErrorForReconfig(false);

						}
						return false;
					}


					if (isVDOCEPossible == 1)
					{
						if(IsInputSizeForVDWithinPercentageRange()== false)
						{	
							return false;
						}
					}
					else
					{
					        if(IsInputSizeForVDWithinRange()==false)
					        {	
						       HandleInputSizeRangeErrorForExpress();
						       return false;
					        }
					        if ( HandleInputSizeGreaterThanOsLimit() == false )
					        {
						       return false;
					        }
					}
					return true;
				}

				function HandleInputSizeGreaterThanOsLimit()
				{
					
					var sizeValue = getElementNameForVDSize();
					var osLimitValueinGB = "<xsl:value-of select="format-number($GLOBAL_PARAM_Oslimit div (1024*1024*1024), '###0.00')"/>";
					var sizeValueDecFormat = parseFloat(document.getElementById(sizeValue).value);
					var osLimitValueDecFormat = parseFloat(ConvertToDecValString(osLimitValueinGB));

					if ( sizeValueDecFormat &gt; osLimitValueDecFormat)
					{
						<!-- This means that the virtual disk size is greater than the os limit-->
						if (confirm ("<xsl:value-of select="$strOsLimitWarn"/>"))
						{
							return true;
						}
						else
						{
							return false;
						}
					}
					else
					{
						return true; 
					}
					return true;
				}
				function IsInputSizeForVDWithinRange()
				{
					<!-- get selected raid layout value-->
					var layoutValue=Reconfig_getInputRaidLayoutValue();
					<!--get max size for selected raid layout in GB-->
					var minSize = getMinSizeForGivenLayout(layoutValue,"GB");
					var maxSize = getMaxSizeForGivenLayout(layoutValue,"GB");
					
					if( getMinSizeForGivenLayout(layoutValue,"BYTES") == getMaxSizeForGivenLayout(layoutValue,"BYTES"))					{
						minSize = maxSize;
					}
					<!--get input size value in GB-->
					var elemNameForSizeValue = getElementNameForVDSize();
					var sizeValue = parseFloat(document.getElementById(elemNameForSizeValue ).value);
					<!--Do a range check-->
					if( sizeValue &lt; minSize || sizeValue &gt; maxSize)
					{
						return false;
					}
					return true;
				}

				function IsInputSizeForVDWithinPercentageRange()
				{
					var elemNameForSizeValue = getElementNameForVDSize();
					var sizeValue = document.getElementById(elemNameForSizeValue).value;

                        	        // check that this isn't zero.
                          	        if (sizeValue !== null &amp;&amp; sizeValue.length &lt; 1)
			       	        {
						alert("<xsl:value-of select="$strError"/> <xsl:value-of select="$strPercentageValidRange"/>");
                                                return false;
			       	        }
			
			  		if(/^[0-9]*$/.test(sizeValue))
			      	        {  //make sure it's a number you are dealing with	
						if (sizeValue &gt; 100 || 1 &gt; sizeValue || sizeValue.indexOf('.') != -1)
				  		{  	//make sure the # is not greater than 100 or less than 1
							alert("<xsl:value-of select="$strError"/> <xsl:value-of select="$strPercentageValidRange"/>");
							return false;
				    		} 
				  		else 
				    		{
	              				return true;
				    		}
			      	        } 
			      	        else 
			      	        {
						alert("<xsl:value-of select="$strError"/> <xsl:value-of select="$strPercentageValidRange"/>");
						return false;
			      	        }
				}

			</script>
			
			
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strReconfigure"/><xsl:value-of select="//VirtualDisks/DCStorageObject/Name"/> <xsl:value-of select="$strStep2"/></xsl:attribute>
			</PageTitle>
			
			<CustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.ReconfigureVDSizeWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;Rules=<xsl:value-of select="/OMA/Rules"/>&amp;IDList=<xsl:value-of select="/OMA/IDList"/>&amp;help=vdtkrcn2</xsl:attribute>
				</Data>
			</CustomButton>
			<BottomCustomButton>
				<Data>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;Action=blank&amp;help=vdprin</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strExitWizard"/></xsl:attribute>
				</Data>
			</BottomCustomButton>
			<TableData>
				<Header>
					<Data align="left" noborderright="true" width="50%" spans="1">
						<xsl:attribute name="value"><xsl:value-of select="$strSelectAttributes"/></xsl:attribute>
					</Data>
					<Data noborderright="true" spans="1"></Data>
					
				</Header>
				<Row>
					<Data width="50%" spans="1">
						<xsl:attribute name="value"><xsl:value-of select="$strTypeCVDU"/></xsl:attribute>
					</Data>
				        <Data type="select" handler="OnRaidLayoutSelected()" event="onchange" name="VDLayout" width="50%" align="left" noborderright="true" spans="1">
                                                   <xsl:if test="$VDOCEPossible != 1">
                                                     <Choice default="true">
                                                                     <xsl:attribute name="value"><xsl:value-of select="$strSelectRAID"/></xsl:attribute>
                                                                     <xsl:attribute name="returnvalue">-1</xsl:attribute>
                                                     </Choice>
                                                    </xsl:if>
                                                    <xsl:for-each select="//SSDAResponse/DCStorageObject">    
                                                           <Choice>
                                                               <xsl:attribute name="value"><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType"><xsl:value-of select="Layout"/></xsl:with-param></xsl:call-template></xsl:attribute>
                                                               <xsl:attribute name="returnvalue"><xsl:value-of select="Layout"/></xsl:attribute>
                                                            </Choice>
                                                     </xsl:for-each>
                                       </Data>
                                </Row>
				<xsl:choose>
					<xsl:when test="$VDOCEPossible = 1">
						<Row>
							<Data width="50%" spans="1">
								<xsl:attribute name="value"><xsl:value-of select="$strSizePercentage"/></xsl:attribute>
							</Data>
							<Data name="VDSize" type="editbox" maxlength="7" width="50%" spans="1">
								<xsl:attribute name="unit"><xsl:value-of select="$strPercSymbol"/></xsl:attribute>
							</Data>
							<!-- Empty data to equalize rows -->
							
						</Row>
						<Row>
							<Data name="Max" value="Maximum Size: 0000.00 GB" width="50%" spans="1"/>
							<Data width="50%" spans="1"/>
							<!-- Empty data to equalize rows -->
							
						</Row>
					</xsl:when>
					<xsl:otherwise>
				               <Row>
					               <Data width="50%" spans="1">
						             <xsl:attribute name="value"><xsl:value-of select="$strSize"/></xsl:attribute>
					               </Data>
					               <Data name="VDSize" type="editbox" maxlength="7" width="50%" spans="1">
						             <xsl:attribute name="unit"><xsl:value-of select="$strGB"/></xsl:attribute>
					               </Data>
					               <!-- Empty data to equalize rows -->
					              
				               </Row>
				               <Row>
					               <Data name="Min" value="Minimum Size: 0000.00 GB" width="50%" spans="1"/>
					               <Data name="Max" value="Maximum Size: 0000.00 GB" width="50%" spans="1"/>
					               <!-- Empty data to equalize rows -->
					               
				               </Row>
					</xsl:otherwise>
				</xsl:choose>
			</TableData>
			<HiddenTable>
				<xsl:for-each select="//SSDAResponse/DCStorageObject">
						<xsl:call-template name="getMaxSizeInBytesForGivenLayoutType_HIDDEN_TABLE"/>
						<xsl:call-template name="getMinSizeInBytesForGivenLayoutType_HIDDEN_TABLE"/>
						<xsl:call-template name="getMaxSizeInGBForGivenLayoutType_HIDDEN_TABLE"/>
						<xsl:call-template name="getMinSizeInGBForGivenLayoutType_HIDDEN_TABLE"/>
				</xsl:for-each>
			</HiddenTable>
		</DataArea>
	</xsl:template>
</xsl:stylesheet>

