<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--xsl:output method="xml"/>
	<xsl:strip-space elements="*"/-->
	<xsl:include href="Utils.xsl"/>
	<xsl:variable name="varReportType"><xsl:value-of select="/OMA/ReportType"/></xsl:variable>
	<xsl:variable name="ctrlSASAddress"><xsl:value-of select="/OMA/SASAddress"/></xsl:variable>

	<xsl:template match="OMA">
		<xsl:variable name="varSortKey"><xsl:value-of select="SortKey"/></xsl:variable>
		<xsl:variable name="varOrder"><xsl:value-of select="Order"/></xsl:variable>
		<xsl:variable name="varDataType"><xsl:value-of select="DataType"/></xsl:variable>
		<xsl:variable name="logCount"><xsl:value-of select="count(//LogEntry[SASAddress = $ctrlSASAddress])"/></xsl:variable>

		<DataArea onLoad="true">
			<xsl:if test="$logCount = 0">
				<xsl:attribute name="exportdata">false</xsl:attribute>
				<xsl:attribute name="email">false</xsl:attribute>
				<xsl:attribute name="printable">false</xsl:attribute>
			</xsl:if>

			<script language="javascript" src="/oma/js/IPSup.js"/>
			<script language="javascript">
				function clearLog()
				{
					document.dataarea.action=top.gnv.appendVID(&apos;./SubmitForm?plugin=com.dell.sm.webplugins.ClearReportWebPlugin&amp;ReportType=<xsl:value-of select="$varReportType"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&apos;);
					if(confirm(&apos;<xsl:value-of select="$strAreYouSure"/>&apos;))
					{
                              	document.dataarea.submit();
					}
				}
        
				function initializationRoutine()
				{
					/*var reportType = '<xsl:value-of select="$varReportType"/>';
					var count = '<xsl:value-of select="$logCount"/>';

					if (document.getElementById(&quot;prompttext&quot;) != null)
					{
						if (reportType == '2' &amp;&amp; count &gt; 0)
						{
							document.getElementById(&quot;prompttext&quot;).innerHTML= &quot;<xsl:value-of select="$strPatrolReadContains"/>&quot;;
						}
						else if (reportType == '4' &amp;&amp; count &gt; 0)
						{
							document.getElementById(&quot;prompttext&quot;).innerHTML= &quot;<xsl:value-of select="$strCheckConsistencyContains"/>&quot;;
						}
						
					}*/
				}

				function saveLog()
				{
					document.dataarea.action=top.gnv.appendVID(&apos;./SubmitForm?plugin=com.dell.oma.webplugins.SaveLogWebPlugin&apos;);
			
					// DFCT93265, Clicking on the &quot;Save As&quot; button second time and performing either save or cancel, resulted an Abend on all flavous of Netware.
                              // The following single line has been added for fixing the problem.
		
					document.getElementById(&quot;pageCode&quot;).value = &quot;&quot;;
					
					document.getElementById(&quot;pageCode&quot;).value = document.getElementsByTagName(&quot;HTML&quot;)[0].innerHTML;
					document.dataarea.submit();
				}
				
                		function showEventHint(eventHintFile)
                		{
                    		if (checkModal () == false)
                    		{
                        		var detailWin; 
                        		var hostURL;
                       	 		var hosname;
                        		var hostport;
                       
                       			hostname=location.hostname;
                       			hostport=location.port;
                       			if(IsIPv6(hostname)==true)
						{
                                   		eventHintFile = "https://[" + hostname + "]:"+hostport+"/" + eventHintFile;
						}
                         		else
						{        
	                        		eventHintFile = "https://" + location.host + "/" + eventHintFile; 
						}  	                      
                        		detailWin = window.open(eventHintFile, 0, config='height=450,width=630,scrollbars=yes,toolbar=no,menubar=no,resizable=yes,location=no,directories=no,status=no');

                        		// this brings the window to the front.
                        		detailWin.focus();
                    		}
                		}
                
                		function checkModal()
                		{
	                		var modal = false;

	                		try
	                		{
		               		modal = window.top.body.frames["ct"].g_bModal;
	                		}
	                		catch(e)
	                		{
		                		try 
		                		{
			                		modal = window.top.body.g_bModal;
		                		}	
		                		catch(e) 
		                		{

		                		}
	                		}
	                		return modal;
                		}
			</script>

			<Header><xsl:value-of select="$strPageHeader"/></Header>
			<PageTitle>
				<xsl:attribute name="display">
                        	<xsl:choose>
                              	<xsl:when test="$varReportType = '2'"><xsl:value-of select="$strPatrolReadReportPart1"/><xsl:value-of select="ControllerName"/><xsl:value-of select="$strPatrolReadReportPart2"/></xsl:when>
                                	<xsl:when test="$varReportType = '4'"><xsl:value-of select="$strCheckConsistencyReportPart1"/><xsl:value-of select="ControllerName"/><xsl:value-of select="$strCheckConsistencyReportPart2"/></xsl:when>
                              </xsl:choose>
                       	</xsl:attribute>
			</PageTitle>

			<xsl:choose>
				<xsl:when test="$logCount &gt; 0">
					<!--AlertMessage>
                        		<xsl:choose>
                        			<xsl:when test="$varReportType = '2'"><xsl:attribute name="display"><xsl:value-of select="$strPatrolReadContains1"/></xsl:attribute></xsl:when>
                              		<xsl:when test="$varReportType = '4'"><xsl:attribute name="display"><xsl:value-of select="$strCheckConsistencyContains1"/></xsl:attribute></xsl:when>
                        		</xsl:choose>
					</AlertMessage-->
			
					<CustomButton>
						<xsl:if test="(OMAUserRights = '7')">
							<Data name="Clear"><xsl:attribute name="display"><xsl:value-of select="$strClearLog"/></xsl:attribute>
								<xsl:attribute name="href">javascript:clearLog()</xsl:attribute>
								<xsl:attribute name="formSubmit">true</xsl:attribute>
							</Data>
						</xsl:if>
						<xsl:if test="(OMAUserRights = '7') or (OMAUserRights = '3')">
							<Data name="Save"><xsl:attribute name="display"><xsl:value-of select="$strSaveAs"/></xsl:attribute>
								<xsl:attribute name="href">javascript:saveLog()</xsl:attribute>
								<xsl:attribute name="formSubmit">true</xsl:attribute>
							</Data>
						</xsl:if>
						<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
                              		<xsl:attribute name="href"><xsl:text>./DataArea?plugin=com.dell.sm.webplugins.PRCCReportWebPlugin&amp;ReportType=</xsl:text><xsl:value-of select="$varReportType"/><xsl:text>&amp;ControllerName=</xsl:text><xsl:value-of select="ControllerName"/><xsl:text>&amp;ControllerOID=</xsl:text><xsl:value-of select="ControllerOID"/><xsl:text>&amp;SASAddress=</xsl:text><xsl:value-of select="$ctrlSASAddress"/><xsl:text>&amp;Refresh=true&amp;PageRefresh=true&amp;newsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;oldsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;order=</xsl:text><xsl:value-of select="$varOrder"/></xsl:attribute>
						</Data>
					</CustomButton>
					<TableData columnspacing="true" nouniqueids="true" sortable="true">
						<Header>
							<Data align="center" name="Status" width="80" link="true">
								<xsl:attribute name="href"><xsl:text>./DataArea?plugin=com.dell.sm.webplugins.PRCCReportWebPlugin&amp;ReportType=</xsl:text><xsl:value-of select="$varReportType"/><xsl:text>&amp;ControllerName=</xsl:text><xsl:value-of select="ControllerName"/><xsl:text>&amp;ControllerOID=</xsl:text><xsl:value-of select="ControllerOID"/><xsl:text>&amp;SASAddress=</xsl:text><xsl:value-of select="$ctrlSASAddress"/><xsl:text>&amp;Refresh=true&amp;newsortkey=Status&amp;oldsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;order=</xsl:text><xsl:value-of select="$varOrder"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
								
						        <xsl:if test="($varSortKey = 'Status')">
						          <xsl:choose>
							         <xsl:when test="$varOrder='ascending'">
								         <xsl:attribute name="topsorted">true</xsl:attribute>
							         </xsl:when>
							         <xsl:otherwise>
								        <xsl:attribute name="descendsorted">true</xsl:attribute>
							         </xsl:otherwise>
						           </xsl:choose>
						        </xsl:if>
							</Data>
							
							<!--Data name="ID" width="110" link="true">
								<xsl:attribute name="href"><xsl:text>./DataArea?plugin=com.dell.sm.webplugins.PRCCReportWebPlugin&amp;ReportType=</xsl:text><xsl:value-of select="$varReportType"/><xsl:text>&amp;ControllerName=</xsl:text><xsl:value-of select="ControllerName"/><xsl:text>&amp;ControllerOID=</xsl:text><xsl:value-of select="ControllerOID"/><xsl:text>&amp;SASAddress=</xsl:text><xsl:value-of select="$ctrlSASAddress"/><xsl:text>&amp;Refresh=true&amp;newsortkey=ID&amp;oldsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;order=</xsl:text><xsl:value-of select="$varOrder"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
							</Data-->

                             <xsl:if test="$varReportType = '4'">
								<Data name="VDName" link="true">
									<xsl:attribute name="href"><xsl:text>./DataArea?plugin=com.dell.sm.webplugins.PRCCReportWebPlugin&amp;ReportType=</xsl:text><xsl:value-of select="$varReportType"/><xsl:text>&amp;ControllerName=</xsl:text><xsl:value-of select="ControllerName"/><xsl:text>&amp;ControllerOID=</xsl:text><xsl:value-of select="ControllerOID"/><xsl:text>&amp;SASAddress=</xsl:text><xsl:value-of select="$ctrlSASAddress"/><xsl:text>&amp;Refresh=true&amp;newsortkey=VirtualDiskName&amp;oldsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;order=</xsl:text><xsl:value-of select="$varOrder"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$strVDName"/></xsl:attribute>
									<xsl:attribute name="display"><xsl:value-of select="$strVDName"/></xsl:attribute>
									<xsl:if test="($varSortKey = 'VirtualDiskName')">
						             <xsl:choose>
							           <xsl:when test="$varOrder='ascending'">
								           <xsl:attribute name="topsorted">true</xsl:attribute>
							           </xsl:when>
							           <xsl:otherwise>
								          <xsl:attribute name="descendsorted">true</xsl:attribute>
							           </xsl:otherwise>
						           </xsl:choose>
						        </xsl:if>
								</Data>
								
								
							</xsl:if>

							<Data name="DateTime" link="true">
								<xsl:attribute name="href"><xsl:text>./DataArea?plugin=com.dell.sm.webplugins.PRCCReportWebPlugin&amp;ReportType=</xsl:text><xsl:value-of select="$varReportType"/><xsl:text>&amp;ControllerName=</xsl:text><xsl:value-of select="ControllerName"/><xsl:text>&amp;ControllerOID=</xsl:text><xsl:value-of select="ControllerOID"/><xsl:text>&amp;SASAddress=</xsl:text><xsl:value-of select="$ctrlSASAddress"/><xsl:text>&amp;Refresh=true&amp;newsortkey=TimeStamp&amp;oldsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;order=</xsl:text><xsl:value-of select="$varOrder"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strDateAndTime"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strDateAndTime"/></xsl:attribute>
								<xsl:if test="($varSortKey = 'TimeStamp')">
						          <xsl:choose>
							         <xsl:when test="$varOrder='ascending'">
								         <xsl:attribute name="topsorted">true</xsl:attribute>
							         </xsl:when>
							         <xsl:otherwise>
								        <xsl:attribute name="descendsorted">true</xsl:attribute>
							         </xsl:otherwise>
						           </xsl:choose>
						        </xsl:if>
							</Data>
							<Data name="Result" link="true">
								<xsl:attribute name="href"><xsl:text>./DataArea?plugin=com.dell.sm.webplugins.PRCCReportWebPlugin&amp;ReportType=</xsl:text><xsl:value-of select="$varReportType"/><xsl:text>&amp;ControllerName=</xsl:text><xsl:value-of select="ControllerName"/><xsl:text>&amp;ControllerOID=</xsl:text><xsl:value-of select="ControllerOID"/><xsl:text>&amp;SASAddress=</xsl:text><xsl:value-of select="$ctrlSASAddress"/><xsl:text>&amp;Refresh=true&amp;newsortkey=ErrorCode&amp;oldsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;order=</xsl:text><xsl:value-of select="$varOrder"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strResult"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strResult"/></xsl:attribute>
								<xsl:if test="($varSortKey = 'ErrorCode')">
						          <xsl:choose>
							         <xsl:when test="$varOrder='ascending'">
								         <xsl:attribute name="topsorted">true</xsl:attribute>
							         </xsl:when>
							         <xsl:otherwise>
								        <xsl:attribute name="descendsorted">true</xsl:attribute>
							         </xsl:otherwise>
						           </xsl:choose>
						        </xsl:if>
							</Data>
							<Data name="Remarks" link="true">
					   			<xsl:attribute name="href"><xsl:text>./DataArea?plugin=com.dell.sm.webplugins.PRCCReportWebPlugin&amp;ReportType=</xsl:text><xsl:value-of select="$varReportType"/><xsl:text>&amp;ControllerName=</xsl:text><xsl:value-of select="ControllerName"/><xsl:text>&amp;ControllerOID=</xsl:text><xsl:value-of select="ControllerOID"/><xsl:text>&amp;SASAddress=</xsl:text><xsl:value-of select="$ctrlSASAddress"/><xsl:text>&amp;Refresh=true&amp;newsortkey=Description&amp;oldsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;order=</xsl:text><xsl:value-of select="$varOrder"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strRemarks"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strRemarks"/></xsl:attribute>
								<xsl:if test="($varSortKey = 'Description')">
						          <xsl:choose>
							         <xsl:when test="$varOrder='ascending'">
								         <xsl:attribute name="topsorted">true</xsl:attribute>
							         </xsl:when>
							         <xsl:otherwise>
								        <xsl:attribute name="descendsorted">true</xsl:attribute>
							         </xsl:otherwise>
						           </xsl:choose>
						        </xsl:if>
							</Data>
					
						</Header>
						<xsl:apply-templates select="//LogEntry[SASAddress = $ctrlSASAddress]">
							<xsl:sort select="*[name()=$varSortKey]" data-type="{$varDataType}" order="{$varOrder}"/>
						</xsl:apply-templates>
					</TableData>
				</xsl:when>
				<xsl:otherwise>
					<!--PromptText>
                        		<xsl:value-of select="$strNoLogEntriesFound"/>
					</PromptText-->
                    <AlertMessage>
					   <xsl:attribute name="display"><xsl:value-of select="$strNoLogEntriesFound"/></xsl:attribute>
					</AlertMessage>
					<CustomButton>
						<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
                              		<xsl:attribute name="href"><xsl:text>./DataArea?plugin=com.dell.sm.webplugins.PRCCReportWebPlugin&amp;ReportType=</xsl:text><xsl:value-of select="$varReportType"/><xsl:text>&amp;ControllerName=</xsl:text><xsl:value-of select="ControllerName"/><xsl:text>&amp;ControllerOID=</xsl:text><xsl:value-of select="ControllerOID"/><xsl:text>&amp;SASAddress=</xsl:text><xsl:value-of select="$ctrlSASAddress"/><xsl:text>&amp;Refresh=true&amp;PageRefresh=true&amp;newsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;oldsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;order=</xsl:text><xsl:value-of select="$varOrder"/></xsl:attribute>
						</Data>
					</CustomButton>
				</xsl:otherwise>
			</xsl:choose>


			<BottomCustomButton>
				<Data formSubmit="true">
					<xsl:attribute name="display"><xsl:value-of select="$strBackPageButton"/></xsl:attribute>
					<xsl:attribute name="href"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>
				</Data>
			</BottomCustomButton>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="LogEntry">
		<Row>
			<Data name="severity" type="status" align="center">
				<xsl:attribute name="value">
					<xsl:call-template name="GetStatusMappings">
						<xsl:with-param name="Status"><xsl:value-of select="Status"/></xsl:with-param>
                        	</xsl:call-template>
           	        	</xsl:attribute>
			</Data>
				
			<!--xsl:choose>
				<xsl:when test="Link !=''">
					<Data name="ID" link="true">
				      	<xsl:attribute name="href">javascript:showEventHint("<xsl:value-of select="Link"/>")</xsl:attribute>
				   	      <xsl:attribute name="display"><xsl:value-of select="ID"/></xsl:attribute>
					      <xsl:attribute name="value"><xsl:value-of select="ID"/></xsl:attribute>
				      </Data>
				</xsl:when>
				<xsl:otherwise>
					<Data name="ID"> 
				   		<xsl:attribute name="display"><xsl:value-of select="ID"/></xsl:attribute>
					      <xsl:attribute name="value"><xsl:value-of select="ID"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose-->

                  <xsl:if test="$varReportType = '4'">
				<Data name="VDName"> 
					<xsl:attribute name="display"><xsl:value-of select="VirtualDiskName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="VirtualDiskName"/></xsl:attribute>
				</Data>
			</xsl:if>

			<Data name="DateTime">
				<xsl:attribute name="display"><xsl:value-of select="TimeStamp"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="DateTime"/></xsl:attribute>
			</Data>
				
			<Data name="Result">
				<xsl:attribute name="display"><xsl:value-of select="ErrorCode"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:call-template name="GetResultDetails"><xsl:with-param name="ErrorCode" select="ErrorCode"/></xsl:call-template></xsl:attribute>
			</Data>
				
			<Data name="description">
				<xsl:attribute name="display"><xsl:value-of select="Description"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="Description"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:template>

	<xsl:template name="GetStatusMappings">
		<xsl:param name="Status"/>
		<xsl:choose>
			<xsl:when test="$Status=0">0</xsl:when>
			<xsl:when test="$Status=1">4</xsl:when>
			<xsl:when test="$Status=2">3</xsl:when>
			<xsl:when test="$Status=4">2</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>