<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Enclosure Information page.  The associated web plugin is the EnclosureInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:import href="pdfwvertbl.xsl"/>
	<!-- Include some common templates created by SS -->
	<xsl:include href="Utils.xsl"/>
	
	<xsl:template match="OMA">
		<DataArea exportdata="false">
		  <xsl:call-template name="scripts"/>
			<script language="javascript">
			    function getFirmwareURLlink(releaseid)
			    {
				 
				   window.open("http://support.us.dell.com/support/downloads/format.aspx?releaseid="+releaseid+"&amp;c=us&amp;l=en&amp;cs=&amp;s=gen")
							   
			    }
			</script>
		   <BottomCustomButton>
				<Data formSubmit="true">
					<xsl:attribute name="display"><xsl:value-of select="$strBackPageButton"/></xsl:attribute>
					<xsl:attribute name="href"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>
				</Data>
			</BottomCustomButton>

			<PageTitle>
                     <xsl:choose>
                         <xsl:when test="//ShowTitle = '1'">
					<xsl:attribute name="display"><xsl:value-of select="$strPageTitle"/></xsl:attribute>
				 </xsl:when>
                         <xsl:otherwise>
					<xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="/*/ArrayInfo/@ControllerName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
                        </xsl:otherwise>
                    </xsl:choose>		
			</PageTitle>
			
			 <CustomButton>
	  			<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">#</xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data>
			</CustomButton>
		    <xsl:call-template name="PhysicalDiskFwTable"/>	 			
	</DataArea>
	</xsl:template>
	<xsl:template name="PhysicalDiskFwTable">
	      <!-- check to see if AD or HD should be visible -->
		 <xsl:variable name="nonRaid">
			<xsl:call-template name="IsObjectNonRaid">
				<xsl:with-param name="Mask">
					<xsl:value-of select="ArrayInfo/ArrayDisks/DCStorageObject/AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		 </xsl:variable>
	      
		      <xsl:choose>
				<xsl:when test="count(//ArrayInfo/ArrayDisks/DCStorageObject) > 0">
				<AlertMessage status="3"><xsl:attribute name="display"><xsl:value-of select="$strMessage"/></xsl:attribute></AlertMessage>
				<xsl:for-each select="ArrayInfo/ArrayDisks">
				  <TableData columnspacing="true">
				    <SubHeader>
					   <xsl:attribute name="display"><xsl:value-of select="@ControllerName"/></xsl:attribute>
					</SubHeader>
				    <Header>
						<xsl:call-template name="PhysicalDiskFwVerTableHeader"/>
					</Header>
					<xsl:for-each select="DCStorageObject">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:sort select="TargetID" data-type="number" order="ascending"/>
						<xsl:call-template name="PhysicalDiskFwVerTableRows"/>
					</xsl:for-each>
				  </TableData>	
				 </xsl:for-each> 
				</xsl:when>
				<xsl:otherwise>
				   <AlertMessage>
					    <xsl:choose>
						    <xsl:when test="$nonRaid = '1' ">
								<xsl:attribute name="display"><xsl:value-of select="$HDNoHDs"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="display"><xsl:value-of select="$ADNoADs"/></xsl:attribute>
							</xsl:otherwise>
					    </xsl:choose>
					</AlertMessage>
				</xsl:otherwise>
			  </xsl:choose>	
		  
    </xsl:template>
</xsl:stylesheet>