<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<xsl:template name="LicenseViewHeader">
    <Header>
		<Data>
			<xsl:attribute name="value"><xsl:value-of select="$strLicenseViewSubHeader"/></xsl:attribute>
		</Data>

	 </Header>

</xsl:template> 
<xsl:template name="LicenseView">
     
      
		 
            <xsl:if test="//FluidCacheLicenseType">
		<Data name="FluidCacheLicenseType">
			<xsl:attribute name="display"><xsl:value-of select="$strFluidCacheLicenseType"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="//FluidCacheLicenseType"/></xsl:attribute>
		</Data>
      	</xsl:if>
		<xsl:if test="//FluidCacheProperties/DCStorageObject/CachePoolLicenseState">	
		<Data name="LicenseState"> 
				<xsl:attribute name="display"><xsl:value-of select="$strCachePoolLicenseState"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="//FluidCacheProperties/DCStorageObject/CachePoolLicenseState"/></xsl:attribute >
												
		</Data>
		</xsl:if>
		<xsl:if test="//FluidCacheLicenseEntitlementID">
		<Data name="LicenseEntitlementID"> 
				<xsl:attribute name="display"><xsl:value-of select="$strFluidCacheLicenseEntitlementID"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="//FluidCacheLicenseEntitlementID"/></xsl:attribute >
												
		</Data>
		</xsl:if>
		
					<xsl:if test="//FluidCacheLicenseDuration">
						<Data name="FluidCacheLicenseDuration"> 
							<xsl:attribute name="display"><xsl:value-of select="$strFluidCacheLicenseDuration"/></xsl:attribute>
                                    	  <xsl:choose>
		                                      <xsl:when test="//FluidCacheLicenseType = 'Evaluation'">
													<xsl:attribute name="value"><xsl:value-of select="//FluidCacheLicenseDuration"/><xsl:value-of select="$strSpace"/><xsl:value-of select="$strDays"/></xsl:attribute>
                              					</xsl:when>
		                                      <xsl:otherwise>
													<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
                              		        </xsl:otherwise>  
							</xsl:choose>									
					</Data>
						</xsl:if>
						<xsl:if test="//FluidCacheLicenseRemaining">
					<Data name="FluidCacheLicenseRemaining"> 
							<xsl:attribute name="display"><xsl:value-of select="$strFluidCacheLicenseRemaining"/></xsl:attribute>

							<xsl:choose>
		                               <xsl:when test="//FluidCacheLicenseType ='Evaluation'">
												<xsl:attribute name="value"><xsl:value-of select="//FluidCacheLicenseRemaining"/><xsl:value-of select="$strSpace"/><xsl:value-of select="$strDays"/></xsl:attribute>
                              		    </xsl:when>
		                                <xsl:otherwise>
												<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
                              		    </xsl:otherwise>  
							</xsl:choose>									

							
															
					</Data>
				</xsl:if>

		<xsl:if test="//FluidCacheLicenseVendor">
		<Data name="FluidCacheLicenseVendor"> 
				<xsl:attribute name="display"><xsl:value-of select="$strFluidCacheLicenseVendor"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="//FluidCacheLicenseVendor"/></xsl:attribute >
												
		</Data>
		</xsl:if>
		<xsl:if test="//FluidCacheLicenseProductID">
		<Data name="FluidCacheLicenseProductID"> 
				<xsl:attribute name="display"><xsl:value-of select="$strFluidCacheLicenseProductID"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="//FluidCacheLicenseProductID"/></xsl:attribute >
												
		</Data>
		</xsl:if>
		<!--xsl:if test="//FluidCacheLicenseDateSold">
		<Data name="FluidCacheLicenseDateSold"> 
				<xsl:attribute name="display"><xsl:value-of select="$strFluidCacheLicenseDateSold"/></xsl:attribute>
				 <xsl:attribute name="value"><xsl:value-of select="translate(//FluidCacheLicenseDateSold,'_',':')"/></xsl:attribute>
												
		</Data>
		</xsl:if-->
		<xsl:if test="//FluidCacheLicenseGeneration">
		<Data name="FluidCacheLicenseGeneration"> 
				<xsl:attribute name="display"><xsl:value-of select="$strFluidCacheLicenseGeneration"/></xsl:attribute>
				 <xsl:attribute name="value"><xsl:value-of select="//FluidCacheLicenseGeneration"/></xsl:attribute>
												
		</Data>
		</xsl:if>
		<xsl:if test="//FluidCacheLicenseCapacity">
		<Data name="FluidCacheLicenseCapacity"> 
				<xsl:attribute name="display"><xsl:value-of select="$strFluidCacheLicenseCapacity"/></xsl:attribute>
				 <xsl:attribute name="value"><xsl:value-of select="//FluidCacheLicenseCapacity"/></xsl:attribute>
												
		</Data>
		</xsl:if>
		<xsl:if test="//FluidCacheLicenseFeatureID">
		<Data name="FluidCacheLicenseFeatureID"> 
				<xsl:attribute name="display"><xsl:value-of select="$strFluidCacheLicenseFeatureID"/></xsl:attribute>
				 <xsl:attribute name="value"><xsl:value-of select="//FluidCacheLicenseFeatureID"/></xsl:attribute>
												
		</Data>
		</xsl:if>
		<xsl:if test="//FluidCacheLicenseFeatureIDDesc">
		<Data name="FluidCacheLicenseFeatureIDDesc"> 
				<xsl:attribute name="display"><xsl:value-of select="$strFluidCacheLicenseFeatureIDDesc"/></xsl:attribute>
				 <xsl:attribute name="value"><xsl:value-of select="//FluidCacheLicenseFeatureIDDesc"/></xsl:attribute>
												
		</Data>
		</xsl:if>

      
</xsl:template>

</xsl:stylesheet>


