<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:include href="dsautils.xsl"/>
<xsl:include href="Utils.xsl"/>
<xsl:variable name="GLOBAL_VAR_Flag"><xsl:value-of select="/OMA/EncryptionViewFlag"/></xsl:variable>
<xsl:variable name="GLOBAL_PARAM_OrigURL"><xsl:value-of select="/OMA/BackTo"/></xsl:variable>
<xsl:variable name="GLOBAL_VAR_ExitWizardHREFValue"><xsl:value-of select="translate($GLOBAL_PARAM_OrigURL,'!','&amp;')"/></xsl:variable>
<xsl:variable name="ErrorCode"><xsl:value-of select="/OMA/ErrorCode"/></xsl:variable>

<xsl:template match="OMA">
    <DataArea exportdata="false" validate="false" onLoad="true" ignoreJumpBar="true">
         <xsl:choose>
	       <xsl:when test="$GLOBAL_VAR_Flag != 0">
	           <BottomCustomButton>
			      <Data formSubmit="true" display="{$strApply}" href="javascript:submitApplyDKM() " id="submitbuttoncontent"/>
	           </BottomCustomButton>
			   <BottomCustomButton>
				  <Data>
					<xsl:attribute name="display"><xsl:value-of select="$strExitWizard"/></xsl:attribute>
 				    <xsl:choose>
						<xsl:when test="$GLOBAL_PARAM_OrigURL != 'null' or $GLOBAL_PARAM_OrigURL != ''">
					                <xsl:attribute name="href"><xsl:value-of select="$GLOBAL_VAR_ExitWizardHREFValue"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin&amp;help=adprin</xsl:attribute>
						</xsl:otherwise>
					  </xsl:choose>
				    </Data>
			    </BottomCustomButton>
				<CustomButton>	   
                   <Data name="Refresh">
					   <xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					   <xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.DKMSServerSettingsWebPlugin&amp;EncryptionViewFlag=1&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin&amp;help=stprhl</xsl:attribute>
				   </Data>	 
	          </CustomButton>
           </xsl:when>
	       <xsl:otherwise>
 	           <BottomCustomButton>
			       <Data formSubmit="true" display="{$strContinue}" href="javascript:submitViewDKM() " id="submitbuttoncontent"/>
	           </BottomCustomButton>
			   <BottomCustomButton>
		        <Data formSubmit="true">
				   <xsl:attribute name="display"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
				   <xsl:attribute name="href"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>
		       </Data>
		      </BottomCustomButton>
			  <CustomButton>	   
                  <Data name="Refresh">
					   <xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					   <xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.DKMSServerSettingsWebPlugin&amp;EncryptionViewFlag=0&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin&amp;help=stprhl</xsl:attribute>
	              </Data>	 
	          </CustomButton>	
	       </xsl:otherwise>
	   </xsl:choose> 
       
	  <xsl:call-template name="scripts"/>
	  
	   <script language="javascript">
	      
		     var oldval=new Array();
			 var inputval=new Array();
		 	  
	       function initializationRoutine() 
		   {
             	 
	       }
	       function onUploadExecute()
		   {  
		      var origurl = GetLocalUrl();
			  var filepath = document.getElementById("FilePath").value;
			  var indexextension = filepath.lastIndexOf(".");
			  var FileExtension = filepath .substring(indexextension,filepath.length);
		      if(filepath=="" || filepath.length==0|| filepath==null)
              {
                 alert('<xsl:value-of select="$strEnterFilePath"/>'); 
				 return ;
               
              }
			  else if(FileExtension != ".csr" &amp;&amp; FileExtension != ".pem" &amp;&amp; FileExtension != ".CSR" &amp;&amp; FileExtension != ".PEM" &amp;&amp; FileExtension != ".txt" &amp;&amp; FileExtension != ".TXT" &amp;&amp; FileExtension != ".cer" &amp;&amp; FileExtension != ".CER")
              {          
                 alert('<xsl:value-of select="$strInvalidFilePath"/>');		
				 return ;
                
              } 
			  
			  
			  document.getElementById("dataarea").encoding = "multipart/form-data";
              document.getElementById("dataarea").enctype = "multipart/form-data";
              var FileFormat = "Base64";
              var Decryptionpassword="";
              var CertificateType="Server";
			  var url = "./UploadCertificateWebPlugin?FileFormat="+FileFormat+"&amp;Decryptionpassword="+Decryptionpassword+"&amp;EncryptionViewFlag=0&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin!help=stprhl&amp;CertificateType=Server"+"&amp;OrigURL="+origurl;
              document.getElementById("dataarea").action  = url;
         	  formSubmit();
		   }
		   function submitViewDKM()
		   {        
			   document.dataarea.action = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.DKMSServerSettingsWebPlugin&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin!help=stprhl");
			   document.dataarea.submit();
		   }
		   
		   function submitApplyDKM()
		   {
		       
		    var profileindex = 0;
			var origurl = GetLocalUrl();
			var SubmitExecuteUrl = "./SubmitForm?plugin=com.dell.sm.webplugins.SubmitDKMConfigWebPlugin&amp;EncryptionViewFlag=0&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin!help=stprhl"+"&amp;OrigURL="+origurl;
		    
			if(validate() == false)
			    return;
			    
				
             oldval[0]='<xsl:value-of select="/OMA//DCStorageObject[ProfileIndex = '1']/NetworkIP"/>';  
			 oldval[1]='<xsl:value-of select="/OMA//DCStorageObject[ProfileIndex = '1']/PortNumber"/>';  
			 oldval[2]='<xsl:value-of select="/OMA//DCStorageObject[ProfileIndex = '1']/TimeOut"/>';  
			 
			 oldval[3]='<xsl:value-of select="/OMA//DCStorageObject[ProfileIndex = '2']/NetworkIP"/>';  
			 oldval[4]='<xsl:value-of select="/OMA//DCStorageObject[ProfileIndex = '2']/PortNumber"/>';  
			 oldval[5]='<xsl:value-of select="/OMA//DCStorageObject[ProfileIndex = '2']/TimeOut"/>';  
			 oldval[6]='<xsl:value-of select="/OMA//DCStorageObject/DevGroup"/>'; 
			 		 
			 
			 inputval[0]=document.dataarea.PrimaryIPAddress.value;
			 inputval[0] = removeLeadingZeros(inputval[0]);
			 
			 inputval[1]=document.dataarea.PrimaryPortNumber.value;
			 inputval[1] = removeLeadingZeros(inputval[1]);
			 
			 inputval[2]=document.dataarea.PrimaryTimeOut.value;
			 inputval[2] = removeLeadingZeros(inputval[2]);
			 
			 inputval[3]=document.dataarea.SecondaryIPAddress.value;
			 inputval[3] = removeLeadingZeros(inputval[3]);
			 
			 inputval[4]=document.dataarea.SecondaryPortNumber.value;
			 inputval[4] = removeLeadingZeros(inputval[4]);
			 
			 inputval[5]=document.dataarea.SecondaryTimeOut.value;
			 inputval[5] = removeLeadingZeros(inputval[5]);
			 
			 inputval[6]=document.dataarea.DeviceGrpNameValue.value;
			 inputval[6] = removeLeadingZeros(inputval[6]);	
           
		    // The below order does matters
            if(!(oldval[0]==inputval[0] &amp;&amp; oldval[1]==inputval[1] &amp;&amp; oldval[2]==inputval[2]) &amp;&amp; !(oldval[3]==inputval[3] &amp;&amp; oldval[4]==inputval[4] &amp;&amp; oldval[5]==inputval[5]))
            {
			  profileindex = 3;
            } else if(!(oldval[0]==inputval[0] &amp;&amp; oldval[1]==inputval[1] &amp;&amp; oldval[2]==inputval[2]))
            {
			  profileindex = 1;
            } else if(!(oldval[3]==inputval[3] &amp;&amp; oldval[4]==inputval[4] &amp;&amp; oldval[5]==inputval[5]))
            {
			  profileindex = 2;
            } else if(!(oldval[6]==inputval[6]))
			{
			  profileindex = 4;
			}
			
			SubmitExecuteUrl += "&amp;ProfileIndex="+profileindex;
			
  	        document.dataarea.action = top.gnv.appendVID(SubmitExecuteUrl);
			document.dataarea.submit();
		   }
		   function onTestExecute(ipaddress)
		   {
		        var profileindex = 0;
		        if(ipaddress == "PrimaryIPAddress")
				{
				   document.dataarea.action = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.DKMTestConnWebPlugin&amp;EncryptionViewFlag=0&amp;profileindex=1&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin!help=stprhl");
			       document.dataarea.submit();
				}
				else if(ipaddress == "SecondaryIPAddress")
				{
				   document.dataarea.action = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.DKMTestConnWebPlugin&amp;EncryptionViewFlag=0&amp;profileindex=2&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin!help=stprhl");
			       document.dataarea.submit();
				}
				
		        
		   }
		   
		    function validate()
           { 
		     var errorMsg = "";
			
			 oldval[0]='<xsl:value-of select="/OMA//DCStorageObject[ProfileIndex = '1']/NetworkIP"/>';  
			 oldval[1]='<xsl:value-of select="/OMA//DCStorageObject[ProfileIndex = '1']/PortNumber"/>';  
			 oldval[2]='<xsl:value-of select="/OMA//DCStorageObject[ProfileIndex = '1']/TimeOut"/>';  
			 
			 oldval[3]='<xsl:value-of select="/OMA//DCStorageObject[ProfileIndex = '2']/NetworkIP"/>';  
			 oldval[4]='<xsl:value-of select="/OMA//DCStorageObject[ProfileIndex = '2']/PortNumber"/>';  
			 oldval[5]='<xsl:value-of select="/OMA//DCStorageObject[ProfileIndex = '2']/TimeOut"/>';  
			 oldval[6]='<xsl:value-of select="/OMA//DCStorageObject/DevGroup"/>'; 
		     
			 inputval[0]=document.dataarea.PrimaryIPAddress.value;
			 inputval[0] = removeLeadingZeros(inputval[0]);
			 
			 inputval[1]=document.dataarea.PrimaryPortNumber.value;
			 inputval[1] = removeLeadingZeros(inputval[1]);
			 
			 inputval[2]=document.dataarea.PrimaryTimeOut.value;
			 inputval[2] = removeLeadingZeros(inputval[2]);
			 
			 inputval[3]=document.dataarea.SecondaryIPAddress.value;
			 inputval[3] = removeLeadingZeros(inputval[3]);
			 
			 inputval[4]=document.dataarea.SecondaryPortNumber.value;
			 inputval[4] = removeLeadingZeros(inputval[4]);
			 
			 inputval[5]=document.dataarea.SecondaryTimeOut.value;
			 inputval[5] = removeLeadingZeros(inputval[5]);
			 
			 inputval[6]=document.dataarea.DeviceGrpNameValue.value;
			 inputval[6] = removeLeadingZeros(inputval[6]);
			
			 if(oldval[0]==inputval[0] &amp;&amp; oldval[1]==inputval[1] &amp;&amp; oldval[2]==inputval[2] &amp;&amp; oldval[3]==inputval[3] &amp;&amp; oldval[4]==inputval[4] &amp;&amp; oldval[5]==inputval[5] &amp;&amp; oldval[6]==inputval[6])
			 {
			   alert("<xsl:value-of select="$strNoChangeInValue"/>");
               return false;
			 }
			  if(inputval[0] == inputval[3])
			  {
			    alert("<xsl:value-of select="$strNoChangeInIPAddress"/>");
			    return false;
			  }
		      if((Valid_IPV4("PrimaryIPAddress",0,223) != true) || (Valid_IPV4("SecondaryIPAddress",0,223) != true))
              {
		           errorMsg += <xsl:value-of select="$strInvalidStaticIP"/>;
				   alert(errorMsg);
		           return false;
              }
			  
			  if((Valid_Digits("PrimaryPortNumber") != true) || (Valid_Digits("SecondaryPortNumber") != true))
			  {
			     errorMsg += <xsl:value-of select="$strInvalidPortNumber"/>;
				 alert(errorMsg);
			     return false;
			  }
			  
			  if((Valid_Digits("PrimaryTimeOut") != true) || (Valid_Digits("SecondaryTimeOut") != true))
			  {
			     errorMsg += <xsl:value-of select="$strInvalidTimeOut"/>;
				 alert(errorMsg);
			     return false;
			  }
			 
			  if(((inputval[2] &lt; 15) || (inputval[2] &gt; 300)) || ((inputval[5] &lt; 15) || (inputval[5] &gt; 300)))
			  {
			     errorMsg += <xsl:value-of select="$strInvalidTimeOut"/>;
				 errorMsg += <xsl:value-of select="$strTimeOutRange"/>
				 alert(errorMsg);
				 return false;
			  }
			
			  if(((inputval[1] &lt; 1) || (inputval[1] &gt; 65535)) || ((inputval[4] &lt; 1) || (inputval[4] &gt; 65535)))
			  {
			     errorMsg += <xsl:value-of select="$strInvalidPortNumber"/>;
				 errorMsg += <xsl:value-of select="$strPortNumberRange"/>
				 alert(errorMsg);
				 return false;
			  }
			  
			  if(Valid_DeviceGrpName("DeviceGrpNameValue") != true)
			  {
			     errorMsg += <xsl:value-of select="$strInvalidDeviceGrpName"/>;
				 alert(errorMsg);
			     return false;
			  }
		 
		      return true;
 
		   }
		   
    function Valid_IPV4(objstr,min,max)
	{
	var nASCII_0 = 48;
	var nASCII_9 = 57;
	var nASCII_dot = 46;
	var curNumber = "";
	var iCount = 0;
	var jCount = 0;
	var limitedMask = 255;
	var str = document.getElementById(objstr).value;
	
	if(str.length == 0 || str == "")
	{
		return false;
    }
	if (Compare_Strings(str, '0.0.0.0'))
	{
		return false;
	}	

	if (Compare_Strings(str, '255.255.255.255'))
	{
		return false;
	}	

	for (var i = 0; i &lt; str.length; i++)
	{
	curChar = str.charCodeAt(i);
	curNum = str.charAt(i);
	if (curChar == nASCII_dot)
	{   
	    iCount++;
		jCount = 0;
		if (iCount == 1)
		{
			if (curNumber &lt; 1 || curNumber == 127)
				return false;
			ret_code = Valid_Number(curNumber,-1,min,max);
		}
		else
			ret_code = Valid_Number(curNumber,-1,min,limitedMask);

		if (ret_code != 1)
			return false;
		curNumber = "";
		continue;
		}
		else if (curChar &gt;= nASCII_0 &amp;&amp; curChar &lt;= nASCII_9 &amp;&amp; jCount &lt;= 3)
		{
			jCount++;
			curNumber += curNum;
		}
		else
		{
			return false;
		}
	}
    
	if (ret_code != 1)
		return false;
	if (iCount != 3)
		return false;
    return true;
    }
	
	function Compare_Strings(str1, str2)
        {
		ret_val = true;
		if(str1.length != str2.length)
		return false;

	        for (var i = 0; i &lt;= str1.length; i++)
		{
			curChar1 = str1.charCodeAt(i);
			curChar2 = str2.charCodeAt(i);
		if ( curChar1 == curChar2)
			{
				continue;
			}
		else
			{
			ret_val = false;
			break;
			}
		}
		return ret_val;
	}
	function Valid_Number(value, exact, min, max)
	{
		var nASCII_0 = 48;
		var nASCII_9 = 57;

		if (exact != -1 &amp;&amp; value != exact)
			return false;
		else if (exact != -1 &amp;&amp; value == exact)
			return true;

		if (value == null || value == "")
			return false;
		var str = new String(value);
		for (var i = 0; i &lt; str.length; i++)
		{
			if (str.charCodeAt(i) &lt; nASCII_0 || str.charCodeAt(i) &gt; nASCII_9)
			return false;
		}

		if (Math.floor(str) &lt; Math.floor(min) || Math.floor(str) &gt; Math.floor(max))
			return false;
		else
			return true;
	}

    function Valid_Digits(objstr)
   {
      var nASCII_0 = 48;
	  var nASCII_9 = 57;
      var str = document.getElementById(objstr).value;
	  if(str.length == 0 || str == "")
	  {
		return false;
      }
	  
	  for (var i = 0; i &lt; str.length; i++)
	 {  
			if (str.charCodeAt(i) &lt; nASCII_0 || str.charCodeAt(i) &gt; nASCII_9)
			return false;
	 }
	  return true;
   }

   function Valid_DeviceGrpName(objstr)
  {
    var str = document.getElementById(objstr).value;
	if(str.length == 0 || str == "")
	{
		return false;
    }
	return true;
  }  
		</script>
	   <PageTitle>
               <xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/></xsl:attribute>
       </PageTitle>

				<xsl:choose>
					<xsl:when test="$ErrorCode = '0'">
					<AlertMessage>
						<xsl:attribute name="display"><xsl:value-of select="$strCertSuccess"/></xsl:attribute>
						<xsl:attribute name="status"><xsl:value-of select="1"/></xsl:attribute>
					</AlertMessage>	
					</xsl:when>
					<xsl:when test="$ErrorCode &gt; 0">
					<AlertMessage>
						<xsl:attribute name="display"><xsl:value-of select="$strCertFailed"/></xsl:attribute>
						<xsl:attribute name="status"><xsl:value-of select="4"/></xsl:attribute>
					</AlertMessage>	
					</xsl:when>
					<xsl:otherwise><!-- Do Nothing--></xsl:otherwise>
				</xsl:choose>
	   
	   <xsl:apply-templates select="/OMA//DCStorageObject[ProfileIndex = '1']"/>
	   <xsl:apply-templates select="/OMA//DCStorageObject[ProfileIndex = '2']"/>
	   <xsl:apply-templates select="/OMA//DCStorageObject/DevGroup"/>
	   
    </DataArea>
</xsl:template>

<xsl:template match="DCStorageObject[ProfileIndex = '1']">
     
        <xsl:if test="DKMTestConnectivityStatus = '0'">
	       <AlertMessage status="2">
	          <xsl:attribute name="display"><xsl:value-of select="$strPrimary"/>:<xsl:value-of select="$strTestPassed"/></xsl:attribute>
	       </AlertMessage>
	    </xsl:if>
		<xsl:if test="DKMTestConnectivityStatus != '0'">
		    <AlertMessage status="4">
	          <xsl:attribute name="display"><xsl:value-of select="$strPrimary"/>:<xsl:value-of select="$strTestFailed"/></xsl:attribute>
	        </AlertMessage>
	    </xsl:if>
		
    <SummaryData ignoreJumpBar="true">       
        <TableData name="DKMPrimaryTable" display="{$strPrimary}">
	        <SubHeader>
		        <xsl:attribute name="display"><xsl:value-of select="$strPrimary"/></xsl:attribute>
	        </SubHeader>
	        <xsl:call-template name="DKMTableHeader"/>
		    <xsl:call-template name="DKMTableRows">
			   <xsl:with-param name="ipaddress">PrimaryIPAddress</xsl:with-param>
			   <xsl:with-param name="portnumber">PrimaryPortNumber</xsl:with-param>
			   <xsl:with-param name="timeout">PrimaryTimeOut</xsl:with-param>
			</xsl:call-template>
	    </TableData>
	</SummaryData>
</xsl:template>

<xsl:template match="DCStorageObject[ProfileIndex = '2']">
      <xsl:if test="DKMTestConnectivityStatus = '0'">
	       <AlertMessage status="2">
	          <xsl:attribute name="display"><xsl:value-of select="$strSecondary"/>:<xsl:value-of select="$strTestPassed"/></xsl:attribute>
	       </AlertMessage>
	    </xsl:if>
		<xsl:if test="DKMTestConnectivityStatus != '0'">
		    <AlertMessage status="4">
	          <xsl:attribute name="display"><xsl:value-of select="$strSecondary"/>:<xsl:value-of select="$strTestFailed"/></xsl:attribute>
	        </AlertMessage>
	    </xsl:if>
     <SummaryData> 
        <TableData name="DKMSecondaryTable" display="{$strSecondary}">
	        <SubHeader>
		        <xsl:attribute name="display"><xsl:value-of select="$strSecondary"/></xsl:attribute>
            </SubHeader>
	        <xsl:call-template name="DKMTableHeader"/>
			<xsl:call-template name="DKMTableRows">
			   <xsl:with-param name="ipaddress">SecondaryIPAddress</xsl:with-param>
			   <xsl:with-param name="portnumber">SecondaryPortNumber</xsl:with-param>
			   <xsl:with-param name="timeout">SecondaryTimeOut</xsl:with-param>
			</xsl:call-template>	
    	</TableData>
	</SummaryData> 
</xsl:template>

<xsl:template match="DevGroup">
     <SummaryData ignoreJumpBar="true">       
        <TableData name="DKMDrvGrpTable" display="{$strDeviceGrp}">
	        <SubHeader>
		        <xsl:attribute name="display"><xsl:value-of select="$strDeviceGrp"/></xsl:attribute>
	        </SubHeader>
	        <xsl:call-template name="DKMTableHeader"/>
		    <xsl:call-template name="DeviceGrpRow"/>
	    </TableData>
		 <xsl:call-template name="ServerCert"/>
	</SummaryData>
	</xsl:template>

<xsl:template name="DKMTableHeader">
   <Header>
	    <Data name="Attribute" editable="false" type="ustring" align="left" width="50%">
	        <xsl:attribute name="value"><xsl:value-of select="$strAttribute"/></xsl:attribute>
		</Data>
		<Data name="Value" editable="false" type="ustring" align="left" width="50%">
		    <xsl:attribute name="value"><xsl:value-of select="$strValue"/></xsl:attribute>
		</Data>
	</Header>
</xsl:template>

<xsl:template name="DKMTableRows">
<xsl:param name="ipaddress"/>
<xsl:param name="portnumber"/>
<xsl:param name="timeout"/>
            <Row>
		           <Data name="IPAdress" editable="false" type="ustring" align="left">
				           <xsl:attribute name="value"><xsl:value-of select="$strNetworkIPAddress"/></xsl:attribute>
		           </Data>
				    <xsl:choose>
				    <xsl:when test="$GLOBAL_VAR_Flag != 0">
				        <Data type="editbox" maxlength="15" size="17" align="left">
						    <xsl:attribute name="name"><xsl:value-of select="$ipaddress"/></xsl:attribute>
					        <xsl:attribute name="value"><xsl:value-of select="NetworkIP"/></xsl:attribute>
					    </Data>
				    </xsl:when>
				    <xsl:otherwise>
				        <Data type="ustring" editable="false" align="left">
						    <xsl:attribute name="name"><xsl:value-of select="$ipaddress"/></xsl:attribute>
				            <xsl:attribute name="value"><xsl:value-of select="NetworkIP"/></xsl:attribute>
		                </Data>
				    </xsl:otherwise>
				    </xsl:choose>
		    </Row>
		    <Row>
		           <Data name="PortNumber" editable="false" type="ustring" align="left">
				      <xsl:attribute name="value"><xsl:value-of select="$strPortNumber"/></xsl:attribute>
		           </Data>
				   <xsl:choose>
				      <xsl:when test="$GLOBAL_VAR_Flag != 0">
				         <Data type="editbox" maxlength="5" size="6" align="left">
						   <xsl:attribute name="name"><xsl:value-of select="$portnumber"/></xsl:attribute>
					       <xsl:attribute name="value"><xsl:value-of select="PortNumber"/></xsl:attribute>
					     </Data>
				      </xsl:when>
				      <xsl:otherwise>
				         <Data editable="false" type="ustring" align="left">
						    <xsl:attribute name="name"><xsl:value-of select="$portnumber"/></xsl:attribute>
				            <xsl:attribute name="value"><xsl:value-of select="PortNumber"/></xsl:attribute>
		                 </Data>
				      </xsl:otherwise>
				   </xsl:choose>
		    </Row>
		    <Row>
		           <Data name="TimeOut" editable="false" type="ustring" align="left">
				      <xsl:attribute name="value"><xsl:value-of select="$strTimeOut"/></xsl:attribute>
		           </Data>
				   <xsl:choose>
				   <xsl:when test="$GLOBAL_VAR_Flag != 0">
				    <Data type="editbox" maxlength="3" size="4" align="left">
					       <xsl:attribute name="name"><xsl:value-of select="$timeout"/></xsl:attribute>
					       <xsl:attribute name="value"><xsl:value-of select="TimeOut"/></xsl:attribute>
					</Data>
					</xsl:when>
				   <xsl:otherwise>
				   <Data editable="false" type="ustring" align="left">
				      <xsl:attribute name="name"><xsl:value-of select="$timeout"/></xsl:attribute>
				      <xsl:attribute name="value"><xsl:value-of select="TimeOut"/>&#160;<xsl:value-of select="$strSeconds"/></xsl:attribute>
		           </Data>
				    </xsl:otherwise>
				   </xsl:choose>
		    </Row>
			<xsl:if test="$GLOBAL_VAR_Flag = 0">
			<Row>
			   <Data colspan="2" type="button" align="right">
							<xsl:attribute name="display"><xsl:value-of select="$strTestConnectivity"/></xsl:attribute>
							 <xsl:attribute name="id"><xsl:value-of select="$strTestConnectivity"/></xsl:attribute>
							  <xsl:attribute name="href">javascript:onTestExecute(\"<xsl:value-of select="$ipaddress"/>\");</xsl:attribute>
							 <xsl:attribute name="tablebutton">true</xsl:attribute> 
							
		      </Data>	
           </Row>
           </xsl:if>		   
</xsl:template>
<xsl:template name="DeviceGrpRow">
        <Row>
		    <Data name="DeviceGrpName" editable="false" type="ustring" align="left">
		        <xsl:attribute name="value"><xsl:value-of select="$strDeviceGrp"/></xsl:attribute>
		    </Data>
			    <xsl:choose>
				    <xsl:when test="$GLOBAL_VAR_Flag != 0">
				        <Data name="DeviceGrpNameValue" type="editbox" maxlength="255" size="20" align="left">
					       <xsl:attribute name="value"><xsl:value-of select="//DevGroup"/></xsl:attribute>
					    </Data>
				    </xsl:when>
				    <xsl:otherwise>
			            <Data name="DeviceGrpNameValue" editable="false" type="ustring" align="left">
			                <xsl:attribute name="value"><xsl:value-of select="//DevGroup"/></xsl:attribute>
		                </Data>
			        </xsl:otherwise>
				</xsl:choose>
		</Row>
		
</xsl:template>
<xsl:template name="ServerCert">
 <xsl:choose>
 <xsl:when test="$GLOBAL_VAR_Flag != 0">
  <TableData name="ServerCertificate">
       <SubHeader>
	      <xsl:attribute name="display"><xsl:value-of select="$strSubHeader"/></xsl:attribute>
	   </SubHeader>
	   <xsl:call-template name="CertificateTableHeader"/>
            <Row>
		       <Data name="Options" editable="false" type="ustring" align="left">
		           <xsl:attribute name="value"><xsl:value-of select="$strLabelCetrifitace"/></xsl:attribute>
		       </Data>
	           <Data name="FilePath" type="file" maxlength="32" size="32" align="left" noborderright="true">
                  <xsl:attribute name="returnvalue"/>
               </Data>
               <Data name="UploadButton" type="button" align="left" noborderright="true">
					<xsl:attribute name="display"><xsl:value-of select="$strUpload"/></xsl:attribute>
					<xsl:attribute name="href">javascript:onUploadExecute();</xsl:attribute>
					<xsl:attribute name="tablebutton">true</xsl:attribute> 
		       </Data>
               <Data></Data>			   
		    </Row>
	   </TableData>	
   </xsl:when>
</xsl:choose>	
</xsl:template>
<xsl:template name="CertificateTableHeader">
   <Header>
	    <Data name="Attribute" editable="false" type="ustring" align="left" width="50%">
	        <xsl:attribute name="value"><xsl:value-of select="$strAttribute"/></xsl:attribute>
		</Data>
		<Data name="Value" editable="false" type="ustring" align="left" noborderright="true" width="25%">
		    <xsl:attribute name="value"><xsl:value-of select="$strValue"/></xsl:attribute>
		</Data>
		<Data name="exbut" columnspacing="true" align="left" editable="false" type="ustring" ignoreoncli="true" noborderright="true" width="10%">
		       <xsl:attribute name="display"><!--XLATESTART-->Upload<!--XLATESTOP--></xsl:attribute>
			   <xsl:attribute name="value"><!--XLATESTART--><!--XLATESTOP--></xsl:attribute>
		</Data>
		<Data width="15%"></Data>
	</Header>
</xsl:template>
</xsl:stylesheet>
