<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
   
	<!-- DFCT139044 - Indravijay J. Gohil  GUI:Adisk with no free space is listed in CreateVD wizard on PERC /2QC -->
	<!-- Creating hash variable for use within conditional for check on minimum drive size allowable to be visible  -->
  <xsl:variable name="MinDriveSpace"><xsl:value-of select="0.005 * 1024 * 1024"/></xsl:variable>
  <xsl:variable name="GLOBAL_PARAM_Oslimit"><xsl:value-of select="//Controllers/DCStorageObject/MaxOsLimitForLogicalDriveSize"/></xsl:variable>
  <xsl:variable name="GLOBAL_VAR_SCSIEnclosureID">0</xsl:variable>
  <xsl:variable name="GLOBAL_VAR_SCSI">1</xsl:variable>
  <xsl:variable name="GLOBAL_VAR_ATA">2</xsl:variable>
  <xsl:variable name="GLOBAL_VAR_SATA">7</xsl:variable>
  <xsl:variable name="GLOBAL_VAR_SAS">8</xsl:variable>
   <xsl:variable name="GLOBAL_VAR_SSDMEDIA">2</xsl:variable>
  <xsl:variable name="GLOBAL_VAR_HDDMEDIA">1</xsl:variable>
 
	<xsl:template name="RenderAdvancedCheckBox">
        <xsl:param name="AdvancedWizard"/>
		<xsl:param name="i"/>
		<xsl:param name="BitValue"/>
		<xsl:param name="InterpreterFunc"/>
        <xsl:variable name="ControllerAttributesMask"><xsl:value-of select="//OMA/Controllers/DCStorageObject/AttributesMask"/></xsl:variable>

		<xsl:if test="(($BitValue != '524288') or (($BitValue = '524288') and substring($ControllerAttributesMask,13,1)='1'))">

                 <xsl:choose>
                     <xsl:when test="$BitValue='512' and substring($ControllerAttributesMask,11,1)='1' and $AdvancedWizard='true'">
					
						   
                             <Data type="checkbox" align="center">
                             <xsl:attribute name="value"><xsl:text> </xsl:text><xsl:value-of select="$strIntelligentMirroring"/></xsl:attribute>
                             <xsl:attribute name="name">intMirror</xsl:attribute>
                             <xsl:attribute name="returnvalue"/>
                             <xsl:attribute name="event">onClick</xsl:attribute>
						</Data>
					
					</xsl:when> 
                    <xsl:when test="substring($ControllerAttributesMask,11,1)='1' and $AdvancedWizard='true'">
					<!-- <Row>
                            <Data  width="130" align="left">
                             <xsl:attribute name="name"></xsl:attribute>
                             <xsl:attribute name="value"></xsl:attribute>
                             <xsl:attribute name="returnvalue"/>
                             <xsl:attribute name="event">onClick</xsl:attribute>
						</Data>
					</Row>	
					-->
                    </xsl:when> 
                  </xsl:choose>
	     </xsl:if>
	</xsl:template>
	<xsl:template name="RenderLayoutSelectionRadioButton">
        <xsl:param name="AdvancedWizard"/>
		<xsl:param name="i"/>
		<xsl:param name="BitValue"/>
		<xsl:param name="InterpreterFunc"/>
        <xsl:variable name="ControllerAttributesMask"><xsl:value-of select="//OMA/Controllers/DCStorageObject/AttributesMask"/></xsl:variable>

		<xsl:if test="(($BitValue != '524288') or (($BitValue = '524288') and substring($ControllerAttributesMask,13,1)='1'))">
			<Choice>
				<xsl:attribute name="value">
					<xsl:call-template name="GetRaidLayout">
						<xsl:with-param name="RaidType">
							<xsl:value-of select="$BitValue"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
			</Choice>
	     </xsl:if>
	</xsl:template>

	<!-- Separate template to disable concatenated, raid-1-concatenated and Raid-50 types for DSA-->
	<xsl:template name="DSARenderLayoutSelectionRadioButton">
		<xsl:param name="i"/>
		<xsl:param name="BitValue"/>
		<xsl:param name="InterpreterFunc"/>
		<Row>
			<xsl:choose>
				<xsl:when test="$i='31'"><Data value="{$strTypeCVDU}" width="175"/></xsl:when>
				<xsl:otherwise><Data value="&#160;" width="175"/></xsl:otherwise>
			</xsl:choose> 
                  
			<Data name="VDLayout" type="radio" handler="OnElementSelected(this)" event="onclick" state="0" width="175">
				<xsl:attribute name="value">
					<xsl:call-template name="GetRaidLayout">
						<xsl:with-param name="RaidType">
							<xsl:value-of select="$BitValue"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
			</Data>
			
		</Row>
	</xsl:template>

	<xsl:template name="for-loop">
            <xsl:param name="AdvancedWizard"/>
		<xsl:param name="Mask"/>
		<xsl:param name="BitValue" select="1"/>
		<xsl:param name="i"	select="32"/>
		<xsl:param name="increment" select="-1"/>
		<xsl:param name="testValue" select="1"/>
		<xsl:param name="RULES" />
		<xsl:if test="$i >= '1' ">
			<xsl:if test="substring($Mask,$i,1) ='1'  ">
			    
				<xsl:choose>
					<xsl:when test="$RULES='0' ">
					   
						<xsl:call-template name="RenderLayoutSelectionRadioButton">
                                          <xsl:with-param name="AdvancedWizard" select="$AdvancedWizard"/>
							<xsl:with-param name="i" select="$i"/>
							<xsl:with-param name="BitValue" select="$BitValue"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$RULES ='1' and $BitValue != '2048' and $BitValue !='4096' and $BitValue != '262144' and $BitValue != '1' ">
						<xsl:call-template name="DSARenderLayoutSelectionRadioButton">
							<xsl:with-param name="i" select="$i"/>
							<xsl:with-param name="BitValue" select="$BitValue"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:if>
			<xsl:call-template name="for-loop">
                        <xsl:with-param name="AdvancedWizard" select="$AdvancedWizard"/>
				<xsl:with-param name="Mask" select="$Mask"/>
				<xsl:with-param name="BitValue" select="$BitValue*2"/>
				<xsl:with-param name="i" select="$i+$increment"/>
				<xsl:with-param name="increment" select="$increment"/>
				<xsl:with-param name="testValue" select="$testValue"/>
				<xsl:with-param name="RULES" select="$RULES"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

		<xsl:template name="for-loop-adv-checkbox">
            <xsl:param name="AdvancedWizard"/>
		<xsl:param name="Mask"/>
		<xsl:param name="BitValue" select="1"/>
		<xsl:param name="i"	select="32"/>
		<xsl:param name="increment" select="-1"/>
		<xsl:param name="testValue" select="1"/>
		<xsl:param name="RULES" />
		<xsl:if test="$i >= '1' ">
			<xsl:if test="substring($Mask,$i,1)='1'  ">
				<xsl:choose>
					<xsl:when test="$RULES='0' ">
						<xsl:call-template name="RenderAdvancedCheckBox">
                                          <xsl:with-param name="AdvancedWizard" select="$AdvancedWizard"/>
							<xsl:with-param name="i" select="$i"/>
							<xsl:with-param name="BitValue" select="$BitValue"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:if>
			<xsl:call-template name="for-loop-adv-checkbox">
                  <xsl:with-param name="AdvancedWizard" select="$AdvancedWizard"/>
				<xsl:with-param name="Mask" select="$Mask"/>
				<xsl:with-param name="BitValue" select="$BitValue*2"/>
				<xsl:with-param name="i" select="$i+$increment"/>
				<xsl:with-param name="increment" select="$increment"/>
				<xsl:with-param name="testValue" select="$testValue"/>
				<xsl:with-param name="RULES" select="$RULES"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getMaxSizeInBytesForGivenLayoutType_HIDDEN_TABLE">
		<!--This creates a hidden table that maps a "raid layout type" to the "max size possible in bytes" for that layout/-->
		<!--The table would look like below /-->
		<!--Layout1 .....  123456789./-->
		<!--Layout2 .....  567891011/ -->
		<!--Layout4 .....  121314156 / -->
		<!--This hidden table makes it easier for javascript functions to display and retrieve values dynamically/-->
		<Data type="hidden">
			<!--The name below would appear as "getMaxSizeFor_Layout_1_HIDDEN_TABLE_DATA", "getMaxSizeFor_Layout_2_HIDDEN_TABLE_DATA" etc/-->
			<xsl:attribute name="name">getMaxSizeInBytesFor_Layout_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="Length"/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template name="getMinSizeInBytesForGivenLayoutType_HIDDEN_TABLE">
		<!--This creates a hidden table that maps a "raid layout type" to the "min size possible in bytes" for that layout/-->
		<!--The table would look like below /-->
		<!--Layout1 .....  123456789./-->
		<!--Layout2 .....  567891011/ -->
		<!--Layout4 .....  121314156 / -->
		<!--This hidden table makes it easier for javascript functions to display and retrieve values dynamically/-->
		<Data type="hidden">
			<!--The name below would appear as "getMaxSizeFor_Layout_1_HIDDEN_TABLE_DATA", "getMaxSizeFor_Layout_2_HIDDEN_TABLE_DATA" etc/-->
			<xsl:attribute name="name">getMinSizeInBytesFor_Layout_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="MinimumLength"/></xsl:attribute>
		</Data>
	</xsl:template>

	<xsl:template name="getMaxSizeInGBForGivenLayoutType_HIDDEN_TABLE">
		<!--This creates a hidden table that maps a "raid layout type" to the "max size possible" for that layout/-->
		<!--The table would look like below /-->
		<!--Layout1 .....  33.33 ./-->
		<!--Layout2 .....  44.65 / -->
		<!--Layout4 .....  55.65 / -->
		<!--This hidden table makes it easier for javascript functions to display and retrieve values dynamically/-->
		<Data type="hidden">
			<!--The name below would appear as "getMaxSizeFor_Layout_1_HIDDEN_TABLE_DATA", "getMaxSizeFor_Layout_2_HIDDEN_TABLE_DATA" etc/-->
			<xsl:attribute name="name">getMaxSizeInGBFor_Layout_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="format-number((Length div (1024*1024*1024)),'###0.00')"/></xsl:attribute>
		</Data>
	</xsl:template>

	<xsl:template name="getMinSizeInGBForGivenLayoutType_HIDDEN_TABLE">
		<!--This creates a hidden table that maps a "raid layout type" to the "min size possible" for that layout/-->
		<!--The table would look like below /-->
		<!--Layout1 .....  33.33 ./-->
		<!--Layout2 .....  44.65 / -->
		<!--Layout4 .....  55.65 / -->
		<!--This hidden table makes it easier for javascript functions to display and retrieve values dynamically/-->
		<Data type="hidden">
			<!--The name below would appear as "getMinSizeFor_Layout_1_HIDDEN_TABLE_DATA", "getMinSizeFor_Layout_2_HIDDEN_TABLE_DATA" etc/-->
			<xsl:attribute name="name">getMinSizeInGBFor_Layout_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="format-number((MinimumLength div (1024*1024*1024)),'###0.00')"/></xsl:attribute>
		</Data>
	</xsl:template>

	<xsl:template name="AvailableRaidLayout_HIDDEN_TABLE">
		<Data type="hidden">
			<xsl:attribute name="name">RadioButtonsForRaidLayoutSelection_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="Layout"/></xsl:attribute>
		</Data>
	</xsl:template>
      <xsl:template name="AvailableSecureVDRaidLayout_HIDDEN_TABLE"> <!-- To figre out which raid levels are enabled for Secured Vd selection -->
		<Data type="hidden">
			<xsl:attribute name="name">RadioButtonsForSecureVDRaidLayoutSelection_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="Layout"/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template name="AvailablePIRaidLayout_HIDDEN_TABLE">
		<Data type="hidden">
			<xsl:attribute name="name">RadioButtonsForPIRaidLayoutSelection_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="Layout"/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template name="AvailablePISecureRaidLayout_HIDDEN_TABLE">
		<Data type="hidden">
			<xsl:attribute name="name">RadioButtonsForPISecureRaidLayoutSelection_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="Layout"/></xsl:attribute>
		</Data>
	</xsl:template>


	
	<xsl:template name="NewLine">
		<xsl:text>
		</xsl:text>
	</xsl:template>
	


      <xsl:template name="DisplayCreateVDFilters">
         <xsl:param name="Mask"/>
         <xsl:param name="templateName"/>
         <xsl:choose>
              <xsl:when test="$templateName ='1'">
                   <xsl:if test="$Mask = '1'">
                       <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strHDD"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">1</xsl:attribute>
                       </Choice>
                   </xsl:if>  
                   <xsl:if test="$Mask = '2'">
                      <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strSSD"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">2</xsl:attribute>
                       </Choice> 
                   </xsl:if>                  
                   <xsl:if test="$Mask = '3'">
                      <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strHDD"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">1</xsl:attribute>
                       </Choice>
                       <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strSSD"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">2</xsl:attribute>
                       </Choice> 
                    </xsl:if>                  
                    
                       
              </xsl:when>
              <xsl:when test="$templateName ='2'">
                   <xsl:if test="$Mask = '128'">
                       <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strSATA"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">128</xsl:attribute>
                       </Choice>
                   </xsl:if>  
                   <xsl:if test="$Mask = '256'">
                      <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strSAS"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">256</xsl:attribute>
                       </Choice> 
                   </xsl:if>  
                    <xsl:if test="$Mask = '1'">
                      <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strSCSI"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">1</xsl:attribute>
                       </Choice> 
                   </xsl:if>                  
                   				   
                   <xsl:if test="$Mask = '384'">
                      <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strSATA"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">128</xsl:attribute>
                       </Choice>
                       <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strSAS"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">256</xsl:attribute>
                       </Choice> 
                    </xsl:if>                 
             </xsl:when>
             <!--xsl:when test="$templateName ='3'">
                       <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">1</xsl:attribute>
                       </Choice>
                       <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">0</xsl:attribute>
                      </Choice> 
             </xsl:when-->
			 
			 <xsl:when test="$templateName ='3'"> <!-- PIS related stuff -->
						
					 <xsl:if test="//PISecureExpressResults">
                       <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strPIEncryptedDD"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">1</xsl:attribute>
                       </Choice>
					  </xsl:if>
					  <xsl:if test="//PIExpressResults">
                       <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strPIDD"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">2</xsl:attribute>
                      </Choice>
					  </xsl:if>
					  <xsl:if test="//SecureExpressResults">
					  <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strNonPIEncryptedDD"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">3</xsl:attribute>
                       </Choice>
					   </xsl:if>
					   <xsl:if test="//ExpressResults">
                       <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$strExpressDD"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">4</xsl:attribute>
                      </Choice>
					</xsl:if>
             </xsl:when>
			</xsl:choose>
         </xsl:template> 


	<xsl:template name="RenderCreateVDTable">
            

		<xsl:param name="RAIDMask"/>
		<xsl:param name="PROTOCOLMask"/> <!-- new parameter -->
		<xsl:param name="MEDIAMask"/> <!-- new parameter -->
		<xsl:param name="READMask"/> 
		<xsl:param name="SectorSizeMask"/>
		<!--xsl:param name="PIEnabledMask"/--><!--Uncomment for PI feature-->
		<xsl:param name="WRITEMask"/>
		<xsl:param name="DEFAULTReadPolicy"/>
		<xsl:param name="DEFAULTWritePolicy"/>
		<xsl:param name="CACHEMask"/>
		<xsl:param name="DISKCACHEMask"/>
		<xsl:param name="CntrlAttributesMask"/>
		<xsl:param name="STRIPESMask"/>
		<xsl:param name="HIDE_NAME_ROW"/>
		<xsl:param name="HIDE_SIZE_ROW"/>
		<xsl:param name="HIDE_MIN_MAX_ROW"/>
		<xsl:param name="HIDE_RAID_DESC_ROW"/>
		<xsl:param name="HIDE_MEDIA_TYPE_ROW" select="false"/> <!-- new parameter -->
		<xsl:param name="HIDE_BUS_PROTOCOL_TYPE_ROW" select="false"/> <!-- new parameter -->
		<xsl:param name="RULES"/>
		<xsl:param name="SELECT_RAID_HEADER"/>
		<xsl:param name="VD_NAME_LENGTH" select="10"/>
		<xsl:param name="HIDE_SECURE_VD_ROW" select="false"/> <!-- new parameter -->
		<xsl:param name="HIDE_PIENABLED_VD_ROW" select="false"/>
		<xsl:param name="HIDE_SUMMARY_ATTRIBUTES_ROW" select="true"/> <!-- new parameter -->
		<xsl:param name="GLOBAL_VAR_ADVANCED_WIZARD" select="0"/> <!-- new parameter -->
		<xsl:param name="HIDE_SectorSize_TYPE_ROW"/>
		<!--xsl:param name="HIDE_PIEnabled_TYPE_ROW"/--><!--Uncomment for PI feature-->
               
		<TableData name="T">
                    
                    
                   <xsl:choose> 
                                <xsl:when test="$HIDE_SUMMARY_ATTRIBUTES_ROW != 'true' ">  <!-- Summary Page display -->
                                       <SubHeader><xsl:attribute name="display"><xsl:value-of select="$strPromptTextVDAttribsCVDAS"/></xsl:attribute></SubHeader>
			 	       <Header><Data value="{$strAttributeCVDAS}" width="400"/><Data value="{$strValueCVDAS}"/></Header>
                                        
				          <Row>
-					            <Data value="{$strTypeCVDAS}" name="RaidLevel"/>
-					               <Data name="RaidLevelValue">
						             <xsl:attribute name="value"><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType"><xsl:value-of select="/OMA/Layout"/></xsl:with-param></xsl:call-template></xsl:attribute>
 					                  </Data>
-				          </Row>
				          <xsl:if test="/OMA/CreateSecureVD = '1' ">
                                            <Row>
					           <Data value="{$strSecuredVirtualDisk}" name="SecureVD"/>
					                 <Data name="SecureVDValue">
                                                                 <xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
                                                        </Data>
			 	            </Row>
                                          </xsl:if>
				         
				            <Row>
					            <Data value="{$strType}" name="Protocol"/>
					                 <Data name="ProtocolValue">
						             <xsl:attribute name="value"><xsl:call-template name="GetBusProtocol"><xsl:with-param name="Bus"><xsl:value-of select="//ArrayDisks/PassThruResponse/DCStorageObject/BusProtocol"/></xsl:with-param></xsl:call-template></xsl:attribute>
 					                  </Data>
				            </Row>
				          <xsl:if test="/OMA/SectorSize != 'null' and (/OMA/SectorSize != '0' or /OMA/SectorSize != '-1') ">
                                <Row>
					                <Data value="{$strSectorSize}" name="sectorSize"/>
					                 <Data name="sectorSizeValue">
						             <xsl:attribute name="value"><xsl:call-template name="GetSectorSize"><xsl:with-param name="SectorSize"><xsl:value-of select="/OMA/SectorSize"/></xsl:with-param></xsl:call-template></xsl:attribute>
 					                  </Data>
				            </Row>
                           </xsl:if>
				        <xsl:if test="/OMA/VdPIEnabled = '1' ">
                        <Row>
					<Data value="{$strT10PICapable}" name="T10PIInformation"/>
					<Data name="VdPIEnabledValue">
                                 <xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
                              </Data>
				</Row>
                        </xsl:if>
				        
                                 
                             </xsl:when>
                             <xsl:when test="$GLOBAL_VAR_ADVANCED_WIZARD = '1'">
                                 
                                       <Header><Data value="{$SELECT_RAID_HEADER}" align="left" noborderright="true" /><Data/><Data/></Header>
                                       <Row><Data name="AdvancedWizard" type="radio" value="{$strAdvancedCVDARLS}" returnvalue="{$GLOBAL_VAR_ADVANCED_WIZARD}" handler="javascript:OnAdvancedWizardSelected()" width="50%" event="onclick" state="0" noborderright="true" colspan="3"/></Row>
									   
			
                            </xsl:when>
                 </xsl:choose>
                       
                 <!--xsl:if test="$HIDE_SECURE_VD_ROW != 'true'">
                	 Row>
				   		<Data value="{$strSecuredVD}" width="50%" spans="2" noborderright="true"/>
						<Data type="select" handler="OnElementSelected(this)" event="onchange" name="SecureVDFilter" width="100" align="left" noborderright="true">				    
										 <Choice default="true">
							   <xsl:attribute name="value"><xsl:value-of select="$strTblHeaderCVDSecureVD"/></xsl:attribute>
							   <xsl:attribute name="returnvalue">-1</xsl:attribute>
							</Choice>
							<xsl:call-template name="DisplayCreateVDFilters">							
									<xsl:with-param name="templateName" select="3"/>
							</xsl:call-template>

						</Data>
						<Data/>
				</Row>	
			</xsl:if-->
			<xsl:if test="$HIDE_PIENABLED_VD_ROW != 'true'">
                	<Row>
				   		<Data value="{$strVDTypeSelect}" width="50%" spans="2" noborderright="true"/>
						<Data type="select" handler="OnElementSelected(this)" event="onchange" name="VDTypeFilter" width="100" align="left" noborderright="true">				    
										 <Choice default="true">
							   <xsl:attribute name="value"><xsl:value-of select="$strTblHeaderCVDSecureVD"/></xsl:attribute>
							   <xsl:attribute name="returnvalue">-1</xsl:attribute>
							</Choice>
							<xsl:call-template name="DisplayCreateVDFilters">							
									<xsl:with-param name="templateName" select="3"/>
							</xsl:call-template>

						</Data>
						<Data/>
				</Row>	
			</xsl:if>
                     

                                              <xsl:if test="$HIDE_RAID_DESC_ROW != 'true'">
			<Row>  
				<Data value="{$strTypeCVDU}" width="50%" spans="2" noborderright="true"/>
				<!-- In case of Intelligent mirron enabled and BitType 512 then template RenderAdvancedCheckBox will render check box else this code will render empty table column (<td>) :BITS072081 -->
				<Data type="select" handler="OnElementSelected(this);" event="onchange" name="VDLayout" width="100" align="left" noborderright="true">
				
				
				 <xsl:variable name="LocalControllerAttributesMask"><xsl:value-of select="//OMA/Controllers/DCStorageObject/AttributesMask"/></xsl:variable>
				
				<xsl:if test="substring($LocalControllerAttributesMask,11,1) ='0'">
					<xsl:attribute name="colspan">2</xsl:attribute>
				</xsl:if>

				    <Choice default="true">
				       <xsl:attribute name="value"><xsl:value-of select="$strSelectRAID"/></xsl:attribute>
				       <xsl:attribute name="returnvalue">-1</xsl:attribute>
			        </Choice>
					<xsl:call-template name="for-loop">
						<xsl:with-param name="AdvancedWizard" select="$HIDE_SIZE_ROW"/>
						<xsl:with-param name="Mask" select="$RAIDMask"/>
						<xsl:with-param name="RULES" select="$RULES"/>
					</xsl:call-template>
				</Data>
			
			<xsl:call-template name="for-loop-adv-checkbox">
						<xsl:with-param name="AdvancedWizard" select="$HIDE_SIZE_ROW"/>
						<xsl:with-param name="Mask" select="$RAIDMask"/>
						<xsl:with-param name="RULES" select="$RULES"/>
			</xsl:call-template>
			</Row>	
                  

			</xsl:if>
			
                  <xsl:if test="$HIDE_BUS_PROTOCOL_TYPE_ROW != 'true'">
                        
				<Row>
				<Data value="{$strBusProtocolType}" width="50%" noborderright="true"/>
				<Data type="select" handler="OnElementSelected(this)" event="onchange" name="BusProtocolFilter" width="100" align="left" noborderright="true">
				    <Choice default="true">
				       <xsl:attribute name="value"><xsl:value-of select="$strSelectBusProtocolType"/></xsl:attribute>
				       <xsl:attribute name="returnvalue">-1</xsl:attribute>
			        </Choice>
					<xsl:call-template name="DisplayCreateVDFilters">
							<xsl:with-param name="Mask" select="$PROTOCOLMask"/>
							<xsl:with-param name="templateName" select="2"/>
					</xsl:call-template>

				</Data><Data/>
			</Row>	
			</xsl:if>

                  <xsl:if test="$HIDE_MEDIA_TYPE_ROW != 'true'">
                         
				<Row>
				<Data value="{$strMediaType}" width="50%" noborderright="true"/>
				<Data type="select" handler="OnElementSelected(this)" event="onchange" name="MediaTypeFilter" width="100" align="left" noborderright="true">
				    <Choice default="true">
				       <xsl:attribute name="value"><xsl:value-of select="$strSelectMediaType"/></xsl:attribute>
				       <xsl:attribute name="returnvalue">-1</xsl:attribute>
			        </Choice>
					<xsl:call-template name="DisplayCreateVDFilters">
							<xsl:with-param name="Mask" select="$MEDIAMask"/>
							<xsl:with-param name="templateName" select="1"/>
					</xsl:call-template>

				</Data><Data/>
			</Row>	
			</xsl:if>
                     
                   <xsl:if test="$HIDE_SectorSize_TYPE_ROW != 'true'">        
			  <Row>
				<Data value="Sector Size" width="50%" noborderright="true"/>
			
				<Data type="select" handler="OnElementSelected(this)" event="onchange" name="SectorTypeFilter" width="100" align="left" noborderright="true">
				    <Choice default="true">
				       <xsl:attribute name="value"><xsl:value-of select="$strSelectSectorSize"/></xsl:attribute>
				       <xsl:attribute name="returnvalue">-1</xsl:attribute>
			        </Choice>
					
					  <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$str512"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">512</xsl:attribute>
                       </Choice>
                       <Choice>
     		                <xsl:attribute name="value"><xsl:value-of select="$str4K"/></xsl:attribute>
 		     		    <xsl:attribute name="returnvalue">4096</xsl:attribute>
                       </Choice> 
                    

				</Data><Data/>
			</Row>
</xsl:if> 
<!--Uncomment for PI feature-->   
 <!--xsl:if test="$HIDE_PIEnabled_TYPE_ROW != 'true'">  
   <Row>
   <Data name="PIEnabledFilter" type="checkbox" value="T10 Protection Information enabled" handler="javascript:OnElementSelected(this)" width="50%" event="onClick" state="0" noborderright="true" colspan="3">
   <xsl:attribute name="state">0</xsl:attribute>
  <xsl:attribute name="returnvalue">0</xsl:attribute>
						
   </Data>
   </Row>
   </xsl:if-->   
   	
		
			<xsl:if test="$HIDE_NAME_ROW != 'true' ">
				<Row>
					<Data value="{$strNameCVDU}"/>
					<Data name="VDName" type="editbox" colspan="1" maxlength="{$VD_NAME_LENGTH}" returnvalue="0"/>
				</Row>
			</xsl:if>
			<xsl:if test="$HIDE_SIZE_ROW != 'true' ">
				<Row>
					<Data value="{$strSizeCVDU}"/>
					<Data name="VDSize" type="editbox" colspan="1" maxlength="7" returnvalue="0">
						<xsl:attribute name="unit"><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute></Data>
				</Row>
			</xsl:if>
			<xsl:if test="$HIDE_MIN_MAX_ROW != 'true' ">
				<Row>
					<Data name="Min" value="{$strMinSizeZeroCVDU}" />
					<Data name="Max" value="{$strMaxSizeZeroCVDU}" />
				</Row>
			</xsl:if>
			<xsl:if test="$STRIPESMask != ''">
				<Row>
					<Data value="{$strStripeSizeCVDU}"/>
					<Data name="StripeSize" type="select">
						<xsl:call-template name="for-loop-list-box">
							<xsl:with-param name="Mask" select="$STRIPESMask"/>
							<xsl:with-param name="templateName" select="1"/>
						</xsl:call-template>
					</Data>
				</Row>
			</xsl:if>
			<xsl:if test="$READMask != ''">
				<Row>
					<Data value="{$strReadPolicyCVDU}"/>
					<Data name="ReadPolicy" type="select">
						<xsl:call-template name="for-loop-list-box">
							<xsl:with-param name="Mask" select="$READMask"/>
							<xsl:with-param name="Default" select="$DEFAULTReadPolicy"/>
							<xsl:with-param name="templateName" select="2"/>
						</xsl:call-template>
					</Data>
				</Row>
			</xsl:if>
			<xsl:if test="$WRITEMask != ''">
				<Row>
					<Data value="{$strWritePolicyCVDU}"/>
					<Data name="WritePolicy" type="select">
						<xsl:call-template name="for-loop-list-box">
							<xsl:with-param name="Mask" select="$WRITEMask"/>
							<xsl:with-param name="Default" select="$DEFAULTWritePolicy"/>
							<xsl:with-param name="templateName" select="3"/>
						</xsl:call-template>
					</Data>
				</Row>
			</xsl:if>
			<xsl:if test="$CACHEMask != ''">
				<Row>
					<Data value="{$strCachePolicyCVDU}"/>
					<Data name="CachePolicy" type="select">
						<xsl:call-template name="for-loop-list-box">
							<xsl:with-param name="Mask" select="$CACHEMask"/>
							<xsl:with-param name="templateName" select="4"/>
						</xsl:call-template>
					</Data>
				</Row>
			</xsl:if>
	        <xsl:if test="(substring($CntrlAttributesMask,13,1) != '1') and ($DISKCACHEMask != '')">
				<Row>
					<Data value="{$strDiskCachePolicyCVDU}"/>
					<Data name="DiskCachePolicy" type="select">
						<xsl:call-template name="for-loop-list-box">
							<xsl:with-param name="Mask" select="$DISKCACHEMask"/>
							<xsl:with-param name="templateName" select="20"/>
						</xsl:call-template>
					</Data>
				</Row>
			</xsl:if>
			
                                       
		</TableData>
	</xsl:template>
	<xsl:template name="RenderVDConfigTable">
		<xsl:param name="KEY_NAME_VDNODES"/>
		<xsl:param name="KEY_MATCH_VDNODES"/>
		<xsl:param name="CONTROLLER_NAME"/>
		<xsl:param name="KEY_NAME_ADNODES"/>
		<TableData>
			<!-- RS - DFCT155243/CHNG129635: Add Existing RAID configuration section and change text type to Array disk -->
			<!-- Main header -->
			<Header>
				<Data value="{$strExistingRaidCVDU}" colspan="6" align="center"/>
			</Header>
			<!-- Sub header -->
			<Header>
				<!-- AS - DF54481: Aligning Header to look like DSA. Removing Empty cell. -->
				<!-- AS - CR30001: Add Status of existing virtual disk  -->
				<Data value="{$strStatus}"/>
				<Data value="{$strVirtualDiskCVDU}"/>
				<Data value="{$strType}"/>
				<Data value="{$strDeviceCVDU}"/>
				<Data value="{$strLevelCVDU}"/>
				<Data value="{$strSizeCVDU}"/>
				<Data value="{$strArrayDiskIDCVDU}"/>
			</Header>
			<xsl:for-each select="key($KEY_NAME_VDNODES,$KEY_MATCH_VDNODES)/DCStorageObject[not(ParentVDID)]">
					<xsl:call-template name="RenderVDConfigInfo">
						<xsl:with-param name="LOGICAL_DRIVE_NUM"><xsl:value-of select="LogicalDriveNum"/></xsl:with-param>
						<xsl:with-param name="CONTfROLLER_NAME"><xsl:value-of select="$CONTROLLER_NAME"/></xsl:with-param>
						<xsl:with-param name="BUSPROTOCOL"><xsl:value-of select="BusProtocol"/></xsl:with-param>
						<xsl:with-param name="LAYOUT"><xsl:value-of select="Layout"/></xsl:with-param>
						<xsl:with-param name="LENGTH"><xsl:value-of select="Length"/></xsl:with-param>
						<xsl:with-param name="KEY_NAME"><xsl:value-of select="$KEY_NAME_ADNODES"/></xsl:with-param>
						<xsl:with-param name="KEY_MATCH">Virtual Disk <xsl:value-of select="LogicalDriveNum"/></xsl:with-param>
					</xsl:call-template>
			</xsl:for-each>
		</TableData>
	</xsl:template>
	<xsl:template name="RenderVDConfigInfo">
		<xsl:param name="LOGICAL_DRIVE_NUM"/>
		<xsl:param name="CONTROLLER_NAME"/>
		<xsl:param name="BUSPROTOCOL"/>
		<xsl:param name="LAYOUT"/>
		<xsl:param name="LENGTH"/>
		<xsl:param name="KEY_NAME"/>
		<xsl:param name="KEY_MATCH"/>
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Row>
			<!-- AS - DF54481: Aligning Row to look like DSA. Removing Empty cell. -->
			<!-- AS - CR30001: Add Status of existing virtual disk  -->
			<!-- AS - DF54481: Removing the align center option for Status icon.  -->
			<Data type="status">
				<xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value"><xsl:value-of select="$LOGICAL_DRIVE_NUM"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value"><xsl:call-template name="GetBusProtocol"><xsl:with-param name="Bus"><xsl:value-of select="$BUSPROTOCOL"/></xsl:with-param></xsl:call-template></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value"><xsl:value-of select="$CONTROLLER_NAME"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value"><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType"><xsl:value-of select="$LAYOUT"/></xsl:with-param></xsl:call-template></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="$LENGTH"/></xsl:with-param></xsl:call-template> <xsl:value-of select="$strGBUnitCVDU"/>
				</xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value">
					<xsl:for-each select="key($KEY_NAME, $KEY_MATCH)/DCStorageObject">
						<xsl:variable name="DiskInEnclosure">
							<xsl:call-template name="IsDiskInEnclosure">
								<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
								<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/><xsl:if test="position()!=last()"><xsl:text>, </xsl:text></xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/><xsl:if test="position()!=last()"><xsl:text>, </xsl:text></xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
	<xsl:template name="RenderResultTableParentRow">
		<xsl:param name="PARENT_NAME"/>
		<xsl:param name="CHILD_NAME_PREFIX"/>
		<xsl:param name="DISPLAY_NAME"/>
		<xsl:param name="RULES"/>
		<xsl:param name="KEY_NAME"/>
		<xsl:param name="KEY_MATCH"/>
		<xsl:param name="DISPLAY_ZERO_FREESPACE_AD"/>
		<xsl:param name="SPAN_MODE"/>
		<xsl:param name="HIDE_DHS" select="0"/>
		<!--ACTIVE_DISK_PROTOCOL has 4th, 7th, 8th bit set based on the protocols supported when this template is called from createVD page-->
		<!--ACTIVE_DISK_PROTOCOL is not set when called from reconfig page and hence gets initialized to 0 below-->
		<!--xsl:param name="ACTIVE_DISK_PROTOCOL" select="0"/-->
		<!-- DF42943 01/13/2006: Adding a flag for reconfigure because reconfigure should receive disks that have smart alerts -->
		<xsl:param name="ALLDISKS"/>
		<xsl:param name="CLEAR_FOREIGN_CONFIGENABLE"/>
		<xsl:param name="MIN_DRIVES_FOR_SELECTED_LAYOUT" select="0"/>
                <xsl:param name="FreeDisks" select="0"/>
                <xsl:param name="SpanEditMode">false</xsl:param>
		
    <Row tree="expand" name="{$PARENT_NAME}">
			<ColumnData>
				<xsl:choose>
					<xsl:when test="$SPAN_MODE = 'true' ">
						<Data type="checkbox" colspan="2">
							<xsl:attribute name="name"><xsl:value-of select="$DISPLAY_NAME"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$DISPLAY_NAME"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$DISPLAY_NAME"/></xsl:attribute>
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:OnDeleteSpan('<xsl:value-of select="$DISPLAY_NAME"/>')</xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data colspan="2" value="{$DISPLAY_NAME}"/>
					</xsl:otherwise>
				</xsl:choose>
			</ColumnData>
			<ChildrenRows>
				<xsl:for-each select="key($KEY_NAME,$KEY_MATCH)/DCStorageObject">
					<xsl:sort select="Channel" data-type="number" order="ascending"/>
					<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
					<xsl:sort select="TargetID" data-type="number" order="ascending"/>

          <xsl:variable name="isEnoughDisk">
            <xsl:choose>
              <xsl:when test="substring(AttributesMask,21,1)='1'">0</xsl:when>
              <xsl:when test="($RULES = '1') or (VendorID = '1')">1</xsl:when>
              <xsl:when test="(UsedSpace != 0) or ($FreeDisks &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT)">1</xsl:when>
              <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>

          <xsl:variable name="isDHS">
						<!-- check to see if current disk is DHS -->
						<xsl:call-template name="IsDedicatedHotSpare">
							<xsl:with-param name="AttributesMask">
								<xsl:value-of select="AttributesMask"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>

					<!-- Chethan 11/15/04: Added to fix DFCT126643-->
					<xsl:variable name="AD_STATE">
						<!-- Get the current disk state -->
						<xsl:value-of select="ObjState"/>
					</xsl:variable>
					<xsl:variable name="AD_STATUS">
						<!-- Get the current disk status -->
						<xsl:value-of select="ObjStatus"/>
					</xsl:variable>
                                        
                                        <!-- drawback of Getcaps covered in UI for 6.1 only going forward Getcaps has to return only those disks which qualify for raid creation and this code needs to be removed along with its condition for isenough disk-->-->
					
					<!-- To fix DF133160 -->
					<xsl:variable name="clearDiskAllowed">
						<xsl:choose>
							<xsl:when test="($AD_STATE = '549755813888') and (ArrayNum != '')">1</xsl:when>
							<xsl:otherwise>0</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

					

					<!-- In DSA mode if there are any foreign drives, allow/keep them for RAID configuration based on User inputs -->
					<xsl:variable name="DSAFOREIGNCLEAR">
					<xsl:choose>
					<xsl:when test="$ALLDISKS!='1' and $RULES = '1' and $AD_STATE = '274877906944' and $CLEAR_FOREIGN_CONFIGENABLE='1'">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
					</xsl:variable>

					<xsl:variable name="ACTIVE_CONTROLLER_PROTOCOL"><xsl:value-of select="//Controllers/DCStorageObject/BusProtocol"/></xsl:variable>
					<!-- In DSA mode if there are any drives in resynching (rebuild) state, allow/keep them for RAID configuration -->
					<!-- Only applicable for SAS 5/IR. Getcaps filters out based on model number -->
					<xsl:variable name="DSAREBUILDSTATE">
					<xsl:choose>
					<xsl:when test="$ALLDISKS!='1' and $RULES = '1' and $AD_STATE = '8388608' and $ACTIVE_CONTROLLER_PROTOCOL='8'">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
					</xsl:variable>

					<xsl:variable name="eSATADisk">
						<xsl:choose>
							<xsl:when test="substring(AttributesMask,14,1) = '1'">1</xsl:when>
							<xsl:otherwise>0</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

					<xsl:choose>
						<!-- IMPORTANT: The first condition to be checked must be whether the row
						     should be hidden because it is a DHS (dedicated hotspare) and whether
						     we should be checking for DHS. Therefore this condition must always
						     be the first to be checked. -->
						<xsl:when test="$HIDE_DHS='1' and $isDHS='1'"><!-- DO NOTHING --></xsl:when>
						<!--ACTIVE_DISK_PROTOCOL != 0 for createVD case only. When this template is called from reconfig page, this value will be 0.-->
						<!--Continue normal processing for reconfig case-->
						<!--xsl:when test="$ACTIVE_DISK_PROTOCOL = '0' " ></xsl:when-->


						<!-- Filtering out disks that are not ready and not online and in not OK status. Fix for DFCT126643, DF28585 -->
            <!-- DF128929 - allow disks in rebuilding state -->
						<!-- Not applicable for Reconfigure -->
						<xsl:when test="($isEnoughDisk != '1') or ($eSATADisk != '0') or ($ALLDISKS != '1' and $DSAFOREIGNCLEAR='0' and $DSAREBUILDSTATE='0' and $clearDiskAllowed != '1' and (($AD_STATUS != '2' and $AD_STATUS != '3') or ($AD_STATE != '1' and $AD_STATE != '4' and $AD_STATE != '8388608')))">
							<!-- DO NOTHING -->
						</xsl:when>

						<xsl:when test="$RULES='1'">
							<xsl:call-template name="RenderArrayDiskResultRow">
								<xsl:with-param name="ArrayDiskSpace"><xsl:value-of select="Length"/></xsl:with-param>
								<xsl:with-param name="PrefixName"><xsl:value-of select="$CHILD_NAME_PREFIX"/></xsl:with-param>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$DISPLAY_ZERO_FREESPACE_AD='1'">
							<xsl:call-template name="RenderArrayDiskResultRow">
								<xsl:with-param name="ArrayDiskSpace"><xsl:value-of select="ContiguousFree"/></xsl:with-param>
								<xsl:with-param name="PrefixName"><xsl:value-of select="$CHILD_NAME_PREFIX"/></xsl:with-param>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<!--Filter array disks with zero freespace-->
							<!-- DFCT139044 - Indravijay J. Gohil GUI:Adisk with no free space is listed in CreateVD wizard on PERC /2QC -->
							<!-- Using hash variable  for comparison to make sure a adisk with >= .01g is shown -->
							<xsl:if test="ContiguousFree >= $MinDriveSpace">
								<xsl:call-template name="RenderArrayDiskResultRow">
									<xsl:with-param name="ArrayDiskSpace"><xsl:value-of select="ContiguousFree"/></xsl:with-param>
									<xsl:with-param name="PrefixName"><xsl:value-of select="$CHILD_NAME_PREFIX"/></xsl:with-param>
								</xsl:call-template>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</ChildrenRows>
		</Row>
	</xsl:template>
	<xsl:template name="RenderArrayDiskResultAndSpanRow">
		<xsl:param name="ArrayDiskSpace"/>
		<xsl:param name="PrefixName"/>
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Row>
			<xsl:choose>
				<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/>:<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
					<SelectDataItem>
					    <!--xsl:if test="PDPowerState != ''">
			            <Data type="icon" name="PDPowerState" columnspacing="true" align="center">
					        <xsl:attribute name="value"><xsl:call-template name="GetPowerStatusIcon"><xsl:with-param name="powerstatus"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
					        <xsl:attribute name="alt"><xsl:call-template name="GetPowerStatusToolTip"><xsl:with-param name="psicon"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
				        </Data>
			            </xsl:if-->
						<Data type="checkbox"  width="180">
							<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDU"/>&#160;<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:OnDelete('<xsl:value-of select="Channel"/>','<xsl:value-of select="EnclosureID"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
						</Data>
					</SelectDataItem>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/>:<xsl:value-of select="Channel"/>:<xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
					<SelectDataItem>
					    <!--xsl:if test="PDPowerState != ''">
			            <Data type="icon" name="PDPowerState" columnspacing="true" align="center">
					        <xsl:attribute name="value"><xsl:call-template name="GetPowerStatusIcon"><xsl:with-param name="powerstatus"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
					        <xsl:attribute name="alt"><xsl:call-template name="GetPowerStatusToolTip"><xsl:with-param name="psicon"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
				        </Data>
			            </xsl:if-->
						<Data type="checkbox"  width="180">
							<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDU"/>&#160;<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:OnDelete('<xsl:value-of select="Channel"/>','<xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
						</Data>
					</SelectDataItem>
				</xsl:otherwise>
			</xsl:choose>
			<ColumnData>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSpace div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute>
				</Data>
			</ColumnData>
                         <ColumnData>
						<Data columnspacing="true" width="150" align="center">
							<xsl:attribute name="value"><xsl:call-template name="PhysicalDiskDescription"><xsl:with-param name="BusProtocol" select="BusProtocol"/><xsl:with-param name="MediaType" select="MediaType"/></xsl:call-template></xsl:attribute>
						</Data>
			 </ColumnData>
		</Row>
	</xsl:template>
	<xsl:template name="RenderArrayDiskResultRow">
		<xsl:param name="ArrayDiskSpace"/>
		<xsl:param name="PrefixName"/>
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
				<Row>
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
					<!--SelectDataItem>
						<Data>
							<xsl:attribute name="value"><xsl:text>Array Disk </xsl:text><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
						</Data>
					</SelectDataItem-->
					<SelectDataItem>
					    <!--xsl:if test="PDPowerState != ''">
			            <Data type="icon" name="PDPowerState" columnspacing="true" align="center">
					        <xsl:attribute name="value"><xsl:call-template name="GetPowerStatusIcon"><xsl:with-param name="powerstatus"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
					        <xsl:attribute name="alt"><xsl:call-template name="GetPowerStatusToolTip"><xsl:with-param name="psicon"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
				        </Data>
			            </xsl:if-->
						<Data type="checkbox"  width="180">
							<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDU"/>&#160;<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:OnDelete('<xsl:value-of select="Channel"/>','<xsl:value-of select="EnclosureID"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
						</Data>
					</SelectDataItem>
					<ColumnData>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSpace div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute>
						</Data>
					</ColumnData>
                                        <ColumnData>
						<Data columnspacing="true" width="150" align="center">
							<xsl:attribute name="value"><xsl:call-template name="PhysicalDiskDescription"><xsl:with-param name="BusProtocol" select="BusProtocol"/><xsl:with-param name="MediaType" select="MediaType"/></xsl:call-template></xsl:attribute>
						</Data>
					</ColumnData>
					<!--ColumnData>
						<Data type="icon" value="/ss/images/delete.gif" event="onclick">
							<xsl:attribute name="handler">javascript:OnDelete("<xsl:value-of select="Channel"/>","<xsl:value-of select="TargetID"/>")</xsl:attribute>
						</Data>
					</ColumnData-->
					<!--ColumnData>
						<Data name="delete" type="icon" value="/ss/images/delete.gif" alt="delete">
							<EventHandler event="onclick">
								<xsl:attribute name="handler">javascript:OnDelete("<xsl:value-of select="Channel"/>","<xsl:value-of select="TargetID"/>")</xsl:attribute>
							</EventHandler>
						</Data>
					</ColumnData-->
				</Row>
			</xsl:when>
			<xsl:otherwise>
				<Row>
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
					<!--SelectDataItem>
						<Data>
							<xsl:attribute name="value"><xsl:text>Array Disk </xsl:text><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
						</Data>
					</SelectDataItem-->
					<SelectDataItem>
					    <!--xsl:if test="PDPowerState != ''">
			            <Data type="icon" name="PDPowerState" columnspacing="true" align="center">
					        <xsl:attribute name="value"><xsl:call-template name="GetPowerStatusIcon"><xsl:with-param name="powerstatus"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
					        <xsl:attribute name="alt"><xsl:call-template name="GetPowerStatusToolTip"><xsl:with-param name="psicon"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
				        </Data>
			            </xsl:if-->
						<Data type="checkbox"  width="180">
							<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDU"/>&#160;<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:OnDelete('<xsl:value-of select="Channel"/>','<xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
						</Data>
					</SelectDataItem>
					<ColumnData>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSpace div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute>
						</Data>
					</ColumnData>
                                        <ColumnData>
						<Data columnspacing="true" width="150" align="center">
							<xsl:attribute name="value"><xsl:call-template name="PhysicalDiskDescription"><xsl:with-param name="BusProtocol" select="BusProtocol"/><xsl:with-param name="MediaType" select="MediaType"/></xsl:call-template></xsl:attribute>
						</Data>
					</ColumnData>
					<!--ColumnData>
						<Data type="icon" value="/ss/images/delete.gif" event="onclick">
							<xsl:attribute name="handler">javascript:OnDelete("<xsl:value-of select="Channel"/>","<xsl:value-of select="TargetID"/>")</xsl:attribute>
						</Data>
					</ColumnData-->
					<!--ColumnData>
						<Data name="delete" type="icon" value="/ss/images/delete.gif" alt="delete">
							<EventHandler event="onclick">
								<xsl:attribute name="handler">javascript:OnDelete("<xsl:value-of select="Channel"/>","<xsl:value-of select="TargetID"/>")</xsl:attribute>
							</EventHandler>
						</Data>
					</ColumnData-->
				</Row>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
        
	<xsl:template name="RenderSelectionTableParentRow">
            <xsl:param name="Channel"/>   
		<xsl:param name="PARENT_NAME"/>
		<xsl:param name="CHILD_NAME_PREFIX"/>
		<xsl:param name="DISPLAY_NAME"/>
		<xsl:param name="RULES"/>
		<xsl:param name="KEY_NAME"/>
		<xsl:param name="KEY_MATCH"/>
		<xsl:param name="DISPLAY_ZERO_FREESPACE_AD"/>
                <xsl:param name="LAYOUT_SELECTED"/>
		<xsl:param name="HIDE_DHS" select="0"/>
		<!--xsl:param name="ACTIVE_DISK_PROTOCOL" select="1"/-->
			<!-- DF42943 01/13/2006: Adding a flag for reconfigure because reconfigure should receive disks that have smart alerts -->
		<xsl:param name="ALLDISKS"/>
		<xsl:param name="CLEAR_FOREIGN_CONFIGENABLE"/>
		<xsl:param name="MIN_DRIVES_FOR_SELECTED_LAYOUT" select="0"/>
                <xsl:param name="FreeDisks" select="0"/>
		<xsl:param name="EnclosureID" select="0"/>
                <xsl:param name="CntrlAttributesMask" select="0"/>
                <xsl:param name="SpanEditMode">false</xsl:param>
                             
               

                <Row tree="expand" name="{$PARENT_NAME}">
			<ColumnData>
                          
				<xsl:choose>
				<xsl:when test="($LAYOUT_SELECTED='512' and $SpanEditMode != 'true') or $LAYOUT_SELECTED='2048' or $LAYOUT_SELECTED='262144'">
					<Data type="checkbox" colspan="2">
						<xsl:attribute name="name">Sel<xsl:value-of select="$Channel"/>:<xsl:value-of select="$EnclosureID"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$DISPLAY_NAME"/></xsl:attribute>
						<xsl:attribute name="returnvalue"><xsl:value-of select="$EnclosureID"/></xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:OnEnclosureSelected('<xsl:value-of select="$Channel"/>','<xsl:value-of select="$EnclosureID"/>')</xsl:attribute>
						<!-- Note: there is a space between tags <xsl:text></xsl:text> in the above line and needs to remain that way for delete span to work. Need to come up with a better idea to fix this.-->
					</Data>
                                 </xsl:when>
                                 <xsl:otherwise>
                            
					<Data colspan="2" value="{$DISPLAY_NAME}"/>
                                 </xsl:otherwise>
                                 </xsl:choose>
			</ColumnData>
			<ChildrenRows>
				<xsl:for-each select="key($KEY_NAME,$KEY_MATCH)/DCStorageObject">
					<xsl:sort select="Channel" data-type="number" order="ascending"/>
					<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
					<xsl:sort select="TargetID" data-type="number" order="ascending"/>

                                      <xsl:variable name="isEnoughDisk">
                                        <xsl:choose>
                                          <xsl:when test="substring(AttributesMask,21,1)='1'">0</xsl:when>
                                          <xsl:when test="($RULES ='1') or (VendorID = '1')">1</xsl:when>
                                          <xsl:when test="(UsedSpace != 0) or ($FreeDisks &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT)">1</xsl:when>
                                          <xsl:otherwise>0</xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:variable>

                                       <xsl:variable name="isDHS">
						<!-- check to see if current disk is DHS -->
						<xsl:call-template name="IsDedicatedHotSpare">
							<xsl:with-param name="AttributesMask">
								<xsl:value-of select="AttributesMask"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<!-- Chethan 11/15/04: Added to fix DFCT126643-->
					<xsl:variable name="AD_STATE">
						<!-- Get the current disk state -->
						<xsl:value-of select="ObjState"/>
					</xsl:variable>
					<xsl:variable name="AD_STATUS">
						<!-- Get the current disk state -->
						<xsl:value-of select="ObjStatus"/>
					</xsl:variable>
					<!-- To fix DF133160 -->
					<xsl:variable name="clearDiskAllowed">
						<xsl:choose>
							<xsl:when test="($AD_STATE = '549755813888') and (ArrayNum != '')">1</xsl:when>
							<xsl:otherwise>0</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
                                        
					<xsl:variable name="ACTIVE_CONTROLLER_PROTOCOL"><xsl:value-of select="//Controllers/DCStorageObject/BusProtocol"/></xsl:variable>
					<!-- In DSA mode if there are any foreign drives, allow/keep them for RAID configuration based on User inputs -->
					<xsl:variable name="DSAFOREIGNCLEAR">
					<xsl:choose>
					<xsl:when test="$ALLDISKS!='1' and $RULES = '1' and $AD_STATE = '274877906944' and $CLEAR_FOREIGN_CONFIGENABLE='1'">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
					</xsl:variable>

					<!-- In DSA mode if there are any drives in resynching (rebuild) state, allow/keep them for RAID configuration -->
					<!-- Only applicable for SAS 5/IR. Getcaps filters out based on model number -->
					<xsl:variable name="DSAREBUILDSTATE">
					  <xsl:choose>
					      <xsl:when test="$ALLDISKS!='1' and $RULES = '1' and $AD_STATE = '8388608' and $ACTIVE_CONTROLLER_PROTOCOL='8'">1</xsl:when>
					      <xsl:otherwise>0</xsl:otherwise>
					  </xsl:choose>
					</xsl:variable>
					

					<xsl:variable name="eSATADisk">
						<xsl:choose>
							<xsl:when test="substring(AttributesMask,14,1) = '1'">1</xsl:when>
							<xsl:otherwise>0</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
                                       
					<xsl:choose>
						<!-- IMPORTANT: The first condition to be checked must be whether the row
						     should be hidden because it is a DHS (dedicated hotspare) and whether
						     we should be checking for DHS. Therefore this condition must always
						     be the first to be checked. -->
						<xsl:when test="$HIDE_DHS='1' and $isDHS='1'"></xsl:when>

						<!--ACTIVE_DISK_PROTOCOL != 0 for createVD case only. When this template is called from reconfig page, this value will be 0.-->
						<!--Continue normal processing for reconfig case-->
						<!--xsl:when test="$ACTIVE_DISK_PROTOCOL = '0' " ></xsl:when-->
                                               
						<!-- Filtering out disks that are not ready or not online. Fix for DFCT126643 -->
						<!-- Not applicable for reconfigure -->
            <!-- DF128929 - allow disks in rebuilding state -->
            <!-- Allow AD_STATE Ready, Online and Clear -->
						<xsl:when test="($isEnoughDisk != '1') or ($eSATADisk != '0') or ($ALLDISKS != '1' and $DSAFOREIGNCLEAR='0' and $DSAREBUILDSTATE='0' and $clearDiskAllowed != '1' and (($AD_STATUS != '2' and $AD_STATUS != '3') or ($AD_STATE != '1' and $AD_STATE != '4' and $AD_STATE != '8388608'))) "><!-- DO NOTHING --></xsl:when>


						<xsl:when test="$RULES='1'">
                                                     
							<xsl:call-template name="RenderArrayDiskSelectionRow">
								<xsl:with-param name="ArrayDiskSpace"><xsl:value-of select="Length"/></xsl:with-param>
								<xsl:with-param name="PrefixName"><xsl:value-of select="$CHILD_NAME_PREFIX"/></xsl:with-param>
							</xsl:call-template>
                                                       
						</xsl:when>
						<xsl:when test="$DISPLAY_ZERO_FREESPACE_AD='1'">
                                                    
							<xsl:call-template name="RenderArrayDiskSelectionRow">
								<xsl:with-param name="ArrayDiskSpace"><xsl:value-of select="ContiguousFree"/></xsl:with-param>
								<xsl:with-param name="PrefixName"><xsl:value-of select="$CHILD_NAME_PREFIX"/></xsl:with-param>
							</xsl:call-template>
                                                        
						</xsl:when>
						<xsl:otherwise>
                                                        
							<!--Filter array disks with zero freespace-->
							<!-- DFCT139044 - Indravijay J. Gohil GUI:Adisk with no free space is listed in CreateVD wizard on PERC /2QC -->
							<!-- Using hash variable  for comparison to make sure a adisk with >= .01g is shown -->
							<xsl:if test="ContiguousFree >= $MinDriveSpace ">
                                                            
								<xsl:call-template name="RenderArrayDiskSelectionRow">
									<xsl:with-param name="ArrayDiskSpace"><xsl:value-of select="ContiguousFree"/></xsl:with-param>
									<xsl:with-param name="PrefixName"><xsl:value-of select="$CHILD_NAME_PREFIX"/></xsl:with-param>
								</xsl:call-template>
							</xsl:if>
                                                         
						</xsl:otherwise>
					</xsl:choose>

				</xsl:for-each>
			</ChildrenRows>
		</Row>
	</xsl:template>
	<xsl:template name="RenderArrayDiskSelectionRow">
		<xsl:param name="ArrayDiskSpace"/>
		<xsl:param name="PrefixName"/>
         
				<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Row>
			<xsl:choose>
				<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<SelectDataItem>
			    <!--xsl:if test="PDPowerState != ''">
			      <Data type="icon" name="PDPowerState" columnspacing="true" align="center">
					<xsl:attribute name="value"><xsl:call-template name="GetPowerStatusIcon"><xsl:with-param name="powerstatus"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
					<xsl:attribute name="alt"><xsl:call-template name="GetPowerStatusToolTip"><xsl:with-param name="psicon"><xsl:value-of select="PDPowerState"/></xsl:with-param></xsl:call-template></xsl:attribute>
				  </Data>
			   </xsl:if-->
				<Data type="checkbox"  width="180">
					<xsl:choose>
						<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
							<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDU"/>&#160;<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDU"/>&#160;<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="event">onClick</xsl:attribute>
					<xsl:choose>
						<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
							<xsl:attribute name="handler">javascript:OnArrayDiskSelected('<xsl:value-of select="Channel"/>','<xsl:value-of select="EnclosureID"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="handler">javascript:OnArrayDiskSelected('<xsl:value-of select="Channel"/>','<xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Data>
			</SelectDataItem>
			<ColumnData>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSpace div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/> (<xsl:value-of select="$strFreeCVDU"/>)</xsl:attribute>
				</Data>
			</ColumnData>
                        <ColumnData>
						<Data columnspacing="true" width="150" align="center">
							<xsl:attribute name="value"><xsl:call-template name="PhysicalDiskDescription"><xsl:with-param name="BusProtocol" select="BusProtocol"/><xsl:with-param name="MediaType" select="MediaType"/></xsl:call-template></xsl:attribute>
						</Data>
		        </ColumnData>
		</Row>
	</xsl:template>

	<xsl:template name="GetLocalDecSeparator">
		<xsl:choose>
			<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,</xsl:when>
			<xsl:otherwise>.</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="getCommonScripts">
				var JS_GLOBAL_UnivDecSeparator=".";
				var JS_GLOBAL_LocalDecSeparator="<xsl:call-template name="GetLocalDecSeparator"/>";
							var CREATE_VD_COMBINATIONS = new Array();
						
							var i=0;
							var GLOBAL_VAR_SAS_SAS_MixProtocolValueInDecimal = 384;
							var GLOBAL_VAR_HDD_SSD_MEDIA = 3;
							var GLOBAL_VAR_512_4K_SECTORS = 4608;
						//	var GLOBAL_VAR_PI_Mixed = 3; <!--Uncomment for PI feature-->
						
							var AdvancedWizardParams = new Array();
							var AdvancedWizardObjArray= new Array();
                            
                            // adding flag to check if only one of the following is available and not more than one
                            // 1. //PISecureExpressResults/DCStorageObject
                            // 2. //PIExpressResults/DCStorageObject
                            // 3. //SecureExpressResults/DCStorageObject
                            // 4. //ExpressResults/DCStorageObject
                            // Note: Adding flag at the top to avoid reading the xml again to set it when it is required
                            var DefaultVDTypeFromXMLTag = -1;
                            
							<xsl:for-each select="//ExpressResults/DCStorageObject">
								<xsl:if test="Layout and Layout != ''">
									CREATE_VD_COMBINATIONS[i]  = new Array();


									CREATE_VD_COMBINATIONS[i][0] =  new VDCombObject("VDTypeFilter","4");// 0 is the value for Nonsecure vd flag.. Because express result send the super set of result, it 's not possible to use "SecureFlag" from "expressResults" here. 
									CREATE_VD_COMBINATIONS[i][1] =  new VDCombObject("VDLayout","<xsl:value-of select="Layout"/>");
									CREATE_VD_COMBINATIONS[i][2] = new VDCombObject("BusProtocolFilter","<xsl:value-of select="BusProtocolMask"/>");
									CREATE_VD_COMBINATIONS[i][3] = new VDCombObject("MediaTypeFilter","<xsl:value-of select="MediaTypeMask"/>");
									CREATE_VD_COMBINATIONS[i++][4] = new VDCombObject("SectorTypeFilter","<xsl:value-of select="SectorMask"/>");
									//<!--Uncomment for PI feature-->  CREATE_VD_COMBINATIONS[i++][5] = new VDCombObject("PIEnabledFilter","<xsl:value-of select="VdPIMask"/>");
                                    DefaultVDTypeFromXMLTag = 4;
								</xsl:if>   
							</xsl:for-each>

								
                                <xsl:for-each select="//PIExpressResults/DCStorageObject">
                                     <xsl:if test="Layout and Layout != ''">
                                            CREATE_VD_COMBINATIONS[i]  = new Array();
											
										
											   CREATE_VD_COMBINATIONS[i][0] =  new VDCombObject("VDTypeFilter","2");// 0 is the value for Nonsecure vd flag.. Because express result send the super set of result, it 's not possible to use "SecureFlag" from "expressResults" here. 
                                               CREATE_VD_COMBINATIONS[i][1] =  new VDCombObject("VDLayout","<xsl:value-of select="Layout"/>");
                                               CREATE_VD_COMBINATIONS[i][2] = new VDCombObject("BusProtocolFilter","<xsl:value-of select="BusProtocolMask"/>");
                                               CREATE_VD_COMBINATIONS[i][3] = new VDCombObject("MediaTypeFilter","<xsl:value-of select="MediaTypeMask"/>");
											   CREATE_VD_COMBINATIONS[i++][4] = new VDCombObject("SectorTypeFilter","<xsl:value-of select="SectorMask"/>");
											 //<!--Uncomment for PI feature-->  CREATE_VD_COMBINATIONS[i++][5] = new VDCombObject("PIEnabledFilter","<xsl:value-of select="VdPIMask"/>");
                                            DefaultVDTypeFromXMLTag = 2;
											
                                     </xsl:if>   
                                </xsl:for-each>
                             
                                <xsl:for-each select="//SecureExpressResults/DCStorageObject">
                                          <xsl:if test="Layout and Layout != ''">
											CREATE_VD_COMBINATIONS[i]  = new Array();
											
                                               CREATE_VD_COMBINATIONS[i][0] =  new VDCombObject("VDTypeFilter","3");// 0 is the value for Nonsecure vd flag.. Because express result send the super set of result, it 's not possible to use "SecureFlag" from "expressResults" here. 
                                               CREATE_VD_COMBINATIONS[i][1] =  new VDCombObject("VDLayout","<xsl:value-of select="Layout"/>");
                                               CREATE_VD_COMBINATIONS[i][2] = new VDCombObject("BusProtocolFilter","<xsl:value-of select="BusProtocolMask"/>");
                                               CREATE_VD_COMBINATIONS[i][3] = new VDCombObject("MediaTypeFilter","<xsl:value-of select="MediaTypeMask"/>");
											   CREATE_VD_COMBINATIONS[i++][4] = new VDCombObject("SectorTypeFilter","<xsl:value-of select="SectorMask"/>");
											 //<!--Uncomment for PI feature-->    CREATE_VD_COMBINATIONS[i++][5] = new VDCombObject("PIEnabledFilter","<xsl:value-of select="VdPIMask"/>");
                                             DefaultVDTypeFromXMLTag = 3;
                                          </xsl:if>   
                                </xsl:for-each>
								<xsl:for-each select="//PISecureExpressResults/DCStorageObject">
                                          <xsl:if test="Layout and Layout != ''">
											CREATE_VD_COMBINATIONS[i]  = new Array();
											
                                               CREATE_VD_COMBINATIONS[i][0] =  new VDCombObject("VDTypeFilter","1");// 0 is the value for Nonsecure vd flag.. Because express result send the super set of result, it 's not possible to use "SecureFlag" from "expressResults" here. 
                                               CREATE_VD_COMBINATIONS[i][1] =  new VDCombObject("VDLayout","<xsl:value-of select="Layout"/>");
                                               CREATE_VD_COMBINATIONS[i][2] = new VDCombObject("BusProtocolFilter","<xsl:value-of select="BusProtocolMask"/>");
                                               CREATE_VD_COMBINATIONS[i][3] = new VDCombObject("MediaTypeFilter","<xsl:value-of select="MediaTypeMask"/>");
											   CREATE_VD_COMBINATIONS[i++][4] = new VDCombObject("SectorTypeFilter","<xsl:value-of select="SectorMask"/>");
											 //<!--Uncomment for PI feature-->    CREATE_VD_COMBINATIONS[i++][5] = new VDCombObject("PIEnabledFilter","<xsl:value-of select="VdPIMask"/>");
                                             DefaultVDTypeFromXMLTag = 1;
                                          </xsl:if>   
                                </xsl:for-each>
					   function VDCombObject (elementName,elementValue) {
				
							this.elementName		= elementName;
							this.elementValue		= elementValue;
						
						}
						
                      
                    
                          
                        function DisableAllRaidlevels()
                        {
                            var AllRaidLevels = "";
                            var SEDRaidLevels = "";
                            <xsl:for-each select="//ExpressResults/DCStorageObject">
                                     <xsl:if test="Layout and Layout != ''">
                                        AllRaidLevels += '<xsl:value-of select="Layout"/>'+":";
                                     </xsl:if>   
                            </xsl:for-each>
                            <xsl:for-each select="//SecureExpressResults/DCStorageObject">
                                       <xsl:if test="Layout and Layout != ''">
                                        SEDRaidLevels+='<xsl:value-of select="Layout"/>'+":";
                                        </xsl:if>   
                            </xsl:for-each>
                            var AllRaidLevelsArray = AllRaidLevels.split(":");
                            var SEDRaidLevelsArray = SEDRaidLevels.split(":");  
                           
                            for( var i =0; i &lt;AllRaidLevelsArray.length; i++)
                            {
                                 DisableRaidlevel(AllRaidLevelsArray[i]); 
                            }  
                            for( var i =0; i &lt;SEDRaidLevels.length; i++)
                            {
                                              DisableRaidlevel(SEDRaidLevelsArray[i]); 
                            }                             
                            if(document.getElementById("intMirror")!=null)
                            {
                                document.getElementById("intMirror").checked=false;
                                document.getElementById("intMirror").disabled=true;
                            }
                          } 
                          
                          function EnableValidRaidLevels()
                          {
                             var AllRaidLevels = "";
                             var SEDRaidLevels = "";
							 var PIRaidLevels = "";
							 var PISRaidLevels = "";
                             var ExtraRaidLevels = "";
                           
                            <xsl:for-each select="//ExpressResults/DCStorageObject">
                               <xsl:if test="Layout and Layout != ''">
                                   AllRaidLevels += '<xsl:value-of select="Layout"/>'+":";
                               </xsl:if>   
                            </xsl:for-each>
                            <xsl:for-each select="//SecureExpressResults/DCStorageObject">
                               <xsl:if test="Layout and Layout != ''">
                                 SEDRaidLevels+='<xsl:value-of select="Layout"/>'+":";
                               </xsl:if>   
                            </xsl:for-each>

                            <xsl:for-each select="//PIExpressResults/DCStorageObject">
                               <xsl:if test="Layout and Layout != ''">
                                   PIRaidLevels += '<xsl:value-of select="Layout"/>'+":";
                               </xsl:if>   
                            </xsl:for-each>
							
                            <xsl:for-each select="//PISecureExpressResults/DCStorageObject">
                               <xsl:if test="Layout and Layout != ''">
                                 PISRaidLevels+='<xsl:value-of select="Layout"/>'+":";
                               </xsl:if>   
                            </xsl:for-each>
							
                            var AllRaidLevelsArray = AllRaidLevels.split(":");
								
                            var SEDRaidLevelsArray = SEDRaidLevels.split(":");  
                            var PIRaidLevelsArray = PIRaidLevels.split(":");  
                            var PISRaidLevelsArray = PISRaidLevels.split(":");  
							
							
                            if( getInputVDSelectedType() == 1) 
                            {
								  for( var i =0; i &lt;PISRaidLevelsArray.length; i++)
								  {   
									   enableRaidlevel(PISRaidLevelsArray[i]); 
								  }     
                            }
							else if( getInputVDSelectedType() == 2) 
                            {
								  for( var i =0; i &lt;PIRaidLevelsArray.length; i++)
								  {   
									   enableRaidlevel(PIRaidLevelsArray[i]); 
								  }     
                            }
							else if( getInputVDSelectedType() == 3) 
                            {
								  for( var i =0; i &lt;SEDRaidLevelsArray.length; i++)
								  {   
									   
									   enableRaidlevel(SEDRaidLevelsArray[i]); 
								  }     
                            }
                            else
                            {  
                                           for( var i =0; i &lt;AllRaidLevelsArray.length; i++)
                                            {
                                                   enableRaidlevel(AllRaidLevelsArray[i]); 
                                            }                            
                            }

                          }
						  function getHiddenTableRaidLayoutprefix(VDType)
						  {
						     switch(VDType)
							 {
							 
							    case "1":
								          return "RadioButtonsForRaidLayoutSelection_";
										  
								case "2":
								          return "RadioButtonsForPIRaidLayoutSelection_";
										 
								case "3":
								          return "RadioButtonsForSecureVDRaidLayoutSelection_";
										 
								case "4":
										  return "RadioButtonsForRaidLayoutSelection_";
								default:
										  return "RadioButtonsForRaidLayoutSelection_";
							}
							 
						  
						  }
                          function enableRaidlevel(raidlevel)
                          {
                             var elemNameRaidLevel =  "";
                           
                             if(document.getElementById("ExpressWizard")!=null &amp;&amp; document.getElementById("ExpressWizard").checked ==true )
                             {
                                    elemNameRaidLevel= "ExpressVDLayout";
                             }
                             else
                             {
                                   elemNameRaidLevel= getElementNameForRaidLayout();
                             }
                            
                             var RadioArray = document.getElementById(elemNameRaidLevel).options;
							 
							 var VDType = getInputVDSelectedType();
                             var prefix = getHiddenTableRaidLayoutprefix(VDType);//     "RadioButtonsForRaidLayoutSelection_";
							var postfix = "_HIDDEN_TABLE_DATA";
							 var elemName =prefix+raidlevel+postfix;
						
							 
                            // var SecureVDprefix = "RadioButtonsForSecureVDRaidLayoutSelection_";
                            // var SecureVDelemName = SecureVDprefix+raidlevel+postfix;

                             for( var i =0; i &lt;RadioArray.length; i++)
                             { 
                                         if (RadioArray[i].value == raidlevel &amp;&amp; document.getElementById(elemName) != null )
                                         { 
                                                    RadioArray[i].disabled = false; 
                                         }
                                         /*if (RadioArray[i].value == raidlevel &amp;&amp; document.getElementById(SecureVDelemName) != null )
                                         { 
                                                    RadioArray[i].disabled = false; 
                                         }*/
										  if(-1 ==RadioArray[i].value)
											{
													RadioArray[i].disabled = false; 
											}
                            }    
						
                          }  
                          function enableBusProtocols(BusProtocolsForSelectedRaidLayout)
                          {
                        
						if(BusProtocolsForSelectedRaidLayout ==null)
						      return;
							  
                             var BusProtocolArray = document.getElementById(getElementNameForBusProtocol());
                             
                             if(BusProtocolArray!=null)
                             {
                                        for ( var i=0; i&lt; BusProtocolArray.length; i++)
                                         { 
                                                        if( BusProtocolArray[i].value == BusProtocolsForSelectedRaidLayout)
                                                        {
                                                              BusProtocolArray[i].disabled = false;
                                                        }
                                                        else if( BusProtocolsForSelectedRaidLayout == GLOBAL_VAR_SAS_SAS_MixProtocolValueInDecimal)
                                                        {
                                                             BusProtocolArray[i].disabled = false;                                                        
                                                        }
                                                           
                                         } 
                               }
                          }
                          
                          function enableMediaTypes(MediaTypesForSelectedRaidLayout)
                          {
                                 var MediaTypeArray = document.getElementById(getElementNameForMediaType());
                            
                                 if(MediaTypeArray!=null)
                                  {
                                        for ( var i=0; i&lt; MediaTypeArray.length; i++)
                                         {  
                                                        if( MediaTypeArray[i].value == MediaTypesForSelectedRaidLayout)
                                                        {
                                                              MediaTypeArray[i].disabled = false;
                                                        }
                                                        else if( MediaTypesForSelectedRaidLayout == GLOBAL_VAR_HDD_SSD_MEDIA)
                                                        {
                                                             MediaTypeArray[i].disabled = false;                                                        
                                                        }
                                                           
                                         } 
                                 }
                          }
                          function DisableRaidlevel(raidlevel)
                          {
                            
                              var elemNameRaidLevel =  "";
                              if(document.getElementById("ExpressWizard")!=null &amp;&amp; document.getElementById("ExpressWizard").checked ==true )
                               {
                                      elemNameRaidLevel= "ExpressVDLayout";
                               }
                              else
                               {
                                      elemNameRaidLevel= getElementNameForRaidLayout();
                               }
                                 var RadioArray = document.getElementById(elemNameRaidLevel).options;
                                 var prefix = "RadioButtonsForRaidLayoutSelection_";
                                 var postfix = "_HIDDEN_TABLE_DATA";
                                 var elemName =prefix+raidlevel+postfix;

                                 var SecureVDprefix = "RadioButtonsForSecureVDRaidLayoutSelection_";
                                 var SecureVDelemName = SecureVDprefix+raidlevel+postfix;

                                 for( var i =0; i &lt;RadioArray.length; i++)
                                 {
                                     if (RadioArray[i].value == raidlevel &amp;&amp; document.getElementById(elemName) != null &amp;&amp; document.getElementById(elemName).disabled==false )
                                     { 
                                             RadioArray[i].disabled = true; 
                                     }     
                                     if (RadioArray[i].value == raidlevel &amp;&amp; document.getElementById(SecureVDelemName) != null &amp;&amp; document.getElementById(SecureVDelemName).disabled==false )
                                     { 
                                             RadioArray[i].disabled = true; 
                                     }  
                                 }
                          }
						
						   function ClearAlloptions()
						   {
						     // Iterate through all the elements displayed on page
						     for(var index=0;index &lt;AdvancedWizardParams.length;index++)
							   { // Check which is  the first supported element and enable the options for that element 
							      if(AdvancedWizardObjArray[index].Objsupported == 1)
									{
									  			
												var elemName=AdvancedWizardObjArray[index].htmlName;
							
												if(document.getElementById(elemName)!=null)
												{
														if(document.getElementById(elemName).type=="checkbox") //  if element type is checkbox 
															document.getElementById(elemName).disabled=false;  // enable checkbox
													else
														{var dropdown=document.getElementById(elemName); // if element type is radio button
														
															if(dropdown)
															{
																dropdown.options[0].selected=true;  
																dropdown.options[0].disabled=false;
															}
														}
												}
											
											//	AdvancedWizardObjArray[index].status="enabled";
												//Enable options for the first supported element and exit
												EnableAdvWizElement(null,AdvancedWizardObjArray[index].htmlName,null);
												  break;
									 											
									}
							
							   }
						
						   }
						 
						   function EnableAdvWizElement(selectedElem,nextElement,UserSelectedInputValue)
						   { 
						       switch(nextElement)
                                   {
                                      									 
										 
										 case "VDTypeFilter":  {  
																	
																		EnableVDTypeOptions(); 
																	
																 
																	break;
																 }
										 case "SecureVDFilter":  {  
																	
																		EnableSecureVDOptions(); 
																	
																 
																	break;
																 }
																
										 case "VDLayout": //  Raid Level
														 {    
															EnableValidRaidLevels();											 
															
														 }
														 break;
										
										 case "BusProtocolFilter": 													 
										 case "MediaTypeFilter": 
										 case "SectorTypeFilter": 
										 case "PIEnabledFilter": 
																 {     
																	SetOptionsForSelectedelement(selectedElem,nextElement,UserSelectedInputValue);
																 }
																 break;
										 default:   break;
										
													 
											
									}
						   
						   }
						   
						 // Reset options in elements available below selected element ex. if selected element is busprotocol disable/reset all the options displayed below busprotocol
						   function ClearOptionsForSelectedElement(eleName)
						   {    var tempIndex;
								for( var index=0;index &lt;AdvancedWizardParams.length;index++)
								{
										if(AdvancedWizardObjArray[index].Objsupported == 1)
										{
											if(AdvancedWizardObjArray[index].htmlName == eleName)
											{
												
												ClearOptions(index+1);
												break;
											
											}
										}
								}
								
						   }
						   
													
						   
						   
						     function ClearOptions(nextIndex)
						   {   var dropdown,element;
								 for(var index=nextIndex;index &lt;AdvancedWizardParams.length;index++)
								 {
									 element=document.getElementById(AdvancedWizardObjArray[index].htmlName);
									if(element != null)
											{
												
												if(document.getElementById(AdvancedWizardObjArray[index].htmlName).type=="checkbox")
															document.getElementById(AdvancedWizardObjArray[index].htmlName).disabled=true;
													else
													
												{   dropdown=document.getElementById(AdvancedWizardObjArray[index].htmlName);
												   if(dropdown!=null)
												   {
														for( var i =0; i &lt;dropdown.length; i++)
														{
															//dropdown.options[0].selected=true;
															dropdown.options[i].disabled=true;
														}
													dropdown.options[0].selected=-1;
													dropdown.options[0].disabled=false;
												   }
												}
											}
								 }
						   }
						function SetOptionsForSelectedelement(eleName,nexteleName,layoutValue)// raid,busprot,2
						{
							var i;var j;
                            // if the drop down for VD type is available else default will be picked
							if(getInputVDSelectedType() != -1)
                            {
                                DefaultVDTypeFromXMLTag = getInputVDSelectedType();
                            }
                            
                            
										var colindex=0;
									   // Depending upon secureVd option and raid value selected identify what options of next element should be enabled
										for( i=0;i &lt; CREATE_VD_COMBINATIONS.length ; i++)
										{   
											  if(CREATE_VD_COMBINATIONS[i][0].elementValue== DefaultVDTypeFromXMLTag) // If secureVD value = 0 or -1 then check the supported layout value in expressresult xmlnode else check the layout in secureexpressresult
											    { 
													if(CREATE_VD_COMBINATIONS[i][1].elementValue == getInputRaidLayoutValue())
													{ 													  
													 for(j=2;j&lt;CREATE_VD_COMBINATIONS[i].length;j++)  //setting j=2 since  now excluding raid level and secure VD find next supported element whose options has to be enabled
														{ 
															if(CREATE_VD_COMBINATIONS[i][j].elementName == nexteleName)
															{
																enableValidTypes(CREATE_VD_COMBINATIONS[i][j].elementName,CREATE_VD_COMBINATIONS[i][j].elementValue); // enable the valid options of next supported element
																break; 
															}//end if
														
														} //end for
														
													} //end if
												}//end if
										
										}//end for
								
						
						}
						function EnableSecureVDOptions()
						{
							dropdown=document.getElementById("SecureVDFilter");
							if(dropdown!=null)
							{	for( var i =0; i &lt;dropdown.length; i++)
									dropdown.options[i].disabled=false;
							}
						}
						function EnableVDTypeOptions()
						{
							dropdown=document.getElementById("VDTypeFilter");
							if(dropdown!=null)
							{	for( var i =0; i &lt;dropdown.length; i++)
									dropdown.options[i].disabled=false;
							}
						}
						
						function enableValidTypes(optionName,optionValue) // enable the options for the elements 
						{
							
							 switch(optionName)
                                   {
                                      									 
										 
										 case "SecureVDFilter":   break;
                                         
										 case "VDTypeFilter":   
											break;                                                         
										 
										 case "VDLayout": //  Options Raid Level
															 {    
																
																	EnableValidRaidLevels();
																	
															 }
															 break;
										 case "BusProtocolFilter": //  Options for BusProtocol
															 {     
																enableBusProtocols(optionValue);
																
															 }
															 break;
													 
										 case "MediaTypeFilter": //  Options  for Media Type
															 {     
																enableMediaTypes(optionValue);
															
															 }
															 break;
										 case "SectorTypeFilter": // Options  for Sector Type
															 {     
															   enableSectorTypes(optionValue);
															 
															 }
															 break;
										 case "PIEnabledFilter": // Options  for PI
															 {     
															   
																//enablePIEnabledFlagType(optionValue); <!--Uncomment for PI feature-->
															 }
															 break;
										 default:  // No Options 
                                                    break;
										
													 
											
									}
						   
						
						}
						   function EnableAllOptions(elemName)
						   {  	
								var dropdown=document.getElementById(elemName);
						 
								for(var i=0;i&lt;dropdown.length;i++)
								{
										dropdown.options[i].selected = true;
										dropdown.options[i].disabled = false;
																
								}
                        
						   }
						   
						    
						   function ADWizObject (Objsupported,htmlName,status) {
					
					this.Objsupported		= Objsupported;
					this.htmlName		= htmlName;
					this.status  		= status;
					
					
				}
				function createAdvancedWizardObject(index,Objsupported,htmlName,status)
				{					
					AdvancedWizardObjArray[index]	= new ADWizObject(Objsupported,htmlName,status);
				
						
				}
				
				function createAdvancedWizardParams()
				{
				// Create array of parameters to be displayed on page. 
				// Includes 2 values [ ParamSupportedflag , HTMLelementname ]
				// Depending on ParamSupportedFlag decide to display or not to display the elemet on the page
					
				   AdvancedWizardParams =[    
				              [TYPE_VD_ROW,"VDTypeFilter"],
				              [RAID_LEVEL_ROW,"VDLayout"], 
							  [BUS_PROTOCOL_TYPE_ROW,"BusProtocolFilter"],
							  [MEDIA_TYPE_ROW,"MediaTypeFilter"],
							  [SECTOR_TYPE_ROW,"SectorTypeFilter"]
							
							  ]; 
				   
					 <!--Uncomment for PI feature-->/* AdvancedWizardParams =[    
				  [SECURE_VD_ROW,"SecureVDFilter"],
				  [RAID_LEVEL_ROW,"VDLayout"], 
				  [BUS_PROTOCOL_TYPE_ROW,"BusProtocolFilter"],
				  [MEDIA_TYPE_ROW,"MediaTypeFilter"],
				  [SECTOR_TYPE_ROW,"SectorTypeFilter"],
				  [PI_TYPE_ROW,"PIEnabledFilter"]
				  ];
				  */
									
				
				
				}
                       
						
						
                        function ClearSecureVDOptions()
                        { 
                           
                             var SecureVDArray = document.getElementById(getElementNameForSecureVD());
                             if(SecureVDArray!=null )
                             {
                             
                                        for ( var i=0; i&lt; SecureVDArray.length; i++)
                                        {
                                              SecureVDArray[i].disabled= false;
                                         } 
                              }
                        }
                        
                        function DisableSecureVDOptions()  
                        {
                            var SecureVDArray = document.getElementById(getElementNameForSecureVD());
                            
                             if(SecureVDArray != null)
                             {
                                    for ( var i=0; i&lt; SecureVDArray.length; i++)
                                    {
                                        SecureVDArray[i].disabled = true;
                                     }
                              }
                            
                        }
						function ClearVDTypeOptions()
                        { 
                           
                             var VDTypeArray = document.getElementById(getElementNameForVDType());
                             if(VDTypeArray!=null )
                             {
                             
                                        for ( var i=0; i&lt; VDTypeArray.length; i++)
                                        {
                                              VDTypeArray[i].disabled= false;
                                         } 
                              }
                        }
                        
                        function DisableVDTypeOptions()  
                        {
                            var VDTypeArray = document.getElementById(getElementNameForVDType());
                            
                             if(VDTypeArray != null)
                             {
                                    for ( var i=0; i&lt; VDTypeArray.length; i++)
                                    {
                                        VDTypeArray[i].disabled = true;
                                     }
                              }
                            
                        }

                        function ClearBusProtocolOptions()
                        {
                             var BusProtocolArray = document.getElementById(getElementNameForBusProtocol());
                             if(BusProtocolArray != null)
                             {
                                    for ( var i=0; i&lt; BusProtocolArray.length; i++)
                                    {
                                        BusProtocolArray[i].disabled= false;
                                     } 
                             }
                        }
                       
                        function DisableBusProtocolOptions()
                        {
                            var BusProtocolArray = document.getElementById(getElementNameForBusProtocol());
                            if(BusProtocolArray != null)
                             { 
                                       for ( var i=0; i&lt; BusProtocolArray.length; i++)
                                       {
                                             BusProtocolArray[i].disabled= true;
                                       } 
                                      BusProtocolArray[0].disabled= false;
                                       BusProtocolArray[0].value = '-1';
                             }
                        }

                        function ClearMediaTypeOptions()
                        {
                             var MediaTypeArray = document.getElementById(getElementNameForMediaType());
                             
                             if(MediaTypeArray != null)
                             { 
                                      for ( var i=0; i&lt; MediaTypeArray.length; i++)
                                      {
                                             MediaTypeArray[i].disabled= false;
                                      } 
                               }          

                        }
                       
                        function DisableMediaTypeOptions()
                        {
                             var MediaTypeArray = document.getElementById(getElementNameForMediaType());
                             if(MediaTypeArray != null)
                             { 
                                  for ( var i=0; i&lt; MediaTypeArray.length; i++)
                                  {
                                        MediaTypeArray[i].disabled= true;
                                  }   
                             }
                        }
						
						
                        function AutoSelectBusProtocolValue(Choice)
		        {
			     try
			     {
						var elemName =  getElementNameForBusProtocol();
						var optionsArray=document.getElementById(elemName).options;
                                                if(optionsArray!=null)
                                                {
                                                        for(var i=0; i &lt; optionsArray.length; i++)
                                                        {
                                                                if(Choice==optionsArray[i].value)
                                                                {
                                                                        document.getElementById(elemName).selectedIndex=i;
                                                                        break;
                                                                }
                                                        }
                                                 }       
			       }catch(e){}
			 }
                                
                                function AutoSelectSecureVDValue(Choice)
				{
					try
					{
						var elemName =  getElementNameForSecureVD();
						var optionsArray=document.getElementById(elemName).options;
                                                if(optionsArray!=null)
                                                {
                                                        for(var i=0; i &lt; optionsArray.length; i++)
                                                        {
                                                                if(Choice==optionsArray[i].value)
                                                                 {
                                                                        document.getElementById(elemName).selectedIndex=i;
                                                                        break;
                                                                }
                                                        }
                                                 }   
					}catch(e){}
				}
                                function AutoSelectRaidLayoutValue(Choice)
				{
					try
					{
						var elemName =  getElementNameForRaidLayout();
						var optionsArray=document.getElementById(elemName).options;
                                                if(optionsArray !=null)
                                                {
                                                            for(var i=0; i &lt; optionsArray.length; i++)
                                                            {
                                                                    if(Choice==optionsArray[i].value)
                                                                    {
                                                                            document.getElementById(elemName).selectedIndex=i;
                                                                            break;
                                                                    }
                                                            }
                                                  }
					}catch(e){}
				}
                                
                                 function AutoSelectExpressRaidLayoutValue(Choice)
				{
					try
					{
						var elemName =  "ExpressVDLayout";
						var optionsArray=document.getElementById(elemName).options;
                                                if(optionsArray !=null)
                                                {
                                                        for(var i=0; i &lt; optionsArray.length; i++)
                                                        {
                                                                if(Choice==optionsArray[i].value)
                                                                {
                                                                        document.getElementById(elemName).selectedIndex=i;
                                                                        break;
                                                                }
                                                        }
                                                 }       
					}catch(e){}
				}
                                function AutoSelectMediaTypeValue(Choice)
				{
					try
					{
						var elemName =  getElementNameForMediaType();
						var optionsArray=document.getElementById(elemName).options;
						for(var i=0; i &lt; optionsArray.length; i++)
						{
							if(Choice==optionsArray[i].value)
							{
								document.getElementById(elemName).selectedIndex=i;
								break;
							}
						}
					}catch(e){}
				}
				
				
				function RestoreInputNameFieldToBlank()
				{
					try{
						var elemName = getElementNameForVDName();
						document.getElementById(elemName).value = "";
						return;
					}catch(e){}
				}

				function ConvertToDecValString(locString)
				{
					return locString.replace(/,/g,".");
				}

				function FormatNumber(num,decimalPlaces,bRoundUp)
				{
					if(bRoundUp=="true")
					{
						var temp = num;
						temp *= Math.pow(10,decimalPlaces);
						temp = Math.ceil(temp);
						temp /= Math.pow(10,decimalPlaces);
                                                return temp;
					}
					else
					{
						var temp = num;
						temp *= Math.pow(10,decimalPlaces);
	       				temp = Math.floor(temp );
	       				temp /= Math.pow(10,decimalPlaces);
	       				return temp;
       				}
				}
				function getElementNameForVDName()
				{
					return "VDName";
				}
				function getElementNameForVDSize()
				{
					return "VDSize";
				}
				function getElementNameForRaidLayout()
				{
					return "VDLayout";
				}
                                function getElementNameForSecureVD()
				{
					return "SecureVDFilter";
				}
				function getElementNameForVDType()
				{
					return "VDTypeFilter";
				}
                                 function getElementNameForBusProtocol()
				{
					return "BusProtocolFilter";
				}
                                function getElementNameForMediaType()
				{
					return "MediaTypeFilter";
				} 
				  function getElementNameForSectorType()
				{
					return "SectorTypeFilter";
				} 
				 /* function getElementNameForPI()
				{
					return "PIEnabledFilter";
				} */
				function HandleRaidLayoutNotSelectedError()
				{
					try{
						var strMsg = "<xsl:value-of select="$strSelectRaidLevelCVDU"/>";
						var strError = "<xsl:value-of select="$strError"/>";
						alert(strError + strMsg);
						document.getElementById("VDSize").value="";
					}catch(e){}
				}
				function HandleInputSizeNotSpecifiedError()
				{
					var strMsg = "<xsl:value-of select="$strSpecifyVDSizeCVDU"/>";
					var strError = "<xsl:value-of select="$strError"/>";
					alert(strError + strMsg);
				}
				function HandleInputSizeNotANumberError()
				{
					var strMsg = "<xsl:value-of select="$strVDSizeNotNumberMsgCVDU"/>";
					var strError = "<xsl:value-of select="$strError"/>";
					alert(strError + strMsg);
				}

				// start reconfigure specific code.
				function HandleInputSizeNotANumberErrorForReconfig(expandcapacity)
				{
					var layoutValue=getInputRaidLayoutValue();
					var strMsg = "";
					var strError = "<xsl:value-of select="$strError"/>";
					if (expandcapacity)
					{
						strMsg = "<xsl:value-of select="$strVDSizeNotNumberMsgCVDUforResize"/>";
						alert(strError + strMsg);
					}
					else
					{
						strMsg = "<xsl:value-of select="$strVDSizeNotNumberMsgCVDU"/>";
						alert(strError + strMsg);
						document.getElementById(getElementNameForVDSize()).value=getMaxSizeForGivenLayout(layoutValue,"GB");
					}

				}

				// end reconfig specific code.

				function HandleInputVDNameSizeOutOfRange()
				{
					var strMsg = "<xsl:value-of select="$strVDNameSizeExceedMsgCVDU"/>";
					var strError = "<xsl:value-of select="$strError"/>";
					alert(strError + strMsg);
				}
				function IsRaidLayoutSelected()
				{
					if(getInputRaidLayoutValue()==-1)
						return false;
					return true;
				}
                                function IsSecureVDSelected()
				{
					if(getInputSecureVDValue() ==-1)
						return false;
					return true;
				}
                                function IsBusprotocolSelected()
				{
					if(getInputBusProtocolValue() ==-1)
						return false;
					return true;
				}
                                 function IsMediaTypeSelected()
				{
					if(getInputMediaTypeValue()==-1)
						return false;
					return true;
				}
				  function IsSectorTypeSelected()
				{
					if(getInputSectorSizeValue()==-1)
						return false;
					return true;
				}
				/* function IsPITypeSelected()  // Uncomment when required for PI feature
				{
					if(getInputPIEnabledValue()==-1)
						return false;
					return true;
				}*/
				function IsInputSizeForVDSpecified()
				{
					if(getInputVDSizeValue()=="")
						return false;
					return true;
				}
				function IsInputSizeForVDNaN()
				{
					var sizeValue = getInputVDSizeValue();
					<!--Make sure to check for trailing spaces, leading spaces and spaces in between a number -->
					<!-- The above check can be accomplished by "isNaN(sizeValue)" that checks spaces in between a number
						and "isNaN(parseFloat(sizeValue)" checks leading and trailing spaces-->
					var sizeValueDecFormat = ConvertToDecValString(sizeValue);
					if( isNaN(sizeValueDecFormat ) )
						return true;
					else if( isNaN(parseFloat(sizeValueDecFormat )) )
						return true;
					else return false;
				}
				function IsInputVDNameSizeWithinRange()
				{
					var nameVal = getInputVDNameValue();
					var str = new String(nameVal);
					if(str.length >24)
						return false;
					return true;
				}
				function getInputVDSizeValue()
				{
					var elemName=getElementNameForVDSize();
					return document.getElementById(elemName).value;
				}
				function getInputVDNameValue()
				{
					try{
						var elemName = getElementNameForVDName();
						return document.getElementById(elemName).value;
					}catch(e){}
				}
				function getInputRaidLayoutValue()
				{
					var elemName = getElementNameForRaidLayout();
					var SelectBox=document.getElementById(elemName);
					if(SelectBox)
					{
						return(SelectBox.value);
					}
					return -1;
					<!--return 0;-->
				}
					function getInputSectorSizeValue()
					{
					var elemName = "SectorTypeFilter";
					var SelectBox=document.getElementById(elemName);
					if(SelectBox)
					{
						return(SelectBox.value);
					}
					return -1;
					<!--return 0;-->
                                }
								
				  /* function getInputPIEnabledValue() // Uncomment when required for PI Feature
					{
					var elemName = "PIEnabledFilter";
					var checkBox=document.getElementById(elemName);
					if(checkBox)
					{
						return(checkBox.value);
					}
					return -1;
				
                                }*/
                 function getInputRaidLayoutValueForExpressWizard()
				{
					var elemName = "ExpressVDLayout";
					var SelectBox=document.getElementById(elemName);
					if(SelectBox)
					{
						return(SelectBox.value);
					}
					return -1;
					<!--return 0;-->
				}
                        
                        function getInputSecureVDValue()
				{
					var elemName = getElementNameForSecureVD();
					var SelectBox=document.getElementById(elemName);
					if(SelectBox!=null)
					{
						return(SelectBox.value);
					}
					return 0; //  because for non secure VD value  to be posted to lower layers shall be zero.
				}
				function getInputVDSelectedType()
				{
					var elemName = getElementNameForVDType();
					var SelectBox=document.getElementById(elemName);
					if(SelectBox!=null)
					{
						return(SelectBox.value);
					}
					return -1; 
				}
                        function getInputBusProtocolValue()
				{
					var elemName = getElementNameForBusProtocol();
					var SelectBox=document.getElementById(elemName);
					if(SelectBox!=null)
					{
						if(SelectBox.value == Math.pow(2,'<xsl:value-of select="$GLOBAL_VAR_SATA"/>'))
                                                {
                                                        return '<xsl:value-of select="$GLOBAL_VAR_SATA"/>';
                                                }
                                                if(SelectBox.value == Math.pow(2,'<xsl:value-of select="$GLOBAL_VAR_SAS"/>'))
                                                {
                                                        return '<xsl:value-of select="$GLOBAL_VAR_SAS"/>';
                                                }
                                                if(SelectBox.value == Math.pow(2,'<xsl:value-of select="$GLOBAL_VAR_SCSI"/>'))
                                                {
                                                        return '<xsl:value-of select="$GLOBAL_VAR_SCSI"/>';
                                                }
                                                
                                                                                              
					}
				
					return -1;
					
				}
                        function getInputMediaTypeValue()
				{
					var elemName = getElementNameForMediaType();
					var SelectBox=document.getElementById(elemName);
					if(SelectBox!=null)
					{
						return(SelectBox.value);
					}
					return -1;
				}
                 
				
                    function commonInitializationRoutine()
				    {
						var Choice = -1;
						createAdvancedWizardParams(); // construct array of elements supported on the createvd page-1.
						// Create Object representing each parameter/HTML element on Create VD Advanced Wizard Table .Each object has info [HTMLElementName,ElementSupporteFlag]
						 for(var index=0;index &lt;AdvancedWizardParams.length;index++)
						  {  
						    createAdvancedWizardObject(index,AdvancedWizardParams[index][0],AdvancedWizardParams[index][1],null);// passing index:supportedflag:elementname
							
						  }
				   
				        DisableAllOptionsOnAdvancedWizard();
						DisableAllOptionsForRaidLayoutSelectionForExpressWizard();
					
				}

				function WizardInitializationRoutine()
				{   
					
				
						EnableAllAdvancedWizardOptions();
						
					    ClearAlloptions();
                    
                                  
				}
				function ClearAllSelectionForRaidLayoutSelection()
				{
					var elemNameForRaidLayout=getElementNameForRaidLayout();
					var dropdown=document.getElementById(getElementNameForRaidLayout());
					if(dropdown)
					{
						dropdown.options[0].selected=true;
					}
				}
				function DisableAllOptionsOnExpressWizard()
				{
					if( null != document.getElementById("ExpressVDLayout"))
					{
						var optionsArray=document.getElementById("ExpressVDLayout").options;
						  if(optionsArray!=null)
						  {  for(var i=0; i &lt; optionsArray.length; i++)
								{
									optionsArray[i].disabled=true;
								}
							optionsArray[0].selected=-1;
						  }
					}
				}
				function DisableAllOptionsOnAdvancedWizard()
				{
				   var elemName;
				   for(var index=0;index &lt; AdvancedWizardParams.length;index++)
				   {
						 elemName=AdvancedWizardObjArray[index].htmlName;
						
									if(AdvancedWizardObjArray[index].Objsupported == 1 &amp;&amp; document.getElementById(elemName)!=null)
									{
										
										
										if(document.getElementById(elemName).type=="checkbox")
											document.getElementById(elemName).disabled=true;
										else 
										{
										var options = document.getElementById(elemName).options;
										if (options)   
											{
												for(var i=0; i&lt;options.length; i++)
												{    
													options[i].disabled = true;
												}
												options[0].selected = -1;
											}
									    }
									}
				   
				   }
				
				
				}
				function DisableAllOptionsForRaidLayoutSelection()
				{ 
					var elemNameRaidLevel =  getElementNameForRaidLayout(); 
                              if(document.getElementById(elemNameRaidLevel)!=null)
                             {
    
                              	var options = document.getElementById(elemNameRaidLevel).options;
	                              if (options)   
      					{
							for(var i=0; i&lt;options.length; i++)
							{    
								options[i].disabled = true;
							}
                              	}
                             }
				}
				function DisableAllOptionsForRaidLayoutSelectionForExpressWizard()
				{ 
					var elemNameRaidLevel =  "ExpressVDLayout";    
                              if(document.getElementById(elemNameRaidLevel)!= null)
                              {  
                              	var options = document.getElementById(elemNameRaidLevel).options;
		                              if(options )
							{          
								for(var i=0; i&lt;options.length; i++)
								{    
									options[i].disabled = true;
								}
                        		      }
                               } 
				}
				
				function EnableAllAdvancedWizardOptions()
				{
			
				
					var elemName;
				   for(var index=0;index &lt; AdvancedWizardParams.length;index++)
				   {
						 elemName=AdvancedWizardObjArray[index].htmlName;
						
									if(AdvancedWizardObjArray[index].Objsupported == 1 &amp;&amp; document.getElementById(elemName)!=null)
									{
										if(document.getElementById(elemName).type=="checkbox")
											document.getElementById(elemName).disabled=true;
										else
										{
											var dropdown=document.getElementById(elemName);
											
											if(dropdown)
											{   dropdown.options[0].disabled=false;
											   dropdown.options[0].selected=true;
											}
										}
									}
				   
				   }
					
				
				}
				
				function EnableAllValidRaidLayoutDropDown()
				{   
					var prefix = "RadioButtonsForRaidLayoutSelection_";
					var layoutValue = "";
					var postfix = "_HIDDEN_TABLE_DATA";
					var elemName = "";
                                        var SecureVD_prefix = "RadioButtonsForSecureVDRaidLayoutSelection_" ;
                                        var SecureVD_eleName = "";
                                                     
                                        var elemNameRaidLevel =  getElementNameForRaidLayout();     
                                        var options = document.getElementById(elemNameRaidLevel).options;
					 // Raid drop down box is common for secure and no secure Raid levels.
				    if(options )
                            {   
					  for(var i=0; i&lt;options.length; i++)
					  {
						layoutValue = options[i].value;				
						
						    
							elemName = prefix+layoutValue+postfix;
                                                        SecureVD_eleName = SecureVD_prefix+layoutValue+postfix;
							if( (document.getElementById(elemName) != null || layoutValue == "-1") ||(document.getElementById(SecureVD_eleName) != null || layoutValue == "-1"))
							{
								options[i].disabled = false;
							}
							else
							{
							    options[i].disabled = true;
							}
						
					     }
                             }
				}				
				
				function ClearAllRadioButtonsForRaidLayoutSelection()
				{
					var elemNameForRaidLayout=getElementNameForRaidLayout();
					var RadioArray=document.getElementsByName(getElementNameForRaidLayout());
                              if(RadioArray)
                              {
					    for(var i=0; i&lt;RadioArray.length; i++)
						{
							RadioArray[i].checked = false;
						}
                              }  
				}
				function EnableAllValidRaidLayoutRadioButtons()
				{
					var RadioArray=document.getElementsByName(getElementNameForRaidLayout());
					var prefix = "RadioButtonsForRaidLayoutSelection_";
					var layoutValue = "";
					var postfix = "_HIDDEN_TABLE_DATA";
					var elemName = "";
					for(var i=0; i&lt;RadioArray.length; i++)
					{
						layoutValue = RadioArray[i].value;
						elemName = prefix+layoutValue+postfix;
						if(document.getElementById(elemName) != null)
						{
							RadioArray[i].disabled = false;
						}
					}
				}
				function DisableAllRadioButtonsForRaidLayoutSelection()
				{
					var RadioArray=document.getElementsByName(getElementNameForRaidLayout());
                              if(RadioArray)
                              {
					for(var i=0; i&lt;RadioArray.length; i++)
					{
							RadioArray[i].disabled = true;
					}
                              }
				}

				function EnableRaidSelectionRadioButtonsGivenRaidLayoutValue(layoutValue)
				{
					var prefix = "RadioButtonsForRaidLayoutSelection_";
					var postfix = "_HIDDEN_TABLE_DATA";
					var elemName =prefix+layoutValue+postfix;
					if(document.getElementById(elemName)!=null)
					{
						EnableRadioButtonForGivenRaidLayout(layoutValue);
					}
				}
				function EnableRadioButtonForGivenRaidLayout(layoutValue)
				{
					var elemName = getElementNameForRaidLayout();
					var RadioArray = document.getElementsByName(elemName);
					var len = RadioArray.length;
                              if(RadioArray )
                              {
					for(var i=0;i&lt;len;i++)
					{
						if(layoutValue == RadioArray[i].value)
						{
							RadioArray[i].disabled = false;
							break;
						}
					}
                              }
				}
				function DisableRadioButtonForGivenRaidLayout(layoutValue)
				{
					var elemName = getElementNameForRaidLayout();
					var RadioArray = document.getElementsByName(elemName);
					var len = RadioArray.length;

                              if(RadioArray)
                              {
						for(var i=0;i&lt;len;i++)
						{
							if(layoutValue == RadioArray[i].value)
							{
								RadioArray[i].disabled = true;
								break;
							}
						}
                              }
				}
				function IsRadioButtonEnabledForGivenRaidLayoutValue(layoutValue)
				{   
				    var elemName = getElementNameForRaidLayout();
					var dropdown=document.getElementById(elemName);
					var len = dropdown.length;
                              if(dropdown)
                              {
						for(var i=0;i&lt;len;i++)
						{   
							if(dropdown.options[i].value==layoutValue)
							{   
								return true;
							}
						}
                              } 
					return false;
				}
				function UpdateRaidDescriptionTextBox(layoutValue)
				{   
				   
				   
                       
				}
				function getRaidLayoutHelpOneLiner(RaidType)
				{
					if(RaidType==1)
						return('<xsl:value-of select="$strOneLineHelpConcatCVDU"/>');
					else if	(RaidType==2)
						return('<xsl:value-of select="$strOneLineHelpRaid0CVDU"/>');
					else if	(RaidType==4)	
						return('<xsl:value-of select="$strOneLineHelpRaid1CVDU"/>');
					else if	(RaidType==64)	
						return('<xsl:value-of select="$strOneLineHelpRaid5CVDU"/>');
					else if	(RaidType==512 || RaidType==524288)		
						return('<xsl:value-of select="$strOneLineHelpRaid10CVDU"/>');
					else if	(RaidType==2048)		
						return('<xsl:value-of select="$strOneLineHelpRaid50CVDU"/>');
					else if	(RaidType==4096)			
						return('<xsl:value-of select="$strOneLineHelpRaid1ConcatCVDU"/>');
					else if	(RaidType==128)				
						return('<xsl:value-of select="$strOneLineHelpRaid6CVDU"/>');
					else if	(RaidType==262144)		
						return('<xsl:value-of select="$strOneLineHelpRaid60CVDU"/>');
					else
						return("");
				}
				function setInputRaidLayoutValue(layoutValue)
				{   
				    
				  	var elemName = getElementNameForRaidLayout();
					var dropdown=document.getElementById(elemName);
                              if(dropdown)
                              {
						var len = dropdown.length;
						for(var i=0;i&lt;len;i++)
						{
							if(dropdown.options[i].value==layoutValue)
							{   
								dropdown.options[i].selected = true;
								break;
							}
						}
                             }
                                       
				}
                        function setInputSecureVDValue(SecureVDValue)
				{   
				    
				  	var elemName = getElementNameForSecureVD();
					var dropdown=document.getElementById(elemName);
					var len = dropdown.length;
					for(var i=0;i&lt;len;i++)
					{
						if(dropdown.options[i].value==SecureVDValue)
						{     
							dropdown.options[i].selected = true;
							break;
						}
					}
                                       
				}
                        function setInputBusProtocolValue(BusProtocol)
				{   
				    
				  	var elemName = getElementNameForRaidLayout();
					var dropdown=document.getElementById(elemName);
					var len = dropdown.length;
					for(var i=0;i&lt;len;i++)
					{
						if(dropdown.options[i].value==BusProtocol)
						{   
							dropdown.options[i].selected = true;
							break;
						}
					}
                                       
				}
                        
                        function setInputMediaTypeValue(layoutValue)
				{   
				    
				  	var elemName = getElementNameForMediaType();
					var dropdown=document.getElementById(elemName);
					var len = dropdown.length;
					for(var i=0;i&lt;len;i++)
					{
						if(dropdown.options[i].value==MediaType)
						{   
							dropdown.options[i].selected = true;
							break;
						}
					}
                                       
				}
                        

                        
				function setInputVDNameField(nameStr)
				{
					var elemName = getElementNameForVDName();
					document.getElementById(elemName).value = nameStr;
				}
				function disableInputVDSizeField()
				{
					var elemName=getElementNameForVDSize();
					document.getElementById(elemName).disabled = true;
				}
				function enableInputVDSizeField()
				{
					var elemName=getElementNameForVDSize();
					document.getElementById(elemName).disabled = false;
				}
				function setInputVDSizeValue(value)
				{
					var elemName=getElementNameForVDSize();
					document.getElementById(elemName).value = value;
				}
				function setValueForMinField(minValue)
				{
					document.getElementById("Min").innerHTML = "<xsl:value-of select="$strMinSizeLabelCVDU"/>"+ getFormattedStringForMinMaxFields(minValue)+" <xsl:value-of select="$strGBUnitCVDU"/>" ;
				}
				function setValueForMaxField(maxValue)
				{
					document.getElementById("Max").innerHTML = "<xsl:value-of select="$strMaxSizeLabelCVDU"/>"+getFormattedStringForMinMaxFields(maxValue)+" <xsl:value-of select="$strGBUnitCVDU"/>";
				}
				function getPaddingStringForMinMaxFields(origString,fieldWidth)
				{
					var str = new String(origString);
					var len = str.length;
					var maxLen = fieldWidth;
					var paddingLen = maxLen - len;
					var paddingStr = "";
					for(var i=0;i &lt;paddingLen; i++)
					{
						<!-- &#160; is the escape character for &nbsp;-->
						<!--paddingStr  =paddingStr+ "&#160;"; -->
						paddingStr = paddingStr+"0";
					}
					return paddingStr;
				}
				function getFormattedStringForMinMaxFields(origString)
				{
					<!--String to be formatted can be categorized as follows; -->
					<!--a)Integers eg;  "500" etc with no decimal points-->
					<!--b)Floats with a integer part and a decimal part separated by a decimal point. eg;"1234.56", "0.56" -->
					<!--c)Floats with a integer part, no decimal part but have a decimal point. eg; "5." -->
					<!--d)Floats with a decimal part, no integet part but have a decimal point. e.g; ".39"-->
					<!--The above strings after formatting should look like follows "0500.00","1234.56","0000.56","0005.00","0000.39", -->
					<!--They have to be in 4.2 format-->
					<!--The idea is to separate the integer and decimal parts. Format the integer and decimal parts separately, then combine them as one whole string-->
					var formattedString="";
					var intPart="";
					var decPart="";
					var tmpArray = new String(origString).split(JS_GLOBAL_LocalDecSeparator);
					if(tmpArray.length == 1)<!--refer case a) above-->
					{
						intPart = getPaddingStringForMinMaxFields(tmpArray[0],4)+tmpArray[0];
						decPart = "00";
						formattedString = intPart+JS_GLOBAL_LocalDecSeparator+decPart;
					}
					else if(tmpArray.length==2)<!--refer case b,c,d above-->
					{
						intPart = getPaddingStringForMinMaxFields(tmpArray[0],4)+tmpArray[0];
						decPart = tmpArray[1]+getPaddingStringForMinMaxFields(tmpArray[1],2);
						formattedString = intPart+JS_GLOBAL_LocalDecSeparator+decPart;
					}
					else
					{
						formattedString=origString;
					}
					return formattedString;
				}
	
				function getMinSizeForGivenLayout(layoutValue,units)
				{
					if(units=="BYTES")
					{
						var minStr = "getMinSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA";
						if(document.getElementById(minStr))
						{	
							var minValue = document.getElementById(minStr).value;
							return minValue;
						}
					}
					if(units == "GB")
					{
						var minStr = "getMinSizeInGBFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA";
						if(document.getElementById(minStr))
						{	
							var minValue = document.getElementById(minStr).value;
							return minValue;
						}
					}
					return "0";
				}
				function getMaxSizeForGivenLayout(layoutValue,units)
				{
					if(units=="BYTES")
					{
						var maxStr = "getMaxSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA";
						if(document.getElementById(maxStr))
						{
							var maxValue = document.getElementById(maxStr).value;
							return maxValue;
						}	
					}
					if(units == "GB")
					{
						var maxStr = "getMaxSizeInGBFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA";
						if(document.getElementById(maxStr))
						{
							var maxValue = document.getElementById(maxStr).value;
							return maxValue;
						}
					}
					return "0";
			}
                        
						
						
			function OnElementSelected(element)
			{
				var elemName=element.getAttribute("name");
				var NextElement;
				
				switch(elemName)
				{
					case "VDLayout": 		{	 // Reset options in elements available below selected element ex. if selected element is busprotocol disable/reset all the options displayed below busprotocol
											  ClearOptionsForSelectedElement(elemName);
											  RaidLayoutSelected(elemName);
											  
											  } break;
					case "SecureVDFilter"	:
					case "VDTypeFilter"	:
											NextElement = GetNextSupportedOption(elemName);
											if(NextElement != null){
												ClearOptionsForSelectedElement(elemName);
												EnableAdvWizElement(elemName,NextElement,element.value);
												
												}
											break;
					case "BusProtocolFilter":
					case "MediaTypeFilter"	:
					case "SectorTypeFilter" :
					case "PIEnabledFilter" :{  //Find next supported element and enable the options for next element
												NextElement = GetNextSupportedOption(elemName);
											   // Reset options in elements available below selected element ex. if selected element is busprotocol disable/reset all the options displayed below busprotocol
												ClearOptionsForSelectedElement(elemName);
												if(NextElement != null)								
													EnableAdvWizElement(elemName,NextElement,element.value);
												
												}
												break;
				     default				:  break;
				
				
				
				}
			
			
			}
			
                    function RaidLayoutSelected(elemName)
					{ 		
							var layoutValue = getInputRaidLayoutValue();
                            var Choice = -1;
                                     
							if(document.getElementById("intMirror")!=null)
							{
									  if(layoutValue=='512')
									  {
												document.getElementById("intMirror").disabled=false;
									  }
									  else
									  {
												document.getElementById("intMirror").disabled=true;
												document.getElementById("intMirror").checked=false;
									   }
							  } 
							   
									/* if (navigator.appName == "Microsoft Internet Explorer") 
									{
										
											var sAppVersion = navigator.appVersion;
											sAppVersion = sAppVersion.replace (/.*MSIE /i, "");
											sAppVersion = sAppVersion.split (';')[0];
							
											if ( Number(sAppVersion) &lt; 8.0 )
											{
													var prefix = "RadioButtonsForRaidLayoutSelection_";
													var postfix = "_HIDDEN_TABLE_DATA";
													var elemName = prefix+layoutValue+postfix;
													if (document.getElementById(elemName) == null)
													{
														document.getElementById('submitbuttoncontent').className = 'page_button_disabled';
														document.getElementById('submitbuttoncontent').disabled = true;
													}
													else
													{
														document.getElementById('submitbuttoncontent').className = 'page_button_emphasized';
														document.getElementById('submitbuttoncontent').disabled = false;
													}
											}
											
												
									}
									*/
								var NextElement = GetNextSupportedOption(elemName);
							
								if(NextElement != null)								
									EnableAdvWizElement(elemName,NextElement,layoutValue);
								
                                     
  		      }
			  
			  
			  function GetNextSupportedOption(optionSelected)
			  {
			    var index;
			    // This function returns the next supported element for a chosen element
				for( index=0;index &lt;AdvancedWizardParams.length;index++)
								{   
									if(optionSelected == AdvancedWizardObjArray[index].htmlName)
									{		
									   for(var j=index+1;j &lt;AdvancedWizardParams.length;j++)
									   {
											if(AdvancedWizardObjArray[j].Objsupported == 1)
											{
												return AdvancedWizardObjArray[j].htmlName;
											}
										}
									}
								}
				return null;
								
			  }
	
	
		function  enableSectorTypes(SectorTypeForSelectedMediaType)
		{
			  var SectorTypeArray = document.getElementById(getElementNameForSectorType());
			  
				 if(SectorTypeArray!=null)
				  {
						for ( var i=0; i&lt; SectorTypeArray.length; i++)
						 {  
										if( SectorTypeArray[i].value == SectorTypeForSelectedMediaType)
										{
											  SectorTypeArray[i].disabled = false;
										}
										else if( SectorTypeForSelectedMediaType == GLOBAL_VAR_512_4K_SECTORS)
										{
											 SectorTypeArray[i].disabled = false;                                                        
										}
															   
						 } 
				 }
		}
		
		/* function enablePIEnabledFlagType(selectedValue) //Uncomment when required for PI Feature
				 {
					var PIType= document.getElementById(getElementNameForPI());
					
					//enable/disable check box based on sector type
					 if(PIType != null)
					{
						if(selectedValue == 1 || selectedValue == 3)
							document.getElementById(getElementNameForPI()).disabled=false;
					}
				 }
		*/

				
	         function IsInputSizeForVDWithinRangeForExpress()
		 {
					<!-- get selected raid layout value-->
					var layoutValue=getInputRaidLayoutValue();
					<!--get max size for selected raid layout in GB-->
					var minSize = getMinSizeForGivenLayout(layoutValue,"GB");
					var maxSize = getMaxSizeForGivenLayout(layoutValue,"GB");

					if(  getMinSizeForGivenLayout(layoutValue,"BYTES") == getMaxSizeForGivenLayout(layoutValue,"BYTES"))					{
						minSize = maxSize;
					}
					<!--get input size value in GB-->
					var elemNameForSizeValue = getElementNameForVDSize();
					var sizeValue = getInputVDSizeValue();<!--parseFloat(document.getElementById(elemNameForSizeValue ).value);-->

					var sizeValueDecFormat = parseFloat(ConvertToDecValString(sizeValue));
					var minSizeDecFormat = parseFloat(ConvertToDecValString(minSize));
					var maxSizeDecFormat = parseFloat(ConvertToDecValString(maxSize));

					<!--Do a range check-->
					if( sizeValueDecFormat &lt; minSizeDecFormat || sizeValueDecFormat &gt; maxSizeDecFormat )
					{
						return false;
					}
					return true;
				}
				function HandleInputSizeGreaterThanOsLimitExpress()
				{
					var sizeValue = getInputVDSizeValue();
					var osLimitValueinGB = "<xsl:value-of select="format-number($GLOBAL_PARAM_Oslimit div (1024*1024*1024), '###0.00')"/>";
					var sizeValueDecFormat = parseFloat(ConvertToDecValString(sizeValue));
					var osLimitValueDecFormat = parseFloat(ConvertToDecValString(osLimitValueinGB));

					if ( sizeValueDecFormat &gt; osLimitValueDecFormat)
					{
						<!-- This means that the virtual disk size is greater than the os limit-->
						if (confirm ("<xsl:value-of select="$strOsLimitWarn"/>"))
						{
							return true;
						}
						else
						{
							return false;
						}
					}
					else
					{
						return true;
					}
				}
				function HandleInputSizeRangeErrorForExpress()
				{
					var layoutValue=getInputRaidLayoutValue();
					var nameStr = "getMaxSizeFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA";
					var strMsg = "<xsl:value-of select="$strInvalidSizeMsgCVDU"/>";
					var strError = "<xsl:value-of select="$strError"/>";
					alert(strError + strMsg);
					document.getElementById(getElementNameForVDSize()).value=getMaxSizeForGivenLayout(layoutValue,"GB");
				}
				function ConvertInputSizeToBytesForExpress(ReconfigLayout)
				{     
                                      var layoutValue = ReconfigLayout;
                                      if(!ReconfigLayout)
                                      {
                                                 var layoutValue=getInputRaidLayoutValue();
                                      }
                              
					var inputSizeValue = getInputVDSizeValue();
					var minSizeInBytes = getMinSizeForGivenLayout(layoutValue,"BYTES");
					var maxSizeInBytes = getMaxSizeForGivenLayout(layoutValue,"BYTES");
					var minSizeInGB = getMinSizeForGivenLayout(layoutValue,"GB");
					var maxSizeInGB = getMaxSizeForGivenLayout(layoutValue,"GB");
					var outputSizeValueInBytes="";

					var maxSizeInGBDecFormat = ConvertToDecValString(maxSizeInGB);
					var minSizeInGBDecFormat = ConvertToDecValString(minSizeInGB);
					var inputSizeValueDecFormat = ConvertToDecValString(inputSizeValue);

					if(  minSizeInBytes == maxSizeInBytes)
					{
						outputSizeValueInBytes=maxSizeInBytes;
					}
					else if(parseFloat(maxSizeInGBDecFormat ) == parseFloat(inputSizeValueDecFormat ) )
					{
						outputSizeValueInBytes=maxSizeInBytes;
					}
					else if( parseFloat(minSizeInGBDecFormat ) ==parseFloat(inputSizeValueDecFormat ))
					{
						outputSizeValueInBytes=minSizeInBytes;
					}
					else
					{
						outputSizeValueInBytes=parseInt(inputSizeValueDecFormat *1024*1024*1024);
					<!--RS - DFCT134412: Check if the RAID size Boundary value in Express wizard falls betn getcaps max size and displayed size/-->
						if( outputSizeValueInBytes &gt; maxSizeInBytes )
							outputSizeValueInBytes = maxSizeInBytes;

					}
					return outputSizeValueInBytes;
				}
                                
                        
				function submitExpressCreateVD()
				{
					if(validate()==false)
						return;<!-- NOTE: Just "return" is used instead of "return false". This is intentional, using "return false" would cause HTML page to display a text "false" whenver validate fails(VISH:4/29/04)-->
                                                
					var Rules ="<xsl:value-of select="//Rules"/>";
					<!--This function is called when the submit button is selected in the express mode, this validates user input/-->

					var layoutValue=getInputRaidLayoutValueForExpressWizard();
					var SecureFlag = 0;
					var VDPIEnabledFlag=0;
					var confirmflag = false;
					<xsl:for-each select="//PISecureExpressResults/DCStorageObject">
						  var RaidLevel_DCStorageObject = <xsl:value-of select="Layout"/>
						  if(RaidLevel_DCStorageObject == layoutValue)
						  {
							  SecureFlag='<xsl:value-of select="SecureFlag"/>';
							  VDPIEnabledFlag='1';
							  confirmflag = true;
						  }
					</xsl:for-each>
					if(!confirmflag){
						<xsl:for-each select="//PIExpressResults/DCStorageObject">
							  var RaidLevel_DCStorageObject = <xsl:value-of select="Layout"/>
							  if(RaidLevel_DCStorageObject == layoutValue)
							  {
								  SecureFlag='<xsl:value-of select="SecureFlag"/>';
								  VDPIEnabledFlag='1';
								  confirmflag = true;
							  }
						</xsl:for-each>
					}
					if(!confirmflag){
						<xsl:for-each select="//SecureExpressResults/DCStorageObject">
							  var RaidLevel_DCStorageObject = <xsl:value-of select="Layout"/>
							  if(RaidLevel_DCStorageObject == layoutValue)
							  {
								  SecureFlag='<xsl:value-of select="SecureFlag"/>';
								  VDPIEnabledFlag='0';
							  }
						</xsl:for-each>
					}
					<!--var sizeValue=ConvertInputSizeToBytesForGivenLayout(layoutValue);-->
					<!-- Fetch the DSA params -->
					var ParamClearForeignConfigEnable="<xsl:value-of select="//ClearForeignConfigEnable"/>";
					var ParamForeignAdiskFound="<xsl:value-of select="//ForeignAdiskFound"/>";
                                        <!--Next call the submit webplugin for DSA pass additional parameters-->
					if(Rules == "1" &amp;&amp; ParamClearForeignConfigEnable != null &amp;&amp; ParamForeignAdiskFound != null )
					{
						<!--Ashesh - CR54430: Values entered in the Raid configuration pages need to be cached-->
						<!--Ashesh: Flush the cache to make sure that the cache gets overwritten with new selection-->
						cachePageInDSA();
						document.getElementById("dataarea").action = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CreateVDExpressSummaryWebPlugin&amp;OrigURL=<xsl:value-of select="//OrigURL"/>&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>"+"&amp;Layout="+layoutValue+"&amp;Rules=<xsl:value-of select="//Rules"/>"+"&amp;DisplayVDConfig=<xsl:value-of select="//DisplayVDConfig"/>"+"&amp;OutputFileName=<xsl:value-of select="//OutputFileName"/>");
						document.getElementById("dataarea").submit();
						return true;
                    }
					else
					{
						document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CreateVDExpressSummaryWebPlugin&amp;OrigURL=<xsl:value-of select="//OrigURL"/>&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>"+"&amp;Layout="+layoutValue+"&amp;Rules=<xsl:value-of select="//Rules"/>"+"&amp;DisplayVDConfig=<xsl:value-of select="//DisplayVDConfig"/>"+"&amp;OutputFileName=<xsl:value-of select="//OutputFileName"/>&amp;SecureFlag="+SecureFlag+"&amp;VDPIEnabledFlag="+VDPIEnabledFlag);
					}

				}
	</xsl:template>
	<xsl:template name="BitOr">
		<xsl:param name="num1"/>
		<xsl:param name="num2"/>
		<xsl:param name="result" select="0"/>
		<xsl:param name="pow2" select="1"/>
		<xsl:choose>
			<xsl:when test="$num1 &lt; 1 and $num2 &lt; 1">
				<xsl:value-of select="$result"/> 
			</xsl:when>
			<xsl:when test="boolean($num1 mod 2) or boolean($num2 mod 2)">
				<xsl:call-template name="BitOr">
					<xsl:with-param name="num1" select="floor($num1 div 2)"/>
					<xsl:with-param name="num2" select="floor($num2 div 2)"/>
					<xsl:with-param name="result" select="$result + $pow2"/>
					<xsl:with-param name="pow2" select="$pow2 * 2"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="BitOr">
					<xsl:with-param name="num1" select="floor($num1 div 2)"/>
					<xsl:with-param name="num2" select="floor($num2 div 2)"/>
					<xsl:with-param name="result" select="$result"/>
					<xsl:with-param name="pow2" select="$pow2 * 2"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--Returns the bit of num1 in bit place num2-->
	<xsl:template name="BitCheck">
		<xsl:param name="num1"/>
		<xsl:param name="num2"/>
		<xsl:param name="result" select="0"/>
		<xsl:choose>
			<xsl:when test="$num2=0">
				<xsl:value-of select="$num1 mod 2"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="BitCheck">
					<xsl:with-param name="num1" select="floor($num1 div 2)"/>
					<xsl:with-param name="num2" select="$num2 - 1"/>
					<xsl:with-param name="result" select="$result"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--Returns the number of 1's in num1-->
	<xsl:template name="NumBits">
		<xsl:param name="num1"/>
		<xsl:param name="result" select="0"/>
		<xsl:choose>
			<xsl:when test="$num1=0">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:when test="($num1 mod 2) = '1'">
				<xsl:call-template name="NumBits">
					<xsl:with-param name="num1" select="floor($num1 div 2)"/>
					<xsl:with-param name="result" select="$result+1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="NumBits">
					<xsl:with-param name="num1" select="floor($num1 div 2)"/>
					<xsl:with-param name="result" select="$result"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
        
          <xsl:template name="GetNumberFromMask">
		<xsl:param name="num"/>
		<xsl:param name="count" select="0"/>
                <xsl:variable name="result">
                    <xsl:call-template name="Power">
			<xsl:with-param name="num1" select="2"/>
			<xsl:with-param name="num2" select="$count"/>
		    </xsl:call-template>
                </xsl:variable>    
		<xsl:choose>
			
                        <xsl:when test="$result=$num and $count=0">
				<xsl:value-of select="$count+1"/>
			</xsl:when>
                        <xsl:when test="$result=$num">
				<xsl:value-of select="$count"/>
			</xsl:when>
			<xsl:when test="$count &lt; 31">
                            <xsl:call-template name="GetNumberFromMask">
					<xsl:with-param name="num" select="$num"/>
					<xsl:with-param name="count" select="$count + 1"/>
                            </xsl:call-template>
			</xsl:when>
                        <xsl:otherwise>0</xsl:otherwise>    
		</xsl:choose>
	</xsl:template>
        
		<!--Returns num1 to the power of num2-->
	<xsl:template name="Power">
		<xsl:param name="num1"/>
		<xsl:param name="num2"/>
		<xsl:param name="result" select="1"/>
		<xsl:choose>
			<xsl:when test="$num2=0">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="Power">
					<xsl:with-param name="num1" select="$num1"/>
					<xsl:with-param name="num2" select="$num2 - 1"/>
					<xsl:with-param name="result" select="$result * $num1"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--Uses busprotocol to get a protocol mask of all the protocols exisiting-->
	<xsl:template name="GetProtocolMask">
		<xsl:param name="nodes" select="/.."/>
		<xsl:param name="result" select="0"/>
		<xsl:choose>
			<xsl:when test="not($nodes)">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="GetProtocolMask">
					<xsl:with-param name="nodes" select="$nodes[position() != 1]"/>
					<xsl:with-param name="result"><xsl:call-template name="BitOr">
						<xsl:with-param name="num1"><xsl:call-template name="Power">
							<xsl:with-param name="num1" select="2"/>
							<xsl:with-param name="num2"><xsl:value-of select="$nodes[1]"/></xsl:with-param></xsl:call-template></xsl:with-param>
						<xsl:with-param name="num2" select="$result"/>
					</xsl:call-template></xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
     <xsl:template name="CreateProtocolMask">
		<xsl:param name="nodes" select="/.."/>
		<xsl:param name="result" select="0"/>
		<xsl:choose>
			<xsl:when test="not($nodes)">
				<xsl:value-of select="$result"/> 
			</xsl:when>
			<xsl:otherwise>
                    
                         <xsl:call-template name="CreateProtocolMask">
        
					<xsl:with-param name="result">
						<xsl:call-template name="BitOr">
							<xsl:with-param name="num1" select="$nodes[1]"/>
							<xsl:with-param name="num2" select="$result"/>
						</xsl:call-template>
					</xsl:with-param>
					<xsl:with-param name="nodes" select="$nodes[position() != 1]"/>
				</xsl:call-template>
                         
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
      

	<xsl:template name="getScriptsForAdvanced">
				function getElementNameForReadPolicy()
				{
					return "ReadPolicy";
				}
				function getElementNameForWritePolicy()
				{
					return "WritePolicy";
				}
				function getElementNameForCachePolicy()
				{
					return "CachePolicy";
				}
                function getElementNameForDiskCachePolicy()
				{
					return "DiskCachePolicy";
				}
				function getElementNameForStripeSize()
				{
					return "StripeSize";
				}
				function getInputReadPolicyValue()
				{
					var elemName = getElementNameForReadPolicy();
					return document.getElementById(elemName).value;
				}
				function getInputWritePolicyValue()
				{
					var elemName = getElementNameForWritePolicy();
					return document.getElementById(elemName).value;
				}
				function getInputCachePolicyValue()
				{
					var elemName = getElementNameForCachePolicy();
					return document.getElementById(elemName).value;
				}
                function getInputDiskCachePolicyValue()
				{
					var elemName = getElementNameForDiskCachePolicy();
					return document.getElementById(elemName).value;
				}
				function getInputStripeSizeValue()
				{
					var elemName = getElementNameForStripeSize();
					return document.getElementById(elemName).value;
				}
				function setStripeSize(defStripeSizeVal )
				{
					try
					{
						var elemName = getElementNameForStripeSize();
						var optionsArray=document.getElementById(elemName).options;
						for(var i=0; i &lt; optionsArray.length; i++)
						{
							if(defStripeSizeVal==optionsArray[i].value)
							{
								document.getElementById(elemName).selectedIndex=i;
								break;
							}
						}
					}catch(e){}
				}
				function setReadPolicy(defReadPolicy )
				{
					try
					{
						var elemName = getElementNameForReadPolicy();
						var optionsArray=document.getElementById(elemName).options;
						for(var i=0; i &lt; optionsArray.length; i++)
						{
							if(defReadPolicy==optionsArray[i].value)
							{
								document.getElementById(elemName).selectedIndex=i;
								break;
							}
						}
					}catch(e){}
				}
				function setWritePolicy(defWritePolicy )
				{
					try
					{
						var elemName = getElementNameForWritePolicy();
						var optionsArray=document.getElementById(elemName).options;
						for(var i=0; i &lt; optionsArray.length; i++)
						{
							if(defWritePolicy==optionsArray[i].value)
							{
								document.getElementById(elemName).selectedIndex=i;
								break;
							}
						}
					}catch(e){}
				}
				function setCachePolicy(defCachePolicy )
				{
					try
					{
							var elemName = getElementNameForCachePolicy();
							var optionsArray=document.getElementById(elemName).options;
							for(var i=0; i &lt; optionsArray.length; i++)
							{
								if(defCachePolicy==optionsArray[i].value)
								{
									document.getElementById(elemName).selectedIndex=i;
									break;
								}
							}
					}catch(e){}
				}
                                function setDiskCachePolicy(defDiskCachePolicy )
				{
					try
					{
							var elemName = getElementNameForDiskCachePolicy();
							var optionsArray=document.getElementById(elemName).options;
							for(var i=0; i &lt; optionsArray.length; i++)
							{
								if(defDiskCachePolicy==optionsArray[i].value)
								{
									document.getElementById(elemName).selectedIndex=i;
									break;
								}
							}
					}catch(e){}
				}
                         

	</xsl:template>
</xsl:stylesheet>


