<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc that can be resused/-->
	<xsl:include href="Utils.xsl"/>
	<!-- CreateVDUtils contains templates and scripts to render tables and validate pages-->
	<xsl:include href="cvdutils.xsl"/>
	<xsl:include href="dsautils.xsl"/>
	<!--Below defines a Key that maps virtual disks and its constituent array disks -->
	<xsl:key name="ADsForVD" match="//ArrayDisks" use="@LDN"/>
	<!--Below defines a key that maps a given controller and its associated virtual disks -->
	<xsl:key name="VDs" match="//VirtualDisks" use="@ControllerName"/>
	<!--main entry point into this XSL,  /-->

	<!-- Declare Global variables and parameters-->
        
      <xsl:variable name="GLOBAL_VAR_EXPRESS_WIZARD">0</xsl:variable>
      <xsl:variable name="GLOBAL_VAR_CREATE_CACHECADE"><xsl:value-of select="//ManageSSC"/></xsl:variable>

	<xsl:variable name="GLOBAL_VAR_GetCapsSMStatus">
		<xsl:choose>
			<xsl:when test="//ExpressResults/SMStatus"><xsl:value-of select="//ExpressResults/SMStatus"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
    <xsl:variable name="GLOBAL_VAR_SecureExpressResults">
		<xsl:choose>
			<xsl:when test="//SecureExpressResults">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_PISExpressResults">
		<xsl:choose>
			<xsl:when test="//PISecureExpressResults">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_PIExpressResults">
		<xsl:choose>
			<xsl:when test="//PIExpressResults">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
    <xsl:variable name="GLOBAL_VAR_HIDE_VD_FILTER">
		<xsl:choose>
			<xsl:when test="//SecureExpressResults or //PISecureExpressResults or //PIExpressResults ">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
       <xsl:variable name="GLOBAL_VAR_SecureVDSelectedOnPageLoad">
		<xsl:choose>
			<xsl:when test="/OMA/SecureVD = '1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
      <xsl:variable name="ControllerAttributesMask"><xsl:value-of select="//OMA/Controllers/DCStorageObject/AttributesMask"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_RaidLevelsMask"><xsl:value-of select="//Controllers/DCStorageObject/RAIDLevelsMask"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_NumVirtualDisks"><xsl:value-of select="count(//VirtualDisks/DCStorageObject)"/></xsl:variable>
      <xsl:variable name="GLOBAL_VAR_MediaTypeMask">
		<xsl:choose>
			<xsl:when test="/OMA/ExpressResults/DCStorageObject/MediaTypeMask">
				<xsl:call-template name="CreateProtocolMask">
					<xsl:with-param name="nodes" select="/OMA/ExpressResults/DCStorageObject/MediaTypeMask"/>
					<xsl:with-param name="result" select="0"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>

	</xsl:variable>
	
	
      <xsl:variable name="GLOBAL_VAR_BusProtocolMask">
		<xsl:choose>
			<xsl:when test="/OMA/ExpressResults/DCStorageObject/BusProtocolMask">
				<xsl:call-template name="CreateProtocolMask">
					<xsl:with-param name="nodes" select="/OMA/ExpressResults/DCStorageObject/BusProtocolMask"/>
					<xsl:with-param name="result" select="0"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>

	</xsl:variable>
	<!--Including variable for Sector Mask returns 0 if sector mask not present-->
	 <xsl:variable name="GLOBAL_VAR_SectorSizeMask">
		<xsl:choose>
			<xsl:when test="/OMA/ExpressResults/DCStorageObject/SectorMask">
				<xsl:call-template name="CreateProtocolMask">
					<xsl:with-param name="nodes" select="/OMA/ExpressResults/DCStorageObject/SectorMask"/>
					<xsl:with-param name="result" select="0"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>

	</xsl:variable>
    <xsl:variable name="GLOBAL_VAR_PISecureSectorSizeMask">
		<xsl:choose>
			<xsl:when test="/OMA/PISecureExpressResults/DCStorageObject/SectorMask">
				<xsl:call-template name="CreateProtocolMask">
					<xsl:with-param name="nodes" select="/OMA/PISecureExpressResults/DCStorageObject/SectorMask"/>
					<xsl:with-param name="result" select="0"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>

	</xsl:variable>
    <xsl:variable name="GLOBAL_VAR_PISectorSizeMask">
		<xsl:choose>
			<xsl:when test="/OMA/PIExpressResults/DCStorageObject/SectorMask">
				<xsl:call-template name="CreateProtocolMask">
					<xsl:with-param name="nodes" select="/OMA/PIExpressResults/DCStorageObject/SectorMask"/>
					<xsl:with-param name="result" select="0"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>

	</xsl:variable>
    <xsl:variable name="GLOBAL_VAR_SecureSectorSizeMask">
		<xsl:choose>
			<xsl:when test="/OMA/SecureExpressResults/DCStorageObject/SectorMask">
				<xsl:call-template name="CreateProtocolMask">
					<xsl:with-param name="nodes" select="/OMA/SecureExpressResults/DCStorageObject/SectorMask"/>
					<xsl:with-param name="result" select="0"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>

	</xsl:variable>
	<!--Including variable for PI Mask returns 0 if PI enabled mask not present-->
	 <!--xsl:variable name="GLOBAL_VAR_PIEnabledMask">
		<xsl:choose>
			<xsl:when test="/OMA/ExpressResults/DCStorageObject/VdPIMask">
				<xsl:call-template name="CreateProtocolMask">
					<xsl:with-param name="nodes" select="/OMA/ExpressResults/DCStorageObject/VdPIMask"/>
					<xsl:with-param name="result" select="0"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>

	</xsl:variable-->
     
         <xsl:variable name="GLOBAL_VAR_SecureVDMask">
		<xsl:choose>
			<xsl:when test="/OMA/ExpressResults/DCStorageObject/SecureFlag">
				<xsl:call-template name="CreateProtocolMask">
					<xsl:with-param name="nodes" select="/OMA/ExpressResults/DCStorageObject/SecureFlag"/>
					<xsl:with-param name="result" select="0"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>

	</xsl:variable>
     
  
	<xsl:variable name="PARAM_DSA_Rules">
		<xsl:choose>
			<xsl:when test="/OMA/Rules"><xsl:value-of select="/OMA/Rules"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_ClearForeignConfigEnable">
		<xsl:choose>
			<xsl:when test="/OMA/ClearForeignConfigEnable">
				<xsl:value-of select="/OMA/ClearForeignConfigEnable"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_IsAnyAdiskForeign">
		<xsl:choose>
			<xsl:when test="/OMA/ForeignAdiskFound">
				<xsl:value-of select="/OMA/ForeignAdiskFound"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_DSARaidModeAndDiskCheck">
		<xsl:choose>
			<xsl:when test="/OMA/DSARaidModeAndDiskCheck">
				<xsl:value-of select="/OMA/DSARaidModeAndDiskCheck"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_SECURITYKEY">
		 <xsl:choose>
            <xsl:when test="substring(/OMA/Controllers/DCStorageObject/AttributesMask,8,1)='1' and substring(/OMA/Controllers/DCStorageObject/AttributesMask,9,1)='1' "><xsl:value-of select="$strYes"/></xsl:when>
            <xsl:when test="substring(/OMA/Controllers/DCStorageObject/AttributesMask,8,1)='0' and substring(/OMA/Controllers/DCStorageObject/AttributesMask,9,1)='1'"><xsl:value-of select="$strNo"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
        </xsl:choose> 
	</xsl:variable>
	<xsl:variable name="PARAM_DSA_OutputFileName"><xsl:value-of select="/OMA/OutputFileName"/></xsl:variable>
	<xsl:variable name="PARAM_DSA_DisplayVDConfig"><xsl:value-of select="/OMA/DisplayVDConfig"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_ControllerName"><xsl:value-of select="/OMA/ControllerName"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_ControllerOID"><xsl:value-of select="/OMA/ControllerOID"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_FILE"><xsl:value-of select="/OMA/FILE"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_OrigURL"><xsl:value-of select="/OMA/OrigURL"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_Layout"><xsl:value-of select="/OMA/Layout"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_Length"><xsl:value-of select="/OMA/Length"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_VDName"><xsl:value-of select="/OMA/VDName"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_IDList"><xsl:value-of select="/OMA/IDList"/></xsl:variable>
        <xsl:variable name="PARAM_NEXT_IMIDList"><xsl:value-of select="/OMA/IMIDList"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_SpanLength"><xsl:value-of select="/OMA/SpanLength"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_DiskProtocol"><xsl:value-of select="/OMA/DiskProtocol"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_ReadPolicy"><xsl:value-of select="/OMA/ReadPolicy"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_WritePolicy"><xsl:value-of select="/OMA/WritePolicy"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_CachePolicy"><xsl:value-of select="/OMA/CachePolicy"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_DiskCachePolicy"><xsl:value-of select="/OMA/DiskCachePolicy"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_StripeSize"><xsl:value-of select="/OMA/StripeSize"/></xsl:variable>
	<xsl:variable name="PARAM_STATE_UserSelectedAdiskArrayNumList"><xsl:value-of select="/OMA/UserSelectedAdiskArrayNumList"/></xsl:variable>
	<xsl:variable name="PARAM_STATE_UserSelectedAdiskContiguousFreeSpaceList"><xsl:value-of select="/OMA/UserSelectedAdiskContiguousFreeSpaceList"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_Minosdrivesize"><xsl:value-of select="/OMA/Minosdrivesize"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_Maxosdrivesize"><xsl:value-of select="/OMA/Maxosdrivesize"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_IM"><xsl:value-of select="/OMA/IntMirror"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_SELECTALL"><xsl:value-of select="/OMA/SelectAll"/></xsl:variable>
        <xsl:variable name="PARAM_CURR_ENCLOSURESELECTEDLIST"><xsl:value-of select="/OMA/EnclosureSelectedList"/></xsl:variable>
        <xsl:variable name="PARAM_CURR_ENCLOSUREDISABLEDLIST"><xsl:value-of select="/OMA/EnclosureDisabledList"/></xsl:variable>

	<xsl:variable name="DSA_PARAMS">Rules=<xsl:value-of select="$PARAM_DSA_Rules"/>&amp;DisplayVDConfig=<xsl:value-of select="$PARAM_DSA_DisplayVDConfig"/>&amp;OutputFileName=<xsl:value-of select="$PARAM_DSA_OutputFileName"/>&amp;ClearForeignConfigEnable=<xsl:value-of select="$PARAM_ClearForeignConfigEnable"/>&amp;ForeignAdiskFound=<xsl:value-of select="$GLOBAL_PARAM_IsAnyAdiskForeign"/>&amp;DSARaidModeAndDiskCheck=<xsl:value-of select="$GLOBAL_PARAM_DSARaidModeAndDiskCheck"/></xsl:variable>

	<xsl:variable name="REGULAR_PARAMS">ControllerOID=<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$PARAM_REGULAR_ControllerName"/>&amp;FILE=<xsl:value-of select="PARAM_REGULAR_FILE"/>&amp;Minosdrivesize=<xsl:value-of select="$PARAM_REGULAR_Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="$PARAM_REGULAR_Maxosdrivesize"/></xsl:variable>

	<xsl:variable name="CACHED_PARAMS">IDList=<xsl:value-of select="$PARAM_NEXT_IDList"/>&amp;SpanLength=<xsl:value-of select="$PARAM_NEXT_SpanLength"/>&amp;DiskProtocol=<xsl:value-of select="$PARAM_NEXT_DiskProtocol"/>&amp;VDName=<xsl:value-of select="$PARAM_NEXT_VDName"/>&amp;Length=<xsl:value-of select="$PARAM_NEXT_Length"/>&amp;ReadPolicy=<xsl:value-of select="$PARAM_NEXT_ReadPolicy"/>&amp;WritePolicy=<xsl:value-of select="$PARAM_NEXT_WritePolicy"/>&amp;CachePolicy=<xsl:value-of select="$PARAM_NEXT_CachePolicy"/>&amp;DiskCachePolicy=<xsl:value-of select="$PARAM_NEXT_DiskCachePolicy"/>&amp;StripeSize=<xsl:value-of select="$PARAM_NEXT_StripeSize"/>&amp;IMIDList=<xsl:value-of select="$PARAM_NEXT_IMIDList"/></xsl:variable>

	<xsl:variable name="STATE_PARAMS">UserSelectedAdiskArrayNumList=<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskArrayNumList"/>&amp;UserSelectedAdiskContiguousFreeSpaceList=<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskContiguousFreeSpaceList"/></xsl:variable>

	<xsl:variable name="GLOBAL_PARAM_Screen_Name">cvdraid_<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Prev_Page_URL">
		<xsl:choose>
			<!-- Ashesh: If there are foreign disks take user back to foreign configuration page -->
			<xsl:when test="$GLOBAL_PARAM_IsAnyAdiskForeign='1'">./DataArea?plugin=com.dell.sm.webplugins.DSAClearForeignConfigWebPlugin&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;IsFromAdvanced=1</xsl:when>
			<xsl:otherwise>./SubmitForm?plugin=com.dell.cdu.webplugins.PreviousScreenWebPlugin&amp;IsFromAdvanced=1</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Exit_Wizard_URL">
		<xsl:choose>
			<xsl:when test="$PARAM_DSA_Rules='1'">./DSASwitch?exitRAID=1&amp;IsFromAdvanced=1</xsl:when>
			<xsl:otherwise><xsl:value-of select="translate($PARAM_REGULAR_OrigURL,'!','&amp;')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Express_Wizard_URL">./DataArea?plugin=com.dell.sm.webplugins.CreateVDExpressWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/></xsl:variable>

	<xsl:template match="/">
		<!-- This page is rendered under two scenarios-->
		<!-- Page Load Scenario One: Page is loaded for first time.-->
		<!-- Page Load Scenario Two: Page is loaded because user clicked "back button" on wizard.-->
		<!-- Page error scenarios-->
		<!-- Error scenario One:
			Detection: When getcaps command returns value for SMStatus as "-1".
			Cause: Free array disks unavailable to create any raid layout.
			User Scenario when this occurs: This can happen on both "Page Load Scenario One" and "Page Load Scenario Two" if there are no array disks with free space-->
		<!-- Error scenario Two:
			Detection: When user selected raid layout does not appear in results of getcaps command
			Cause: Configuration change
			User scenario when this occurs: This can happen when somebody has simulatenously issued a command for create VD using CLI or from another browser-->
		<!-- When user comes to this page using "back button" on wizard, the variable below determines whether layout selected by user is still valid-->
		<!-- Next render page depending if there is an error or not.-->
		<xsl:choose>
			<xsl:when test="$PARAM_DSA_Rules != '1' and $GLOBAL_VAR_GetCapsSMStatus='-1'">
				<DataArea exportdata="false"  email="false" printable="false">
					<!--PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strTitleFreeDisksUnavailableCVDARLS"/></xsl:attribute>
					</PageTitle-->
					<AlertMessage>
					  <xsl:attribute name="display"><xsl:value-of select="$strTitleFreeDisksUnavailableCVDARLS"/></xsl:attribute>
					</AlertMessage>
					<BottomCustomButton>
						<Data formSubmit="true" display="{$strCancelCVDARLS}" href="{$GLOBAL_PARAM_Exit_Wizard_URL}"/>
					</BottomCustomButton>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="OMA" mode="UI"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="OMA" mode="UI">
		<!-- Ashesh: DF63251: Pressing Enter key clears selected RAID level in configuration wizard. -->
		<!-- Added nosubmitfordsa attribute to disable <Enter> key -->
		<DataArea onLoad="true" validate="true" exportdata="false" printable="false" email="false" nosubmitfordsa="true" ignoreJumpBar="true">
			<xsl:if test="$PARAM_DSA_Rules ='1'">
				<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
				<!-- In DSA mode, we want to enable the DSA caching mechanism so storeonback and screenname are defined. -->
				<xsl:attribute name="storeonback">true</xsl:attribute>
				<xsl:attribute name="screenname"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:attribute>
				
				<!-- OMSS does not have a back button but OMSS Lite does. We use the DSA caching javascript function. -->
				<xsl:attribute name="custombackpagedisplay"><xsl:value-of select="$strBackButtonDisplayCVDARLS"/></xsl:attribute>
				<xsl:attribute name="backpagetarget">javascript:goToPreviousPageInDSA();</xsl:attribute>
			</xsl:if>
			
			<script language="javascript">
				var LAYOUT_SELECTED_ON_PAGE_LOAD;<!-- This variable holds what raid layout is selected on page load.(when back button on wizard is used) -->
                                var Intelligent_Mirroring;
                               var SecureVDOnPageLoad;
							   var RAID_LEVEL_ROW =1; //Flag indicates Raid Level (Set the default as 1- raid level option always enabled or supported on create VD page-1).
                               var SECURE_VD_ROW = "<xsl:choose><xsl:when test="$GLOBAL_VAR_SecureExpressResults != '1'">0</xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose>" ;
                               var MEDIA_TYPE_ROW = "<xsl:choose><xsl:when test="$GLOBAL_VAR_MediaTypeMask ='1'">0</xsl:when><xsl:when test="$GLOBAL_VAR_MediaTypeMask = '2'">0</xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose>"; 
							   var TYPE_VD_ROW = "<xsl:choose><xsl:when test="$GLOBAL_VAR_HIDE_VD_FILTER = '1'">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose>" ;
                               var BUS_PROTOCOL_TYPE_ROW = "<xsl:choose><xsl:when test="$GLOBAL_VAR_BusProtocolMask = '128'">0</xsl:when><xsl:when test="$GLOBAL_VAR_BusProtocolMask = '256'">0</xsl:when><xsl:when test="$GLOBAL_VAR_BusProtocolMask = '1'">0</xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose>";
							   //Flag below indicates if sector size is supported (created VD Page-1) SECTOR_TYPE_ROW-1 indicates sectormask element should be displayed on page and value should be selected before procxeeding to next page.
						       var SECTOR_TYPE_ROW = "<xsl:choose><xsl:when test="$GLOBAL_VAR_SectorSizeMask ='512'">0</xsl:when><xsl:when test="$GLOBAL_VAR_SectorSizeMask = '4096'">0</xsl:when><xsl:when test="$GLOBAL_VAR_SectorSizeMask = '0'">0</xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose>"; 
							  
							// <!--Uncomment for PI feature-->
							//var PI_TYPE_ROW = "<!--xsl:choose><xsl:when test="$GLOBAL_VAR_PIEnabledMask ='1'">0</xsl:when><xsl:when test="$GLOBAL_VAR_PIEnabledMask = '3'">0</xsl:when><xsl:when test="$GLOBAL_VAR_PIEnabledMask ='0'">0</xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose-->"; 
                               var CACHECADELAYOUT = "2"; //Raid - 0 for cachecade 
                                
				function initializationRoutine()
				{  
                                        if( '<xsl:value-of select="$GLOBAL_VAR_CREATE_CACHECADE"/>' == '1')
                                        {
                                           return;  // No Initialization required for Cache cade
                                           
                                        }
					//alert("2");
					commonInitializationRoutine();
					//UpdateWithUserSelectedInputs();
					LAYOUT_SELECTED_ON_PAGE_LOAD = '<xsl:value-of select="$PARAM_CURR_Layout"/>'
					Intelligent_Mirroring='<xsl:value-of select="$PARAM_CURR_IM"/>';
                                        SecureVDOnPageLoad= '<xsl:value-of select="$GLOBAL_VAR_SecureVDSelectedOnPageLoad"/>';
					var SecurityKey = '<xsl:value-of select="$GLOBAL_PARAM_SECURITYKEY"/>';
					
                                                                   
                                        if(document.getElementById("intMirror")!=null &amp;&amp; (Intelligent_Mirroring=='false' || Intelligent_Mirroring=='null') )
                                        {
                                           document.getElementById("intMirror").checked=false;
                                           document.getElementById("intMirror").disabled=true;
                                          
                                         }
                                         if(LAYOUT_SELECTED_ON_PAGE_LOAD=='512')
                                         {
                                            if(document.getElementById("intMirror")!=null &amp;&amp; Intelligent_Mirroring=='true')
                                            {
                                               document.getElementById("intMirror").checked=true;
                                            }
                                            if(document.getElementById("intMirror")!=null)
                                            {
                                               document.getElementById("intMirror").disabled=false;
                                            }
                                         }
                                   	<!-- DSA uses different function to append VID -->
					var Rules="<xsl:value-of select="$PARAM_DSA_Rules"/>";
					if (Rules == "1")
					{					
						top.gnv.appendVID = top.getFrame("OMA_gnv").appendDataAreaVID;
					}
				}
				function UpdateWithUserSelectedInputs()
				{<!-- Need to see if anything special needs to be done for DSA here-->
					var UserSelectedLayoutValue = "";
					var Rules="<xsl:value-of select="$PARAM_DSA_Rules"/>";
					if (Rules == "1")
					{
						UserSelectedLayoutValue = document.getElementById("PARAM_CURR_Layout").value;
					}
					else
					{
						UserSelectedLayoutValue = '<xsl:value-of select="$PARAM_CURR_Layout"/>';
					}
					if(UserSelectedLayoutValue !="null" &amp;&amp; UserSelectedLayoutValue !="" )
					{
						<!-- Make sure the user selected raid layout is still valid after page load.(when back button on wizard is used)-->
						if(IsRadioButtonEnabledForGivenRaidLayoutValue(UserSelectedLayoutValue ) == true)
						{
							setInputRaidLayoutValue(UserSelectedLayoutValue );
							
							
                                                       
						}
						else
						{
							var alertStrCfgChng = "<xsl:value-of select="$strCfgChngDetectCVDARLS"/>";
							var alertStrInvalidRaid = "<xsl:value-of select="$strRaidSelectionInvalidCVDARLS"/>";
							var alertStrReselectRaid = "<xsl:value-of select="$strReselectRaidTypeCVDARLS"/>"
							var alertStrRaidCfgChange = alertStrCfgChng+"\n"+alertStrInvalidRaid+"\n"+alertStrReselectRaid;
							alert(alertStrRaidCfgChange);
							LAYOUT_SELECTED_ON_PAGE_LOAD = "null";
						}
					}
				}
				function validate()
				{
                                 
                                 var NoneWizardSAelected = true;
                                 if( document.getElementById("ExpressWizard")!=null  &amp;&amp; document.getElementById("ExpressWizard").checked ==true)
                                  {      
                                         NoneWizardSAelected = false;
                                         if(expressWizardValidate()== false)
                                         {
                                              return false;
                                         }
                                    
                                    
                                  } 
                                 if( (document.getElementById("AdvancedWizard")!=null  &amp;&amp; document.getElementById("AdvancedWizard").checked ==true) || '<xsl:value-of select="$GLOBAL_VAR_CREATE_CACHECADE"/>' == '1')
                                  {     
                                       NoneWizardSAelected = false;
                                       if(advancedWizardValidate()== false)
                                        {
                                             return false;
                                        }
                                  }
                                  if( NoneWizardSAelected ==  true)
                                  {
                                       alert("<xsl:value-of  select="$strSelectCreateVDWizard"/>");
                                       return false;
                                  }
                                  
                                  return true;
					
				}
				function expressWizardValidate()
                                {
                                   
                                    if(getInputRaidLayoutValueForExpressWizard() == -1 )
					{
						alert("<xsl:value-of  select="$strSelectRaidLevel"/>");
						return false;
					}
                                        return true;
                                   
                                }
                                function advancedWizardValidate()
                                {
                                        if(IsSecureVDSelected()==false &amp;&amp; SECURE_VD_ROW == 1 )
					{      
						alert("<xsl:value-of  select="$strSelectSecureVD"/>");
						return false;
					}
                                        if(IsRaidLayoutSelected()==false &amp;&amp; '<xsl:value-of  select="$GLOBAL_VAR_CREATE_CACHECADE"/>' != '1')
					{
						alert("<xsl:value-of  select="$strSelectRaidLevel"/>");
						return false;
					}
                                        if(IsBusprotocolSelected()==false &amp;&amp; ( (BUS_PROTOCOL_TYPE_ROW == 1) || '<xsl:value-of  select="$GLOBAL_VAR_CREATE_CACHECADE"/>' == '1'))
					{
						alert("<xsl:value-of  select="$strSelectBusProtocol"/>");
						return false;
					}
                                        if(IsMediaTypeSelected()==false &amp;&amp; MEDIA_TYPE_ROW == 1)
					{
						alert("<xsl:value-of  select="$strSelectMediaType"/>");
						return false;
					}
					 if(IsSectorTypeSelected()==false &amp;&amp; SECTOR_TYPE_ROW == 1) //if sectortype supported but not selected before proceeding to next page 
					{
						alert("<xsl:value-of  select="$strSelectSectorSize"/>");
						return false;
					}
				<!--Uncomment for PI feature-->/*	 if(IsPITypeSelected()==false &amp;&amp; PI_TYPE_ROW == 1)
					{
						//alert("<xsl:value-of  select="$strSelectSectorSize"/>");
						return false;
					}*/
					return true;
                                }
				function submitCreateVDAdvancedRaidLayoutSelected()
				{
					<!--call validate before loading the next page-->
                                     
                                        
					if(validate() == false)
						return;
                                       if( document.getElementById("ExpressWizard")!=null  &amp;&amp; document.getElementById("ExpressWizard").checked ==true)
                                       { 
                                          submitExpressCreateVD();
                                       }
                                       else
                                       {
                                                
                                        var Prev_Intelligent_Mirroring=false;
                                        var CurrentIM=false;
                                        var CreateVDFilters="";
                                        var MediaType = getInputMediaTypeValue();
                                        var BusProtocol = getInputBusProtocolValue()
                                        //var SecureVD = getInputSecureVDValue() ;
										var SecureVD =  0;
										var VdPIEnabled = 0;
                                        var layoutValue = getInputRaidLayoutValue();
                                        var VDType = getInputVDSelectedType();
										if('1' == VDType || '2' == VDType)
										{
											//alert("setting VdPIEnabled to 1");
											
											VdPIEnabled = 1;
											if('1' == VDType)
											{
												SecureVD =1;
											}
												
										}
										else
										{
											VdPIEnabled = 0;
											if('3' == VDType)
											{
												SecureVD =1;
											}
										}
										
                                        var sectorSize = getInputSectorSizeValue();
										if(document.getElementById("VDTypeFilter")==null) 
										 { 
											 if(VDType == -1 || VDType == 0)
											{ 
												if('1' == '<xsl:value-of  select="$GLOBAL_VAR_PIExpressResults"/>')
												{
													VdPIEnabled = 1;
													SecureVD = 0;
												}
												if('1' == '<xsl:value-of  select="$GLOBAL_VAR_PISExpressResults"/>')
												{
													VdPIEnabled = 1;
													SecureVD = 1;
												}
												
												if('1' == '<xsl:value-of  select="$GLOBAL_VAR_SecureExpressResults"/>')
												{
													SecureVD = 1;
												}
											
											}
										 } 
                                                 if(document.getElementById("BusProtocolFilter")==null) 
                                                 { 
                                                        if(BusProtocol == -1)
                                                        { 
                                                                 BusProtocol= '<xsl:call-template name="GetNumberFromMask"><xsl:with-param name="num" select="$GLOBAL_VAR_BusProtocolMask"/></xsl:call-template>';
                                                         }
                                                         
                                                 } 
                                                 if(document.getElementById("MediaTypeFilter")==null) 
                                                 { 
                                                       if(MediaType == -1)
                                                        {        

                                                                 MediaType= '<xsl:value-of  select="$GLOBAL_VAR_MediaTypeMask"/>';
                                                                
                                                        }
                                                        
                                                 }
												 if(document.getElementById("SectorTypeFilter")==null) 
                                                 { 
                                                    if(1 == VDType )
                                                    {
                                                        sectorSize= '<xsl:value-of  select="$GLOBAL_VAR_PISecureSectorSizeMask"/>';
													}
                                                     else if(2 == VDType )
                                                    {
                                                        sectorSize= '<xsl:value-of  select="$GLOBAL_VAR_PISectorSizeMask"/>';
                                                     }
                                                     else if(3 == VDType )
                                                    {
                                                        sectorSize= '<xsl:value-of  select="$GLOBAL_VAR_SecureSectorSizeMask"/>';
                                                     }
                                                     else if(4 == VDType )
                                                    {
                                                        sectorSize= '<xsl:value-of  select="$GLOBAL_VAR_SectorSizeMask"/>';
                                                     }
                                                     else
                                                    {
                                                        sectorSize= '<xsl:value-of  select="$GLOBAL_VAR_SectorSizeMask"/>';
                                                     }
                                                } 
											
											document.getElementById("SecureVD").value = SecureVD;
                                               document.getElementById("BusProtocol").value = BusProtocol;
                                               document.getElementById("MediaType").value = MediaType;

                                               document.getElementById("SectorSize").value = sectorSize;     
											
                                        
                                  
                                        if('<xsl:value-of select="$PARAM_CURR_IM"/>'=='true')
                                        {
                                            Prev_Intelligent_Mirroring=true;
                                        }
										if(document.getElementById("intMirror")!=null)
                                        {
                                            var intMirror = document.getElementById("intMirror").checked;
                                        }
                                       if(intMirror)
                                        {
                                            CurrentIM=true;
                                        }
                                        else
                                        {  
                                            CurrentIM=false;
                                        }

                                      
 
                                        var selectAll = '<xsl:value-of select="$PARAM_CURR_SELECTALL"/>';
                                        var EnclosureSelectedList= '<xsl:value-of select="$PARAM_CURR_ENCLOSURESELECTEDLIST"/>';
                                        var EnclosureDisabledList= '<xsl:value-of select="$PARAM_CURR_ENCLOSUREDISABLEDLIST"/>';
                                        
					<!--The following code is checking for three things. i)page loaded for first time ii) page loaded by using back button on wizard and user selection
					remains unchanged iii)page loaded using back button and user has changed selection, in which case CACHED_PARAMS and STATE_PARAMS should not be used for
					loading next page-->
                                        
					var Rules="<xsl:value-of select="$PARAM_DSA_Rules"/>";
					if (Rules == "1")
					{       
						<!-- Flush and reload the DSA javascript page cache on submit. -->
						cachePageInDSA();
						LAYOUT_SELECTED_ON_PAGE_LOAD = document.getElementById("PARAM_CURR_Layout").value;
					}
                                        if('<xsl:value-of select="$GLOBAL_VAR_CREATE_CACHECADE"/>' == '1')
                                        {      
                                               ControllerOID =  "<xsl:value-of select="/OMA/ControllerOID"/>";
                                               ControllerName = "<xsl:value-of select="/OMA/ControllerName"/>";
	                                         
                                           <!--Uncomment for PI feature-->  //  var NextPageURL =  "./DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedAdiskSelectionWebPlugin&amp;Layout=2&amp;BusProtocol="+BusProtocol+"&amp;MediaType="+MediaType+"&amp;SectorSize="+SectorSize+"&amp;PIEnabled="+PIEnabledValue+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;ManageSSC=1"+"&amp;ControllerOID="+ControllerOID+"&amp;ControllerName="+ControllerName+"&amp;Layout="+CACHECADELAYOUT;
                                                var NextPageURL =  "./DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedAdiskSelectionWebPlugin&amp;Layout=2&amp;BusProtocol="+BusProtocol+"&amp;MediaType="+MediaType+"&amp;SectorSize="+SectorSize+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;ManageSSC=1"+"&amp;ControllerOID="+ControllerOID+"&amp;ControllerName="+ControllerName+"&amp;Layout="+CACHECADELAYOUT;
                                               document.location.href = top.gnv.appendVID(NextPageURL);
                                        }
					else if((LAYOUT_SELECTED_ON_PAGE_LOAD == "null" || layoutValue == LAYOUT_SELECTED_ON_PAGE_LOAD) &amp;&amp; CurrentIM==Prev_Intelligent_Mirroring &amp;&amp; SecureVDOnPageLoad==SecureVD)
					{        
						var NextPageURL =  "./DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedAdiskSelectionWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;"+CreateVDFilters;
						if (Rules == "1")
						{ 
							var DSA_cachedValues = document.getElementById("CACHED_PARAMS").value + "&amp;" + document.getElementById("STATE_PARAMS").value;
							NextPageURL += DSA_cachedValues;
						}
						else
						{ 
							var OMSS_cachedValues = "<xsl:value-of select="$CACHED_PARAMS"/>&amp;<xsl:value-of select="$STATE_PARAMS"/>";
							NextPageURL += OMSS_cachedValues;
						}
						
					<!--Uncomment for PI feature--> //NextPageURL += "&amp;Layout="+layoutValue+"&amp;IntMirror="+intMirror+"&amp;BusProtocol="+BusProtocol+"&amp;MediaType="+MediaType+"&amp;SectorSize="+sectorSize+"&amp;PIEnabled="+PIEnabledValue+"&amp;SelectAllVal="+selectAll+"&amp;EnclosureSelectedList="+EnclosureSelectedList+"&amp;EnclosureDisabledList="+EnclosureDisabledList+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;SecureVD="+SecureVD+"&amp;SingleSpanVD=<xsl:value-of select="/OMA/SingleSpanVD"/>";
					NextPageURL += "&amp;Layout="+layoutValue+"&amp;IntMirror="+intMirror+"&amp;BusProtocol="+BusProtocol+"&amp;MediaType="+MediaType+"&amp;SectorSize="+sectorSize+"&amp;SelectAllVal="+selectAll+"&amp;EnclosureSelectedList="+EnclosureSelectedList+"&amp;EnclosureDisabledList="+EnclosureDisabledList+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;SecureVD="+SecureVD+"&amp;VdPIEnabled="+VdPIEnabled+"&amp;SingleSpanVD=<xsl:value-of select="/OMA/SingleSpanVD"/>";
						                          
						document.location.href = top.gnv.appendVID(NextPageURL);
					}
                                       
					else
					{        
                                                
                                                 if(document.getElementById("SingleSpanVD")!=null) 
                                                  { 
                                                        document.getElementById("SingleSpanVD").value='<xsl:value-of select="/OMA/SingleSpanVD"/>';
                                                  } 
                                                  
                                                  document.dataarea.action = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedAdiskSelectionWebPlugin&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;SecureVD="+SecureVD+"&amp;VdPIEnabled="+VdPIEnabled+"&amp;Layout="+layoutValue+"&amp;IntMirror="+intMirror+CreateVDFilters);
                                                  document.dataarea.submit();
				}
		        }
                    }
                           // Commenting this code will be required for PI feature            
                         /* function OnPIEnableAttribSelected(element)
						  {
								
						    	 if( element.checked == true)
									 document.getElementById(element.name).value = 1;
								else
								    document.getElementById(element.name).value = 0;
						  
						  }*/

                        function OnAdvancedWizardSelected()
                        {
						//If advanced wizard radio button selected then disable all the express wizard elements and uncheck the express wizard button
						 DisableAllOptionsOnExpressWizard();
						 if(document.getElementById("ExpressWizard")!=null)
                            {
                                 document.getElementById("ExpressWizard").checked = false;
                            }
							
                           WizardInitializationRoutine(); // Now enable advanced wizard elements for selection 
						
                        }
                        
                        function OnExpressWizardSelected()
                        {	//If express wizard radio button selected then disable all the advanced wizard elements and uncheck the advanced wizard button
						 DisableAllOptionsOnAdvancedWizard();
						 if(document.getElementById("AdvancedWizard")!=null)
                            {
                                 document.getElementById("AdvancedWizard").checked = false;
                            }
						EnableValidRaidLevels(); // Enable express wizard elements that is Raid levels for express wizard
                      
                        }
                        

                             
                            
              	</script>
			<script language="javascript">
				<xsl:call-template name="getCommonScripts"/>
				<xsl:if test="$PARAM_DSA_Rules='1'">
					<!-- Include the DSA caching scripts if OMSS Lite mode. Specify relevant parameters to the template. -->
					<xsl:call-template name="getDSAScripts">
						<xsl:with-param name="PARAM_Screen_Name"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:with-param>
						<xsl:with-param name="PARAM_Prev_Page_URL"><xsl:value-of select="$GLOBAL_PARAM_Prev_Page_URL"/></xsl:with-param>
						<xsl:with-param name="PARAM_Exit_Wizard_URL"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:with-param>
					</xsl:call-template>

					function expressWizardInDSA()
					{
						cachePageInDSA();
						document.dataarea.action = top.getFrame("OMA_gnv").appendDataAreaVID("<xsl:value-of select="$GLOBAL_PARAM_Express_Wizard_URL"/>");
						document.dataarea.submit();
					}
				</xsl:if>
			</script>
			<PageTitle>
                                <xsl:choose>
                                   <xsl:when test="$GLOBAL_VAR_CREATE_CACHECADE = '1'">
                                       <xsl:attribute name="display"><xsl:value-of select="$strCacheTitlepart1"/><xsl:value-of select="$PARAM_REGULAR_ControllerName"/><xsl:value-of select="$strCacheTitlepart2"/></xsl:attribute>
                                   </xsl:when>
                                   <xsl:otherwise>
                                       <xsl:attribute name="display"><xsl:value-of select="$strTitleMainStartCVDARLS"/><xsl:value-of select="$PARAM_REGULAR_ControllerName"/><xsl:value-of select="$strTitleMainEndCVDARLS"/></xsl:attribute>
                                   </xsl:otherwise>    
                                </xsl:choose>
			</PageTitle>

                 
                
                 

			
			<xsl:call-template name="RenderBottomCustomButtons"/>
			
			
			<!-- Check to see if the bit that takes you directly to advanced wizard is on -->
			<xsl:variable name="isDirectToAdvancedWizard">
				<xsl:choose>
					<xsl:when test="$PARAM_DSA_Rules !='1' and substring(/OMA/Controllers/DCStorageObject/AttributesMask,13,1)='1'">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>			
			
			<!-- In DSA mode if SAS 5ira has > 2 disks, Express wiz. is disabled. Disable the Express wiz. button displayed on Lefthand top corner of Advance wiz. -->
			<xsl:if test="$GLOBAL_PARAM_DSARaidModeAndDiskCheck = '0' and $GLOBAL_VAR_CREATE_CACHECADE! = '1'">
				<!-- in OMSS, no express wizard button if bitmask for controller is set to advanced wizard only -->	
				<xsl:if test="$isDirectToAdvancedWizard!='1'">			
					  <TableData>
                                              
                                           <Row> 
                                                     <Data name="ExpressWizard" type="radio" value="{$strExpressCVDARLS}" returnvalue="{$GLOBAL_VAR_EXPRESS_WIZARD}" handler="javascript:OnExpressWizardSelected()"  event="onclick" state="0" width="50%" noborderright="true"/>                                                    
						     <Data/>
                                             </Row>
                                             <Row>
                                                  <Data value="{$strTypeCVDU}" width="50%" spans="2" noborderright="true"/>
                                                  <Data type="select"  event="onchange" name="ExpressVDLayout" width="100" align="left" noborderright="true">
                                                         <Choice default="true">
                                                             <xsl:attribute name="value"><xsl:value-of select="$strSelectRAID"/></xsl:attribute>
                                                             <xsl:attribute name="returnvalue">-1</xsl:attribute>
                                                         </Choice>
                                                         <xsl:call-template name="for-loop">
                                                            <xsl:with-param name="AdvancedWizard" select="false"/>
                                                            <xsl:with-param name="Mask" select="$GLOBAL_VAR_RaidLevelsMask"/>
                                                            <xsl:with-param name="RULES" select="$PARAM_DSA_Rules"/>
                                                          </xsl:call-template>
				                      </Data>
                                             </Row>
                                           </TableData>
				 </xsl:if>
			</xsl:if>

                      
			<xsl:choose>
                      <xsl:when test="$GLOBAL_VAR_CREATE_CACHECADE != '1'">

				<xsl:call-template name="RenderCreateVDTable">
					<xsl:with-param name="RAIDMask"><xsl:value-of select="$GLOBAL_VAR_RaidLevelsMask"/></xsl:with-param>
					<xsl:with-param name="MEDIAMask"><xsl:value-of select="$GLOBAL_VAR_MediaTypeMask"/></xsl:with-param>
										
					<xsl:with-param name="PROTOCOLMask"><xsl:value-of select="$GLOBAL_VAR_BusProtocolMask"/></xsl:with-param>
					<xsl:with-param name="SectorSizeMask"><xsl:value-of select="$GLOBAL_VAR_SectorSizeMask"/></xsl:with-param>
					<!--Uncomment for PI feature--><!--xsl:with-param name="PIEnabledMask"><xsl:value-of select="$GLOBAL_VAR_PIEnabledMask"/></xsl:with-param-->
                    <xsl:with-param name="HIDE_SECURE_VD_ROW"><xsl:choose><xsl:when test="$GLOBAL_VAR_SecureExpressResults != '1'">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:with-param>
					<xsl:with-param name="HIDE_PIENABLED_VD_ROW"><xsl:choose><xsl:when test="$GLOBAL_VAR_HIDE_VD_FILTER = '1'">false</xsl:when><xsl:otherwise>true</xsl:otherwise></xsl:choose></xsl:with-param>
					<xsl:with-param name="HIDE_SIZE_ROW">true</xsl:with-param>
					<xsl:with-param name="HIDE_NAME_ROW">true</xsl:with-param>
					<xsl:with-param name="HIDE_MIN_MAX_ROW">true</xsl:with-param>
					<xsl:with-param name="HIDE_MEDIA_TYPE_ROW"><xsl:choose><xsl:when test="$GLOBAL_VAR_MediaTypeMask ='1'">true</xsl:when><xsl:when test="$GLOBAL_VAR_MediaTypeMask = '2'">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:with-param>
					<xsl:with-param name="HIDE_BUS_PROTOCOL_TYPE_ROW"><xsl:choose><xsl:when test="$GLOBAL_VAR_BusProtocolMask = '128'">true</xsl:when><xsl:when test="$GLOBAL_VAR_BusProtocolMask = '256'">true</xsl:when><xsl:when test="$GLOBAL_VAR_BusProtocolMask = '1'">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:with-param>
					<xsl:with-param name="HIDE_SectorSize_TYPE_ROW"><xsl:choose><xsl:when test="$GLOBAL_VAR_SectorSizeMask = '512'">true</xsl:when><xsl:when test="$GLOBAL_VAR_SectorSizeMask = '4096'">true</xsl:when><xsl:when test="$GLOBAL_VAR_SectorSizeMask = '0'">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:with-param>
					<!--Uncomment for PI feature--><!--xsl:with-param name="HIDE_PIEnabled_TYPE_ROW"><xsl:choose><xsl:when test="$GLOBAL_VAR_PIEnabledMask = '1'">true</xsl:when><xsl:when test="$GLOBAL_VAR_PIEnabledMask = '3'">true</xsl:when><xsl:when test="$GLOBAL_VAR_PIEnabledMask = '0'">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:with-param-->
					<xsl:with-param name="SELECT_RAID_HEADER"><xsl:value-of select="$strTblHeaderCVDARLS"/></xsl:with-param>
					<xsl:with-param name="RULES"><xsl:value-of select="$PARAM_DSA_Rules"/></xsl:with-param>
					<xsl:with-param name="GLOBAL_VAR_ADVANCED_WIZARD">1</xsl:with-param>

				</xsl:call-template>
				
                       </xsl:when>  
                       <xsl:when test="$GLOBAL_VAR_CREATE_CACHECADE = '1'">
							<xsl:call-template name="RenderCreateVDTable">
							<xsl:with-param name="PROTOCOLMask"><xsl:value-of select="$GLOBAL_VAR_BusProtocolMask"/></xsl:with-param>
							<xsl:with-param name="HIDE_SECURE_VD_ROW">true</xsl:with-param>
							<xsl:with-param name="HIDE_PIENABLED_VD_ROW">true</xsl:with-param>
							<xsl:with-param name="HIDE_SIZE_ROW">true</xsl:with-param>
							<xsl:with-param name="HIDE_NAME_ROW">true</xsl:with-param>
							<xsl:with-param name="HIDE_MIN_MAX_ROW">true</xsl:with-param>
							<xsl:with-param name="HIDE_MEDIA_TYPE_ROW">true</xsl:with-param>
							<xsl:with-param name="HIDE_SectorSize_TYPE_ROW">true</xsl:with-param>
							<!--Uncomment for PI feature--><!--xsl:with-param name="HIDE_PIEnabled_TYPE_ROW">true</xsl:with-param--><!--Uncomment for PI feature-->
							<xsl:with-param name="HIDE_BUS_PROTOCOL_TYPE_ROW">false</xsl:with-param>
							<xsl:with-param name="HIDE_RAID_DESC_ROW">true</xsl:with-param>
							<xsl:with-param name="RULES"><xsl:value-of select="$PARAM_DSA_Rules"/></xsl:with-param>
				</xsl:call-template>


                       </xsl:when>
                    </xsl:choose>   
			<HiddenTable>
                        
			<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="AvailableRaidLayout_HIDDEN_TABLE"/></xsl:for-each>
			<xsl:for-each select="//SecureExpressResults/DCStorageObject"><xsl:call-template name="AvailableSecureVDRaidLayout_HIDDEN_TABLE"/></xsl:for-each>
			<xsl:for-each select="//PIExpressResults/DCStorageObject"><xsl:call-template name="AvailablePIRaidLayout_HIDDEN_TABLE"/></xsl:for-each>
			<xsl:for-each select="//PISecureExpressResults/DCStorageObject"><xsl:call-template name="AvailablePISecureRaidLayout_HIDDEN_TABLE"/></xsl:for-each>			
				<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
				<!-- Ashesh: Passing cached_params and state_params as hidden values so that these values can be cached.  -->
				<xsl:call-template name="cachedValues"/>
			</HiddenTable>
                
                        <HiddenTable>
				<Data>
					<xsl:attribute name="name">SingleSpanVD</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable>
                      
                        <HiddenTable>
				<Data>
					<xsl:attribute name="name">BusProtocol</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable>
                        <HiddenTable>
				<Data>
					<xsl:attribute name="name">SecureVD</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable>
                        <HiddenTable>
				<Data>
					<xsl:attribute name="name">MediaType</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable>
			<HiddenTable>
				<Data>
					<xsl:attribute name="name">SectorSize</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable>
			<!--Uncomment for PI feature--> <!--HiddenTable>
				<Data>
					<xsl:attribute name="name">PIEnabled</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable-->

		</DataArea>
	</xsl:template>
	
	<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
	<!-- Ashesh: Template for hidden values to cache for this page -->
	<xsl:template name="cachedValues">
		<Data type="hidden">
			<xsl:attribute name="name">CACHED_PARAMS</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="$CACHED_PARAMS"/></xsl:attribute>
		</Data>
		<Data type="hidden">
			<xsl:attribute name="name">STATE_PARAMS</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="$STATE_PARAMS"/></xsl:attribute>
		</Data>
		<Data type="hidden">
			<xsl:attribute name="name">PARAM_CURR_Layout</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="$PARAM_CURR_Layout"/></xsl:attribute>
		</Data>
    </xsl:template>

	<xsl:template name="RenderBottomCustomButtons">
		<BottomCustomButton>
			<Data display="{$strContinueCVDARLS}" formSubmit="true" href="javascript:submitCreateVDAdvancedRaidLayoutSelected()" id="submitbuttoncontent"/>
		</BottomCustomButton>
		<BottomCustomButton>
			<Data formSubmit="true" display="{$strCancelCVDARLS}">
				<xsl:attribute name="href">
					<xsl:choose>
						<!-- We use the DSA caching javascript function to exit the wizard in case of DSA. -->
						<xsl:when test="$PARAM_DSA_Rules ='1'">javascript:exitWizardInDSA();</xsl:when>
						<xsl:otherwise><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</BottomCustomButton>
	</xsl:template>
	
</xsl:stylesheet>



