<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- the xsl included below contains messages for error codes-->
	<xsl:include href="smmsgs.xsl"/>
  <xsl:variable name="WSManError" select="/OMA/WSManError"/>

  <xsl:template match="/">
		<DataArea exportdata="false">
      <xsl:choose>
        <xsl:when test="$WSManError != 0 and $WSManError !='' and $WSManError != 'null'">
          <xsl:attribute name="email">false</xsl:attribute>
          <xsl:attribute name="printable">false</xsl:attribute>
					<PageTitle alert="false">
						<xsl:attribute name="display"><xsl:value-of select="$strActionPerformed"/><xsl:call-template name="GetMessage"><xsl:with-param name="ErrorID" select="/OMA/ErrorCode"/><xsl:with-param name="WSManError" select="$WSManError"/></xsl:call-template></xsl:attribute>
					</PageTitle>
        </xsl:when>
        <xsl:otherwise>
          <PageTitle>
				    <xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="//ControllerName"/></xsl:attribute>
			    </PageTitle>
			    <SubHeader><xsl:attribute name="display"><xsl:call-template name="GetMessage"><xsl:with-param name="ErrorID" select="/OMA/ErrorCode"/><xsl:with-param name="WSManError" select="$WSManError"/></xsl:call-template></xsl:attribute></SubHeader>
        </xsl:otherwise>
      </xsl:choose>

      <CustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.HandleCreateVDErrorWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;ErrorCode=<xsl:value-of select="/OMA/ErrorCode"/>&amp;WSManErrorCode=<xsl:value-of select="$WSManError"/></xsl:attribute>
				</Data>
			</CustomButton>
			<BottomCustomButton>
				<Data>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;Action=false</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strGoToCtrlInfoPage"/></xsl:attribute>
				</Data>
			</BottomCustomButton>
		</DataArea>
	</xsl:template>
</xsl:stylesheet>
