<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc which can be resused/-->
	<xsl:include href="Utils.xsl"/>
	<xsl:include href="cvdutils.xsl"/>
	<xsl:include href="dsautils.xsl"/>
	<xsl:key name="ADsForChannel" match="//ArrayDisks" use="@EnclosureName"/>
	<!--DEFINE A BUNCH OF GLOBAL VARIABLES THAT CAN BE USED THROUGH OUT THE XSL-->
	<!-- Independent global variables-->
      <xsl:variable name="GLOBAL_VAR_SecurityEnabled">
         <xsl:choose>
              <xsl:when test="substring(//Controllers/DCStorageObject/AttributesMask,8,1)='1' and substring(//Controllers/DCStorageObject/AttributesMask,9,1)='1' ">1</xsl:when>
              <xsl:otherwise>0</xsl:otherwise>
         </xsl:choose>
      </xsl:variable> 
    <xsl:variable name="GLOBAL_VAR_PercVersion">
         <xsl:choose>
              <xsl:when test="substring(//Controllers/DCStorageObject/AttributesMask1,24,1)='1'">9</xsl:when>
              <xsl:otherwise>0</xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
	  
	  <xsl:variable name="PARAM_PERC9">
         <xsl:choose>
              <xsl:when test="$GLOBAL_VAR_PercVersion='9'">true</xsl:when>
              <xsl:otherwise>false</xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
        <xsl:variable name="GLOBAL_VAR_CreateSSC"><xsl:value-of select="//CreateEnhancedCacheDisk"/></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_MinDrivesForConcat"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MinDrivesForConcat"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MinDrivesForRAID0"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MinDrivesForRAID0"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MinDrivesForRAID1"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MinDrivesForRAID1"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MinDrivesForRAID5"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MinDrivesForRAID5"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MinDrivesForRAID6"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MinDrivesForRAID6"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MinDrivesForRAID10"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MinDrivesForRAID10"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MinDrivesForRAID50"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MinDrivesForRAID50"/></xsl:variable>
      <xsl:variable name="GLOBAL_VAR_MinDrivesForRAID1E"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MinDrivesForRAID1E"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MinDrivesForRAID60"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MinDrivesForRAID60"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MinDrivesForRAID1Concat"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MinDrivesForRAID1Concat"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxDrivesForConcat"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxDrivesForConcat"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxDrivesForRAID0"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxDrivesForRAID0"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxDrivesForRAID1"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxDrivesForRAID1"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxDrivesForRAID5"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxDrivesForRAID5"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxDrivesForRAID6"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxDrivesForRAID6"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxDrivesForRAID10"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxDrivesForRAID10"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxDrivesForRAID50"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxDrivesForRAID50"/></xsl:variable>
      <xsl:variable name="GLOBAL_VAR_MaxDrivesForRAID1E"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxDrivesForRAID1E"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxDrivesForRAID60"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxDrivesForRAID60"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxDrivesForRAID1Concat"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxDrivesForRAID1Concat"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_ControllerSupportedMaxNumOfSpans"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxNumOfSpans"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_ControllerSupportedMaxNumOfDisksInSpan"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxNumOfDisksInSpan"/></xsl:variable>
	<!-- disk groups for a VD creation -->
        <xsl:variable name="GLOBAL_VAR_ArrayDiskCount"><xsl:value-of select="count(//ArrayDisks/DCStorageObject[(ObjStatus = '2' or ObjStatus = '3') and (ObjState = '1' or ObjState = '4' or ObjState = '8388608') ])"/></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_ArrayNumDisks">
		<xsl:for-each select="//ExpressResults[@ArrayNum != '-1']">
			<xsl:for-each select="DCStorageObject">
				<xsl:value-of select="DIDList"/>
			</xsl:for-each>
			<xsl:if test="position() != last()"><xsl:text>;</xsl:text></xsl:if>
		</xsl:for-each>
	  </xsl:variable>
        <xsl:variable name="GLOBAL_VAR_ArraySpanLength">
		<xsl:if test="//ExpressResults[@ArrayNum != '-1']/DCStorageObject/SpanLength">
			<xsl:for-each select="//ExpressResults[@ArrayNum != '-1']">
				<xsl:for-each select="DCStorageObject">
					<xsl:value-of select="SpanLength"/> 
				</xsl:for-each>
				<xsl:if test="position() != last()"><xsl:text>;</xsl:text></xsl:if>
			</xsl:for-each>
		</xsl:if>
	  </xsl:variable>
        <!--xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure01"><xsl:value-of select="count(//ArrayDisks/DCStorageObject[Channel = '0' and EnclosureID = '1' and (ObjStatus = '2' or ObjStatus = '3') and (ObjState = '1' or ObjState = '4' or ObjState = '8388608')])"/></xsl:variable-->
        <xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure00"><xsl:call-template name="GetMax00"><xsl:with-param name="values" select="//ArrayDisks/DCStorageObject"/></xsl:call-template></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure01"><xsl:call-template name="GetMax01"><xsl:with-param name="values" select="//ArrayDisks/DCStorageObject"/></xsl:call-template></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure02"><xsl:call-template name="GetMax02"><xsl:with-param name="values" select="//ArrayDisks/DCStorageObject"/></xsl:call-template></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure03"><xsl:call-template name="GetMax03"><xsl:with-param name="values" select="//ArrayDisks/DCStorageObject"/></xsl:call-template></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure10"><xsl:call-template name="GetMax10"><xsl:with-param name="values" select="//ArrayDisks/DCStorageObject"/></xsl:call-template></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure11"><xsl:call-template name="GetMax11"><xsl:with-param name="values" select="//ArrayDisks/DCStorageObject"/></xsl:call-template></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure12"><xsl:call-template name="GetMax12"><xsl:with-param name="values" select="//ArrayDisks/DCStorageObject"/></xsl:call-template></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure13"><xsl:call-template name="GetMax13"><xsl:with-param name="values" select="//ArrayDisks/DCStorageObject"/></xsl:call-template></xsl:variable>

        <!--xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure02"><xsl:value-of select="count(//ArrayDisks/DCStorageObject[Channel = '0' and EnclosureID = '2' and (ObjStatus = '2' or ObjStatus = '3') and (ObjState = '1' or ObjState = '4' or ObjState = '8388608')])"/></xsl:variable>  
        <xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure03"><xsl:value-of select="count(//ArrayDisks/DCStorageObject[Channel = '0' and EnclosureID = '3' and (ObjStatus = '2' or ObjStatus = '3') and (ObjState = '1' or ObjState = '4' or ObjState = '8388608')])"/></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure10"><xsl:value-of select="count(//ArrayDisks/DCStorageObject[Channel = '1' and EnclosureID = '0' and (ObjStatus = '2' or ObjStatus = '3') and (ObjState = '1' or ObjState = '4' or ObjState = '8388608')])"/></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure11"><xsl:value-of select="count(//ArrayDisks/DCStorageObject[Channel = '1' and EnclosureID = '1' and (ObjStatus = '2' or ObjStatus = '3') and (ObjState = '1' or ObjState = '4' or ObjState = '8388608')])"/></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure12"><xsl:value-of select="count(//ArrayDisks/DCStorageObject[Channel = '1' and EnclosureID = '2' and (ObjStatus = '2' or ObjStatus = '3') and (ObjState = '1' or ObjState = '4' or ObjState = '8388608')])"/></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_ArrayDiskEnclosure13"><xsl:value-of select="count(//ArrayDisks/DCStorageObject[Channel = '1' and EnclosureID = '3' and (ObjStatus = '2' or ObjStatus = '3') and (ObjState = '1' or ObjState = '4' or ObjState = '8388608')])"/></xsl:variable-->
        <xsl:variable name="GLOBAL_VAR_EnclosureOnChannel_0"><xsl:value-of select="count(//ArrayDisks[@ChannelName = 'Channel 0'])"/></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_EnclosureOnChannel_1"><xsl:value-of select="count(//ArrayDisks[@ChannelName = 'Channel 1'])"/></xsl:variable>
         <xsl:variable name="GLOBAL_VAR_MAX_Enclosures">4</xsl:variable>
      <xsl:template name="GetMax00">
                <xsl:param name="values"/>
                <xsl:variable name="max">
                    <xsl:for-each select="$values[Channel = '0' and EnclosureID = '0']">
                    <xsl:sort select="TargetID" data-type="number" order="descending"/>
                             <xsl:if test="position()=1">
                               <xsl:copy-of select="TargetID"/>
                             </xsl:if>
                     </xsl:for-each>
                 </xsl:variable>
           <xsl:choose>
           <xsl:when test="$max ='' and count($values[Channel = '0' and not(EnclosureID)]) &gt; 0">24</xsl:when>
           <xsl:when test="$max &gt; 0 or $max= '0' ">
                      <xsl:value-of select="$max + 1"/>
           </xsl:when>
           <xsl:otherwise>0</xsl:otherwise></xsl:choose>
  </xsl:template>      
  <xsl:template name="GetMax01">
                <xsl:param name="values"/>
                <xsl:variable name="max">
                    <xsl:for-each select="$values[Channel = '0' and EnclosureID = '1']">
                    <xsl:sort select="TargetID" data-type="number" order="descending"/>
                             <xsl:if test="position()=1">
                               <xsl:copy-of select="TargetID"/>
                             </xsl:if>
                     </xsl:for-each>
                 </xsl:variable>
           <xsl:choose>
           <xsl:when test="$max ='' and count($values[Channel = '0' and not(EnclosureID)]) &gt; 0">24</xsl:when>
           <xsl:when test="$max &gt; 0 or $max= '0' ">
                      <xsl:value-of select="$max + 1"/>
           </xsl:when>
           <xsl:otherwise>0</xsl:otherwise></xsl:choose>
  </xsl:template>      
 <xsl:template name="GetMax02">
                <xsl:param name="values"/>
                <xsl:variable name="max">
                    <xsl:for-each select="$values[Channel = '0' and EnclosureID = '2']">
                    <xsl:sort select="TargetID" data-type="number" order="descending"/>
                             <xsl:if test="position()=1">
                               <xsl:copy-of select="TargetID"/>
                             </xsl:if>
                     </xsl:for-each>
                 </xsl:variable>
           <xsl:choose>
           <xsl:when test="$max ='' and count($values[Channel = '0' and not(EnclosureID)]) &gt; 0">24</xsl:when>
           <xsl:when test="$max &gt; 0 or $max= '0' ">
                      <xsl:value-of select="$max + 1"/>
           </xsl:when>
           <xsl:otherwise>0</xsl:otherwise></xsl:choose>
  </xsl:template>      
<xsl:template name="GetMax03">
                <xsl:param name="values"/>
                <xsl:variable name="max">
                    <xsl:for-each select="$values[Channel = '0' and EnclosureID = '3']">
                    <xsl:sort select="TargetID" data-type="number" order="descending"/>
                             <xsl:if test="position()=1">
                               <xsl:copy-of select="TargetID"/>
                             </xsl:if>
                     </xsl:for-each>
                 </xsl:variable>
           <xsl:choose>
           <xsl:when test="$max ='' and count($values[Channel = '0' and not(EnclosureID)]) &gt; 0">24</xsl:when>
           <xsl:when test="$max &gt; 0 or $max= '0' ">
                      <xsl:value-of select="$max + 1"/>
          </xsl:when>
           <xsl:otherwise>0</xsl:otherwise></xsl:choose>
  </xsl:template>      
  <xsl:template name="GetMax10">
                <xsl:param name="values"/>
                <xsl:variable name="max">
                    <xsl:for-each select="$values[Channel = '1' and EnclosureID = '0']">
                    <xsl:sort select="TargetID" data-type="number" order="descending"/>
                             <xsl:if test="position()=1">
                               <xsl:copy-of select="TargetID"/>
                             </xsl:if>
                     </xsl:for-each>
                 </xsl:variable>
           <xsl:choose>
           <xsl:when test="$max ='' and count($values[Channel = '1' and not(EnclosureID)]) &gt; 0">24</xsl:when>
           <xsl:when test="$max &gt; 0 or $max= '0'">
                      <xsl:value-of select="$max + 1"/>
          </xsl:when>
           <xsl:otherwise>0</xsl:otherwise></xsl:choose>
  </xsl:template>      
<xsl:template name="GetMax11">
                <xsl:param name="values"/>
                <xsl:variable name="max">
                    <xsl:for-each select="$values[Channel = '1' and EnclosureID = '1']">
                    <xsl:sort select="TargetID" data-type="number" order="descending"/>
                             <xsl:if test="position()=1">
                               <xsl:copy-of select="TargetID"/>
                             </xsl:if>
                     </xsl:for-each>
                 </xsl:variable>
           <xsl:choose>
           <xsl:when test="$max ='' and count($values[Channel = '1' and not(EnclosureID)]) &gt; 0">24</xsl:when>
           <xsl:when test="$max &gt; 0 or $max= '0'">
                      <xsl:value-of select="$max + 1"/>
           </xsl:when>
           <xsl:otherwise>0</xsl:otherwise></xsl:choose>
  </xsl:template>   
<xsl:template name="GetMax12">
                <xsl:param name="values"/>
                <xsl:variable name="max">
                    <xsl:for-each select="$values[Channel = '1' and EnclosureID = '2']">
                    <xsl:sort select="TargetID" data-type="number" order="descending"/>
                             <xsl:if test="position()=1">
                               <xsl:copy-of select="TargetID"/>
                             </xsl:if>
                     </xsl:for-each>
                 </xsl:variable>
           <xsl:choose>
           <xsl:when test="$max ='' and count($values[Channel = '1' and not(EnclosureID)]) &gt; 0">24</xsl:when>
           <xsl:when test="$max &gt; 0 or $max= '0'">
                      <xsl:value-of select="$max + 1"/>
           </xsl:when> 
           <xsl:otherwise>0</xsl:otherwise></xsl:choose>
  </xsl:template>  
<xsl:template name="GetMax13">
                <xsl:param name="values"/>
                <xsl:variable name="max">
                    <xsl:for-each select="$values[Channel = '1' and EnclosureID = '3']">
                    <xsl:sort select="TargetID" data-type="number" order="descending"/>
                             <xsl:if test="position()=1">
                               <xsl:copy-of select="TargetID"/>
                             </xsl:if>
                     </xsl:for-each>
                 </xsl:variable>
	           <xsl:choose>
           <xsl:when test="$max ='' and count($values[Channel = '1' and not(EnclosureID)]) &gt; 0">24</xsl:when>
           <xsl:when test="$max &gt; 0 or $max= '0' ">
                      <xsl:value-of select="$max + 1"/>
           </xsl:when>
           <xsl:otherwise>0</xsl:otherwise>
           </xsl:choose>
  </xsl:template>             
      <!-- -->
      
      
      
       <xsl:variable name="CreateSecureVD"><xsl:value-of select="/OMA/SecureVD"/></xsl:variable>
	   <xsl:variable name="VdPIEnabled"><xsl:value-of select="/OMA/VdPIEnabled"/></xsl:variable>
        <xsl:variable name="PARAM_DSA_Rules"><xsl:value-of select="/OMA/Rules"/></xsl:variable>
	<xsl:variable name="PARAM_DSA_DisplayVDConfig"><xsl:value-of select="/OMA/DisplayVDConfig"/></xsl:variable>
	<xsl:variable name="PARAM_DSA_OutputFileName"><xsl:value-of select="/OMA/OutputFileName"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_ControllerOID"><xsl:value-of select="/OMA/ControllerOID"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_ControllerName"><xsl:value-of select="/OMA/ControllerName"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_FILE"><xsl:value-of select="/OMA/FILE"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_OrigURL"><xsl:value-of select="/OMA/OrigURL"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_Layout"><xsl:value-of select="/OMA/Layout"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_SectorSize"><xsl:value-of select="/OMA/SectorSize"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_VDName"><xsl:value-of select="/OMA/VDName"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_Length"><xsl:value-of select="/OMA/Length"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_ReadPolicy"><xsl:value-of select="/OMA/ReadPolicy"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_WritePolicy"><xsl:value-of select="/OMA/WritePolicy"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_CachePolicy"><xsl:value-of select="/OMA/CachePolicy"/></xsl:variable>
    <xsl:variable name="PARAM_NEXT_DiskCachePolicy"><xsl:value-of select="/OMA/DiskCachePolicy"/></xsl:variable>
    <xsl:variable name="PARAM_NEXT_StripeSize"><xsl:value-of select="/OMA/StripeSize"/></xsl:variable>
	<xsl:variable name="PARAM_STATE_UserSelectedAdiskArrayNumList"><xsl:value-of select="/OMA/UserSelectedAdiskArrayNumList"/></xsl:variable>
	<xsl:variable name="PARAM_STATE_UserSelectedAdiskContiguousFreeSpaceList"><xsl:value-of select="/OMA/UserSelectedAdiskContiguousFreeSpaceList"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_IDList"><xsl:value-of select="/OMA/IDList"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_SpanLength"><xsl:value-of select="/OMA/SpanLength"/></xsl:variable>
    <xsl:variable name="PARAM_CURR_SingleSpanVD"><xsl:value-of select="/OMA/SingleSpanVD"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_IM"><xsl:value-of select="/OMA/IntMirror"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_SELECTALL"><xsl:value-of select="/OMA/SelectAll"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_ENCLOSURESELECTEDLIST"><xsl:value-of select="/OMA/EnclosureSelectedList"/></xsl:variable>
    <xsl:variable name="PARAM_CURR_ENCLOSUREDISABLEDLIST"><xsl:value-of select="/OMA/EnclosureDisabledList"/></xsl:variable>
    <xsl:variable name="PARAM_SPANEDITMODE"><xsl:value-of select="/OMA/SpanEditMode"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_Minosdrivesize"><xsl:value-of select="/OMA/Minosdrivesize"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_Maxosdrivesize"><xsl:value-of select="/OMA/Maxosdrivesize"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_OMSAVID"><xsl:value-of select="/OMA/OMSAVID"/></xsl:variable>
	<xsl:variable name="PARAM_ClearForeignConfigEnable">
		<xsl:choose>
			<xsl:when test="/OMA/ClearForeignConfigEnable">
				<xsl:value-of select="/OMA/ClearForeignConfigEnable"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_IsAnyAdiskForeign">
		<xsl:choose>
			<xsl:when test="/OMA/ForeignAdiskFound">
				<xsl:value-of select="/OMA/ForeignAdiskFound"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_DSARaidModeAndDiskCheck">
		<xsl:choose>
			<xsl:when test="/OMA/DSARaidModeAndDiskCheck">
				<xsl:value-of select="/OMA/DSARaidModeAndDiskCheck"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<!--Global variables derived from independent variables -->
	<xsl:variable name="GLOBAL_VAR_MinSpansForRAID10"><xsl:value-of select="floor($GLOBAL_VAR_MinDrivesForRAID10 div 2)"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxSpansForRAID10">
		<xsl:choose>
			<xsl:when test="$GLOBAL_VAR_MaxDrivesForRAID10 &lt; $GLOBAL_VAR_ArrayDiskCount and $GLOBAL_VAR_MaxDrivesForRAID10 &lt; $GLOBAL_VAR_ControllerSupportedMaxNumOfSpans*2"><xsl:value-of select="floor($GLOBAL_VAR_MaxDrivesForRAID10 div 2)"/></xsl:when>
			<xsl:when test="$GLOBAL_VAR_ArrayDiskCount &lt; $GLOBAL_VAR_MaxDrivesForRAID10 and $GLOBAL_VAR_ArrayDiskCount &lt; $GLOBAL_VAR_ControllerSupportedMaxNumOfSpans*2"><xsl:value-of select="floor($GLOBAL_VAR_ArrayDiskCount div 2)"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$GLOBAL_VAR_ControllerSupportedMaxNumOfSpans"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:variable name="GLOBAL_VAR_MinSpansForRAID50"><xsl:value-of select="floor($GLOBAL_VAR_MinDrivesForRAID50 div 3)"/></xsl:variable>

	<xsl:variable name="GLOBAL_VAR_MinSpansForRAID60"><xsl:value-of select="floor($GLOBAL_VAR_MinDrivesForRAID60 div 4)"/></xsl:variable>

	<xsl:variable name="GLOBAL_VAR_MaxSpansForRAID50">
		<xsl:choose>
			<xsl:when test="$GLOBAL_VAR_MaxDrivesForRAID50 &lt; $GLOBAL_VAR_ArrayDiskCount and $GLOBAL_VAR_MaxDrivesForRAID50 &lt; $GLOBAL_VAR_ControllerSupportedMaxNumOfSpans*3"><xsl:value-of select="floor($GLOBAL_VAR_MaxDrivesForRAID50 div 3)"/></xsl:when>
			<xsl:when test="$GLOBAL_VAR_ArrayDiskCount &lt; $GLOBAL_VAR_MaxDrivesForRAID50 and $GLOBAL_VAR_ArrayDiskCount &lt; $GLOBAL_VAR_ControllerSupportedMaxNumOfSpans*3"><xsl:value-of select="floor($GLOBAL_VAR_ArrayDiskCount div 3)"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$GLOBAL_VAR_ControllerSupportedMaxNumOfSpans"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="GLOBAL_VAR_MaxSpansForRAID60">
		<xsl:choose>
			<xsl:when test="$GLOBAL_VAR_MaxDrivesForRAID60 &lt; $GLOBAL_VAR_ArrayDiskCount and $GLOBAL_VAR_MaxDrivesForRAID60 &lt; $GLOBAL_VAR_ControllerSupportedMaxNumOfSpans*4"><xsl:value-of select="floor($GLOBAL_VAR_MaxDrivesForRAID60 div 4)"/></xsl:when>
			<xsl:when test="$GLOBAL_VAR_ArrayDiskCount &lt; $GLOBAL_VAR_MaxDrivesForRAID60 and $GLOBAL_VAR_ArrayDiskCount &lt; $GLOBAL_VAR_ControllerSupportedMaxNumOfSpans*4"><xsl:value-of select="floor($GLOBAL_VAR_ArrayDiskCount div 4)"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$GLOBAL_VAR_ControllerSupportedMaxNumOfSpans"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>	
	
	<xsl:variable name="GLOBAL_VAR_MinDrivesForRAID10Span">2</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxDrivesForRAID10Span">
		<xsl:choose>
			<xsl:when test="2*$GLOBAL_VAR_ControllerSupportedMaxNumOfDisksInSpan &lt; $GLOBAL_VAR_ArrayDiskCount">
         		<xsl:value-of select="$GLOBAL_VAR_ControllerSupportedMaxNumOfDisksInSpan"/>
			</xsl:when>
                 
			<xsl:otherwise><xsl:value-of select="floor($GLOBAL_VAR_ArrayDiskCount div 2)"/></xsl:otherwise>

		</xsl:choose>
	</xsl:variable>
	
	<xsl:variable name="GLOBAL_VAR_MinSpansForRAID1Concat"><xsl:value-of select="floor($GLOBAL_VAR_MinDrivesForRAID1Concat div 2)"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxSpansForRAID1Concat">
		<xsl:choose>
			<xsl:when test="$GLOBAL_VAR_MaxDrivesForRAID1Concat &lt; $GLOBAL_VAR_ArrayDiskCount and $GLOBAL_VAR_MaxDrivesForRAID1Concat &lt; $GLOBAL_VAR_ControllerSupportedMaxNumOfSpans*2"><xsl:value-of select="floor($GLOBAL_VAR_MaxDrivesForRAID1Concat div 2)"/></xsl:when>
			<xsl:when test="$GLOBAL_VAR_ArrayDiskCount &lt; $GLOBAL_VAR_MaxDrivesForRAID1Concat and $GLOBAL_VAR_ArrayDiskCount &lt; $GLOBAL_VAR_ControllerSupportedMaxNumOfSpans*2"><xsl:value-of select="floor($GLOBAL_VAR_ArrayDiskCount div 2)"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$GLOBAL_VAR_ControllerSupportedMaxNumOfSpans"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MinDrivesForRAID50Span">3</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxDrivesForRAID50Span">
		<xsl:choose>
			<xsl:when test="2*$GLOBAL_VAR_ControllerSupportedMaxNumOfDisksInSpan &lt; $GLOBAL_VAR_ArrayDiskCount">
				<xsl:value-of select="$GLOBAL_VAR_ControllerSupportedMaxNumOfDisksInSpan"/>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="floor($GLOBAL_VAR_ArrayDiskCount div 2)"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:variable name="GLOBAL_VAR_MinDrivesForRAID60Span">4</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxDrivesForRAID60Span">
		<xsl:choose>
			<xsl:when test="2*$GLOBAL_VAR_ControllerSupportedMaxNumOfDisksInSpan &lt; $GLOBAL_VAR_ArrayDiskCount">
				<xsl:value-of select="$GLOBAL_VAR_ControllerSupportedMaxNumOfDisksInSpan"/>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="floor($GLOBAL_VAR_ArrayDiskCount div 2)"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
		<!--Excluding Rules from DSA_PARAMS to fix BITS115436: Go back to previous page issue for intelligent mirroring-->
	<xsl:variable name="DSA_BACKPAGE_PARAMS">DisplayVDConfig=<xsl:value-of select="$PARAM_DSA_DisplayVDConfig"/>&amp;OutputFileName=<xsl:value-of select="$PARAM_DSA_OutputFileName"/>&amp;ClearForeignConfigEnable=<xsl:value-of select="$PARAM_ClearForeignConfigEnable"/>&amp;ForeignAdiskFound=<xsl:value-of select="$PARAM_IsAnyAdiskForeign"/>&amp;DSARaidModeAndDiskCheck=<xsl:value-of select="$PARAM_DSARaidModeAndDiskCheck"/></xsl:variable>
	<xsl:variable name="DSA_PARAMS">Rules=<xsl:value-of select="$PARAM_DSA_Rules"/>&amp;DisplayVDConfig=<xsl:value-of select="$PARAM_DSA_DisplayVDConfig"/>&amp;OutputFileName=<xsl:value-of select="$PARAM_DSA_OutputFileName"/>&amp;ClearForeignConfigEnable=<xsl:value-of select="$PARAM_ClearForeignConfigEnable"/>&amp;ForeignAdiskFound=<xsl:value-of select="$PARAM_IsAnyAdiskForeign"/>&amp;DSARaidModeAndDiskCheck=<xsl:value-of select="$PARAM_DSARaidModeAndDiskCheck"/></xsl:variable>
	<xsl:variable name="REGULAR_PARAMS">ControllerOID=<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$PARAM_REGULAR_ControllerName"/>&amp;FILE=<xsl:value-of select="$PARAM_REGULAR_FILE"/>&amp;Minosdrivesize=<xsl:value-of select="$PARAM_REGULAR_Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="$PARAM_REGULAR_Maxosdrivesize"/></xsl:variable>
	<xsl:variable name="CACHED_PARAMS">Layout=<xsl:value-of select="$PARAM_PREV_Layout"/>&amp;VDName=<xsl:value-of select="$PARAM_NEXT_VDName"/>&amp;Length=<xsl:value-of select="$PARAM_NEXT_Length"/>&amp;ReadPolicy=<xsl:value-of select="$PARAM_NEXT_ReadPolicy"/>&amp;WritePolicy=<xsl:value-of select="$PARAM_NEXT_WritePolicy"/>&amp;CachePolicy=<xsl:value-of select="$PARAM_NEXT_CachePolicy"/>&amp;StripeSize=<xsl:value-of select="$PARAM_NEXT_StripeSize"/>&amp;DiskCachePolicy=<xsl:value-of select="$PARAM_NEXT_DiskCachePolicy"/></xsl:variable>
	<xsl:variable name="STATE_PARAMS">UserSelectedAdiskArrayNumList=<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskArrayNumList"/>&amp;UserSelectedAdiskContiguousFreeSpaceList=<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskContiguousFreeSpaceList"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MinDrivesForSelectedLayout">
		<xsl:choose>
			<xsl:when test="$PARAM_PREV_Layout='1'"><xsl:value-of select="$GLOBAL_VAR_MinDrivesForConcat"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='2'"><xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID0"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='4'"><xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID1"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='64'"><xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID5"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='512'"><xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID10"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='2048'"><xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID50"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='4096'"><xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID1Concat"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='128'"><xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID6"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='262144'"><xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID60"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='524288'"><xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID1E"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxDrivesForSelectedLayout">
		<xsl:choose>
			<xsl:when test="$PARAM_PREV_Layout='1'"><xsl:value-of select="$GLOBAL_VAR_MaxDrivesForConcat"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='2'"><xsl:value-of select="$GLOBAL_VAR_MaxDrivesForRAID0"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='4'"><xsl:value-of select="$GLOBAL_VAR_MaxDrivesForRAID1"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='64'"><xsl:value-of select="$GLOBAL_VAR_MaxDrivesForRAID5"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='512'"><xsl:value-of select="$GLOBAL_VAR_MaxDrivesForRAID10"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='2048'"><xsl:value-of select="$GLOBAL_VAR_MaxDrivesForRAID50"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='4096'"><xsl:value-of select="$GLOBAL_VAR_MaxDrivesForRAID1Concat"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='128'"><xsl:value-of select="$GLOBAL_VAR_MaxDrivesForRAID6"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='262144'"><xsl:value-of select="$GLOBAL_VAR_MaxDrivesForRAID60"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='524288'"><xsl:value-of select="$GLOBAL_VAR_MaxDrivesForRAID1E"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
        <xsl:variable name="GLOBAL_VAR_SingleSpanArrayMinDisksCount">
		<xsl:choose>
			<xsl:when test="$PARAM_PREV_Layout='512'">22</xsl:when>
			
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
        <xsl:variable name="GLOBAL_VAR_SingleSpanArrayMaxDisksCount">
		<xsl:choose>
			<xsl:when test="$PARAM_PREV_Layout='512'">26</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MinSpansForSelectedLayout">
		<xsl:choose>
			<xsl:when test="$PARAM_PREV_Layout='512'"><xsl:value-of select="$GLOBAL_VAR_MinSpansForRAID10"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='2048'"><xsl:value-of select="$GLOBAL_VAR_MinSpansForRAID50"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='4096'"><xsl:value-of select="$GLOBAL_VAR_MinSpansForRAID1Concat"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='262144'"><xsl:value-of select="$GLOBAL_VAR_MinSpansForRAID60"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxSpansForSelectedLayout">
		<xsl:choose>
			<xsl:when test="$PARAM_PREV_Layout='512'"><xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID10"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='2048'"><xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID50"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='4096'"><xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID1Concat"/></xsl:when>
			<xsl:when test="$PARAM_PREV_Layout='262144'"><xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID60"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
    <!-- Deletion required -->
    <xsl:variable name="GLOBAL_VAR_FreeDiskCount"><xsl:value-of select="count(//ArrayDisks/DCStorageObject[(ObjStatus = '2' or ObjStatus = '3') and (ObjState = '1' or ObjState = '4' or ObjState = '8388608') and UsedSpace='0'])"/></xsl:variable>
    <xsl:variable name="ATAandSATAPower">
		<xsl:call-template name="BitOr">
			<xsl:with-param name="num1" select="$tempATAPower"/>
			<xsl:with-param name="num2" select="$tempSATAPower"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="tempATAPower">
		<xsl:call-template name="Power">
			<xsl:with-param name="num1" select="2"/>
			<xsl:with-param name="num2" select="$GLOBAL_VAR_ATA"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="tempSATAPower">
		<xsl:call-template name="Power">
			<xsl:with-param name="num1" select="2"/>
			<xsl:with-param name="num2" select="$GLOBAL_VAR_SATA"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="tempSASPower">
		<xsl:call-template name="Power">
			<xsl:with-param name="num1" select="2"/>
			<xsl:with-param name="num2" select="$GLOBAL_VAR_SAS"/>
		</xsl:call-template>
	</xsl:variable>
	<!-- 11/1/05: RS - DF33593 to display all the adisks on LSI SCSI controllers -->
	<xsl:variable name="tempSCSIPower">
		<xsl:call-template name="Power">
			<xsl:with-param name="num1" select="2"/>
			<xsl:with-param name="num2" select="$GLOBAL_VAR_SCSI"/>
		</xsl:call-template>
	</xsl:variable>
        <!-- deletion required -->
	<!-- deletion required -->
        <xsl:variable name="GLOBAL_VAR_SCSIEnclosureID">0</xsl:variable>
        <xsl:variable name="GLOBAL_VAR_SCSI">1</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_ATA">2</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_SATA">7</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_SAS">8</xsl:variable>
        <xsl:variable name="CntrlAttributesMask" select="/OMA/Controllers/DCStorageObject/AttributesMask"/>
        <xsl:variable name="RaidLevelMask" select="/OMA/Controllers/DCStorageObject/RAIDLevelsMask"/>

	<xsl:variable name="GLOBAL_PARAM_Screen_Name">
		<xsl:choose>
			<xsl:when test="/OMA/Table='Selection'">cvdadisk_selection_<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/>_<xsl:value-of select="$PARAM_PREV_Layout"/></xsl:when>
			<xsl:when test="/OMA/Table='Result'">cvdadisk_result_<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/>_<xsl:value-of select="$PARAM_PREV_Layout"/></xsl:when>
			<xsl:otherwise>cvdadisk_main_<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/>_<xsl:value-of select="$PARAM_PREV_Layout"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Exit_Wizard_URL">
		<xsl:choose>
                        <xsl:when test="$GLOBAL_VAR_CreateSSC='1'"><xsl:value-of select="translate(/OMA/BackTo,'!','&amp;')"/></xsl:when>
			<xsl:when test="$PARAM_DSA_Rules='1'">./DSASwitch?exitRAID=1&amp;IsFromAdvanced=1</xsl:when>
			<xsl:otherwise><xsl:value-of select="translate($PARAM_REGULAR_OrigURL,'!','&amp;')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
      
      <xsl:variable name="PARAM_CURR_ENCLOSURESELECTEDLIST"><xsl:value-of select="/OMA/EnclosureSelectedList"/></xsl:variable>
      <xsl:variable name="PARAM_CURR_ENCLOSUREDISABLEDLIST"><xsl:value-of select="/OMA/EnclosureDisabledList"/></xsl:variable>
	  <xsl:variable name="GLOBAL_PARAM_MINSINGLESPANLENGTH">
           <xsl:if test="/OMA/ExpressResults//DCStorageObject/SpanLength='22'">22</xsl:if>
      </xsl:variable>
	  <xsl:variable name="GLOBAL_PARAM_MAXSINGLESPANLENGTH">
           <xsl:if test="/OMA/ExpressResults//DCStorageObject/SpanLength='26'">26</xsl:if>
	  </xsl:variable>
	  <xsl:variable name="GLOBAL_PARAM_MINNORMALSPANLENGTH">
           <xsl:for-each select="/OMA/ExpressResults/DCStorageObject">
              <xsl:choose>
              <xsl:when test="SpanLength &gt;= '2' and SpanLength &lt;= '16'">			  
	               <xsl:value-of select="SpanLength"/>
			  </xsl:when>
              </xsl:choose>			  
	       </xsl:for-each>
	  </xsl:variable>
	<xsl:template match="/">
		<!-- This page is rendered under three scenarios-->
		<!-- Page Load Scenario One: Page is loaded for first time.-->
		<!-- Page Load Scenario Two: Page is loaded because user clicked "back button" on wizard.-->
		<!-- Page Load Scenario Three: Page is loaded when user does some selection on current page, goes back to a previous pages on wizard and then returns to current page-->
		<!-- Page error scenarios-->
		<!-- Error scenario One: 
			Detection: When getcaps command returns value for SMStatus as "-1".
			Cause: Free array disks unavailable to create any raid layout. /User selected raid layout on previous page is no longer valid.
			User Scenario when this occurs: Can happen during all the three "Page Load Scenarios". Another user either thru CLI or browser could have used up all or some
			array disk space by the time current page is loaded -->
		<!-- Error scenario Two: 
			Detection: (ConditionOne) When user selected array disks do not belong the same disk group (determined by ArrayNum property).
						(ConditionTwo) When one or some or all of user selected array disks have zero Contiguous free space.
						Above applies for case When "/OMA/Rules" not equal to "1", in other words no need to detect error scenarios for DSA
			Cause: Configuration change
			User scenario when this occurs: Can happen when free space on some user selected array disks have been used up either thru CLI or from another browser. 
			Can occur during page load scenarion two and three-->
		<!-- When user comes to this page using "back button" on wizard, the variable below determines whether adisks selected by user is still valid-->
		<xsl:choose>
			<xsl:when test="$PARAM_DSA_Rules != '1' and ( not(//ExpressResults) or  not(//ArrayDisks) or //ExpressResults/SMStatus='-1')">
				<!-- The template below is called when no array disks are free to create a virtual disk or get caps call fails.-->
				<xsl:call-template name="RenderErrorPage"/>
			</xsl:when>
			<xsl:when test="/OMA/Table='Selection'">
				<!--the template below is applied the when the webplugin containing this XSL is loaded for the second time /-->
				<!--the template below renders the selection data in the selection table/-->
				<xsl:call-template name="SelectionData"/>
			</xsl:when>
			<xsl:when test="/OMA/Table='Result'">
				<!--the template below is applied the when the webplugin containing this XSL is loaded for the second time /-->
				<!--the template below renders the selection data in the selection table/-->
				<xsl:call-template name="ResultData"/>
			</xsl:when>
			<!--the template below is applied the when the webplugin containing this XSL is loaded for the first time /-->
			<xsl:otherwise>
				<xsl:call-template name="RenderMainFrame"/>
			</xsl:otherwise>
		</xsl:choose>
               
	</xsl:template>
        
        
        
	
	
	<xsl:template name="RenderErrorPage">
		<DataArea exportdata="false" email="false" printable="false">
			<xsl:call-template name="scripts"/>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitleCfgChngDetectCVDAAS"/></xsl:attribute>
			</PageTitle>
			<AlertMessage>
			   <xsl:attribute name="display"><xsl:value-of select="$strTitleFreeDisksUnavailableCVDAAS"/></xsl:attribute>
			</AlertMessage>
			<AlertMessage>
			<xsl:attribute name="display"><xsl:value-of select="$strRaidSelectionInvalidCVDAAS"/></xsl:attribute>
			</AlertMessage>
			<BottomCustomButton>
				<Data formSubmit="true">
					<xsl:attribute name="display"><xsl:value-of select="$strCancelCVDAAS"/></xsl:attribute>
					<xsl:attribute name="href"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:attribute>
				</Data>
			</BottomCustomButton>
		</DataArea>
	</xsl:template>
	
	<xsl:template name="RenderMainFrame">
           
            
		<DataArea validate="true" onLoad="true" exportdata="false" printable="false" email="false" ignoreJumpBar="true">
			<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
			<!-- Ashesh: These attributes are for DSA mode only -->
			<xsl:if test="$PARAM_DSA_Rules ='1'">
				<xsl:attribute name="storeonback">true</xsl:attribute>			<!-- Ashesh: This variables lets the DSA-OMSA framework know that page needs to be cached  -->
				<!-- Ashesh: DF89053: Dump RAID cache when user changes a controller -->
				<!-- Added Controller OID to preserve caching in multiple controller scenario -->
				<xsl:attribute name="screenname"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:attribute>	<!-- Ashesh: This is the key for the hashmap which stores the form elements of the page. -->
				<!-- DF116330 : Restore state after DSA cache restoring for the main frame is done -->
				<xsl:attribute name="execfunctiononrestore">frames["RESULT_TABLE"].restoreDSACache</xsl:attribute>
				<!-- Ashesh: This is the label for the back button  -->
				<xsl:attribute name="custombackpagedisplay"><xsl:value-of select="$strBackButtonDisplayCVDAAS"/></xsl:attribute> 
				<!-- Ashesh: This is the href for the back button. This will cache the form elements of this page and take the user to the URL specified  -->
				<xsl:attribute name="backpagetarget">javascript:backPage()</xsl:attribute> 
			</xsl:if>
			<HiddenTable>
				<Data>
					<xsl:attribute name="name">IDList</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable>
                        <HiddenTable>
				<Data>
					<xsl:attribute name="name">IMIDList</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable>
                          <HiddenTable>
				<Data>
					<xsl:attribute name="name">SingleSpanVD</xsl:attribute>
					<xsl:attribute name="returnvalue"/>
				</Data>
			</HiddenTable> 
                       <HiddenTable>
				<Data>
					<xsl:attribute name="name">SecureVD</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/SecureVD"/></xsl:attribute>
				</Data>
			</HiddenTable>
                   
                        <HiddenTable>
				<Data>
					<xsl:attribute name="name">AdvancedWizard</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/AdvancedWizard"/></xsl:attribute>
				</Data>
			</HiddenTable>
                  
                  <HiddenTable>
				<Data>
					<xsl:attribute name="name">ExpressWizard</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/ExpressWizard"/></xsl:attribute>
				</Data>
			</HiddenTable>
                  
                  <HiddenTable>
				<Data>
					<xsl:attribute name="name">MediaType</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/MediaType"/></xsl:attribute>
				</Data>
			</HiddenTable>
                  
                     <HiddenTable>
				<Data>
					<xsl:attribute name="name">BusProtocol</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/BusProtocol"/></xsl:attribute>
				</Data>
			</HiddenTable>
                  
                   
                        <xsl:if test="$GLOBAL_VAR_CreateSSC!='1'"><PromptText><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType" select="$PARAM_PREV_Layout"/></xsl:call-template><xsl:value-of select="$strColonSpace"/><xsl:value-of select="$strPromptForArrayDiskSelectionCVDAAS"/><xsl:value-of select="$strMinDisksToBeSelected"/><xsl:value-of select="$GLOBAL_VAR_MinDrivesForSelectedLayout"/><xsl:value-of select="$strPeriodSpace"/><xsl:value-of select="$strMaxDisksToBeSelected"/><xsl:value-of select="$GLOBAL_VAR_MaxDrivesForSelectedLayout"/><xsl:value-of select="$strPeriodSpace"/><xsl:if test="$PARAM_SPANEDITMODE = 'true'"><xsl:text> </xsl:text><xsl:value-of select="$strSpanEditText"/></xsl:if></PromptText></xsl:if>
                        <xsl:if test="$PARAM_CURR_IM ='true'"><PromptText><xsl:value-of select="$strFullIMDescritpion"/></PromptText></xsl:if>
<!--xsl:call-template name="RenderDiskTypeSelectionRadioButtons"/-->

			<script language="javascript">

				var IDLIST_VALUE_ON_PAGE_LOAD;
				var SPAN_LENGTH_VALUE_ON_PAGE_LOAD;
                        var SINGLE_SPAN_VD_ON_PAGE_LOAD; 
				var DISK_PROTOCOL_VALUE_ON_PAGE_LOAD;
				var PREV_SPAN_LENGTH_VALUE=0;
				
				var INTMIRROR_ON_PAGE_LOAD=false;
				var SELECTALL_ON_PAGE_LOAD=false;
				var ENCLOSURESELECTEDLIST_ON_PAGE_LOAD;
                        var ENCLOSUREDISABLEDLIST_ON_PAGE_LOAD;
				var JS_GLOBAL_MaxNumTargets=24;
				var JS_GLOBAL_MaxNumEnclosures = parseInt("<xsl:value-of select="$GLOBAL_VAR_MAX_Enclosures"/>");
				var JS_GLOBAL_MaxNumChannels=2;
				var SPANEDITMODE = '<xsl:value-of select="$PARAM_SPANEDITMODE"/>';				
				var VDArrayNums = "<xsl:value-of select="$GLOBAL_VAR_ArrayNumDisks"/>";		

				function initializationRoutine()
				{           
                                
						<!-- DSA uses different function to append VID -->
                                                <xsl:if test="$GLOBAL_VAR_CreateSSC='1'">
                                                document.getElementById("VDSize").disabled=true;
                                                </xsl:if>
                                                
						var RulesValue='<xsl:value-of select="$PARAM_DSA_Rules"/>';
						if (RulesValue == "1")
						{
							top.gnv.appendVID = top.getFrame("OMA_gnv").appendDataAreaVID;
						}
						
						<!-- First save user selected values on page load.(Scenario: User selects disks on current bage, goes to previous page and comes back to current page)-->
						IDLIST_VALUE_ON_PAGE_LOAD = '<xsl:value-of select="$PARAM_CURR_IDList"/>';
						SPAN_LENGTH_VALUE_ON_PAGE_LOAD='<xsl:value-of select="$PARAM_CURR_SpanLength"/>';
                                                SINGLE_SPAN_VD_ON_PAGE_LOAD='<xsl:value-of select="/OMA/SingleSpanVD"/>';
                                                
                                                
						layoutValue = '<xsl:value-of select="$PARAM_PREV_Layout"/>';
						INTMIRROR_ON_PAGE_LOAD = '<xsl:value-of select="$PARAM_CURR_IM"/>';
                                                SELECTALL_ON_PAGE_LOAD = '<xsl:value-of select="$PARAM_CURR_SELECTALL"/>';
                                                ENCLOSURESELECTEDLIST_ON_PAGE_LOAD = '<xsl:value-of select="$PARAM_CURR_ENCLOSURESELECTEDLIST"/>';
                                                ENCLOSUREDISABLEDLIST_ON_PAGE_LOAD = '<xsl:value-of select="$PARAM_CURR_ENCLOSUREDISABLEDLIST"/>';
                                                
                                                if (INTMIRROR_ON_PAGE_LOAD=='true' &amp;&amp; SPANEDITMODE != 'true')
						{
							
                                                        if(document.getElementById("Spans") != null )
                                                        { 
                                                           document.getElementById("Spans").disabled=true;
                                                        }
                                                        SPAN_LENGTH_VALUE_ON_PAGE_LOAD=parseInt('<xsl:value-of select="$GLOBAL_VAR_ArrayDiskCount"/>') + 1;
                                                        PREV_SPAN_LENGTH_VALUE=parseInt('<xsl:value-of select="$GLOBAL_VAR_ArrayDiskCount"/>') + 1;
                                                }
                                                if(document.getElementById("Spans") != null &amp;&amp; document.getElementById("SingleSpans")!=null )
                                                {
 					                  var RadioArray=document.getElementsByName("SpanInfo");
									 
				                        if (SINGLE_SPAN_VD_ON_PAGE_LOAD=='true')
				                        {
 						                 RadioArray[0].checked=false;
						                 RadioArray[1].checked=true;
						                 document.getElementById("Spans").disabled=true;
				            		         document.getElementById("SingleSpans").disabled=false;
						                 document.getElementById("SingleSpans").value=SPAN_LENGTH_VALUE_ON_PAGE_LOAD;
						                 PREV_SPAN_LENGTH_VALUE=SPAN_LENGTH_VALUE_ON_PAGE_LOAD;
						            }
				                        else
				                        {      
	                                                            if(SPAN_LENGTH_VALUE_ON_PAGE_LOAD == 'null')
						                    {
						                        SPAN_LENGTH_VALUE_ON_PAGE_LOAD=parseInt("<xsl:value-of select="$GLOBAL_VAR_MinSpansForSelectedLayout"/>");
						                    }
                                                                    document.getElementById("Spans").disabled=false;
                                                                    document.getElementById("Spans").value=SPAN_LENGTH_VALUE_ON_PAGE_LOAD;
                                                                    document.getElementById("SingleSpans").disabled=true;
                                                                    RadioArray[0].checked=true;
                                                                    RadioArray[1].checked=false;
                                                            }
                                                 } 
						else if (document.getElementById("Spans") != null &amp;&amp; (SPAN_LENGTH_VALUE_ON_PAGE_LOAD != '' &amp;&amp; SPAN_LENGTH_VALUE_ON_PAGE_LOAD != null &amp;&amp; SPAN_LENGTH_VALUE_ON_PAGE_LOAD != 'null'))
						{     
                                                            document.getElementById("Spans").disabled=false;
                                                            document.getElementById("Spans").value=SPAN_LENGTH_VALUE_ON_PAGE_LOAD;
                                                            PREV_SPAN_LENGTH_VALUE=SPAN_LENGTH_VALUE_ON_PAGE_LOAD;
                                                            frames["SELECTION_TABLE"].setSpanLengthValue(SPAN_LENGTH_VALUE_ON_PAGE_LOAD);
                                                            if (document.getElementById("SpanInfo") != null)
                                                            {
                                                                       var RadioArray=document.getElementsByName("SpanInfo");
                                                                       RadioArray[0].checked=true;
                                                            }
                                                                      							
						}
						else if (document.getElementById("SpanInfo") != null)
						{
                                                              var RadioArray=document.getElementsByName("SpanInfo");
                                                              RadioArray[0].checked=true;
						}

                                                if(SELECTALL_ON_PAGE_LOAD=='true')
                                                {

                                                             if (document.getElementById("SelectAll")!= null)
                                                             {
                                                                      document.getElementById("SelectAll").checked = true;
                                                             }
                                                }

                                                if (VDArrayNums != '' &amp;&amp; (IDLIST_VALUE_ON_PAGE_LOAD == 'null' || IDLIST_VALUE_ON_PAGE_LOAD == ''))
                                                {
                                                            OnSpanLengthChangeHandler(layoutValue);	

                                                }	

				            <!-- Restore page using url caching only if OMSS, Lite uses DSA caching -->
						<xsl:if test="$PARAM_DSA_Rules!='1'">
                                     
							UpdateWithUserSelectedInputs('<xsl:value-of select="$PARAM_CURR_IDList"/>');
                                   
						</xsl:if>
                                  
                                                if(INTMIRROR_ON_PAGE_LOAD=='true' &amp;&amp; SPANEDITMODE != 'true')
                                                { 

                                                                    if(DISK_PROTOCOL_VALUE_ON_PAGE_LOAD!='null')
                                                                    {
                                                                     frames["SELECTION_TABLE"].enableAllCheckBoxes();
                                                                    }

                                                }
				     		
                                    frames["SELECTION_TABLE"].EnableDisableEnclosures();
				}
				
				function UpdateWithUserSelectedInputs(IDList)
				{     
                                    
 					var SpanLength="";
 					var layoutValue = "";
					var UserSelectedAdiskArrayNumList ="";
					var UserSelectedAdiskContiguousFreeSpaceList="";
					<xsl:choose>
						<xsl:when test="$PARAM_DSA_Rules!='1'">
							SpanLength = '<xsl:value-of select="$PARAM_CURR_SpanLength"/>';
							
						</xsl:when>
						<xsl:otherwise>
							SpanLength = "" + getSpanLengthValue();
							

						</xsl:otherwise>
					</xsl:choose>
                              
					layoutValue = '<xsl:value-of select="$PARAM_PREV_Layout"/>';
					UserSelectedAdiskArrayNumList = '<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskArrayNumList "/>';
					UserSelectedAdiskContiguousFreeSpaceList = '<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskContiguousFreeSpaceList"/>';
					
					<!-- DF32325 - Fix to clear result table for R10 w/ multiple protocol -->
					<!-- DiskProtocol values in different scenarios:
					When the Adisk selection page is first loaded(SCSI/SAS/SATA) - NULL
					With SCSI disks, when the Adisk selection pg is reloaded frm RAID selection pg - 0
					With SCSI disks, when the Adisk selection pg is reloaded frm SIZE selection pg - 0
					With SAS or SATA or both, When the Adisk selection page is reloaded from 
					RAID selection pg - BusProtocol(7-SATA,8-SAS) 
					With SAS or SATA or both, When the Adisk selection pg is reloaded from 
					SIZE selection pg - BusProtocol(7-SATA,8-SAS) -->
					
                              
                               
					if( IDList != "" &amp;&amp; SpanLength != "" &amp;&amp; IDList != "null" &amp;&amp; SpanLength != "null" )
					{
						var ObjIDArray = IDList.split(":");
						
						<!-- OMSS Lite does not care about free space or config changes -->
						<xsl:if test="$PARAM_DSA_Rules!='1'">
                                          <!-- First detect for any configuration changes that invalidates user selected array disks-->
							if( getUserSelectedAdiskArrayNumList(IDList) != UserSelectedAdiskArrayNumList &amp;&amp; SPANEDITMODE != 'true') 
							{       							
								var strCfgDetect = "<xsl:value-of select="$strCfgChngDetectCVDAAS"/>";
								var strAdiskInvalid = "<xsl:value-of select="$strAdiskSelectionInvalidCVDAAS"/>";
								var strReselectAdisk = "<xsl:value-of select="$strReselectAdisksCVDAAS"/>";
								var alertStrMsg = strCfgDetect+"\n"+strAdiskInvalid +"\n"+strReselectAdisk ;
								IDLIST_VALUE_ON_PAGE_LOAD = "null";
								SPAN_LENGTH_VALUE_ON_PAGE_LOAD="null";
								DISK_PROTOCOL_VALUE_ON_PAGE_LOAD="null";
								INTMIRROR_ON_PAGE_LOAD = false;
								SELECTALL_ON_PAGE_LOAD = false;
								ENCLOSURESELECTEDLIST_ON_PAGE_LOAD="null";
                                                                ENCLOSUREDISABLEDLIST_ON_PAGE_LOAD="null";  
								return;
							}
							<!-- Also make sure the user selected array disks  have non-zero contiguous free space.
							(All adaptec disks are considered free disks, hence the check). First check to see if cached "UserSelectedAdiskContiguousFreeSpaceList" and
							"Contiguous Free Space" for user selected disks after page load match; If there is a mismatch handle it.-->
                                                        
							if(getUserSelectedAdiskContiguousFreeSpaceList(IDList) != UserSelectedAdiskContiguousFreeSpaceList &amp;&amp; SPANEDITMODE != 'true')
							{
										var strCfgDetect = "<xsl:value-of select="$strCfgChngDetectCVDAAS"/>";
										var strAdiskInvalid = "<xsl:value-of select="$strAdiskSelectionInvalidCVDAAS"/>";
										var strReselectAdisk = "<xsl:value-of select="$strReselectAdisksCVDAAS"/>";
										var alertStrMsg = strCfgDetect+"\n"+strAdiskInvalid +"\n"+strReselectAdisk ;
										IDLIST_VALUE_ON_PAGE_LOAD = "null";
										SPAN_LENGTH_VALUE_ON_PAGE_LOAD="null";
										DISK_PROTOCOL_VALUE_ON_PAGE_LOAD="null";
										INTMIRROR_ON_PAGE_LOAD = false;
										SELECTALL_ON_PAGE_LOAD = false;
										ENCLOSURESELECTEDLIST_ON_PAGE_LOAD="null";
                                                                                ENCLOSUREDISABLEDLIST_ON_PAGE_LOAD="null";  
										return;
								
							}
						</xsl:if>
											
						if((layoutValue == 512) || (layoutValue == 2048) || (layoutValue == 262144) )
						{
								PREV_SPAN_LENGTH_VALUE = SpanLength;
								frames["SELECTION_TABLE"].setSpanLengthValue(SpanLength);
                                                }
						<!--Turn OFF the warning message that is displayed when disks of different size disks in a span are selected until the selection 
						and result table are populated with previously selected adisk values.-->
						frames["SELECTION_TABLE"].setWarnFlagForDifferentSizeDisksInSpan(0);
						UpdateUserSelectedArrayDisks(ObjIDArray);
						<!-- Now that selection/result tables are populated with previously selected adisk values, Turn ON the warning message for any further 
						span selection that the user may make.-->
                                                
						frames["SELECTION_TABLE"].setWarnFlagForDifferentSizeDisksInSpan(1);
					}					
					
				}
				function UpdateUserSelectedArrayDisks(ObjIDArray)
				{       
					var len = ObjIDArray.length;
					for(var i=0;i &lt; len; i++)
					{
						var str="";
						str = frames["SELECTION_TABLE"].getChTgtIdStringGivenObjIDForArrayDisk(ObjIDArray[i]);
						//Enter only when autoDeleteAllSpan is false for sliced span case
						if(str != null &amp;&amp; !frames["SELECTION_TABLE"].autoDeleteAllSpan)
						{
							var chTgtArray = str.split(":");
							frames["SELECTION_TABLE"].selectArrayDiskCheckBox(chTgtArray[0], chTgtArray[1], chTgtArray[2]);
							frames["SELECTION_TABLE"].OnArrayDiskSelected(chTgtArray[0], chTgtArray[1], chTgtArray[2]);
						}
					}
                                      
                              if(document.getElementById("SelectAll")!=null )
                              {         
                                          if(SELECTALL_ON_PAGE_LOAD=='true')
                                          {    
                                                             document.getElementById("SelectAll").checked=true; 
                                                             document.getElementById("SelectAll").disabled=false;
                                           }
                                           else
                                           {
                                                             document.getElementById("SelectAll").checked=false;
                                           }       
                              }
                                   
				 }
                                 
                                 
                                 // Checks to make sure that text only contains alphanumeric and space, dash and underscores.
		   // Also name cannot begin or end with a space.
		   function isVDNameValid(text)
			 {
				var validchars = /^[a-zA-Z0-9_ -]*$/;
				if( validchars.test(text))
				{

					// cannot start or end with a space.
					if(/^ /.test(text) || / $/.test(text))
					{
					   alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strStartSpace"/>");
					   return false
					}

					return true;
				}
				alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strInvalidString"/>");
				return false;
			}

				
                        function submitCreateVDAdvancedAdiskSelected()
				{
					<!--call validate before loading the next page-->
                                        <xsl:if test="$GLOBAL_VAR_CreateSSC='1'">
                                             var VDName = document.getElementById("VDName").value;
                                             if( isVDNameValid(VDName) == false )
                                             {
                                                return;
                                             }
                                             var Length = document.getElementById("VDSize").value;
                                        </xsl:if>
					if(validate() == false)
						return;

					<xsl:if test="substring($CntrlAttributesMask,13,1)='1'">
						if (confirm ("<xsl:value-of select="$strDataWarningLevel2"/>") == false)
							return;
					</xsl:if>
                                        
					var layoutValue='<xsl:value-of select="$PARAM_PREV_Layout"/>';
					var IDList="";
					var SpanLength=frames["SELECTION_TABLE"].getSpanLength();
                              
					var intMirror = getIMValue();
                                        if(intMirror==true)
                                        {
                                            SpanLength = parseInt('<xsl:value-of select="$GLOBAL_VAR_ArrayDiskCount"/>') + 1;
                                        }

					var selectAll = getSelectAllValue();

                                        
                              
                                         
                              


                                       
					var nextWebplugin = "com.dell.sm.webplugins.CreateVDAdvancedSummaryWebPlugin";
                                        var IMSupport=<xsl:value-of select="substring($CntrlAttributesMask,11,1)='1'"/>;
                                          if(layoutValue == 512 &amp;&amp; IMSupport)
                                           {
                                              var EnclosureSelectedList=frames["SELECTION_TABLE"].GetSelectedOrDisabledEnclosures(1);
                                              var EnclosureDisabledList=frames["SELECTION_TABLE"].GetSelectedOrDisabledEnclosures(0);

                                           }
                                            if(layoutValue == 512 || layoutValue==2048 || layoutValue==4096 || layoutValue == 262144 )
                                            {
                                                    IDList=frames["SELECTION_TABLE"].getSelectedArrayDisksObjIDsForSpans();
                                            }
                                            else
                                            {
                                                    IDList = frames["SELECTION_TABLE"].getSelectedArrayDisksObjIDs();
                                            }
					
                                         var PDselPowerState = frames["SELECTION_TABLE"].getSelectedPDInfo(IDList);
					if(frames["SELECTION_TABLE"].getPowerStateCount(IDList))
					{
					  alert("<xsl:value-of select="$strDataWarningLevel3"/>" + "\n" + PDselPowerState);
					}

                                          var PDselDiffLayoutStr = frames["SELECTION_TABLE"].getMultiRaidLevelOnDiskGroupWarn(IDList, layoutValue);
					if(PDselDiffLayoutStr != '')
					{
					    if(confirm("<xsl:value-of select="$strDataWarningLevel5"/>" + "\n" + PDselDiffLayoutStr) == false)
					    {
                                                 return; 
                                            }	   	
					}

					if(SPANEDITMODE == 'true')
					{    
						nextWebplugin = "com.dell.sm.webplugins.CreateVDAdvancedSummaryWebPlugin&amp;SpanEditMode=true&amp;<xsl:value-of select="$CACHED_PARAMS"/>&amp;EnclosureDisabledList=<xsl:value-of select="$PARAM_CURR_ENCLOSUREDISABLEDLIST"/>&amp;EnclosureSelectedList=<xsl:value-of select="$PARAM_CURR_ENCLOSURESELECTEDLIST"/>&amp;DiskCachePolicy=<xsl:value-of select="/OMA/DiskCachePolicy"/>&amp;sectorSize=<xsl:value-of select="/OMA/SectorSize"/>&amp;SelectAllVal=<xsl:value-of select="/OMA/SelectAll"/>&amp;IntMirror=<xsl:value-of select="/OMA/IntMirror"/>";
					}
                                        if(document.getElementById("SingleSpans")!=null &amp;&amp; document.getElementById("SingleSpans").disabled==false)
                                        {
                                              document.getElementById("SingleSpanVD").value = "true";
                                        }
					<!--The following code is checking for three things. i)page loaded for first time ii) page loaded by using back button on wizard and user selection
					remains unchanged iii)page loaded using back button and user has changed selection, in which case CACHED_PARAMS should not be used for
					loading next page-->

					<xsl:if test="$PARAM_DSA_Rules='1'">
						<!-- Flush and reload the DSA javascript page cache on submit. We need to do this for the iframes as well. -->
						cachePageInDSA();
						frames["RESULT_TABLE"].cachePageInDSA();
					</xsl:if>
                                        document.getElementById("SecureVD").value = '<xsl:value-of select="$CreateSecureVD"/>';
                      <!-- new condition added to fix issue BITS139703 OMSS: Wrong messages displayed while creating RAID-10  -->                 
					if((layoutValue == 512) || (IDLIST_VALUE_ON_PAGE_LOAD == "null" &amp;&amp; SPAN_LENGTH_VALUE_ON_PAGE_LOAD=="null" ) ||(IDLIST_VALUE_ON_PAGE_LOAD == IDList &amp;&amp; SPAN_LENGTH_VALUE_ON_PAGE_LOAD==SpanLength) )
					{
                                        
                                                 if(document.getElementById("IMIDList")!=null &amp;&amp; SPANEDITMODE != 'true')
                                                 {
                                                           document.getElementById("IMIDList").value = IDList;  
                                                           var UserSelectedAdiskArrayNumList= getUserSelectedAdiskArrayNumList(IDList);
                                                           var UserSelectedAdiskContiguousFreeSpaceList= getUserSelectedAdiskContiguousFreeSpaceList(IDList);
                                                 }
                                                 else
                                                 {
                                                            var UserSelectedAdiskArrayNumList= getUserSelectedAdiskArrayNumList('<xsl:value-of select="/OMA/IMIDList"/>');
                                                            var UserSelectedAdiskContiguousFreeSpaceList= getUserSelectedAdiskContiguousFreeSpaceList('<xsl:value-of select="/OMA/IMIDList"/>');
                                                            document.getElementById("IMIDList").value = '<xsl:value-of select="/OMA/IMIDList"/>';
                                                 }
                                                 
						var StateParams = "UserSelectedAdiskArrayNumList="+UserSelectedAdiskArrayNumList+"&amp;UserSelectedAdiskContiguousFreeSpaceList="+UserSelectedAdiskContiguousFreeSpaceList;
                                      
                                     <!--     document.location.href = top.gnv.appendVID("./DataArea?plugin="+nextWebplugin+"&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;<xsl:value-of select="$CACHED_PARAMS"/>"+"&amp;IDList="+IDList+"&amp;SpanLength="+SpanLength+"&amp;IntMirror="+intMirror+"&amp;EnclosureSelectedList="+EnclosureSelectedList+"&amp;EnclosureDisabledList="+EnclosureDisabledList+"&amp;SelectAll="+selectAll+"&amp;"+StateParams+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;cvdaselection=true");
                                  -->        
                                           document.getElementById("IDList").value = IDList;
                                           
                                           <xsl:choose>
                                           <xsl:when test="$GLOBAL_VAR_CreateSSC='1'">
                                               document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.SubmitCreateVDAdvancedSummaryWebPlugin&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;Layout=2&amp;VDName="+VDName+"&amp;Length="+Length+"&amp;Force=1&amp;ManageSSC=<xsl:value-of select="$GLOBAL_VAR_CreateSSC"/>"+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;ControllerOID=<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$PARAM_REGULAR_ControllerName"/>");
				           document.dataarea.submit();
                                           </xsl:when>
                                           <xsl:otherwise>
                                           document.dataarea.action = top.gnv.appendVID("./DataArea?plugin="+nextWebplugin+"&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;sectorSize=<xsl:value-of select="/OMA/SectorSize"/>&amp;<xsl:value-of select="$CACHED_PARAMS"/>"+"&amp;SpanLength="+SpanLength+"&amp;SelectAllVal="+selectAll+"&amp;IntMirror="+intMirror+"&amp;EnclosureSelectedList="+EnclosureSelectedList+"&amp;EnclosureDisabledList="+EnclosureDisabledList+"&amp;"+StateParams+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>"+"&amp;PercVersion=<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>"+"&amp;ManageSSC=<xsl:value-of select="$GLOBAL_VAR_CreateSSC"/>"+"&amp;VdPIEnabled=<xsl:value-of select="$VdPIEnabled"/>");
				           document.dataarea.submit();
                                           </xsl:otherwise>
                                           </xsl:choose>
                                  
				
					}
					else
					{ 
						
						if(document.getElementById("IMIDList")!=null &amp;&amp; SPANEDITMODE != 'true')
                                                {
                                                        document.getElementById("IMIDList").value = IDList;  
                                                        var UserSelectedAdiskArrayNumList= getUserSelectedAdiskArrayNumList(IDList);
                                                        var UserSelectedAdiskContiguousFreeSpaceList= getUserSelectedAdiskContiguousFreeSpaceList(IDList);
                                                 }
                                                 else
                                                 {
                                                         document.getElementById("IMIDList").value = '<xsl:value-of select="/OMA/IMIDList"/>';
                                                         var UserSelectedAdiskArrayNumList= getUserSelectedAdiskArrayNumList('<xsl:value-of select="/OMA/IMIDList"/>');
                                                         var UserSelectedAdiskContiguousFreeSpaceList= getUserSelectedAdiskContiguousFreeSpaceList('<xsl:value-of select="/OMA/IMIDList"/>');
                                                  }
                                                   
						
						
						var StateParams = "UserSelectedAdiskArrayNumList="+UserSelectedAdiskArrayNumList+"&amp;UserSelectedAdiskContiguousFreeSpaceList="+UserSelectedAdiskContiguousFreeSpaceList;
                     
                                         <!--        
                                          document.location.href = top.gnv.appendVID("./DataArea?plugin="+nextWebplugin+"&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;Layout=<xsl:value-of select="$PARAM_PREV_Layout"/>"+"&amp;IDList="+IDList+"&amp;SpanLength="+SpanLength+"&amp;IntMirror="+intMirror+"&amp;EnclosureSelectedList="+EnclosureSelectedList+"&amp;EnclosureDisabledList="+EnclosureDisabledList+"&amp;SelectAll="+selectAll+"&amp;"+StateParams+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;cvdaselection=true");
                                                 
					   -->      document.getElementById("IDList").value = IDList;
                                             
                                             <xsl:choose>
                                           <xsl:when test="$GLOBAL_VAR_CreateSSC='1'">
                                                document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.SubmitCreateVDAdvancedSummaryWebPlugin&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;Layout=2&amp;VDName="+VDName+"&amp;Length="+Length+"&amp;Force=1&amp;ManageSSC=<xsl:value-of select="$GLOBAL_VAR_CreateSSC"/>"+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;ControllerOID=<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$PARAM_REGULAR_ControllerName"/>");
                                                document.dataarea.submit();
                                           </xsl:when>
                                           <xsl:otherwise>
											
											document.dataarea.action = top.gnv.appendVID("./DataArea?plugin="+nextWebplugin+"&amp;<xsl:value-of select="$CACHED_PARAMS"/>&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;Layout=<xsl:value-of select="$PARAM_PREV_Layout"/>&amp;sectorSize=<xsl:value-of select="$PARAM_PREV_SectorSize"/>"+"&amp;SpanLength="+SpanLength+"&amp;SelectAllVal="+selectAll+"&amp;IntMirror="+intMirror+"&amp;EnclosureSelectedList="+EnclosureSelectedList+"&amp;EnclosureDisabledList="+EnclosureDisabledList+"&amp;"+StateParams+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>"+"&amp;ManageSSC=<xsl:value-of select="$GLOBAL_VAR_CreateSSC"/>&amp;VdPIEnabled=<xsl:value-of select="$VdPIEnabled"/>");
                           		      document.dataarea.submit();
                                           </xsl:otherwise>
                                           </xsl:choose>
		                            
                                        
                                        }
				}
				function validate()
				{       

					return IsAnyArrayDiskSelected();
				}
				function IsAnyArrayDiskSelected()
				{
					var RulesValue='<xsl:value-of select="$PARAM_DSA_Rules"/>';
					var DSARaidModeAndDiskCheck='<xsl:value-of select="$PARAM_DSARaidModeAndDiskCheck"/>';
					var layoutValue='<xsl:value-of select="$PARAM_PREV_Layout"/>';
					var count =frames["SELECTION_TABLE"].GetSelectedArrayDisksCount();
					var minDrivesForConcat = "<xsl:value-of select="$GLOBAL_VAR_MinDrivesForConcat"/>";
					var maxDrivesForConcat = "<xsl:value-of select="$GLOBAL_VAR_MaxDrivesForConcat"/>";
					var minDrivesForRAID0 = "<xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID0"/>";
					var maxDrivesForRAID0 = "<xsl:value-of select="$GLOBAL_VAR_MaxDrivesForRAID0"/>";
					var minDrivesForRAID1 = "<xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID1"/>";
					var maxDrivesForRAID1= "<xsl:value-of select="$GLOBAL_VAR_MaxDrivesForRAID1"/>";
					var minDrivesForRAID5 = "<xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID5"/>";
					var maxDrivesForRAID5 = "<xsl:value-of select="$GLOBAL_VAR_MaxDrivesForRAID5"/>";
					var minDrivesForRAID6 = "<xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID6"/>";
					var maxDrivesForRAID6 = "<xsl:value-of select="$GLOBAL_VAR_MaxDrivesForRAID6"/>";
					var minDrivesForRAID1Concat = "<xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID1Concat"/>";
					var maxDrivesForRAID1Concat = "<xsl:value-of select="$GLOBAL_VAR_MaxDrivesForRAID1Concat"/>";
					var minSpansForRAID10="<xsl:value-of select="$GLOBAL_VAR_MinSpansForRAID10"/>";
					var maxSpansForRAID10="<xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID10"/>";
					var minSpansForRAID50="<xsl:value-of select="$GLOBAL_VAR_MinSpansForRAID50"/>";
					var maxSpansForRAID50="<xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID50"/>";
					var minSpansForRAID60="<xsl:value-of select="$GLOBAL_VAR_MinSpansForRAID60"/>";
					var maxSpansForRAID60="<xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID60"/>";
					var minSpansForRAID1Concat="<xsl:value-of select="$GLOBAL_VAR_MinSpansForRAID1Concat"/>";
					var maxSpansForRAID1Concat="<xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID1Concat"/>";
					var minDrivesForRAID1E = "<xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID1E"/>";
                                        var SizeofSSCVD =0;
                                        if(document.getElementById("VDSize")!=null)
                                        {
                                          SizeofSSCVD = document.getElementById("VDSize").value;
                                        }
					<!--Concat -->
                                    
					if(layoutValue=="1" &amp;&amp; (count &lt; parseInt(minDrivesForConcat) || count &gt; parseInt(maxDrivesForConcat)) )
					{
						var strMinConcatError = "<xsl:value-of select="$strMinNumOfDisksErrorConcatCVDAAS"/>" + minDrivesForConcat;
						var strMaxConcatError = "<xsl:value-of select="$strMaxNumOfDisksErrorConcatCVDAAS"/>" + maxDrivesForConcat;
						var strError = "<xsl:value-of select="$strError"/>";
						alert(strError + strMinConcatError + "\n"+strMaxConcatError);
						return false;
					}
					<!-- Raid-0-->
					else if(layoutValue=="2" &amp;&amp; (count &lt; parseInt(minDrivesForRAID0) || count &gt; parseInt(maxDrivesForRAID0)) || parseInt(SizeofSSCVD) &gt; 512 )
					{     
                                             var strMinRaid0Error="";
                                             var strMaxRaid0Error="";
                                             var strError="";                                             
                                              if(( '<xsl:value-of select="$GLOBAL_VAR_CreateSSC"/>' =='1' &amp;&amp; parseInt(SizeofSSCVD) &gt; 512) || ( '<xsl:value-of select="$GLOBAL_VAR_CreateSSC"/>' =='1' &amp;&amp; count &lt; parseInt(minDrivesForRAID0)))
                                               {
                                                    strMinRaid0Error = "<xsl:value-of select="$strMinNumOfDisksErrorSSCCVDAAS"/>" + minDrivesForRAID0;
						                strError = "<xsl:value-of select="$strError"/>";
                                                                                   
                                                    if(count &lt; parseInt(minDrivesForRAID0) ||count &gt; parseInt(maxDrivesForRAID0))
                                                    {
                                                          alert(strError + strMinRaid0Error + "\n"+strMaxRaid0Error);
						                      return false;
                                                    } 
                                                    else if(confirm("<xsl:value-of select="$strMaxSizeSSCCVDAAS"/>")==false)
                                                    {
                                                          return false;
                                                    }  
                                               }
                                               else  
                                               {
                                                      strMinRaid0Error = "<xsl:value-of select="$strMinNumOfDisksErrorRaid0CVDAAS"/>" + minDrivesForRAID0;
                                                      strMaxRaid0Error = "<xsl:value-of select="$strMaxNumOfDisksErrorRaid0CVDAAS"/>" + maxDrivesForRAID0;
                                                      strError = "<xsl:value-of select="$strError"/>";
                                                      alert(strError + strMinRaid0Error + "\n"+strMaxRaid0Error);
						                  return false;
                                                }
					}
					<!-- Raid-1-->
					else if(layoutValue=="4" &amp;&amp; (count &lt; parseInt(minDrivesForRAID1) || count &gt; parseInt(maxDrivesForRAID1)) )
					{
						var strRaid1Error = "<xsl:value-of select="$strNumOfDisksErrorRaid1CVDAAS"/>";
						var strError = "<xsl:value-of select="$strError"/>";
						alert(strError + strRaid1Error);
						return false;
					}
					<!-- Raid-5-->
					else if(layoutValue=="64" &amp;&amp; (count &lt; parseInt(minDrivesForRAID5) || count &gt; parseInt(maxDrivesForRAID5)) )
					{
						var strMinRaid5Error = "<xsl:value-of select="$strMinNumOfDisksErrorRaid5CVDAAS"/>" + minDrivesForRAID5;
						var strMaxRaid5Error = "<xsl:value-of select="$strMaxNumOfDisksErrorRaid5CVDAAS"/>" + maxDrivesForRAID5;
						var strError = "<xsl:value-of select="$strError"/>";
						alert(strError + strMinRaid5Error + "\n"+strMaxRaid5Error);
						return false;
					}
					<!-- Raid-6-->
					else if(layoutValue=="128" &amp;&amp; (count &lt; parseInt(minDrivesForRAID6) || count &gt; parseInt(maxDrivesForRAID6)) )
					{
						var strMinRaid6Error = "<xsl:value-of select="$strMinNumOfDisksErrorRaid6CVDAAS"/>" + minDrivesForRAID6;
						var strMaxRaid6Error = "<xsl:value-of select="$strMaxNumOfDisksErrorRaid6CVDAAS"/>" + maxDrivesForRAID6;
						var strError = "<xsl:value-of select="$strError"/>";
						alert(strError + strMinRaid6Error + "\n"+strMaxRaid6Error);
						return false;
					}

					<!-- Raid-10 -->
					
				   else if(layoutValue=="512")
				   { 
				      var spanLength=getSpanLengthValue();
				      var numSpans = frames["SELECTION_TABLE"].getNumOfSpans();
				      var strRaid10Error = "<xsl:value-of select="$strNumOfDisksErrorRaid10CVDAAS"/>";
				      var strError = "<xsl:value-of select="$strError"/>"
				      if ('<xsl:value-of select="$PARAM_CURR_IM"/>'=='true' || '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'=='9')
				      {  
				             if('<xsl:value-of select="$PARAM_SPANEDITMODE"/>' == 'true')
				             {      //Span Edit Mode
				                    if( numSpans &lt; parseInt(minSpansForRAID10) || numSpans &gt; parseInt(maxSpansForRAID10) )
			                     	{
			         	                   alert(strError + strRaid10Error);
				                         return false;
				                    }
				             }
                            else
                            { 
                                //Raid-10 Requirement - Minimum Disks
                                if(count &lt; parseInt('<xsl:value-of select="$GLOBAL_VAR_MinDrivesForRAID10"/>'))
                                {
                                    if('<xsl:value-of select="$PARAM_CURR_IM"/>'!='true' &amp;&amp; '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'=='9')
                                    {
                                        strRaid10Error= "<xsl:value-of select="$strNumOfMinDisksErrorPerc9CVDAAS"/>";
                                    }
                                    // RAID -10 and IM
                                    if('<xsl:value-of select="$PARAM_CURR_IM"/>'=='true')
                                    {
                                        strRaid10Error= "<xsl:value-of select="$strNumOfMinDisksErrorIMCVDAAS"/>";
                                    }
                                    alert(strError + strRaid10Error);
                                    return false;
                                }
                                // RAID 10, more than four disks but uneven disk.
                                if('<xsl:value-of select="$PARAM_CURR_IM"/>'=='true' &amp;&amp; count%2 != 0)
                                {
                                    strRaid10Error= "<xsl:value-of select="$strUnevenDisksErrorPerc9CVDAAS"/>";
                                    alert(strError + strRaid10Error);
                                    return false;
                                }
                                // Scenario: Raid 10 with Perc 9 : validating if uneven number of disk selected.
                                if ('<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'=='9' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true')
                                {
                                    // Check for not allowing uneven disk in RAID 10 with Perc 9 controller
                                    if(count %2 != 0)
                                    {
                                        strRaid10Error= "<xsl:value-of select="$strUnevenDisksErrorPerc9CVDAAS"/>";
                                        alert(strError + strRaid10Error);
                                        return false;
                                    }
                                }
									
                                if(frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY.length &gt; 0)
                                {   //Before posting put the 2D array input into into 3D array for Intelligent Mirroring
                                    frames["SELECTION_TABLE"].ThreeDArray[0]=frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY;
                                    frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY= new Array();
                                }
                            }
				      }
				      else
				      {   

                                        //Normal Raid-10  GLOBAL_VAR_SingleSpanArrayMinDisksCount
                                         if(document.getElementById("SingleSpans")!=null &amp;&amp; document.getElementById("SingleSpans").disabled==false)
                                         { 
                                            if((count==spanLength ) &amp;&amp; (spanLength=='<xsl:value-of select="$GLOBAL_VAR_SingleSpanArrayMinDisksCount"/>' || spanLength=='<xsl:value-of select="$GLOBAL_VAR_SingleSpanArrayMaxDisksCount"/>') ) 
                                             {
                                               if(!(<xsl:value-of select="substring($RaidLevelMask,13,1)='1'"/>))
                                               {    
                                                    strRaid10Error= "<xsl:value-of select="$strRaid10SingleSpanError"/>";
                                                    alert(strError + strRaid10Error);
							          return false;
                                               }
                                             }
                                             if(count!= spanLength )
                                              {     
                                                    strRaid10Error= "<xsl:value-of select="$strRaid10SingleSpanError2"/>";
                                                    alert(strError + strRaid10Error);
                                                    return false;
                                              }
                                           }                                              
				                   else if(((count &lt; 2*spanLength) ||(count % spanLength !=0) ||( numSpans &lt; parseInt(minSpansForRAID10) || numSpans &gt; parseInt(maxSpansForRAID10)) ))
				                   {  
				                      alert(strError + strRaid10Error);
							    return false;
				                   }
				     }
			       }
				 else if( layoutValue == "2048" )
				 {
						var numSpans = frames["SELECTION_TABLE"].getNumOfSpans();
						var spanLength=getSpanLengthValue();
						if(count &lt; 2*spanLength || count % spanLength !=0 )// got to change -done
						{
							var strRaid50Error = "<xsl:value-of select="$strNumOfDisksErrorRaid50CVDAAS"/>";
							var strError = "<xsl:value-of select="$strError"/>";
							alert(strError + strRaid50Error);
							return false;
						}
						if( numSpans &lt; parseInt(minSpansForRAID50) || numSpans &gt; parseInt(maxSpansForRAID50))
						{
							var strNumOfSpanError = "<xsl:value-of select="$strNumOfSpansErrorRaid50CVDAAS"/>";
							var strError = "<xsl:value-of select="$strError"/>";
							alert(strError + strNumOfSpanError);
							return false;
						}
					}
					<!-- RAID 60  check this-->
					else if( layoutValue =="262144" )
					{
						var numSpans = frames["SELECTION_TABLE"].getNumOfSpans();
						var spanLength=getSpanLengthValue();
						if(count &lt; 2*spanLength || count % spanLength !=0 )
						{
							var strRaid60Error = "<xsl:value-of select="$strNumOfDisksErrorRaid60CVDAAS"/>";
							var strError = "<xsl:value-of select="$strError"/>";
							alert(strError + strRaid60Error);
							return false;
						}
						if( numSpans &lt; parseInt(minSpansForRAID60) || numSpans &gt; parseInt(maxSpansForRAID60))
						{
							var strNumOfSpanError = "<xsl:value-of select="$strNumOfSpansErrorRaid60CVDAAS"/>";
							var strError = "<xsl:value-of select="$strError"/>";
							alert(strError + strNumOfSpanError);
							return false;
						}
					}
					<!-- Raid-1-Concat-->
					else if(  layoutValue=="4096"  )
					{
						var numSpans = frames["SELECTION_TABLE"].getNumOfSpans();
						if(count &lt; 4 || count %2 != 0)
						{
							var strRaid1cError = "<xsl:value-of select="$strNumOfDisksErrorRaid1ConcatCVDAAS"/>";
							var strError = "<xsl:value-of select="$strError"/>";
							alert(strError + strRaid1cError);
							return false;
						}
						if( numSpans &lt; parseInt(minSpansForRAID1Concat) || numSpans &gt; parseInt(maxSpansForRAID1Concat) )  
						{
							var strNumOfSpanError = "<xsl:value-of select="$strNumOfSpansErrorRaid1ConcatCVDAAS"/>";
							var strError = "<xsl:value-of select="$strError"/>";
							alert(strError + strNumOfSpanError);
							return false;
						}
					}
					else if(layoutValue=="524288")
				    {   
					    var strMinRaid10EError = "<xsl:value-of select="$strMinNumOfDisksErrorRaid10CVDAAS"/>" + minDrivesForRAID1E;
						var strError = "<xsl:value-of select="$strError"/>";
						var strEvenNumberOfDisksRAID1E = "<xsl:value-of select="$strEvenNumberOfDisksRAID1E"/>";
					    if(count &lt; parseInt(minDrivesForRAID1E))
						{
					    alert(strError + strMinRaid10EError);
						return false;
						} 
						else if(count % 2 != 0)
						{
						  alert(strError + strEvenNumberOfDisksRAID1E);
						  return false;
						}
				    }
					<!-- In DSA mode if SAS 5ira has > 2 disks, prompt the user if disk w/ lowest drive ID is not selected. -->
					if(  RulesValue=="1" &amp;&amp; DSARaidModeAndDiskCheck=="1" )
					{
						return frames["SELECTION_TABLE"].CheckIfFirstArrayDiskSelected();
					}

					return true;
				}
				function backPage()
				{
					var layoutValue='<xsl:value-of select="$PARAM_PREV_Layout"/>';
					var IDList="";
					<!--var SpanLength=frames["SELECTION_TABLE"].getSpanLength();-->
					var SpanLength = getSpanLengthValue();
					
					var intMirror = getIMValue();
					var selectAll = getSelectAllValue();
                              
					//var backWebPlugin = "com.dell.sm.webplugins.CreateVDAdvancedRaidLayoutSelectionWebPlugin";
					
					if(layoutValue == 512 || layoutValue==2048 || layoutValue==4096 || layoutValue ==262144 )
					{  
                                          var IMSupport=<xsl:value-of select="substring($CntrlAttributesMask,11,1)='1'"/>;

                                            if(layoutValue == 512 &amp;&amp; IMSupport)
                                             {
                                                    var EnclosureSelectedList=frames["SELECTION_TABLE"].GetSelectedOrDisabledEnclosures(1);
                                                    var EnclosureDisabledList=frames["SELECTION_TABLE"].GetSelectedOrDisabledEnclosures(0);
                                             }

                                      
						var spanInProgressLen = frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY.length;
                                    if(('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true' &amp;&amp; '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true'))
                                    { 
						   var numOfSpans = frames["SELECTION_TABLE"].FourDArray.length;
                                       var numOfMirrors = frames["SELECTION_TABLE"].MIRROR_IN_PROGRESS_ARRAY.length;
                                 
                                    
						    if(numOfSpans == 0 &amp;&amp; spanInProgressLen == 0 &amp;&amp; numOfMirrors == 0)
						    {
							   IDList="";<!-- Set to zero length string-->
						    }
                                        if(numOfSpans >0 )
						    {
							   IDList=frames["SELECTION_TABLE"].getSelectedArrayDisksObjIDsForSpans();
							  
						    }
                                        if(spanInProgressLen > 0)
						    {     if(IDList == "")
                                              {
                                                        IDList=frames["SELECTION_TABLE"].R10_getSelectedArrayDisksObjIDsForSpans();
                                              }
                                              else
                                              {  
 							              IDList+=":"+frames["SELECTION_TABLE"].R10_getSelectedArrayDisksObjIDsForSpans();
                                              }
						    }
						    if(numOfMirrors >0)
                                         {     if(IDList == "")
                                               {  
							                IDList=frames["SELECTION_TABLE"].getSelectedAndEnabledArrayDisksObjIDs();
                                               }
                                               else
                                               {
                                                          IDList+=":"+frames["SELECTION_TABLE"].getSelectedAndEnabledArrayDisksObjIDs();
                                               }

						    }
						  }
                                      else
                                      {   var numOfSpans = frames["SELECTION_TABLE"].ThreeDArray.length;

                                           if(numOfSpans == 0 &amp;&amp; spanInProgressLen == 0)
								{
									IDList="";<!-- Set to zero length string-->
								}
								if(numOfSpans > 0)
								{  
									IDList=frames["SELECTION_TABLE"].getSelectedArrayDisksObjIDsForSpans();
								}
								if(spanInProgressLen > 0)
								{
                                                      if(IDList == "")
                                                      {
                                                                    IDList=frames["SELECTION_TABLE"].getSelectedAndEnabledArrayDisksObjIDs();
                                                      }
                                                      else
                                                      {
 									              IDList+=":"+frames["SELECTION_TABLE"].getSelectedAndEnabledArrayDisksObjIDs();
                                                      }
								}
                                          
                                      } 
						   
					}
					else
					{
						IDList = frames["SELECTION_TABLE"].getSelectedArrayDisksObjIDs();
					}
					
				<!--
					<xsl:choose>
					<xsl:when test="$PARAM_SPANEDITMODE = 'true'">
						backWebPlugin = "com.dell.sm.webplugins.CreateVDAdvancedSummaryWebPlugin&amp;IDList=<xsl:value-of select="$PARAM_CURR_IDList"/>";
					</xsl:when>
					<xsl:otherwise>
						backWebPlugin = "com.dell.sm.webplugins.CreateVDAdvancedRaidLayoutSelectionWebPlugin&amp;IDList=" + IDList;
					</xsl:otherwise>					
					</xsl:choose>
				-->

					<xsl:if test="$PARAM_DSA_Rules='1'">
						<!-- Flush and reload the DSA javascript page cache on going back. We need to do this for the iframes as well. -->
						cachePageInDSA();
						frames["RESULT_TABLE"].cachePageInDSA();
					</xsl:if>
					 var SecureVD=0;
                                if(document.getElementById("SingleSpans")!=null &amp;&amp; document.getElementById("SingleSpans").disabled==false)
                                           {
                                                    document.getElementById("SingleSpanVD").value = "true";
                                           }  
                                         document.getElementById("SecureVD").value = '<xsl:value-of select="$CreateSecureVD"/>';
					<!-- First check to see if any adisks have been selected by user-->
                             if(new String(IDList).length == 0)
                             {       
                                           
                                    document.dataarea.action = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedRaidLayoutSelectionWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_BACKPAGE_PARAMS"/>&amp;<xsl:value-of select="$CACHED_PARAMS"/>&amp;UseCachedXMLData=false"+"&amp;IDList="+IDList+"&amp;SpanLength="+SpanLength+"&amp;IntMirror="+intMirror+"&amp;EnclosureSelectedList="+EnclosureSelectedList+"&amp;EnclosureDisabledList="+EnclosureDisabledList+"&amp;SelectAllVal="+selectAll+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>");
                                    document.dataarea.submit();
				     }
					else
					{
						var UserSelectedAdiskArrayNumList= getUserSelectedAdiskArrayNumList(IDList);
						var UserSelectedAdiskContiguousFreeSpaceList= getUserSelectedAdiskContiguousFreeSpaceList(IDList);
						var StateParams = "UserSelectedAdiskArrayNumList="+UserSelectedAdiskArrayNumList+"&amp;UserSelectedAdiskContiguousFreeSpaceList="+UserSelectedAdiskContiguousFreeSpaceList;
                                            
                                          
												document.getElementById("IDList").value = "";
                                                document.dataarea.action = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedRaidLayoutSelectionWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_BACKPAGE_PARAMS"/>&amp;<xsl:value-of select="$CACHED_PARAMS"/>&amp;UseCachedXMLData=false"+"&amp;SpanLength="+SpanLength+"&amp;IntMirror="+intMirror+"&amp;EnclosureSelectedList="+EnclosureSelectedList+"&amp;EnclosureDisabledList="+EnclosureDisabledList+"&amp;SelectAllVal="+selectAll+"&amp;"+StateParams+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>");
                                                document.dataarea.submit();

					}
				}
				function cacheIframesAndExitWizard() {
					<!-- Flush and reload the DSA javascript page cache on exiting wizard. We need to do this for the iframes as well. -->
					frames["RESULT_TABLE"].cachePageInDSA();
					exitWizardInDSA();
				}
				function getUserSelectedAdiskArrayNumList(IDList)
				{
					var ObjIDArray = IDList.split(":");
					var len = ObjIDArray.length;
					var retval = "";
					for(var i=0; i&lt;len; i++)
					{
						var tempStr = document.getElementById("AN"+ObjIDArray[i].toString()).value;
						if(i==0)
						{
							retval=tempStr;
						}
						else
						{
							retval+=":"+tempStr;
						}
					}
					return retval;
				}
				function getUserSelectedAdiskContiguousFreeSpaceList(IDList)
				{
					var ObjIDArray = IDList.split(":");
					var len = ObjIDArray.length;
					var retval = "";
					for(var i=0; i&lt;len; i++)
					{
						var tempStr = document.getElementById("CFS"+ObjIDArray[i].toString()).value;
						if(i==0)
						{
							retval=parseInt(tempStr);
						}
						else
						{
							retval+=parseInt(tempStr);
						}
					}
					return parseInt(retval);
				}
				
				function getSpanLengthValue()
				{
					<!-- this function is called by Selection_table IFrame to obtain the value of "number of disks in Span for RAID 50" entered by user in edit box-->
					var layoutValue='<xsl:value-of select="$PARAM_PREV_Layout"/>';
					if(layoutValue == 4096) 
						return 2;
					else if(layoutValue == 512 )
					 {  
                                            var SpanLengthValue = 2; //to take care of scsi and other normal conditions
                                            if(document.getElementById("Spans") != null &amp;&amp; document.getElementById("Spans").disabled==false  )
                                            { 
                                                        SpanLengthValue = parseInt(document.getElementById("Spans").value);
                                                        
                                            }  
                                             if(document.getElementById("SingleSpans") != null &amp;&amp; document.getElementById("SingleSpans").disabled==false  )
                                            { 
                                                        SpanLengthValue = parseInt(document.getElementById("SingleSpans").value);
                                                        
                                            }   
                                            if(INTMIRROR_ON_PAGE_LOAD=='true' &amp;&amp; SPANEDITMODE != 'true')
                                            {
                                                           SpanLengthValue =parseInt('<xsl:value-of select="$GLOBAL_VAR_ArrayDiskCount"/>') + 1; 
                                            }
                                            if(INTMIRROR_ON_PAGE_LOAD=='true' &amp;&amp; SPANEDITMODE == 'true')
                                            {
                                                           SpanLengthValue =parseInt('<xsl:value-of select="$PARAM_CURR_SpanLength"/>'); 
                                            }

                                             
    
                                            return SpanLengthValue;
                                          }   
					else if(layoutValue==2048 || layoutValue == 262144)
						         return parseInt(document.getElementById("Spans").value);
					else
						return 0;
				}

				function getIMValue()
				{
					var intMirror = false;
					intMirror ='<xsl:value-of select="$PARAM_CURR_IM"/>'; 

					return intMirror;
				}
				
				function getSelectAllValue()
				{
					var selectAll = false;
					if (document.getElementById("SelectAll") != null)
						selectAll = document.getElementById("SelectAll").checked;

					return selectAll;
				}
				
				function setSpanLengthValue(value)
				{
					// TBD: Change the caller
					if ((SPANEDITMODE != 'true') &amp;&amp; (document.getElementById("Spans") != null))
						document.getElementById("Spans").value = value;
				}
				function OnSelectSpanInfo(SingleSpan)
                        {  if(frames["SELECTION_TABLE"].GetSelectedArrayDisksCount() &gt; 1)
                           {
                              if(!confirm("<xsl:value-of select="$strPromptLossOfDiskSelection"/>"))
                              {
							   setSingleSpanValue(SingleSpan);
                               return;
                              }
                            }  
                           if(SingleSpan == '1')
                              {
							    if (document.getElementById("Spans") != null)
								{ 
                                  document.getElementById("Spans").disabled=true;
                                  document.getElementById("SingleSpans").disabled=false;
                                  frames["SELECTION_TABLE"].setSpanLengthValue(document.getElementById("SingleSpans").value);
                                }
								       
                              }  
                              else
                              {
							     if (document.getElementById("SingleSpans") != null)
								{ 
                                  document.getElementById("Spans").disabled=false;
                                  document.getElementById("SingleSpans").disabled=true;
                                  frames["SELECTION_TABLE"].setSpanLengthValue(document.getElementById("Spans").value);
                                }								  
                               
                              }
							 
                                var numSpansAllowed = parseInt("<xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID10"/>");

                           for (var i=numSpansAllowed; i &gt;=0 ; i--)
						{
							frames["RESULT_TABLE"].OnDeleteSpan("Span "+i.toString());
						}
                        
                        if(SingleSpan == '1')
						{
                                var freedisk = "<xsl:value-of select="$GLOBAL_VAR_FreeDiskCount"/>";						  
								if(freedisk &lt; 22)
								{ 
						    		<xsl:for-each select="//ArrayDisks/DCStorageObject[UsedSpace='0']">
									var Chbxname = "";
									var EnclosureID = "<xsl:value-of select="EnclosureID"/>";
									var Channel = "<xsl:value-of select="Channel"/>";
									var TargetID = "<xsl:value-of select="TargetID"/>";
									Chbxname = "Sel"+Channel+":"+EnclosureID+":"+TargetID;
									if(frames["SELECTION_TABLE"].document.getElementById(Chbxname)!=null);
									{ 
										
									frames["SELECTION_TABLE"].document.getElementById(Chbxname).disabled=true;
                                 
									}								
						   
						            </xsl:for-each>
						        }							   
                        }						
                           
                        }

				function OnSpanLengthChangeHandler(layout)
				{   
                                        if(document.getElementById("VDSize")!=null)
                                          {
                                             document.getElementById("VDSize").value=0;
                                          }

                                         var  currValue= '<xsl:value-of select="$PARAM_CURR_SpanLength"/>';
                                         if(document.getElementById("Spans")!=null &amp;&amp; document.getElementById("Spans").disabled == false)
                                          {
                                               currValue = parseInt(document.getElementById("Spans").value);
                                          }                              
                                          if(document.getElementById("SingleSpans")!=null &amp;&amp; document.getElementById("SingleSpans").disabled == false)
                                          {
                                               currValue = parseInt(document.getElementById("SingleSpans").value);
                                          } 
					var numSpansAllowed = 2; //default of 2
					
					if(layout == '512')
					{
						numSpansAllowed = parseInt("<xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID10"/>");
					}
					else if(layout == '2048')
					{
						numSpansAllowed = parseInt("<xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID50"/>");
					}
					else if(layout == '262144')
					{
						numSpansAllowed = parseInt("<xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID60"/>");
					}				

					var numDisksSelected = frames["SELECTION_TABLE"].GetSelectedArrayDisksCount();
					
					if(numDisksSelected &lt; 1)
					{
						PREV_SPAN_LENGTH_VALUE = currValue;
						<!-- Call the setSpanLengthValue() in Selection_Table iframe to update the value of SpanLength maintained by Selection_Table iframe.-->
						frames["SELECTION_TABLE"].setSpanLengthValue(currValue);
					}
					else if( confirm("<xsl:value-of select="$strPromptLossOfDiskSelection"/>") == false)
					{
						setSpanLengthValue(PREV_SPAN_LENGTH_VALUE);
						return;
					}
					else
					{
						if(layout == '512' &amp;&amp; document.getElementById("SelectAll") != null)
						{
							document.getElementById("SelectAll").checked=false;
						}
						PREV_SPAN_LENGTH_VALUE = currValue;
						
						<!--When clearing the spans in result table, make sure to clear starting from last span; because every time a span is cleared, span numbers change.  -->
						for (var i=numSpansAllowed; i &gt;=0 ; i--)
						{
							frames["RESULT_TABLE"].OnDeleteSpan("Span "+i.toString());
						}
						<!-- Call the setSpanLengthValue() in Selection_Table iframe to update the value of SpanLength maintained by Selection_Table iframe.-->
						frames["SELECTION_TABLE"].setSpanLengthValue(currValue);

					}				

					var VDSpanLengths = "<xsl:value-of select="$GLOBAL_VAR_ArraySpanLength"/>";
					if (VDSpanLengths != null &amp;&amp; VDSpanLengths != '')
					{
                                   	
				           	frames["SELECTION_TABLE"].enableAllCheckBoxes();

      					var VDSingleSpanLength = VDSpanLengths.split(";");
                                        var arrayNums = "<xsl:value-of select="$GLOBAL_VAR_ArrayNumDisks"/>";
      					var arrayNumArray = arrayNums.split(";");
						for(var y=0;y&lt;VDSingleSpanLength.length;y++)
						{            
							if (currValue != VDSingleSpanLength[y])
							{
      							var ObjIDArray = arrayNumArray[y].split(":");
								var elemName = "";
						 		for(var z=0; z&lt;ObjIDArray.length; z++)
						 		{
									elemName = "OBJID"+ObjIDArray[z];
									var chkBxName = "";
									if(frames["SELECTION_TABLE"].document.getElementById(elemName) != null)
									{
										chkBxName = "Sel"+frames["SELECTION_TABLE"].document.getElementById(elemName).value;
										if (frames["SELECTION_TABLE"].document.getElementById(chkBxName) != null)
										{
											frames["SELECTION_TABLE"].document.getElementById(chkBxName).checked=false;
											frames["SELECTION_TABLE"].document.getElementById(chkBxName).disabled=true;
										}
									}

 								}	
								
							}
							else
							{
								//Do not do anything ...meaning keep the disks for selection
								continue;
							}
						}

						//Keep disabled Selectall and enclosure select
						if (document.getElementById("SelectAll") != null)
						{
							document.getElementById("SelectAll").checked = false;
							document.getElementById("SelectAll").disabled = true;
						}

                              	var chBxName="";
                              	for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
                              	{
                              		for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
                                    	{
                                    		chBxName="Sel"+i.toString()+":"+k.toString();
                                          	if(frames["SELECTION_TABLE"].document.getElementById(chBxName)!=null)
                                          	{      
                                                	frames["SELECTION_TABLE"].document.getElementById(chBxName).checked=false;
                                                	frames["SELECTION_TABLE"].document.getElementById(chBxName).disabled=true;
                                          	}
                                   		}
                            		}

					}
				
				}				
				
				
				<!--This function is a handler that is called in response to disk protocol type radio button selection-->
				
				<!--This function is a handler that is called when select All checkbox is selected-->
                                function enableEnclosureCheckBoxes()
                                { 
                                  var chBxName="";
                                  for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
			          {
				                for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
                                                {
                                                   chBxName="Sel"+i+":"+k;
                                                   if(document.getElementById(chBxName)!=null &amp;&amp; document.getElementById(chBxName).checked==true)
                                                   {
                                                         document.getElementById(chBxName).checked=false;
                                                         document.getElementById(chBxName).disabled=false;
                                                    }
                                                 }
                                 }
                               }

                        function resetall()
                        { 
                           frames["RESULT_TABLE"].hideResultTable();
                           frames["SELECTION_TABLE"].unSelectAllCheckBoxes();
                          
                            for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
			    {
			       for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
			       {
				     chkBxName="Sel"+i.toString()+":"+k.toString();
			             if(frames["SELECTION_TABLE"].document.getElementById(chkBxName)!=null)
                                     { 
                                       frames["SELECTION_TABLE"].document.getElementById(chkBxName).checked=true;
                                       frames["SELECTION_TABLE"].document.getElementById(chkBxName).disabled=true;
                                     }   
			       }
                            }
                           
                        }

                        function OnIMSelected()
                        { 
                           if('<xsl:value-of select="$PARAM_CURR_IM"/>'=='true')
                           {         
                                     frames["SELECTION_TABLE"].setSpanLengthValue(parseInt('<xsl:value-of select="$GLOBAL_VAR_ArrayDiskCount"/>') + 1);
                                     document.getElementById("Spans").disabled=true; 
                           }
                          else
                           {
                                    
                                 
   
                                    document.getElementById("Spans").disabled=false;
                                    if(document.getElementById("Spans")!=null)
                                    {
                                               document.getElementById("Spans").disabled=false;
                                    }
                                 
                                    document.getElementById("SelectAll").checked=false;
                                    document.getElementById("SelectAll").disabled=false; 
				    frames["SELECTION_TABLE"].unSelectAllCheckBoxes();
				    frames["RESULT_TABLE"].hideResultTable();
				    if(frames["SELECTION_TABLE"].IsSpanMode())
				    {
				               frames["SELECTION_TABLE"].clearSpanSelectionTable();
				    }
				    frames["SELECTION_TABLE"].enableAllCheckBoxes();
                                    for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
				    {
				              for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
				               {
					          chkBxName="Sel"+i.toString()+":"+k.toString();
					          if(frames["SELECTION_TABLE"].document.getElementById(chkBxName)!=null)
                                                  { 
                                                             frames["SELECTION_TABLE"].document.getElementById(chkBxName).checked=false;
                                                             frames["SELECTION_TABLE"].document.getElementById(chkBxName).disabled=false;
                                                  }   
		                                }
                                    }
                                    if(document.getElementById("Spans")!=null)
                                    {
                                    frames["SELECTION_TABLE"].setSpanLengthValue(document.getElementById("Spans").value);
                                    }
                                    frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY=new Array;

                                  }//end of else part 
                                }
                                
				function OnSelectAllSelected()
				{  
                                    var chkBxName=""; 
                                    resetall();
                                    
                                       
                                        if (document.getElementById("SelectAll").checked==true)
				                {     
	 			                  frames["SELECTION_TABLE"].unSelectAllCheckBoxes();
				                  frames["RESULT_TABLE"].hideResultTable();
                                          
				                         if((document.getElementById("Spans")!=null &amp;&amp; document.getElementById("Spans").disabled==false)|| (document.getElementById("SingleSpans")!=null &amp;&amp; document.getElementById("SingleSpans").disabled==false))
                                                  {             
                                                            frames["SELECTION_TABLE"].setSpanLengthValue(frames.getSpanLengthValue());
                                                  }
                                                  else  
                                                  { 
                                                             frames["SELECTION_TABLE"].setSpanLengthValue(2);
                                                  }  
                                                 if('<xsl:value-of select="$PARAM_CURR_IM"/>'=='true' || ( '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'=='9' &amp;&amp; layoutValue == 512))
                                                 {
                                                             frames["SELECTION_TABLE"].setSpanLengthValue(parseInt('<xsl:value-of select="$GLOBAL_VAR_ArrayDiskCount"/>') + 1);
                                                 }
   			                          if(frames["SELECTION_TABLE"].IsSpanMode())
				                   {
				                             frames["SELECTION_TABLE"].clearSpanSelectionTable();
				                   }
				                   frames["SELECTION_TABLE"].enableAllCheckBoxes();
                      		                   frames["SELECTION_TABLE"].selectAllCheckBoxesforSpannedRaidLevels();
                                           for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
			                         {
				                              for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
				                              {
				                                     chkBxName="Sel"+i.toString()+":"+k.toString();
				                                     if(frames["SELECTION_TABLE"].document.getElementById(chkBxName)!=null)
                                                                     {  
                                                                            frames["SELECTION_TABLE"].document.getElementById(chkBxName).checked=false;
                                                                            frames["SELECTION_TABLE"].document.getElementById(chkBxName).disabled=true;
                                                                      }   
				                               }
                                                  }
                                                 if(frames["SELECTION_TABLE"].FourDArray.length!=0)
                                                 {        
                                                     var tempSize=0;
                                                       for(var z=0; z &lt; frames["SELECTION_TABLE"].FourDArray[0].length &amp;&amp; frames["SELECTION_TABLE"].JS_GLOBAL_WarnForDifferentSizeDisksInSpan==1; z++)
				                               {
                                                             for(var len=0;len &lt; frames["SELECTION_TABLE"].FourDArray.length;len++)
                                                             {
				                                    var elemName = "DISK"+frames["SELECTION_TABLE"].FourDArray[len][z][0]+frames["SELECTION_TABLE"].FourDArray[len][z][1]+frames["SELECTION_TABLE"].FourDArray[len][z][2];
                                                                    if(frames["SELECTION_TABLE"].document.getElementById(elemName)!=null)
                                                                    { 
				                                           var elemNameValue = frames["SELECTION_TABLE"].document.getElementById(elemName).value;
                                                                    }
				                                    if(tempSize !=0 &amp;&amp; elemNameValue != tempSize )
				                                    {     
					                                   alert("<xsl:value-of select="$strWarnUnequalSizeDisksInSpan"/>");
					                                   return;
				                                    }
				                                    else
				                                    {
				                                           tempSize=elemNameValue;
				                                    }
                                                              }
				                         } 
                                                  }// if closed
                                                  
                                                  
                                                  
                                                if(('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true' &amp;&amp; '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true'))
                                                 { 
                                                         if(frames["SELECTION_TABLE"].FourDArray.length!=0)
                                                         {        
                                                            var tempSize=0;
                                                            for(var z=0; z &lt; frames["SELECTION_TABLE"].FourDArray[0].length &amp;&amp; frames["SELECTION_TABLE"].JS_GLOBAL_WarnForDifferentSizeDisksInSpan==1; z++)
				                                    {
                                                                   for(var len=0;len &lt; frames["SELECTION_TABLE"].FourDArray.length;len++)
                                                                   {
				                                           var elemName = "DISK"+frames["SELECTION_TABLE"].FourDArray[len][z][0]+frames["SELECTION_TABLE"].FourDArray[len][z][1]+frames["SELECTION_TABLE"].FourDArray[len][z][2];
                                                                           if(frames["SELECTION_TABLE"].document.getElementById(elemName)!=null)
                                                                           { 
				                                                     var elemNameValue = frames["SELECTION_TABLE"].document.getElementById(elemName).value;
                                                                           }
				                                           if(tempSize !=0 &amp;&amp; elemNameValue != tempSize )
				                                           {     
					                                            alert("<xsl:value-of select="$strWarnUnequalSizeDisksInSpan"/>");
					                                            return;
				                                           }
				                                           else
				                                           {
				                                                 tempSize=elemNameValue;
				                                           }
                                                                    }
				                             } 
                                                         }// if closed
                                                }// if closed
                                                else
                                                {
                                                     if(frames["SELECTION_TABLE"].ThreeDArray.length!=0)
                                                     {        
                                                          var tempSize=0;
                                                          for(var z=0; z &lt; frames["SELECTION_TABLE"].ThreeDArray[0].length &amp;&amp; frames["SELECTION_TABLE"].JS_GLOBAL_WarnForDifferentSizeDisksInSpan==1; z++)
				                                  {
                                                               for(var len=0;len &lt; frames["SELECTION_TABLE"].ThreeDArray.length;len++)
                                                               {
				                                    var elemName = "DISK"+frames["SELECTION_TABLE"].ThreeDArray[len][z][0]+frames["SELECTION_TABLE"].ThreeDArray[len][z][1]+frames["SELECTION_TABLE"].ThreeDArray[len][z][2];
                                                                    if(frames["SELECTION_TABLE"].document.getElementById(elemName)!=null)
                                                                    { 
				                                           var elemNameValue = frames["SELECTION_TABLE"].document.getElementById(elemName).value;
                                                                    }
				                                    if(tempSize !=0 &amp;&amp; elemNameValue != tempSize )
				                                    {     
					                                   alert("<xsl:value-of select="$strWarnUnequalSizeDisksInSpan"/>");
					                                   return;
				                                    }
				                                    else
				                                    {
				                                           tempSize=elemNameValue;
				                                    }
                                                              }
				                         } 
                                                     }// if closed
                                                 }  
                                   } // main if closed
                                  else // if select all is deselected
                                  {
                                     frames["SELECTION_TABLE"].unSelectAllCheckBoxes();
				             frames["RESULT_TABLE"].hideResultTable();
				             if(frames["SELECTION_TABLE"].IsSpanMode())
				             {
				                frames["SELECTION_TABLE"].clearSpanSelectionTable();
				             }
  				     frames["SELECTION_TABLE"].enableAllCheckBoxes();
                                     for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
				     {
				             for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
				             {
                                                    chkBxName="Sel"+i.toString()+":"+k.toString();
                                                    if(frames["SELECTION_TABLE"].document.getElementById(chkBxName)!=null)
                                                    { 
                                                            frames["SELECTION_TABLE"].document.getElementById(chkBxName).checked=false;
                                                            frames["SELECTION_TABLE"].document.getElementById(chkBxName).disabled=false;
                                                    }   
				      
                                              }
                                     }
                                     frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY=new Array;
                                     if(document.getElementById("Spans")!=null &amp;&amp; document.getElementById("Spans").disabled==false)
                                     {
                                                   frames["SELECTION_TABLE"].setSpanLengthValue(document.getElementById("Spans").value);
                                     }
                                     if(document.getElementById("SingleSpans")!=null &amp;&amp; document.getElementById("SingleSpans").disabled==false)
                                     {
                                                    frames["SELECTION_TABLE"].setSpanLengthValue(document.getElementById("SingleSpans").value);
                                     }
                                   }//end of else
				}

				
				function setSingleSpanValue(val)
				{  
				         if (document.getElementsByName("SpanInfo") != null)
					{
					      var RadioArray=document.getElementsByName("SpanInfo");
					      if(val == '1')
                                              {  		 
        		                            RadioArray[0].checked=true;
				                    RadioArray[1].checked=false;
					      }
                                              else
                                              {  
					          RadioArray[0].checked=false;
				                  RadioArray[1].checked=true;
                                               }					 
					}
		    	         }
				
				<xsl:if test="$PARAM_DSA_Rules='1'">
					<xsl:call-template name="getDSAScripts">
						<xsl:with-param name="PARAM_Screen_Name"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:with-param>
						<xsl:with-param name="PARAM_Exit_Wizard_URL"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</script>
			
		
			
			<PageTitle>
				<xsl:attribute name="display"><xsl:choose><xsl:when test="$GLOBAL_VAR_CreateSSC = '1'"><xsl:value-of select="$strTitleMainStartCVDAAS_CreateSSC"/><xsl:text> - </xsl:text></xsl:when><xsl:when test="$PARAM_SPANEDITMODE = 'true'"><xsl:value-of select="$strSpanEditingMode"/><xsl:text> - </xsl:text></xsl:when><xsl:otherwise><xsl:value-of select="$strTitleMainStartCVDAAS"/></xsl:otherwise></xsl:choose><xsl:text/><xsl:value-of select="$PARAM_REGULAR_ControllerName"/><xsl:text/><xsl:value-of select="$strTitleMainEndCVDAAS"/></xsl:attribute>
			</PageTitle>
			

     	               <!-- Check if data loss warning should be added if the controller attributemask tells us to -->		
			<xsl:choose>
				<xsl:when test="substring($CntrlAttributesMask,13,1)='1'">
					<AlertMessage alert="true" status="3">
						<xsl:attribute name="display"><xsl:value-of select="$strDataWarning"/></xsl:attribute>
					</AlertMessage>	
				</xsl:when>
			</xsl:choose>
					
			<!-- Next call the template to render the bottom custom buttons for the wizard page-->
                        
			<xsl:call-template name="RenderBottomCustomButtons"/>
                      
				
			<!--xsl:call-template name="RenderDiskTypeSelectionRadioButtons"/-->
							
			<HiddenTable>
				<xsl:for-each select="//ArrayDisks/DCStorageObject">
					<xsl:call-template name="getAdiskArrayNum_HIDDEN_TABLE"/>
					<xsl:call-template name="getContiguousFreeSpace_HIDDEN_TABLE"/>
				</xsl:for-each>
			</HiddenTable>
            <xsl:if test="$PARAM_SPANEDITMODE != 'true'">
			   <xsl:if test="$PARAM_PREV_Layout='512' and substring($CntrlAttributesMask,11,1)='1'">
                                <xsl:if test="$PARAM_CURR_IM !='true' and $GLOBAL_VAR_PercVersion !='9'">
				<TableData>
					<Row>
					        <xsl:if test="$GLOBAL_VAR_FreeDiskCount &gt;= '4' or ($GLOBAL_PARAM_MINNORMALSPANLENGTH != '' and $GLOBAL_PARAM_MINNORMALSPANLENGTH &gt;= '2')">
                                    <xsl:choose>
								<xsl:when test="substring($RaidLevelMask,13,1)='1'">
									<Data name="SpanInfo" type="radio" value="{$strPromptNumOfDisksForSpan}" handler="javascript:OnSelectSpanInfo('0')" event="onclick" />
								</xsl:when>
								<xsl:otherwise>
									<Data name="SpanInfo" value="{$strPromptNumOfDisksForSpan}"/>
								</xsl:otherwise>
							</xsl:choose>
							
                            <Data name="Spans" type="select" event="onchange" handler="javascript:OnSpanLengthChangeHandler('512')">
							   <xsl:call-template name="RenderSpanLengthListBox">
								   <xsl:with-param name="initial" select="$GLOBAL_VAR_MinDrivesForRAID10Span"/>
								   <xsl:with-param name="terminal" select="$GLOBAL_VAR_MaxDrivesForRAID10Span"/>
								   <xsl:with-param name="increment" select="2"/>
   							   </xsl:call-template>
                     	    </Data>
					 
                    	</xsl:if>			   
					  
					   <xsl:choose>
                          
                          <xsl:when test="substring($RaidLevelMask,13,1)='1' and ($GLOBAL_VAR_FreeDiskCount &gt;= $GLOBAL_VAR_SingleSpanArrayMinDisksCount or $GLOBAL_PARAM_MINSINGLESPANLENGTH = $GLOBAL_VAR_SingleSpanArrayMinDisksCount or $GLOBAL_PARAM_MAXSINGLESPANLENGTH = $GLOBAL_VAR_SingleSpanArrayMaxDisksCount)">							   
						     <Data name="SpanInfo" type="radio" value="{$strPromptNumOfDisksForSingleSpan}" handler="javascript:OnSelectSpanInfo('1')"  event="onclick" />
						     <Data name="SingleSpans" type="select" event="onchange" handler="javascript:OnSpanLengthChangeHandler('512')">
                                         
                      
							<xsl:if test="$GLOBAL_VAR_FreeDiskCount &gt;= $GLOBAL_VAR_SingleSpanArrayMinDisksCount or $GLOBAL_PARAM_MINSINGLESPANLENGTH = $GLOBAL_VAR_SingleSpanArrayMinDisksCount">
		    	                  <Choice value="{$GLOBAL_VAR_SingleSpanArrayMinDisksCount}" returnvalue="{$GLOBAL_VAR_SingleSpanArrayMinDisksCount}"/>
  	                        </xsl:if>
                      
					        <xsl:if test="$GLOBAL_VAR_FreeDiskCount &gt;= $GLOBAL_VAR_SingleSpanArrayMaxDisksCount or $GLOBAL_PARAM_MAXSINGLESPANLENGTH = $GLOBAL_VAR_SingleSpanArrayMaxDisksCount">   
			                        <Choice value="{$GLOBAL_VAR_SingleSpanArrayMaxDisksCount}" returnvalue="{$GLOBAL_VAR_SingleSpanArrayMaxDisksCount}"/>
 	                        </xsl:if>
                                           
 						</Data>
                                </xsl:when>
                                <xsl:otherwise>
						<Data value="" width="25%"/>
						<Data value="" width="25%"/>
                                </xsl:otherwise>
                                </xsl:choose>
					</Row>
				</TableData>
			</xsl:if>
			</xsl:if>
  </xsl:if>
			<xsl:if test="$PARAM_PREV_Layout=2048">
				<TableData>
					<Row>
						<Data value="{$strPromptNumOfDisksForSpan}"/>
						<Data name="Spans" type="select" event="onchange" handler="javascript:OnSpanLengthChangeHandler('2048')">
							<xsl:call-template name="RenderSpanLengthListBox">
								<xsl:with-param name="initial" select="$GLOBAL_VAR_MinDrivesForRAID50Span"/>
								<xsl:with-param name="terminal" select="$GLOBAL_VAR_MaxDrivesForRAID50Span"/>
								<xsl:with-param name="increment" select="1"/>
							</xsl:call-template>
						</Data>
						<Data value="" width="25%"/>
						<Data value="" width="25%"/>
					</Row>
				</TableData>
			</xsl:if>
			<xsl:if test="$PARAM_PREV_Layout=262144">
				<TableData>
					<Row>
						<Data value="{$strPromptNumOfDisksForSpan}"/>
						<Data name="Spans" type="select" event="onchange" handler="javascript:OnSpanLengthChangeHandler('262144')">
							<xsl:call-template name="RenderSpanLengthListBox">
								<xsl:with-param name="initial" select="$GLOBAL_VAR_MinDrivesForRAID60Span"/>
								<xsl:with-param name="terminal" select="$GLOBAL_VAR_MaxDrivesForRAID60Span"/>
								<xsl:with-param name="increment" select="1"/>
							</xsl:call-template>
						</Data>
						<Data value="" width="25%"/>
						<Data value="" width="25%"/>
					</Row>
				</TableData>
			</xsl:if>
			
			<xsl:if test="$PARAM_SPANEDITMODE != 'true'">
					<xsl:if test="$PARAM_PREV_Layout='512' or $PARAM_PREV_Layout='2048' or $PARAM_PREV_Layout='262144'">
						<TableData>
							<Row>
								<xsl:call-template name="DisplayIMandSelectAll"/>		
							</Row>
						</TableData>
					</xsl:if>
			</xsl:if>
                      
                        <xsl:if test="$GLOBAL_VAR_CreateSSC='1'">
						<TableData>
							
								<xsl:call-template name="DisplaySizeAndName"/>		
							
						</TableData>
			</xsl:if>
                           
			<SelectionDataUI>
				<SelectionTableUI id="SELECTION_TABLE" height="100%" width="95%" hspace="10">
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedAdiskSelectionWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;SpanEditMode=<xsl:value-of select="$PARAM_SPANEDITMODE"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;<xsl:value-of select="$CACHED_PARAMS"/>&amp;<xsl:value-of select="$STATE_PARAMS"/>&amp;Table=Selection&amp;CreateEnhancedCacheDisk=<xsl:value-of select="//CreateEnhancedCacheDisk"/>&amp;vid=<xsl:value-of select="$PARAM_REGULAR_OMSAVID"/></xsl:attribute>
				</SelectionTableUI>
				<ResultTableUI id="RESULT_TABLE" height="100%" width="90%">
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedAdiskSelectionWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;SpanEditMode=<xsl:value-of select="$PARAM_SPANEDITMODE"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;<xsl:value-of select="$CACHED_PARAMS"/>&amp;<xsl:value-of select="$STATE_PARAMS"/>&amp;Table=Result&amp;CreateEnhancedCacheDisk=<xsl:value-of select="//CreateEnhancedCacheDisk"/>&amp;vid=<xsl:value-of select="$PARAM_REGULAR_OMSAVID"/></xsl:attribute>
				</ResultTableUI>
			</SelectionDataUI>
                       
		</DataArea>	
                		
	</xsl:template>	

	<xsl:template name="DisplaySizeAndName">
               <Row>
                    <Data value="{$strNameCVDU}"/>
                    <Data name="VDName" type="editbox"  maxlength="15" returnvalue="0"/>
                   
               </Row>
               <Row>     
		<Data value="{$strSizeCVDU}"/>
			<Data name="VDSize" type="editbox" value="0" maxlength="7" returnvalue="0">
			   <xsl:attribute name="unit"><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute>
                        </Data>
			       
               </Row>                
	</xsl:template>
	<xsl:template name="DisplayIMandSelectAll">
           
		<Data type="checkbox">
			<xsl:attribute name="name">SelectAll</xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strSelectAll"/></xsl:attribute>
			<xsl:attribute name="returnvalue"/>
			<xsl:attribute name="event">onClick</xsl:attribute>
			<xsl:attribute name="handler">javascript:OnSelectAllSelected()</xsl:attribute>
			<!-- Note: there is a space between tags <xsl:text></xsl:text> in the above line and needs to remain that way for delete span to work. Need to come up with a better idea to fix this.-->
		</Data>
		
	</xsl:template>
     
	<!-- Renders the bottom custom buttons for the main frame-->
	<xsl:template name="RenderBottomCustomButtons">
                        <xsl:choose>
                             <xsl:when test="$GLOBAL_VAR_CreateSSC='1'">  
                                 <BottomCustomButton>
                                      <Data display="{$strFinish}" formSubmit="true" href="javascript:submitCreateVDAdvancedAdiskSelected()" id="submitbuttoncontent"/> 
                                 </BottomCustomButton>
                             </xsl:when>
                              <xsl:otherwise>  
                                 <BottomCustomButton>
                                      <Data display="{$strContinueCVDAAS}" formSubmit="true" href="javascript:submitCreateVDAdvancedAdiskSelected()" id="submitbuttoncontent"/> 
                                 </BottomCustomButton>
                              </xsl:otherwise>
                           </xsl:choose>
                    
                     
		<BottomCustomButton>
			<Data formSubmit="true">
				<xsl:attribute name="display"><xsl:value-of select="$strCancelCVDAAS"/></xsl:attribute>
				<xsl:attribute name="href">
					<xsl:choose>
						<xsl:when test="$PARAM_DSA_Rules ='1'">javascript:cacheIframesAndExitWizard();</xsl:when>
						<xsl:otherwise><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</BottomCustomButton>

		<xsl:if test="$PARAM_DSA_Rules !='1' and $PARAM_SPANEDITMODE != 'true'">
                 <xsl:if test="$GLOBAL_VAR_CreateSSC!='1'">  
			<BottomCustomButton>
				<Data display="{$strBackButtonDisplayCVDAAS}" formSubmit="true" href="javascript:backPage()"/>
			</BottomCustomButton>
                 </xsl:if>
                       
		</xsl:if>
		
	</xsl:template>
	
	<!-- Renders a list box to select number of disks in a RAID50 span-->
	<xsl:template name="RenderSpanLengthListBox">
		<xsl:param name="initial"/>
		<xsl:param name="terminal"/>
		<xsl:param name="increment"/>
		<xsl:if test="$initial &lt;= $terminal">
			<Choice value="{$initial}" returnvalue="{$initial}"/>
			<xsl:call-template name="RenderSpanLengthListBox">
				<xsl:with-param name="initial" select="$initial+$increment"/>
				<xsl:with-param name="terminal" select="$terminal"/>
				<xsl:with-param name="increment" select="$increment"/>
			</xsl:call-template>
		</xsl:if>
           
            

	</xsl:template>

	<!-- creates a table that maps ObjID of arraydisk to arraynum.Used for state change detection-->
	<xsl:template name="getAdiskArrayNum_HIDDEN_TABLE">
		<xsl:variable name="ArrayNumExists"><xsl:value-of select="ArrayNum"/></xsl:variable>
		<Data type="hidden">
			<xsl:choose>
				<!--Code to handle DSA display-->
				<xsl:when test="$PARAM_DSA_Rules='1' ">
					<xsl:attribute name="name">AN<xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="returnvalue">-1</xsl:attribute>		
				</xsl:when>
				<xsl:when test="not($ArrayNumExists)">
					<xsl:attribute name="name">AN<xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="returnvalue">-1</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="name">AN<xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="ArrayNum"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</Data>
	</xsl:template>
	<!-- creates a table that maps ObjID of arraydisk to Contiguous Free Space on disk. Used for state change detection-->
	<xsl:template name="getContiguousFreeSpace_HIDDEN_TABLE">
		<Data type="hidden">
			<xsl:choose>
				<!--Code to handle DSA display-->
				<xsl:when test="$PARAM_DSA_Rules='1' ">
					<xsl:attribute name="name">CFS<xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="Length"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="name">CFS<xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="ContiguousFree"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</Data>
	</xsl:template>

	<!--**************************************************************************Code for Selection Table/**************************************************************************************************************************-->
	<xsl:template name="SelectionData">
		<DataArea printable="false" validate="true" nosubmitfordsa="true" email="false" exportdata="false" onLoad="true" nographics="true">
			<script language="javascript">
				





                        var MaxTargetsArray = new Array();
				var SPAN_MODE="false";
				var SPAN_LENGTH=2;
                        var ThreeDArray = new Array();
				var FourDArray = new Array();
				var JS_GLOBAL_MaxNumChannels=2;
				var JS_GLOBAL_MaxNumEnclosures = parseInt("<xsl:value-of select="$GLOBAL_VAR_MAX_Enclosures"/>");
				
				var JS_GLOBAL_LayoutValue=<xsl:value-of select="$PARAM_PREV_Layout"/>;
                        var MIRROR_LENGTH_CURR =2;
				var SPAN_LENGTH_CURR=parseInt("<xsl:value-of select="$PARAM_CURR_SpanLength"/>");<!--If back button was used to get to this page-->;
				<!-- This is a variable that contains array disks that is yet to be added to a span-->
				var SPAN_IN_PROGRESS_ARRAY=new Array();
                        var MIRROR_IN_PROGRESS_ARRAY=new Array();
                        
				var JS_GLOBAL_MaxDrivesForSelectedLayout=parseInt("<xsl:value-of select="$GLOBAL_VAR_MaxDrivesForSelectedLayout"/>");
				var JS_GLOBAL_MinDrivesForSelectedLayout=parseInt("<xsl:value-of select="$GLOBAL_VAR_MinDrivesForSelectedLayout"/>");
				<!--This variable determines if a warning message has to be displayed to user if disks of different sizes are selected in a Span.
				By default the warning is always turned ON, however the warning has to be disabled for the following two scenarios.
				i) user selects a span, goes to previous page and then comes back to current page
				ii) user selects a span, goes to next page and then comes back to current page.
				The main frame will briefly turn OFF the warning flag in the above two scenarios for the period until the frame is loaded.
				Once the frame has been loaded the warning flag is turned ON. The setWarnFlagForDifferentSizeDisksInSpan() function is used by main frame to turn ON/OFF the warning.-->
				var JS_GLOBAL_WarnForDifferentSizeDisksInSpan = 1;
				var autoDeleteAllSpan = false;
				var createssc = '<xsl:value-of select="$GLOBAL_VAR_CreateSSC"/>';
				function initializationRoutine()
				{	  
                                MaxTargetsArray[0] = new Array();                                
                                MaxTargetsArray[0][0] =  new Array();
                                MaxTargetsArray[0][0] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure00"/>';
                                MaxTargetsArray[0][1] =  new Array();
                                MaxTargetsArray[0][1] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure01"/>';
							    MaxTargetsArray[0][2] =  new Array();
                                MaxTargetsArray[0][2] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure02"/>';
							    MaxTargetsArray[0][3] =  new Array();
                                MaxTargetsArray[0][3] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure03"/>';
                            								
                                MaxTargetsArray[1] = new Array();                                
                                MaxTargetsArray[1][0] =  new Array();
                                MaxTargetsArray[1][0] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure10"/>';
                                MaxTargetsArray[1][1] =  new Array();
                                MaxTargetsArray[1][1] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure11"/>';
							    MaxTargetsArray[1][2] =  new Array();
                                MaxTargetsArray[1][2] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure12"/>';
							    MaxTargetsArray[1][3] =  new Array();
                                MaxTargetsArray[1][3] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure13"/>';
	                                
                               
					<!--this function is called when the Selection table page is first loaded/-->
					
					<!-- Selection table does not find gnavObj since it is an embedded frame -->
					<xsl:if test="$PARAM_DSA_Rules='1'">
						gnavObj = parent.parent.parent.parent.gnv;
					</xsl:if>
					
					hideSelectionTable();
					
					<!--get the first channel that has enclosure attached to it-->
					if(createssc == '1')
					{ 
					        disableChannelSelectionRadioButtonsWithNoArrayDisksEC();
					        setDefaultChannelSelectionRadioButtonEC();
					}
                                        else
					{
					<!--Below disable the Channel radio buttons that do not contain ArrayDisks-->
					        disableChannelSelectionRadioButtonsWithNoArrayDisks();
					        <!--Below set the default channel selection radio button-->
					        setDefaultChannelSelectionRadioButton();
					}
					

                      
                     
					    <!--Disable Channel radio buttons that are non-raid scsi-->
					    disableNonRaidChannelSelectionRadioButtons();
                                        var channelNum = getDefaultChannelSelectionRadioButtonIndex();
	
					<!--show selection table with array disks attached to default channel identified-->
					if(channelNum!=-1)
                                              
						showSelectionTable(channelNum);
		                             
					<!-- Determine Span_Mode-->
					if(JS_GLOBAL_LayoutValue==512 ||  JS_GLOBAL_LayoutValue==2048 || JS_GLOBAL_LayoutValue==4096 || JS_GLOBAL_LayoutValue==262144)
					{
						SPAN_MODE="true";
					}

					<!-- set span lengths for each layout-->
					 if(JS_GLOBAL_LayoutValue==512)
					{
						<!--Raid-10 --> //Got to change this value
                                   
						SPAN_LENGTH_CURR =parent.frames.getSpanLengthValue();	
					}
					else if(JS_GLOBAL_LayoutValue==2048 )
					{
						<!--Raid-50-->
						SPAN_LENGTH_CURR = parent.frames.getSpanLengthValue();					
					}
					else if (JS_GLOBAL_LayoutValue==4096)
					{
						<!--Raid-1-concat-->
						SPAN_LENGTH_CURR = 2;
					}
					else if (JS_GLOBAL_LayoutValue==262144)
					{
						<!--Raid-1-concat-->
						SPAN_LENGTH_CURR = parent.frames.getSpanLengthValue();
					}
                                        
				}
				
				function setSpanLengthValue(len)
				{
					<!-- This function is called by parent IFrame to set the value of span length for RAID 50 when user input in edit box changes-->
					SPAN_LENGTH_CURR = len;
                             
				}
				
				function setWarnFlagForDifferentSizeDisksInSpan(flagValue)
				{
					<!-- This function is called by parent IFrame to turn on or Off the warning message that is displayed when disks of different sizes are chosen in a span.-->
					JS_GLOBAL_WarnForDifferentSizeDisksInSpan = flagValue;
				}
				
				function disableNonRaidChannelSelectionRadioButtons()
				{
					var RadioArray = document.getElementsByName("Channel");
					for(var i=0;i&lt;RadioArray.length;i++)
					{
						var elemName="ChannelNum"+i.toString();
						if(document.getElementById(elemName).value == 1)
						{
							RadioArray[i].disabled=true;
						}
					}
				}
				
				<!--This function returns the index of the default channel selected from the array of channels-->
				function getDefaultChannelSelectionRadioButtonIndex()
				{
					var RadioArray = document.getElementsByName("Channel");
					for(var i=0;i&lt;RadioArray.length;i++)
					{
						
							if(RadioArray[i].checked == true)
							{
								return i;
							}
						
					}
					return -1;<!--failure-->
				}
				<!--This function selects and sets the default channel-->
				function setDefaultChannelSelectionRadioButton()
				{var RadioArray = document.getElementsByName("Channel");

					for(var i=0;i&lt;RadioArray.length;i++)
					{
						var ArrayDisks = 0;
						for(var j=0;j&lt;JS_GLOBAL_MaxNumEnclosures;j++)
						{
							var elemNameEnclosure="parentrow_"+"Sel"+i.toString()+j.toString();
                                          
                                          
                                                for(var k=0;k&lt;MaxTargetsArray[i][j];k++)
							      { 
								  var elemName = "parentrow_"+"Sel"+i.toString()+j.toString()+k.toString();
								  if(document.getElementById(elemName) != null)
								  {  
									RadioArray[i].checked=true;
                                                      return;
								  }
							       }
                                             
                                           
                                            if(document.getElementById(elemNameEnclosure) != null)
					     {
					 		 	RadioArray[i].checked =true ;
                                                                return;
					    }
                                    }
                              }

				}
				<!--This function selects and sets the default channel-->
				function setDefaultChannelSelectionRadioButtonEC()
				{
				    var RadioArray = document.getElementsByName("Channel");

					for(var i=0;i&lt;RadioArray.length;i++)
					{
						var ArrayDisks = 0;
						for(var j=0;j&lt;JS_GLOBAL_MaxNumEnclosures;j++)
						{
							var elemNameEnclosure="parentrow_"+"Sel"+i.toString()+j.toString();
                             for(var k=0;k&lt;MaxTargetsArray[i][j];k++)
							 { 
								  var elemName = "parentrow_"+"Sel"+i.toString()+j.toString()+k.toString();
								  if(document.getElementById(elemName) != null)
								  {  
									RadioArray[i].checked=true;
                                    return;
								  }
							  }
                                             
                                          
                        }
                    }

				}
				<!--This function disables the channel radio buttons that do not have any array disks attached-->
				function disableChannelSelectionRadioButtonsWithNoArrayDisks()
				{
					var RadioArray = document.getElementsByName("Channel");
					
					for(var i=0;i&lt;RadioArray.length;i++)
					{
						var ArrayDisks = 0;
						for(var j=0;j&lt;JS_GLOBAL_MaxNumEnclosures;j++)
						{
							var elemNameEnclosure="parentrow_"+"Sel"+i.toString()+j.toString();
                                           for(var k=0;k&lt;MaxTargetsArray[i][j];k++)
							      {
								  var elemName = "parentrow_"+"Sel"+i.toString()+j.toString()+k.toString();
								  if(document.getElementById(elemName) != null)
								  {
									ArrayDisks = 1;
								  }
							       }
                                             
                                         
                                         if(document.getElementById(elemNameEnclosure) != null)
							   {
							 	ArrayDisks = 1;
							   }
                                  
							
						}
						if (ArrayDisks == 0)
						{
							RadioArray[i].disabled=true;
						}
					}
				}
				<!--This function disables the channel radio buttons that do not have any array disks attached-->
				function disableChannelSelectionRadioButtonsWithNoArrayDisksEC()
				{
					var RadioArray = document.getElementsByName("Channel");
					
					for(var i=0;i&lt;RadioArray.length;i++)
					{
						var ArrayDisks = 0;
						for(var j=0;j&lt;JS_GLOBAL_MaxNumEnclosures;j++)
						{
							var elemNameEnclosure="parentrow_"+"Sel"+i.toString()+j.toString();
                            
                                  for(var k=0;k&lt;MaxTargetsArray[i][j];k++)
							      {
								      var elemName = "parentrow_"+"Sel"+i.toString()+j.toString()+k.toString();
								      if(document.getElementById(elemName) != null)
								      {
									      ArrayDisks = 1;
								      }
							       }
                                             
                                                           
							
						}
						if (ArrayDisks == 0)
						{
							RadioArray[i].disabled=true;
						}
					}
				}
				<!--This function hides all the rows in the selection table-->
				function hideSelectionTable()
				{
					var elemName="";
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						if(document.getElementById("parentrow_"+"Sel"+i.toString())!=null)
						{   
							document.getElementById("parentrow_"+"Sel"+i.toString()).style.display="none";
						}
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							elemName = "parentrow_"+"Sel"+i.toString()+k.toString();
							if(document.getElementById(elemName) != null)
							{
								document.getElementById(elemName).style.display="none";
							}
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								elemName = "parentrow_"+"Sel"+i.toString()+k.toString()+j.toString();
								if(document.getElementById(elemName) != null)
								{
									document.getElementById(elemName).style.display="none";
								}
							}
						}
					}
				}
				<!--This funtion displays all the rows associated with channel 'i'-->
				function showSelectionTable(i)
				{     var ele = "";   
					for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
					{        
						for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
						{
							elemName="parentrow_"+"Sel"+i.toString()+k.toString()+j.toString();
                                          ele = document.getElementById(elemName);
							if( ele!= null)
							{       
								document.getElementById("parentrow_"+"Sel"+i.toString()+k.toString()).style.display="";
								ele.style.display="";
							}
						}
					}
				}
				
				<!--This function is a handler that is called in response to a channel selection-->
				function OnChannelSelected()
				{
					hideSelectionTable();
                                       	var EnclosureArray = document.getElementsByName("EnclosureSelected");
                                        var currEnclosureSelected = -1;
					var RadioArray = document.getElementsByName("Channel");
					for(var i=0;i&lt;EnclosureArray.length;i++)
					{
						if(EnclosureArray[i].checked==true)
						{
							currEnclosureSelected = (EnclosureArray[i]).value;
							break;
						} 
					}
					if (currEnclosureSelected != -1)
					{
						for(var i=0;i&lt;EnclosureArray.length;i++)
						{
							EnclosureArray[i].checked=true;
						} 
					}

					for(var i=0;i&lt;RadioArray.length;i++)
					{
						if(RadioArray [i].checked)
						{
							showSelectionTable(i);
							break;
						}
					}
				}
				<!--This function disables all array disk selection check boxes-->
				function disableAllCheckBoxes()
				{
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								disableArrayDiskCheckBox(i.toString(),k.toString(), j.toString());
							}
						}
					}
				}
				<!--This function enables all array disk selection check boxes-->
				function enableAllCheckBoxes()
				{
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								enableArrayDiskCheckBox(i.toString(), k.toString(), j.toString());
							}
						}
					}
				}
				<!--This function selects all array disk selection check boxes-->
				function selectAllCheckBoxes()
				{
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								selectArrayDiskCheckBox(i.toString(), k.toString(), j.toString());
							}
						}
					}
				}
                        function DisableAllCheckBoxesonenclosurecall()
				{
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								if(document.getElementById("Sel"+i+":"+k+":"+j)!=null &amp;&amp; document.getElementById("Sel"+i+":"+k+":"+j).disabled==false)
                                               {
                                                 document.getElementById("Sel"+i+":"+k+":"+j).disabled=true;
                                                 document.getElementById("Sel"+i+":"+k+":"+j).checked=false;
                                               }       
							}
						}
					}
				}

                                function selectAllCheckBoxesForAnEnclosure(Channel,EnclosureID)
				{
					
					  for(var j=0;j&lt;MaxTargetsArray[Channel][EnclosureID];j++)
				          {
                                                 if(document.getElementById("Sel"+Channel.toString()+":"+EnclosureID.toString()+":"+j.toString())!=null &amp;&amp;document.getElementById("Sel"+Channel.toString()+":"+EnclosureID.toString()+":"+j.toString()).disabled==false)
                                                 selectArrayDiskCheckBox(Channel.toString(), EnclosureID.toString(), j.toString());
					  }
					
				}

				<!--This function unselects all array disk selection check boxes-->
				function unSelectAllCheckBoxes()
				{
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								unSelectArrayDiskCheckBox(i.toString(), k.toString(), j.toString());
							}
						}
					}
				}
                       function enableAllArrayDisksCheckBox()
				{
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								enableArrayDiskCheckBox(i.toString(), k.toString(), j.toString());
							}
						}
					}
				}

				<!--This function enables a single array disk selection check box-->
				function enableArrayDiskCheckBox(channel, enclosureId, targetId)
				{
					var elemName="Sel"+channel+":"+enclosureId+":"+targetId;
					if(document.getElementById(elemName) != null)
					{
						document.getElementById(elemName).disabled=false;
					}
				}
				<!--This function disables a single array disk selection check box-->
				function disableArrayDiskCheckBox(channel, enclosureId, targetId)
				{
					var elemName="Sel"+channel+":"+enclosureId+":"+targetId;
                              var ele =  document.getElementById(elemName);  
					if( ele!= null)
					{
						ele.disabled=true;
					}
				}
				<!-- This function selects a single array disk selection check box-->
				function selectArrayDiskCheckBox(channel, enclosureId, targetId)
				{
					var elemName="Sel"+channel+":"+enclosureId+":"+targetId;
                              var ele = document.getElementById(elemName); 
					if( ele!= null)
					{
						ele.checked=true;
					}
				}
				<!-- This function un selects a single array disk selection check box-->
				function unSelectArrayDiskCheckBox(channel, enclosureId, targetId)
				{
					var elemName="Sel"+channel+":"+enclosureId+":"+targetId;
                              var ele = document.getElementById(elemName); 
					if( ele!= null)
					{
						ele.checked=false;
					}
				}
				<!-- This function returns true if the given single array disk selection check box is checked, else returns false-->
				function isArrayDiskSelected(channel, enclosureId, targetId)
				{
					var elemName="Sel"+channel+":"+enclosureId+":"+targetId;
                              var ele = document.getElementById(elemName); 
					if( ele!= null)
					{
						return ele.checked;
					}
					return false;
				}

				function clearSpanSelectionTable()
				{
					<!-- DF32325 - Fix to clear result table for R10 w/ multiple protocol -->
                           if(('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true' &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true'))
                           {
				         var numSpans = FourDArray.length + SPAN_IN_PROGRESS_ARRAY.length;
                           }
                           else
                           {
                              var numSpans = ThreeDArray.length + SPAN_IN_PROGRESS_ARRAY.length;
                            }
				   for(var i=numSpans-1; i&gt;=0; i--)
				   {  
				   	parent.frames["RESULT_TABLE"].OnDeleteSpan("Span "+i);
				   }
		
				}
                                 function clearSpanSelectionTableforAnenclosure(Channel,EnclosureID)//function not used anywhere
				{
					
				   var numSpans = FourDArray.length + SPAN_IN_PROGRESS_ARRAY.length;
                                    var SpanNumber;
				   for(var i=FourDArray.length; i&gt;=0; i--)
				   {  
                                    if(FourDArray[i][0]== Channel &amp;&amp; FourDArray[i][1]==EnclosureID)
                                    SpanNumber=i - 1;
				    parent.frames["RESULT_TABLE"].OnDeleteSpan("Span "+SpanNumber);
				   }
                                   for(var i=SPAN_IN_PROGRESS_ARRAY.length; i&gt;=0; i--)
				   { 
                                    if(SPAN_IN_PROGRESS_ARRAY[i][0]==Channel &amp;&amp; SPAN_IN_PROGRESS_ARRAY[i][1]==EnclosureID)
                                    SpanNumber=i/CURR_SPAN_LENGTH;
                                    SpanNumber=SpanNumber+FourDArray.length - 1;
				            parent.frames["RESULT_TABLE"].OnDeleteSpan("Span "+SpanNumber);
				   }
				}								
	
			
			
				function enableCheckBoxesForGivenDiskGroup(DGIndex)
				{
					var elemName="";
					var chkBxName="";
					var index = DGIndex;
	
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								elemName="DG"+i.toString()+k.toString()+j.toString();
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();//SSDFIX
                                                                
								if(document.getElementById(elemName) != null &amp;&amp;  document.getElementById(chkBxName) != null &amp;&amp; document.getElementById(elemName).value==index )
								{
									document.getElementById(chkBxName).disabled=false;
								}
							}
						}
					}
				}
				<!--This function disables array disk selection check boxes that have the same ArrayNum property-->
				
				function disableUnselectedCheckBoxes()
				{
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								if( isArrayDiskSelected(i.toString(), k.toString(), j.toString()) == false )
								{
									disableArrayDiskCheckBox(i.toString(), k.toString(), j.toString());
								}
							}
						}
					}
				}
				<!--This function automagically CHECKS array disk selection check boxes that have the same ArrayNum property-->
				function autoSelectCheckBoxesForGivenDiskGroup(index)
				{
					var elemName="";
					var chkBxName="";
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								elemName="DG"+i.toString()+k.toString()+j.toString();
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();//SSDFIX
								if(document.getElementById(elemName) != null &amp;&amp; document.getElementById(elemName).value==index &amp;&amp; document.getElementById(chkBxName) != null)
								{
									document.getElementById(chkBxName).checked=true;
								}
							}
						}
					}
				}
				<!--This function automagically UNCHECKS array disk selection check boxes that have the same ArrayNum property-->
				function deSelectCheckBoxesForGivenDiskGroup(index)
				{
					var elemName="";
					var chkBxName="";
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								elemName="DG"+i.toString()+k.toString()+j.toString();
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();//SSDFIX
								if(document.getElementById(elemName) != null &amp;&amp; document.getElementById(elemName).value==index &amp;&amp; document.getElementById(chkBxName) != null)
								{
									document.getElementById(chkBxName).checked=false;
								}
							}
						}
					}
				}
				
                        function getEnabledArrayDisksforselectall()
				{
					var chkBxName="";
					var TwoDArray=new Array();
					var counter=0;
                             
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null &amp;&amp; document.getElementById(chkBxName).disabled ==false)
								{
									counter++;
								}
							}
						}
					}	
					return counter;
				}


				function selectAllCheckBoxesforSpannedRaidLevels()
				{     
					var elemName="";
					var chkBxName="";
					var counter = 1;
                                        var countofdisks=0;
                                        countofdisks=getEnabledArrayDisksforselectall();
                                        var maxnumspan=parseInt("<xsl:value-of select="$GLOBAL_VAR_MaxSpansForSelectedLayout"/>");
                                        
                                       var checkfordisk=0;
                                       if(countofdisks &gt; maxnumspan*SPAN_LENGTH_CURR)
                                       {
                                              checkfordisk=maxnumspan*SPAN_LENGTH_CURR;
                                       }
                                       else
                                       {
                                              checkfordisk= (Math.floor(countofdisks/SPAN_LENGTH_CURR))*SPAN_LENGTH_CURR;
                                       } 
                                       if('<xsl:value-of select="$PARAM_CURR_IM"/>'=='true' ||   ( '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'=='9' &amp;&amp; '<xsl:value-of select="$PARAM_PREV_Layout"/>' == '512'))
                                       {
                                              checkfordisk=SPAN_LENGTH_CURR;
                                       }
                             	       selectAllCheckBoxes();
	 
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
					   for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
					   {
						for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
						{
					   	  elemName="Proto"+i.toString()+k.toString()+j.toString();
						  chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();//SSDFIX
                                                  
                                                 
                                                 
                                                         if(document.getElementById(chkBxName) != null &amp;&amp; document.getElementById(elemName) != null)
                                                         {      
                                                             if(counter &lt;(checkfordisk+1) )
                                                             {  
                                                                      if(('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true'  &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true'))
                                                                      {
                                                                               if(!(parent.frames.document.getElementById("SingleSpans")!=null &amp;&amp; parent.frames.document.getElementById("SingleSpans").disabled== false &amp;&amp; FourDArray.length == 1))  
                                                                               {     
                                                                                     R10_OnArrayDiskSelectedSpanMode(i,k,j,counter);
                                                                               }
                                                                               else
                                                                               {    
                                                                                     document.getElementById(chkBxName).disabled=true;
                                                                                     document.getElementById(chkBxName).checked=false;
                                                                                }
                                                                       }
                                                                       else
                                                                       {               
                                                                                       OnArrayDiskSelectedSpanMode(i,k,j,counter);
                                                                       }
							               counter = counter+1 ; 
                                                             
                                                       }
                                                       else
                                                       {  
                                                               document.getElementById(chkBxName).disabled=true;
                                                               document.getElementById(chkBxName).checked=false;
                                                       }  
                                                     }
                                                   }     
						
					     }
					 }
				  }

				<!--This function is a handler that is called on selecting an Enclosure checkbox-->
				function OnEnclosureSelected(Channel,EnclosureID)
				{   
                                   var chkBxName="";
                                 
                                   if(parent.document.getElementById("SelectAll")!=null)
                                     {
                                              parent.document.getElementById("SelectAll").disabled=true;
                                              parent.document.getElementById("SelectAll").checked=false;
                                     }
                                  
                                     chkBxName="Sel"+Channel+":"+EnclosureID;
                                     var TempchkBxName="";
                                                                      
                                     if((parent.document.getElementById("Spans")!=null &amp;&amp; parent.document.getElementById("Spans").disabled==false)||(parent.document.getElementById("SingleSpans")!=null &amp;&amp; parent.document.getElementById("SingleSpans").disabled==false))
                                     {
                                              parent.frames["SELECTION_TABLE"].setSpanLengthValue( parent.frames.getSpanLengthValue());
                                     }
                                     else
                                     {
                                              parent.frames["SELECTION_TABLE"].setSpanLengthValue(2);
                                     }  
                                     if('<xsl:value-of select="$PARAM_CURR_IM"/>'=='true' ||  ( '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'=='9' &amp;&amp; '<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512'))
                                     {
                                          parent.frames["SELECTION_TABLE"].setSpanLengthValue(parseInt('<xsl:value-of select="$GLOBAL_VAR_ArrayDiskCount"/>') + 1);
                                     } 
                                     var EnclosureArray = document.getElementsByName(chkBxName);
                                     var currEnclosureSelected = -1;
				             for(var i=0;i&lt;EnclosureArray.length;i++)
				             {
					            if(EnclosureArray[i].checked==true)
					            {
						            currEnclosureSelected = (EnclosureArray[i]).value;
						            break;
					            } 
				            }
                                    
				            if (currEnclosureSelected != -1)
				            {
                                             
  				                   selectAllCheckBoxesForGivenProtocolForAnEnclosure(Channel,currEnclosureSelected);
                                                   if(parent.frames["SELECTION_TABLE"].ThreeDArray.length!=0)
                                                   {
                                                          var tempSize=0;
                                                          for(var z=0; z &lt; parent.frames["SELECTION_TABLE"].ThreeDArray[0].length &amp;&amp; parent.frames["SELECTION_TABLE"].JS_GLOBAL_WarnForDifferentSizeDisksInSpan==1; z++)
					                            {
                                                                    for(var len=0;len &lt; parent.frames["SELECTION_TABLE"].ThreeDArray.length;len++)
                                                                    { 
					                                		 var elemName = "DISK"+parent.frames["SELECTION_TABLE"].ThreeDArray[len][z][0]+parent.frames["SELECTION_TABLE"].ThreeDArray[len][z][1]+parent.frames["SELECTION_TABLE"].ThreeDArray[len][z][2];
					                                		 var elemNameValue = parent.frames["SELECTION_TABLE"].document.getElementById(elemName).value;
					                                       if(tempSize !=0 &amp;&amp; elemNameValue != tempSize )
					                                       {     
					                                           alert("<xsl:value-of select="$strWarnUnequalSizeDisksInSpan"/>");
					                                           return;
					                                       }
					                                   else
					                                       {
					                                           tempSize=elemNameValue;
					                                       }
                                                                     }//end of first for loop
					                   }//end of seconf for loop
                                            }//end of nested if    
 
			       }
                         else
                         {     
                                  if( ThreeDArray.length==0 &amp;&amp; FourDArray.length==0 &amp;&amp; SPAN_IN_PROGRESS_ARRAY.length==0 &amp;&amp; MIRROR_IN_PROGRESS_ARRAY.length==0)
                                      {
                                        if(document.getElementById(chkBxName)!=null)
                                             { 
                                                    document.getElementById(chkBxName).disabled=false;                                            
                                             }
                                        if(parent.frames.document.getElementById("SelectAll")!=null)
                                             {  
                                                   parent.frames.document.getElementById("SelectAll").disabled=false;                                       
                                             }
                                       return;
                                      } 
                                       
                                     //clear span table     
                                      var l=0, SelectDisksArray = new Array(); 
									
                                      if(('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true' &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true'))
                                      {       //Raid -10 enclosure Select
                                              parent.frames["RESULT_TABLE"].ActiveSpanTable(); //clear the mirrored span table
                                              
                                              //remove all disks of selected disks from FourDArray
                                              for(i=0;i&lt;FourDArray.length; i++)
                                              {
                                                   	for(j=0;j&lt; FourDArray[i].length;j++)
                                                    	{
                                                        	 for(k=0;k&lt;FourDArray[i][j].length;k++)
                                                        	 {  
                                                               		if(FourDArray[i][j][k][0]==Channel &amp;&amp; FourDArray[i][j][k][1]==EnclosureID)
                                                               		 { 
                                                                   	         continue; 
                                                                		 }
                                                                		 else
                                                                		 { 
                                                                   		  SelectDisksArray[l] = new Array();
                                                                                SelectDisksArray[l] = FourDArray[i][j][k]; 
                                                                                l=l+1;
                                                                         }  
                                                             }//end k
                                                     }//end j
                                              }//end i
                                              //remove all disks of selected disks from SPAN_IN_PROGRESS_ARRAY
                                              for(i=0;i&lt;SPAN_IN_PROGRESS_ARRAY.length; i++)
                                              {
                                                   	for(j=0;j&lt; SPAN_IN_PROGRESS_ARRAY[i].length;j++)
                                                    	{                                                        	
                                                               		if(SPAN_IN_PROGRESS_ARRAY[i][j][0]==Channel &amp;&amp; SPAN_IN_PROGRESS_ARRAY[i][j][1]==EnclosureID)
                                                               		 { 
                                                                   	         continue; 
                                                                		 }
                                                                		 else
                                                                		 { 
                                                                   		  SelectDisksArray[l] = new Array();
                                                                                SelectDisksArray[l] = SPAN_IN_PROGRESS_ARRAY[i][j]; 
                                                                                l=l+1;
                                                                         }  
                                                      }//end j
                                              }//end i
                                               //remove all disks of selected disks from MIRROR_IN_PROGRESS_ARRAY
                                              for(i=0;i&lt;MIRROR_IN_PROGRESS_ARRAY.length; i++)
                                              {                                                        	
                                                      		if(MIRROR_IN_PROGRESS_ARRAY[i][0]==Channel &amp;&amp; MIRROR_IN_PROGRESS_ARRAY[i][1]==EnclosureID)
                                                          		 { 
                                                                	         continue; 
                                                         		 }
                                                       		 else
                                                           		 { 
                                                                		  SelectDisksArray[l] = new Array();
                                                                          SelectDisksArray[l] = MIRROR_IN_PROGRESS_ARRAY[i]; 
                                                                          l=l+1;
                                                                   }  
                                               }//end i
                                              MIRROR_IN_PROGRESS_ARRAY = new Array();
                                              SPAN_IN_PROGRESS_ARRAY = new Array();
                                              FourDArray = new Array();
                                              

	                			  }//end of if   raid 10
                                      else
                                      { // raid-50,60, IM 

                                                  parent.frames["RESULT_TABLE"].hideSpanTable();
                                                  for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					                    {
						                     for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						                      {
							                   for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							                   {
								                parent.frames["SELECTION_TABLE"].enableArrayDiskCheckBox(i.toString(), k.toString(), j.toString());
                                                                parent.frames["SELECTION_TABLE"].unSelectArrayDiskCheckBox(i.toString(), k.toString(), j.toString());
                                                

										}
									}
								}
 
                                                //remove all disks of selected disks from ThreeDArray
                                                for(i=0;i &lt; ThreeDArray.length;i++)
                                                { 
                                                       for(j=0;j &lt;ThreeDArray[i].length;j++)
                                                       {   
                                                             if(ThreeDArray[i][j][0]==Channel &amp;&amp; ThreeDArray[i][j][1]==EnclosureID)
                                                             { 
                                                                continue; 
                                                             }
                                                             else
                                                             { 
                                                                SelectDisksArray[l]=ThreeDArray[i][j];
                                                                l++; 
                                                             }
                                                       }//end of j
                                                }// end of i
                                                //  //remove all disks of selected disks from SPAN_IN_PROGRESS_ARRAY
                                                for(i=0;i&lt;SPAN_IN_PROGRESS_ARRAY.length; i++)
                                                {                                                        	
                                                      		if(SPAN_IN_PROGRESS_ARRAY[i][0]==Channel &amp;&amp; SPAN_IN_PROGRESS_ARRAY[i][1]==EnclosureID)
                                                          		 { 
                                                                	         continue; 
                                                         		 }
                                                       		 else
                                                           		 { 
                                                                		  SelectDisksArray[l] = new Array();
                                                                          SelectDisksArray[l] = SPAN_IN_PROGRESS_ARRAY[i]; 
                                                                          l=l+1;
                                                                   }  
                                                 }//end i
                                                 ThreeDArray = new Array();
                                                 SPAN_IN_PROGRESS_ARRAY = new Array(); 
                                                
                                      } // end of raid 50,60, im
                                      
                                       for(i=0;i&lt; SelectDisksArray.length;i++)
                                       {    
                                            selectArrayDiskCheckBox(SelectDisksArray[i][0],SelectDisksArray[i][1],SelectDisksArray[i][2]);
                                            OnArrayDiskSelected(SelectDisksArray[i][0],SelectDisksArray[i][1],SelectDisksArray[i][2]);
                                      }
                                     if(FourDArray.length==0 &amp;&amp; SPAN_IN_PROGRESS_ARRAY.length ==0 &amp;&amp;  MIRROR_IN_PROGRESS_ARRAY.length==0)
				              {
				                    var enclchBxName="Sel"+Channel+":"+EnclosureID;
				                    if(parent.document.getElementById("SelectAll")!=null)
				                    {
				                         parent.document.getElementById("SelectAll").disabled=false;
				                         parent.document.getElementById("SelectAll").checked=false;
				                    }
				                    if(parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName)!=null)
				                    {
				                        parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).disabled=false;
				                    } 
				               }
                                        parent.frames["SELECTION_TABLE"].EnableDisableEnclosures();      


                              }//end of super else
                       }//end of function 
                   	function getEnabledAndSelectedArrayDisksforAnEnclosure(EnclosureID)
				{
				var chkBxName="";
				var TwoDArray=new Array();
				var counter=0;

				for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								chkBxName="Sel"+i.toString()+":"+EnclosureID.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null &amp;&amp; document.getElementById(chkBxName).disabled ==false &amp;&amp; document.getElementById(chkBxName).checked==true )
								{
									counter++;
								}
							}
						
					}	
					return counter;
			}

			function selectAllCheckBoxesForGivenProtocolForAnEnclosure(Channel,EnclosureID)
			{    
					var elemName="";
					var chkBxName="";
					
                                        var counter = 1;
                                        var countofdisks=getEnabledArrayDisksforAnEnclosure(Channel,EnclosureID);
                                        counter=counter+countofdisks;
                                        var maxnumspan=parseInt("<xsl:value-of select="$GLOBAL_VAR_MaxSpansForSelectedLayout"/>");
 					
				        for(var j=0;j&lt;MaxTargetsArray[Channel][EnclosureID];j++)
					{     
							elemName="Proto"+Channel.toString()+EnclosureID.toString()+j.toString();
							chkBxName="Sel"+Channel.toString()+":"+EnclosureID.toString()+":"+j.toString();
                                                       
                                                       
							 if(document.getElementById(chkBxName) != null &amp;&amp; document.getElementById(chkBxName).disabled==false  )
                                                         {    
                                                                 if(((FourDArray.length &lt; maxnumspan) &amp;&amp; (( '<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true' &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9' ) || ( '<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true' ) ) ) || ( ThreeDArray.length &lt; maxnumspan  &amp;&amp; !(( '<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true' &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ( '<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true' ) ) ))
                                                                 {                 
                                                                            selectArrayDiskCheckBox(Channel.toString(), EnclosureID.toString(), j.toString());
                                                                            if(('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true'  &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true'))
                                                                            {
                                                                                   R10_OnArrayDiskSelectedSpanMode(Channel,EnclosureID,j,counter);
                                                                             }
                                                                             else
                                                                             {
                                                                                   OnArrayDiskSelectedSpanMode(Channel,EnclosureID,j,counter);
                                                                             }

                                                
   							                                counter = counter + 1;	
                                                                   }
                                                                  else
                                                                  {
                                                                           DisableAllCheckBoxesonenclosurecall();
                                                                           DisableAllEnclosures();
                                                                           return;
                                                                  }
                                                       } 
						}
					
				}
                         function DisableAllEnclosures()
                         {
                                     for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							
								chkBxName="Sel"+i.toString()+":"+k.toString();
								if(document.getElementById(chkBxName) != null &amp;&amp; document.getElementById(chkBxName).checked==false)
								{   
								   document.getElementById(chkBxName).disabled=true; 	
								}
							
						}
					}	
					
                        }
                        
				<!--This function returns the count of selected array disks-->
                                function GetSelectedArrayDisksCount()
				{
					var count=0;
					var chkBxName="";
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null &amp;&amp; document.getElementById(chkBxName).checked==true)
								{
									count=count+1;
								}
							}
						}
					}	
					return count;		
				}
				function CheckIfFirstArrayDiskSelected()
				{
					var chkBxName="";
					var strArrayDiskSelectionError = "<xsl:value-of select="$strDisksSelErrorCVDAAS"/>";
					var strError = "<xsl:value-of select="$strError"/>";
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null )
								{
									if(document.getElementById(chkBxName).checked==false)
									{
										alert(strError + strArrayDiskSelectionError);
										return false;
									}
									else
										return true;
								}
							}
						}
					}
				}
                                
                                function UpdateCreateSSCSizeField(channel,enclosure,target)
                                { 
                                
                                  var elemName ="";  
                                  var chkBxName ="";                                
				          var SelectedDisks=GetSelectedArrayDisksCount(); 
                                  var DisksArray = new Array();
                                  var count=0;   
                                  for(i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
                                  {
                                       for(j=0;j&lt;JS_GLOBAL_MaxNumEnclosures;j++)
                                       {
                                             for(k=0;k&lt;MaxTargetsArray[i][j];k++)
                                             {  

                                                chkBxName = "Sel"+i+":"+j+":"+k;
                                                    if(document.getElementById(chkBxName)!=null &amp;&amp; document.getElementById(chkBxName).checked==true)
                                                    { var elemName = "DISK"+i+j+k;
                                                      tempsize = parent.frames["SELECTION_TABLE"].document.getElementById(elemName).value; 
                                                      tempsize =  tempsize/ (1024*1024*1024);
                                                      DisksArray[count++] = tempsize;   
                                                     } 
                                               }//first for
                                       }//second for loop
                                  }//third for loop
                                  //sort the size array  
                                  
                                  var lowestsize = DisksArray.sort()[0];  
                                  if(count == 0)
                                  {  lowestsize =0;}                                 
                                  parent.document.getElementById("VDSize").value=parseFloat(lowestsize*count);
                                }
				function OnArrayDiskSelectedNormalMode(channel,enclosure,target)
				{       <xsl:if test="$GLOBAL_VAR_CreateSSC='1'">
                                           UpdateCreateSSCSizeField(channel,enclosure,target);
                                        </xsl:if>
					var DGIndex=document.getElementById("DG"+channel+enclosure+target).value;
                              
					
					var chkBxName = "Sel"+channel+":"+enclosure+":"+target;

					if(document.getElementById(chkBxName).checked==true)
					{
						if(DGIndex != -1)
						{
							disableAllCheckBoxes();
							enableCheckBoxesForGivenDiskGroup(DGIndex);
							autoSelectCheckBoxesForGivenDiskGroup(DGIndex);
                                                        disableUnselectedCheckBoxes();

						}
						else<!--free disks-->
						{
							disableAllCheckBoxes();
                                            
							
							
								enableCheckBoxesForGivenDiskGroup(DGIndex);
							
							<!--Next check to see if maximum disks allowed limit for the given layout has reached; if so disable all unselected array disk checkboxes-->
							if( parseInt(GetSelectedArrayDisksCount()) == parseInt(JS_GLOBAL_MaxDrivesForSelectedLayout) )
							{
								disableUnselectedCheckBoxes();
							}
						}
					}
					else
					{
						if(DGIndex !=-1)
						{							
								enableAllCheckBoxes();					
														
							deSelectCheckBoxesForGivenDiskGroup(DGIndex);								

						}
						else<!--free disks-->
						{
							<!--Always ensure that all arraydisks for given diskgroup or given protocol type is enabled -->
							
								enableCheckBoxesForGivenDiskGroup(DGIndex);								
								if(GetSelectedArrayDisksCount()==0)
								{
									<!--Make sure that when no array disk is selected by user, all array disks irrespective of 	their ArrayNum property value are enabled. -->
									enableAllCheckBoxes();
								}
							
						}
					}
					parent.frames["RESULT_TABLE"].hideResultTable();
					parent.frames["RESULT_TABLE"].showResultTable();
				}
                                                                  

				<!--This function is an handler that is called whenever an array disk is selected in the selection table-->
				function OnArrayDiskSelected(channel, enclosure, target)
				{	
                                    var enclchBxName="Sel"+channel+":"+enclosure;
                                    var DGIndex=document.getElementById("DG"+channel+enclosure+target).value;
                                   if(SPAN_MODE=="false")
					{
						OnArrayDiskSelectedNormalMode(channel,enclosure,target)
					}
					else if(SPAN_MODE=="true")
					{  
                             		if(parent.document.getElementById("SelectAll")!=null)
                                        {
                                        	parent.document.getElementById("SelectAll").disabled=true;
                                              parent.document.getElementById("SelectAll").checked=false;
                                        }  
                                        if(document.getElementById(enclchBxName)!=null)
                                        {
                                        	parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).disabled=true;
                                              parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).checked=false;
                                        }
                                     

						
                                         var chkBxName="Sel"+channel.toString()+":"+enclosure.toString()+":"+target.toString();
                                    
					if(DGIndex != -1 &amp;&amp; document.getElementById(chkBxName).checked == true)
					{
                                            var arrayNums = "<xsl:value-of select="$GLOBAL_VAR_ArrayNumDisks"/>";
                                            var arrayNumArray = arrayNums.split(";");
                                            var OBJIDIndex=document.getElementById("OBJID"+channel+enclosure+target).value;
                                            var objregexp = new RegExp(OBJIDIndex);
					    autoDeleteAllSpan = true;

                                          var elemName="OBJID"+channel.toString()+enclosure.toString()+target.toString();
                                          var arrayNumArray = new Array();
                                          arrayNumArray = arrayNums.split(";");
                                          for(i =0;i&lt;arrayNumArray.length;i++)
                                          {
                                              var ObjIDArray = arrayNumArray[i].split(":");
							    var resp = objregexp.exec(arrayNumArray[i]);
                                              if(resp != null)
                                              {
                                                      exitfromloop = 1;
                                                       break;
                                              }
                                          }
                                          //ObjIDArray contains the disks to be selected
                                       	//Below is required to select all the disks in a array even if user selects randomly any disk
							document.getElementById("Sel"+channel.toString()+":"+enclosure.toString()+":"+target.toString()).checked=false;
                                          var PartialIDArray = new Array();
						 	for(var z=0;z&lt;ObjIDArray.length;z++)
						 	{
								var elemName="";
								var chkBxName="";
								for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
								{
							 	      for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
									{
										for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
										{
											elemName="OBJID"+i.toString()+k.toString()+j.toString();
											chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();//SSDFIX
											if(document.getElementById(elemName) != null &amp;&amp; document.getElementById(elemName).value==ObjIDArray[z] &amp;&amp; document.getElementById(chkBxName) != null)
											{     PartialIDArray[z] = document.getElementById(chkBxName);
												document.getElementById(chkBxName).checked=true;
                                                                        document.getElementById(chkBxName).disabled=false;

                                    						if(('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true'  &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true'))
                                    						{
                                    									R10_OnArrayDiskSelectedSpanMode(i,k,j);
                                    						}
                                    						else
                                    						{
                                    									OnArrayDiskSelectedSpanMode(i,k,j);
                                    						} 
											}
										}
									}
								}

 							}	
								
							//Now disable other disks
						 	DisableUnCheckedArrayDisks();
						} 
						else
						{
                                    	var arrayNums = "<xsl:value-of select="$GLOBAL_VAR_ArrayNumDisks"/>";
      						var arrayNumArray = arrayNums.split(";");

						 	for(var y=0;y&lt;arrayNumArray.length;y++)
						 	{
      							var ObjIDArray = arrayNumArray[y].split(":");
								var elemName = "";
						 		for(var z=0; z&lt;ObjIDArray.length; z++)
						 		{
									elemName = "OBJID"+ObjIDArray[z];
									var chkBxName = "";
									if(document.getElementById(elemName) != null)
									{
										chkBxName = "Sel"+document.getElementById(elemName).value;
										if (document.getElementById(chkBxName) != null)
										{
											document.getElementById(chkBxName).checked=false;
											document.getElementById(chkBxName).disabled=true;
										}
									}

 								}	
						 	}

                                    	if(('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true' &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true'))
                                    	{
                                    		R10_OnArrayDiskSelectedSpanMode(channel,enclosure,target);
                                    	}
                                    	else
                                    	{
                                    		OnArrayDiskSelectedSpanMode(channel,enclosure,target);
                                    	} 

						}
                                         
                                    if(DGIndex!=-1)
                                    {
                                          for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
   	   			                  {
 							      for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
							       { 
                                                      enclchBxName="Sel"+i.toString()+":"+k.toString();
						                  if(parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName)!= null)
						    			  {
								           parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).disabled=true;
                                                           parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).checked=false;
                                                        }
						              }
					             }	

                                     }
                                     else
                                     {
                                        parent.frames["SELECTION_TABLE"].EnableDisableEnclosures();
                                     }     

					}

				}
                        
                        function getSelectedAndEnabledArrayDisksforselectall(spanlength)
				{
					var chkBxName="";
					var TwoDArray=new Array();
					var counter=0;
                             
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{     
                                				chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null &amp;&amp; document.getElementById(chkBxName).checked==true &amp;&amp; document.getElementById(chkBxName).disabled ==false)
								{
									var OneDArray = new Array();
									OneDArray[0]=i;
									OneDArray[1]=k;
									OneDArray[2]=j;
									TwoDArray[counter++]=OneDArray;
                                                                        disableArrayDiskCheckBox(i.toString(),k.toString(), j.toString());
                                                                     if(counter==spanlength)
                                                                     {   
                                                                           return TwoDArray; 
                                                                     }
								}
							}
						}
					}
					return TwoDArray;
				}
                         
                         function getSelectedAndEnabledArrayDisksforEnclosureSelect(Channel,Enclosure,spanlength) 
                         {                                 
                                  if(SPAN_IN_PROGRESS_ARRAY.length == spanlength)
                                     { 
                                        for(i=0;i&lt;spanlength;i++)
                                         { 
                                             disableArrayDiskCheckBox(SPAN_IN_PROGRESS_ARRAY[i][0].toString(),SPAN_IN_PROGRESS_ARRAY[i][1].toString(), SPAN_IN_PROGRESS_ARRAY[i][2].toString());
                                         }
                                       return SPAN_IN_PROGRESS_ARRAY;
                                     }                               
                         }


                       function OnAddMirror(channel,enclosure)
                       {
                             
                              var len = SPAN_IN_PROGRESS_ARRAY.length;
					var maxMirrorsAllowedForSelectedLayout = 16;
					

                              if(len == 0 )
				      { 
				            var layoutValue = '<xsl:value-of select="$PARAM_PREV_Layout"/>';
						if(layoutValue == 512 &amp;&amp; getSelectedAndEnabledArrayDisks().length &lt; 2)
						{
							var strNumOfDisksInSpanRaid10 = "<xsl:value-of select="$strNumOfDisksInSpanErrorRaid10CVDAAS"/>";
							alert(strNumOfDisksInSpanRaid10);
							return;
						}
						
					}
                              else if(len != 0 &amp;&amp; getSelectedAndEnabledArrayDisks().length &lt; SPAN_IN_PROGRESS_ARRAY[0].length)
					{    
						var strPartOne = "<xsl:value-of select="$strSelTotalOfCVDAAS"/>";
						var strPartTwo = "<xsl:value-of select="$strDisksToAddToSpanCVDAAS"/>";
						var alertStrMsg = strPartOne +" "+SPAN_IN_PROGRESS_ARRAY[0].length+" "+strPartTwo;
						alert(alertStrMsg);
						return;
					}
                              
                             SPAN_IN_PROGRESS_ARRAY[len] = new Array();
                             var enclchBxName="Sel"+channel+":"+enclosure; 
                             if((parent.frames.document.getElementById("SelectAll")!= null &amp;&amp; parent.frames.document.getElementById("SelectAll").checked==true) || (document.getElementById(enclchBxName)!=null &amp;&amp; document.getElementById(enclchBxName).checked==true))
                             { 
                                              SPAN_IN_PROGRESS_ARRAY[len]= getSelectedAndEnabledArrayDisksforselectall(MIRROR_LENGTH_CURR);
                             }
                             else
                             {  
                                          SPAN_IN_PROGRESS_ARRAY[len] = MIRROR_IN_PROGRESS_ARRAY;
                                          //DisableCheckedArrayDisks();
                                          for(var j=0;j&lt;MIRROR_IN_PROGRESS_ARRAY.length;j++)
							{
								chkBxName="Sel"+MIRROR_IN_PROGRESS_ARRAY[j][0].toString()+":"+MIRROR_IN_PROGRESS_ARRAY[j][1].toString()+":"+MIRROR_IN_PROGRESS_ARRAY[j][2].toString();
								document.getElementById(chkBxName).disabled = true;	
													
							}
                             }
                                  
                             
						EnableUnCheckedArrayDisks();
					
					
				
					
					<!--Next do the following two checks -->
					<!-- Check One: Check to see if the number of spans added has reached the allowed span limit; if so disable all unchecked array disks-->
					<!-- Check Two: Check to see if the number of disks allowed for the layout is not exeeded. 
					e.g; RAID 50 might allow a max of 8 spans to be selected not exceeding a total of 32 array disks across all spans.
					If a user selects 16 disks in a span, user should be restricted to creating 2 spans only with a total of 32 disks.-->
					
				 	if(8 == FourDArray.length )
					{
						DisableUnCheckedArrayDisks();
					}
					

					<!-- Now disable  array disk checkboxes in result table that belong to the recently added span -->
				
					for(var i=0; i &lt; MIRROR_IN_PROGRESS_ARRAY.length; i++)
 					{
			 				
					   parent.frames["RESULT_TABLE"].R10_DisableArrayDiskCheckBoxInGivenSpan(SPAN_IN_PROGRESS_ARRAY.length,FourDArray.length,MIRROR_IN_PROGRESS_ARRAY[i][0], MIRROR_IN_PROGRESS_ARRAY[i][1], MIRROR_IN_PROGRESS_ARRAY[i][2]);
					}
                              
				       var TotalMirrors = 2*SPAN_IN_PROGRESS_ARRAY.length;
                               
                              if( TotalMirrors == parent.frames.getSpanLengthValue())
                               {  
                                  R10_OnAddSpan();
                               
                                  SPAN_IN_PROGRESS_ARRAY = new Array();
					    
                               }
                                
                                MIRROR_IN_PROGRESS_ARRAY=new Array(); // Do a Reset
                               
					
                       } //end of Mirror Set



                       function OnAddSpan(channel,enclosure)
			     {	
                        	
					var len = ThreeDArray.length;
					var maxSpansAllowedForSelectedLayout = parseInt("<xsl:value-of select="$GLOBAL_VAR_MaxSpansForSelectedLayout"/>");
					
					<!--First check if this is the first span to be added-->
					if(len == 0 )
					{
						var layoutValue = '<xsl:value-of select="$PARAM_PREV_Layout"/>';
						if(layoutValue == 512 &amp;&amp; getSelectedAndEnabledArrayDisks().length &lt; 2)
						{
							var strNumOfDisksInSpanRaid10 = "<xsl:value-of select="$strNumOfDisksInSpanErrorRaid10CVDAAS"/>";
							alert(strNumOfDisksInSpanRaid10);
							return;
						}
						else if(layoutValue == 2048 &amp;&amp; getSelectedAndEnabledArrayDisks().length &lt; 3)
						{
							var strNumOfDisksInSpanRaid50 = "<xsl:value-of select="$strNumOfDisksInSpanErrorRaid50CVDAAS"/>";
							alert(strNumOfDisksInSpanRaid50);
							return;
						}
						else if(layoutValue==4096 &amp;&amp; getSelectedAndEnabledArrayDisks().length &lt; 2)
						{
							var strNumOfDisksInSpanRaid1C = "<xsl:value-of select="$strNumOfDisksInSpanErrorRaid1ConcatCVDAAS"/>";
							alert(strNumOfDisksInSpanRaid1C);
							return;				
						}
						else if(layoutValue==262144 &amp;&amp; getSelectedAndEnabledArrayDisks().length &lt; 4)
						{
							var strNumOfDisksInSpanRaid60 = "<xsl:value-of select="$strNumOfDisksInSpanErrorRaid60CVDAAS"/>";
							alert(strNumOfDisksInSpanRaid60);
							return;				
						}
					}
					else if(len != 0 &amp;&amp; getSelectedAndEnabledArrayDisks().length &lt; ThreeDArray[0].length)
					{     
						var strPartOne = "<xsl:value-of select="$strSelTotalOfCVDAAS"/>";
						var strPartTwo = "<xsl:value-of select="$strDisksToAddToSpanCVDAAS"/>";
						var alertStrMsg = strPartOne +" "+ThreeDArray[0].length+" "+strPartTwo;
						alert(alertStrMsg);
						return;
					}
				     
                             
                                    ThreeDArray[len] = new Array();
                                    var enclchBxName="Sel"+channel+":"+enclosure; 
                                    if(parent.frames.document.getElementById("SelectAll")!= null &amp;&amp; parent.frames.document.getElementById("SelectAll").checked==true)
                                    { 
                                              ThreeDArray[len]= getSelectedAndEnabledArrayDisksforselectall(SPAN_LENGTH_CURR);
                                    }
                                    else if(document.getElementById(enclchBxName)!=null &amp;&amp; document.getElementById(enclchBxName).checked==true)
                                    { 
                                              ThreeDArray[len]= getSelectedAndEnabledArrayDisksforEnclosureSelect(channel,enclosure,SPAN_LENGTH_CURR);
                                    }
                                   else
                                   {  
                                             ThreeDArray[len] = getSelectedAndEnabledArrayDisks();
                                             DisableCheckedArrayDisks();
                                   }
                              
                                  
						EnableUnCheckedArrayDisks();
					
					
					<!--The statement below checks if the number of unselected disks is atleast equal to span length-->
					if(ThreeDArray.length!=0 &amp;&amp; (getArrayDisksInSelectionTable().length - getDisabledAndUncheckedArrayDisksInSelectionTable().length - ThreeDArray.length*ThreeDArray[0].length &lt; ThreeDArray[0].length) )
					{
						DisableUnCheckedArrayDisks();
                                    
					}
					
					<!--Next do the following two checks -->
					<!-- Check One: Check to see if the number of spans added has reached the allowed span limit; if so disable all unchecked array disks-->
					<!-- Check Two: Check to see if the number of disks allowed for the layout is not exeeded. 
					e.g; RAID 50 might allow a max of 8 spans to be selected not exceeding a total of 32 array disks across all spans.
					If a user selects 16 disks in a span, user should be restricted to creating 2 spans only with a total of 32 disks.-->
					var maxSpansPossibleForUserChosenSpanLength = parseInt("<xsl:value-of select="$GLOBAL_VAR_MaxDrivesForSelectedLayout"/>")/ThreeDArray[0].length;
                              
                              
                              


					if(maxSpansAllowedForSelectedLayout == ThreeDArray.length || maxSpansPossibleForUserChosenSpanLength == ThreeDArray.length )
					{
						DisableUnCheckedArrayDisks();
                              }
					

					<!-- Now disable  array disk checkboxes in result table that belong to the recently added span -->
					for(var i=0; i &lt; ThreeDArray[len].length; i++)
					{
						parent.frames["RESULT_TABLE"].DisableArrayDiskCheckBoxInGivenSpan(len, ThreeDArray[len][i][0], ThreeDArray[len][i][1], ThreeDArray[len][i][2]);
					}
					
					<!-- If adisks in span are of different sizes, display a warning -->
					var tempSize = 0;
                                        if(!(parent.frames.document.getElementById("SelectAll")!= null &amp;&amp; parent.frames.document.getElementById("SelectAll").checked==true || document.getElementById(enclchBxName)!=null &amp;&amp; document.getElementById(enclchBxName).checked==true))
                                        { 
					   for(var z=0; z &lt; ThreeDArray[0].length &amp;&amp; JS_GLOBAL_WarnForDifferentSizeDisksInSpan==1; z++)
				  	   {
						var elemName = "DISK"+ThreeDArray[len][z][0]+ThreeDArray[len][z][1]+ThreeDArray[len][z][2];
						var elemNameValue = document.getElementById(elemName).value;
						if(tempSize !=0 &amp;&amp; elemNameValue != tempSize )
						{     
							alert("<xsl:value-of select="$strWarnUnequalSizeDisksInSpan"/>");
							break;
						}
						else
						{
							tempSize=elemNameValue;
						}
					   }
                                        }
					<!-- Do a Reset-->
					SPAN_IN_PROGRESS_ARRAY=new Array();
                               	} 
                       function R10_OnAddSpan()
			     {	
                        	
					      var len = FourDArray.length;
					      
                                    FourDArray[len] = new Array();
                                    FourDArray[len] =SPAN_IN_PROGRESS_ARRAY;
                                   
                              
                                  
						        EnableUnCheckedArrayDisks();
					  
					
					<!--The statement below checks if the number of unselected disks is atleast equal to span length-->
					if((FourDArray.length!=0 &amp;&amp; (getArrayDisksInSelectionTable().length - getDisabledAndUncheckedArrayDisksInSelectionTable().length - FourDArray.length*2*FourDArray[0].length &lt; 2*FourDArray[0].length)|| FourDArray.length == 8 )|| (parent.frames.document.getElementById("SingleSpans")!=null &amp;&amp; parent.frames.document.getElementById("SingleSpans").disabled== false &amp;&amp; FourDArray.length == 1))
					{ 
						DisableUnCheckedArrayDisks();
					}
					
					  SPAN_IN_PROGRESS_ARRAY=new Array();
                               
                        }
                        
                          function Non_R10_OnDeleteSpan(SpanName,noofdiskinspan)
				  {   
					var newThreeDArray = new Array();
					var len = ThreeDArray.length;
					var index = 0;
					
                              var enclchBxName;
					
					for(var i=0; i&lt; len; i++)
					{
						if( SpanName != "Span "+i.toString())
						{
							<!-- copy arraydisks from all spans into new array except for deleted span-->
							newThreeDArray[index] = new Array();
							newThreeDArray[index] = ThreeDArray[i];
							index++;
						}
                                                if( SpanName == "Span "+i.toString())
                                                 {
                                                        enclchBxName="Sel"+ThreeDArray[i][1][0].toString()+":"+ ThreeDArray[i][1][1].toString(); 
                                                 } 
					}
					<!-- Now update the ThreeDArray reflecting the entire span deleted.-->
					ThreeDArray = newThreeDArray;
					
					<!--Now redraw the result table  -->
					parent.frames["RESULT_TABLE"].hideSpanTable()
                              
                             
					for(i=0; i&lt; ThreeDArray.length; i++)
					{
						for(var j=0; j&lt; ThreeDArray[i].length; j++)
						{
							parent.frames["RESULT_TABLE"].showArrayDiskInSpanTable(i ,ThreeDArray[i][j][0],ThreeDArray[i][j][1],ThreeDArray[i][j][2]);
						}
					}
					<!-- Now disable  array disk checkboxes in Result table and Selection Table,that, belong to the spans that have already been added to ThreeDArray -->
					for(i=0; i&lt; ThreeDArray.length; i++)
					{
						for(var j=0; j&lt; ThreeDArray[i].length; j++)
						{
							parent.frames["RESULT_TABLE"].DisableArrayDiskCheckBoxInGivenSpan(i ,ThreeDArray[i][j][0],ThreeDArray[i][j][1],ThreeDArray[i][j][2]);
							disableArrayDiskCheckBox(ThreeDArray[i][j][0],ThreeDArray[i][j][1],ThreeDArray[i][j][2]);
						}
					}
					
					<!-- Next enable any unchecked array disks in Selection table-->
					
						EnableUnCheckedArrayDisks();
					
					
					
					<!--also show  any span selection in progress . This can be achieved by call OnArrayDiskSelected function for each Array disk -->
					var spanInProgArray = getSelectedAndEnabledArrayDisks();
					var count  = getSelectedAndEnabledArrayDisks().length;
					for(i=0; i&lt; count; i++)
					{
						OnArrayDiskSelected(spanInProgArray[i][0],spanInProgArray[i][1],spanInProgArray[i][2]);
						<!-- enable the Span row first
						parent.frames["RESULT_TABLE"].showArrayDiskInSpanTable(spanIndex ,-1,-1);
						parent.frames["RESULT_TABLE"].showArrayDiskInSpanTable(spanIndex ,spanInProgArray[i][0],spanInProgArray[i][1]);-->
					}

                              //First case
                              if(ThreeDArray.length &gt;0)
                              {    
					    if (parent.document.getElementById("SelectAll") != null) 
					    {
					          parent.document.getElementById("SelectAll").checked=false;
                                        parent.document.getElementById("SelectAll").disabled=true;
				 	    }

                                  if(enclchBxName &amp;&amp; parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName)!= null)
                                  {
                                       parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).checked=false;
                                       parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).disabled=true;
                                   }
                               }
  
                               //Second Case 
                               if(ThreeDArray.length==0 &amp;&amp; SPAN_IN_PROGRESS_ARRAY.length==0 )
                               { 
                                      
					   if (parent.document.getElementById("SelectAll") != null) 
					   {
                                 		parent.document.getElementById("SelectAll").disabled=false;
                                  		parent.document.getElementById("SelectAll").checked=false;
					   }
                                       	  
                                  for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
   	   			           {
					      for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
					       { 
                                                      enclchBxName="Sel"+i.toString()+":"+k.toString();
					              if(parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName)!= null)
						      {
								parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).disabled=false;
                                                                parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).checked=false;
                                                      }
						}
					    }	
                                          }//end of second case 
                                   
                                         var count2=0;
                                         for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					  {
 				               for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
					         { 
                                                        count2 = 0;
                                                        enclchBxName="Sel"+i.toString()+":"+k.toString();
                                                        if(document.getElementById(enclchBxName) != null)
                                                         {
                                                                  for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
					                            {
  					       	                           chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
                                                                           if(document.getElementById(chkBxName) != null)
                                                                            {
							                            if( document.getElementById(chkBxName).checked ==false )
							                              {
							                                  continue;
							                              }
                                                                                      else
                                                                                      {
                                                                                          count2++;
                                                                                      } 
                                                                            }
					                              }
                                                                if(count2==0)
                                                                { 
                                                                        parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).disabled=false;
                                                                        parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).checked=false;
                                                                }
                                                           }
                                                     } 
                                         }

    			    	    }
                        
                          function R10_OnDeleteSpan(SpanName,deletedSpanArray) // second invoke
				  {  
					var newFourDArray = new Array();
					var len = FourDArray.length;
					var index = 0;
					
                              var enclchBxName;
					var NumofMirrors = parent.frames.getSpanLengthValue();
                              NumofMirrors = NumofMirrors/2; 
                              var SpanNum=9; 
                          
					for(var i=0; i&lt; len; i++)
					{   
                                    if( SpanName != "Span "+i.toString())
						 {
                                             newFourDArray[index] = new Array();
                                             newFourDArray[index] = FourDArray[i];
                                             index++;
                                             SpanNum = i;
                                     } 
                                    
					}
                              if( SpanName == "Span "+SpanNum.toString())
                              {   
                                         enclchBxName="Sel"+FourDArray[i][0][0][0].toString()+":"+ FourDArray[i][0][0][0].toString(); 
                              }
   			            <!-- Now update the FourDArray reflecting the entire span deleted.-->
                             <!--Now redraw the result table  -->
					parent.frames["RESULT_TABLE"].ActiveSpanTable(); //clear the span table
                              FourDArray = new Array();
  				      FourDArray = newFourDArray;

                              
                              
                              
					for(i=0; i&lt; FourDArray.length; i++)
					{      
						 for(var j=0; j&lt; FourDArray[i].length; j++)
			     				{  
                                               for( k=0;k&lt;FourDArray[i][j].length ; k++)
                                               {
                                                     selectArrayDiskCheckBox(FourDArray[i][j][k][0],FourDArray[i][j][k][1],FourDArray[i][j][k][2]);
                                                     parent.frames["RESULT_TABLE"].R10_showArrayDiskInSpanTable(j, i ,FourDArray[i][j][k][0],FourDArray[i][j][k][1],FourDArray[i][j][k][2]);
                                                     parent.frames["RESULT_TABLE"].R10_DisableArrayDiskCheckBoxInGivenSpan(j, i ,FourDArray[i][j][k][0],FourDArray[i][j][k][1],FourDArray[i][j][k][2]);
				                             disableArrayDiskCheckBox(FourDArray[i][j][k][0],FourDArray[i][j][k][1],FourDArray[i][j][k][2]);
 
                                                     
                                                }        
 				                  }
				      } 
                             <!-- Now disable  array disk checkboxes in Result table and Selection Table,that, belong to the spans that have already been added to FourDArray -->
				   	
                             
                               var spanInProgArray = new Array();
                               k=0;
                               for(i=0;i&lt; SPAN_IN_PROGRESS_ARRAY.length ; i++)
                               { 
                                		 for(j=0;j&lt;SPAN_IN_PROGRESS_ARRAY[i].length;j++)
                                 		 {   
                                                spanInProgArray[k++] = SPAN_IN_PROGRESS_ARRAY[i][j];
                                           }
                               }
                               if(MIRROR_IN_PROGRESS_ARRAY.length !=0)
                               { 
                                           spanInProgArray[k] = MIRROR_IN_PROGRESS_ARRAY[0]; 
                                }
                            
                               SPAN_IN_PROGRESS_ARRAY = new Array();
                               MIRROR_IN_PROGRESS_ARRAY = new Array();
                               
                               
                               if(deletedSpanArray.length != spanInProgArray.length)
                               {        
                                               for(i=0; i&lt; spanInProgArray.length; i++)
					                 {   selectArrayDiskCheckBox(spanInProgArray[i][0],spanInProgArray[i][1],spanInProgArray[i][2]);
                                                   OnArrayDiskSelected(spanInProgArray[i][0],spanInProgArray[i][1],spanInProgArray[i][2]);
 				                       }
                               }   
                               
				      <!-- Next enable any unchecked array disks in Selection table-->
					
						EnableUnCheckedArrayDisks();
					
					
					
					<!--also show  any span selection in progress . This can be achieved by call OnArrayDiskSelected function for each Array disk -->
					
					
                             
                              //First case
                              if(FourDArray.length &gt;0)
                              {    
					    if (parent.document.getElementById("SelectAll") != null) 
					    {
					          parent.document.getElementById("SelectAll").checked=false;
                                        parent.document.getElementById("SelectAll").disabled=true;
				 	    }

                                  if(enclchBxName &amp;&amp; parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName)!= null)
                                   {
                                       parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).checked=false;
                                       parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).disabled=true;
                                   }
                               }
  
                               //Second Case 
                               if(FourDArray.length==0 &amp;&amp; SPAN_IN_PROGRESS_ARRAY.length==0 )
                               { 
					   if (parent.document.getElementById("SelectAll") != null) 
					   {
                                 		parent.document.getElementById("SelectAll").disabled=false;
                                  		parent.document.getElementById("SelectAll").checked=false;
					   }
                                       	  
                                 for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
   	   			         {
					          for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
					           { 
                                              enclchBxName="Sel"+i.toString()+":"+k.toString();
					                if(parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName)!= null)
						           {
								       parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).disabled=false;
                                                       parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).checked=false;
                                               }
						     }
					   }	
                              }//end of second case 
                             parent.frames["SELECTION_TABLE"].EnableDisableEnclosures();     
                                   
                              
    			    	    }
                                    
                        function EnableDisableEnclosures()
                        {     
                              var TotalDisks=0, SelectedDisks=0,EnableEnclosure=1;
                              var enclchBxName="";
                             
                              for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
 				              for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
					         {                EnableEnclosure=1; 

                                                        SelectedDisks = 0;
                                                        enclchBxName="Sel"+i.toString()+":"+k.toString();
                                                        if(document.getElementById(enclchBxName) != null)
                                                         { 
                                                               for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
					                                 { 
  					       	                           chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
                                                                     if(document.getElementById(chkBxName) != null)
                                                                     {       TotalDisks++;
                                                                             
 
							                                   if( document.getElementById(chkBxName).checked ==false &amp;&amp; document.getElementById("DG"+i.toString()+k.toString()+j.toString()).value == -1 )
  							                                   {
							                                        continue;
							                                    }
                                                                              if(document.getElementById(chkBxName).checked ==true)
                                                                              {
                                                                                  SelectedDisks++;
                                                                              } 
                                                                              
                                                                              if(document.getElementById("DG"+i.toString()+k.toString()+j.toString()).value!= -1)
                                                                              {
                                                                                   EnableEnclosure=0; 

                                                                              }
                                                                             
                                                                                    

                                                                      }
					                                 }
                                                              
                                                               if(SelectedDisks == 0 &amp;&amp; EnableEnclosure==1 )
                                                               { 
                                                                     document.getElementById(enclchBxName).disabled=false;
                                                                     document.getElementById(enclchBxName).checked=false;
                                                               }
                                                               else if(SelectedDisks == TotalDisks &amp;&amp;EnableEnclosure==1 )
                                                               {     
                                                                     document.getElementById(enclchBxName).disabled=false;
                                                                     document.getElementById(enclchBxName).checked=true;
                                                               }else if(SelectedDisks &lt; TotalDisks)
                                                               {
                                                                     document.getElementById(enclchBxName).disabled=true;
                                                                     document.getElementById(enclchBxName).checked=false;
                                                               }
                                                               if(EnableEnclosure==0)
                                                               {   
                                                                   document.getElementById(enclchBxName).disabled=true;
                                                                   document.getElementById(enclchBxName).checked=false;
                                                                   if(parent.frames.document.getElementById("SelectAll")!=null)
                                                                   {
                                                                     parent.frames.document.getElementById("SelectAll").disabled=true;
                                                                     parent.frames.document.getElementById("SelectAll").checked=false;
                                                                    }
   

                                                               } 
                                                        }
                                           }//for k 
                                }//for i
                        }
                        function getEnabledArrayDisksforAnEnclosure(Channel,enclosure)
				    {
					var chkBxName="";
					var TwoDArray=new Array();
					var counter=0;
                             
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null &amp;&amp; document.getElementById(chkBxName).disabled ==false &amp;&amp; document.getElementById(chkBxName).checked ==true )
								{
									counter++
								}
							}
						}
					}
                              for(var j=0;j&lt;MaxTargetsArray[Channel][enclosure];j++)
							{
								chkBxName="Sel"+Channel.toString()+":"+enclosure.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null &amp;&amp; document.getElementById(chkBxName).disabled ==false &amp;&amp; document.getElementById(chkBxName).checked ==true )

				{
				counter--;
				}
				}

				return counter;
				}

                        function OnArrayDiskSelectedSpanMode(channel,enclosure,target,counter)
				{   //  for raid-50 raid 60 and Intelligent Miroring(R-10)
							if ( ('<xsl:value-of select="$PARAM_CURR_IM"/>'=='true' ||   ( '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'=='9' &amp;&amp; '<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' )) &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>' != 'true')
							{	
								SPAN_LENGTH_CURR=parseInt('<xsl:value-of select="$GLOBAL_VAR_ArrayDiskCount"/>') + 1;

							}
                        //SPAN_LENGTH_CURR=parseInt('<xsl:value-of select="$GLOBAL_VAR_ArrayDiskCount"/>') + 1;
                               
                                   var count=0;
                                   var enclchBxName="";
				           var chkBxName = "Sel"+channel+":"+enclosure+":"+target;
				          
                       		   // is the case when last disk is selected in span table during deletion			
                                     if((getSelectedAndEnabledArrayDisks().length+getDisabledAndCheckedArrayDisksInSelectionTable().length)==0)
                                      { 
                                            enclchBxName="Sel"+channel+":"+enclosure;        
                                            if(parent.document.getElementById("SelectAll")!=null)
                                                {
                                                          parent.document.getElementById("SelectAll").disabled=false;
                                                          parent.document.getElementById("SelectAll").checked=false;
                                                }
                                           
                                             if(parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName)!=null)
                                                {
                                                             parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).disabled=false;
                                                 }
                                     }
                                 
                                     if(document.getElementById(chkBxName) != null &amp;&amp; document.getElementById(chkBxName).checked==true)
				             {	 
                                                 enclchBxName="Sel"+channel+":"+enclosure;       
						 var addToSpanFlag = 0;<!-- value of 1 indicates that OnAddSpan function be called.-->		
						 if(frames.document.getElementById(enclchBxName) != null &amp;&amp; frames.document.getElementById(enclchBxName).checked==true )
                                                 {       
                                                          count=(counter) %SPAN_LENGTH_CURR;
                                                          if(count==0)
                                                          { 
                                                                count=SPAN_LENGTH_CURR;
                                                          } 
                                                 } 
                                                else if(parent.frames.document.getElementById("SelectAll")!=null &amp;&amp;parent.frames.document.getElementById("SelectAll").checked==true )
                                                 {    

                                                          count=counter %SPAN_LENGTH_CURR;
                                                          if(count==0)
                                                          {
                                                                 count=SPAN_LENGTH_CURR;
                                                           } 
                                                 }
                                                 else
                                                 {   
                                                          count  =getSelectedAndEnabledArrayDisks().length;
                                                 }
                                                
						<!-- array disk is being added to a new span and hence its span number will be length of ThreeDArray -->
						var spanIndex = ThreeDArray.length;
                                     
						parent.frames["RESULT_TABLE"].showArrayDiskInSpanTable(spanIndex ,channel,enclosure,target);
						<!--The below statement makes sure the first span does not exceed half of the available disks-->
						if(count == SPAN_LENGTH_CURR || (counter != '' &amp;&amp; counter % SPAN_LENGTH_CURR)==0)
						{      
							DisableUnCheckedArrayDisks();
							addToSpanFlag = 1;
                                         
						}
						
                                    <!--The below statement makes sure that succeeding span lengths does not exceed the first span length-->
						else if(spanIndex  !=0 &amp;&amp; ThreeDArray[0].length == count)
						{     
							DisableUnCheckedArrayDisks();
                                         
							addToSpanFlag = 1;
						}
                                    
						<!-- add the selected array disk to SPAN_IN_PROGRESS_ARRAY- this array is used to hold array disks that are
						selected by user but "Add Span" button is not clicked yet.-->
						var len = SPAN_IN_PROGRESS_ARRAY.length;
						
                                    SPAN_IN_PROGRESS_ARRAY[len] = new Array();
                                    SPAN_IN_PROGRESS_ARRAY[len][0] = channel;
						SPAN_IN_PROGRESS_ARRAY[len][1] = enclosure
						SPAN_IN_PROGRESS_ARRAY[len][2] = target;
						
						if(addToSpanFlag== 1)
							OnAddSpan(channel,enclosure);
                                   
					}
					else
					{   
						<!-- Array disk deletion falls into following cases: a) single array disk deleted from last span by user action; 
														     b) array disk deleted as a part of entire span deletion that is not part of ThreeDArray yet
												   		     c) array disk deleted as a part of entire span deletion that is part of ThreeDArray-->
						<!-- calculate the span number from which the array disk is being removed from: This determines one of above cases-->
						var spanIndex = -1;
						var len = ThreeDArray.length;
						for(var i=0; i &lt; len; i++)
						{
							for(var j=0; j &lt; ThreeDArray[i].length; j++)
							{
								if(channel == ThreeDArray[i][j][0] &amp;&amp; enclosure==ThreeDArray[i][j][1] &amp;&amp; target==ThreeDArray[i][j][2])
								{
									spanIndex = i;
									break;
								}
							}
						}
						<!--check if spanIndex was found. If spanIndex was not found, array disk is being deleted from the last span -->
						if(spanIndex == -1)
						{ 
							<!-- falls into either case a or case b mentioned above-->
							
							spanIndex = ThreeDArray.length;
							
							<!-- hide the deleted array disk in Result table-->
							parent.frames["RESULT_TABLE"].hideArrayDiskInSpanTable(spanIndex ,channel,enclosure,target);
							
							<!-- Since an array disk is being deleted from a Span, the SpanLength has not reached its max, hence enable all unchecked disabled disks-->
							
								EnableUnCheckedArrayDisks();
							
							
							
							<!-- check to see if this is the last array disk deleted from the span; if so hide the Span Row and enable -->
							var count = getSelectedAndEnabledArrayDisks().length;
							if(count== 0)
							{
								parent.frames["RESULT_TABLE"].hideArrayDiskInSpanTable(spanIndex ,-1,-1,-1);
							}
							<!-- update SPAN_IN_PROGRESS_ARRAY with deleted adisk-->
							var tempArray = new Array();
							var counter=0;
							var len = SPAN_IN_PROGRESS_ARRAY.length;
							for(var k=0; k&lt;len; k++)
							{
								if( SPAN_IN_PROGRESS_ARRAY[k][0] == channel  &amp;&amp; SPAN_IN_PROGRESS_ARRAY[k][1] == enclosure &amp;&amp; SPAN_IN_PROGRESS_ARRAY[k][2] == target)
								{
									continue;
								}
								else
								{
									tempArray[counter] = new Array();
									tempArray[counter][0] = SPAN_IN_PROGRESS_ARRAY[k][0];
									tempArray[counter][1] = SPAN_IN_PROGRESS_ARRAY[k][1];
									tempArray[counter][2] = SPAN_IN_PROGRESS_ARRAY[k][2];
									counter++;
								}
							}
							SPAN_IN_PROGRESS_ARRAY = tempArray;
						}
						else
						{  

							<!-- falls into either case "c" mentioned above-->
							<!-- hide the deleted array disk in Result table-->
							parent.frames["RESULT_TABLE"].hideArrayDiskInSpanTable(spanIndex ,channel,enclosure,target);
							
							<!-- an entire span is being deleted. The array disks in the span were checked and disabled when added to the span.
								Now enable them. The disks were unchecked by the caller of this function-->
							
								EnableUnCheckedArrayDisks();
							
						}
						
						
						
						<!-- if current Span length has not exceed the max span length, enable all unchecked array disks-->
						if( (ThreeDArray.length == 0 || (ThreeDArray.length != 0 &amp;&amp; count &lt; ThreeDArray[0].length)))
						{
							EnableUnCheckedArrayDisks();
						}
					}
				}
				function R10_OnArrayDiskSelectedSpanMode(channel,enclosure,target,counter)
				{
                               
                                    if(MIRROR_IN_PROGRESS_ARRAY.length==0)
                                    {
                                        parent.frames["RESULT_TABLE"].hideMirrorDisks(FourDArray.length,SPAN_IN_PROGRESS_ARRAY.length);
                                    }

				 var count=0;
				 var enclchBxName="";
				 var chkBxName = "Sel"+channel+":"+enclosure+":"+target;
				 
                       
				 // is the case when last disk is selected in span table during deletion
                              if(document.getElementById(chkBxName) != null &amp;&amp; document.getElementById(chkBxName).checked==true)
			      {	
                                     enclchBxName="Sel"+channel+":"+enclosure;       
						 var addToMirrorFlag = 0;<!-- value of 1 indicates that OnAddSpan function be called.-->		
						 if((frames.document.getElementById(enclchBxName) != null &amp;&amp; frames.document.getElementById(enclchBxName).checked==true) || (parent.frames.document.getElementById("SelectAll")!=null &amp;&amp;parent.frames.document.getElementById("SelectAll").checked==true ) )
                                                 {       
                                                          count=(counter) %MIRROR_LENGTH_CURR;
                                                          if(count==0)
                                                          { 
                                                                count=MIRROR_LENGTH_CURR;
                                                          } 
                                                 } 
                                                 else
                                                 {   
                                                          count  =getSelectedAndEnabledArrayDisks().length;
                                                 }
                                                
						<!-- array disk is being added to a new span and hence its span number will be length of FourDArray -->
						var spanIndex = FourDArray.length;
                                    var MirrorIndex =  SPAN_IN_PROGRESS_ARRAY.length;   
                                     
						parent.frames["RESULT_TABLE"].R10_showArrayDiskInSpanTable(MirrorIndex,spanIndex ,channel,enclosure,target);
						<!--The below statement makes sure the first span does not exceed half of the available disks-->
						if(count == MIRROR_LENGTH_CURR || (counter != '' &amp;&amp; counter % MIRROR_LENGTH_CURR)==0)
						{    
							DisableUnCheckedArrayDisks();
							addToMirrorFlag = 1;
                                         
						}
						
                                    <!--The below statement makes sure that succeeding span lengths does not exceed the first span length-->
						else if(MirrorIndex !=0 &amp;&amp; MIRROR_LENGTH_CURR == count)
						{     
							DisableUnCheckedArrayDisks();
                                         
							addToMirrorFlag = 1;
						}
                                    
						<!-- add the selected array disk to SPAN_IN_PROGRESS_ARRAY- this array is used to hold array disks that are
						selected by user but "Add Span" button is not clicked yet.-->
						var len = MIRROR_IN_PROGRESS_ARRAY.length;
						
                                                MIRROR_IN_PROGRESS_ARRAY[len] = new Array();
                                                MIRROR_IN_PROGRESS_ARRAY[len][0] = channel;
						MIRROR_IN_PROGRESS_ARRAY[len][1] = enclosure
						MIRROR_IN_PROGRESS_ARRAY[len][2] = target;
						
						if(addToMirrorFlag == 1)
                                    { 
							OnAddMirror(channel,enclosure);
                                     }
                                   
					}
					else
					{  <!-- Array disk deletion falls into following cases:    a) single array disk deleted from last span by user action; 
														     b) array disk deleted as a part of entire span deletion that is not part of FourDArray yet
												   		     c) array disk deleted as a part of entire span deletion that is part of FourDArray-->
						<!-- calculate the span number from which the array disk is being removed from: This determines one of above cases-->
						var spanIndex = -1;
                                    
						
						<!--check if spanIndex was found. If spanIndex was not found, array disk is being deleted from the last span -->
                                     for(var i=0; i &lt; FourDArray.length; i++)
						{       
							for(var j=0; j &lt; FourDArray[i].length; j++)
							{
								for(k=0;k&lt;FourDArray[i][j].length;k++)
                                                {
                                                    
                                                     if(channel == FourDArray[i][j][k][0] &amp;&amp; enclosure==FourDArray[i][j][k][1] &amp;&amp; target==FourDArray[i][j][k][2])
	   						           {
									 spanIndex = i;
									 break;
								     }
                                                }
							}
						}
                                    
						if(spanIndex == -1)
						{  
							<!-- falls into either case a or case b mentioned above-->
							
							spanIndex = FourDArray.length;
							
							<!-- hide the deleted array disk in Result table-->
                                          for(i=0;i&lt;MIRROR_IN_PROGRESS_ARRAY.length; i++)
                                          {
                                             if(channel == MIRROR_IN_PROGRESS_ARRAY[i][0] &amp;&amp; enclosure==MIRROR_IN_PROGRESS_ARRAY[i][1] &amp;&amp; target==MIRROR_IN_PROGRESS_ARRAY[i][2])
                                             {
                                                  var MirrorSet = i;
                                             }

                                          } 
                                          
							parent.frames["RESULT_TABLE"].R10_hideArrayDiskInSpanTable(spanIndex ,channel,enclosure,target);
							
							<!-- Since an array disk is being deleted from a Span, the SpanLength has not reached its max, hence enable all unchecked disabled disks-->
							
								EnableUnCheckedArrayDisks();
							
							
							
							<!-- check to see if this is the last array disk deleted from the span; if so hide the Span Row and enable -->
							
							if(FourDArray.length!=8)
 							{
                                                parent.frames["RESULT_TABLE"].R10_hideArrayDiskInSpanTable(spanIndex ,-1,-1,-1); 
                                           }
                                           if(MIRROR_IN_PROGRESS_ARRAY.length!=0)
                                           {     
                                                MIRROR_IN_PROGRESS_ARRAY = new Array();
                                           }
                                         
							
						}
						else
						{  

							<!-- falls into either case "c" mentioned above-->
							<!-- hide the deleted array disk in Result table-->
							parent.frames["RESULT_TABLE"].R10_hideArrayDiskInSpanTable(spanIndex ,channel,enclosure,target);
							parent.frames["RESULT_TABLE"].R10_hideArrayDiskInSpanTable(spanIndex ,-1,-1,-1); 

							<!-- an entire span is being deleted. The array disks in the span were checked and disabled when added to the span.
								Now enable them. The disks were unchecked by the caller of this function-->
							
								EnableUnCheckedArrayDisks();
							
						}
						
						
						
						<!-- if current Span length has not exceed the max span length, enable all unchecked array disks-->
						if( FourDArray.length == 0 || (FourDArray.length != 0 &amp;&amp; count &lt; FourDArray[0].length)  )
						{
							EnableUnCheckedArrayDisks();
						}
                                if(FourDArray.length==0 &amp;&amp; SPAN_IN_PROGRESS_ARRAY.length ==0 &amp;&amp;  MIRROR_IN_PROGRESS_ARRAY.length==0)
				         {
				             enclchBxName="Sel"+channel+":"+enclosure;
				             if(parent.document.getElementById("SelectAll")!=null)
				             {
				                         parent.document.getElementById("SelectAll").disabled=false;
				                         parent.document.getElementById("SelectAll").checked=false;
				             }
				             if(parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName)!=null)
				             {
				                        parent.frames["SELECTION_TABLE"].document.getElementById(enclchBxName).disabled=false;
				              } 
				         }
					}
                         
				}
				function DisableCheckedArrayDisks()
				{
					var chkBxName="";
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null 
									&amp;&amp; document.getElementById(chkBxName).checked==true 
									&amp;&amp; document.getElementById(chkBxName).disabled ==false)
								{
									document.getElementById(chkBxName).disabled = true;	
								}					
							}
						}
					}	
				}
				function DisableUnCheckedArrayDisks()
				{
					var chkBxName="";
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null 
									&amp;&amp; document.getElementById(chkBxName).checked==false 
									&amp;&amp; document.getElementById(chkBxName).disabled ==false)
								{
									document.getElementById(chkBxName).disabled = true;	
								}				
							}
						}
					}	
				}

                        function DisableUnCheckedAndSelectedArrayDisks()
                        {  
					var chkBxName="";
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null 
									&amp;&amp; document.getElementById(chkBxName).checked==true 
									&amp;&amp; document.getElementById(chkBxName).disabled == false)
								{ 
                                                        R10_OnArrayDiskSelectedSpanMode(i,k,j);
									//document.getElementById(chkBxName).disabled = true;	
                                                      //document.getElementById(chkBxName).checked==false;
								}				
							}
						}
					}	
				}
                        function getDGnumber()
                        {     var xnumber=-1;

                               if(MIRROR_IN_PROGRESS_ARRAY.length &gt;0)
                               {
                                      xnumber= document.getElementById("DG"+MIRROR_IN_PROGRESS_ARRAY[0][0].toString()+MIRROR_IN_PROGRESS_ARRAY[0][1].toString()+MIRROR_IN_PROGRESS_ARRAY[0][2].toString()).value;

                               }
                              
                               if(SPAN_IN_PROGRESS_ARRAY.length &gt;0)
                               {   

                                     if(('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true' &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true'))
                                     {      
                                             xnumber= document.getElementById("DG"+SPAN_IN_PROGRESS_ARRAY[0][0][0].toString()+SPAN_IN_PROGRESS_ARRAY[0][0][1].toString()+SPAN_IN_PROGRESS_ARRAY[0][0][2].toString()).value;
                                     }
                                     else
                                     {
                                               xnumber= document.getElementById("DG"+SPAN_IN_PROGRESS_ARRAY[0][0].toString()+SPAN_IN_PROGRESS_ARRAY[0][1].toString()+SPAN_IN_PROGRESS_ARRAY[0][2].toString()).value;

                                     }
                              }
                              if(ThreeDArray.length &gt;0)
                              {
                                      xnumber= document.getElementById("DG"+ThreeDArray[0][0][0].toString()+ThreeDArray[0][0][1].toString()+ThreeDArray[0][0][2].toString()).value;


                              }
                              if(FourDArray.length &gt;0)
                              {
                                    xnumber= document.getElementById("DG"+FourDArray[0][0][0][0].toString()+FourDArray[0][0][0][1].toString()+FourDArray[0][0][0][2].toString()).value;

                              } 

                           return xnumber;
                        }

				function EnableUnCheckedArrayDisks()
				{
					var chkBxName="";
                              var arrayNums = "<xsl:value-of select="$GLOBAL_VAR_ArrayNumDisks"/>";
                              var xnumber = getDGnumber();
                              


					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
                                                chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
                                                
                                                     
                                                
                                                    if(document.getElementById("DG"+i.toString()+k.toString()+j.toString())!=null)
                                                   {   
                                                          var DGIndex=document.getElementById("DG"+i.toString()+k.toString()+j.toString()).value;
                                                    }
                                                   
                                                   if(DGIndex!= xnumber &amp;&amp; !autoDeleteAllSpan &amp;&amp; document.getElementById(chkBxName)!=null)
                                                   {
                                                          document.getElementById(chkBxName).disabled = true;		        
                                                   
                                                   }  
                                                    if(document.getElementById(chkBxName) != null 
									&amp;&amp; document.getElementById(chkBxName).checked==false 
									&amp;&amp; document.getElementById(chkBxName).disabled ==true &amp;&amp; (DGIndex == xnumber || (FourDArray.length+ ThreeDArray.length + SPAN_IN_PROGRESS_ARRAY.length + MIRROR_IN_PROGRESS_ARRAY.length==0))  )
								{
									document.getElementById(chkBxName).disabled = false;			
								}			
							}
						}
					}
                              	
                                if(FourDArray.length+ ThreeDArray.length + SPAN_IN_PROGRESS_ARRAY.length + MIRROR_IN_PROGRESS_ARRAY.length==0)
                               { parent.frames.OnSpanLengthChangeHandler('<xsl:value-of select="$PARAM_PREV_Layout"/>');} 	
				}
				

				function hideNonFreeArrayDisks()
				{
					var chkBxName="";
					var DGIndex="";
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null )
								{
									DGIndex=document.getElementById("DG"+i.toString()+k.toString()+j.toString()).value;
									if(DGIndex != 999)
									{
										document.getElementById("parentrow_"+"Sel"+i.toString()+k.toString()+j.toString()).style.display="none";		
									}	
								}			
							}
						}
					}
				}
				
				function getArrayDisksInSelectionTable()
				{
					var chkBxName="";
					var TwoDArray=new Array();
					var counter=0;
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null  )
								{
									var OneDArray = new Array();
									OneDArray[0]=i;
									OneDArray[1]=k;
									OneDArray[2]=j;
									TwoDArray[counter++]=OneDArray;
								}
							}
						}
					}	
					return TwoDArray;
				}
				function getDisabledAndCheckedArrayDisksInSelectionTable()
				{
					var chkBxName="";
					var TwoDArray=new Array();
					var counter=0;
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null 
									&amp;&amp; document.getElementById(chkBxName).checked==true 
									&amp;&amp; document.getElementById(chkBxName).disabled ==true)
								{
									var OneDArray = new Array();
									OneDArray[0]=i;
									OneDArray[1]=k;
									OneDArray[2]=j;
									TwoDArray[counter++]=OneDArray;
								}
							}
						}
					}	
					return TwoDArray;
				}

				function getDisabledAndUncheckedArrayDisksInSelectionTable()
				{
					var chkBxName="";
					var TwoDArray=new Array();
					var counter=0;
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null 
									&amp;&amp; document.getElementById(chkBxName).checked==false 
									&amp;&amp; document.getElementById(chkBxName).disabled ==true)
								{
									var OneDArray = new Array();
									OneDArray[0]=i;
									OneDArray[1]=k;
									OneDArray[2]=j;
									TwoDArray[counter++]=OneDArray;
								}
							}
						}
					}	
					return TwoDArray;
				}
				
				function getSelectedAndEnabledArrayDisks()
				{
					var chkBxName="";
					var TwoDArray=new Array();
					var counter=0;
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								chkBxName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(chkBxName) != null 
									&amp;&amp; document.getElementById(chkBxName).checked==true 
									&amp;&amp; document.getElementById(chkBxName).disabled ==false)
								{
									var OneDArray = new Array();
									OneDArray[0]=i;
									OneDArray[1]=k;
									OneDArray[2]=j;
									TwoDArray[counter++]=OneDArray;
								}
							}
						}
					}	
					return TwoDArray;
				}
				function getSelectedAndEnabledArrayDisksObjIDs()
				{
					var tempArray = getSelectedAndEnabledArrayDisks();
					var len = tempArray.length;
					var elemName="";
					var resval="";
					var displayString="";
					var counter =0;
					for(var k=0; k&lt;len; k++)
					{
						elemName = "OBJID"+tempArray[k][0].toString()+tempArray[k][1].toString()+tempArray[k][2].toString();
                                    resval = document.getElementById(elemName).value;
						if(counter == 0)
						{
							displayString = resval;
						}
						else
						{
							displayString = displayString + ":"+resval;
						}
						counter++;
					}
					return displayString;
				}
				function getSelectedArrayDisksArrayNum()
				{
					var elemName="";
					<!-- break out of the for loop when the first selected array disk is found-->
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								elemName = "Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(elemName) != null &amp;&amp; document.getElementById(elemName).checked==true)
								{
									return document.getElementById("DG"+i.toString()+k.toString()+j.toString()).value;
								}
							}
						}
					}
					return "null";
				}
				function getSelectedArrayDisksObjIDs()
				{
					var elemName="";
					var resval="";
					var displayString="";
					var counter =0;
					
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								elemName = "Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(document.getElementById(elemName) != null &amp;&amp; document.getElementById(elemName).checked==true)
								{
									elemName="OBJID"+i.toString()+k.toString()+j.toString();
									resval = document.getElementById(elemName).value;
									if(counter == 0)
									{
										displayString = resval;
									}
									else
									{
										displayString = displayString + ":"+resval;
									}
									counter++;
								}
							}
						}
					}
					return displayString;
				}
				
				function getPowerStateCount(IDList)
				{
					var elemName="";
					var pdstateflag =false;
					var ObjIDArray = IDList.split(":");
					for(var i=0; i&lt;ObjIDArray.length; i++)
					{
						elemName = "PDPower"+ObjIDArray[i];
						if(document.getElementById(elemName) != null &amp;&amp; document.getElementById(elemName).value == 1)
						{
						    pdstateflag = true;	
						}
					}

					return pdstateflag;
				}

				function getMultiRaidLevelOnDiskGroupWarn(IDList, layoutValue)
				{
					var elemName = "";
					var elemNameObjID = "";
					var ObjIDArray = IDList.split(":");
				        var counter =0;
				        var resval="";
				        var displayString="";

					for(var i=0; i&lt;ObjIDArray.length; i++)
					{
						elemName = "PDLayout"+ObjIDArray[i];
                                                elemNameObjID = "OBJID"+ObjIDArray[i];
						if(document.getElementById(elemName) != null &amp;&amp; document.getElementById(elemNameObjID) != null &amp;&amp; document.getElementById(elemName).value != '' &amp;&amp; document.getElementById(elemName).value != 0 &amp;&amp; document.getElementById(elemName).value != layoutValue)
						{
					            resval = document.getElementById(elemNameObjID).value;
					            if(counter == 0)
					            {
							    displayString = resval;
						      }
						      else
					            {
					    	          displayString = displayString + ", "+resval;
					            }
					            counter++;
						}
					}

					return displayString;
				}


                        function getSelectedPDInfo(IDList)
				{  
				   var elemName = "";
				   var ObjIDArray = IDList.split(":");
				   var counter =0;
				   var resval="";
				   var displayString="";
				   var powerstate="";


				   for(var i=0; i&lt;ObjIDArray.length; i++)
					{
					   elemName = "OBJID"+ObjIDArray[i];
					   powerstate = "PDPower"+ObjIDArray[i];
					   if(document.getElementById(powerstate) != null &amp;&amp; document.getElementById(powerstate).value == 1)
					   {
					      resval = document.getElementById(elemName).value;
					      if(counter == 0)
					      {
							displayString = resval;
						  }
						  else
					      {
					    	displayString = displayString + ", "+resval;
					      }
					      counter++;
					  } 
					}

					return displayString;
    			}
				
				
                         function R10_getSelectedArrayDisksObjIDsForSpans()
				{ 
					
 
					var elemName="";
					var resval="";
					var displayString="";
              			var counter =0;

                             
					     var NUM_MIRRORS = SPAN_IN_PROGRESS_ARRAY.length;
                                  
			
					     for(var i=0; i&lt;NUM_MIRRORS;i++)
					     {     
                                          for(var j=0; j&lt;2;j++)
					            {
                                   			
              							elemName = "OBJID"+SPAN_IN_PROGRESS_ARRAY[i][j][0].toString()+ SPAN_IN_PROGRESS_ARRAY[i][j][1].toString()+SPAN_IN_PROGRESS_ARRAY[i][j][2].toString();
		   							resval = document.getElementById(elemName).value;
									if(counter == 0)
									{
										displayString = resval;
									}
									else
									{
										displayString = displayString + ":"+resval;
									}
									counter++;
							
                  	                  }
						 }
                                    
                                   return displayString;

                                }

				function getSelectedArrayDisksObjIDsForSpans()
				{
					var NUM_SPANS;//R10_
                              var SPAN_LENGTH ;
					var elemName="";
					var resval="";
					var displayString="";
              			var counter =0;
                              
                             if(('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true' &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true'))
                             {     NUM_SPANS = FourDArray.length;
					     var NUM_MIRRORS = FourDArray[0].length;
                                   SPAN_LENGTH=2*NUM_MIRRORS;
			
					     for(var i=0; i&lt;NUM_SPANS;i++)
					     {     
                                          for(var j=0; j&lt;NUM_MIRRORS;j++)
					            {
                                   			for(var k=0;k&lt;2;k++)
 						            {     
              							elemName = "OBJID"+FourDArray[i][j][k][0].toString()+ FourDArray[i][j][k][1].toString()+FourDArray[i][j][k][2].toString();
		   							resval = document.getElementById(elemName).value;
									if(counter == 0)
									{
										displayString = resval;
									}
									else
									{
										displayString = displayString + ":"+resval;
									}
									counter++;
								}
                  	                }
						}
                                }
                                else
                                {        
                                          NUM_SPANS=ThreeDArray.length;
					            SPAN_LENGTH=ThreeDArray[0].length;

                                           for(var i=0; i&lt;NUM_SPANS;i++)
		  				            {
 									for(var j=0;j&lt;SPAN_LENGTH;j++)
										{
											elemName = "OBJID"+ThreeDArray[i][j][0].toString()+ ThreeDArray[i][j][1].toString()+ThreeDArray[i][j][2].toString();
											resval = document.getElementById(elemName).value;
												if(counter == 0)
												{
													displayString = resval;
												}
												else
												{
													displayString = displayString + ":"+resval;
												}
												counter++;
										}
								}
                                } 
					return displayString;
                              
				}
                        function GetSelectedOrDisabledEnclosures(selectedordisabled)
				{     
					
					
					var elemName="";
					var resval="";
					var displayString="";
					var counter =0;
					
					for(var i=0; i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var j=0;j&lt;JS_GLOBAL_MaxNumEnclosures;j++)
						{      
							elemName = "Sel"+i.toString()+":"+ j.toString();
                                          if(selectedordisabled == 1 &amp;&amp; document.getElementById(elemName)!=null &amp;&amp; document.getElementById(elemName).checked == true )
                                          {   
							      resval = document.getElementById(elemName).value;
                                               
								if(counter == 0)
								{
									displayString = resval;
								}
								else
								{
									displayString = displayString + ":"+resval;
								}
								counter++;
                                           }
                                          else if(selectedordisabled == 0 &amp;&amp; document.getElementById(elemName)!=null &amp;&amp; document.getElementById(elemName).disabled == true)
                                          {   
							     resval = document.getElementById(elemName).value;

                                               
								if(counter == 0)
								{
									displayString = resval;
								}
								else
								{
									displayString = displayString + ":"+resval;
								}
								counter++;
                                           }

						}
					}
                                       
					return displayString;
                              
				}
                        

				function getSpanLength()
				{     
					
                            if(('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true' &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true'))
                             {
                                  if(FourDArray.length != 0)
	 				    {
						     return 2*FourDArray[0].length;
					    }
					    else
					    {
						 return 0;
					     }
                             }else
                             { 
                                if(ThreeDArray.length != 0)
					  {
						return ThreeDArray[0].length;
					  }
					  else
					  {
						return 0;
					  }
                              }   
				}
				function IsSpanMode()
				{
					return SPAN_MODE;
				}
				function getNumOfSpans()
				{
                              if(('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true' &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true'))
                              { 	return FourDArray.length;  }
                              else
                               {          ThreeDArray.length; }
                                           
				}
				function R10_getArrayDisksInGivenSpan(SpanName)
				{
					var len = FourDArray.length;
                              var ReturnArray = new Array(); 
                              var a=0;
					for(var i=0; i&lt; len; i++)
					{
						if(SpanName == "Span "+i.toString())
                                      {  


                                              for(j=0;j&lt;FourDArray[i].length;j++)
                                              {
                                                    for(k=0;k&lt;FourDArray[i][j].length; k++)
                                                    {   
                                                          ReturnArray[a++]= FourDArray[i][j][k];
                                                    }
                                              } 
						          if(a &gt;0)
                                              {  
                                                       return ReturnArray;
                                              }
                                      }
                                   
					}
                              
					return null;
				}
                        function Non_R10_getArrayDisksInGivenSpan(SpanName)
				{
					var len = ThreeDArray.length;
					for(var i=0; i&lt; len; i++)
					{
						if(SpanName == "Span "+i.toString())
							return ThreeDArray[i];
					}
					return null;
				}
				function getChTgtIdStringGivenObjIDForArrayDisk(ObjID)
				{
					var elemName = "OBJID"+ObjID;
					var obj = document.getElementById(elemName);
					if(obj != null)
						return obj.value;
					else
						return null;
				}
			</script>
			<SelectionData>
					<SelectionTable>
                                           
						<Header>
							<xsl:for-each select="//Channels/DCStorageObject">
								<xsl:sort select="Channel" data-type="number" order="ascending"/>
								<xsl:call-template name="RenderChannelSelectionRadioButtons"/>
							</xsl:for-each>
						</Header>

						<xsl:for-each select="//ArrayDisks">
							<xsl:variable name="SASorSATA">
								<xsl:call-template name="IsSASorSATA">
									<xsl:with-param name="BusProtocol"><xsl:value-of select="DCStorageObject/BusProtocol"/></xsl:with-param>
								</xsl:call-template>
							</xsl:variable>
                                                         <xsl:message> inside utils selection table layout 1</xsl:message>
							<xsl:variable name="DiskInEnclosure">
								<xsl:call-template name="IsDiskInEnclosure">
									<xsl:with-param name="AttributesMask"><xsl:value-of select="DCStorageObject/AttributesMask"/></xsl:with-param>
								</xsl:call-template>
							</xsl:variable>
							<xsl:if test="count(DCStorageObject)!=0 and @EnclosureName">
								<xsl:choose>
									<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
										<xsl:call-template name="RenderSelectionTableParentRow">
                                                                                        <xsl:with-param name="Channel"><xsl:value-of select="DCStorageObject/Channel"/></xsl:with-param>                                
											<xsl:with-param name="PARENT_NAME">Sel<xsl:value-of select="DCStorageObject/Channel"/><xsl:value-of select="DCStorageObject/EnclosureID"/></xsl:with-param>
											<xsl:with-param name="CHILD_NAME_PREFIX">Sel</xsl:with-param>
											<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type" select="@EnclosureType"/><xsl:with-param name="productid" select="@ProductID"/></xsl:call-template> (<xsl:value-of select="$strEnclosureID"/>&#160;<xsl:value-of select="DCStorageObject/EnclosureID"/>)</xsl:otherwise></xsl:choose></xsl:with-param>
											<xsl:with-param name="KEY_NAME">ADsForChannel</xsl:with-param>
											<xsl:with-param name="KEY_MATCH"><xsl:value-of select="@EnclosureName"/></xsl:with-param>
											<xsl:with-param name="RULES"><xsl:value-of select="$PARAM_DSA_Rules"/></xsl:with-param>
											<xsl:with-param name="LAYOUT_SELECTED"><xsl:value-of select="$PARAM_PREV_Layout"/></xsl:with-param>
											<xsl:with-param name="CLEAR_FOREIGN_CONFIGENABLE"><xsl:value-of select="$PARAM_ClearForeignConfigEnable"/></xsl:with-param>
											<xsl:with-param name="MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$GLOBAL_VAR_MinDrivesForSelectedLayout"/></xsl:with-param>
											<xsl:with-param name="FreeDisks"><xsl:value-of select="$GLOBAL_VAR_ArrayDiskCount"/></xsl:with-param>          
											<xsl:with-param name="EnclosureID"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:text> </xsl:text></xsl:when><xsl:otherwise><xsl:value-of select="DCStorageObject/EnclosureID"/></xsl:otherwise></xsl:choose></xsl:with-param>
											<xsl:with-param name="CntrlAttributesMask"><xsl:value-of select="$CntrlAttributesMask"/></xsl:with-param>
											<xsl:with-param name="SpanEditMode"><xsl:value-of select="$PARAM_SPANEDITMODE"/></xsl:with-param>
											
									   	</xsl:call-template>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="RenderSelectionTableParentRow">
                                                                                        <xsl:with-param name="Channel"><xsl:value-of select="DCStorageObject/Channel"/></xsl:with-param>                                
											<xsl:with-param name="PARENT_NAME">Sel<xsl:value-of select="DCStorageObject/Channel"/><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/></xsl:with-param>
											<xsl:with-param name="CHILD_NAME_PREFIX">Sel</xsl:with-param>
											<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type" select="@EnclosureType"/><xsl:with-param name="productid" select="@ProductID"/></xsl:call-template></xsl:otherwise></xsl:choose></xsl:with-param>			
											<xsl:with-param name="KEY_NAME">ADsForChannel</xsl:with-param>
											<xsl:with-param name="KEY_MATCH"><xsl:value-of select="@EnclosureName"/></xsl:with-param>
											<xsl:with-param name="RULES"><xsl:value-of select="$PARAM_DSA_Rules"/></xsl:with-param>
											<xsl:with-param name="LAYOUT_SELECTED"><xsl:value-of select="$PARAM_PREV_Layout"/></xsl:with-param>
											<xsl:with-param name="CLEAR_FOREIGN_CONFIGENABLE"><xsl:value-of select="$PARAM_ClearForeignConfigEnable"/></xsl:with-param>
											<xsl:with-param name="MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$GLOBAL_VAR_MinDrivesForSelectedLayout"/></xsl:with-param>
											<xsl:with-param name="FreeDisks"><xsl:value-of select="$GLOBAL_VAR_ArrayDiskCount"/></xsl:with-param>          
                                                                                        <xsl:with-param name="CntrlAttributesMask"><xsl:value-of select="$CntrlAttributesMask"/></xsl:with-param>
											<xsl:with-param name="SpanEditMode"><xsl:value-of select="$PARAM_SPANEDITMODE"/></xsl:with-param>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:if>
						</xsl:for-each>
					</SelectionTable>
				</SelectionData>
				<HiddenTable>
					<xsl:for-each select="//ArrayDisks/DCStorageObject">
						<xsl:call-template name="getArrayDiskArrayNum_HIDDEN_SELECTION_TABLE"/>
						<xsl:call-template name="getObjIDForArrayDisks_HIDDEN_SELECTION_TABLE"/>
						<xsl:call-template name="getChTgtIDGivenObjIDForArrayDisks_HIDDEN_SELECTION_TABLE"/>
						<xsl:call-template name="getProtocolsForArrayDisks_HIDDEN_SELECTION_TABLE"/>
						<xsl:call-template name="getContiguousFreeSpaceForArrayDisks_HIDDEN_SELECTION_TABLE"/>
						<xsl:call-template name="getPowerStateForArrayDisks_HIDDEN_SELECTION_TABLE"/>
						<xsl:call-template name="getLayoutForArrayDisks_HIDDEN_SELECTION_TABLE"/>
					</xsl:for-each>
					<!--xsl:for-each select="//ArrayDisks">
						<xsl:call-template name="getDiskGroupNumPossibleForGivenLayout_HIDDEN_TABLE"/>
					</xsl:for-each-->
					<xsl:apply-templates select="//ArrayDisks/DCStorageObject" mode="ObjIDsForArrayDisks_HIDDEN_TABLE"/>
					<xsl:for-each select="//ExpressResults">
						<xsl:call-template name="getArrayNumsPossibleForGivenLayout_HIDDEN_TABLE"/>
					</xsl:for-each>
					<xsl:for-each select="//Channels/DCStorageObject">
						<xsl:call-template name="isChannelNonRaid_HIDDEN_TABLE"/>
					</xsl:for-each>
				</HiddenTable>
		</DataArea>
	</xsl:template>
	<!--xsl:template name="getDiskGroupNumPossibleForGivenLayout_HIDDEN_TABLE">
		<Data>
			<xsl:attribute name="name">DiskGroupNumForGivenLayout<xsl:value-of select="position()"/></xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="@ArrayNum"/></xsl:attribute>
		</Data>
	</xsl:template-->
	<xsl:template name="isChannelNonRaid_HIDDEN_TABLE">
		<Data>
			<xsl:attribute name="name">ChannelNum<xsl:value-of select="Channel"/></xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:call-template name="IsObjectNonRaid"><xsl:with-param name="Mask" select="AttributesMask"/></xsl:call-template></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template name="getArrayNumsPossibleForGivenLayout_HIDDEN_TABLE">
		<Data>
			<xsl:attribute name="name">ANIndex<xsl:value-of select="position()"/></xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="@ArrayNum"/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template name="getObjIDForArrayDisks_HIDDEN_SELECTION_TABLE">
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Data>
			<xsl:choose>
				<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
					<xsl:attribute name="name">OBJID<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="name">OBJID<xsl:value-of select="Channel"/><xsl:value-of select="TargetID"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template name="getContiguousFreeSpaceForArrayDisks_HIDDEN_SELECTION_TABLE">
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Data>
			<xsl:choose>
				<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
					<xsl:attribute name="name">DISK<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="name">DISK<xsl:value-of select="Channel"/><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<!--RS - DF24509: Fix to handle freespace in DSA-->
			<xsl:choose>
				<xsl:when test="$PARAM_DSA_Rules='1' ">
					<xsl:attribute name="returnvalue"><xsl:value-of select="Length"/></xsl:attribute>
				</xsl:when>
	   			<xsl:otherwise>
					<xsl:attribute name="returnvalue"><xsl:value-of select="ContiguousFree"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</Data>
	</xsl:template>
	<xsl:template name="getPowerStateForArrayDisks_HIDDEN_SELECTION_TABLE">
		<Data>
			<xsl:attribute name="name">PDPower<xsl:value-of select="ObjID"/></xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="PDPowerState"/></xsl:attribute>
		</Data>
	</xsl:template>
	<!-- creates a table to fetch  Layout (added only for SWRaid disks *not* VD) on disk. Used to show a warning when multiple raid levels are being created-->
	<xsl:template name="getLayoutForArrayDisks_HIDDEN_SELECTION_TABLE">
		<Data type="hidden">
			<xsl:attribute name="name">PDLayout<xsl:value-of select="ObjID"/></xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="Layout"/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template name="getChTgtIDGivenObjIDForArrayDisks_HIDDEN_SELECTION_TABLE">
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Data>
			<xsl:attribute name="name">OBJID<xsl:value-of select="ObjID"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
					<xsl:attribute name="returnvalue"><xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="returnvalue"><xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</Data>
	</xsl:template>
	<xsl:template name="getArrayDiskArrayNum_HIDDEN_SELECTION_TABLE">
		<xsl:variable name="ArrayNumExists"><xsl:value-of select="ArrayNum"/></xsl:variable>
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Data>
			<xsl:choose>
				<!--Code to handle DSA display-->
				<xsl:when test="$PARAM_DSA_Rules='1' ">
					<xsl:choose>
						<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
							<xsl:attribute name="name">DG<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="name">DG<xsl:value-of select="Channel"/><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="returnvalue">-1</xsl:attribute>		
				</xsl:when>
				<xsl:when test="not($ArrayNumExists)">
					<xsl:choose>
						<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
							<xsl:attribute name="name">DG<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="name">DG<xsl:value-of select="Channel"/><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="returnvalue">-1</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
							<xsl:attribute name="name">DG<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="name">DG<xsl:value-of select="Channel"/><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="returnvalue"><xsl:value-of select="ArrayNum"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</Data>
	</xsl:template>
	<xsl:template name="getProtocolsForArrayDisks_HIDDEN_SELECTION_TABLE">
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Data>
			<xsl:choose>
				<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
					<xsl:attribute name="name">Proto<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="name">Proto<xsl:value-of select="Channel"/><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:attribute name="returnvalue"><xsl:value-of select="BusProtocol"/></xsl:attribute>
		</Data>
	</xsl:template>
        
        
        
	<xsl:template name="RenderChannelSelectionRadioButtons">
		<Data name="Channel" type="radio" handler="OnChannelSelected()" event="onclick" state="0">
			<xsl:attribute name="value"><xsl:value-of select="$strChannel"/>&#160;<xsl:value-of select="Channel"/></xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="Channel"/></xsl:attribute>
		</Data>
	</xsl:template>
	<!--**************************************************************************Code for Result Table/**************************************************************************************************************************-->
	<xsl:template name="ResultData">
		<!--the code below is rendered third/-->
		<DataArea printable="false" email="false" onLoad="true" exportdata="false" nographics="true">
			<xsl:if test="$PARAM_DSA_Rules ='1'">
				<xsl:attribute name="storeonback">true</xsl:attribute>
				<xsl:attribute name="screenname"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:attribute>
			</xsl:if>
			<script language="javascript">
				
				var JS_GLOBAL_MaxNumChannels = 2;
				var JS_GLOBAL_MaxNumEnclosures = parseInt("<xsl:value-of select="$GLOBAL_VAR_MAX_Enclosures"/>");
				
                       	var JS_GLOBAL_MaxNumSpans = parseInt("<xsl:value-of select="$GLOBAL_VAR_MaxSpansForSelectedLayout"/>");
                         var JS_GLOBAL_MaxNumMirros = 2*JS_GLOBAL_MaxNumSpans; 
				var JS_GLOBAL_LayoutValue=parseInt("<xsl:value-of select="$PARAM_PREV_Layout"/>");
				var JS_GLOBAL_RowElemName1D = new Array(JS_GLOBAL_MaxNumChannels);
				var JS_GLOBAL_ChkbxRowName2D = new Array(JS_GLOBAL_MaxNumChannels);
				var JS_GLOBAL_ChkbxElemName2D = new Array(JS_GLOBAL_MaxNumChannels);
				var JS_GLOBAL_SpanElemName3D = new Array(JS_GLOBAL_MaxNumSpans);
				var JS_GLOBAL_SpanRowChkbxName3D = new Array(JS_GLOBAL_MaxNumSpans);
				var JS_GLOBAL_SpanRowElemName1D = new Array(JS_GLOBAL_MaxNumSpans);
                        var JS_GLOBAL_MirrorElemName3D = new Array(JS_GLOBAL_MaxNumSpans);
                        var JS_GLOBAL_MirrorRowElemName1D = new Array(JS_GLOBAL_MaxNumMirros);
   				var JS_GLOBAL_ObjIDs2D = new Array(JS_GLOBAL_MaxNumChannels);
                        var MaxTargetsArray = new Array();
				function initializationRoutine()
				{

                               MaxTargetsArray[0] = new Array();                                
                                MaxTargetsArray[0][0] =  new Array();
                                MaxTargetsArray[0][0] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure00"/>';		
                                MaxTargetsArray[0][1] =  new Array();
                                MaxTargetsArray[0][1] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure01"/>';
                                MaxTargetsArray[0][2] =  new Array();
                                MaxTargetsArray[0][2] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure02"/>';
                                MaxTargetsArray[0][3] =  new Array();
                                MaxTargetsArray[0][3] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure03"/>';

                                MaxTargetsArray[1] = new Array();                                
                                MaxTargetsArray[1][0] =  new Array();
                                MaxTargetsArray[1][0] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure10"/>';		
                                MaxTargetsArray[1][1] =  new Array();
                                MaxTargetsArray[1][1] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure11"/>';
                                MaxTargetsArray[1][2] =  new Array();
                                MaxTargetsArray[1][2] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure12"/>';
                                MaxTargetsArray[1][3] =  new Array();
                                MaxTargetsArray[1][3] = '<xsl:value-of select="$GLOBAL_VAR_ArrayDiskEnclosure13"/>';

					initRowElemNames();
					initChkbxRowNames();
					initChkbxElemNames();
			            initSpanRowElemNames();
                              initObjIDsElemNames();
					hideResultTable();

                              if(('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>'!='true' &amp;&amp;  '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || ('<xsl:value-of select="$PARAM_PREV_Layout"/>'=='512' &amp;&amp; '<xsl:value-of select="$PARAM_CURR_IM"/>' == 'true' &amp;&amp; '<xsl:value-of select="$PARAM_SPANEDITMODE"/>'== 'true'))
                              {
                                   R10_initSpanElemNames();
                                   R10_initMirrorRowElemNames();
					     R10_initSpanRowChkbxNames();
                                   R10_hideSpanTable();
                               }
                               else
                               {
                                    initSpanElemNames();
                                    initSpanRowChkbxNames();
                                    hideSpanTable(); 
                                }
					<!-- Result table does not find gnavObj since it is an embedded frame -->
					<xsl:if test="$PARAM_DSA_Rules='1'">
						gnavObj = parent.parent.parent.parent.gnv;
					</xsl:if>
				}
				function restoreDSACache()
				{
					<!--
					Get DSA cached data for result table. Figure out IDList based on which checkboxes
					are set. Once we have a colon delimited list of disk IDs, we can call the restore
					function UpdateWithUserSelectedInputs() in main frame.
					 -->
					var IDList = '';
					var initialData = gnavObj.collection.getItem (replaceString ('<xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/>' , ' ' , '-' , false));
					if (initialData != null &amp;&amp; typeof(initialData) != "undefined" &amp;&amp; initialData.length != 0) {
						for (var j = 0; j &lt; initialData.length; j++)
						{
							element = initialData[j];
							
							if (element.type == "checkbox" &amp;&amp; element.value == "1") {
								checkbox = document.getElementById(element.id);
								checkbox.checked = false;
								checkbox.disabled = false;
								
								oid = checkbox.value;
								if (!isNaN(parseInt(oid)))
									IDList += oid + ':';
							}
						}
						IDList = IDList.substr(0, IDList.length-1);
						if (IDList != "")
							parent.frames.UpdateWithUserSelectedInputs(IDList);
					}
				}
				function getMaxSpansValue()
				{
					return JS_GLOBAL_MaxNumSpans;
				}
                        function initSpanElemNames()
				{
					var elemName="";
					for(var k=0;k&lt;JS_GLOBAL_MaxNumSpans;k++)
					{
						JS_GLOBAL_SpanElemName3D[k] = new Array(JS_GLOBAL_MaxNumChannels);
						for(var i=0; i&lt; JS_GLOBAL_MaxNumChannels; i++)
						{
							JS_GLOBAL_SpanElemName3D[k][i] = new Array(JS_GLOBAL_MaxNumEnclosures);
							for(var l=0;l&lt;JS_GLOBAL_MaxNumEnclosures;l++)
							{
								JS_GLOBAL_SpanElemName3D[k][i][l] = new Array(MaxTargetsArray[i][l]);
								for(var j=0;j&lt;MaxTargetsArray[i][l];j++)
								{
									elemName = "parentrow_"+"Span"+k.toString()+":"+i.toString()+":"+l.toString()+":"+j.toString();
									JS_GLOBAL_SpanElemName3D[k][i][l][j] = elemName;
								}
							}
						}
					}
				} 
				function R10_initSpanElemNames()
				{
					var elemName="";

					for(var k=0;k&lt;JS_GLOBAL_MaxNumSpans;k++)
					{       
                                    JS_GLOBAL_SpanElemName3D[k] = new Array(JS_GLOBAL_MaxNumMirros);
						for(var a=0;a&lt;JS_GLOBAL_MaxNumMirros;a++)
                                    {
                                         JS_GLOBAL_SpanElemName3D[k][a] = new Array(JS_GLOBAL_MaxNumChannels);
  						            for(var i=0; i&lt; JS_GLOBAL_MaxNumChannels; i++)
								 {
									JS_GLOBAL_SpanElemName3D[k][a][i] = new Array(JS_GLOBAL_MaxNumEnclosures);
										for(var l=0;l&lt;JS_GLOBAL_MaxNumEnclosures;l++)
										{
                                                			JS_GLOBAL_SpanElemName3D[k][a][i][l] = new Array(MaxTargetsArray[i][l]);
												for(var j=0;j&lt;MaxTargetsArray[i][l];j++)
												{	
													elemName = "parentrow_"+"Span"+k.toString()+a.toString()+":"+i.toString()+":"+l.toString()+":"+j.toString();
													JS_GLOBAL_SpanElemName3D[k][a][i][l][j] = elemName;
												}
										}
								}
						}
				}
                    }
			
                 function initSpanRowChkbxNames()
				{
					var elemName="";
					for(var k=0;k&lt;JS_GLOBAL_MaxNumSpans;k++)
					{
						JS_GLOBAL_SpanRowChkbxName3D[k] = new Array(JS_GLOBAL_MaxNumChannels);
						for(var i=0; i&lt; JS_GLOBAL_MaxNumChannels; i++)
						{
							JS_GLOBAL_SpanRowChkbxName3D[k][i] = new Array(JS_GLOBAL_MaxNumEnclosures);
							for(var l=0;l&lt;JS_GLOBAL_MaxNumEnclosures;l++)
							{
								JS_GLOBAL_SpanRowChkbxName3D[k][i][l] = new Array(MaxTargetsArray[i][l]);
								for(var j=0;j&lt;MaxTargetsArray[i][l];j++)
								{
									elemName = "Span"+k.toString()+i.toString()+":"+l.toString()+":"+j.toString();
									JS_GLOBAL_SpanRowChkbxName3D[k][i][l][j] = elemName;
								}
							}
						}
					}
				}
      	function R10_initSpanRowChkbxNames()
				{
					var elemName="";
					for(var k=0;k&lt;JS_GLOBAL_MaxNumSpans;k++)
					{
                                               JS_GLOBAL_SpanRowChkbxName3D[k] = new Array(JS_GLOBAL_MaxNumMirros);
                                               for(var a=0;a&lt;JS_GLOBAL_MaxNumMirros;a++)
                                               {

                                                                                    JS_GLOBAL_SpanRowChkbxName3D[k][a] = new Array(JS_GLOBAL_MaxNumChannels);
                                                                                    for(var i=0; i&lt; JS_GLOBAL_MaxNumChannels; i++)
                                                                                    {
                                                                                            JS_GLOBAL_SpanRowChkbxName3D[k][a][i] = new Array(JS_GLOBAL_MaxNumEnclosures);
                                                                                            for(var l=0;l&lt;JS_GLOBAL_MaxNumEnclosures;l++)
                                                                                            {
                                                                                                    JS_GLOBAL_SpanRowChkbxName3D[k][a][i][l] = new Array(MaxTargetsArray[i][l]);
                                                                                                    for(var j=0;j&lt;MaxTargetsArray[i][l];j++)
                                                                                                    { 
                                                                                                            elemName = "Span"+k.toString()+a.toString()+i.toString()+":"+l.toString()+":"+j.toString()	;
                                                                                                            JS_GLOBAL_SpanRowChkbxName3D[k][a][i][l][j] = elemName;

                                                                                                    }
                                                                                            }
                                                                                    }
                                                                            }
                                                               }
                                       }
			function initSpanRowElemNames()
				{
					var elemName="";
					for(var i=0; i&lt;JS_GLOBAL_MaxNumSpans; i++)
					{
							elemName = "parentrow_"+"Span"+i.toString();
							JS_GLOBAL_SpanRowElemName1D[i] = elemName;
					}
				}
                  function R10_initMirrorRowElemNames()
				{
					var elemName="";
                              for(var i=0; i&lt;JS_GLOBAL_MaxNumSpans; i++)
					{
                                        JS_GLOBAL_MirrorRowElemName1D[i] = new Array();
					           for(var j=0; j&lt;JS_GLOBAL_MaxNumMirros; j++)
					           {
							 elemName = "parentrow_"+"Span"+i.toString()+"Mirror"+j.toString();
							 JS_GLOBAL_MirrorRowElemName1D[i][j] = elemName;
					           }
                              }
				}

				function initRowElemNames()
				{
					var elemName="";
					for(var i=0; i&lt;JS_GLOBAL_MaxNumChannels; i++)
					{
						JS_GLOBAL_RowElemName1D[i] = new Array(JS_GLOBAL_MaxNumEnclosures);
						for(var j=0; j&lt;JS_GLOBAL_MaxNumEnclosures;j++)
						{
							elemName = "parentrow_"+"Res"+i.toString()+j.toString();
							JS_GLOBAL_RowElemName1D[i][j] = elemName;
						}
					}
				}
				function initObjIDsElemNames()
				{
					var elemName="";
					for(var i=0; i&lt;JS_GLOBAL_MaxNumChannels; i++)
					{
						JS_GLOBAL_ObjIDs2D[i] = new Array(JS_GLOBAL_MaxNumEnclosures);
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							JS_GLOBAL_ObjIDs2D[i][k] = new Array(MaxTargetsArray[i][k]);
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								elemName = "OBJID"+i.toString()+k.toString()+j.toString();
								JS_GLOBAL_ObjIDs2D[i][k][j] = elemName;
							}
						}
					}
				}
				function initChkbxRowNames()
				{
					var elemName="";
					for(var i=0; i&lt;JS_GLOBAL_MaxNumChannels; i++)
					{
						JS_GLOBAL_ChkbxRowName2D[i] = new Array(JS_GLOBAL_MaxNumEnclosures);
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{    
							JS_GLOBAL_ChkbxRowName2D[i][k] = new Array(MaxTargetsArray[i][k]);
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								elemName = "parentrow_"+"Res"+i.toString()+k.toString()+j.toString();
								JS_GLOBAL_ChkbxRowName2D[i][k][j] = elemName;
							}
						}
					}
				}
				function initChkbxElemNames()
				{
					var elemName="";
					for(var i=0; i&lt;JS_GLOBAL_MaxNumChannels; i++)
					{
						JS_GLOBAL_ChkbxElemName2D[i] = new Array(JS_GLOBAL_MaxNumEnclosures);
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							JS_GLOBAL_ChkbxElemName2D[i][k] = new Array(MaxTargetsArray[i][k]);
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								elemName = "Res"+i.toString()+":"+k.toString()+":"+j.toString();
								JS_GLOBAL_ChkbxElemName2D[i][k][j] = elemName;
							}
						}
					}
				}
				function hideResultTable()
				{					
					for(var i=0; i&lt;JS_GLOBAL_MaxNumChannels; i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{     var ele = document.getElementById(JS_GLOBAL_ChkbxRowName2D[i][k][j]);
								if(ele != null)
								{
									document.getElementById(JS_GLOBAL_RowElemName1D[i][k]).style.display="none";
									ele.style.display="none";
                                                     
								}
							}
                                          ele= document.getElementById(JS_GLOBAL_RowElemName1D[i][k]);
                                          if(ele!=null)
                                          {  
                                          ele.style.display="none";
                                          }
						}
					}
				}
                       
				function ActiveSpanTable()
                       {
                           var SpanElemName ="";  
                           var MirrorName ="";
                          var SpanName ="";
                           for(var i=0;i&lt; parent.frames["SELECTION_TABLE"].FourDArray.length;i++)
                               {
                                     for(var j=0;j&lt; parent.frames["SELECTION_TABLE"].FourDArray[i].length ; j++)
                                      {
                                           for(var  k=0; k&lt; parent.frames["SELECTION_TABLE"].FourDArray[i][j].length ; k++)
                                             {
                                                  SpanElemName  =  "parentrow_"+"Span"+i.toString()+j.toString()+":"+parent.frames["SELECTION_TABLE"].FourDArray[i][j][k][0].toString()+":"+parent.frames["SELECTION_TABLE"].FourDArray[i][j][k][1].toString()+":"+ parent.frames["SELECTION_TABLE"].FourDArray[i][j][k][2];
                                                  document.getElementById(SpanElemName).style.display="none";
                                              }
                                           MirrorName = "parentrow_"+"Span"+i.toString()+"Mirror"+j.toString();
                                           document.getElementById(MirrorName).style.display="none";
                                      }
                                       SpanName = "parentrow_"+"Span"+i.toString();
                                       document.getElementById(SpanName).style.display="none";
                                }
                           
                              for(i=0;i&lt; parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY.length;i++)
                              {
                                     for(j=0;j&lt; parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY[i].length ; j++)
                                      {                                           
                                            SpanElemName  =  "parentrow_"+"Span"+parent.frames["SELECTION_TABLE"].FourDArray.length+i.toString()+":"+parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY[i][j][0].toString()+":"+parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY[i][j][1].toString()+":"+ parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY[i][j][2];
                                            document.getElementById(SpanElemName).style.display="none";
                                            
                                      }
                                       MirrorName = "parentrow_"+"Span"+parent.frames["SELECTION_TABLE"].FourDArray.length+"Mirror"+i.toString();
                                       document.getElementById(MirrorName).style.display="none";
                                       SpanName = "parentrow_"+"Span"+parent.frames["SELECTION_TABLE"].FourDArray.length;
                                       document.getElementById(SpanName).style.display="none";

                                 } 
                                for(i=0;i&lt; parent.frames["SELECTION_TABLE"].MIRROR_IN_PROGRESS_ARRAY.length;i++)
                                {
                                               SpanElemName  =  "parentrow_"+"Span"+parent.frames["SELECTION_TABLE"].FourDArray.length+parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY.length.toString()+":"+parent.frames["SELECTION_TABLE"].MIRROR_IN_PROGRESS_ARRAY[i][0].toString()+":"+parent.frames["SELECTION_TABLE"].MIRROR_IN_PROGRESS_ARRAY[i][1].toString()+":"+ parent.frames["SELECTION_TABLE"].MIRROR_IN_PROGRESS_ARRAY[i][2];
                                               document.getElementById(SpanElemName).style.display="none";
                                               MirrorName = "parentrow_"+"Span"+parent.frames["SELECTION_TABLE"].FourDArray.length+"Mirror"+parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY.length.toString();
                                               document.getElementById(MirrorName).style.display="none";
                                               SpanName = "parentrow_"+"Span"+parent.frames["SELECTION_TABLE"].FourDArray.length;
                                               document.getElementById(SpanName).style.display="none";

                                 }  
                               
                              
                                  
                              for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								parent.frames["SELECTION_TABLE"].enableArrayDiskCheckBox(i.toString(), k.toString(), j.toString());
                                                parent.frames["SELECTION_TABLE"].unSelectArrayDiskCheckBox(i.toString(), k.toString(), j.toString());
                                                

							}
						}
					}
                              
                      }
 
				function hideSpanTable()
				{
					for(var k=0;k&lt;JS_GLOBAL_MaxNumSpans;k++)
					{
						for(var i=0; i&lt; JS_GLOBAL_MaxNumChannels; i++)
						{
							for(var l=0;l&lt;JS_GLOBAL_MaxNumEnclosures;l++)
							{
								for(var j=0;j&lt;MaxTargetsArray[i][l];j++)
								{
									if(document.getElementById(JS_GLOBAL_SpanElemName3D[k][i][l][j]) != null)
									{
										document.getElementById(JS_GLOBAL_SpanRowElemName1D[k]).style.display="none";
										document.getElementById(JS_GLOBAL_SpanElemName3D[k][i][l][j]).style.display="none";
										<!-- DF115804 : Hidden array disks need to be unchecked as well -->
										try{
											var chkBxName="Span"+k.toString()+i.toString()+":"+l.toString()+":"+j.toString();
											document.getElementById(chkBxName).checked=false;
										}catch(e){}
									}
								}
							}
						}
					}
				}

                        function hideMirrorDisks(FourDArrayLength, SpanInProgressArrayLength)
                        {
                            var ChannelArray = new Array();
                            var EnclosureArray = new Array();
                            var ele1 = "";
                            for(var i=0; i&lt; JS_GLOBAL_MaxNumChannels; i++)
                            { 
                                ChannelArray = JS_GLOBAL_SpanElemName3D[FourDArrayLength][SpanInProgressArrayLength][i];  
				for(var l=0;l&lt;JS_GLOBAL_MaxNumEnclosures;l++)
                                { 
                                    EnclosureArray = ChannelArray[l]; 
                                    for(var j=0;j&lt;MaxTargetsArray[i][l];j++)
                                    {    
                                        ele1 = document.getElementById(EnclosureArray[j]);
	    				if(ele1 != null)
                                        {
                                            ele1.style.display="none";
                                        }
                                    }
                                    EnclosureArray = new Array();
                                }
                                ChannelArray = new Array();
                            }
                        } 
                        
                        function R10_hideSpanTable()
			{  
                            var ele1="",ele2="",ele3="";
                            var k=0,a=0,i=0,l=0,j=0;
                            var SpanArray = new Array();
                            var MirrorArray = new Array();
                              
                            for(k=0;k&lt;JS_GLOBAL_MaxNumSpans;k++)
                            {   
                                //SpanArray =JS_GLOBAL_SpanElemName3D[k]; 
                                for(a=0;a&lt;JS_GLOBAL_MaxNumMirros;a++)
                                {   
                                    //MirrorArray = SpanArray[a]; 
                                    ele2 = document.getElementById(JS_GLOBAL_MirrorRowElemName1D[k][a]); 
                                    if(ele2 != null)
                                    { 
                                        ele2.style.display="none";
                                    } 
                                    MirrorArray = new Array();
                                }
                                ele3 = document.getElementById(JS_GLOBAL_SpanRowElemName1D[k]); 
                                if(ele3 != null)
                                {
                                    ele3.style.display="none"; 
                                }
                                SpanArray = new Array();   
                            }
			}
                        
                        function hideMirrorSetTable()
                        {
                              for(var k=0;k&lt;JS_GLOBAL_MaxNumSpans;k++)
					{
                                  for(var a=0;a&lt;JS_GLOBAL_MaxNumMirros;a++)
                                  {  
                                     document.getElementById(JS_GLOBAL_MirrorRowElemName1D[k][a]).style.display="none";
                                  }
                              }
                        }                         


                        function OnDeleteSpan(SpanName)
                        {
                          var layoutValue='<xsl:value-of select="$PARAM_PREV_Layout"/>';
                          var intMirror = false;
  				  intMirror ='<xsl:value-of select="$PARAM_CURR_IM"/>'; 
                          var SPANEDITMODE = '<xsl:value-of select="$PARAM_SPANEDITMODE"/>';				

                           if((layoutValue=='512' &amp;&amp; intMirror!='true' &amp;&amp; '<xsl:value-of select="$GLOBAL_VAR_PercVersion"/>'!='9') || (layoutValue=='512' &amp;&amp; intMirror == 'true' &amp;&amp; SPANEDITMODE == 'true'))
                           {
                                  R10_OnDeleteSpan(SpanName);
                           }
                           else
                           {
							 // this is used for RAID10 with Perc9 as well
                             Non_R10_OnDeleteSpan(SpanName);
                           }
                          
                         if(parent.frames["SELECTION_TABLE"].FourDArray.length+parent.frames["SELECTION_TABLE"].ThreeDArray.length+parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY.length+parent.frames["SELECTION_TABLE"].MIRROR_IN_PROGRESS_ARRAY.length == 0)
                            {
                                   parent.frames.OnSpanLengthChangeHandler('<xsl:value-of select="$PARAM_PREV_Layout"/>');
                                   parent.frames["SELECTION_TABLE"].autoDeleteAllSpan = false;
                            } 
                            else
                            { 
                                
                                 
                                
								parent.frames["SELECTION_TABLE"].EnableUnCheckedArrayDisks();
							
                                       
                            }
                          parent.frames["SELECTION_TABLE"].EnableDisableEnclosures();     


                        }
                        function Non_R10_OnDeleteSpan(SpanName)
				{
					var deletedSpanArray = new Array();
					var SpanNum=0;
					var flagSpanFound = 0;
					<!-- get span number from SpanName . Total span possible is 8-->
					for(var k=0; k&lt; JS_GLOBAL_MaxNumSpans; k++)
					{
						if( SpanName == "Span "+k.toString())
						{
							SpanNum=k;
							flagSpanFound = 1;
							break;
						}
					}
					
					if(flagSpanFound == 0)
						return;
				
					<!-- first check to see if span being deleted has already been added to ThreeDArraySpan-->
					<!-- if not, it is the current span -->
					if( (deletedSpanArray = parent.frames["SELECTION_TABLE"].Non_R10_getArrayDisksInGivenSpan(SpanName)) != null )
					{ 
						var len = deletedSpanArray.length;
						for(var i=0; i&lt; len; i++)
						{
							OnDelete(deletedSpanArray[i][0], deletedSpanArray[i][1], deletedSpanArray[i][2]);
							<!-- when user clicked AddSpan, the checkboxes for arraydisks in that span were disabled in result table, enable them now-->
							EnableArrayDiskCheckBoxInGivenSpan(SpanNum,deletedSpanArray[i][0], deletedSpanArray[i][1], deletedSpanArray[i][2] );
						}
						parent.frames["SELECTION_TABLE"].Non_R10_OnDeleteSpan(SpanName,deletedSpanArray.length);
						
					}
					else if( (deletedSpanArray =parent.frames["SELECTION_TABLE"].getSelectedAndEnabledArrayDisks()) != null)
					{  
						var len = deletedSpanArray.length;
						for(var i=0; i&lt; len; i++)
						{
							OnDelete(deletedSpanArray[i][0], deletedSpanArray[i][1], deletedSpanArray[i][2]);
							<!-- 
                                           user clicked AddSpan, the checkboxes for arraydisks in that span were disabled in result table, enable them now-->
							EnableArrayDiskCheckBoxInGivenSpan(SpanNum,deletedSpanArray[i][0], deletedSpanArray[i][1], deletedSpanArray[i][2] );
						}
						parent.frames["SELECTION_TABLE"].Non_R10_OnDeleteSpan(SpanName,deletedSpanArray.length);
					}

					//Following code will be called only for deletion of span in sliced span vd	
					if (parent.frames["SELECTION_TABLE"].autoDeleteAllSpan)
					{
						for(var j=0; j&lt; parent.frames["SELECTION_TABLE"].ThreeDArray.length; j++)
						{
							var newSpanName = "Span "+j.toString();
							OnDeleteSpan(newSpanName);
						}
                                    // need to change sanjeev
                                    parent.frames["SELECTION_TABLE"].unSelectAllCheckBoxes();
						

				    		parent.frames["SELECTION_TABLE"].enableAllCheckBoxes();
                                    parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY=new Array;
                                    if(parent.document.getElementById("Spans")!=null &amp;&amp; parent.document.getElementById("Spans").disabled==false)
                                    {
                                         parent.frames["SELECTION_TABLE"].setSpanLengthValue(parent.document.getElementById("Spans").value);
                                    }
                                    if(parent.document.getElementById("SingleSpans")!=null &amp;&amp; parent.document.getElementById("SingleSpans").disabled==false)
                                    {
                                    	parent.frames["SELECTION_TABLE"].setSpanLengthValue(parent.document.getElementById("SingleSpans").value);
                                    }
				     }

				}
				
				function R10_OnDeleteSpan(SpanName)
				{ 
                            
				 var deletedSpanArray = new Array();
				 var SpanNum=0;
				 var MirrorSet=0;
				 var flagSpanFound = 0;
				<!-- get span number from SpanName . Total span possible is 8-->
					for(var k=0; k&lt; JS_GLOBAL_MaxNumSpans; k++)
					{
						if( SpanName == "Span "+k.toString())
						{
							SpanNum=k;
							flagSpanFound = 1;
							break;
						}
					}
					
					if(flagSpanFound == 0)
						return;
				
                              
					<!-- first check to see if span being deleted has already been added to FourDArraySpan-->
					<!-- if not, it is the current span -->
                             k=0;
                             deletedSpanArray =  parent.frames["SELECTION_TABLE"].R10_getArrayDisksInGivenSpan(SpanName); // i is mirror set and j is the index of disk inside mirror set                                          
                             
                             	if( deletedSpanArray != null )
					{ 
						var len = deletedSpanArray.length;
						for(var i=0; i&lt; len; i++)
						{
							      //OnDelete(deletedSpanArray[i][0], deletedSpanArray[i][1], deletedSpanArray[i][2]);
							      <!-- when user clicked AddSpan, the checkboxes for arraydisks in that span were disabled in result table, enable them now-->
								MirrorSet= Math.floor(i/2);
								R10_EnableArrayDiskCheckBoxInGivenSpan(MirrorSet, SpanNum,deletedSpanArray[i][0], deletedSpanArray[i][1], deletedSpanArray[i][2] );
				            } 
                                     
                                    
            
			 	            parent.frames["SELECTION_TABLE"].R10_OnDeleteSpan(SpanName,deletedSpanArray);
 				      }
                              else
                              {      
                                       deletedSpanArray = new Array();
                                       if(parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY.length &gt;0)
                                        {
                                    
                                                for(i=0;i&lt; parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY.length; i++)
                                                {
                                                      for(j=0;j&lt;parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY[i].length ;j++)
                                                      {
                                                              deletedSpanArray[k++]=parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY[i][j];
                                                
                                                      }
                                                } 
                                          }
                                         
                                          if(parent.frames["SELECTION_TABLE"].MIRROR_IN_PROGRESS_ARRAY.length &gt;0)
                                          {                                      
                                                 for(i=0;i&lt; parent.frames["SELECTION_TABLE"].MIRROR_IN_PROGRESS_ARRAY.length; i++)
                                                 {
                                                 	deletedSpanArray[k++]=parent.frames["SELECTION_TABLE"].MIRROR_IN_PROGRESS_ARRAY[i];
                                                 }  
                                           }
                                          
                                           if( deletedSpanArray != null )
					             {        
						              var len = deletedSpanArray.length;
						              for(var i=0; i&lt; len; i++)
						               {
							                   //OnDelete(deletedSpanArray[i][0], deletedSpanArray[i][1], deletedSpanArray[i][2]);
                                                
							                   <!-- when user clicked AddSpan, the checkboxes for arraydisks in that span were disabled in result table, enable them now-->
								             MirrorSet= Math.floor(i/2);
								             R10_EnableArrayDiskCheckBoxInGivenSpan(MirrorSet, SpanNum,deletedSpanArray[i][0], deletedSpanArray[i][1], deletedSpanArray[i][2] );
				                            } 
                                                   

			 	                            parent.frames["SELECTION_TABLE"].R10_OnDeleteSpan(SpanName,deletedSpanArray);
 				                    }
  
                               }
                              
					//Following code will be called only for deletion of span in sliced span vd	
					if (parent.frames["SELECTION_TABLE"].autoDeleteAllSpan)
					{  
						for(var j=0; j&lt; parent.frames["SELECTION_TABLE"].FourDArray.length; j++)
						{
							var newSpanName = "Span "+j.toString();
							OnDeleteSpan(newSpanName);
						}

                                    parent.frames["SELECTION_TABLE"].unSelectAllCheckBoxes();
						

				    		parent.frames["SELECTION_TABLE"].enableAllCheckBoxes();
                                    //parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY=new Array;
                                    if(parent.document.getElementById("Spans")!=null &amp;&amp; parent.document.getElementById("Spans").disabled==false)
                                    {
                                         parent.frames["SELECTION_TABLE"].setSpanLengthValue(parent.document.getElementById("Spans").value);
                                    }
                                    if(parent.document.getElementById("SingleSpans")!=null &amp;&amp; parent.document.getElementById("SingleSpans").disabled==false)
                                    {
                                    	parent.frames["SELECTION_TABLE"].setSpanLengthValue(parent.document.getElementById("SingleSpans").value);
                                   	}
					}

 				    
				}
                        function showArrayDiskInSpanTable(SpanNum,ChannelNum,EnclosureNum,TargetNum)
				{    
					var elemName="";
					if(ChannelNum==-1 &amp;&amp; TargetNum==-1)
					{   
						document.getElementById(JS_GLOBAL_SpanRowElemName1D[SpanNum]).style.display="";
                                  
					}
					else
					{
						elemName = "parentrow_"+"Span"+SpanNum.toString()+":"+ChannelNum.toString()+":"+EnclosureNum.toString()+":"+TargetNum.toString();
						if(document.getElementById(elemName) != null)
						{ 
							if(document.getElementById(JS_GLOBAL_SpanRowElemName1D[SpanNum])!=null)
							document.getElementById(JS_GLOBAL_SpanRowElemName1D[SpanNum]).style.display="";
							document.getElementById(elemName).style.display="";
							try{
								var chkBxName="Span"+SpanNum.toString()+ChannelNum.toString()+":"+EnclosureNum.toString()+":"+TargetNum.toString();
								document.getElementById(chkBxName).checked=true;
                                                                document.getElementById(chkBxName).disabled=false;
								var SpanChkBx = "Span "+SpanNum.toString();
								document.getElementById(SpanChkBx).checked=true;
							}catch(e){}
                                       
						}
                                
					}
					
				}
                        
				function R10_showArrayDiskInSpanTable(MirrorSet,SpanNum,ChannelNum,EnclosureNum,TargetNum)
				{
                           
				
				var elemName="";

				if(ChannelNum==-1 &amp;&amp; TargetNum==-1)
				{
				document.getElementById(JS_GLOBAL_SpanRowElemName1D[SpanNum]).style.display="";

				}
				else
				{
				      elemName = "parentrow_"+"Span"+SpanNum.toString()+MirrorSet+":"+ChannelNum.toString()+":"+EnclosureNum.toString()+":"+TargetNum.toString();

 				   if(document.getElementById(elemName) != null)
				   {
				          document.getElementById(JS_GLOBAL_SpanRowElemName1D[SpanNum]).style.display="";
                                  document.getElementById(JS_GLOBAL_MirrorRowElemName1D[SpanNum][MirrorSet]).style.display=""; 
				    	    document.getElementById(elemName).style.display="";
				    try{

				         var chkBxName="Span"+SpanNum.toString()+MirrorSet+ChannelNum.toString()+":"+EnclosureNum.toString()+":"+TargetNum.toString();
  				         document.getElementById(chkBxName).checked=true;
               			   document.getElementById(chkBxName).disabled=false;
  				         var SpanChkBx = "Span "+SpanNum.toString();
 				         document.getElementById(SpanChkBx).checked=true;
			 	     }catch(e){}

				   }
                                                   
                                         




				 }

				}
                        function DisableArrayDiskCheckBoxInGivenSpan(SpanNum, ChannelNum, EnclosureNum, TargetNum)
				{     
					var chkBxName = JS_GLOBAL_SpanRowChkbxName3D[SpanNum][ChannelNum][EnclosureNum][TargetNum];
					if(document.getElementById(chkBxName) != null)
					{
						document.getElementById(chkBxName).disabled = true;
					}
				}
				function R10_DisableArrayDiskCheckBoxInGivenSpan(MirrorSet,  SpanNum, ChannelNum, EnclosureNum, TargetNum)
				{

				SpanLength = parent.frames.getSpanLengthValue();
				for(var MirrorSet=0; MirrorSet&lt; SpanLength/2 ; MirrorSet++)
				{
				var chkBxName = JS_GLOBAL_SpanRowChkbxName3D[SpanNum][MirrorSet][ChannelNum][EnclosureNum][TargetNum];

				if(document.getElementById(chkBxName) != null)
				{

				document.getElementById(chkBxName).disabled = true;
				}
				}
}

                        function EnableArrayDiskCheckBoxInGivenSpan(SpanNum, ChannelNum, EnclosureNum, TargetNum)
				{
					var chkBxName = JS_GLOBAL_SpanRowChkbxName3D[SpanNum][ChannelNum][EnclosureNum][TargetNum];
					if(document.getElementById(chkBxName) != null)
					{
						document.getElementById(chkBxName).disabled = false;
					}
				}
				function R10_EnableArrayDiskCheckBoxInGivenSpan(MirrorSet, SpanNum, ChannelNum, EnclosureNum, TargetNum)
				{

				var chkBxName = JS_GLOBAL_SpanRowChkbxName3D[SpanNum][MirrorSet][ChannelNum][EnclosureNum][TargetNum];
				if(document.getElementById(chkBxName) != null)
				{
				document.getElementById(chkBxName).disabled = false;
				}
				}
                        
				function hideArrayDiskInSpanTable(SpanNum,ChannelNum,EnclosureNum,TargetNum)
				{
					var elemName="";
					if(ChannelNum==-1 &amp;&amp; EnclosureNum==-1 &amp;&amp; TargetNum==-1)
					{
						document.getElementById(JS_GLOBAL_SpanRowElemName1D[SpanNum]).style.display="none";
					}
					else
					{
						elemName = "parentrow_"+"Span"+SpanNum.toString()+":"+ChannelNum.toString()+":"+EnclosureNum.toString()+":"+TargetNum.toString();
						if(document.getElementById(elemName) != null)
						{ 
							document.getElementById(elemName).style.display="none";
							try{
								var chkBxName="Span"+SpanNum.toString()+ChannelNum.toString()+":"+EnclosureNum.toString()+":"+TargetNum.toString();
								document.getElementById(chkBxName).checked=false;
							}catch(e){}

						}
					}
					
				}
                        function R10_hideArrayDiskInSpanTable(SpanNum,ChannelNum,EnclosureNum,TargetNum)
				{ 

				var elemName="";
				if(ChannelNum==-1 &amp;&amp; EnclosureNum==-1 &amp;&amp; TargetNum==-1)
				{
				     if(parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY.length==0)
                                    {  
                                                    document.getElementById(JS_GLOBAL_SpanRowElemName1D[SpanNum]).style.display="none";
                                                    document.getElementById(JS_GLOBAL_MirrorRowElemName1D[SpanNum][0]).style.display="none";
                                                  
                                    }
                                    else if(parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY.length!=0 &amp;&amp; parent.frames["SELECTION_TABLE"].MIRROR_IN_PROGRESS_ARRAY.length!=0)
                                    { 
                                                    document.getElementById(JS_GLOBAL_MirrorRowElemName1D[SpanNum][parent.frames["SELECTION_TABLE"].SPAN_IN_PROGRESS_ARRAY.length]).style.display="none";
                                     }

				}
				
				else
				{       SpanLength = parent.frames.getSpanLengthValue();
				        for(var MirrorSet=0; MirrorSet&lt; SpanLength/2 ; MirrorSet++)
						{
							elemName = "parentrow_"+"Span"+SpanNum.toString()+MirrorSet+":"+ChannelNum.toString()+":"+EnclosureNum.toString()+":"+TargetNum.toString();
							if(document.getElementById(elemName) != null)
							{
								document.getElementById(elemName).style.display="none";
								try{
										var chkBxName="Span"+SpanNum.toString()+MirrorSet+ChannelNum.toString()+":"+EnclosureNum.toString()+":"+TargetNum.toString();
										document.getElementById(chkBxName).checked=false;
							         }
									 catch(e){}
							}
				             }
                         
                                   
                         }

				}

				function showResultTable()
				{
				hideResultTable();
				var elemName="";
				for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								elemName="Sel"+i.toString()+":"+k.toString()+":"+j.toString();
								if(parent.frames["SELECTION_TABLE"].document.getElementById(elemName) != null)
								{
									<!-- If checkbox is checked in selection table -->
									if (parent.frames["SELECTION_TABLE"].document.getElementById(elemName).checked == true)
									{
										<!-- Display corresponding row in result table -->
										try {
											document.getElementById(JS_GLOBAL_RowElemName1D[i][k]).style.display="";
										}catch(e){}
										try {
											document.getElementById(JS_GLOBAL_ChkbxRowName2D[i][k][j]).style.display="";
										}catch(e){}
										<!-- Check the corresponding checkbox in the result table -->
										try{
											document.getElementById(JS_GLOBAL_ChkbxElemName2D[i][k][j]).checked=true;
										}catch(e){}
									} else {
										<!-- Uncheck the corresponding checkbox in the result table -->
										try{
											document.getElementById(JS_GLOBAL_ChkbxElemName2D[i][k][j]).checked=false;
										}catch(e){}
									}
								}
							}
						}
					}
				}
				function OnDelete(ChannelNum,EnclosureId,TargetId)
				{     
                                        if(parent.frames["SELECTION_TABLE"].document.getElementById("Sel"+ChannelNum+":"+EnclosureId)!=null)
                                         { 
                                                     parent.frames["SELECTION_TABLE"].document.getElementById("Sel"+ChannelNum+":"+EnclosureId).checked=false; 
                                                     parent.frames["SELECTION_TABLE"].document.getElementById("Sel"+ChannelNum+":"+EnclosureId).disabled=false; 
                                         }
                                       
					if(parent.frames["SELECTION_TABLE"].document.getElementById("Sel"+ChannelNum+":"+EnclosureId+":"+TargetId) == null)
					{
						     return;
					}
					
					parent.frames["SELECTION_TABLE"].document.getElementById("Sel"+ChannelNum+":"+EnclosureId+":"+TargetId).checked =false;
					parent.frames["SELECTION_TABLE"].OnArrayDiskSelected(ChannelNum,EnclosureId,TargetId);
					
					if(parent.frames["SELECTION_TABLE"].IsSpanMode() == false)
					{
						showResultTable();
					}
                                
				}
                         
                                function GetIMStatus()
                                {
                                  return 1;
                                }
				function getSelectedArrayDisksObjIDs()
				{
					var elemName="";
					var resval="";
					var displayString="";
					var counter =0;
					
					for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
					{
						for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
						{
							for(var j=0;j&lt;MaxTargetsArray[i][k];j++)
							{
								if(document.getElementById(JS_GLOBAL_ChkbxRowName2D[i][k][j]) != null &amp;&amp; document.getElementById(JS_GLOBAL_ChkbxRowName2D[i][k][j]).style.display!="none")
								{
									resval = document.getElementById(JS_GLOBAL_ObjIDs2D[i][k][j]).value;
									if(counter == 0)
									{
										displayString = resval;
									}
									else
									{
										displayString = displayString + ":"+resval;
									}
									counter++;
								}
							}
						}
					}
					return displayString;
				}
				
				<xsl:if test="$PARAM_DSA_Rules='1'">
					<xsl:call-template name="getDSAScripts">
						<xsl:with-param name="PARAM_Screen_Name"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:with-param>
						<xsl:with-param name="PARAM_Exit_Wizard_URL"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</script>
			<SelectionData>
				<SelectionTable>					
					<Header>
						<Data value="{$strAdisksSelectedCVDAAS}"/>
					</Header>
					<xsl:choose>
						<xsl:when test="$PARAM_PREV_Layout='512' or $PARAM_PREV_Layout='2048' or $PARAM_PREV_Layout='4096' or $PARAM_PREV_Layout='262144' ">
							<xsl:call-template name="SpanLoop">
								<xsl:with-param name="testValue">
									<xsl:choose>
										<xsl:when test="$PARAM_PREV_Layout='512'"><xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID10"/></xsl:when>
										<xsl:when test="$PARAM_PREV_Layout='2048'"><xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID50"/></xsl:when>
										<xsl:when test="$PARAM_PREV_Layout='4096'"><xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID1Concat"/></xsl:when>
										<xsl:when test="$PARAM_PREV_Layout='262144'"><xsl:value-of select="$GLOBAL_VAR_MaxSpansForRAID60"/></xsl:when>
									</xsl:choose>
								</xsl:with-param>
                                          <xsl:with-param name="IntMirrorValue"><xsl:value-of select="$PARAM_CURR_IM"/></xsl:with-param>
					  <xsl:with-param name="Perc9Flag"><xsl:value-of select="$PARAM_PERC9"/></xsl:with-param>
                                       
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:for-each select="//ArrayDisks">
								<xsl:variable name="SASorSATA">
									<xsl:call-template name="IsSASorSATA">
										<xsl:with-param name="BusProtocol"><xsl:value-of select="DCStorageObject/BusProtocol"/></xsl:with-param>
										</xsl:call-template>
								</xsl:variable>
								<xsl:variable name="DiskInEnclosure">
									<xsl:call-template name="IsDiskInEnclosure">
										<xsl:with-param name="AttributesMask"><xsl:value-of select="DCStorageObject/AttributesMask"/></xsl:with-param>
									</xsl:call-template>
								</xsl:variable>
								<xsl:if test="count(DCStorageObject)!=0 and @EnclosureName">
									<xsl:choose>
										<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
											<xsl:call-template name="RenderResultTableParentRow">
												<xsl:with-param name="PARENT_NAME">Res<xsl:value-of select="DCStorageObject/Channel"/><xsl:value-of select="DCStorageObject/EnclosureID"/></xsl:with-param>
												<xsl:with-param name="CHILD_NAME_PREFIX">Res</xsl:with-param>
												<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type" select="@EnclosureType"/><xsl:with-param name="productid" select="@ProductID"/></xsl:call-template> (<xsl:value-of select="$strEnclosureID"/>&#160;<xsl:value-of select="DCStorageObject/EnclosureID"/>)</xsl:otherwise></xsl:choose></xsl:with-param>
												<xsl:with-param name="KEY_NAME">ADsForChannel</xsl:with-param>
												<xsl:with-param name="KEY_MATCH"><xsl:value-of select="@EnclosureName"/></xsl:with-param>
												<xsl:with-param name="RULES"><xsl:value-of select="$PARAM_DSA_Rules"/></xsl:with-param>
												<xsl:with-param name="CLEAR_FOREIGN_CONFIGENABLE"><xsl:value-of select="$PARAM_ClearForeignConfigEnable"/></xsl:with-param>
												<xsl:with-param name="MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$GLOBAL_VAR_MinDrivesForSelectedLayout"/></xsl:with-param>
                                                                                                <xsl:with-param name="FreeDisks"><xsl:value-of select="$GLOBAL_VAR_ArrayDiskCount"/></xsl:with-param>          
                                                                                                <xsl:with-param name="SpanEditMode"><xsl:value-of select="$PARAM_SPANEDITMODE"/></xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="RenderResultTableParentRow">
												<xsl:with-param name="PARENT_NAME">Res<xsl:value-of select="DCStorageObject/Channel"/><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/></xsl:with-param>
												<xsl:with-param name="CHILD_NAME_PREFIX">Res</xsl:with-param>
												<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type" select="@EnclosureType"/><xsl:with-param name="productid" select="@ProductID"/></xsl:call-template></xsl:otherwise></xsl:choose></xsl:with-param>
												<xsl:with-param name="KEY_NAME">ADsForChannel</xsl:with-param>
												<xsl:with-param name="KEY_MATCH"><xsl:value-of select="@EnclosureName"/></xsl:with-param>
												<xsl:with-param name="RULES"><xsl:value-of select="$PARAM_DSA_Rules"/></xsl:with-param>
												<xsl:with-param name="CLEAR_FOREIGN_CONFIGENABLE"><xsl:value-of select="$PARAM_ClearForeignConfigEnable"/></xsl:with-param>
												<xsl:with-param name="MIN_DRIVES_FOR_SELECTED_LAYOUT"><xsl:value-of select="$GLOBAL_VAR_MinDrivesForSelectedLayout"/></xsl:with-param>
                                                                                                <xsl:with-param name="FreeDisks"><xsl:value-of select="$GLOBAL_VAR_ArrayDiskCount"/></xsl:with-param>          
						                                                <xsl:with-param name="SpanEditMode"><xsl:value-of select="$PARAM_SPANEDITMODE"/></xsl:with-param>
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
							</xsl:for-each>		
						</xsl:otherwise>
					</xsl:choose>
				</SelectionTable>
			</SelectionData>
			<HiddenTable>
				<xsl:apply-templates select="//ArrayDisks/DCStorageObject" mode="ObjIDsForArrayDisks_HIDDEN_TABLE"/>
				<!--  CR54430: Values entered in the Raid configuration pages need to be cached (NEW)-->
				<!-- <xsl:call-template name="cachedValues"/> -->
			</HiddenTable>
		</DataArea>
	</xsl:template>
	<!--  CR54430: Values entered in the Raid configuration pages need to be cached (NEW)-->
	<!-- <xsl:template name="cachedValues">
		<Data type="hidden">
			<xsl:attribute name="name">CACHED_PARAMS</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="$CACHED_PARAMS"/></xsl:attribute>
		</Data>
	</xsl:template>  -->
	
	<!--This template creates a table that correlates ArrayDisk to their ObjIDs/-->
	<xsl:template match="ArrayDisks/DCStorageObject" mode="ObjIDsForArrayDisks_HIDDEN_TABLE">
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Data>
			<xsl:choose>
				<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
					<xsl:attribute name="name">OBJID<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="name">OBJID<xsl:value-of select="Channel"/><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
		</Data>
	</xsl:template>
	
<xsl:template name="SpanLoop">
		<xsl:param name="i" select="0"/>
		<xsl:param name="increment" select="1"/>
		<xsl:param name="testValue" select="8"/>
            <xsl:param name="IntMirrorValue" select="false"/>
	    <xsl:param name="Perc9Flag" select="false"/>
		<xsl:if test="$i &lt; $testValue ">
		
           		<Row tree="expand">
			<xsl:attribute name="name">Span<xsl:value-of select="$i"/></xsl:attribute>
			<ColumnData>
						<Data type="checkbox" colspan="2">
							<xsl:attribute name="name">Span<xsl:text> </xsl:text><xsl:value-of select="$i"/></xsl:attribute>
							<xsl:attribute name="value">
                                          <xsl:choose>
                                                <xsl:when test="$IntMirrorValue = 'true' and $PARAM_SPANEDITMODE !='true'">
                                                       <xsl:value-of select="$strIMArray"/>
                                                </xsl:when>
												  <xsl:when test="$Perc9Flag = 'true' and $PARAM_SPANEDITMODE!='true' and /OMA/Layout ='512' ">
                                                        <xsl:choose>
														<xsl:when test="not(/OMA/ArrayDisks/@EnclosureType) or (/OMA/ArrayDisks/@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/>
														</xsl:when>
														<xsl:otherwise>
														<xsl:call-template name="GetEnclosureType">
														<xsl:with-param name="type" select="/OMA/ArrayDisks/@EnclosureType"/>
														<xsl:with-param name="productid" select="/OMA/ArrayDisks/@ProductID"/>
														</xsl:call-template> (<xsl:value-of select="$strEnclosureID"/>&#160;<xsl:value-of select="/OMA/ArrayDisks/DCStorageObject/EnclosureID"/>)
														</xsl:otherwise></xsl:choose>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                        <xsl:value-of select="$strSpanCVDAAS"/><xsl:text>&#160;</xsl:text><xsl:value-of select="$i"/>
                                                </xsl:otherwise>
                                          </xsl:choose> 
                                          </xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$strSpanCVDAAS"/><xsl:text> </xsl:text><xsl:value-of select="$i"/></xsl:attribute>
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:OnDeleteSpan('Span<xsl:text> </xsl:text><xsl:value-of select="$i"/>')</xsl:attribute>
							<!-- Note: there is a space between tags <xsl:text></xsl:text> in the above line and needs to remain that way for delete span to work. Need to come up with a better idea to fix this.-->
						</Data>
			</ColumnData>
			<ChildrenRows>
				<xsl:choose>
                        <xsl:when test="($PARAM_PREV_Layout = '512' and $IntMirrorValue != 'true' and $Perc9Flag != 'true')"> 
					<xsl:call-template name="MirrorSets"><xsl:with-param name="SpanNumber"><xsl:value-of select="$i"/></xsl:with-param></xsl:call-template>
                        </xsl:when> 
                         <xsl:when test="($PARAM_PREV_Layout = '512' and $IntMirrorValue = 'true' and $PARAM_SPANEDITMODE='true')"> 
					<xsl:call-template name="MirrorSets"><xsl:with-param name="SpanNumber"><xsl:value-of select="$i"/></xsl:with-param></xsl:call-template>
                        </xsl:when>
					<xsl:when test="($PARAM_PREV_Layout = '512' and $IntMirrorValue != 'true' and $Perc9Flag = 'true' and $PARAM_SPANEDITMODE ='true')"> 
					<xsl:call-template name="MirrorSets"><xsl:with-param name="SpanNumber"><xsl:value-of select="$i"/></xsl:with-param></xsl:call-template>
                        </xsl:when>
 			      <xsl:otherwise>
                               <xsl:for-each select="//ArrayDisks">
					<xsl:for-each select="DCStorageObject">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
						<xsl:sort select="TargetID" data-type="number" order="ascending"/>
					
					<xsl:variable name="SASorSATA">
						<xsl:call-template name="IsSASorSATA">
							<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:variable name="DiskInEnclosure">
						<xsl:call-template name="IsDiskInEnclosure">
							<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
						</xsl:call-template>
					</xsl:variable>					
					<xsl:choose>
						<xsl:when test="$PARAM_DSA_Rules='1'">
							<xsl:call-template name="RenderArrayDiskResultAndSpanRow">
								<xsl:with-param name="ArrayDiskSpace"><xsl:value-of select="Length"/></xsl:with-param>
								<xsl:with-param name="PrefixName">Span<xsl:value-of select="$i"/></xsl:with-param>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<!--Filter array disks with zero freespace-->
							<xsl:if test="ContiguousFree != '0'">
								<xsl:call-template name="RenderArrayDiskResultAndSpanRow">
									<xsl:with-param name="ArrayDiskSpace"><xsl:value-of select="ContiguousFree"/></xsl:with-param>
									<xsl:with-param name="PrefixName">Span<xsl:value-of select="$i"/></xsl:with-param>
								</xsl:call-template>	
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
				</xsl:for-each>

 
                        </xsl:otherwise>
				</xsl:choose>
			</ChildrenRows>
		</Row>
			<xsl:call-template name="SpanLoop">
				<xsl:with-param name="i" select="$i+$increment"/>
				<xsl:with-param name="increment" select="$increment"/>
				<xsl:with-param name="testValue" select="$testValue"/>
                        <xsl:with-param name="IntMirrorValue"><xsl:value-of select="$PARAM_CURR_IM"/></xsl:with-param>
			<xsl:with-param name="Perc9Flag"><xsl:value-of select="$PARAM_PERC9"/></xsl:with-param>
						
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="MirrorSets">
		<xsl:param name="SpanNumber" select="0"/>
		<xsl:param name="MirrorCount" select="0"/>
		<xsl:param name="increment" select="1"/>
		<xsl:param name="testValue" select="$GLOBAL_VAR_MaxSpansForSelectedLayout + $GLOBAL_VAR_MaxSpansForSelectedLayout - 1"/>
		<Row tree="expand">
			<xsl:attribute name="name">Span<xsl:text></xsl:text><xsl:value-of select="$SpanNumber"/>Mirror<xsl:value-of select="$MirrorCount"/></xsl:attribute>
			<ColumnData>
						<Data colspan="2">
							<xsl:attribute name="name">Mirror <xsl:text></xsl:text><xsl:value-of select="$MirrorCount"/></xsl:attribute>
                                          <xsl:attribute name="value">Mirror <xsl:text></xsl:text><xsl:value-of select="$MirrorCount"/></xsl:attribute>
  					      </Data>
			</ColumnData>


			
			<ChildrenRows>
				<xsl:for-each select="//ArrayDisks">
					<xsl:for-each select="DCStorageObject">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
						<xsl:sort select="TargetID" data-type="number" order="ascending"/>

						<xsl:variable name="SASorSATA">
							<xsl:call-template name="IsSASorSATA">
								<xsl:with-param name="BusProtocol">
									<xsl:value-of select="BusProtocol"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="DiskInEnclosure">
							<xsl:call-template name="IsDiskInEnclosure">
								<xsl:with-param name="AttributesMask">
									<xsl:value-of select="AttributesMask"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$PARAM_DSA_Rules='1'">
								<xsl:call-template name="RenderArrayDiskResultAndSpanRow">
									<xsl:with-param name="ArrayDiskSpace">
										<xsl:value-of select="Length"/>
									</xsl:with-param>
									<xsl:with-param name="PrefixName">Span<xsl:value-of select="$SpanNumber"/><xsl:value-of select="$MirrorCount"/></xsl:with-param>
								<xsl:with-param name="MirrorCount"></xsl:with-param>
 
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<!--Filter array disks with zero freespace-->
								<xsl:if test="ContiguousFree != '0'">
									<xsl:call-template name="RenderArrayDiskResultAndSpanRow">
										<xsl:with-param name="ArrayDiskSpace">
											<xsl:value-of select="ContiguousFree"/>
										</xsl:with-param><xsl:with-param name="PrefixName">Span<xsl:value-of select="$SpanNumber"/><xsl:value-of select="$MirrorCount"/></xsl:with-param>
									</xsl:call-template>
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:for-each>
			</ChildrenRows>
		</Row>
		<xsl:if test="$MirrorCount &lt; $testValue ">
		<xsl:call-template name="MirrorSets">
			<xsl:with-param name="MirrorCount" select="$MirrorCount+$increment"/>
			<xsl:with-param name="SpanNumber" select="$SpanNumber"/>
			<xsl:with-param name="increment" select="$increment"/>
			<xsl:with-param name="testValue" select="$testValue"/>
		</xsl:call-template>
	</xsl:if>
		
	</xsl:template>
	</xsl:stylesheet>

