<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Confirm Import/Clear foreign config page.  The associated web plugin is the ControllerExecWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>

	<xsl:variable name="strPatrolReadAction">
		<xsl:choose>
			<xsl:when test="/OMA/Action = '2097152'">
				<xsl:value-of select="$strTitleStartPatRead"/>
			</xsl:when>
			<xsl:when test="/OMA/Action = '4194304'">
				<xsl:value-of select="$strTitleStopPatRead"/>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>

	<xsl:template match="OMA">
		<DataArea printable="false" email="false" validate="false" Refresh="false" export="false" exportdata="false">
			<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;Action=<xsl:value-of select="Action"/>&amp;help=cnprin"+"&amp;BackTo="+<xsl:value-of select="BackTo"/></xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strPatrolReadAction"/></xsl:attribute>

			<xsl:variable name="dfltBkPg">./DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;help=cnprin</xsl:variable >
			<xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
			<xsl:attribute name="backpagetarget"><xsl:call-template name="BackPage"><xsl:with-param name="defaultBackPage" select="$dfltBkPg"/></xsl:call-template></xsl:attribute>

			<PageTitle>
				<xsl:attribute name="display">
					<xsl:value-of select="ControllerName"/>
					<xsl:value-of select="$strColon"/>
					<xsl:value-of select="$strSpace"/>
					<xsl:value-of select="$strPatrolReadAction"/>
				</xsl:attribute>
			</PageTitle>

			<PromptText ignoreoncli="true">
				<xsl:choose>
					<xsl:when test="/OMA/Action = '2097152'">
						<xsl:value-of select="$strSubStartPatReadHeader1"/>
					</xsl:when>
					<xsl:when test="/OMA/Action = '4194304'">
						<xsl:value-of select="$strSubStopPatReadHeader1"/>
					</xsl:when>
				</xsl:choose>
			</PromptText>
		</DataArea>
	</xsl:template>

</xsl:stylesheet>
