<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../common/vdparttbl.xsl"/>
	<xsl:include href="../common/encltbl.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:template match="OMA">
		<DataArea>
			
			<!-- Determine which form of the cli was invoked.  This determines the page title. -->
			<xsl:choose>
				<xsl:when test="count(//UserInputError)>0">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="//UserInputError"/></xsl:attribute>
					</PageTitle>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="Partitions/DCStorageObject">
							
							<PageTitle>
								<xsl:attribute name="display">List of Partitions</xsl:attribute>
							</PageTitle>
							<xsl:apply-templates select="Partitions"/>
						</xsl:when>
						<xsl:otherwise>
							<PageTitle>
								<xsl:attribute name="display">Partitions Not found</xsl:attribute>
							</PageTitle>
						</xsl:otherwise>
					</xsl:choose>
					
						
					
				</xsl:otherwise>
			</xsl:choose>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="Partitions">
		<TableData>
			
                  <xsl:for-each select="DCStorageObject">    
			<Header>
				<xsl:call-template name="VirtualDiskPartitionTableHeader">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</Header>
			
				
				<xsl:call-template name="VirtualDiskPartitionTableRows">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
		</TableData>
	</xsl:template>
	
	

	<xsl:template match="OMAUserRights"/>
	<xsl:template match="*"/>
</xsl:stylesheet>