<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
         <xsl:include href="../common/hspoltbl.xsl"/>
      	<xsl:include href="../en/globals.xsl"/>
	<xsl:template match="/">
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strGlobalStorageProperties"/></xsl:attribute>
			</PageTitle>
			<TableData>
				<Header>
				        <Data name="STS" editable="false" type="ustring" align="left">
				            <xsl:attribute name="display"><xsl:value-of select="$strSmartThermalShutdown"/></xsl:attribute>
				            <xsl:attribute name="value"><xsl:value-of select="$strSmartThermalShutdown"/></xsl:attribute>
				        </Data>
				</Header>
			       <Row>
			            <Data  editable="false" type="ustring" ignoreonweb="true">
			            		<xsl:attribute name="name"><xsl:value-of select="$strSTS"/></xsl:attribute>
			            		<xsl:attribute name="value">
			            			<xsl:choose>
			            				<xsl:when test="/OMA/ArrayInfo/STSMode/DCStorageObject/SmartThermalShutdownMode">
			            					<xsl:choose>
			            						<xsl:when test="/OMA/ArrayInfo/STSMode/DCStorageObject/SmartThermalShutdownMode='1'">
			            							<xsl:value-of select="$strEnabled"/>
			            						</xsl:when>
					            				<xsl:otherwise>
			            							<xsl:value-of select="$strDisabled"/>
					            				</xsl:otherwise>
									</xsl:choose>
			            				</xsl:when>
			            				<xsl:otherwise>
	            							<xsl:value-of select="$strNotApplicable"/>
			            				</xsl:otherwise>
							</xsl:choose>
			            		</xsl:attribute>
			            </Data>
			       </Row>
			</TableData>
                        <TableData>
                               <SubHeader>
				       <xsl:attribute name="display"><xsl:value-of select="$strDedicatedHotSparePolicies"/></xsl:attribute>
			       </SubHeader>
                               <Header>
				      <xsl:call-template name="DedicatedHotSparePolicyHeaders">
                                          <xsl:with-param name="tasks">false</xsl:with-param>
                                      </xsl:call-template>    
                               </Header>  
                               <xsl:for-each select="OMA/ProtectionPolicies[1]/ProtectionEntry/DCStorageObject">
                                  <xsl:call-template name="DedicatedHotSparePolicyRows"/>
                               </xsl:for-each>
		        </TableData>
                        <TableData>
                               <SubHeader>
				       <xsl:attribute name="display"><xsl:value-of select="$strGlobalHotSparePolicies"/></xsl:attribute>
			       </SubHeader>
                               <Header>
				      <xsl:call-template name="GlobalHotSparePolicyHeaders"/>
                               </Header>  
                               <xsl:for-each select="OMA/ProtectionPolicies[2]/ProtectionEntry/DCStorageObject">
                                  <xsl:call-template name="GlobalHotSparePolicyRows">
                                      <xsl:with-param name="tasks">false</xsl:with-param>
                                  </xsl:call-template>    
                               </xsl:for-each>
		        </TableData>
		</DataArea>
	</xsl:template>
        <xsl:template match="OMAUserRights"/>
	<xsl:template match="*"/>
   </xsl:stylesheet>
