<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../common/vdtbl.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:template match="/">
		<DataArea>
			<xsl:variable name="slotNum">
				<xsl:choose>
					<xsl:when test="//VirtualDisks/@PCISlotNo = '-1' or //VirtualDisks/@PCISlotNo = '2147483648' or //VirtualDisks/@PCISlotNo = '0' ">
						<xsl:value-of select="$strEmbedded"/>
					</xsl:when>
					<xsl:when test="//VirtualDisks/@PCISlotNo = '2147483649'">
					<xsl:value-of select="'Not Available'"/>
					</xsl:when>
					<xsl:otherwise>Slot <xsl:value-of select="//VirtualDisks/@PCISlotNo"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<!-- Determine which form of the cli was invoked.  This determines the page title. -->
			<xsl:choose>			
			    <xsl:when test="count(/*/VirtualDisks/DCStorageObject[IsSSC='1']) &gt; 0">
			       <xsl:choose>
				        <xsl:when test="/*/VirtualDisks/@System='true'">
					    <!-- The command: omreport storage vdisk   was called -->
				  	        <PageTitle>
						        <xsl:attribute name="display"><xsl:value-of select="$strRptECDiskTitle1"/></xsl:attribute>
					        </PageTitle>
					    </xsl:when>
				        <!-- end of when test="count(/*/VirtualDisks)=1" -->
				        <xsl:otherwise>
					     <!-- A controller was provided on the command.  Figure out which version of the command was called -->
					        <xsl:choose>
						        <xsl:when test="count(/*/VirtualDisks/DCStorageObject)=1">
						 	    <!-- The command: omreport storage vdisk controller=id vdisk=id  was called -->
						            <PageTitle>
								         <xsl:attribute name="display"><xsl:value-of select="$strRptECDiskTitle2"/><xsl:value-of select="/*/VirtualDisks/DCStorageObject/LogicalDriveNum"/> on Controller <xsl:value-of select="//VirtualDisks/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
							        </PageTitle>
						        </xsl:when>
						        <xsl:otherwise>
							    <!-- The command: omreport storage vdisk controller=id  was called -->
							        <PageTitle>
								         <xsl:attribute name="display"><xsl:value-of select="$strRptECDiskTitle3"/><xsl:value-of select="//VirtualDisks/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
							        </PageTitle>
						        </xsl:otherwise>
					        </xsl:choose>
				        </xsl:otherwise>
			        </xsl:choose>
			       <xsl:apply-templates select="/*/VirtualDisks"/>
		        </xsl:when>
			    <xsl:otherwise>
		            <PageTitle>
				         <xsl:attribute name="display"><xsl:value-of select="$strRptECDiskTitle4"/></xsl:attribute>
			        </PageTitle>
			    </xsl:otherwise>
			</xsl:choose>
		</DataArea>
	</xsl:template>
	<xsl:template match="VirtualDisks">
		<xsl:variable name="slotNum">
			<xsl:choose>
				<xsl:when test="@PCISlotNo = '-1' or @PCISlotNo = '2147483648' or @PCISlotNo = '0' ">
					<xsl:value-of select="$strEmbedded"/>
				</xsl:when>
				<xsl:when test="@PCISlotNo = '2147483649'">
				<xsl:value-of select="'Not Available'"/>
				</xsl:when>
				<xsl:otherwise>Slot <xsl:value-of select="@PCISlotNo"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<TableData>
		   <xsl:if test="DCStorageObject/IsSSC='1'">
			<SubHeader>
				<xsl:attribute name="display">Controller <xsl:value-of select="@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
			</SubHeader>
		   	
			<Header>
				<xsl:call-template name="VirtualDiskTableHeader">
					<xsl:with-param name="tasks">false</xsl:with-param>
					<xsl:with-param name="ManageIsSSC">1</xsl:with-param>
				</xsl:call-template>
			</Header>
			</xsl:if>
     		<xsl:for-each select="DCStorageObject">
				<xsl:sort select="LogicalDriveNum" data-type="number" order="ascending"/>
				<xsl:if test="IsSSC='1'"><!-- Filter child VDs-->
				<xsl:call-template name="VirtualDiskTableRows">
					<xsl:with-param name="tasks">false</xsl:with-param>
					<xsl:with-param name="ManageIsSSC">1</xsl:with-param>
				</xsl:call-template>
				</xsl:if>
		    </xsl:for-each>
			
    	</TableData>
	</xsl:template>
</xsl:stylesheet>
