<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../common/emmtbl.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:template match="OMA">
		<DataArea>
			<PageTitle>
				<xsl:if test="count(EMM/DCStorageObject)='0'">
					<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="EMM/@EnclosureId"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="count(EMM/DCStorageObject) > '1'">
					<xsl:attribute name="display"><xsl:value-of select="$strTitle2"/><xsl:value-of select="EMM/@EnclosureId"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="count(EMM/DCStorageObject)='1'">
					<xsl:attribute name="display"><xsl:value-of select="$strTitle3"/><xsl:value-of select="EMM/DCStorageObject/Index"/> in Enclosure <xsl:value-of select="EMM/@EnclosureId"/></xsl:attribute>
				</xsl:if>
			</PageTitle>
			<xsl:choose>
				<xsl:when test="count(EMM/DCStorageObject)!=0">
					<TableData>
						<Header>
						<xsl:call-template name="EMMTableHeader"/>
						</Header>
						<xsl:for-each select="EMM/DCStorageObject">
							<xsl:sort select="Index" data-type="number" order="ascending"/>
							<xsl:call-template name="EMMTableRows"/>
						</xsl:for-each>
					</TableData>
				</xsl:when>
			</xsl:choose>				
		</DataArea>
	</xsl:template>
	<xsl:template match="OMAUserRights"/>
	<xsl:template match="*"/>
</xsl:stylesheet>


