#!/bin/sh

#fixup omreg
cat /opt/dell/srvadmin/etc/omreg.d/*.cfg /etc/compat-omreg.cfg > /opt/dell/srvadmin/etc/omreg.cfg 2>/dev/null ||:

##########################################
# Perform Data Engine configuration
##########################################
source /opt/dell/srvadmin/lib64/srvadmin-omilcore/Funcs.sh
DCECFG=$(GetRegVal /opt/dell/srvadmin/etc/omreg.cfg OMDataEngine.configtool)
DCICFG=$(GetRegVal /opt/dell/srvadmin/etc/omreg.cfg Instrumentation.configtool)

#$DCECFG command=addmpialias update=TRUE startuptype=automatic \
#        aliasname=ssimp \
#        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdsm_sm_ssimp.so" \
#        dispatchfn=OMSSIMP_SMMIBImplementerDispatch \
#        displayname="OMSM_SNMP_IMPLEMENTER"
if [ -n "$1" ]
then
	if [ "$1" == "upgrade" ]
	then
		$CLIREGUTIL /opt/dell/srvadmin/lib64/srvadmin-storage/storage.ini del
	fi
fi


# configure event logging
$DCECFG command=addepialias update=TRUE startuptype=automatic \
        aliasname=dcsipe \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdsm_sm_dcsipe.so" \
        dispatchfn=DCSIPE_SMEventImplementerDispatch \
        displayname="OMSM_EVENT_IMPLEMENTER"


DCICFG_CODES="2050 2051 2060 2061 2070 2071 2080 2081 2090 2091 2100 2101"
for code in $DCICFG_CODES
do
    $DCICFG command=addlrarespconfig \
            type=${code} \
            update=FALSE \
            settings=0 \
            epfname=
done

# configure Storage Services OM Data Populator
$DCECFG command=addpopalias update=TRUE startuptype=automatic \
        aliasname=ral \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdsm_sm_ral.so" \
        dispatchfn=RAL_SMPopulatorDispatch \
        displayname="OMSM_POPULATOR_IMPLEMENTER"

exit 0
