<?xml version="1.0" encoding="UTF-8"?>
<!-- Information in this document is subject to change without notice.
     (c) 1995- 2006 Dell Inc. All rights reserved. -->   
<!-- This is the XSL to render the Virtual Disks Information page.  The associated web plugin is the VDInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<xsl:template match="OMA">
		<xsl:call-template name="scripts"/>
		<DataArea backpagetarget="./DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin" printable="false" email="false" validate="true" Refresh="false" export="false" exportdata="false">
			<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.sm.webplugins.VDExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=<xsl:value-of select="VDiskOID"/>&amp;VDiskName=<xsl:value-of select="VDiskName"/>&amp;Action=524288&amp;help=vdmgmt</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strApplyChanges"/></xsl:attribute>
			
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCancel"/></xsl:attribute>
			<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;Action=blank&amp;help=vdprin</xsl:attribute>
			
			<script language="javascript">
				function init(){

					var readPolicyMask = '<xsl:value-of select="/OMA/Controllers/DCStorageObject/ReadPolicyMask"/>';
					var writePolicyMask = '<xsl:value-of select="/OMA/Controllers/DCStorageObject/WritePolicyMask"/>';
					var cachePolicyMask = '<xsl:value-of select="/OMA/Controllers/DCStorageObject/CachePolicyMask"/>';
                                        var diskcachePolicyMask = '<xsl:value-of select="/OMA/Controllers/DCStorageObject/DiskCachePolicyMask"/>';
                                        

					var defaultReadPolicy = '<xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultReadPolicy"/>';
					var defaultWritePolicy = '<xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultWritePolicy"/>';
					var defaultCachePolicy = '<xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultCachePolicy"/>';
                                        
                    
					if ((readPolicyMask == defaultReadPolicy) &amp;&amp; (writePolicyMask == defaultWritePolicy) &amp;&amp; (cachePolicyMask == defaultCachePolicy) &amp;&amp; (diskcachePolicyMask == ''))
					{
						disableButtons("submit","" ,"");
					}

				}

				function validate(){
					var readpolicy;
					var writepolicy;
					var cachepolicy;
                                        var diskcachepolicy;
					<!-- DFCT142239 - No error while changing policy of VD to same values -->
					<!-- Indravijay J. Gohil Adding in new variables that hold the old policy values-->
					var oldReadPolicy ='<xsl:value-of select="/OMA/VirtualDisks/DCStorageObject/ReadPolicy"/>';
					var oldWritePolicy ='<xsl:value-of select="/OMA/VirtualDisks/DCStorageObject/WritePolicy"/>';
                                        var oldCachePolicy ='<xsl:value-of select="/OMA/VirtualDisks/DCStorageObject/CachePolicy"/>';
					var oldDiskCachePolicy ='<xsl:value-of select="/OMA/VirtualDisks/DCStorageObject/DiskCachePolicy"/>';
					try{
						readpolicy = document.dataarea.ReadPolicy.value;
						writepolicy =document.dataarea.WritePolicy.value;
                                                cachepolicy=document.dataarea.CachePolicy.value;
						diskcachepolicy=document.dataarea.DiskCachePolicy.value;
					}catch(e){}<!-- cache policy not supported on Adaptec, hence try catch exception-->
					
					<!-- To fix DF106385 -->
					if (readpolicy == undefined || readpolicy == null)
					{
						readpolicy = '';
      					}	

					if (writepolicy == undefined || writepolicy == null)
					{
						writepolicy = '';
      					}
                                        if (cachepolicy == undefined || cachepolicy == null)
					{
						cachepolicy = '';
      					}	

					if (diskcachepolicy == undefined || diskcachepolicy == null)
					{
						diskcachepolicy = '';
      					}	
					
					<!-- DFCT142239 - No error while changing policy of VD to same values -->
					<!-- Indravijay J. Gohil Checking to see if the old values equal to the current values selected by the user, if so return false with an alert -->
					if ((readpolicy == oldReadPolicy) &amp;&amp; (writepolicy == oldWritePolicy) &amp;&amp; (cachepolicy == oldCachePolicy) &amp;&amp; (diskcachepolicy == oldDiskCachePolicy))
					{
						alert("<xsl:value-of select="$strSamePolicy"/>");
						return false;
					}
					
					disableButtons("submit","back" ,"");
					return true;
				}				
			</script>
			<PageTitle>
				<!-- &#160; is the white space character between vdname and $strTitle-->
				<xsl:attribute name="display"><xsl:value-of select="VDiskName"/>&#160;<xsl:value-of select="$strTitle"/></xsl:attribute>
			</PageTitle>
			<TableData name="T" display="">
				<xsl:if test="/OMA/Controllers/DCStorageObject/ReadPolicyMask">
					<Row>
						<Data><xsl:attribute name="value"><xsl:value-of select="$strReadPolicy"/></xsl:attribute></Data>
						<Data name="ReadPolicy" type="select">
			                        <Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetReadPolicy"><xsl:with-param name="readpolicy"><xsl:value-of 									select="/OMA/VirtualDisks/DCStorageObject/ReadPolicy"/></xsl:with-param></xsl:call-template></xsl:attribute>
			                            <xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/VirtualDisks/DCStorageObject/ReadPolicy"/></xsl:attribute>
                                            </Choice>
						    <xsl:call-template name="for-loop-list-box">
								<xsl:with-param name="Mask" select="/OMA/Controllers/DCStorageObject/ReadPolicyMask"/>
								<xsl:with-param name="currPolicy" select="/OMA/VirtualDisks/DCStorageObject/ReadPolicy"/>
								<xsl:with-param name="templateName" select="12"/>
						    </xsl:call-template>
						</Data>
					</Row>
				</xsl:if>
				<xsl:if test="/OMA/Controllers/DCStorageObject/WritePolicyMask">
					<Row>
						<Data><xsl:attribute name="value"><xsl:value-of select="$strWritePolicy"/></xsl:attribute></Data>
						<Data name="WritePolicy" type="select">
			                        <Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetWritePolicy"><xsl:with-param name="writepolicy"><xsl:value-of 									select="/OMA/VirtualDisks/DCStorageObject/WritePolicy"/></xsl:with-param></xsl:call-template></xsl:attribute>
			                            <xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/VirtualDisks/DCStorageObject/WritePolicy"/></xsl:attribute>
                                            </Choice>
							<xsl:call-template name="for-loop-list-box">
								<xsl:with-param name="Mask" select="/OMA/Controllers/DCStorageObject/WritePolicyMask"/>
								<xsl:with-param name="currPolicy" select="/OMA/VirtualDisks/DCStorageObject/WritePolicy"/>
								<xsl:with-param name="templateName" select="13"/>
							</xsl:call-template>
						</Data>
					</Row>
				</xsl:if>
                                <xsl:if test="/OMA/Controllers/DCStorageObject/CachePolicyMask">
					<Row>
						<Data><xsl:attribute name="value"><xsl:value-of select="$strCachePolicy"/></xsl:attribute></Data>
						<Data name="CachePolicy" type="select">
			                        <Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetCachePolicy"><xsl:with-param name="cachepolicy"><xsl:value-of 									select="/OMA/VirtualDisks/DCStorageObject/CachePolicy"/></xsl:with-param></xsl:call-template></xsl:attribute>
			                            <xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/VirtualDisks/DCStorageObject/CachePolicy"/></xsl:attribute>
                                            </Choice>
							<xsl:call-template name="for-loop-list-box">
								<xsl:with-param name="Mask" select="/OMA/Controllers/DCStorageObject/CachePolicyMask"/>
								<xsl:with-param name="currPolicy" select="/OMA/VirtualDisks/DCStorageObject/CachePolicy"/>
								<xsl:with-param name="templateName" select="14"/>
							</xsl:call-template>
						</Data>
					</Row>
				</xsl:if>
				<xsl:if test="/OMA/Controllers/DCStorageObject/DiskCachePolicyMask">
					<Row>
						<Data><xsl:attribute name="value"><xsl:value-of select="$strDiskCachePolicy"/></xsl:attribute></Data>
						<Data name="DiskCachePolicy" type="select">
			                        <Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetDiskCachePolicy"><xsl:with-param name="DiskCachePolicy"><xsl:value-of select="/OMA/VirtualDisks/DCStorageObject/DiskCachePolicy"/></xsl:with-param></xsl:call-template></xsl:attribute>
			                            <xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/VirtualDisks/DCStorageObject/DiskCachePolicy"/></xsl:attribute>
                                            </Choice>
							<xsl:call-template name="for-loop-list-box">
								<xsl:with-param name="Mask" select="/OMA/Controllers/DCStorageObject/DiskCachePolicyMask"/>
								<xsl:with-param name="currPolicy" select="/OMA/VirtualDisks/DCStorageObject/DiskCachePolicy"/>
								<xsl:with-param name="templateName" select="20"/>
							</xsl:call-template>
						</Data>
					</Row>
				</xsl:if>
			</TableData>
		</DataArea>
	</xsl:template>
</xsl:stylesheet>
