<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Virtual Disks Information page.  The associated web plugin is the VDInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="vdtbl.xsl"/>
	<xsl:import href="Utils.xsl"/>
	<xsl:template match="OMA">
		<xsl:variable name="isCluster">
				<xsl:choose>
					<xsl:when test="substring(/OMA/VirtualDisks/@AttributesMask,32,1)!='0'">1</xsl:when>
				  <xsl:otherwise>0</xsl:otherwise>
			 </xsl:choose>
		</xsl:variable>	
			
		<script language="javascript">
      function reloadPage()
      {
          document.location.href = top.gnv.appendVID(document.URL);
      }
      function PartitionRresh()
      {
	   var RefreshUrl= document.URL + "&amp;RefreshPartitions=true";
         document.location.href = top.gnv.appendVID(RefreshUrl);


      }  
      function getThisURL()
      {
      var cluster = <xsl:value-of select="$isCluster"/>;
			var confirmresponse = 0;
                          var url = GetLocalUrl();
                          
			
			if(cluster == 1)
			{ 									
					var msg = "<xsl:value-of select="$strClusterCreate"/>";
					confirmresponse = confirm(msg);
			}
			
			if((cluster == 1 &amp;&amp; confirmresponse) || cluster == 0)
                        {
                       
                       document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.LaunchCreateVDWizardSubmitWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;OrigURL=" + url+"&amp;ManageSSC="+<xsl:value-of select="//ManageSSC"/>);
  		       document.dataarea.submit();
			}
                        
		}
		
		
		</script>
	
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
            <xsl:variable name="GLOBAL_VAR_VD_Status">
		     <xsl:for-each select="//VirtualDisks/DCStorageObject[IsSSC != '1']">
			     <xsl:value-of select="TreeStatus"/>
			     <xsl:if test="position() != last()"><xsl:text>;</xsl:text></xsl:if>
		      </xsl:for-each>
	      </xsl:variable>
            <xsl:variable name="GLOBAL_VAR_SSC_Status">
		     <xsl:for-each select="//VirtualDisks/DCStorageObject[IsSSC = '1']">
			     <xsl:value-of select="TreeStatus"/>
			     <xsl:if test="position() != last()"><xsl:text>;</xsl:text></xsl:if>
		      </xsl:for-each>
	      </xsl:variable>
           <xsl:variable name="Page_component_status">
			<xsl:choose>
				<xsl:when test="//ManageSSC = '1'"><xsl:value-of select="$GLOBAL_VAR_SSC_Status"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$GLOBAL_VAR_VD_Status"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>


              
		<DataArea backpagetarget="./DataArea?plugin=com.dell.sm.webplugins.ControllerWebPlugin" onLoad="true">
			<xsl:call-template name="scripts"/>
			<script language="javascript">
				function initializationRoutine()
				{
					<!-- DF27306 - Selecting vdisk does not display constituent array disks in aparticular scenario
						This defect was reported in 1.4. A fix for DFCT116290 actually broke the page. At this time, 
						the OMSA team is unable to root cause this issue. Reverting to original behavior since 
						original issue is cosmetic in nature. (GKV)
						Original defect: 
							DFCT116290 - OMSS1.0 Pointer to Storage Tree on Left not changing correponding to Page -->
					<!-- Commenting out
					var compid = "VD"+"<xsl:value-of select="/OMA/ControllerOID"/>";
					parent.ct._select(compid);
					-->
				}
			</script>
			<PageTitle>
				<xsl:choose>					
					<xsl:when test="VirtualDisks/@ControllerName=''">				
						<xsl:choose>
							<xsl:when test="count(VirtualDisks/DCStorageObject)>0">
								<xsl:attribute name="status">
                                                                    <xsl:choose>
                                                                          <xsl:when test="contains($Page_component_status,'3')">3</xsl:when>
                                                                          <xsl:when test="contains($Page_component_status,'4')">4</xsl:when>
                                                                          <xsl:when test="contains($Page_component_status,'2')">2</xsl:when>                                                          
                                                                          <xsl:otherwise><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:otherwise>
                                                                     </xsl:choose>
                                                               </xsl:attribute>
							</xsl:when>
						</xsl:choose>
						<xsl:choose>
                                                    <xsl:when test="//ManageSSC='1'">   						
							<xsl:attribute name="display"><xsl:value-of select="$strSSCTitle"/></xsl:attribute>
					            </xsl:when>
                                                    <xsl:otherwise>
                                                        <xsl:attribute name="display"><xsl:value-of select="$strTitle"/></xsl:attribute>
                                                    </xsl:otherwise>
                                                </xsl:choose> 
					</xsl:when>
					<xsl:when test="VirtualDisks/@ControllerName!=''">
						<xsl:choose>
							<xsl:when test="count(VirtualDisks/DCStorageObject)>0">
								<xsl:attribute name="status"><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:attribute>
							</xsl:when>
						</xsl:choose>
                                                <xsl:choose>
                                                    <xsl:when test="//ManageSSC='1'">   						
							<xsl:attribute name="display"><xsl:value-of select="$strTitleSSC2Part1"/><xsl:value-of select="VirtualDisks/@ControllerName"/><xsl:value-of select="$strTitleSSC2Part2"/></xsl:attribute>
					            </xsl:when>
                                                    <xsl:otherwise>
                                                        <xsl:attribute name="display"><xsl:value-of select="$strTitle2Part1"/><xsl:value-of select="VirtualDisks/@ControllerName"/><xsl:value-of select="$strTitle2Part2"/></xsl:attribute>
                                                    </xsl:otherwise>
                                                </xsl:choose>   
					</xsl:when>
				</xsl:choose>
			</PageTitle>
			<CustomButton>
			<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href"></xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;help=vdprin&amp;ManageSSC=<xsl:value-of select="/OMA/ManageSSC"/>&amp;Return=true&amp;Refresh=true</xsl:attribute>
				</Data>
			</CustomButton>
                   <xsl:choose>
                   <xsl:when test= "//FluidCacheSuccess = '536870912'"> <!-- Enable fluid Cache -->
                                            
                                                             <AlertMessage>
                                                                     <xsl:attribute name="display"><xsl:value-of select="$strEnableFluidSuccess"/></xsl:attribute>
												<xsl:attribute name="status">2</xsl:attribute>
                                                             </AlertMessage>
                                                    
                     </xsl:when>
                     <xsl:when test= "//FluidCacheSuccess = '1073741824'"> <!-- Disable fluid Cache 1073741824 -->

                                            
                                                             <AlertMessage>
                                                                     <xsl:attribute name="display"><xsl:value-of select="$strDisableFluidCacheSuccess"/></xsl:attribute>
												<xsl:attribute name="status">2</xsl:attribute>
                                                             </AlertMessage>
                                                    
                     </xsl:when>
			   <xsl:when test= "//FluidCacheSuccess = '2147483648'"> <!-- Reactivate fluid Cache 2147483648-->

                                            
                                                             <AlertMessage>
                                                                     <xsl:attribute name="display"><xsl:value-of select="$strReactivateVDSuccess"/></xsl:attribute>
												<xsl:attribute name="status">2</xsl:attribute>
                                                             </AlertMessage>
                                                    
                     </xsl:when>
	
                  </xsl:choose>
			
			<!-- Check if the bit for CreateVD is true -->
			<xsl:variable name="isCreateVDOkay">
				<xsl:call-template name="IsCreateVDSupported">
					<xsl:with-param name="Mask">
						<xsl:value-of select="VirtualDisks/@CurrentMethodMask"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>	
                        
                        <xsl:if test="count(VirtualDisks/DCStorageObject)>0 and //Partitions ">
                            <CustomButton align="left">
						<Data formSubmit="true">
							<xsl:attribute name="display"><xsl:value-of select="$strRefreshPartition"/></xsl:attribute>
							<xsl:attribute name="href">javascript:PartitionRresh()</xsl:attribute>
						</Data>
                            </CustomButton>
                        </xsl:if>    
			<xsl:if test="$isCreateVDOkay='1'">
                      <xsl:if test="$checkAdmin='true'">
				<!--check to see if user had admin rights-->
					<CustomButton align="left">
						<Data formSubmit="true">
							<xsl:attribute name="display">
                                          <xsl:choose>
                                             <xsl:when test="//ManageSSC = '1'">
                                                 <xsl:value-of select="$strCreateSSC"/>
                                             </xsl:when>
                                             <xsl:otherwise>
                                                  <xsl:value-of select="$strCreateVDW"/>
                                             </xsl:otherwise>
                                            </xsl:choose>
                                           </xsl:attribute>
							<xsl:attribute name="href">javascript:getThisURL()</xsl:attribute>
						</Data>
					</CustomButton>				
			            </xsl:if>
                   </xsl:if>
									
			            
			<xsl:call-template name="VirtualDiskTable">
				<xsl:with-param name="tasks">
					<xsl:value-of select="$checkAdmin"/>
				</xsl:with-param>
			</xsl:call-template>
		</DataArea>
	</xsl:template>
	<xsl:template name="aVirtualDiskTable">
		<xsl:param name="tasks"/>
		<xsl:choose>
			<xsl:when test="count(VirtualDisks/DCStorageObject)>0">
				<!--CR49916 - auto refresh code-->
				<xsl:if test="VirtualDisks/DCStorageObject/Progress or VirtualDisks/DCStorageObject/ObjState = '268435456'">
	                         <HTMLData>
	                                  <script language="Javascript">
	                                  	<!--refresh page every 30secs when there is atleast one object with Progress associated with it -->
	                                          setTimeout("reloadPage()",30000) ;
	                                  </script>
	                         </HTMLData>
	                    </xsl:if>
				<TableData columnspacing="true">
					<SubHeader>
						
						<xsl:choose>
                                                    <xsl:when test="//ManageSSC='1'">   						
							<xsl:attribute name="display"><xsl:value-of select="$strSSCTitle"/></xsl:attribute>
					            </xsl:when>
                                                    <xsl:otherwise>
                                                        <xsl:attribute name="display"><xsl:value-of select="$strTitle"/></xsl:attribute>
                                                    </xsl:otherwise>
                                                </xsl:choose> 
					</SubHeader>
					<xsl:choose>
						<xsl:when test="count(VirtualDisks/DCStorageObject)>0">
							<PromptText ignoreoncli="true">
								<xsl:value-of select="$strPrompt"/>
							</PromptText>
						</xsl:when>
						<xsl:otherwise>
							<AlertMessage ignoreoncli="true">
								<xsl:attribute name="display"><xsl:value-of select="$strPrompt2"/></xsl:attribute>
							</AlertMessage>
						</xsl:otherwise>
					</xsl:choose>
                                        <xsl:choose>                                            
					<xsl:when test="count(VirtualDisks/DCStorageObject[IsSSC = '1']) >0">
                                             <Header>
						<xsl:call-template name="VirtualDiskTableHeader">
							<xsl:with-param name="tasks">
								<xsl:value-of select="$tasks"/>
							</xsl:with-param>
						</xsl:call-template>
					     </Header>
                                        </xsl:when> 
                                        <xsl:when test="count(VirtualDisks/DCStorageObject[IsSSC != '1']) >0" >
                                            <Header>
						<xsl:call-template name="VirtualDiskTableHeader">
							<xsl:with-param name="tasks">
								<xsl:value-of select="$tasks"/>
							</xsl:with-param>
						</xsl:call-template>
					     </Header>
                                             </xsl:when>
                                        
                                        </xsl:choose>
					<xsl:choose>
                                           <xsl:when test="//ManageSSC='1'">  <!-- Manage SSC Rows -->
                                             <xsl:for-each select="VirtualDisks/DCStorageObject[IsSSC = '1']">
  								<xsl:sort select="LogicalDriveNum" data-type="number" order="ascending"/>
									<xsl:call-template name="VirtualDiskTableRows">
										<xsl:with-param name="tasks">
											<xsl:value-of select="$tasks"/>
										</xsl:with-param>
										<xsl:with-param name="caller">./DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin!ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>!ControllerName=<xsl:value-of select="/OMA/ControllerName"/>!help=vdprin!Return=true!ManageSSC=<xsl:value-of select="/OMA/ManageSSC"/></xsl:with-param>
									</xsl:call-template>
							    </xsl:for-each>
                                      </xsl:when>
                                      <xsl:otherwise>                <!-- VDs Rows -->
                                             <xsl:for-each select="VirtualDisks/DCStorageObject">
  								<xsl:sort select="LogicalDriveNum" data-type="number" order="ascending"/>
									<xsl:call-template name="VirtualDiskTableRows">
										<xsl:with-param name="tasks">
											<xsl:value-of select="$tasks"/>
										</xsl:with-param>
										<xsl:with-param name="caller">./DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin!ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>!ControllerName=<xsl:value-of select="/OMA/ControllerName"/>!help=vdprin!Return=true</xsl:with-param>
									</xsl:call-template>
							    </xsl:for-each>
                                      </xsl:otherwise>
                                </xsl:choose>
                              
				</TableData>
			</xsl:when>
			<xsl:otherwise>
				<AlertMessage ignoreoncli="true">
						<xsl:attribute name="display"><xsl:value-of select="$strPrompt2"/></xsl:attribute>
			    </AlertMessage>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
        
        
        
        <xsl:template name="VirtualDiskTable">
		<xsl:param name="tasks"/>
                  <xsl:variable name="NonSSCVDsPresent">
			<xsl:choose>
				<xsl:when test="count(VirtualDisks/DCStorageObject) > count(VirtualDisks/DCStorageObject[IsSSC = '1'])">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
                      <xsl:when test="//ManageSSC='1'">  
                          <xsl:choose>
			      <xsl:when test="count(VirtualDisks/DCStorageObject[IsSSC = '1'])>0">
				<!--CR49916 - auto refresh code-->
				<xsl:if test="VirtualDisks/DCStorageObject/Progress or VirtualDisks/DCStorageObject/ObjState = '268435456'">
	                         <HTMLData>
	                                  <script language="Javascript">
	                                  	<!--refresh page every 30secs when there is atleast one object with Progress associated with it -->
	                                          setTimeout("reloadPage()",30000) ;
	                                  </script>
	                         </HTMLData>
	                    </xsl:if>
				<TableData columnspacing="true">
					<SubHeader>
                                            <xsl:attribute name="display"><xsl:value-of select="$strSSCTitle"/></xsl:attribute>
					</SubHeader>
                                      	<xsl:if test="count(VirtualDisks/DCStorageObject[IsSSC='1'])=0">
							<AlertMessage ignoreoncli="true">
								<xsl:attribute name="display"><xsl:value-of select="$strPromptSSC2"/></xsl:attribute>
							</AlertMessage>
                        		</xsl:if>
					<xsl:if test="count(VirtualDisks/DCStorageObject[IsSSC = '1']) >0">
                                             <Header>
						<xsl:call-template name="VirtualDiskTableHeader">
							<xsl:with-param name="tasks">
								<xsl:value-of select="$tasks"/>
							</xsl:with-param>
						</xsl:call-template>
					     </Header>
                                        </xsl:if> 
                                        <xsl:for-each select="VirtualDisks/DCStorageObject[IsSSC = '1']">
  								<xsl:sort select="LogicalDriveNum" data-type="number" order="ascending"/>
									<xsl:call-template name="VirtualDiskTableRows">
										<xsl:with-param name="tasks">
											<xsl:value-of select="$tasks"/>
										</xsl:with-param>
										<xsl:with-param name="caller">./DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin!ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>!ControllerName=<xsl:value-of select="/OMA/ControllerName"/>!help=vdprin!Return=true!ManageSSC=<xsl:value-of select="/OMA/ManageSSC"/></xsl:with-param>
									</xsl:call-template>
							    </xsl:for-each>
                                      </TableData>
			</xsl:when>
                        <xsl:otherwise>
				<AlertMessage ignoreoncli="true">
				 	<xsl:attribute name="display"><xsl:value-of select="$strPromptSSC2"/></xsl:attribute>
				</AlertMessage>
			</xsl:otherwise>
		</xsl:choose>
                </xsl:when>
                
                
                <xsl:otherwise>
                    <xsl:choose>
                    <xsl:when test="$NonSSCVDsPresent='1'">
				<!--CR49916 - auto refresh code-->
				<xsl:if test="VirtualDisks/DCStorageObject/Progress or VirtualDisks/DCStorageObject/ObjState = '268435456'">
	                         <HTMLData>
	                                  <script language="Javascript">
	                                  	<!--refresh page every 30secs when there is atleast one object with Progress associated with it -->
	                                          setTimeout("reloadPage()",30000);
	                                  </script>
	                         </HTMLData>
	                    </xsl:if>
				<TableData columnspacing="true">
					<SubHeader>
                                            <xsl:attribute name="display"><xsl:value-of select="$strTitle"/></xsl:attribute>
					</SubHeader>
					
						<xsl:if test="count(VirtualDisks/DCStorageObject[not(IsSSC) or IsSSC='0'])=0">
							<AlertMessage ignoreoncli="true">
								<xsl:attribute name="display"><xsl:value-of select="$strPrompt2"/></xsl:attribute>
							</AlertMessage>
						</xsl:if>
                                                                              
					<xsl:if test="$NonSSCVDsPresent='1'">
                                             <Header>
						<xsl:call-template name="VirtualDiskTableHeader">
							<xsl:with-param name="tasks">
								<xsl:value-of select="$tasks"/>
							</xsl:with-param>
						</xsl:call-template>
					     </Header>
                                        </xsl:if> 
                                        <xsl:for-each select="VirtualDisks/DCStorageObject[not(IsSSC)or IsSSC='0']">
  						<xsl:sort select="LogicalDriveNum" data-type="number" order="ascending"/>
                                                  
									<xsl:call-template name="VirtualDiskTableRows">
										<xsl:with-param name="tasks">
											<xsl:value-of select="$tasks"/>
										</xsl:with-param>
										<xsl:with-param name="caller">./DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin!ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>!ControllerName=<xsl:value-of select="/OMA/ControllerName"/>!help=vdprin!Return=true</xsl:with-param>
									</xsl:call-template>
                                                   
						</xsl:for-each>
                                      </TableData>
			</xsl:when>
                        <xsl:otherwise>
							
				<AlertMessage ignoreoncli="true">
					<xsl:attribute name="display"><xsl:value-of select="$strPrompt2"/></xsl:attribute>
				</AlertMessage>
			</xsl:otherwise>
                        </xsl:choose>
                </xsl:otherwise>    
                </xsl:choose>
	</xsl:template>
</xsl:stylesheet>

