<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Enclosure Information page.  The associated web plugin is the EnclosureInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:include href="Utils.xsl"/>
	<xsl:variable name="GLOBAL_VAR_TargetID"><xsl:value-of select="/OMA/ArrayDisks/DCStorageObject/TargetID"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxSlotLength">
	   <xsl:for-each select="/OMA/ArrayDisks">
	           <xsl:value-of select="@MaxSlotLength"/>
	   </xsl:for-each>	   
	</xsl:variable>
	
	<xsl:template match="OMA">
		<DataArea exportdata="false">
		    <xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strBackPageButton"/></xsl:attribute>
			<xsl:attribute name="backpagetarget"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>
			 
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle1Part1"/><xsl:value-of select="/*/ArrayDisks/@ControllerName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
			</PageTitle>
			
			 <CustomButton>
			<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webp
				  lugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.OccupancySlotReportWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;Name=<xsl:value-of select="/OMA/Name"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;Action=<xsl:value-of select="/OMA/Action"/>&amp;help=entktmp</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">#</xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data>
			</CustomButton>
			 			
			<xsl:call-template name="SlotOccupancyTable"/>
	</DataArea>
	</xsl:template>
	<xsl:template name="SlotOccupancyTable">
	<xsl:if test="ArrayDisks/@ControllerName != ''">
	  <xsl:for-each select="//ArrayDisks">
	  <xsl:sort select="@Channel" data-type="number" order="ascending"/>
	  <xsl:sort select="@EnclosureID" data-type="number" order="ascending"/>
	     <TableData name="{@EnclosureName}_{position()}" width="0%" nopadding="true">
			<xsl:choose>
				<xsl:when test="normalize-space(@EnclosureName) != 'BACKPLANE'">
		     <xsl:attribute name="display"><xsl:value-of select="$strEnclosure"/><xsl:value-of select="$strSpace"/><xsl:value-of select="@Channel"/>:<xsl:value-of select="@EnclosureID"/> (<xsl:value-of select="@EnclosureName"/>)</xsl:attribute>
		     <SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strEnclosure"/><xsl:value-of select="$strSpace"/><xsl:value-of select="@Channel"/>:<xsl:value-of select="@EnclosureID"/> (<xsl:value-of select="@EnclosureName"/>)</xsl:attribute>
			 </SubHeader>
				</xsl:when>
				<xsl:otherwise>
		     			<xsl:attribute name="display"><xsl:value-of select="@EnclosureName"/></xsl:attribute>
		     			<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="@EnclosureName"/></xsl:attribute>
			 		</SubHeader>
				</xsl:otherwise>
			</xsl:choose>
			 <xsl:call-template name="SlotOccupancyHeaders"/>
		     <xsl:call-template name="SlotOccupancyRows"/>
		  </TableData>
       </xsl:for-each>  	  
	  </xsl:if>
	</xsl:template>
	
	<xsl:template name="SlotOccupancyHeaders">
	<Header>
	      <xsl:for-each select="DCStorageObject">
		   <xsl:sort select="TargetID" data-type="number" order="ascending"/>
		         <Data name="TargetID" editable="false" type="ustring" align="center">
				   <xsl:attribute name="value"><xsl:value-of select="TargetID"/></xsl:attribute>
				 </Data>
		   </xsl:for-each>
    </Header>
    </xsl:template>
	
	<xsl:template name="SlotOccupancyRows">
	   <Row>
	     <xsl:choose>
		  <xsl:when test="@EnclosureName = 'MD1120' or @EnclosureName = 'MD1220'">
	      <xsl:for-each select="DCStorageObject">
		   <xsl:sort select="TargetID" data-type="number" order="ascending"/>
		    <xsl:choose>
		      <xsl:when test="ObjID != '' and  ObjState != '1024'">
			      <Data editable="false" type="icon" align="left" value="/sm/images/occupied_25_slot.gif">
			        <xsl:attribute name="alt">
					  <xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/> (<xsl:call-template name="GetState"><xsl:with-param name="state" select="ObjState"/></xsl:call-template>)<xsl:value-of select="$strSpace"/><xsl:value-of select="$strCapacity"/>:<xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="Length"/></xsl:with-param></xsl:call-template><xsl:value-of select="$strGB"/>
					</xsl:attribute>
			      </Data>
			  </xsl:when>
			  <xsl:otherwise>
			     <Data editable="false" type="icon" align="left" value="/sm/images/empty_25_slot.gif"/>
 			  </xsl:otherwise>
			</xsl:choose>  
		   </xsl:for-each>
		  </xsl:when>
		  <xsl:otherwise>
		    <xsl:for-each select="DCStorageObject">
		   <xsl:sort select="TargetID" data-type="number" order="ascending"/>
		    <xsl:choose>
		      <xsl:when test="ObjID != '' and  ObjState != '1024'">
			    <Data type="icon" align="center" value="/sm/images/occupied_slot.gif">
			       <xsl:attribute name="alt">
				       <xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/> (<xsl:call-template name="GetState"><xsl:with-param name="state" select="ObjState"/></xsl:call-template>)<xsl:value-of select="$strSpace"/><xsl:value-of select="$strCapacity"/>:<xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="Length"/></xsl:with-param></xsl:call-template><xsl:value-of select="$strGB"/>
				   </xsl:attribute>
    		     </Data>
			  </xsl:when>
			  <xsl:otherwise>
			     <Data type="icon" align="center" value="/sm/images/empty_slot.gif"/>
			  </xsl:otherwise>
			</xsl:choose>  
		   </xsl:for-each>
		  </xsl:otherwise>
		 </xsl:choose> 
      </Row>
	  <!--Row>
	      <xsl:for-each select="//ArrayDisks/DCStorageObject">
		   <xsl:sort select="TargetID" data-type="number" order="ascending"/>
		      <Data type="ustring" align="center" font="bold">
				  <xsl:if test="ObjID != ''">
				      <xsl:attribute name="value">
				         <xsl:call-template name="GetState">
					      <xsl:with-param name="state" select="ObjState"/>
					     </xsl:call-template>
				        </xsl:attribute>
				  </xsl:if>
				 </Data>
			   </xsl:for-each>
      </Row-->	
	  <xsl:if test="DCStorageObject//BusProtocol">
	  <Row>
	      <xsl:for-each select="DCStorageObject">
		   <xsl:sort select="TargetID" data-type="number" order="ascending"/>
		        <Data name="BusProtocol" editable="false" type="ustring" align="center" bold="true">
				  <xsl:if test="ObjID != '' and  ObjState != '1024'">
				   <xsl:attribute name="value">
				      <xsl:call-template name="GetBusProtocol">
					      <xsl:with-param name="Bus" select="BusProtocol"/>
					 </xsl:call-template>
				    </xsl:attribute>
				  </xsl:if>	
				</Data>
			</xsl:for-each>
      </Row>
     </xsl:if>	
     <xsl:if test="DCStorageObject//MediaType">	 
      <Row>
	      <xsl:for-each select="DCStorageObject">
		   <xsl:sort select="TargetID" data-type="number" order="ascending"/>
		        <Data name="MediaType" editable="false" type="ustring" align="center" bold="true">
				  <xsl:if test="ObjID != '' and  ObjState != '1024'">
				   <xsl:attribute name="value">
				      <xsl:call-template name="GetMediaType">
					      <xsl:with-param name="MediaType" select="MediaType"/>
					 </xsl:call-template>
				    </xsl:attribute>
				  </xsl:if>	
				</Data>
			</xsl:for-each>
      </Row>
	  </xsl:if>
	  
	  
	  <xsl:if test="count(//DCStorageObject/AttributesMask[substring(.,24,1)='1']) &gt; '0' or count(//DCStorageObject/AttributesMask[substring(.,25,1)='1']) &gt; '0'">
      <Row>
	      <xsl:for-each select="DCStorageObject">
		   <xsl:sort select="TargetID" data-type="number" order="ascending"/>
		         <Data name="HotSpare" editable="false" type="ustring" align="center" bold="true">
				  <xsl:if test="ObjID != '' and  ObjState != '1024'">
				     <xsl:choose>
			              <xsl:when test="substring(AttributesMask,24,1)='1'">
							        <xsl:attribute name="value"><xsl:value-of select="$strDHS"/></xsl:attribute>
						  </xsl:when>
				     </xsl:choose>  
					 <xsl:choose>
			              <xsl:when test="substring(AttributesMask,25,1)='1'">
						        <xsl:attribute name="value"><xsl:value-of select="$strGHS"/></xsl:attribute>
						  </xsl:when>
				     </xsl:choose>  
					
				  </xsl:if>	
				</Data> 
			</xsl:for-each>
      </Row>
      </xsl:if>
    </xsl:template>
</xsl:stylesheet>