<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Battery Delay Learn Cycle page.  The associated web plugin is the SetBatteryDelayLearnWebPlugin.java. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:import href="Utils.xsl"/>
    <xsl:import href="btrytbl.xsl"/>
    <xsl:template match="OMA">
        <DataArea validate="true" email="false" export="false" exportdata="false" printable="false">
		
				<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.sm.webplugins.BatteryExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;Name=<xsl:value-of select="/OMA/Name"/>&amp;BatteryOID=<xsl:value-of select="/OMA/BatteryOID"/>&amp;Action=4</xsl:attribute>
				<xsl:attribute name="submitdisplay"><xsl:value-of select="$strApply"/></xsl:attribute>
				
				<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCancel"/></xsl:attribute>
				<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.sm.webplugins.BattInfoWebPlugin&amp;HREF=<xsl:value-of select="HREF"/>&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/Name"/>&amp;BatteryOID=<xsl:value-of select="/OMA/BatteryOID"/>&amp;help=btprin</xsl:attribute>
				
				<xsl:call-template name="scripts"/>
		
            <PageTitle>
                <xsl:attribute name="display"><xsl:value-of select="$strTitle1Part1"/><xsl:value-of select="Batteries/@ControllerName"/><xsl:value-of select="$strTitle1Part2"/></xsl:attribute>
            </PageTitle>
            <CustomButton>
                <Data name="Refresh">
                    <xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
                    <xsl:attribute name="href"></xsl:attribute>
                    <xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
                </Data>
            </CustomButton>
            <ComboData>
				<ListData>
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>
						<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
					</SubHeader> 

					<xsl:for-each select="Batteries/DCStorageObject">
						<xsl:call-template name="BatteryList"/>
					</xsl:for-each>
				</ListData>
                <TableData>
                    <SubHeader>
                        <xsl:attribute name="display"><xsl:value-of select="$strSubHeader2"/></xsl:attribute>
                    </SubHeader>
                    <Row>
                        <Data name="SetDays" editable="false" type="ustring" align="left">
                            <xsl:attribute name="display"><xsl:value-of select="$strSetDays"/></xsl:attribute>
                            <xsl:attribute name="value"><xsl:value-of select="$strSetDays"/> (0 - 7)</xsl:attribute>
                        </Data>

                        <Data name="Days" editable="true" type="editbox" maxlength="1" align="left">
                            <xsl:attribute name="display"><xsl:value-of select="$strDays"/></xsl:attribute>
                            <xsl:attribute name="value">0</xsl:attribute>
                        </Data>

                        <Data name="SetHours" editable="false" type="ustring" align="left">
                            <xsl:attribute name="display"><xsl:value-of select="$strSetHours"/></xsl:attribute>
                            <xsl:attribute name="value"><xsl:value-of select="$strSetHours"/> (0 - 23)</xsl:attribute>
                        </Data>

                        <Data name="Hours" editable="true" type="editbox" maxlength="2" align="left">
                            <xsl:attribute name="display"><xsl:value-of select="$strHours"/></xsl:attribute>
                            <xsl:attribute name="value">0</xsl:attribute>
                        </Data>
                    </Row>
                </TableData>
            </ComboData>

            <script language="javascript">
					function validate() 
					{				
						var Days  = document.getElementById("Days");
						var Hours = document.getElementById("Hours");

						if (Days.value == "") {
							Days.value = 0;
						}

						if (Hours.value == "") {
							Hours.value = 0;
						}
						
						if (Days.value == 0 &amp;&amp; Hours.value == 0) {
						    alert("<xsl:value-of select="$strZero"/>");
						    return false;
						}

						if (!IsPositiveInt(Days.value) || Days.value &lt; 0 || Days.value &gt; 7) {
							Days.focus();
							alert("<xsl:value-of select="$strDaysInvalid"/>");
							Days.value = 0;
							return false;
						}
						
						if (!IsPositiveInt(Hours.value) || Hours.value &lt; 0 || Hours.value &gt; 23) {
							Hours.focus();
							alert("<xsl:value-of select="$strHoursInvalid"/>");
							Hours.value = 0;
							return false;
						}
						
						var TotalHours = (Days.value * 24) + (Hours.value * 1);
						if (TotalHours > <xsl:value-of select="Batteries/DCStorageObject/MaxLearnDelay"/>) {
							var TotalAllowedHours = <xsl:value-of select="Batteries/DCStorageObject/MaxLearnDelay"/>;
				
							var AllowedDays = (TotalAllowedHours / 24) | 0;
							var AllowedHours = TotalAllowedHours - (AllowedDays * 24);
					
							alert("<xsl:value-of select="$strErrorMaxLearn"/><xsl:value-of select="$strColon"/>\n" + "<xsl:value-of select="$strSetDays"/><xsl:value-of select="$strColon"/>" + " " + AllowedDays + "     " + "<xsl:value-of select="$strSetHours"/><xsl:value-of select="$strColon"/>" + " " + AllowedHours);
							Days.value = 0;
							Hours.value = 0;
							return false;
						}

						disableButtons("submit","back" ,"");						
						return true;
					}
				
					function IsPositiveInt(str)
					{
						var valid = "0123456789";
						var isNum=true;
						var ch;
					
						for (i = 0; i &lt; str.length &amp;&amp; isNum == true; i++) 
						{ 
							ch = str.charAt(i); 
							if (valid.indexOf(ch) == -1) 
							{
								isNum = false;
							}
						}
						return isNum;
					}
		
			</script>
        </DataArea>
    </xsl:template>
</xsl:stylesheet>
