<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Virtual Disks Information page.  The associated web plugin is the VDInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="vdtbl.xsl"/>
	<xsl:import href="Utils.xsl"/>
	<xsl:template match="OMA">
		<xsl:call-template name="scripts"/>
		<DataArea printable="false" email="false" validate="true" Refresh="false" exportdata="false" onLoad="true">

			<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;Action=rebuildrate&amp;help=cnprin&amp;</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strApply"/></xsl:attribute>

			<xsl:variable name="dfltBkPg">./DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;help=cnprin</xsl:variable >
			<xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
			<xsl:attribute name="backpagetarget"><xsl:call-template name="BackPage"><xsl:with-param name="defaultBackPage" select="$dfltBkPg"/></xsl:call-template></xsl:attribute>

			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="ControllerName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
			</PageTitle>

			<PromptText><xsl:value-of select="$strSubHeader1"/></PromptText>
            <xsl:call-template name="RebuildRate"/>
		</DataArea>
	</xsl:template>
	<xsl:template name="RebuildRate">
		<ComboData>
			<ListData>
				<xsl:variable name="showtasks">false</xsl:variable>

				<Data name="currentrate" editable="false" type="ustring" align="right">
					<xsl:attribute name="display"><xsl:value-of select="$strCurrentRate"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="/OMA/Rebuildrate"/></xsl:attribute>
					<xsl:attribute name="unit"> %</xsl:attribute>
				</Data>

				<Data name="rbldrate" type="editbox" maxlength="3" size="3" align="right">
					<xsl:attribute name="display"><xsl:value-of select="$strRate"/></xsl:attribute>
					<xsl:attribute name="value"/>
					<xsl:attribute name="unit"> %</xsl:attribute>
				</Data>

			</ListData>
		</ComboData>
		<script language="javascript">
		function initializationRoutine()
		{
			document.getElementById("rbldrate").focus();
			return;
		}

		function validate()
		{
			var text = document.getElementById("rbldrate").value;
			var inputval = document.dataarea.rbldrate.value;
			var oldval = '<xsl:value-of select="/OMA/Rebuildrate"/>';

      inputval = removeLeadingZeros(inputval);

      // check that this isn't zero.
      if (text.length &lt; 1)
			{
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strErrorNumeric"/>");
					return false;
			}

			if( /^[0-9]*$/.test(text))
			{  //make sure it's a number you are dealing with
				if( text > 100 || 0 > text )
				{  //make sure the # is not greater than 100 or less than 0
					alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strErrorNumeric"/>");
					document.getElementById("rbldrate").value = "";
					document.getElementById("rbldrate").focus();
					return false;
				}
				else
				{
					// make sure the new value and old value are different
					if ( inputval == oldval)
					{
						alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strErrorEqual"/>");
						document.getElementById("rbldrate").value = "";
						document.getElementById("rbldrate").focus();
						return false;
					}
					else
					{
						disableButtons("submit","back" ,"");
						return true;
					}
				}
			}
			else
			{
					alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strErrorNumeric"/>");
					document.getElementById("rbldrate").value = "";
					document.getElementById("rbldrate").focus();
					return false;
			}
		}

	</script>

	</xsl:template>
</xsl:stylesheet>
