<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Controller Property  page.  The associated web plugin is the ChangeControllerWebPlugin.java -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>
	<xsl:variable name="GLOBAL_VAR_MinimumValue">30</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaximumValue">1440</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_IncrementValue">1</xsl:variable>
    <xsl:variable name="GLOBAL_VAR_ControllerFamily"><xsl:value-of select="/OMA/Controllers/DCStorageObject/ControllerFamily"/></xsl:variable>
	 <xsl:variable name="GLOBAL_VAR_SupportPowerSavings"><xsl:value-of select="/OMA/Controllers/DCStorageObject/SupportPowerSavings"/></xsl:variable>
	 <xsl:variable name="GLOBAL_VAR_MaximumValue_Hours">12</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaximumValue_Minutes">59</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MinimumValue_Hours">01</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MinimumValue_Minutes">00</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_END_MaxmumValue_Minutes">24</xsl:variable>
	
	<xsl:variable name="GLOBAL_VAR_SpindownTimeInterval">SpindownTimeInterval</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_StartTimeMinutes">StartTimeMinutes</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_StartTimeHours">StartTimeHours</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_EndTimeMinutes">EndTimeMinutes</xsl:variable>
    <!--Added below variable to identify H330 controller for power management options -->
	<xsl:variable name="GLOBAL_VAR_H330Controller">
		<xsl:choose>
			  <xsl:when test="substring(//Controllers/DCStorageObject/AttributesMask1,32,1)='1'">1</xsl:when>
			  <xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:template match="OMA">
		<xsl:call-template name="scripts"/>
		<DataArea backpagetarget="./DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin" printable="false" email="false" validate="true" Refresh="false" exportdata="false" onLoad="true">
             
			  <BottomCustomButton>
		           <Data display="{$strApply}" formSubmit="true" href="javascript:submitPowerSettings()" id="submitbuttoncontent"/> 
	           </BottomCustomButton> 
              
			  <BottomCustomButton>
		           <Data formSubmit="true">
				   <xsl:attribute name="display"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
				   <xsl:attribute name="href"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>
		           </Data>
		      </BottomCustomButton>
 			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="Controllers/@ControllerName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
			</PageTitle>
			<script language="javascript" src="/oma/js/UtilPM.js"/>
			<script language="javascript">
	    var lastobjcmd;
		var curobjcmd;
		var lastobjcmd1;
		var curobjcmd1;
		var cmdModified = false;
		var _enabled = false;
		var _settime_enabled = false;
		var powersavingmode = '<xsl:value-of select="//DimmerPowerSavingMode"/>';
		//initialze
	     function initializationRoutine()
		{  
		  
		   if((document.getElementById("NoPowerMode") != null) &amp;&amp; (powersavingmode == '1'))
		   {
		    
		     document.getElementById("NoPowerMode").checked = true;
			 OnOperationNoPowerModeSelected();
			 
		   }
           else if((document.getElementById("BalancedPowerMode") != null) &amp;&amp; (powersavingmode == '2'))
			{
			 
			  document.getElementById("BalancedPowerMode").checked = true;
			  OnOperationBalancedPowerModeSelected();
			  
			 
			}	
            else if((document.getElementById("MaximumPowerMode") != null) &amp;&amp; (powersavingmode == '3'))
            {
			  document.getElementById("MaximumPowerMode").checked = true;
			  OnOperationMaxPowerModeSelected();
            }
            else
            {
			  if(document.getElementById("CustomPowerMode") != null)
			  {
			    document.getElementById("CustomPowerMode").checked = true;
				
			  }	
			  OnOperationCustomPowerModeSelected();
			}
            			
		
		}
		
		function submitPowerSettings()
		{
		    var UnconfigDrives = document.getElementById("UnconfigDrives").value;
			var UnconfigHotspares = document.getElementById("UnconfigHotspares").value;
			var SpindownTimeInterval = document.getElementById("SpindownTimeInterval").value;
			
		   				
			if(validate() == false)
			return;
			
			var PageURL = "./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;UnconfigDrives="+UnconfigDrives+"&amp;UnconfigHotspares="+UnconfigHotspares+"&amp;SpindownTimeInterval="+SpindownTimeInterval+"&amp;Action=2147483648&amp;help=cnprin"
			if(document.getElementById("ConfigDrives") != null)
			{
			 var ConfigDrives = document.getElementById("ConfigDrives").value;
			 var idlec = document.getElementById("IdleC").value;
			 var starttime = document.getElementById("StartTimeHours").value + ":"+document.getElementById("StartTimeMinutes").value+":"+document.getElementById("AMPM").value;
		     var endtimeminutes = document.getElementById("EndTimeMinutes").value;
			 PageURL = PageURL + "&amp;ConfigDrives="+ConfigDrives+"&amp;idlec="+idlec+"&amp;StartTime="+starttime+"&amp;EndTimeMinutes="+endtimeminutes;
			
			  if(document.getElementById("QOSCheckBox").checked==true)
			  {
			    PageURL= PageURL + "&amp;QOSEnableFlag=1";
			  }
			  else
			  {
			    PageURL= PageURL + "&amp;QOSEnableFlag=0";
			  }
			}
			
		   	document.dataarea.action = top.gnv.appendVID(PageURL);
            document.dataarea.submit();
		}
		function OnOperationNoPowerModeSelected()
		{
		    // In H330 controller the below two radio buttons will be not available, therefore check is placed 
		    if(document.getElementById("MaximumPowerMode") != null)
			{
				document.getElementById("MaximumPowerMode").checked = false;
			}
			if(document.getElementById("CustomPowerMode") != null)
			{
				document.getElementById("CustomPowerMode").checked = false;
			}
			 document.getElementById("BalancedPowerMode").checked = false;
			 dimmerswitch_oldsettings(2);
		     dimmerswitch_newsettings(2);
		     _enabled = false;
			 _settime_enabled = false;
		}
		function OnOperationMaxPowerModeSelected()
		{  		 
		    document.getElementById("NoPowerMode").checked = false;
			document.getElementById("CustomPowerMode").checked = false;
			document.getElementById("BalancedPowerMode").checked = false;
			dimmerswitch_oldsettings(1);
			dimmerswitch_newsettings(1);
         	_enabled = false;
			_settime_enabled = false;
		}
		
		function OnOperationBalancedPowerModeSelected()
		{  
		  	var PercVersion = '<xsl:choose><xsl:when test="substring(//Controllers/DCStorageObject/AttributesMask1,24,1)='1'">9</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose>'; 
			document.getElementById("NoPowerMode").checked = false;
            // In H330 controller the below two radio buttons will be not available, therefore check is placed 
			if(document.getElementById("CustomPowerMode") != null)
			{
				document.getElementById("CustomPowerMode").checked = false;
			}
			if(document.getElementById("MaximumPowerMode") != null)
			{			
				document.getElementById("MaximumPowerMode").checked = false;
			}
			dimmerswitch_oldsettings(1);
			dimmerswitch_newsettings(2);
			// if percversion is 9 then Idle C value will be in enabled state but user cannot edit it
			if(PercVersion == 9)
			{
				changeIdleC(1);
			}
		    _enabled = false;
			_settime_enabled = false;
	    }
		// added function to support BalancedPowerMode for H330, H830 and H730 Controllers
		function changeIdleC(flag)
		{
			if(flag == 1)
			{
				if(document.getElementById("IdleC") != null)
				{
					document.getElementById("IdleC").disabled=true;
					document.getElementById("IdleC").value=flag;
				}
			}
		}
		function OnOperationCustomPowerModeSelected()
		{  
		   var oldval=new Array();
		   var qosenableflag = '<xsl:value-of select="//QOSEnableFlag"/>';
		   oldval[0]='<xsl:choose><xsl:when test="substring(//DimmerPropertyMask ,28,1)='1' or substring(//ChangeControllerPropertyMask ,28,1)='1'">2</xsl:when><xsl:when test="substring(//DimmerPropertyMask ,27,1)='1' or substring(//ChangeControllerPropertyMask ,27,1)='1'">1</xsl:when></xsl:choose>';
           oldval[1]='<xsl:choose><xsl:when test="substring(//DimmerPropertyMask ,26,1)='1' or substring(//ChangeControllerPropertyMask ,26,1)='1'">2</xsl:when><xsl:when test="substring(//DimmerPropertyMask ,25,1)='1' or substring(//ChangeControllerPropertyMask ,25,1)='1'">1</xsl:when></xsl:choose>';
           oldval[2]='<xsl:value-of select="/OMA/Controllers/DCStorageObject/SpinDownTime"/>';
		   oldval[3]='<xsl:choose><xsl:when test="substring(//DimmerPropertyMask ,24,1)='1'">2</xsl:when><xsl:when test="substring(//DimmerPropertyMask ,23,1)='1'">1</xsl:when></xsl:choose>';
		   oldval[4]='<xsl:choose><xsl:when test="substring(//DimmerPropertyMask ,22,1)='1'">2</xsl:when><xsl:when test="substring(//DimmerPropertyMask ,21,1)='1'">1</xsl:when></xsl:choose>';
		   oldval[5]='<xsl:value-of select="/OMA/Controllers/DCStorageObject/DisableLDPSInterval"/>';
		   oldval[6]='<xsl:value-of select="/OMA/Controllers/DCStorageObject/DisableLDPSTime"/>';
         
		  if((document.getElementById("CustomPowerMode") != null) &amp;&amp;(document.getElementById("CustomPowerMode").checked = 'true'))
		  { 
		    document.getElementById("NoPowerMode").checked = false;
			document.getElementById("MaximumPowerMode").checked = false;
			document.getElementById("BalancedPowerMode").checked = false;
			document.getElementById("UnconfigDrives").disabled=false;
			document.getElementById("UnconfigDrives").value=oldval[0];
			document.getElementById("UnconfigHotspares").disabled=false;
			document.getElementById("UnconfigHotspares").value=oldval[1];
			document.getElementById("ConfigDrives").disabled=false;
			document.getElementById("ConfigDrives").value=oldval[3];
			document.getElementById("IdleC").disabled=false;
			document.getElementById("IdleC").value=oldval[4];
			 if((document.getElementById("UnconfigDrives").value=='2') &amp;&amp; (document.getElementById("UnconfigHotspares").value=='2') &amp;&amp; (document.getElementById("ConfigDrives").value=='2') &amp;&amp; (document.getElementById("IdleC").value=='2'))
		     {
			    document.getElementById("SpindownTimeInterval").disabled=true;
				document.getElementById("StartTimeHours").disabled=true;
				document.getElementById("StartTimeMinutes").disabled=true; 
				document.getElementById("EndTimeMinutes").disabled=true; 
				document.getElementById("AMPM").disabled=true;
				document.getElementById("QOSCheckBox").disabled=true;
				_enabled = false;
				_settime_enabled = false;
				 
			 }
			 else
			 {
			    document.getElementById("SpindownTimeInterval").disabled=false;
				_enabled = true;
				if(document.getElementById("ConfigDrives").value=='2')
				{  
				    document.getElementById("StartTimeHours").disabled=true;
				    document.getElementById("StartTimeMinutes").disabled=true;
					document.getElementById("EndTimeMinutes").disabled=true;
					document.getElementById("AMPM").disabled=true;
					document.getElementById("QOSCheckBox").disabled=true;
					_settime_enabled = false;
                }
				
                if(document.getElementById("ConfigDrives").value=='1')
				{
				    document.getElementById("QOSCheckBox").disabled=false;
					if(qosenableflag == '1')
				    {
							document.getElementById("QOSCheckBox").checked = true;
							document.getElementById("StartTimeHours").disabled = false;
							document.getElementById("StartTimeMinutes").disabled = false;
							document.getElementById("EndTimeMinutes").disabled = false;
							document.getElementById("AMPM").disabled = false;
					}
					else
					{
					        document.getElementById("QOSCheckBox").checked = false;
							document.getElementById("StartTimeHours").disabled = true;
							document.getElementById("StartTimeMinutes").disabled = true;
							document.getElementById("EndTimeMinutes").disabled = true;
							document.getElementById("AMPM").disabled = true;
					}
					_settime_enabled = true;
                }			
				
			 }
	         
			 document.getElementById("EndTimeMinutes").value=oldval[5];
			 
		  }
		  else
		  { 
		    if(document.getElementById("UnconfigDrives") != null &amp;&amp; document.getElementById("UnconfigHotspares") != null)
			{
		    document.getElementById("UnconfigDrives").disabled=false;
			document.getElementById("UnconfigDrives").value=oldval[0];
			document.getElementById("UnconfigHotspares").disabled=false;
			document.getElementById("UnconfigHotspares").value=oldval[1];
			
			 if((document.getElementById("UnconfigDrives").value=='2') &amp;&amp; (document.getElementById("UnconfigHotspares").value=='2'))
		     { 
			    document.getElementById("SpindownTimeInterval").disabled=true;
				_enabled = false;
				 
			 }
			 else
			 {
			    document.getElementById("SpindownTimeInterval").disabled=false;
				_enabled = true;
			 }
			}
			
		  }
		     document.getElementById("SpindownTimeInterval").value=oldval[2];
			
		 
		}
		
		function dimmerswitch_oldsettings(flagValue)
		{
		    document.getElementById("UnconfigDrives").disabled=true;
			document.getElementById("UnconfigDrives").value=flagValue;
		    document.getElementById("UnconfigHotspares").disabled=true;
			document.getElementById("UnconfigHotspares").value=flagValue;
			document.getElementById("SpindownTimeInterval").disabled=true;
			document.getElementById("SpindownTimeInterval").value='30';
		    
		}
		
		function dimmerswitch_newsettings(flagValue)
		{
		     document.getElementById("ConfigDrives").disabled=true;
			 document.getElementById("ConfigDrives").value=flagValue;
			 document.getElementById("IdleC").disabled=true;
			 document.getElementById("IdleC").value=flagValue;
			 document.getElementById("StartTimeHours").disabled=true;
		     document.getElementById("StartTimeMinutes").disabled=true;
			 document.getElementById("EndTimeMinutes").disabled=true;
			 document.getElementById("EndTimeMinutes").value='<xsl:value-of select="//DisableLDPSInterval"/>';
			 document.getElementById("AMPM").disabled=true;
			 document.getElementById("QOSCheckBox").checked = false;
			 document.getElementById("QOSCheckBox").disabled=true;
		}
		//validate
		function validate() 
		{ 
		   var oldval=new Array();
		   var qosstatus = 0;
               var familynumber = '<xsl:value-of select="$GLOBAL_VAR_ControllerFamily"/>';
			   var supportpowersettings = '<xsl:value-of select="$GLOBAL_VAR_SupportPowerSavings"/>';
              
		   oldval[0]='<xsl:choose><xsl:when test="substring(//DimmerPropertyMask ,28,1)='1' or substring(//ChangeControllerPropertyMask ,28,1)='1'">2</xsl:when><xsl:when test="substring(//DimmerPropertyMask ,27,1)='1' or substring(//ChangeControllerPropertyMask ,27,1)='1'">1</xsl:when></xsl:choose>';
           oldval[1]='<xsl:choose><xsl:when test="substring(//DimmerPropertyMask ,26,1)='1' or substring(//ChangeControllerPropertyMask ,26,1)='1'">2</xsl:when><xsl:when test="substring(//DimmerPropertyMask ,25,1)='1' or substring(//ChangeControllerPropertyMask ,25,1)='1'">1</xsl:when></xsl:choose>';
           oldval[2]='<xsl:value-of select="/OMA/Controllers/DCStorageObject/SpinDownTime"/>';
		    oldval[3]='<xsl:choose><xsl:when test="substring(//DimmerPropertyMask ,24,1)='1'">2</xsl:when><xsl:when test="substring(//DimmerPropertyMask ,23,1)='1'">1</xsl:when></xsl:choose>';
			 oldval[4]='<xsl:choose><xsl:when test="substring(//DimmerPropertyMask ,22,1)='1'">2</xsl:when><xsl:when test="substring(//DimmerPropertyMask ,21,1)='1'">1</xsl:when></xsl:choose>';
			 oldval[5]='<xsl:value-of select="/OMA/Controllers/DCStorageObject/DisableLDPSInterval"/>';
			 oldval[6]='<xsl:value-of select="/OMA/UserSetTime0"/>';
			 oldval[6] = removeLeadingZeros(oldval[6]);
			 oldval[7]='<xsl:value-of select="/OMA/UserSetTime1"/>';
			 oldval[7] = removeLeadingZeros(oldval[7]);
			 oldval[8]='<xsl:value-of select="/OMA/UserSetTime2"/>';
			 oldval[8] = removeLeadingZeros(oldval[8]);
			 oldval[9]='<xsl:value-of select="//QOSEnableFlag"/>';
			 oldval[9] = removeLeadingZeros(oldval[9]);
			
		   var inputval=new Array(); 
           inputval[0]=document.dataarea.UnconfigDrives.value;
		   inputval[0] = removeLeadingZeros(inputval[0]);			
           inputval[1]=document.dataarea.UnconfigHotspares.value;
		   inputval[1] = removeLeadingZeros(inputval[1]);
           inputval[2]=document.dataarea.SpindownTimeInterval.value;
		   inputval[2] = removeLeadingZeros(inputval[2]); 
          			 
		   if(document.getElementById("CustomPowerMode") != null)
		  {  
		      inputval[3]=document.dataarea.ConfigDrives.value;
		      inputval[3] = removeLeadingZeros(inputval[3]); 
			  inputval[4]=document.dataarea.IdleC.value;
		      inputval[4] = removeLeadingZeros(inputval[4]); 
			  inputval[5]=document.dataarea.EndTimeMinutes.value;
		      inputval[5] = removeLeadingZeros(inputval[5]); 
			  inputval[6]=document.dataarea.StartTimeHours.value;
			  inputval[6] = removeLeadingZeros(inputval[6]);
			  inputval[7]=document.dataarea.StartTimeMinutes.value;
			  inputval[7] = removeLeadingZeros(inputval[7]);
			  inputval[8]=document.dataarea.AMPM.value;
			  inputval[8] = removeLeadingZeros(inputval[8]);
						  
			  if(document.dataarea.QOSCheckBox.checked == true)
			  {
			    qosstatus = 1;
			  }
			  else
			  {
			     qosstatus = 0;
			  }
			  
			  
			 if(document.getElementById("CustomPowerMode").checked == true)
			 { 
		      if(oldval[0]==inputval[0] &amp;&amp; oldval[1]==inputval[1] &amp;&amp; oldval[2]==inputval[2] &amp;&amp; oldval[3]==inputval[3] &amp;&amp; oldval[4]==inputval[4] &amp;&amp; oldval[5]==inputval[5] &amp;&amp; oldval[6]==inputval[6] &amp;&amp; oldval[7]==inputval[7] &amp;&amp; oldval[8]==inputval[8] &amp;&amp; oldval[9]==qosstatus)
		      {
		         alert("<xsl:value-of select="$strNoChangeInValue"/>");
			      return false;
		      }
		     if((inputval[5] &lt; 1 || inputval[5] &gt; 24) &amp;&amp; (document.getElementById("QOSCheckBox").checked == true))
              {
		         	alert("<xsl:value-of select="$strEndTimeHrs"/>");
		        	document.dataarea.EndTimeMinutes.value = oldval[5];
			        return false;
			  }	
			  if((inputval[6] &lt; 1 || inputval[6] &gt; 12) &amp;&amp; (document.getElementById("QOSCheckBox").checked == true))
              {
		         	alert("<xsl:value-of select="$strStartTimeHrs"/>");
		        	document.dataarea.StartTimeHours.value = oldval[6];
			        return false;
			  }
			  if((inputval[7] &lt; 0 || inputval[7] &gt; 59) &amp;&amp; (document.getElementById("QOSCheckBox").checked == true))
              {
		         	alert("<xsl:value-of select="$strStartTimeMinu"/>");
		        	document.dataarea.StartTimeMinutes.value = oldval[7];
			        return false;
			  }
			 } 
			  
			 /*  
			  if(document.getElementById("CustomPowerMode").checked == true)
			  {
				if((inputval[0] == 2) &amp;&amp; (inputval[1] == 2) &amp;&amp; (inputval[3] == 2) &amp;&amp; (inputval[4] == 2))
				{
					alert("No Power Setting");
				}
			  
				if((inputval[0] == 1) &amp;&amp; (inputval[1] == 1) &amp;&amp; (inputval[3] == 1) &amp;&amp; (inputval[4] == 1))
				{
					alert("Maximum Power Setting");
				}
			  
				if((inputval[0] == 1) &amp;&amp; (inputval[1] == 1) &amp;&amp; (inputval[3] == 2) &amp;&amp; (inputval[4] == 2))
				{
					alert("Balance Power Setting");
				}
			  }
			 */
			 
		   }
		   else
		   { 
		      if(oldval[0]==inputval[0] &amp;&amp; oldval[1]==inputval[1] &amp;&amp; oldval[2]==inputval[2])
		      {
		        alert("<xsl:value-of select="$strNoChangeInValue"/>");
			    return false;
		      }
		   }
		   
          if(familynumber &gt;= 8 &amp;&amp; supportpowersettings != 0)
          {
		if((document.getElementById("CustomPowerMode") != null) &amp;&amp; (document.getElementById("CustomPowerMode").checked == true))
	    {  
		  if(inputval[2] &lt; 30 || inputval[2] &gt; 1440)
          {
		   	alert("<xsl:value-of select="$strInvalidTimeIntr"/>");
			document.dataarea.SpindownTimeInterval.value = oldval[2];
			return false;
			
          }	
          }
          }
          else
          {
            if(inputval[2] &lt; 30 || inputval[2] &gt; 1440)
             {
		   	alert("<xsl:value-of select="$strInvalidTimeIntr"/>");
			document.dataarea.SpindownTimeInterval.value = oldval[2];
			return false;
			
            }	

          }
        		  
		   return true;
		}
		
		//onselect change
		function Onselect()
        { 
		  if((document.getElementById("CustomPowerMode") != null))
		  {
		      if((document.getElementById("UnconfigDrives").value=='2') &amp;&amp; (document.getElementById("UnconfigHotspares").value=='2') &amp;&amp; (document.getElementById("ConfigDrives").value=='2') &amp;&amp; (document.getElementById("IdleC").value=='2'))
		      {  
                  document.getElementById("SpindownTimeInterval").disabled=true;
				  document.getElementById("SpindownTimeInterval").value='<xsl:value-of select="/OMA/Controllers/DCStorageObject/SpinDownTime"/>';
				  document.getElementById("StartTimeHours").disabled=true;
				  document.getElementById("StartTimeHours").value='<xsl:value-of select="/OMA/UserSetTime0"/>';
				  document.getElementById("StartTimeMinutes").disabled=true; 
				  document.getElementById("StartTimeMinutes").value='<xsl:value-of select="/OMA/UserSetTime1"/>';
				  document.getElementById("EndTimeMinutes").disabled=true;
				  document.getElementById("EndTimeMinutes").value='<xsl:value-of select="/OMA/Controllers/DCStorageObject/DisableLDPSInterval"/>';
				  document.getElementById("AMPM").disabled=true;
				  document.getElementById("AMPM").value='<xsl:value-of select="/OMA/UserSetTime2"/>';
				  document.getElementById("QOSCheckBox").disabled=true;
			     _enabled = false;
				 _settime_enabled = false;
	          } 
		      else
		      {   
                 document.getElementById("SpindownTimeInterval").disabled=false;
			    _enabled = true;
				
				if(document.getElementById("ConfigDrives").value=='2')
				{ 
				    document.getElementById("StartTimeHours").disabled=true;
				    document.getElementById("StartTimeMinutes").disabled=true;
					 document.getElementById("EndTimeMinutes").disabled=true;
					 document.getElementById("AMPM").disabled=true;
					 document.getElementById("QOSCheckBox").disabled=true;
					_settime_enabled = false;
                }
				
               if(document.getElementById("ConfigDrives").value=='1')
				{
				    document.getElementById("QOSCheckBox").disabled=false;
					_settime_enabled = true;
				  /*  document.getElementById("StartTimeHours").disabled=false;
				    document.getElementById("StartTimeMinutes").disabled=false;
					document.getElementById("EndTimeMinutes").disabled=false;
					document.getElementById("AMPM").disabled=false;
					_settime_enabled = true;*/
                }	
		      }
		 }
		 else
		 {    
		      if((document.getElementById("UnconfigDrives").value=='2') &amp;&amp; (document.getElementById("UnconfigHotspares").value=='2'))
		      {  
                  document.getElementById("SpindownTimeInterval").disabled=true;
			     _enabled = false;
	          } 
		      else
		      {   
                 document.getElementById("SpindownTimeInterval").disabled=false;
			    _enabled = true;
		      }
		 }
		   
		}
		
		//tonum string
		function tonum(obj)
		{
			 return parseInt(obj);
   	    }
			 
		function getvaluecmd(flag)
		{
		    if(flag == "SpindownTimeInterval")
			  lastobjcmd = tonum(document.dataarea.SpindownTimeInterval.value);
			if(flag == "StartTimeHours") 
			  lastobjcmd = tonum(document.dataarea.StartTimeHours.value);
			if(flag == "StartTimeMinutes")  
			  lastobjcmd = tonum(document.dataarea.StartTimeMinutes.value);
			if(flag == "EndTimeMinutes")  
			  lastobjcmd = tonum(document.dataarea.EndTimeMinutes.value);  
			 return lastobjcmd;
		}
		
		function getvaluecmd1()
		{
		  	lastobjcmd1 = tonum(document.dataarea.cmdlog.value);
			return lastobjcmd1;
		}
						
		function incrcmd(x , y, z)
		{   
		        if( _enabled == true)
				{  
					curobjcmd=getvaluecmd(z);
					curobjcmd1=getvaluecmd1();
					curobjcmd = curobjcmd + x;
					if ( y &gt;= curobjcmd )
					{
					  if(z == "SpindownTimeInterval")
						document.dataarea.SpindownTimeInterval.value = curobjcmd;
						
					}
					else
					{
					     if(z == "SpindownTimeInterval")
						     document.dataarea.SpindownTimeInterval.value = y;
				
						
					}
					curobjcmd1 = curobjcmd1 + x;
					if ( y &gt;= curobjcmd1 )
					{
						document.dataarea.cmdlog.value = curobjcmd1;
					}
					else
					{
						document.dataarea.cmdlog.value = y;	
					}
					if( false == cmdModified )
						cmdModified = true;
				
					
                  }		

                 if( _settime_enabled == true)
				{ 
					curobjcmd=getvaluecmd(z);
					curobjcmd1=getvaluecmd1();
					curobjcmd = curobjcmd + x;
					if ( y &gt;= curobjcmd )
					{
			
					  if(z == "StartTimeHours")
                        document.dataarea.StartTimeHours.value = curobjcmd;	
                      if(z == "StartTimeMinutes")
                        document.dataarea.StartTimeMinutes.value = curobjcmd;
                       if(z == "EndTimeMinutes")
                        document.dataarea.EndTimeMinutes.value = curobjcmd;						
					}
					else
					{
				
					     if(z == "StartTimeHours")
                             document.dataarea.StartTimeHours.value = y;	
                         if(z == "StartTimeMinutes")
                             document.dataarea.StartTimeMinutes.value = y;
                         if(z == "EndTimeMinutes")
                             document.dataarea.EndTimeMinutes.value = y;								 
						
					}
					curobjcmd1 = curobjcmd1 + x;
					if ( y &gt;= curobjcmd1 )
					{
						document.dataarea.cmdlog.value = curobjcmd1;
					}
					else
					{
						document.dataarea.cmdlog.value = y;	
					}
				   if( false == cmdModified )
						cmdModified = true;
				
                  }		
                 return;				  
		}

		function decrcmd(a , b, c)	
		{      
		        if( _enabled == true)
				{
					curobjcmd=getvaluecmd(c);
					curobjcmd1=getvaluecmd1();
					
					curobjcmd = curobjcmd - a;
					if ( b &lt;= curobjcmd )
					{
						if(c == "SpindownTimeInterval")
						  document.dataarea.SpindownTimeInterval.value = curobjcmd;
					}
					else
					{
						
						 if(c == "SpindownTimeInterval")
						     document.dataarea.SpindownTimeInterval.value = b;
									
					}	
					
					curobjcmd1 = curobjcmd1 - a;
					if ( b &lt;= curobjcmd1 )
					{
						document.dataarea.cmdlog.value = curobjcmd1;
					}
					else
					{
						document.dataarea.cmdlog.value = b;
					}
					if( false == cmdModified )
						cmdModified = true;
                }

                if( _settime_enabled == true)
				{
					curobjcmd=getvaluecmd(c);
					curobjcmd1=getvaluecmd1();
					
					curobjcmd = curobjcmd - a;
					if ( b &lt;= curobjcmd )
					{
						
				
					    if(c == "StartTimeHours")
                          document.dataarea.StartTimeHours.value = curobjcmd;	
                        if(c == "StartTimeMinutes")
                          document.dataarea.StartTimeMinutes.value = curobjcmd;	
                        if(c == "EndTimeMinutes")
                          document.dataarea.EndTimeMinutes.value = curobjcmd;						  
					}
					else
					{
					
					     if(c == "StartTimeHours")
                             document.dataarea.StartTimeHours.value = b;	
                         if(c == "StartTimeMinutes")
                             document.dataarea.StartTimeMinutes.value = b;
                         if(c == "EndTimeMinutes")
                             document.dataarea.EndTimeMinutes.value = b;							 
						
					}	
					
					curobjcmd1 = curobjcmd1 - a;
					if ( b &lt;= curobjcmd1 )
					{
						document.dataarea.cmdlog.value = curobjcmd1;
					}
					else
					{
						document.dataarea.cmdlog.value = b;
					}
					if( false == cmdModified )
						cmdModified = true;

                    
                }	
                 return;				
			}
			
			function validateTimeInterval(component)
            {   validateAndAllowNumbers(component);
            }
			function OnSelectTimeMeridian()
            {
            }		

            function OnEnableSelected()
			{  		

                if(document.getElementById("QOSCheckBox").checked == true)
               {			
				   if(document.getElementById("ConfigDrives").value=='1')
				    {  
				    document.getElementById("StartTimeHours").disabled=false;
				    document.getElementById("StartTimeMinutes").disabled=false;
					document.getElementById("EndTimeMinutes").disabled=false;
					document.getElementById("AMPM").disabled=false;
					_settime_enabled = true;
                     }
			 }	
				else
				{ 
				   
				   document.getElementById("StartTimeHours").disabled=true;
				    document.getElementById("StartTimeMinutes").disabled=true;
					document.getElementById("EndTimeMinutes").disabled=true;
					document.getElementById("AMPM").disabled=true;
					_settime_enabled = false;
				}
			}			
	   </script>
            <xsl:call-template name="PwrProps"/>
			
      
		</DataArea>
	</xsl:template>
	   <xsl:template name="PwrProps">
	         <TableData>
                  <xsl:variable name="showtasks">false</xsl:variable>
				  <SubHeader>
				    <xsl:attribute name="display"><xsl:value-of select="$strPowerManagementSettings"/></xsl:attribute>
				  </SubHeader>
		
        <xsl:if test="($GLOBAL_VAR_ControllerFamily &gt;= 8) and ($GLOBAL_VAR_SupportPowerSavings != 0)">
		<Row>
		   <Data size="2%" align="left" noborderright="true"/>
		   <Data name="NoPowerMode" type="radio" handler="OnOperationNoPowerModeSelected()" event="onClick" state="0" align="left">
                <xsl:attribute name="value"><xsl:value-of select="$strNoPowerMode"/></xsl:attribute>
           </Data>
		    
		</Row>
		<Row>
		   <Data size="2%" align="left" noborderright="true"/>
		   <Data name="BalancedPowerMode" type="radio" handler="OnOperationBalancedPowerModeSelected()" event="onClick" state="0" align="left">
                <xsl:attribute name="value"><xsl:value-of select="$strBalancedPowerMode"/></xsl:attribute>
           </Data>
		</Row>
        <!--Added below restriction for not displaying Max Power mode and Custom Power Mode in H330 controller -->
		<xsl:if test="$GLOBAL_VAR_H330Controller != 1">
			<Row>
			   <Data size="2%" align="left" noborderright="true"/>
			   <Data name="MaximumPowerMode" type="radio" handler="OnOperationMaxPowerModeSelected()" event="onClick" state="0" align="left">
					<xsl:attribute name="value"><xsl:value-of select="$strMaxPowerMode"/></xsl:attribute>
			   </Data>
			</Row>
			<Row>
			   <Data size="2%" align="left" noborderright="true"/>
			   <Data name="CustomPowerMode" type="radio" handler="OnOperationCustomPowerModeSelected()" event="onClick" state="0" align="left">
					<xsl:attribute name="value"><xsl:value-of select="$strCustomPowerMode"/></xsl:attribute>
			   </Data>
			</Row>
		</xsl:if>
		 </xsl:if>
		<xsl:if test="//DimmerPropertyMask">
           <Row>
             <Data><xsl:attribute name="value"><xsl:value-of select="$strUnconfiguredDrives"/></xsl:attribute></Data>
             <Data name="UnconfigDrives" type="select" handler="javascript:Onselect()" event="onChange">
	         <Choice>
	             <xsl:attribute name="value">
                    <xsl:call-template name="GetControllerProperty">
                       <xsl:with-param name="PropertyMode">
                       <xsl:choose>
                           <xsl:when test="substring(//DimmerPropertyMask,28,1)='1'">16</xsl:when>
                           <xsl:when test="substring(//DimmerPropertyMask,27,1)='1'">32</xsl:when>
                       </xsl:choose>
                       </xsl:with-param>
                    </xsl:call-template>
                 </xsl:attribute>
                 <xsl:attribute name="returnvalue">
                    <xsl:choose>
                         <xsl:when test="substring(//DimmerPropertyMask,28,1)='1'">2</xsl:when>
                         <xsl:when test="substring(//DimmerPropertyMask,27,1)='1'">1</xsl:when>
					</xsl:choose>
                  </xsl:attribute>
               </Choice>
					      
               <xsl:call-template name="for-loop-list-box">
		          <xsl:with-param name="Mask" select="//DimmerPropertyMask"/>
                  <xsl:with-param name="currPolicy">
                     <xsl:choose>
                          <xsl:when test="substring(//DimmerPropertyMask,28,1)='1'">16</xsl:when>
                          <xsl:when test="substring(//DimmerPropertyMask,27,1)='1'">32</xsl:when>
                     </xsl:choose>
                  </xsl:with-param> 
                  <xsl:with-param name="templateName" select="24"/>
	           </xsl:call-template>
             </Data>
           </Row>
        </xsl:if>
		<xsl:if test="//ChangeControllerPropertyMask and not(//DimmerPropertyMask)">
           <Row>
             <Data><xsl:attribute name="value"><xsl:value-of select="$strUnconfiguredDrives"/></xsl:attribute></Data>
             <Data name="UnconfigDrives" type="select" handler="javascript:Onselect()" event="onChange">
	         <Choice>
	             <xsl:attribute name="value">
                    <xsl:call-template name="GetControllerProperty">
                       <xsl:with-param name="PropertyMode">
                       <xsl:choose>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,28,1)='1'">16</xsl:when>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,27,1)='1'">32</xsl:when>
                       </xsl:choose>
                       </xsl:with-param>
                    </xsl:call-template>
                 </xsl:attribute>
                 <xsl:attribute name="returnvalue">
                    <xsl:choose>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,28,1)='1'">2</xsl:when>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,27,1)='1'">1</xsl:when>
					</xsl:choose>
                  </xsl:attribute>
               </Choice>
					      
               <xsl:call-template name="for-loop-list-box">
		          <xsl:with-param name="Mask" select="//ChangeControllerPropertyMask"/>
                  <xsl:with-param name="currPolicy">
                     <xsl:choose>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,28,1)='1'">16</xsl:when>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,27,1)='1'">32</xsl:when>
                     </xsl:choose>
                  </xsl:with-param> 
                  <xsl:with-param name="templateName" select="24"/>
	           </xsl:call-template>
             </Data>
           </Row>
        </xsl:if>
       
		<xsl:if test="//DimmerPropertyMask">
           <Row>
             <Data><xsl:attribute name="value"><xsl:value-of select="$strUnconfiguredHotspares"/></xsl:attribute></Data>
             <Data name="UnconfigHotspares" type="select" handler="javascript:Onselect()" event="onChange">
	         <Choice>
	             <xsl:attribute name="value">
                    <xsl:call-template name="GetControllerProperty">
                       <xsl:with-param name="PropertyMode">
                       <xsl:choose>
                           <xsl:when test="substring(//DimmerPropertyMask,26,1)='1'">64</xsl:when>
                           <xsl:when test="substring(//DimmerPropertyMask,25,1)='1'">128</xsl:when>
                       </xsl:choose>
                       </xsl:with-param>
                    </xsl:call-template>
                 </xsl:attribute>
                 <xsl:attribute name="returnvalue">
                    <xsl:choose>
                         <xsl:when test="substring(//DimmerPropertyMask,26,1)='1'">2</xsl:when>
                         <xsl:when test="substring(//DimmerPropertyMask,25,1)='1'">1</xsl:when>
					</xsl:choose>
                  </xsl:attribute>
               </Choice>
					      
               <xsl:call-template name="for-loop-list-box">
		          <xsl:with-param name="Mask" select="//DimmerPropertyMask"/>
                  <xsl:with-param name="currPolicy">
                     <xsl:choose>
                          <xsl:when test="substring(//DimmerPropertyMask,26,1)='1'">64</xsl:when>
                          <xsl:when test="substring(//DimmerPropertyMask,25,1)='1'">128</xsl:when>
                     </xsl:choose>
                  </xsl:with-param> 
                  <xsl:with-param name="templateName" select="25"/>
	           </xsl:call-template>
             </Data>
           </Row>
        </xsl:if>
		<xsl:if test="(//ChangeControllerPropertyMask) and not(//DimmerPropertyMask)">
           <Row>
             <Data><xsl:attribute name="value"><xsl:value-of select="$strUnconfiguredHotspares"/></xsl:attribute></Data>
             <Data name="UnconfigHotspares" type="select" handler="javascript:Onselect()" event="onChange">
	         <Choice>
	             <xsl:attribute name="value">
                    <xsl:call-template name="GetControllerProperty">
                       <xsl:with-param name="PropertyMode">
                       <xsl:choose>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,26,1)='1'">64</xsl:when>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,25,1)='1'">128</xsl:when>
                       </xsl:choose>
                       </xsl:with-param>
                    </xsl:call-template>
                 </xsl:attribute>
                 <xsl:attribute name="returnvalue">
                    <xsl:choose>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,26,1)='1'">2</xsl:when>
                         <xsl:when test="substring(//ChangeControllerPropertyMask,25,1)='1'">1</xsl:when>
					</xsl:choose>
                  </xsl:attribute>
               </Choice>
					      
               <xsl:call-template name="for-loop-list-box">
		          <xsl:with-param name="Mask" select="//ChangeControllerPropertyMask"/>
                  <xsl:with-param name="currPolicy">
                     <xsl:choose>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,26,1)='1'">64</xsl:when>
                          <xsl:when test="substring(//ChangeControllerPropertyMask,25,1)='1'">128</xsl:when>
                     </xsl:choose>
                  </xsl:with-param> 
                  <xsl:with-param name="templateName" select="25"/>
	           </xsl:call-template>
             </Data>
           </Row>
        </xsl:if>
		<xsl:if test="(//DimmerPropertyMask) and (substring(//DimmerPropertyMask,24,1) = '1' or substring(//DimmerPropertyMask,23,1) = '1')">
           <Row>
             <Data><xsl:attribute name="value"><xsl:value-of select="$strConfiguredDrives"/></xsl:attribute></Data>
             <Data name="ConfigDrives" type="select" handler="javascript:Onselect()" event="onChange">
	         <Choice>
	             <xsl:attribute name="value">
                    <xsl:call-template name="GetControllerProperty">
                       <xsl:with-param name="PropertyMode">
                       <xsl:choose>
                           <xsl:when test="substring(//DimmerPropertyMask,24,1)='1'">256</xsl:when>
                           <xsl:when test="substring(//DimmerPropertyMask,23,1)='1'">512</xsl:when>
                       </xsl:choose>
                       </xsl:with-param>
                    </xsl:call-template>
                 </xsl:attribute>
                 <xsl:attribute name="returnvalue">
                    <xsl:choose>
                         <xsl:when test="substring(//DimmerPropertyMask,24,1)='1'">2</xsl:when>
                         <xsl:when test="substring(//DimmerPropertyMask,23,1)='1'">1</xsl:when>
					</xsl:choose>
                  </xsl:attribute>
               </Choice>
					      
               <xsl:call-template name="for-loop-list-box">
		          <xsl:with-param name="Mask" select="//DimmerPropertyMask"/>
                  <xsl:with-param name="currPolicy">
                     <xsl:choose>
                          <xsl:when test="substring(//DimmerPropertyMask,24,1)='1'">256</xsl:when>
                          <xsl:when test="substring(//DimmerPropertyMask,23,1)='1'">512</xsl:when>
                     </xsl:choose>
                  </xsl:with-param> 
                  <xsl:with-param name="templateName" select="26"/>
	           </xsl:call-template>
             </Data>
           </Row>
        </xsl:if>	
        
		<xsl:if test="(//DimmerPropertyMask) and (substring(//DimmerPropertyMask,22,1) = '1' or substring(//DimmerPropertyMask,21,1) = '1')">
           <Row>
             <Data><xsl:attribute name="value"><xsl:value-of select="$strIdleCFull"/></xsl:attribute></Data>
             <Data name="IdleC" type="select" handler="javascript:Onselect()" event="onChange">
	         <Choice>
	             <xsl:attribute name="value">
                    <xsl:call-template name="GetControllerProperty">
                       <xsl:with-param name="PropertyMode">
                       <xsl:choose>
                           <xsl:when test="substring(//DimmerPropertyMask,22,1)='1'">1024</xsl:when>
                           <xsl:when test="substring(//DimmerPropertyMask,21,1)='1'">2048</xsl:when>
                       </xsl:choose>
                       </xsl:with-param>
                    </xsl:call-template>
                 </xsl:attribute>
                 <xsl:attribute name="returnvalue">
                    <xsl:choose>
                         <xsl:when test="substring(//DimmerPropertyMask,22,1)='1'">2</xsl:when>
                         <xsl:when test="substring(//DimmerPropertyMask,21,1)='1'">1</xsl:when>
					</xsl:choose>
                  </xsl:attribute>
               </Choice>
					      
               <xsl:call-template name="for-loop-list-box">
		          <xsl:with-param name="Mask" select="//DimmerPropertyMask"/>
                  <xsl:with-param name="currPolicy">
                     <xsl:choose>
                          <xsl:when test="substring(//DimmerPropertyMask,22,1)='1'">1024</xsl:when>
                          <xsl:when test="substring(//DimmerPropertyMask,21,1)='1'">2048</xsl:when>
                     </xsl:choose>
                  </xsl:with-param> 
                  <xsl:with-param name="templateName" select="27"/>
	           </xsl:call-template>
             </Data>
           </Row>
        </xsl:if> 
	   <xsl:element name="Row">
                               
								<xsl:element name="Data">
									<xsl:attribute name="display"><xsl:value-of select="$strSpindownTimeInterval"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$strSpindownTimeInterval"/></xsl:attribute>
								</xsl:element>
								
							    
								<xsl:element name="Data">
									<xsl:attribute name="name"><xsl:value-of select="$GLOBAL_VAR_SpindownTimeInterval"/></xsl:attribute>
									<xsl:attribute name="type">spincontrol</xsl:attribute>
									<xsl:attribute name="size">4</xsl:attribute>
									<xsl:attribute name="maxlength">4</xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="Controllers/DCStorageObject/SpinDownTime"/></xsl:attribute>
									<xsl:attribute name="state">2</xsl:attribute>
									<xsl:attribute name="uparrscript">
										<xsl:call-template name="scriptcmd11">
											<xsl:with-param name="max"><xsl:value-of select="$GLOBAL_VAR_MaximumValue"/></xsl:with-param>
											<xsl:with-param name="incr"><xsl:value-of select="$GLOBAL_VAR_IncrementValue"/></xsl:with-param>
											<xsl:with-param name="name"><xsl:value-of select="$GLOBAL_VAR_SpindownTimeInterval"/></xsl:with-param>
										</xsl:call-template>
									</xsl:attribute>
									<xsl:attribute name="downarrscript">
										<xsl:call-template name="scriptcmd12">
											<xsl:with-param name="min"><xsl:value-of select="$GLOBAL_VAR_MinimumValue"/></xsl:with-param>
											<xsl:with-param name="incr"><xsl:value-of select="$GLOBAL_VAR_IncrementValue"/></xsl:with-param>
											<xsl:with-param name="name"><xsl:value-of select="$GLOBAL_VAR_SpindownTimeInterval"/></xsl:with-param>
										</xsl:call-template>
									</xsl:attribute>
									<EventHandler>
                                            <xsl:attribute name="event">onKeyUp</xsl:attribute>
                                            <xsl:attribute name="handler">javascript:validateTimeInterval(this);</xsl:attribute>
                                    </EventHandler>
							   </xsl:element>		
									
								 
								<xsl:element name="Data">
								 
								    <xsl:attribute name="type">hidden</xsl:attribute>
									<xsl:attribute name="align">right</xsl:attribute>
									<xsl:attribute name="name">cmdlog</xsl:attribute>
									<xsl:attribute name="returnvalue"><xsl:value-of select="$GLOBAL_VAR_MaximumValue"/></xsl:attribute>
								 
								</xsl:element>
        	
       </xsl:element>	   
      </TableData>
	  
	  <xsl:if test="(//DimmerPropertyMask) and ((substring(//DimmerPropertyMask,24,1) = '1' or substring(//DimmerPropertyMask,23,1) = '1') or (substring(//DimmerPropertyMask,22,1) = '1' or substring(//DimmerPropertyMask,21,1) = '1'))">
	  <TableData>
	   <SubHeader>
			<xsl:attribute name="display"><xsl:value-of select="$strQualityOfService"/></xsl:attribute>
		</SubHeader>
		<Row>
		   <Data name="QOSCheckBox" type="checkbox" align="left" event="onClick" colspan="4">
		       <xsl:attribute name="value"><xsl:value-of select="$strEnableQOS"/></xsl:attribute>
			   <xsl:attribute name="handler">javascript:OnEnableSelected()</xsl:attribute>
		   </Data>
		 
		</Row>
		 <Row>
                               
								<Data>
									<xsl:attribute name="display"><xsl:value-of select="$strStartTime"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$strStartTime"/></xsl:attribute>
								</Data>
								
							   
								<Data width="15" noborderright="true" name="{$GLOBAL_VAR_StartTimeHours}" type="spincontrol" size="2" maxlength="2" state="2">
									<xsl:attribute name="value"><xsl:call-template name="removeLeadingZeros"><xsl:with-param name="originalString" select="UserSetTime0"/></xsl:call-template></xsl:attribute>
								
									<xsl:attribute name="uparrscript">
										<xsl:call-template name="scriptcmd13">
											<xsl:with-param name="max"><xsl:value-of select="$GLOBAL_VAR_MaximumValue_Hours"/></xsl:with-param>
											<xsl:with-param name="incr"><xsl:value-of select="$GLOBAL_VAR_IncrementValue"/></xsl:with-param>
											<xsl:with-param name="name"><xsl:value-of select="$GLOBAL_VAR_StartTimeHours"/></xsl:with-param>
										</xsl:call-template>
									</xsl:attribute>
									<xsl:attribute name="downarrscript">
										<xsl:call-template name="scriptcmd14">
											<xsl:with-param name="min"><xsl:value-of select="$GLOBAL_VAR_MinimumValue_Hours"/></xsl:with-param>
											<xsl:with-param name="incr"><xsl:value-of select="$GLOBAL_VAR_IncrementValue"/></xsl:with-param>
											<xsl:with-param name="name"><xsl:value-of select="$GLOBAL_VAR_StartTimeHours"/></xsl:with-param>
										</xsl:call-template>
									</xsl:attribute>
									<EventHandler>
                                            <xsl:attribute name="event">onKeyUp</xsl:attribute>
                                            <xsl:attribute name="handler">javascript:validateTimeInterval(this);</xsl:attribute>
                                    </EventHandler>
							   </Data>	
                               						   
					           <Data width="15" noborderright="true" name="{$GLOBAL_VAR_StartTimeMinutes}" type="spincontrol" size="2" maxlength="2" state="2">
									<xsl:attribute name="value"><xsl:value-of select="UserSetTime1"/></xsl:attribute>
									<xsl:attribute name="uparrscript">
										<xsl:call-template name="scriptcmd15">
											<xsl:with-param name="max"><xsl:value-of select="$GLOBAL_VAR_MaximumValue"/></xsl:with-param>
											<xsl:with-param name="incr"><xsl:value-of select="$GLOBAL_VAR_IncrementValue"/></xsl:with-param>
											<xsl:with-param name="name"><xsl:value-of select="$GLOBAL_VAR_SpindownTimeInterval"/></xsl:with-param>
										</xsl:call-template>
									</xsl:attribute>
									<xsl:attribute name="downarrscript">
										<xsl:call-template name="scriptcmd16">
											<xsl:with-param name="min"><xsl:value-of select="$GLOBAL_VAR_MinimumValue_Minutes"/></xsl:with-param>
											<xsl:with-param name="incr"><xsl:value-of select="$GLOBAL_VAR_IncrementValue"/></xsl:with-param>
											<xsl:with-param name="name"><xsl:value-of select="$GLOBAL_VAR_StartTimeMinutes"/></xsl:with-param>
										</xsl:call-template>
									</xsl:attribute>
									<EventHandler>
                                            <xsl:attribute name="event">onKeyUp</xsl:attribute>
                                            <xsl:attribute name="handler">javascript:validateTimeInterval(this);</xsl:attribute>
                                    </EventHandler>
							   </Data>
                               <Data name="AMPM" type="select" handler="javascript:OnSelectTimeMeridian()" event="onChange">
								<Choice>	
									<xsl:attribute name="value"><xsl:value-of select="UserSetTime2"/></xsl:attribute>
									<xsl:attribute name="returnvalue"><xsl:value-of select="UserSetTime2"/></xsl:attribute>
								</Choice>
								<Choice>
								    <xsl:attribute name="value">
											<xsl:call-template name="GetMeridianProperty">
												<xsl:with-param name="PropertyMode"><xsl:value-of select="UserSetTime2"/></xsl:with-param>
                                            </xsl:call-template>
                                    </xsl:attribute>
									<xsl:attribute name="returnvalue">
									 <xsl:call-template name="GetMeridianProperty">
												<xsl:with-param name="PropertyMode"><xsl:value-of select="UserSetTime2"/></xsl:with-param>
                                      </xsl:call-template>
									</xsl:attribute>
								</Choice>
								 
   						       </Data>							   
   	
         </Row>
	   	 <Row>
                               
								<Data>
									<xsl:attribute name="display"><xsl:value-of select="$strEndTime"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$strEndTime"/></xsl:attribute>
								</Data>
								
							   
								<Data width="15" noborderright="true" name="EndTimeMinutes" type="spincontrol" size="2" maxlength="2" state="2">
									<xsl:attribute name="value"><xsl:value-of select="DisableLDPSInterval"/></xsl:attribute>
								
									<xsl:attribute name="uparrscript">
										<xsl:call-template name="scriptcmd17">
											<xsl:with-param name="max"><xsl:value-of select="$GLOBAL_VAR_END_MaxmumValue_Minutes"/></xsl:with-param>
											<xsl:with-param name="incr"><xsl:value-of select="$GLOBAL_VAR_IncrementValue"/></xsl:with-param>
											<xsl:with-param name="name"><xsl:value-of select="$GLOBAL_VAR_EndTimeMinutes"/></xsl:with-param>
										</xsl:call-template>
									</xsl:attribute>
									<xsl:attribute name="downarrscript">
										<xsl:call-template name="scriptcmd18">
											<xsl:with-param name="min"><xsl:value-of select="$GLOBAL_VAR_MinimumValue_Hours"/></xsl:with-param>
											<xsl:with-param name="incr"><xsl:value-of select="$GLOBAL_VAR_IncrementValue"/></xsl:with-param>
											<xsl:with-param name="name"><xsl:value-of select="$GLOBAL_VAR_EndTimeMinutes"/></xsl:with-param>
										</xsl:call-template>
									</xsl:attribute>
									
									<EventHandler>
                                            <xsl:attribute name="event">onKeyUp</xsl:attribute>
                                            <xsl:attribute name="handler">javascript:validateTimeInterval(this);</xsl:attribute>
                                    </EventHandler>
							   </Data>	
                               <Data noborderright="true"></Data>
                               <Data></Data>
                         				   
					      
       </Row>
	 </TableData>
	</xsl:if> 
    </xsl:template>
	<xsl:template name="GetMeridianProperty">
	   <xsl:param name="PropertyMode"/>
	   <xsl:choose>
           <xsl:when test="$PropertyMode != 'PM'">PM</xsl:when>
           <xsl:when test="$PropertyMode != 'AM'">AM</xsl:when>		   
	  </xsl:choose> 
	</xsl:template>
	
	<xsl:template name="removeLeadingZeros">  
      <xsl:param name="originalString"/>  
      <xsl:choose>  
          <xsl:when test="starts-with($originalString,'0')">  
              <xsl:call-template name="removeLeadingZeros">  
                  <xsl:with-param name="originalString">  
                        <xsl:value-of select="substring-after($originalString,'0' )"/>  
                  </xsl:with-param>  
              </xsl:call-template>  
          </xsl:when>  
          <xsl:otherwise>  
                 <xsl:value-of select="$originalString"/>  
          </xsl:otherwise>  
      </xsl:choose>  
    </xsl:template>
		<xsl:template name="scriptcmd11">javascript:incrcmd(<xsl:value-of select="$GLOBAL_VAR_IncrementValue"/>,<xsl:value-of select="$GLOBAL_VAR_MaximumValue"/>,'<xsl:value-of select="$GLOBAL_VAR_SpindownTimeInterval"/>')</xsl:template>
	    <xsl:template name="scriptcmd12">javascript:decrcmd(<xsl:value-of select="$GLOBAL_VAR_IncrementValue"/>,<xsl:value-of select="$GLOBAL_VAR_MinimumValue"/>,'<xsl:value-of select="$GLOBAL_VAR_SpindownTimeInterval"/>')</xsl:template>
		<xsl:template name="scriptcmd13">javascript:incrcmd(<xsl:value-of select="$GLOBAL_VAR_IncrementValue"/>,<xsl:value-of select="$GLOBAL_VAR_MaximumValue_Hours"/>,'<xsl:value-of select="$GLOBAL_VAR_StartTimeHours"/>')</xsl:template>
	    <xsl:template name="scriptcmd14">javascript:decrcmd(<xsl:value-of select="$GLOBAL_VAR_IncrementValue"/>,<xsl:value-of select="$GLOBAL_VAR_MinimumValue_Hours"/>,'<xsl:value-of select="$GLOBAL_VAR_StartTimeHours"/>')</xsl:template>
		<xsl:template name="scriptcmd15">javascript:incrcmd(<xsl:value-of select="$GLOBAL_VAR_IncrementValue"/>,<xsl:value-of select="$GLOBAL_VAR_MaximumValue_Minutes"/>,'<xsl:value-of select="$GLOBAL_VAR_StartTimeMinutes"/>')</xsl:template>
	    <xsl:template name="scriptcmd16">javascript:decrcmd(<xsl:value-of select="$GLOBAL_VAR_IncrementValue"/>,<xsl:value-of select="$GLOBAL_VAR_MinimumValue_Minutes"/>,'<xsl:value-of select="$GLOBAL_VAR_StartTimeMinutes"/>')</xsl:template>
		<xsl:template name="scriptcmd17">javascript:incrcmd(<xsl:value-of select="$GLOBAL_VAR_IncrementValue"/>,<xsl:value-of select="$GLOBAL_VAR_END_MaxmumValue_Minutes"/>,'<xsl:value-of select="$GLOBAL_VAR_EndTimeMinutes"/>')</xsl:template>
	    <xsl:template name="scriptcmd18">javascript:decrcmd(<xsl:value-of select="$GLOBAL_VAR_IncrementValue"/>,<xsl:value-of select="$GLOBAL_VAR_MinimumValue_Hours"/>,'<xsl:value-of select="$GLOBAL_VAR_EndTimeMinutes"/>')</xsl:template>

</xsl:stylesheet>


