<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:variable name="GLOBAL_VAR_LOCALE"><xsl:value-of select="/OMA/Locale"/></xsl:variable>
	<xsl:template match="/OMA">
		<xsl:variable name="isCluster">
			<xsl:choose>
				<xsl:when test="substring(/OMA/ArrayInfo/Controllers/DCStorageObject/AttributesMask,32,1)!='0'">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="checkAdmin">
				<xsl:choose>
					<xsl:when test="OMAUserRights = '7'">true</xsl:when>
					<xsl:otherwise>false</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
		<xsl:variable name="GLOBAL_VAR_AttributeMask"><xsl:value-of select="/OMA/ArrayInfo/Controllers/DCStorageObject/AttributesMask"/></xsl:variable>	
        <xsl:variable name="GLOBAL_VAR_ControllerDKMCapable">
          <xsl:choose>
             <xsl:when test="substring($GLOBAL_VAR_AttributeMask,3,1)='1'">1</xsl:when>
             <xsl:otherwise>0</xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
		 
		<DataArea exportdata="false">
			<!-- The call to the scripts template is needed to include the new common javascript function GetLocalUrl( ) for error handling -->
			<!-- This call must reside within the <DataArea> tag -->
			<xsl:call-template name="scripts"/>
			<script language="javascript">

			function onExecuteController(name, oid, IsDeleteSecurityKeyEnabled,SecurityAction)
			{
			       var cluster = document.getElementById("ClusterMode"+oid).value;
				var confirmreponse = 0;

				var action = document.getElementById("CtrlTasks" + oid).value;
                                var origurl = GetLocalUrl(); 
				if (action == "-")
				{
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
				}
				else if (action =="64")
				{ //create vd

					// need a cluster check.
					if(cluster == 1)
					{
							msg = "<xsl:value-of select="$strClusterCreate"/>";
							confirmresponse = confirm(msg);
					}

					if((cluster == 1 &amp;&amp; confirmresponse) || cluster == 0)
					{
				   	var origurl = GetLocalUrl(); //original URL
						<!--document.location.href ="./DataArea?plugin=com.dell.sm.webplugins.CreateVDExpressWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;help=vdmgmt&amp;OrigURL="+origurl;-->
                                        document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.LaunchCreateVDWizardSubmitWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;OrigURL=" + origurl );
					document.dataarea.submit();
					}
				}
				else if (action == "128")
				{  //reset config
					// need a cluster check.
					if(cluster == 1)
					{
							msg = "<xsl:value-of select="$strClusterResetCnfg"/>";
							confirmresponse = confirm(msg);
					}

					if((cluster == 1 &amp;&amp; confirmresponse) || cluster == 0)
        {
          
          document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.ConfirmResetConfWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;help=cntkrset&amp;BackTo="+origurl);
        }
        }
        else if (action == "32") { //set rebuild rate
          document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.SetRebuildRateWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;help=cntkrbld&amp;RebuildRate=" + document.getElementById("RebuildRate"+oid).value);
        }
        else if (action == "8192") { //set bgi rate
        document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.SetCtrlRateAttribWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action + "&amp;help=cntkbgi&amp;Rate=" + document.getElementById("BGIRate"+oid).value);
        }
        else if (action == "16384")  { //set checkconsistency rate
          document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.SetCtrlRateAttribWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action + "&amp;help=cntkchk&amp;Rate=" + document.getElementById("CheckConsistencyRate"+oid).value);
        }
        else if (action == "65536")  { //set reconstruct rate
        document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.SetCtrlRateAttribWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action + "&amp;help=cntkrcn&amp;Rate=" + document.getElementById("ReconstructRate"+oid).value);
        }
        else if (action == "1") { //controller rescan
        
          document.location.href  = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.ConfirmCtrlRescanWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action="+action+"&amp;help=cnprin&amp;BackTo="+origurl);
        }
        else if ((action == "4") || (action == 8) || (action == 16) || (action == 1024) || (action == 2048)) {
        //will eventually make this default...rescan, enable, disable, quiet alarm, resume, test alarm i/o
        document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action="+action+"&amp;help=cnprin&amp;BackTo="+origurl);
        document.dataarea.submit();
        }
        else if (action == "256") { //export log
          document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CtrlExportLogWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;help=cntklog");
        }
        else if (action == "8388608") { //clear foreign config
         

          document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmForeignConfigWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkclfc"+"&amp;BackTo="+origurl);
        }
        else if (action == "16777216") { //import foreign config
           

          document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmForeignConfigWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkimfc"+"&amp;BackTo="+origurl);
        }
        else if (action == "33554432") { //forced import foreign config
           
           document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmForeignConfigWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkimfc"+"&amp;BackTo="+origurl);
        }
        else if (action == "536870912") { //foreign config operations

		var ForeignSEDPresent=0;
            <xsl:for-each select="//ArrayInfo/Controllers/DCStorageObject">

               if(oid == ("."+'<xsl:value-of select="ControllerNum"/>'))
               { 
                   <xsl:if test="substring(AttributesMask,5,1)='1'">
                       ForeignSEDPresent=1;
                       SecurityKeyPresent='<xsl:choose><xsl:when test="substring(AttributesMask,8,1)='1' and substring(AttributesMask,9,1)='1' ">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose>';
                     
                   </xsl:if>
                }
               </xsl:for-each>
              
               if(ForeignSEDPresent=="1")
               { 
		       document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.SEDForeignConfigWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action+"&amp;SecurityKeyPresent="+SecurityKeyPresent+"&amp;help=cntkipfc"+"&amp;BackTo="+origurl); 
		   }
		   else
               {	
		       document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.ImportPreviewWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkipfc"+"&amp;BackTo="+origurl);
		   }	

        }
        else if (action == "2097152") { //start patrol read
          document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmStartStopPatReadWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkpats"+"&amp;BackTo="+origurl);
        }
        else if (action == "4194304") { //stop patrol read
          document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmStartStopPatReadWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkpats"+"&amp;BackTo="+origurl);
        }
        else if (action == "1048576") { //set patrol read mode
          document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.SetCtrlPatReadModeWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action + "&amp;PatrolReadMode="+ document.getElementById("PatrolReadMode"+oid).value + "&amp;PatrolReadModeMask="+ document.getElementById("PatrolReadModeMask"+oid).value + "&amp;help=cntkpatm"+"&amp;BackTo="+origurl);
	}
        else if (action == "67108864") { //change controller properties 6.0 changes
        
          document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.ChangeControllerPropertiesWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName="+ name+"&amp;BackTo="+origurl+"&amp;help=cntkchcp");
        }
        else if (action == "268435456") { //Pinned Cached
        
          document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CtrlManagePinnedCacheWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;OrigURL=" + origurl+"&amp;BackTo="+origurl+"&amp;help=cntkmpic");
        }
         else if (action == "1073741824") { // Security Key Management
        
          document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.SecurityKeyManagementWebPlugin&amp;Action="+SecurityAction+"&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name +"&amp;IsDeleteSecurityKeyEnabled="+IsDeleteSecurityKeyEnabled+"&amp;help=sedkey&amp;BackTo="+origurl);
       }
	   else if (action == "131072") { // Occupancy Slot Report
	    document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.OccupancySlotReportWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkvsor"+"&amp;BackTo="+origurl);                
       }
	   else if (action == "2147483648") { //Dimmer Switch
	    document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.PhysicalDiskPowerManagementWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;help=cntkmpdp"+"&amp;BackTo="+origurl);                
	   }
         else if (action == "2147483649") { //Manage SSC
            document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;help=cacheca1"+"&amp;ManageSSC=1"+"&amp;BackTo="+origurl);
         }
		 else if (action == "2147483650") { //Convert multiple Non-Raid to Raid
            document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.MultipleRaidToNonRaidWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;convertOption=1&amp;help=cntkctr&amp;OrigURL=" + origurl+"&amp;BackTo="+origurl);
         }
         else if (action == "2147483652") { //Convert multiple Raid to Non-Raid
               document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.MultipleRaidToNonRaidWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;convertOption=2&amp;help=cntkctnr&amp;OrigURL=" + origurl+"&amp;BackTo="+origurl);
         }

       else {
	      // Should never get here
	      alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
             }
        }

			function onExecuteReport(name, oid, sasaddress)
			{
				var reportaction = document.getElementById("CtrlReports" + oid).value;
            		        var origurl = GetLocalUrl(); 

				if (reportaction == "-")
				{
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
				}
				else if (reportaction == "2")
				{ 
					//view patrol read report
				    	document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.PRCCReportWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;ReportType=" + reportaction + "&amp;SASAddress=" + sasaddress +"&amp;help=cntkprr"+"&amp;BackTo="+origurl);                
				}
				else if (reportaction == "4")
				{ 
					//view check consistency report
				    	document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.PRCCReportWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;ReportType=" + reportaction + "&amp;SASAddress=" + sasaddress +"&amp;help=cntkccr"+"&amp;BackTo="+origurl);                
				}
				else if (reportaction == "8")
				{ 
					//view slot occpancy report
				    	document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.OccupancySlotReportWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;ReportType=" + reportaction +"&amp;help=cntkvsor"+"&amp;BackTo="+origurl);                
				}
				else if (reportaction == "16")
				{
				     //view physical disk firmware version report
				    	document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.HDDFirmwareVersionReportWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;ReportType=" + reportaction +"&amp;help=hddfirm"+"&amp;BackTo="+origurl);                
				}
       			else 
				{
	      			// Should never get here
	      			   alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
             		}
			}

       function RedirectToAlertLog()
        {
          document.location.href =top.gnv.appendVID("./DataArea?plugin=com.dell.oma.webplugins.AlertLogWebPlugin&amp;help=AlertLog&amp;app=hip&amp;ct=System&amp;snb=Logs&amp;lsnb=AlertLog");
        }

		      </script>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strStorageDashboard"/></xsl:attribute>
			</PageTitle>

			<!-- Add set hotspare policy button when any SAS controller is present -->
			<xsl:variable name="CurrentStorMask">
				<xsl:value-of select="/OMA/StorageInfo/DCStorageObject/CurrentMethodMask"/>
			</xsl:variable>
			<xsl:if test="substring($CurrentStorMask,29,1)='1'">
				<CustomButton align="left">
					<Data name="HSPolicy" formSubmit="true">
						<xsl:choose>
							<xsl:when test="$checkAdmin='true'">
						                <xsl:attribute name="display"><xsl:value-of select="$strSetHSProtectionPolicy"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="display"><xsl:value-of select="$strViewHSProtectionPolicy"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.SetHSProtectionPolicyWebplugin&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin!help=stprhl&amp;help=hsppol</xsl:attribute>
					</Data>
				</CustomButton>
			    </xsl:if>
            	  <xsl:if test="$GLOBAL_VAR_ControllerDKMCapable='1'">
				  <CustomButton align="left">
					<Data name="EncryptionKey" formSubmit="true">
						<xsl:choose>
							<xsl:when test="$checkAdmin='true'">
						                <xsl:attribute name="display"><xsl:value-of select="$strEncryptKeySettings"/></xsl:attribute>
							</xsl:when>
					    </xsl:choose>
						<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin!help=stprhl&amp;help=hsppol</xsl:attribute>
					</Data>
				  </CustomButton>
			    </xsl:if>

			<CustomButton>
				<Data name="AlertLog" formSubmit="false">
					<xsl:attribute name="display"><xsl:value-of select="$strAlertLog"/></xsl:attribute>
					<xsl:attribute name="href">javascript:parent.ct.select('System', 'Logs', 'AlertLog');</xsl:attribute>
				</Data>
			</CustomButton>

			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				</Data>
			</CustomButton>
      <xsl:choose>
        <xsl:when test="count(.//ArrayInfo) = '0'">
          <AlertMessage>
            <xsl:attribute name="display"><xsl:value-of select="$strNoStorageController"/></xsl:attribute>
          </AlertMessage>
        </xsl:when>
        <xsl:otherwise>
          <PromptText><xsl:value-of select="$strDescriptionDetail"/></PromptText>
		    <xsl:if test="ArrayInfo/Controllers[DCStorageObject/BusProtocol != '9']">
			    <SelectionData>
				    <SubHeader>
		                       <xsl:attribute name="display"><xsl:value-of select="$strRAIDControllers"/></xsl:attribute>
                    </SubHeader>
				    <SelectionTable>
					    <Header>
						    <Data>
							    <xsl:attribute name="value"><xsl:value-of select="$strSeverity"/></xsl:attribute>
						    </Data>
					    </Header>
				      <xsl:choose>
					      <xsl:when test="SortHealthComp='true'">
						      <xsl:for-each select="ArrayInfo/Controllers[DCStorageObject/BusProtocol != '9' or not(DCStorageObject/BusProtocol)]">
							      <xsl:sort select="@ControllerName" order="ascending"/>
								<xsl:sort select="DCStorageObject/PCISlot"/>
							      <xsl:call-template name="Component">
								      <xsl:with-param name="DCSObject" select="DCStorageObject"/>
								      <xsl:with-param name="tasks"><xsl:value-of select="$checkAdmin"/></xsl:with-param>
							      </xsl:call-template>
						      </xsl:for-each>
					      </xsl:when>
					      <xsl:otherwise>
						      <xsl:for-each select="ArrayInfo/Controllers[DCStorageObject/BusProtocol != '9' or not(DCStorageObject/BusProtocol)]">
								<xsl:sort select="DCStorageObject/PCISlot"/>
							      <xsl:call-template name="Component">
								      <xsl:with-param name="DCSObject" select="DCStorageObject"/>
								      <xsl:with-param name="tasks"><xsl:value-of select="$checkAdmin"/></xsl:with-param>
							      </xsl:call-template>
						      </xsl:for-each>
					      </xsl:otherwise>
				      </xsl:choose>
				  </SelectionTable>
			</SelectionData>
			</xsl:if>
			<xsl:if test="ArrayInfo/Controllers[DCStorageObject/BusProtocol = '9']">
			<SelectionData>
			        <SubHeader>
		                       <xsl:attribute name="display"><xsl:value-of select="$strPCIeSSD"/></xsl:attribute>
                    </SubHeader>
				    <SelectionTable>
					    <Header>
						    <Data>
							    <xsl:attribute name="value"><xsl:value-of select="$strSeverity"/></xsl:attribute>
						    </Data>
					    </Header>
						 	
				      <xsl:choose>
					      <xsl:when test="SortHealthComp='true'">
						      <xsl:for-each select="ArrayInfo/Controllers[DCStorageObject/BusProtocol = '9']">
							      <xsl:call-template name="PCIESSDComponent">
								      <xsl:with-param name="DCSObject" select="DCStorageObject"/>
								      <xsl:with-param name="tasks"><xsl:value-of select="$checkAdmin"/></xsl:with-param>
							      </xsl:call-template>
						      </xsl:for-each>
					      </xsl:when>
					      <xsl:otherwise>
						      <xsl:for-each select="ArrayInfo/Controllers[DCStorageObject/BusProtocol = '9']">
								  <xsl:call-template name="PCIESSDComponent">
								      <xsl:with-param name="DCSObject" select="DCStorageObject"/>
								      <xsl:with-param name="tasks"><xsl:value-of select="$checkAdmin"/></xsl:with-param>
							      </xsl:call-template>
						      </xsl:for-each>
					      </xsl:otherwise>
				      </xsl:choose>
				  </SelectionTable>
			</SelectionData>
			</xsl:if>


                  <xsl:if test="ArrayInfo/Controllers[DCStorageObject/ObjType='786']">
			<SelectionData>
			        <SubHeader>
		                       <xsl:attribute name="display"><xsl:value-of select="$strFluidCacheComponent"/></xsl:attribute>
                                </SubHeader>
				    <SelectionTable>
					    <Header>
						    <Data>
							    <xsl:attribute name="value"><xsl:value-of select="$strSeverity"/></xsl:attribute>
						    </Data>
					    </Header>
						 	
				      <xsl:choose>
					      <xsl:when test="SortHealthComp='true'">
						      <xsl:for-each select="ArrayInfo/Controllers[DCStorageObject/ObjType='786']">
							      <xsl:call-template name="FluidCacheComponent">
								      <xsl:with-param name="DCSObject" select="DCStorageObject"/>
								      <xsl:with-param name="tasks"><xsl:value-of select="$checkAdmin"/></xsl:with-param>
							      </xsl:call-template>
						      </xsl:for-each>
					      </xsl:when>
					      <xsl:otherwise>
						      <xsl:for-each select="ArrayInfo/Controllers[DCStorageObject/ObjType='786']">
								  <xsl:call-template name="FluidCacheComponent">
								      <xsl:with-param name="DCSObject" select="DCStorageObject"/>
								      <xsl:with-param name="tasks"><xsl:value-of select="$checkAdmin"/></xsl:with-param>
							      </xsl:call-template>
						      </xsl:for-each>
					      </xsl:otherwise>
				      </xsl:choose>
				  </SelectionTable>
			</SelectionData>
			</xsl:if>

        </xsl:otherwise>
      </xsl:choose>

      <HiddenTable>
				<!--This creates a hidden table that maps a "controller oid" to the "max size possible" for that layout/-->
				<xsl:for-each select="/OMA/ArrayInfo/Controllers/DCStorageObject"><xsl:call-template name="getClusterModeGivenControllerOID_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="/OMA/ArrayInfo/Controllers/DCStorageObject"><xsl:call-template name="getRebuildRateGivenControllerOID_HIDDEN_TABLE"/></xsl:for-each>
        <xsl:for-each select="/OMA/ArrayInfo/Controllers/DCStorageObject"><xsl:call-template name="getReconstructRateGivenControllerOID_HIDDEN_TABLE"/></xsl:for-each>
        <xsl:for-each select="/OMA/ArrayInfo/Controllers/DCStorageObject"><xsl:call-template name="getBGIRateGivenControllerOID_HIDDEN_TABLE"/></xsl:for-each>
        <xsl:for-each select="/OMA/ArrayInfo/Controllers/DCStorageObject"><xsl:call-template name="getChkConsistencyRateGivenControllerOID_HIDDEN_TABLE"/></xsl:for-each>
        <xsl:for-each select="/OMA/ArrayInfo/Controllers/DCStorageObject"><xsl:call-template name="getPatrolReadModeGivenControllerOID_HIDDEN_TABLE"/></xsl:for-each>
        <xsl:for-each select="/OMA/ArrayInfo/Controllers/DCStorageObject"><xsl:call-template name="getPatrolReadModeMaskGivenControllerOID_HIDDEN_TABLE"/></xsl:for-each>
			</HiddenTable>

    </DataArea>
	</xsl:template>

  <xsl:template name="getPatrolReadModeGivenControllerOID_HIDDEN_TABLE">
    <xsl:variable name="OID"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template></xsl:variable>
    <Data type="hidden">
      <xsl:attribute name="name">PatrolReadMode<xsl:value-of select="$OID"/></xsl:attribute>
      <xsl:attribute name="returnvalue"><xsl:choose><xsl:when test="PatrolReadMode"><xsl:value-of select="PatrolReadMode"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose></xsl:attribute>
    </Data>
  </xsl:template>

  <xsl:template name="getPatrolReadModeMaskGivenControllerOID_HIDDEN_TABLE">
    <xsl:variable name="OID"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template></xsl:variable>
    <Data type="hidden">
      <xsl:attribute name="name">PatrolReadModeMask<xsl:value-of select="$OID"/></xsl:attribute>
      <xsl:attribute name="returnvalue"><xsl:choose><xsl:when test="PatrolReadModeMask"><xsl:value-of select="PatrolReadModeMask"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose></xsl:attribute>
    </Data>
  </xsl:template>

  <xsl:template name="getChkConsistencyRateGivenControllerOID_HIDDEN_TABLE">
    <xsl:variable name="OID"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template></xsl:variable>
    <Data type="hidden">
      <xsl:attribute name="name">CheckConsistencyRate<xsl:value-of select="$OID"/></xsl:attribute>
      <xsl:attribute name="returnvalue"><xsl:choose><xsl:when test="CheckConsistencyRate"><xsl:value-of select="CheckConsistencyRate"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose></xsl:attribute>
    </Data>
  </xsl:template>

  <xsl:template name="getBGIRateGivenControllerOID_HIDDEN_TABLE">
    <xsl:variable name="OID"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template></xsl:variable>
    <Data type="hidden">
      <xsl:attribute name="name">BGIRate<xsl:value-of select="$OID"/></xsl:attribute>
      <xsl:attribute name="returnvalue"><xsl:choose><xsl:when test="BGIRate"><xsl:value-of select="BGIRate"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose></xsl:attribute>
    </Data>
  </xsl:template>

  <xsl:template name="getReconstructRateGivenControllerOID_HIDDEN_TABLE">
    <xsl:variable name="OID"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template></xsl:variable>
    <Data type="hidden">
      <xsl:attribute name="name">ReconstructRate<xsl:value-of select="$OID"/></xsl:attribute>
      <xsl:attribute name="returnvalue"><xsl:choose><xsl:when test="ReconstructRate"><xsl:value-of select="ReconstructRate"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose></xsl:attribute>
    </Data>
  </xsl:template>

  <xsl:template name="getRebuildRateGivenControllerOID_HIDDEN_TABLE">
    <xsl:variable name="OID"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template></xsl:variable>
    <Data type="hidden">
      <xsl:attribute name="name">RebuildRate<xsl:value-of select="$OID"/></xsl:attribute>
      <xsl:attribute name="returnvalue"><xsl:choose><xsl:when test="RebuildRate"><xsl:value-of select="RebuildRate"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose></xsl:attribute>
    </Data>
  </xsl:template>

  <xsl:template name="getClusterModeGivenControllerOID_HIDDEN_TABLE">
    <xsl:variable name="OID"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template></xsl:variable>
    <Data type="hidden">
      <xsl:attribute name="name">ClusterMode<xsl:value-of select="$OID"/></xsl:attribute>
      <xsl:attribute name="returnvalue"><xsl:value-of select="substring(AttributesMask,32,1)"/></xsl:attribute>
    </Data>
  </xsl:template>

	<xsl:template name="Component">
		<xsl:param name="DCSObject"/>
		<xsl:param name="tasks"/>
		<xsl:variable name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus" select="$DCSObject/Nexus"/>
			</xsl:call-template>
		</xsl:variable>
                <xsl:variable name="IsDeleteSecurityKeyEnabled">
			<xsl:call-template name="IsDeleteSecurityKeyPossible">
				<xsl:with-param name="Mask" select="$DCSObject/AttributesMask"/>
			</xsl:call-template>
		</xsl:variable>
			
            

    <Row tree="expand">
			<xsl:attribute name="name">controllergroup<xsl:value-of select="$ObjID"/>treecontrol</xsl:attribute>
			<SelectDataItem>
				<Data type="icon" align="left" width="20" height="1">
					<xsl:attribute name="value"><xsl:call-template name="getIcon1"><xsl:with-param name="status"><xsl:value-of select="$DCSObject/TreeStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
			</SelectDataItem>
			<ColumnData>
				<Data align="left" width="170" height="1">
					<xsl:attribute name="value"><xsl:value-of select="@ControllerName"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">javascript:parent.ct.select('Controller<xsl:value-of select="$ObjID"/>', 'Properties<xsl:value-of select="$ObjID"/>', 'Health<xsl:value-of select="$ObjID"/>');</xsl:attribute>
				</Data>
			</ColumnData>

			<xsl:variable name="checkAdmin">
				<xsl:choose>
					<xsl:when test="OMAUserRights = '7'">true</xsl:when>
					<xsl:otherwise>false</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<!-- var used for hiding tasks menu option -->
			<xsl:variable name="isEmpty">
				<xsl:call-template name="IsCurrentMethodMaskEmpty">
					<xsl:with-param name="Mask">
						<xsl:value-of select="$DCSObject/CurrentMethodMask"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>

                  <xsl:variable name="VAR_SecurityAction">

                     <xsl:choose> 
                        <xsl:when test="substring($DCSObject/AttributesMask,8,1)='0'">CreateSecurityKey</xsl:when>
                        <xsl:when test="substring($DCSObject/AttributesMask,8,1)='1'">DeleteOrChangeSecurityKey</xsl:when>
                     </xsl:choose>
</xsl:variable>
			<xsl:if test="$tasks='true'">
			<ColumnData>
				<xsl:choose>
					<xsl:when test="$isEmpty='0'">
						<!-- currentmethod mask isn't empty -->
						<Data type="select" align="left">
							<xsl:attribute name="name">CtrlTasks<xsl:value-of select="$ObjID"/></xsl:attribute>
							<xsl:choose>
						       <xsl:when test="(starts-with($GLOBAL_VAR_LOCALE, 'fr')) or (starts-with($GLOBAL_VAR_LOCALE, 'es')) or (starts-with($GLOBAL_VAR_LOCALE, 'de'))">
							       <xsl:attribute name="width">width:320px</xsl:attribute>
							   </xsl:when>
						       <xsl:otherwise>
						            <xsl:attribute name="width">width:230px</xsl:attribute>
						        </xsl:otherwise>
					        </xsl:choose>
							<Choice>			
								<xsl:choose>
									<!-- The below condition for for 12GBPS SAS HBA controller as it will be not having any controller tasks but reports -->
									<xsl:when test="substring($DCSObject/AttributesMask1,31,1)='1'">
										<xsl:attribute name="value"><xsl:value-of select="$strNoTask"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="$strSelectTask"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</Choice>
							<xsl:if test="string-length($DCSObject/MasterMethodMask) = 32">
								<xsl:call-template name="for-loop-list-box">
									<xsl:with-param name="Mask" select="$DCSObject/CurrentMethodMask"/>
									<xsl:with-param name="templateName" select="5"/>
								</xsl:call-template>

							</xsl:if>
                                          <xsl:if test="string-length($DCSObject/MasterMethodMask) = 32">
								<xsl:call-template name="for-loop-list-box">
									<xsl:with-param name="Mask" select="$DCSObject/CurrentMethodMask1"/>
									<xsl:with-param name="templateName" select="5"/>
                                                      <xsl:with-param name="AdditionalCurrentMethodMask" select="1"/>
								</xsl:call-template>

							</xsl:if>

						</Data>
						<Data type="button" width="100">
							<xsl:attribute name="href">javascript:onExecuteController(\"<xsl:value-of select="@ControllerName"/>\",\"<xsl:value-of select="$ObjID"/>\", \"<xsl:value-of select="$IsDeleteSecurityKeyEnabled"/>\",\"<xsl:value-of select="$VAR_SecurityAction"/>\");</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strExecute"/></xsl:attribute>
							<xsl:attribute name="tablebutton">true</xsl:attribute>
							<xsl:attribute name="browsercssfix">table_button_safari_omss_healthpage</xsl:attribute>
							<!-- The above property should be set for the table button to get rid of white spaces on the edges -->
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="select" align="left">
							<xsl:attribute name="name">CtrlTasks<xsl:value-of select="$ObjID"/></xsl:attribute>
							<xsl:choose>
						       <xsl:when test="(starts-with($GLOBAL_VAR_LOCALE, 'fr')) or (starts-with($GLOBAL_VAR_LOCALE, 'es')) or (starts-with($GLOBAL_VAR_LOCALE, 'de'))">
							       <xsl:attribute name="width">width:320px</xsl:attribute>
							   </xsl:when>
						       <xsl:otherwise>
						            <xsl:attribute name="width">width:230px</xsl:attribute>
						        </xsl:otherwise>
					        </xsl:choose>
							<Choice returnvalue="" default="true">
								<xsl:attribute name="value"><xsl:value-of select="$strNoTask"/></xsl:attribute>
							</Choice>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</ColumnData>
			</xsl:if>

			<xsl:if test="( (((substring($DCSObject/CurrentMethodMask,12,1)='1') and ($DCSObject/VendorID = '4')) or (substring($DCSObject/CurrentMethodMask,15,1)='1')) and $DCSObject/BusProtocol != '9' )">
				<ColumnData>
					<xsl:variable name="ctrlSasAddress">
						<xsl:value-of select="$DCSObject/SasAddress"/>
					</xsl:variable>

					<xsl:choose>
						<xsl:when test="$isEmpty='0'">
							<!-- currentmethod mask isn't empty -->
							<Data type="select" align="left">
								<xsl:attribute name="name">CtrlReports<xsl:value-of select="$ObjID"/></xsl:attribute>
								<xsl:choose>
						       <xsl:when test="(starts-with($GLOBAL_VAR_LOCALE, 'fr')) or (starts-with($GLOBAL_VAR_LOCALE, 'es')) or (starts-with($GLOBAL_VAR_LOCALE, 'de'))">
							       <xsl:attribute name="width">width:340px</xsl:attribute>
							   </xsl:when>
						       <xsl:otherwise>
						            <xsl:attribute name="width">width:250px</xsl:attribute>
						        </xsl:otherwise>
					           </xsl:choose>
								<Choice>
									<xsl:attribute name="value"><xsl:value-of select="$strSelectReport"/></xsl:attribute>
								</Choice>
								<xsl:if test="(substring($DCSObject/CurrentMethodMask,12,1)='1') and ($DCSObject/VendorID = '4')">
									<Choice>
										<xsl:attribute name="value"><xsl:value-of select="$strViewPatrolReadReport"/></xsl:attribute>
										<xsl:attribute name="returnvalue">2</xsl:attribute>
									</Choice>
									<Choice>
										<xsl:attribute name="value"><xsl:value-of select="$strViewCheckConsistencyReport"/></xsl:attribute>
										<xsl:attribute name="returnvalue">4</xsl:attribute>
									</Choice>
								</xsl:if>
								<xsl:if test="substring($DCSObject/CurrentMethodMask,15,1)='1'">
									<Choice>
										<xsl:attribute name="value"><xsl:value-of select="$strOccupancySlotReport"/></xsl:attribute>
										<xsl:attribute name="returnvalue">8</xsl:attribute>
									</Choice>
								</xsl:if>
								<Choice>
										<xsl:attribute name="value"><xsl:value-of select="$strHDDFirmwareVersion"/></xsl:attribute>
										<xsl:attribute name="returnvalue">16</xsl:attribute>
								</Choice>
							</Data>
							<Data type="button" width="100">
								<xsl:attribute name="href">javascript:onExecuteReport(\"<xsl:value-of select="@ControllerName"/>\",\"<xsl:value-of select="$ObjID"/>\",\"<xsl:value-of select="$ctrlSasAddress"/>\");</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strExecute"/></xsl:attribute>
								<xsl:attribute name="tablebutton">true</xsl:attribute>
								<xsl:attribute name="browsercssfix">table_button_safari_omss_healthpage</xsl:attribute>
								<!-- The above property should be set for the table button to get rid of white spaces on the edges -->
							</Data>
						</xsl:when>
						<xsl:otherwise>
							<Data type="select" align="left">
								<xsl:attribute name="name">CtrlReports<xsl:value-of select="$ObjID"/></xsl:attribute>
								<xsl:choose>
						       <xsl:when test="(starts-with($GLOBAL_VAR_LOCALE, 'fr')) or (starts-with($GLOBAL_VAR_LOCALE, 'es')) or (starts-with($GLOBAL_VAR_LOCALE, 'de'))">
							       <xsl:attribute name="width">width:340px</xsl:attribute>
							   </xsl:when>
						       <xsl:otherwise>
						            <xsl:attribute name="width">width:250px</xsl:attribute>
						        </xsl:otherwise>
					           </xsl:choose>
								<Choice returnvalue="" default="true">
									<xsl:attribute name="value"><xsl:value-of select="$strNoReports"/></xsl:attribute>
								</Choice>
							</Data>
						</xsl:otherwise>
					</xsl:choose>
				</ColumnData>
			</xsl:if>

			<!-- virtual disk -->
			<ChildrenRows>
				<xsl:choose>
					<xsl:when test="../VirtualDisks/DCStorageObject">
					<Row>
						<ColumnData>
						<!-- VD details link -->
							<Data>
							<xsl:attribute name="value"><xsl:value-of select="$strVDDetails"/></xsl:attribute>
							<xsl:attribute name="link">true</xsl:attribute>
							<xsl:attribute name="href">javascript:parent.ct.select('VD<xsl:value-of select="$ObjID"/>', 'VDSNB<xsl:value-of select="$ObjID"/>', 'Information<xsl:value-of select="$ObjID"/>');</xsl:attribute>
							</Data>
						</ColumnData>
					</Row>


						<xsl:for-each select="../VirtualDisks/DCStorageObject[IsSSC = '0' or not(IsSSC)]">
							<xsl:choose>
								<xsl:when test="SpanNum"></xsl:when><!-- do not show child span vds -->
								<xsl:otherwise>
									<Row>
										<SelectDataItem>
											<Data type="icon" align="left" width="20" height="1">
												<xsl:attribute name="value"><xsl:call-template name="getIcon1"><xsl:with-param name="status"><xsl:value-of select="ObjStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
											</Data>
										</SelectDataItem>
										<ColumnData>
											<Data width="150">
												<xsl:attribute name="value"><xsl:value-of select="Name"/></xsl:attribute>
                                                                                                <xsl:if test="ObjStatus!=2">
                                                                                                <xsl:attribute name="link">true</xsl:attribute>
                                                                                                <xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.ArrayWebPlugin&amp;ControllerOID=.<xsl:value-of select="GlobalNo"/>&amp;ControllerName=<xsl:value-of select="../../@ControllerName"/>&amp;VirtualDiskOID=<xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template>&amp;VirtualDiskName=<xsl:value-of select="Name"/>&amp;RaidLayout=<xsl:value-of select="Layout"/>&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin!help=stprhl&amp;help=adprin</xsl:attribute>
                                                                                                </xsl:if>
											</Data>
										</ColumnData>
										<ColumnData>
											<Data>
												<xsl:attribute name="value"><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType" 		select="Layout"/></xsl:call-template></xsl:attribute>
											</Data>
										</ColumnData>
									</Row>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
				  <!-- No VD. This is is needed to keep alignment in the table, otherwise alignment will be off if a controller has a VD and another one doesn't. -->
					<Row>
						<ColumnData>
								<Data width="150">
									<xsl:attribute name="value"><xsl:value-of select="$strNoVirtualDisks"/></xsl:attribute>
								</Data>
						</ColumnData>
					</Row>
				</xsl:otherwise>
			</xsl:choose>
			</ChildrenRows>

		</Row>
	</xsl:template>
	
	
	<xsl:template name="PCIESSDComponent">
		<xsl:param name="DCSObject"/>
		<xsl:variable name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus" select="$DCSObject/Nexus"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- var used for hiding tasks menu option -->
			<xsl:variable name="isEmpty">
				<xsl:call-template name="IsCurrentMethodMaskEmpty">
					<xsl:with-param name="Mask">
						<xsl:value-of select="$DCSObject/CurrentMethodMask"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
		<xsl:variable name="IsDiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask">
					<xsl:value-of select="../ArrayDisks/DCStorageObject/AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="IsSASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol">
					<xsl:value-of select="../ArrayDisks/DCStorageObject/BusProtocol"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
       	<xsl:variable name="ADID">
			<xsl:choose>
				<xsl:when test="$IsSASorSATA='1' and $IsDiskInEnclosure='1'">
					<xsl:value-of select="../ArrayDisks/DCStorageObject/Channel"/>:<xsl:value-of select="../ArrayDisks/DCStorageObject/EnclosureID"/>:<xsl:value-of select="../ArrayDisks/DCStorageObject/TargetID"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
			
			<xsl:variable name="chnlparamID">
					<xsl:call-template name="ModNexus">
							<xsl:with-param name="nexus">
								<xsl:value-of select="../Channels/DCStorageObject/Nexus"/>
							</xsl:with-param>
					</xsl:call-template>
			</xsl:variable>
			<xsl:variable name="enclparamID">
					<xsl:call-template name="ModNexus">
						<xsl:with-param name="nexus">
								<xsl:value-of select="../Enclosures/DCStorageObject/Nexus"/>
						</xsl:with-param>
					</xsl:call-template>
			</xsl:variable>	
		<Row tree="expand">
			<ColumnData>
				<Data type="icon" width="20" align="left" height="1">
					<xsl:attribute name="value"><xsl:call-template name="getIcon1"><xsl:with-param name="status"><xsl:value-of select="$DCSObject/TreeStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
			
				<Data align="left" width="170">
					<xsl:attribute name="value"><xsl:value-of select="@ControllerName"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">javascript:parent.ct.select('Controller<xsl:value-of select="$ObjID"/>', 'Properties<xsl:value-of select="$ObjID"/>', 'Health<xsl:value-of select="$ObjID"/>');</xsl:attribute>
				</Data>
			</ColumnData>
			<xsl:if test="(((substring($DCSObject/CurrentMethodMask,12,1)='1') and ($DCSObject/VendorID = '4')) or (substring($DCSObject/CurrentMethodMask,15,1)='1'))">
				<ColumnData>
					<xsl:variable name="ctrlSasAddress">
						<xsl:value-of select="$DCSObject/SasAddress"/>
					</xsl:variable>

					<xsl:choose>
						<xsl:when test="$isEmpty='0'">
							<!-- currentmethod mask isn't empty -->
							<Data type="select" align="left">
								<xsl:attribute name="name">CtrlReports<xsl:value-of select="$ObjID"/></xsl:attribute>
								<xsl:choose>
						       <xsl:when test="(starts-with($GLOBAL_VAR_LOCALE, 'fr')) or (starts-with($GLOBAL_VAR_LOCALE, 'es')) or (starts-with($GLOBAL_VAR_LOCALE, 'de'))">
							       <xsl:attribute name="width">width:320px</xsl:attribute>
							   </xsl:when>
						       <xsl:otherwise>
						            <xsl:attribute name="width">width:230px</xsl:attribute>
						        </xsl:otherwise>
					           </xsl:choose>
								<Choice>
									<xsl:attribute name="value"><xsl:value-of select="$strSelectReport"/></xsl:attribute>
								</Choice>
								<xsl:if test="(substring($DCSObject/CurrentMethodMask,12,1)='1') and ($DCSObject/VendorID = '4')">
									<Choice>
										<xsl:attribute name="value"><xsl:value-of select="$strViewPatrolReadReport"/></xsl:attribute>
										<xsl:attribute name="returnvalue">2</xsl:attribute>
									</Choice>
									<Choice>
										<xsl:attribute name="value"><xsl:value-of select="$strViewCheckConsistencyReport"/></xsl:attribute>
										<xsl:attribute name="returnvalue">4</xsl:attribute>
									</Choice>
								</xsl:if>
								<xsl:if test="substring($DCSObject/CurrentMethodMask,15,1)='1'">
									<Choice>
										<xsl:attribute name="value"><xsl:value-of select="$strOccupancySlotReport"/></xsl:attribute>
										<xsl:attribute name="returnvalue">8</xsl:attribute>
									</Choice>
								</xsl:if>
							</Data>
							<Data type="button" width="100">
								<xsl:attribute name="href">javascript:onExecuteReport(\"<xsl:value-of select="@ControllerName"/>\",\"<xsl:value-of select="$ObjID"/>\",\"<xsl:value-of select="$ctrlSasAddress"/>\");</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strExecute"/></xsl:attribute>
								<xsl:attribute name="tablebutton">true</xsl:attribute>
								<xsl:attribute name="browsercssfix">table_button_safari_omss_healthpage</xsl:attribute>
								<!-- The above property should be set for the table button to get rid of white spaces on the edges -->
							</Data>
						</xsl:when>
						<xsl:otherwise>
							<Data type="select" align="left">
								<xsl:attribute name="name">CtrlReports<xsl:value-of select="$ObjID"/></xsl:attribute>
								<xsl:choose>
						       <xsl:when test="(starts-with($GLOBAL_VAR_LOCALE, 'fr')) or (starts-with($GLOBAL_VAR_LOCALE, 'es')) or (starts-with($GLOBAL_VAR_LOCALE, 'de'))">
							       <xsl:attribute name="width">width:320px</xsl:attribute>
							   </xsl:when>
						       <xsl:otherwise>
						            <xsl:attribute name="width">width:230px</xsl:attribute>
						        </xsl:otherwise>
					           </xsl:choose>
								<Choice returnvalue="" default="true">
									<xsl:attribute name="value"><xsl:value-of select="$strNoReports"/></xsl:attribute>
								</Choice>
							</Data>
						</xsl:otherwise>
					</xsl:choose>
				</ColumnData>
			</xsl:if>

			<!-- physical disk -->
			<ChildrenRows>
				<xsl:choose>
					<xsl:when test="../ArrayDisks/DCStorageObject">
					<Row>
						<ColumnData>
						<!-- PD details link -->//ArrayDisks.1.0.1.0.0
							<Data>
							<xsl:attribute name="value"><xsl:value-of select="$strDeviceDetails"/></xsl:attribute>
							<xsl:attribute name="link">true</xsl:attribute>
							<xsl:attribute name="href">javascript:parent.ct.select('ArrayDisks<xsl:value-of select="$chnlparamID"/><xsl:value-of select="$enclparamID"/>', '', '');</xsl:attribute>
			   			</Data>
						</ColumnData>
					</Row>
                    <xsl:for-each select="../ArrayDisks/DCStorageObject">
					              <xsl:sort select="Channel" data-type="number" order="ascending"/>
					              <xsl:sort select="TargetID" data-type="number" order="ascending"/>
								  <Row>
										<SelectDataItem>
											<Data type="icon" align="left" width="20" height="1">
												<xsl:attribute name="value"><xsl:call-template name="getIcon1"><xsl:with-param name="status"><xsl:value-of select="ObjStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
											</Data>
										</SelectDataItem>
										<ColumnData>
										   <xsl:choose>
				                              <xsl:when test="$IsSASorSATA='1' and $IsDiskInEnclosure='1'">
											    <Data width="150">
												<xsl:attribute name="value"><xsl:value-of select="$strDevice"/><xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
												</Data>
										    </xsl:when>
											<xsl:otherwise>
											   <xsl:attribute name="value"><xsl:value-of select="$strDevice"/><xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>	 
										</ColumnData>
										<ColumnData>
											<Data>
												<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
											</Data>
										</ColumnData>
									</Row>
								
						</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
				  <!-- No PD. This is is needed to keep alignment in the table, otherwise alignment will be off if a controller has a PD and another one doesn't. -->
					<Row>
						<ColumnData>
								<Data width="150">
									<xsl:attribute name="value"><xsl:value-of select="$strNoDevices"/></xsl:attribute>
								</Data>
						</ColumnData>
					</Row>
				</xsl:otherwise>
			</xsl:choose>
			</ChildrenRows>
	
		</Row>
	</xsl:template>
	

<xsl:template name="FluidCacheComponent">
		<xsl:param name="DCSObject"/>
		<xsl:variable name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus" select="$DCSObject/Nexus"/>
			</xsl:call-template>
		</xsl:variable>
		<Row tree="expand">
			<ColumnData>
				<Data type="icon" width="20" align="left" height="1">
					<xsl:attribute name="value"><xsl:call-template name="getIcon1"><xsl:with-param name="status"><xsl:value-of select="$DCSObject/TreeStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
			
				<Data align="left" width="170">
					<xsl:attribute name="value"><xsl:value-of select="@ControllerName"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">javascript:parent.ct.select('Controller<xsl:value-of select="$ObjID"/>', 'Properties<xsl:value-of select="$ObjID"/>', 'Health<xsl:value-of select="$ObjID"/>');</xsl:attribute>
				</Data>
			</ColumnData>
			
			   <ChildrenRows>
				<xsl:choose>
					<xsl:when test="../FluidCachedDisks/DCStorageObject">
                                                <xsl:for-each select="../FluidCachedDisks/DCStorageObject">
					             	  <Row>
								<SelectDataItem>
									<Data type="icon" align="left" width="20" height="1">
									<xsl:attribute name="value"><xsl:call-template name="getIcon1"><xsl:with-param name="status"><xsl:value-of select="ObjStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
									</Data>
								</SelectDataItem>
					                        <ColumnData>
                                                                    <Data width="150">
										<xsl:attribute name="value"><xsl:value-of select="CacheLunName"/></xsl:attribute>
								    </Data>
								</ColumnData>
								<ColumnData>
									<Data>
										<xsl:attribute name="value"><xsl:call-template name="GetFluidCacheState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
									</Data>
								</ColumnData>
							  </Row>
								
						</xsl:for-each>
				      </xsl:when>
				      <xsl:otherwise>
				  
					<Row>
						<ColumnData>
								<Data width="150">
									<xsl:attribute name="value"><xsl:value-of select="$strNoFluidCacheDisks"/></xsl:attribute>
								</Data>
						</ColumnData>
					</Row>
				</xsl:otherwise>
			  </xsl:choose>
			</ChildrenRows>
	
		</Row>
	</xsl:template>
	
	<xsl:template name="getIcon1">
		    <xsl:param name="status"/>
		    <xsl:if test="$status='0'">/oma/images/status_icons/statusUnknown_16.png</xsl:if>
		    <xsl:if test="$status='1'">/oma/images/status_icons/statusUnknown_16.png</xsl:if>
		    <xsl:if test="$status='2'">/oma/images/status_icons/statusOK_16.png</xsl:if>
		    <xsl:if test="$status='3'">/oma/images/status_icons/nonCritical_16.png</xsl:if>
		    <xsl:if test="$status='4'">/oma/images/status_icons/critical_16.png</xsl:if>
		    <xsl:if test="$status='5'">/oma/images/status_icons/critical_16.png</xsl:if>
		    <xsl:if test="$status='6'">/oma/images/action_icons/abort_16.png</xsl:if>
		    <xsl:if test="$status='7'">/oma/images/progress.gif</xsl:if>
		    <xsl:if test="$status='8'">/oma/images/action_icons/suspend_16.png</xsl:if>
		    <xsl:if test="$status='9'">/oma/images/action_icons/resume_16.png</xsl:if>
		    <xsl:if test="$status='10'">/oma/images/pending.gif</xsl:if>
     </xsl:template>
     <xsl:template match="*">
</xsl:template>
</xsl:stylesheet>

