<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
      <xsl:import href="vdtbl.xsl"/>
	<xsl:output method="xml"/>
     
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
                  <DataArea printable="false" email="false" validate="true" Refresh="false" exportdata="false" onLoad="true">
                  
                  <xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
                  <xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.sm.webplugins.CtrlManagePinnedCacheWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;Return=true</xsl:attribute>
                 
			<xsl:call-template name="scripts"/>

			<script language="javascript">
			      function validate()
                        {
                             return true;
                        }
			      function initializationRoutine()
                        {
                              ;
                        }
                        function reloadPage()
      			{
          			     document.location.href = top.gnv.appendVID(document.URL+"&amp;Refresh=true");
      			}
                  </script>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strOfflineVDswithPinnedCache"/><xsl:value-of select="/OMA/ControllerName"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">javascript:reloadPage()</xsl:attribute>
				</Data>

			</CustomButton>
		
		<TableData name="T" columnspacing="true">
			<Header>
			  <xsl:call-template name="VirtualDiskTableHeader"/>
			</Header>
                       <xsl:for-each select="VirtualDisks/DCStorageObject[VDiskPinnedCache='1']">
                              <xsl:sort select="LogicalDriveNum" data-type="number" order="ascending"/>
					<xsl:call-template name="VirtualDiskTableRows">
						<xsl:with-param name="tasks">false</xsl:with-param>
						<xsl:with-param name="VDLink">false</xsl:with-param>
					</xsl:call-template>
				</xsl:for-each>
		
		</TableData>	
</DataArea>
</xsl:template>
</xsl:stylesheet>


