<?xml version="1.0" encoding="UTF-8"?>
<!-- . -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="adtbl.xsl"/>
	<xsl:import href="vdtbl.xsl"/>
	<xsl:template match="OMA">
		<DataArea exportdata="false" email="false" printable="false">
              <!--xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
              <xsl:attribute name="backpagetarget"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute-->

			<xsl:call-template name="scripts"/>
			
					<AlertMessage>
					   <!--xsl:attribute name="display"><xsl:value-of select="$strTitle1"/></xsl:attribute-->
					   <xsl:attribute name="display"><xsl:choose><xsl:when test="//convertOption ='1'"><xsl:value-of select="$strAssignHdr"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnassignHdr"/></xsl:otherwise></xsl:choose></xsl:attribute>
					</AlertMessage>
				
						<TableData>
							<Header>
								<Data value="{$strArrayDiskMRTMNR}" width="400"/>
					            <Data value="{$strFreeSpaceMRTMNR}"/>
							</Header>
							<xsl:if test="count(DestinationDisk/ArrayDisks/DCStorageObject) > 0">
														
										<xsl:for-each select="DestinationDisk/ArrayDisks/DCStorageObject">
											<xsl:call-template name="AssignedDisks"/>
										</xsl:for-each>
							</xsl:if>
						</TableData>
					 	
				
			<BottomCustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strBackToVDInfo"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;help=vdprin</xsl:attribute>
				</Data>
			</BottomCustomButton>
		</DataArea>
	</xsl:template>
	
	<xsl:template name="AssignedDisks">
		<xsl:variable name="ArrayDiskSize">
			<xsl:value-of select="Length"/>
		</xsl:variable>
		<Row>
			
				<Data name="Test" columnspacing="true" editable="false" type="usting" display="Test">
					<xsl:choose>
						<xsl:when test="EnclosureID">
							<!-- SAS -->
							<xsl:attribute name="value"><xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<!-- SCSI -->
							<xsl:attribute name="value"><xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Data>
			
			
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSize div (1024*1024*1024)),'#,##0.00 GB')"/></xsl:attribute>
				</Data>
			
		</Row>
	</xsl:template>
	
</xsl:stylesheet>
