<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
        <!-- This hspoltbl is used only for the CLI command "globalinfo"--> 
	<!-- Dedicated HotSpare TABLE HEADER -->
	<xsl:template name="DedicatedHotSparePolicyHeaders">
	         
            <Data name="Layout" editable="false" type="ustring" ignoreonweb="true">
		    <xsl:attribute name="display"><xsl:value-of select="$strRAIDLevels"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="$strRAIDLevels"/></xsl:attribute>
	    </Data>
             
            <Data name="HSCount" editable="false" type="ustring" ignoreonweb="true">
		    <xsl:attribute name="display"><xsl:value-of select="$strMinNumDHSDisks"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="$strMinNumDHSDisks"/></xsl:attribute>
	    </Data>
             
            <Data name="WarningLevel" editable="false" type="ustring" ignoreonweb="true">
		    <xsl:attribute name="display"><xsl:value-of select="$strWarnLevel"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="$strWarnLevel"/></xsl:attribute>
	    </Data>
             
	</xsl:template>
        
        <!--Global HotSpare TABLE HEADER-->
        <xsl:template name="GlobalHotSparePolicyHeaders">
	  
	    <Data name="HSCount" editable="false" type="ustring" ignoreonweb="true">
		    <xsl:attribute name="display"><xsl:value-of select="$strMinNumGHSDisks"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="$strMinNumGHSDisks"/></xsl:attribute>
	    </Data>
             
            <Data name="WarningLevel" editable="false" type="ustring" ignoreonweb="true">
		    <xsl:attribute name="display"><xsl:value-of select="$strWarnLevel"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="$strWarnLevel"/></xsl:attribute>
	    </Data>
            <Data name="ConsiderGHSInVDStatus" editable="false" type="ustring" ignoreonweb="true">
		    <xsl:attribute name="display"><xsl:value-of select="$strConsiderGHSInVDStatus"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="$strConsiderGHSInVDStatus"/></xsl:attribute>
	    </Data>
             
	</xsl:template>
	
  
	<!-- DHS HotSpare TABLE ROWS -->
	<xsl:template name="DedicatedHotSparePolicyRows">
	   <xsl:param name="tasks"/>
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<Row>
                   <xsl:choose>     
		     <xsl:when test="Layout != 0">   
                       <Data editable="false" type="ustring" ignoreonweb="true">
			 <xsl:attribute name="name"><xsl:value-of select="$strRAIDLevels"/><xsl:value-of select="position()"/></xsl:attribute>
			 <xsl:attribute name="value">
                                   <xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType"><xsl:value-of select="Layout"/></xsl:with-param></xsl:call-template>
                         </xsl:attribute>
		       </Data>
               
                      <Data editable="false" type="ustring" ignoreonweb="true">
			 <xsl:attribute name="name"><xsl:value-of select="$strMinNumDHSDisks"/><xsl:value-of select="position()"/></xsl:attribute>
			 <xsl:attribute name="value">
                             <xsl:choose>     
		               <xsl:when test="HSCount != ''">
                                     <xsl:value-of select="HSCount"/>
                               </xsl:when>
                               <xsl:otherwise>
                                 <xsl:value-of select="$strNotAssigned"/>
                            </xsl:otherwise>
                           </xsl:choose>
                         </xsl:attribute>
		      </Data>
               
                      <Data editable="false" type="ustring" ignoreonweb="true">
		         <xsl:attribute name="name"><xsl:value-of select="$strWarnLevel"/><xsl:value-of select="position()"/></xsl:attribute>
                         <xsl:attribute name="value">
                            <xsl:choose>     
		               <xsl:when test="WarningLevel != '' and WarningLevel != 0">
                                 <xsl:call-template name="GetWarningLevels"><xsl:with-param name="warnvalue"><xsl:value-of select="WarningLevel"/></xsl:with-param></xsl:call-template>
                               </xsl:when>
                            <xsl:otherwise>
                                 <xsl:value-of select="$strNotAssigned"/>
                            </xsl:otherwise>
                           </xsl:choose>
                        </xsl:attribute>
		      </Data>
                     </xsl:when>
                   </xsl:choose>
                </Row>    
        </xsl:template>
        
        <!-- Global HotSpare TABLE ROWS -->
	<xsl:template name="GlobalHotSparePolicyRows">
	   <xsl:param name="tasks"/>
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<Row>
                    <Data editable="false" type="ustring" ignoreonweb="true">
			 <xsl:attribute name="name"><xsl:value-of select="$strMinNumGHSDisks"/><xsl:value-of select="position()"/></xsl:attribute>
			 <xsl:attribute name="value"><xsl:value-of select="HSCount"/></xsl:attribute>
		    </Data>
               
                    <Data editable="false" type="ustring" ignoreonweb="true">
		         <xsl:attribute name="name"><xsl:value-of select="$strWarnLevel"/><xsl:value-of select="position()"/></xsl:attribute>
                         <xsl:attribute name="value">
                            <xsl:choose>     
		               <xsl:when test="WarningLevel != '' and WarningLevel != 0">
                                 <xsl:call-template name="GetWarningLevels"><xsl:with-param name="warnvalue"><xsl:value-of select="WarningLevel"/></xsl:with-param></xsl:call-template>
                               </xsl:when>
                            <xsl:otherwise>
                                 <xsl:value-of select="$strNotAssigned"/>
                            </xsl:otherwise>
                           </xsl:choose>
                        </xsl:attribute>
		    </Data>
                    <Data editable="false" type="ustring" ignoreonweb="true">
		         <xsl:attribute name="name"><xsl:value-of select="$strConsiderGHSInVDStatus"/><xsl:value-of select="position()"/></xsl:attribute>
                         <xsl:attribute name="value">
                                  <xsl:call-template name="GetConsiderGHS"><xsl:with-param name="ghsvalue"><xsl:value-of select="ConsiderGHSInVDStatus"/></xsl:with-param></xsl:call-template>
                        </xsl:attribute>
		    </Data>
                </Row>    
        </xsl:template>        
</xsl:stylesheet>
