<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	
	
	<xsl:import href="Utils.xsl"/>
      <xsl:import href="fclnctbl.xsl"/>
	
	<xsl:template match="OMA">
        <DataArea exportdata="false" validate="false" onLoad="true" ignoreJumpBar="true">
                <!--BottomCustomButton>
			  <Data>
					<xsl:attribute name="display"><xsl:value-of select="$strExitWizard"/></xsl:attribute>
 				    	<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.FluidCacheInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;help=fldcach</xsl:attribute>						
			   </Data>
  	        </BottomCustomButton-->
		<CustomButton>	   
                        <Data name="Refresh">
					  <xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					   <xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.FluidCacheLicenseWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;help=fldclic</xsl:attribute>
					  
                        </Data>	 
	         </CustomButton>
           
	  <xsl:call-template name="scripts"/>
	   <script language="javascript">
	       function initializationRoutine() 
	       {
             	 
	       }
            
	       function onUploadExecute()
	       {  
		      var origurl = GetLocalUrl();
		      var filepath = document.getElementById("FilePath").value;
		      var indexextension = filepath.lastIndexOf(".");
	   	      var FileExtension = filepath .substring(indexextension,filepath.length);
		      
                      if(filepath=="" || filepath.length==0|| filepath==null)
                      {
                           alert('<xsl:value-of select="$strEnterFilePath"/>'); 
			   return ;
               
                     }
	             else if(FileExtension != ".xml")
                     {          
                           alert('<xsl:value-of select="$strInvalidFilePath"/>');		
			   return ;
                
                     } 
			  
			  
	       document.getElementById("dataarea").encoding = "multipart/form-data";
              document.getElementById("dataarea").enctype = "multipart/form-data";
              var FileFormat = "licXML";
              var Decryptionpassword="";
              var CertificateType="Server";
	    	  var ControllerOID = '<xsl:value-of select="/OMA/ControllerOID"/>' ;
		  var ControllerName = '<xsl:value-of select="/OMA/ControllerName"/>' ;	
				var url = "./OMSSUploadCert?FileFormat="+FileFormat+"&amp;ControllerName="+ControllerName+"&amp;ControllerOID="+ControllerOID;
								
				document.dataarea.action = top.gnv.appendVID(url);
				document.dataarea.submit();	
           
	     }
		   
		  function validate()
                  { 
		     var errorMsg = "";
		      return true;
 
		   }
		   
    	</script>
	 <PageTitle>
               <xsl:attribute name="display"><xsl:value-of select="$strTitle"/></xsl:attribute>
         </PageTitle>
	<xsl:choose>
		<xsl:when test="UploadStatus ='2305'">
		<AlertMessage>
			<xsl:attribute name="display"><xsl:value-of select="$strErrorID257"/></xsl:attribute>
			<xsl:attribute name="status">3</xsl:attribute>
		</AlertMessage>
		</xsl:when>
		<xsl:when test="UploadStatus ='2302'">
		<AlertMessage>
			<xsl:attribute name="display"><xsl:value-of select="$strErrorID254"/></xsl:attribute>
			<xsl:attribute name="status">3</xsl:attribute>
		</AlertMessage>
		</xsl:when>
		<xsl:when test="UploadStatus ='2329'">
		<AlertMessage>
			<xsl:attribute name="display"><xsl:value-of select="$strErrorID281"/></xsl:attribute>
			<xsl:attribute name="status">3</xsl:attribute>
		</AlertMessage>
		</xsl:when>
		<xsl:when test="UploadStatus ='2331'">
		<AlertMessage>
			<xsl:attribute name="display"><xsl:value-of select="$strErrorID283"/></xsl:attribute>
			<xsl:attribute name="status">3</xsl:attribute>
		</AlertMessage>
		</xsl:when>
		<xsl:when test="UploadStatus =0">
		<AlertMessage>
			<xsl:attribute name="display"><xsl:value-of select="$strUploadSuccess"/></xsl:attribute>
			<xsl:attribute name="status">2</xsl:attribute>
		</AlertMessage>
		</xsl:when>
	</xsl:choose>
	 
	 <ListData type="custom">
		<xsl:call-template name="LicenseViewHeader"/>
		 <xsl:call-template name="LicenseView"/>
	</ListData>	
	 <xsl:call-template name="LicenseUpload"/>
	   
    </DataArea>
</xsl:template>

<xsl:template name="LicenseUpload">
  <TableData name="LicenseUpload">
       <SubHeader>
	      <xsl:attribute name="display"><xsl:value-of select="$strSubHeader"/></xsl:attribute>
       </SubHeader>
      
            <Row>
		       <Data name="License" editable="false" type="ustring" align="left" width="40%" noborder="true">
		           <xsl:attribute name="value"><xsl:value-of select="$strLabelLicense"/></xsl:attribute>
		       </Data>
	               <Data name="FilePath" type="file" maxlength="32" size="32" align="left" noborderright="true" width="30%" noborder="true">
                        <xsl:attribute name="returnvalue"/>
                       </Data>
                       <Data name="UploadButton" type="button" align="left" width="30%" noborder="true">
					<xsl:attribute name="display"><xsl:value-of select="$strApply"/></xsl:attribute>
					<xsl:attribute name="href">javascript:onUploadExecute();</xsl:attribute>
					<xsl:attribute name="tablebutton">true</xsl:attribute> 
		       </Data>
                       			   
	    </Row>
   </TableData>	
</xsl:template>

</xsl:stylesheet>

