<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	
	<xsl:template name="FluidCacheDiskTableHeader">
		<xsl:param name="tasks"/>
       <xsl:variable name="GLOBAL_VAR_VD_LOCALE"><xsl:value-of select="/OMA/Locale"/></xsl:variable>
       <xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
        
 
       		<!-- ignore on web is set to true since it's only needed for scripts using the cli -->
		
		<Data name="Status" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
		</Data>
		<Data name="Name" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
		</Data>
                <Data name="State" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
		</Data>
           
		<xsl:if test="$tasks='true'">
			<Data name="Delete" editable="false" type="ustring" noborderright="true" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strTasks"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strTasks"/></xsl:attribute>
			</Data>
			<!-- The Rows have one extra row for the execute button.  Including a blank <Data> tag here keeps the line that underlines the headers continuous -->
			<Data name="exbut" editable="false" type="ustring" ignoreoncli="true" align="center">
				<xsl:attribute name="display">Execute</xsl:attribute>
				<xsl:attribute name="value"> </xsl:attribute>
			</Data>
		</xsl:if>
          
		<xsl:if test="(//FluidCachedDisks/DCStorageObject/Progress)">
			<!-- See if any VDisk has a progress.  If so, show the header for the table -->
			<Data name="Progress" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strProgress"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strProgress"/></xsl:attribute>
			</Data>
		</xsl:if>
           <Data name="ObjType" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strEMMType"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strEMMType"/></xsl:attribute>
		</Data>
	
	
		<Data name="DeviceName" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strDeviceName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strDeviceName"/></xsl:attribute>
		</Data>
		<Data name="Size" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strSize"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strSize"/></xsl:attribute>
		</Data>
            <!--xsl:if test="//FluidCacheDiskDirtyBytes"> 

            <Data name="DirtyData" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strDirtyData"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strDirtyData"/></xsl:attribute>
		</Data>
		</xsl:if-->
            <!--xsl:if test="//HighAvailabilityMode= 'False' or $dynamicView = 'false'"-->
            <Data name="WriteMode" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strWriteMode"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strWriteMode"/></xsl:attribute>
		</Data>
            <!--/xsl:if-->
 
            <Data name="OpWriteMode" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strOpWriteMode"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strOpWriteMode"/></xsl:attribute>
		</Data>
		
		
	</xsl:template>
	
	<xsl:template name="FluidCacheDiskTableRows">
		<xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="tasks"/>
		<xsl:call-template name="scripts"/>
		
		<xsl:variable name="fcdiskid">
			<xsl:value-of select="$ObjID"/>
		</xsl:variable>
		<xsl:variable name="FCDName">
			<xsl:value-of select="CacheLunName"/>
		</xsl:variable>
             <xsl:variable name="GLOBAL_VAR_VD_LOCALE"><xsl:value-of select="/OMA/Locale"/></xsl:variable>   
              <xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
      
		<script language="javascript">
			//*********************************************************************************************************
			//* Javascript function to redirect the local DataArea page to the
			//* appropriate web plugin which handles the action selected from the drop-down menu.
			//*********************************************************************************************************//
			function onExecute(FCDObjID,FluidCacheDeviceName) 
                        {
                                 var FluidCacheTask = "FCDTasks" + FCDObjID;
                                 var Action = document.getElementById(FluidCacheTask).value;
                                 
                                 
                                 
                                 // Submit URL
                                 var SubmitUrl = "./SubmitForm?plugin=com.dell.sm.webplugins.FCDExecuteActionWebPlugin&amp;Action="+Action+"&amp;FluidCacheDeviceName="+FluidCacheDeviceName;
                                 
                                // Action Code
                                if(Action == "-") 
                                 { 
                                        alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
                                 }      
                                 else if(Action == '1')
                                 {    
                                      document.dataarea.action = top.gnv.appendVID(SubmitUrl);
                                      document.dataarea.submit();
 
                                 }
                                 else
                                 {    
                                         <!-- should not reach here -->
                                 }
                        }
		</script>

			
		
            
		<xsl:if test="count(ParentVDID)= 0">
			<!-- Only display main virtual disks, not child VDisks -->
			<Row height="30px">
				<!-- ignore on web is set to true since it's only needed for scripts using the cli -->
				
				<Data type="status" align="center">
					<xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
				</Data>
				<Data editable="false" type="ustring" display="{Name}">
					<xsl:attribute name="name"><xsl:value-of select="$strName"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="CacheLunName"/></xsl:attribute>
					
				</Data>

				<Data name="State" editable="false" type="ustring" display="Test" align="center">
					<xsl:attribute name="name"><xsl:value-of select="$strState"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetFluidCacheState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
				
				<xsl:variable name="isEmpty">
					<xsl:call-template name="IsCurrentMethodMaskEmpty">
						<xsl:with-param name="Mask">
							<xsl:value-of select="CurrentMethodMask"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
                       

				<xsl:if test="$tasks='true'">
					<xsl:choose>
						<!--check to see if methods even exist -->
						<xsl:when test="$isEmpty='0'">
							<!-- currentmethod mask isn't empty -->
							<Data value="tasks" type="select" noborderright="true" align="center">
							    <xsl:choose>
						           <xsl:when test="(starts-with($GLOBAL_VAR_VD_LOCALE, 'fr')) or (starts-with($GLOBAL_VAR_VD_LOCALE, 'es')) or (starts-with($GLOBAL_VAR_VD_LOCALE, 'de'))">
							           <xsl:attribute name="width">width:400px</xsl:attribute>
							       </xsl:when>
						           <xsl:otherwise>
						               <xsl:attribute name="width">width:280px</xsl:attribute>
						           </xsl:otherwise>
					            </xsl:choose>	
								<xsl:attribute name="display"><xsl:value-of select="$strVDTasks"/></xsl:attribute>
								<xsl:attribute name="name">FCDTasks<xsl:value-of select="$fcdiskid"/></xsl:attribute>
								<Choice returnvalue="-" default="true">
									<xsl:attribute name="value"><xsl:value-of select="$strSelectTask"/></xsl:attribute>
								</Choice>
								<xsl:call-template name="for-loop-list-box">
									<xsl:with-param name="Mask" select="CurrentMethodMask"/>
									<xsl:with-param name="templateName" select="29"/>
								</xsl:call-template>
							</Data>
							<!-- add execute link -->
							<Data type="button" align="center">
								<xsl:attribute name="display"><xsl:value-of select="$strExecute"/></xsl:attribute>
								 <xsl:attribute name="id"><xsl:value-of select="$strExecute"/></xsl:attribute>
								 <xsl:attribute name="href">javascript:onExecute(\"<xsl:value-of select="$ObjID"/>\",\"<xsl:value-of select="$FCDName"/>\");</xsl:attribute>
								 <xsl:attribute name="tablebutton">true</xsl:attribute> 
						    </Data>
						</xsl:when>
						<xsl:otherwise>
							<!-- current methodmask is empty -->
							<Data value="tasks" type="select" align="center">
								<xsl:attribute name="display"><xsl:value-of select="$strVDTasks"/></xsl:attribute>
								<xsl:attribute name="name">FCDTasks<xsl:value-of select="$fcdiskid"/></xsl:attribute>
								 <xsl:choose>
						           <xsl:when test="(starts-with($GLOBAL_VAR_VD_LOCALE, 'fr')) or (starts-with($GLOBAL_VAR_VD_LOCALE, 'es')) or (starts-with($GLOBAL_VAR_VD_LOCALE, 'de'))">
							           <xsl:attribute name="width">width:400px</xsl:attribute>
							       </xsl:when>
						           <xsl:otherwise>
						               <xsl:attribute name="width">width:280px</xsl:attribute>
						           </xsl:otherwise>
					            </xsl:choose>
								<Choice returnvalue="" default="true">
									<xsl:attribute name="value"><xsl:value-of select="$strNoTask"/></xsl:attribute>
								</Choice>
							</Data>
						<Data type="ustring" columnspacing="true" name="execute" link="false" align="center">
							<xsl:attribute name="value"></xsl:attribute>
						</Data>
					   </xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				
				<xsl:if test="(//FluidCachedDisks/DCStorageObject/Progress)">
					<xsl:choose>
						<xsl:when test="Progress">
							<Data type="ustring" align="center">
								<xsl:attribute name="value"><xsl:value-of select="Progress"/><xsl:value-of select="$strPercComp"/></xsl:attribute>
							</Data>
						</xsl:when>
						<xsl:when test="/OMA/@cli = 'true'">
							<Data type="ustring" align="center">
								<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
							</Data>
						</xsl:when>
						<xsl:otherwise>
							<Data type="ustring" align="center">
								<xsl:attribute name="value"/>
							</Data>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
                          <Data name="ObjTypeValue" editable="false" type="ustring" align="center">
					<xsl:attribute name="name"><xsl:value-of select="$strEMMType"/><xsl:value-of select="position()"/></xsl:attribute>
					  <xsl:attribute name="value"><xsl:call-template name="PartitionOrVD"><xsl:with-param name="BackendObjType"><xsl:value-of select="BackendObjType"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
	
				  <Data editable="false" type="ustring" display="CacheLunBackendPath">
					  <xsl:attribute name="name"><xsl:value-of select="$strDeviceName"/><xsl:value-of select="position()"/></xsl:attribute>
					   <xsl:choose>
						<xsl:when test="ObjStatus='4'">
							<xsl:attribute name="value"><xsl:value-of select="$strDevicePathUnavailable"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="CacheLunBackendPath"/></xsl:attribute>
							</xsl:otherwise>
					</xsl:choose>
				  </Data>
				  <xsl:choose>
					<xsl:when test="/OMA/@cli='true'">
						<!--CLI version of the capacty data (displays bytes as well as GB)-->
						<Data name="Size" editable="false" type="ustring" display="Size" align="center">
							<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="PartitionSize"/></xsl:with-param></xsl:call-template> GiB (<xsl:value-of select="PartitionSize"/> bytes)</xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<!-- Web Version of the length data (ONLY displays GB) -->
						<Data editable="false" type="ustring" display="Test" align="center">
							<xsl:attribute name="name"><xsl:value-of select="$strSize"/><xsl:value-of select="position()"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="PartitionSize"/></xsl:with-param></xsl:call-template> GiB </xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
                        <!--xsl:if test="FluidCacheDiskDirtyBytes"> 
                      		<Data name="Test" editable="false" type="ustring" display="Test" align="center">
							<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="FluidCacheDiskDirtyBytes"/></xsl:with-param></xsl:call-template> GB</xsl:attribute>
					</Data>
				</xsl:if-->	

	                     <!--xsl:if test="//HighAvailabilityMode= 'False' or $dynamicView = 'false'"-->

				  	<Data editable="false" type="ustring" display="ConfiguredMode" align="center">
					  <xsl:attribute name="name"><xsl:value-of select="$strWriteMode"/><xsl:value-of select="position()"/></xsl:attribute>
					  <xsl:attribute name="value"><xsl:call-template name="GetFluidCacheWriteMode"><xsl:with-param name="WriteMode"><xsl:value-of select="CacheLunMode"/></xsl:with-param></xsl:call-template></xsl:attribute>
				  	</Data>
				  <!--/xsl:if-->
            			<Data name="OpWriteMode" editable="false" type="ustring" display="OpMode" align="center">
						<xsl:attribute name="name"><xsl:value-of select="$strOpWriteMode"/><xsl:value-of select="position()"/></xsl:attribute>
					  <xsl:attribute name="value"><xsl:call-template name="GetFluidCacheWriteMode"><xsl:with-param name="WriteMode"><xsl:choose><xsl:when test="CacheLunOpMode"><xsl:value-of select="CacheLunOpMode"/></xsl:when><xsl:otherwise><xsl:value-of select="CacheLunMode"/></xsl:otherwise></xsl:choose></xsl:with-param></xsl:call-template></xsl:attribute>

					</Data>
		            
		
            </Row>
		</xsl:if>
	
	</xsl:template>
	
</xsl:stylesheet>


