<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- the xsl included below contains messages for error codes-->
	<xsl:include href="smmsgs.xsl"/>
	<xsl:variable name="GLOBAL_PARAM_OrigURL"><xsl:value-of select="/OMA/OrigURL"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_ExitWizardHREFValue"><xsl:value-of select="translate($GLOBAL_PARAM_OrigURL,'!','&amp;')"/></xsl:variable>
	<xsl:variable name="WSManError" select="/OMA/WSManError"/>
	<xsl:variable name="StatusID">
		  <xsl:call-template name="GetStatusID">
			  <xsl:with-param name="StatusID" select="/OMA/ErrorCode"/>
		  </xsl:call-template>
	</xsl:variable>  

  <xsl:template match="/">
		<DataArea exportdata="false">
      <xsl:choose>
        <xsl:when test="$WSManError != 0 and $WSManError !='' and $WSManError != 'null'">
          <xsl:attribute name="email">false</xsl:attribute>
          <xsl:attribute name="printable">false</xsl:attribute>
					<AlertMessage alert="false">
						<xsl:attribute name="display"><xsl:value-of select="$strActionPerformed"/><xsl:call-template name="GetMessage"><xsl:with-param name="ErrorID" select="/OMA/ErrorCode"/><xsl:with-param name="WSManError" select="$WSManError"/></xsl:call-template></xsl:attribute>
					</AlertMessage>
        </xsl:when>
        <xsl:otherwise>
          <AlertMessage alert="true">
				    <xsl:choose>
					        <xsl:when test="contains(normalize-space($StatusID) , '3')">
					   	        <xsl:attribute name="display"><xsl:value-of select="$strTitle1"/></xsl:attribute>
						    </xsl:when>
							<xsl:otherwise>
							    <xsl:attribute name="display"><xsl:call-template name="GetMessage"><xsl:with-param name="ErrorID" select="/OMA/ErrorCode"/><xsl:with-param name="WSManError" select="$WSManError"/></xsl:call-template></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
				  <xsl:attribute name="status">
				      <xsl:choose>
					      <!-- sev(1)  means 'ok' and sev(2) means 'non-critical' and sev(3) means 'critical'-->
						  <xsl:when test="contains(normalize-space($StatusID) , '1')">2</xsl:when>
						  <xsl:when test="contains(normalize-space($StatusID) , '2')">3</xsl:when>
						  <xsl:when test="contains(normalize-space($StatusID) , '3')">4</xsl:when>
						  <xsl:otherwise>4</xsl:otherwise>
					  </xsl:choose>
     			  </xsl:attribute>
		  </AlertMessage>
		   <xsl:choose>
		      <xsl:when test="contains(normalize-space($StatusID) , '3')">
			  <SubHeader><xsl:attribute name="display"><xsl:value-of select="$strTitle2"/><xsl:call-template name="GetMessage"><xsl:with-param name="ErrorID" select="/OMA/ErrorCode"/><xsl:with-param name="WSManError" select="$WSManError"/></xsl:call-template></xsl:attribute></SubHeader>
			  </xsl:when>
			 </xsl:choose> 
			  <!-- Removed Refresh button as a part of fix for DFCT119759-->
			  <!--CustomButton>
				  <Data>
					  <xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					  <xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.HandleErrorWebPlugin&amp;ErrorCode=<xsl:value-of select="/OMA/ErrorCode"/></xsl:attribute>
				  </Data>
			  </CustomButton-->
        </xsl:otherwise>
      </xsl:choose>

      <BottomCustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strExitWizard"/></xsl:attribute>

					<xsl:choose>
						<xsl:when test="$GLOBAL_PARAM_OrigURL != 'null' or $GLOBAL_PARAM_OrigURL != ''">
					                <xsl:attribute name="href"><xsl:value-of select="$GLOBAL_VAR_ExitWizardHREFValue"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin&amp;help=adprin</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Data>
			</BottomCustomButton>
		</DataArea>
	</xsl:template>
</xsl:stylesheet>
