<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <!-- ENCLOSURE TABLE HEADER -->
    <xsl:template name="EnclosureTableHeader">
        <xsl:param name="tasks"/>
        <!-- The current implementation is to have the UI be dynamic in the data it shows.  Only the columns applicable
to the objects will be displayed.  The CLI will display all columns of data however to ease script parsing. -->
        <xsl:variable name="dynamicView">
            <xsl:choose>
                <xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
                <xsl:otherwise>true</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <!-- ignore on web is set to true since it's only needed for scripts using the cli -->
        <Data columnspacing="true" align="center" name="Id" editable="false" type="ustring" ignoreonweb="true">
            <xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
        </Data>
        <Data columnspacing="true" align="center" name="Status" editable="false" type="ustring">
            <xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
        </Data>
        <Data columnspacing="true" align="center" name="Name" editable="false" type="ustring">
            <xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
        </Data>
        <Data columnspacing="true" align="center" name="State" editable="false" type="ustring">
            <xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
        </Data>
        <Data columnspacing="true" align="center" name="Channel" editable="false" type="ustring">
		<xsl:choose>
		  <xsl:when test="//BusProtocol=9">
            <xsl:attribute name="display"><xsl:value-of select="$strPCIeSSDExpander"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$strPCIeSSDExpander"/></xsl:attribute>
		  </xsl:when>
		  <xsl:otherwise>
		    <xsl:attribute name="display"><xsl:value-of select="normalize-space($strChannel)"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="normalize-space($strChannel)"/></xsl:attribute>
		   </xsl:otherwise>
		  </xsl:choose>	
        </Data>
        <xsl:if test="//Enclosures/DCStorageObject/TargetID or $dynamicView = 'false' ">
            <!-- Only display this column if any of the enclosure objects return the XML or CLI is true -->
					<Data columnspacing="true" align="center" name="TargetID" editable="false" type="ustring">
						<xsl:attribute name="display"><xsl:value-of select="$strTargetID"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strTargetID"/></xsl:attribute>
					</Data>
			</xsl:if>
        <xsl:if test="//EnclosureConfig or $dynamicView = 'false' ">
            <!-- Only display this column if any of the enclosure objects return the XML or CLI is true -->
            <Data columnspacing="true" align="center" name="Config" editable="false" type="ustring">
                <xsl:attribute name="display"><xsl:value-of select="$strConfig"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strConfig"/></xsl:attribute>
            </Data>
        </xsl:if>
        <xsl:if test="//Enclosures/DCStorageObject/FirmwareVer or $dynamicView = 'false' ">
            <!-- Only display this column if any of the enclosure objects return the XML or CLI is true -->
            <Data columnspacing="true" align="center" name="FirmwareVer" editable="false" type="ustring">
                <xsl:attribute name="display"> <xsl:choose>
				   <xsl:when test="//Enclosures/DCStorageObject/DownStreamFWVersion">
				        <xsl:value-of select="$strUpStreamFw"/>
				   </xsl:when>
                   <xsl:otherwise>
				        <xsl:value-of select="$strFW"/>
                   </xsl:otherwise>							  
				  </xsl:choose>
			    </xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strFW"/></xsl:attribute>
            </Data>
        </xsl:if>
		<xsl:if test="//Enclosures/DCStorageObject/DownStreamFWVersion or $dynamicView = 'false' ">
            <!-- Only display this column if any of the enclosure objects return the XML or CLI is true -->
            <Data columnspacing="true" align="center" name="DownStreamFWVersion" editable="false" type="ustring">
                <xsl:attribute name="display"><xsl:value-of select="$strDownStreamFw"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strDownStreamFw"/></xsl:attribute>
            </Data>
        </xsl:if>
        <xsl:if test="//ServiceTag or $dynamicView = 'false' ">
            <!-- Only display this column if any of the enclosure objects return the XML or CLI is true -->
            <Data columnspacing="true" align="center" name="ServiceTag" editable="false" type="ustring">
                <xsl:attribute name="display"><xsl:value-of select="$strServiceTag"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strServiceTag"/></xsl:attribute>
            </Data>
        </xsl:if>

        <xsl:if test="//ServiceTag or $dynamicView = 'false' ">
            <!-- Only display this column if any of the enclosure objects return the XML or CLI is true -->
            <Data columnspacing="true" align="center" name="ExpressServiceCode" editable="false" type="ustring">
                <xsl:attribute name="display"><xsl:value-of select="$strExpressServiceCode"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strExpressServiceCode"/></xsl:attribute>
            </Data>
        </xsl:if>

        <xsl:if test="//AssetTag or $dynamicView = 'false' ">
            <!-- Only display this column if any of the enclosure objects return the XML or CLI is true -->
            <Data columnspacing="true" align="center" name="AssetTag" editable="false" type="ustring">
                <xsl:attribute name="display"><xsl:value-of select="$strAssetTag"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strAssetTag"/></xsl:attribute>
            </Data>
        </xsl:if>
        <xsl:if test="//AssetName or $dynamicView = 'false' ">
            <!-- Only display this column if any of the enclosure objects return the XML or CLI is true -->
            <Data columnspacing="true" align="center" name="AssetName" editable="false" type="ustring">
                <xsl:attribute name="display"><xsl:value-of select="$strAssetName"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strAssetName"/></xsl:attribute>
            </Data>
        </xsl:if>
        <xsl:if test="//BackPlanePartNum or $dynamicView = 'false' ">
            <!-- Only display this column if any of the enclosure objects return the XML or CLI is true -->
            <Data columnspacing="true" align="center" name="BackPlanePartNo" editable="false" type="ustring">
                <xsl:attribute name="display"><xsl:value-of select="$strBPPartNo"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strBPPartNo"/></xsl:attribute>
            </Data>
        </xsl:if>
        <xsl:if test="//SplitBusPartNum or $dynamicView = 'false' ">
            <!-- Only display this column if any of the enclosure objects return the XML or CLI is true -->
            <Data columnspacing="true" align="center" name="SplitBusPartNo" editable="false" type="ustring">
                <xsl:attribute name="display"><xsl:value-of select="$strSBPartNo"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strSBPartNo"/></xsl:attribute>
            </Data>
        </xsl:if>
        <xsl:if test="//EnclosurePartNum or $dynamicView = 'false' ">
            <!-- Only display this column if any of the enclosure objects return the XML or CLI is true -->
            <Data columnspacing="true" align="center" name="EnclosurePartNo" editable="false" type="ustring">
                <xsl:attribute name="display"><xsl:value-of select="$strEnclPartNo"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strEnclPartNo"/></xsl:attribute>
            </Data>
        </xsl:if>
        <xsl:if test="//Enclosures/DCStorageObject/SASAddress or $dynamicView = 'false' ">
            <!-- Only display this column if any of the enclosure objects return the XML or CLI is true -->
            <Data columnspacing="true" align="center" name="SASAddress" editable="false" type="ustring">
                <xsl:attribute name="display"><xsl:value-of select="$strSASAddress"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strSASAddress"/></xsl:attribute>
            </Data>
        </xsl:if>
        <xsl:if test="//EnclosureAlarm or $dynamicView = 'false' ">
            <!-- Only display this column if any of the enclosure objects return the XML or CLI is true -->
            <Data columnspacing="true" align="center" name="EnclAlarm" editable="false" type="ustring">
                <xsl:attribute name="display"><xsl:value-of select="$strEnclAlarm"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strEnclAlarm"/></xsl:attribute>
            </Data>
        </xsl:if>
    </xsl:template>
    <!-- ENCLOSURE TABLE ROWS -->
    <xsl:template name="EnclosureTableRows">
        <xsl:param name="tasks"/>
	<xsl:param name="ObjID">
		<xsl:call-template name="ModNexus">
			<xsl:with-param name="nexus">
				<xsl:value-of select="Nexus"/>
			</xsl:with-param>
		</xsl:call-template>
        </xsl:param>
        <!-- The current implementation is to have the UI be dynamic in the data it shows.  Only the columns applicable
to the objects will be displayed.  The CLI will display all columns of data however to ease script parsing. -->
        <xsl:variable name="dynamicView">
            <xsl:choose>
                <xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
                <xsl:otherwise>true</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <Row>
			<xsl:choose>
				<xsl:when test="BusProtocol=8 or BusProtocol=9">
					<!--ID for a SAS enclosure, ID is determined by the Channel:EnclosureID-->
					<Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test" ignoreonweb="true">
						<xsl:attribute name="value">
							<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>
						</xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<!--ID for a SCSI enclosure is determined by the Channel number to which it is attached-->
					<Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test" ignoreonweb="true">
						<xsl:attribute name="value">
							<xsl:value-of select="Channel"/>
						</xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>

            <Data columnspacing="true" align="center" type="status">
                <xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
            </Data>
            <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                <xsl:attribute name="value"><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="EnclosureType"/></xsl:with-param></xsl:call-template></xsl:attribute>
            </Data>
            <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                <xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
            </Data>
            <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                <xsl:attribute name="value"><xsl:value-of select="Channel"/></xsl:attribute>
            </Data>
            <xsl:if test="TargetID or $dynamicView = 'false' ">
						<xsl:choose>
							<xsl:when test="TargetID">
								<Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
									<xsl:attribute name="value"><xsl:value-of select="TargetID"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:otherwise>
								<Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
									<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
								</Data>
						</xsl:otherwise>
					</xsl:choose>
			</xsl:if>
			<!-- ENCLOSURE CONFIG COLUMN -->
            <xsl:if test="//EnclosureConfig or $dynamicView = 'false' ">
                <!-- Check to see if ANY of the enclosure objects have the config XML tag.  If so, then the header will be displayed, so populate the value here -->
                <xsl:choose>
                    <!-- The column will be displayed so check to see if THIS enclosure object has the config XML tag. -->
                    <xsl:when test="EnclosureConfig">
                        <!-- The tag exists, so display the value -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:call-template name="GetEnclosureConfig"><xsl:with-param name="config"><xsl:value-of select="EnclosureConfig"/></xsl:with-param></xsl:call-template></xsl:attribute>
                        </Data>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The tag was not found, so display Not Applicable -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
                        </Data>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
            <!-- FIRMWARE VERSION COLUMN -->
            <xsl:if test="FirmwareVer or $dynamicView = 'false' ">
                <!-- Check to see if ANY of the enclosure objects have the kernel version XML tag.  If so, then the header will be displayed, so populate the value here -->
                <xsl:choose>
                    <!-- The column will be displayed so check to see if THIS enclosure object has the kernel version XML tag. -->
                    <xsl:when test="FirmwareVer">
                        <!-- The tag exists, so display the value -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="FirmwareVer"/></xsl:attribute>
                        </Data>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The tag was not found, so display Not Applicable -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
                        </Data>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
			<xsl:if test="DownStreamFWVersion or $dynamicView = 'false' ">
                <!-- Check to see if ANY of the enclosure objects have the kernel version XML tag.  If so, then the header will be displayed, so populate the value here -->
                <xsl:choose>
                    <!-- The column will be displayed so check to see if THIS enclosure object has the kernel version XML tag. -->
                    <xsl:when test="DownStreamFWVersion">
                        <!-- The tag exists, so display the value -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="DownStreamFWVersion"/></xsl:attribute>
                        </Data>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The tag was not found, so display Not Applicable -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
                        </Data>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
            <!-- SERVICE TAG COLUMN -->
            <xsl:if test="//ServiceTag or $dynamicView = 'false' ">
                <!-- Check to see if ANY of the enclosure objects have the service tag XML tag.  If so, then the header will be displayed, so populate the value here -->
                <xsl:choose>
                    <!-- The column will be displayed so check to see if THIS enclosure object has the service tag XML tag. -->
                    <xsl:when test="normalize-space(ServiceTag)">
                        <!-- The tag exists, so display the value -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
                        </Data>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The tag was not found, so display Not Applicable -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
                        </Data>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>

            <!-- EXPRESS SERVICE CODE -->
            <xsl:if test="//ServiceTag or $dynamicView = 'false' ">
                <!-- Check to see if ANY of the enclosure objects have the service tag XML tag.  If so, then the header express service tag will be displayed, so populate the value here -->
                <xsl:choose>
                    <!-- The column will be displayed so check to see if THIS enclosure object has the service tag XML tag. -->
                    <xsl:when test="normalize-space(ServiceTag)">
                        <!-- The tag exists, so display the value -->
                        <Data columnspacing="true" align="center" name="ESC" editable="false" type="ustring" display="ESC">
                            <xsl:attribute name="value"><xsl:call-template name="GetExpressServiceCode"><xsl:with-param name="ServiceTag"><xsl:value-of select="normalize-space(ServiceTag)"/></xsl:with-param></xsl:call-template></xsl:attribute>
                        </Data>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The tag was not found, so display Not Applicable -->
                        <Data columnspacing="true" align="center" name="ESC" editable="false" type="ustring" display="ESC">
                            <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
                        </Data>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>

            <!-- ASSET TAG COLUMN -->
            <xsl:if test="//AssetTag or $dynamicView = 'false' ">
                <!-- Check to see if ANY of the enclosure objects have the asset tag XML tag.  If so, then the header will be displayed, so populate the value here -->
                <xsl:choose>
                    <!-- The column will be displayed so check to see if THIS enclosure object has the asset tag XML tag. -->
                    <xsl:when test="AssetTag">
                        <!-- The tag exists, so display the value -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
                        </Data>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The tag was not found, so display Not Applicable -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
                        </Data>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
            <!-- ASSET NAME COLUMN -->
            <xsl:if test="//AssetName or $dynamicView = 'false' ">
                <!-- Check to see if ANY of the enclosure objects have the asset name XML tag.  If so, then the header will be displayed, so populate the value here -->
                <xsl:choose>
                    <!-- The column will be displayed so check to see if THIS enclosure object has the asset name XML tag. -->
                    <xsl:when test="AssetName">
                        <!-- The tag exists, so display the value -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="AssetName"/></xsl:attribute>
                        </Data>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The tag was not found, so display Not Applicable -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
                        </Data>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
            <!-- BACKPLANE PART NUMBER COLUMN -->
            <xsl:if test="//BackPlanePartNum or $dynamicView = 'false' ">
                <!-- Check to see if ANY of the enclosure objects have the backplane part num XML tag.  If so, then the header will be displayed, so populate the value here -->
                <xsl:choose>
                    <!-- The column will be displayed so check to see if THIS enclosure object has the backplane part num XML tag. -->
                    <xsl:when test="BackPlanePartNum">
                        <!-- The tag exists, so display the value -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="BackPlanePartNum"/></xsl:attribute>
                        </Data>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The tag was not found, so display Not Applicable -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
                        </Data>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
            <!-- SPLIT BUS PART NUMBER COLUMN -->
            <xsl:if test="//SplitBusPartNum or $dynamicView = 'false' ">
                <!-- Check to see if ANY of the enclosure objects have the split bus part num XML tag.  If so, then the header will be displayed, so populate the value here -->
                <xsl:choose>
                    <!-- The column will be displayed so check to see if THIS enclosure object has the backplane part num XML tag. -->
                    <xsl:when test="SplitBusPartNum">
                        <!-- The tag exists, so display the value -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="SplitBusPartNum"/></xsl:attribute>
                        </Data>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The tag was not found, so display Not Applicable -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
                        </Data>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
            <!-- ENCLOSURE PART NUMBER COLUMN -->
            <xsl:if test="//EnclosurePartNum or $dynamicView = 'false' ">
                <!-- Check to see if ANY of the enclosure objects have the enclosure part num XML tag.  If so, then the header will be displayed, so populate the value here -->
                <xsl:choose>
                    <!-- The column will be displayed so check to see if THIS enclosure object has the enclosure part num XML tag. -->
                    <xsl:when test="EnclosurePartNum">
                        <!-- The tag exists, so display the value -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="EnclosurePartNum"/></xsl:attribute>
                        </Data>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The tag was not found, so display Not Applicable -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
                        </Data>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
            <!-- SAS Address -->
            <xsl:if test="SASAddress or $dynamicView = 'false' ">
                <!-- Check to see if ANY of the enclosure objects have the sas address XML tag.  If so, then the header will be displayed, so populate the value here -->
                <xsl:choose>
                    <!-- The column will be displayed so check to see if THIS enclosure object has the scsi rate XML tag. -->
                    <xsl:when test="SASAddress">
                        <!-- The tag exists, so display the value -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="SASAddress"/></xsl:attribute>
                        </Data>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The tag was not found, so display Not Applicable -->
                        <Data columnspacing="true" align="center" name="Test" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
                        </Data>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
            <!-- ENCLOSURE ALARM COLUMN -->
            <xsl:if test="//EnclosureAlarm or $dynamicView = 'false' ">
                <!-- Check to see if ANY of the enclosure objects have the alarm XML tag.  If so, then the header will be displayed, so populate the value here -->
                <xsl:choose>
                    <!-- The column will be displayed so check to see if THIS enclosure object has the alarm XML tag. -->
                    <xsl:when test="EnclosureAlarm">
                        <!-- The tag exists, so display the value -->
                        <Data columnspacing="true" align="center" name="EnclAlarm" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:call-template name="GetEnclosureAlarm"><xsl:with-param name="state"><xsl:value-of select="EnclosureAlarm"/></xsl:with-param></xsl:call-template></xsl:attribute>
                        </Data>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The tag was not found, so display Not Applicable -->
                        <Data columnspacing="true" align="center" name="EnclAlarm" editable="false" type="ustring" display="Test">
                            <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
                        </Data>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>           
        </Row>
    </xsl:template>
</xsl:stylesheet>
