<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:import href="Utils.xsl"/>
<xsl:output method="xml"/>
<xsl:strip-space elements="*"/>
<xsl:template match="/OMA">

<DataArea exportdata="false" onLoad="true">
       <!--xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
       <xsl:attribute name="backpagetarget"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/OrigURL"/></xsl:call-template></xsl:attribute-->
	   
	    <xsl:call-template name="scripts"/>
		<script language="javascript">
		   function initializationRoutine()
	       { 
		      document.getElementById("CertificateSettings").checked=false;
			  document.getElementById("ServerSettings").checked=true;
		   }
		   function OnOperationDKMServerSettings()
		   {  
		      if(document.getElementById("ServerSettings").checked == true)
			  { 
			    document.getElementById("CertificateSettings").checked=false;
		      }
		   }
		   function OnOperationClientCertSettings()
		   {  
		      if(document.getElementById("CertificateSettings").checked == true)
			  {
			    document.getElementById("ServerSettings").checked=false;
			  }
		   }
		   
		   function submitDKMSettings()
		   {
		    	 
		     if(document.getElementById("ServerSettings").checked == true)
			 {
			   document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.DKMSServerSettingsWebPlugin&amp;EncryptionViewFlag=0&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin!help=stprhl");
			 }
                 if(document.getElementById("CertificateSettings").checked == true)
			 {
			   document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CertificateClientSettingsWebPlugin&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin!help=stprhl");

			 }
  
		   }
		   
		</script>
	   <PageTitle>
               <xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/></xsl:attribute>
       </PageTitle>
	   <BottomCustomButton>
			<Data formSubmit="true" display="{$strContinue}" href="javascript:submitDKMSettings() " id="submitbuttoncontent"/>
		</BottomCustomButton>
		<BottomCustomButton>
		   <Data formSubmit="true">
				<xsl:attribute name="display"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
				<xsl:attribute name="href"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/OrigURL"/></xsl:call-template></xsl:attribute>
		   </Data>
		</BottomCustomButton>
	   <xsl:call-template name="SecurityKeyOptionRows"/>
</DataArea>
        
</xsl:template>
 <xsl:template name="SecurityKeyOptionRows">
    <TableData name="T4" ignoreJumpbar="true">
	   <Header>
	      <Data name="Options" editable="false" type="ustring" align="left">
				   <xsl:attribute name="value"><xsl:value-of select="$strOptions"/></xsl:attribute>
		  </Data>
	   </Header>
		<Row>  
           <Data name="ServerSettings" type="radio" event="onclick" handler="OnOperationDKMServerSettings()" state="0">
             	<xsl:attribute name="value"><xsl:value-of select="$strDKMServerSettings"/></xsl:attribute>
				<xsl:attribute name="returnvalue"/>
  	       </Data>
	    </Row>
		<Row>  
           <Data name="CertificateSettings" type="radio" event="onclick" handler="OnOperationClientCertSettings()" state="0">
             	<xsl:attribute name="value"><xsl:value-of select="$strDKMCertificateSettings"/></xsl:attribute>
				<xsl:attribute name="returnvalue"/>
  	       </Data>
	    </Row>
	</TableData>
 </xsl:template>
</xsl:stylesheet>
			   
