<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="dsautils.xsl"/>

	<!-- The dsaclrfg.xsl is used to display a table of array disks that have foreign configurations -->
	<!-- with their associated properties. Sections of code from adtbl.xsl, cvdadisk.xsl and cvdutils.xsl -->
	<!-- has been leveraged to satisfy the requirements --> 

	<!-- Declare Global variables and parameters-->
	<xsl:variable name="DSACLRFG_PARAM_Rules">
		<xsl:choose>
			<xsl:when test="/OMA/Rules"><xsl:value-of select="/OMA/Rules"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="DSACLRFG_PARAM_ControllerName"><xsl:value-of select="/OMA/ControllerName"/></xsl:variable>
	<xsl:variable name="DSACLRFG_PARAM_OutputFileName"><xsl:value-of select="/OMA/OutputFileName"/></xsl:variable>
	<xsl:variable name="DSACLRFG_PARAM_DisplayVDConfig"><xsl:value-of select="/OMA/DisplayVDConfig"/></xsl:variable>
	<xsl:variable name="DSACLRFG_PARAM_OrigURL"><xsl:value-of select="/OMA/OrigURL"/></xsl:variable>
	<xsl:variable name="DSACLRFG_PARAM_ControllerOID"><xsl:value-of select="/OMA/ControllerOID"/></xsl:variable>
	<xsl:variable name="DSACLRFG_PARAM_Length"><xsl:value-of select="/OMA/Length"/></xsl:variable>
	<xsl:variable name="DSACLRFG_PARAM_IsAnyAdiskForeign"><xsl:value-of select="/OMA/ForeignAdiskFound"/></xsl:variable>
	<xsl:variable name="DSACLRFG_PARAM_Minosdrivesize"><xsl:value-of select="/OMA/Minosdrivesize"/></xsl:variable>
	<xsl:variable name="DSACLRFG_PARAM_Maxosdrivesize"><xsl:value-of select="/OMA/Maxosdrivesize"/></xsl:variable>
	<xsl:variable name="DSACLRFG_PARAM_ArrayDiskCount"><xsl:value-of select="count(//ArrayDisks/DCStorageObject)"/></xsl:variable>
	<!-- Initialize the foreign drives count to 0. The count is used to enable or disable "keep foreign configuration" radio button -->
	<xsl:variable name="DSACLRFG_PARAM_ForeignDiskCount"><xsl:value-of select="/OMA/ForeignDrivesCount"/></xsl:variable>
	<!-- Ashesh - DF56399: Cache user selection when traversing back n' forth between ClrFg and RAID page. -->
	<xsl:variable name="DSACLRFG_PARAM_CLRFRGNCONFIG"><xsl:value-of select="/OMA/ClearForeignConfigEnable"/></xsl:variable>
		
	<!-- ClearForeignConfigEnable = 0 - Foreign configuration will not be cleared -->
	<xsl:variable name="DSACLEARFOREIGNCONFIGDISABLE">0</xsl:variable>
	<!-- ClearForeignConfigEnable = 1 - Foreign configuration will be cleared -->
	<xsl:variable name="DSACLEARFOREIGNCONFIGENABLE">1</xsl:variable>
	<!-- Get Minimumdrives required for RAID 0 on this controller -->
	<xsl:variable name="DSAMINDRIVES_REQUIRED_FOR_RAID"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MinDrivesForRAID0"/></xsl:variable>
	<!-- Calculate, total drives minus foreign drives to get usable drives without clearign foreign config -->
	<xsl:variable name="DSAUSABLE_DRIVE_COUNT" select="$DSACLRFG_PARAM_ArrayDiskCount - $DSACLRFG_PARAM_ForeignDiskCount"/>
	<!-- Get DSA RaidModeAndDiskCheck flag -->
	<xsl:variable name="DSACLRFG_PARAM_DSARAIDMODEANDDISKCHECK">
		<xsl:choose>
			<xsl:when test="/OMA/DSARaidModeAndDiskCheck">
				<xsl:value-of select="/OMA/DSARaidModeAndDiskCheck"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<!-- Get DSA IsFromAdvanced flag -->
	<xsl:variable name="DSACLRFG_PARAM_ISFROMADVANCED">
		<xsl:choose>
			<xsl:when test="/OMA/IsFromAdvanced">
				<xsl:value-of select="/OMA/IsFromAdvanced"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<!-- Set the state value of keep foreign config radio button based on whether all drives are in foreign or only few -->
	<!-- Radio button state set to 1 => Highlights the radio button -->
	<!-- Radio button state set to 2 => greys out the radio button -->
	<xsl:variable name="KEEP_FOREIGN_CONFIG_RADIO_STATE">
			<xsl:choose>
				<xsl:when test="$DSACLRFG_PARAM_ForeignDiskCount &lt; $DSACLRFG_PARAM_ArrayDiskCount and $DSAUSABLE_DRIVE_COUNT &gt;= $DSAMINDRIVES_REQUIRED_FOR_RAID">1</xsl:when>
				<xsl:otherwise>2</xsl:otherwise>
			</xsl:choose>
	</xsl:variable>	
	
	<xsl:variable name="DSACLRFG_REGULAR_PARAMS">ControllerOID=<xsl:value-of select="$DSACLRFG_PARAM_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$DSACLRFG_PARAM_ControllerName"/>&amp;OrigURL=<xsl:value-of select="$DSACLRFG_PARAM_OrigURL"/>&amp;Rules=<xsl:value-of select="$DSACLRFG_PARAM_Rules"/>&amp;DisplayVDConfig=<xsl:value-of select="$DSACLRFG_PARAM_DisplayVDConfig"/>&amp;OutputFileName=<xsl:value-of select="$DSACLRFG_PARAM_OutputFileName"/>&amp;Minosdrivesize=<xsl:value-of select="$DSACLRFG_PARAM_Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="$DSACLRFG_PARAM_Maxosdrivesize"/>&amp;ForeignAdiskFound=<xsl:value-of select="$DSACLRFG_PARAM_IsAnyAdiskForeign"/></xsl:variable>
	<xsl:variable name="DSACLRFG_ADVANCED_PARAMS">DSARaidModeAndDiskCheck=<xsl:value-of select="$DSACLRFG_PARAM_DSARAIDMODEANDDISKCHECK"/></xsl:variable>

	<xsl:variable name="DSACLRFG_CFG_PARAMS">ClearForeignConfigEnable=<xsl:value-of select="$DSACLEARFOREIGNCONFIGENABLE"/></xsl:variable>

	<xsl:variable name="DSACLRFG_NONCFG_PARAMS">ClearForeignConfigEnable=<xsl:value-of select="$DSACLEARFOREIGNCONFIGDISABLE"/></xsl:variable>
	
	<xsl:variable name="GLOBAL_PARAM_Screen_Name">dsaclrfg_<xsl:value-of select="$DSACLRFG_PARAM_ControllerOID"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Prev_Page_URL">./SubmitForm?plugin=com.dell.cdu.webplugins.PreviousScreenWebPlugin&amp;IsFromAdvanced=<xsl:value-of select="$DSACLRFG_PARAM_ISFROMADVANCED"/></xsl:variable>

	<!-- Main entry point into this XSL -->
	<xsl:template match="OMA">
		<xsl:choose>
			<xsl:when test="$DSACLRFG_PARAM_ArrayDiskCount>0 and $DSACLRFG_PARAM_Rules = '1' and $DSACLRFG_PARAM_ForeignDiskCount>0">
				<xsl:call-template name="DSACLRFG_RenderMainFrame"/>
			</xsl:when>
			<xsl:when test="$DSACLRFG_PARAM_ForeignDiskCount &lt;= 0">
				<xsl:call-template name="DSACLRFG_ErrorHandler">
					<xsl:with-param name="ErrorPageTitle">
						<xsl:value-of select="$strPageTitleNoForeignDisksDetected"/>
					</xsl:with-param>
					<xsl:with-param name="ErrorTextMessage1">
						<xsl:value-of select="$strNoForeignDisksDSACF"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$DSACLRFG_PARAM_ArrayDiskCount &lt;= 0">
				<xsl:call-template name="DSACLRFG_ErrorHandler">
					<xsl:with-param name="ErrorPageTitle">
						<xsl:value-of select="$strPageTitleNoPhysicalDisksDetected"/>
					</xsl:with-param>
					<xsl:with-param name="ErrorTextMessage1">
						<xsl:value-of select="$strNoPhysicalDisksDSACF"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="DSACLRFG_RenderMainFrame">
		<DataArea onLoad="true" validate="true" exportdata="false" email="false" printable="false" ignoreJumpBar="true">
		<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
		<!-- Ashesh: These attributes are for DSA mode only -->
		<xsl:attribute name="storeonback">true</xsl:attribute>		<!-- Ashesh: This variables lets the DSA-OMSA framework know that page needs to be cached  -->
		<xsl:attribute name="screenname"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:attribute>	<!-- Ashesh: This is the key for the hashmap which stores the form elements of the page. -->
		<!-- Ashesh: This is the label for the back button  -->
		<xsl:attribute name="custombackpagedisplay"><xsl:value-of select="$strBackButtonDisplayDSACF"/></xsl:attribute>
		<!-- Ashesh: This is the href for the back button. This will cache the form elements of this page and take the user to the URL specified  -->
		<xsl:attribute name="backpagetarget">javascript:goToPreviousPageInDSA();</xsl:attribute>
		
		<script language="javascript">
		<!-- Initialization routine is the first routine to be called. Default enable Keep foreign config message -->
			function initializationRoutine()
			{
				var InitForeignDriveCount = <xsl:value-of select="$DSACLRFG_PARAM_ForeignDiskCount"/>;
				var InitArrayDiskCount = <xsl:value-of select="$DSACLRFG_PARAM_ArrayDiskCount"/>;
				var InitForeignConfigMesg = "<xsl:value-of select="$strKeepForeignConfigEnabledMesg"/>";
				var InitUsableDiskCount = <xsl:value-of select="$DSAUSABLE_DRIVE_COUNT"/>;
				var InitMinDiskForRaid = <xsl:value-of select="$DSAMINDRIVES_REQUIRED_FOR_RAID"/>;
				//Ashesh - DF56399: Cache user selection when traversing back n' forth between ClrFg and RAID page.
				var ClrFrgnConfigflag = "<xsl:value-of select="$DSACLRFG_PARAM_CLRFRGNCONFIG"/>";
				var ForeignClearMesg = "<xsl:value-of select="$strClearForeignConfigDescMesg"/>";
				
				if( InitForeignDriveCount >= InitArrayDiskCount )
				{
					InitForeignConfigMesg = "<xsl:value-of select="$strKeepForeignConfigDisabledMesg"/>";	
					document.getElementById("ForeignConfigDescTextArea").value = InitForeignConfigMesg;
				}
				else if ( InitMinDiskForRaid > InitUsableDiskCount )
				{
					
					InitForeignConfigMesg = "<xsl:value-of select="$strKeepForeignConfigDisabledMesg2"/>";	
					document.getElementById("ForeignConfigDescTextArea").value = InitForeignConfigMesg;
				}
				else
				{
					document.getElementById("ForeignConfigDescTextArea").value = InitForeignConfigMesg;
				}
				//Ashesh - DF56399: Cache user selection when traversing back n' forth between ClrFg and RAID page.
				if (ClrFrgnConfigflag != "null")
				{
					if (ClrFrgnConfigflag == "1")
					{
						var RadioArray = document.getElementsByName(getElementNameForInputOption());
						RadioArray[0].checked = true;
						document.getElementById("ForeignConfigDescTextArea").value = ForeignClearMesg;
					}	
				}
			}

		<!-- Returns Data name of the Radio button -->
			function getElementNameForInputOption()
			{
				return "ForeignConfig";
			}

		<!-- Invokes appropriate plugin based on the Radio button checked by the user -->
			function submitForeignConfigSelection()
			{
				var RadioArray=document.getElementsByName(getElementNameForInputOption());
				var DSARaidModeAndDiskCheck="<xsl:value-of select="$DSACLRFG_PARAM_DSARAIDMODEANDDISKCHECK"/>";
				var IsFromAdvanced="<xsl:value-of select="$DSACLRFG_PARAM_ISFROMADVANCED"/>";

				cachePageInDSA();
				
				if ( RadioArray[0].checked == true ){
					if(DSARaidModeAndDiskCheck == "0" &amp;&amp; IsFromAdvanced == "0")
					{
						SubmitExpressRaidPluginWithClearForeignConfig();
					}
					else
					{
						SubmitAdvancedRaidPluginWithClearForeignConfig();
					}
				}
				else if( RadioArray[1].checked == true )
				{
					if(DSARaidModeAndDiskCheck == "0" &amp;&amp; IsFromAdvanced == "0")
      {
      SubmitExpressRaidPluginWithKeepForeignConfig();
      }
      else
      {
      SubmitAdvancedRaidPluginWithKeepForeignConfig();
      }
      }
      }

      function SubmitExpressRaidPluginWithClearForeignConfig()
      {
        document.location.href = top.getFrame("OMA_gnv").appendDataAreaVID("./DataArea?plugin=com.dell.sm.webplugins.CreateVDExpressWebPlugin&amp;<xsl:value-of select="$DSACLRFG_REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSACLRFG_CFG_PARAMS"/>");
      }

      function SubmitExpressRaidPluginWithKeepForeignConfig()
      {
        document.location.href = top.getFrame("OMA_gnv").appendDataAreaVID("./DataArea?plugin=com.dell.sm.webplugins.CreateVDExpressWebPlugin&amp;<xsl:value-of select="$DSACLRFG_REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSACLRFG_NONCFG_PARAMS"/>");
      }

      function SubmitAdvancedRaidPluginWithClearForeignConfig()
      {
        document.location.href = top.getFrame("OMA_gnv").appendDataAreaVID("./DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedRaidLayoutSelectionWebPlugin&amp;<xsl:value-of select="$DSACLRFG_REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSACLRFG_CFG_PARAMS"/>&amp;<xsl:value-of select="$DSACLRFG_ADVANCED_PARAMS"/>");
      }

      function SubmitAdvancedRaidPluginWithKeepForeignConfig()
      {
        document.location.href = top.getFrame("OMA_gnv").appendDataAreaVID("./DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedRaidLayoutSelectionWebPlugin&amp;<xsl:value-of select="$DSACLRFG_REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSACLRFG_NONCFG_PARAMS"/>&amp;<xsl:value-of select="$DSACLRFG_ADVANCED_PARAMS"/>");
			}
				

		<!-- To dynamically display Radio button operation in the text box -->
			function getInputForeignConfigValue()
			{
				var RadioArray = document.getElementsByName(getElementNameForInputOption());
				if(RadioArray[0].checked == true)
				{
					var ClearForeignConfigMesg = "<xsl:value-of select="$strClearForeignConfigDescMesg"/>";
					document.getElementById("ForeignConfigDescTextArea").value = ClearForeignConfigMesg;
					
				}	
				else if(RadioArray[1].checked == true)
				{
					var KeepForeignConfigMesg = "<xsl:value-of select="$strKeepForeignConfigEnabledMesg"/>";
					document.getElementById("ForeignConfigDescTextArea").value = KeepForeignConfigMesg;
				}
			}
			
			<xsl:if test="$DSACLRFG_PARAM_Rules='1'">
				<!-- Include the DSA caching scripts if OMSS Lite mode. Specify relevant parameters to the template. -->
				<xsl:call-template name="getDSAScripts">
					<xsl:with-param name="PARAM_Screen_Name"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:with-param>
					<xsl:with-param name="PARAM_Prev_Page_URL"><xsl:value-of select="$GLOBAL_PARAM_Prev_Page_URL"/></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</script>

		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strTitleMainStartDSACF"/><xsl:value-of select="$DSACLRFG_PARAM_ControllerName"/><xsl:value-of select="$strTitleMainEndDSACF"/></xsl:attribute>
		</PageTitle>
			<xsl:call-template name="DSACLRFG_ArrayDiskTableHeader"/>
			<xsl:call-template name="DSACLRFG_RenderBottomCustomButtons"/>
		</DataArea>
	</xsl:template>

	<xsl:template name="DSACLRFG_RenderBottomCustomButtons">
		<!-- Render the "Back" button followed by the "Continue" button in that order-->
		<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
		<!-- Ashesh: Back button was removed, since it is being called in DataArea -->
		<BottomCustomButton>
			<Data display="{$strContinueDSACF}" formSubmit="true" href="javascript:submitForeignConfigSelection()"/>
		</BottomCustomButton>
	</xsl:template>
	
	<xsl:template name="DSACLRFG_ErrorHandler">
		<xsl:param name="ErrorPageTitle"/>
		<xsl:param name="ErrorTextMessage1"/>
		<DataArea exportdata="false" printable="false" email="false" ignoreJumpBar="false">
			<script language="javascript">
        function backToDSAPageNoPhysicalDisks()
        {
        document.getElementById("dataarea").action = top.getFrame("OMA_gnv").appendDataAreaVID("./SubmitForm?plugin=com.dell.cdu.webplugins.PreviousScreenWebPlugin");
        document.getElementById("dataarea").submit();
        return true;
        }
      </script>
			<BottomCustomButton>
				<Data display="{$strBackButtonDisplayDSACF}" formSubmit="true" href="javascript:backToDSAPageNoPhysicalDisks()"/>
			</BottomCustomButton>
			<BottomCustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRebootDSACF"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.cdu.webplugins.CDUParentWebPlugin&amp;component=sysreboot</xsl:attribute>
				</Data>
			</BottomCustomButton>
			<PageTitle status="4"><xsl:attribute name="display"><xsl:value-of select="$ErrorPageTitle"/><xsl:text>&#160;</xsl:text><xsl:value-of select="$DSACLRFG_PARAM_ControllerName"/></xsl:attribute></PageTitle>
			<PromptText><xsl:value-of select="$ErrorTextMessage1"/></PromptText>
		</DataArea>
	</xsl:template>

	<xsl:template name="DSACLRFG_ArrayDiskTableHeader">
		<xsl:call-template name="scripts"/>
		<TableData>
			<!-- Main header -->
			<Header>
				<Data value="{$strExistingForeignConfigDSACF}" colspan="6" align="center"/>
			</Header>
			<!-- Sub header -->
			<Header>
				<Data name="Id" columnspacing="true" editable="false" type="ustring" align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
				</Data>
				<Data name="State" columnspacing="true" editable="false" type="ustring" align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
				</Data>
					<xsl:if test="//BusProtocol">
						<!-- See ifany disk has BusProtocol populated.  If so, show the header for the table -->
						<Data name="BusProtocol" editable="false" type="ustring" align="center">
							<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strType"/></xsl:attribute>
						</Data>
					</xsl:if>
					<xsl:if test="//Length">
						<!-- Only display this column if any of the objects return the XML -->
						<Data name="Capacity" columnspacing="true" editable="false" type="ustring" align="center">
							<xsl:attribute name="display"><xsl:value-of select="$strCapacity"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strCapacity"/></xsl:attribute>
						</Data>
					</xsl:if>
			</Header>
			<xsl:for-each select="ArrayDisks/DCStorageObject">
				<xsl:call-template name="DSACLRFG_ArrayDiskTableRows"/>
			</xsl:for-each>
		</TableData>
			<xsl:call-template name="DSACLRFG_RenderForeignConfigSelection"/>
	</xsl:template>	

	<xsl:template name="DSACLRFG_ArrayDiskTableRows">  
		<xsl:call-template name="scripts"/>
		<!-- The current implementation is to have the UI be dynamic in the data it shows. -->
		<xsl:variable name="AdiskState">
			<xsl:call-template name="GetState">
				<xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:variable name="AdiskStateNumber">
			<!-- Get the current disk state -->
			<xsl:value-of select="ObjState"/>
		</xsl:variable>


		<xsl:choose>
		<!--Devendra (5/25/06): DF68816. Localization issue where we need to get the state of the drives in terms of number rather than a string.-->
		<!--The number 274877906944 represents the Foreign State-->

			<xsl:when test="$AdiskStateNumber='274877906944'">
				<xsl:variable name="IsSASorSATA">
					<xsl:call-template name="IsSASorSATA">
						<xsl:with-param name="BusProtocol">
						<xsl:value-of select="BusProtocol"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="IsDiskInEnclosure">
					<xsl:call-template name="IsDiskInEnclosure">
						<xsl:with-param name="AttributesMask">
						<xsl:value-of select="AttributesMask"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:variable name="ADID">
				<xsl:choose>
					<xsl:when test="$IsSASorSATA='1' and $IsDiskInEnclosure='1'">
						<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

		<Row>
		<Data type="ustring" columnspacing="true" align="center">
			<xsl:attribute name="value"><xsl:value-of select="$ADID"/></xsl:attribute>
		</Data>

		<Data name="State" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
			<xsl:attribute name="value"><xsl:value-of select="$AdiskState"/></xsl:attribute>
		</Data>

		<xsl:if test="//BusProtocol">
			<xsl:choose>
				<xsl:when test="BusProtocol">
					<Data type="ustring" align="center">
						<xsl:attribute name="value"><xsl:call-template name="GetBusProtocol"><xsl:with-param name="Bus"><xsl:value-of select="BusProtocol"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data type="ustring" align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	
		<!-- ************************************* -->
		<!-- CAPACITY (LENGTH) COLUMN -->
		<xsl:if test="//Length">
		<!-- Check to see if ANY of the objects have the XML tag.  If so, then the header will be displayed, so populate the value here -->
			<xsl:choose>
				<!-- The column will be displayed so check to see if THIS object has the XML tag. -->
				<xsl:when test="Length">
						<!-- Web Versions of the length data (ONLY displays GB) -->
						<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
							<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="Length"/></xsl:with-param></xsl:call-template><xsl:value-of select="$strGB"/></xsl:attribute>
						</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strUnavaliable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		</Row>
	</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template name="DSACLRFG_RenderForeignConfigSelection">
<TableData>
		<Header>
			<Data value="{$strAskClearForeignConfigDSACF}" colspan="3" align="center"/> <!-- AS: DF73823: Centering the header. Added colspan   -->
		</Header>
	<Row>
		<Data width="37%"/> <!-- AS: DF73823: Dummy coloumn so that radio buttons appear centered -->
		<Data name="ForeignConfig" type="radio" handler="getInputForeignConfigValue()" event="onclick" state="0" width="*">
			<xsl:attribute name="value">
				<xsl:value-of select="$strClearForeignConfigDSACF"/>
			</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="$DSACLEARFOREIGNCONFIGENABLE"/></xsl:attribute>
		</Data>
		<Data width="37%"/> <!-- AS: DF73823: Dummy coloumn so that radio buttons appear centered -->
	</Row>
	<Row>
		<Data width="37%"/> <!-- AS: DF73823: Dummy coloumn so that radio buttons appear centered -->
		<Data name="ForeignConfig" type="radio" handler="getInputForeignConfigValue()" event="onclick" state="{$KEEP_FOREIGN_CONFIG_RADIO_STATE}" width="*">
			<xsl:attribute name="value">
				<xsl:value-of select="$strKeepForeignConfigDSACF"/>
			</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="$DSACLEARFOREIGNCONFIGDISABLE"/></xsl:attribute>
		</Data>
		<Data width="37%"/> <!-- AS: DF73823: Dummy coloumn so that radio buttons appear centered -->
	</Row>
	<Row>
		<Data type="custom" colspan="3" align="center">
			<textarea rows="2" cols="95" name="ForeignConfigDescTextArea" id="ForeignConfigDescTextArea" readonly="true"/>
		</Data>
	</Row>
</TableData>
</xsl:template>
</xsl:stylesheet>
