<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- the xsl included below contains messages for error codes-->
	<xsl:import href="smmsgs.xsl"/>
	<xsl:variable name="StatusID">
		<xsl:call-template name="GetStatusID">
			<xsl:with-param name="StatusID" select="ErrorCode"/>
		</xsl:call-template>
	</xsl:variable>  
	<xsl:template match="OMA">
		<DataArea exportdata="false">
      <xsl:if test="WSManError != 0 and WSManError !='' and WSManError != 'null'">
        <xsl:attribute name="email">false</xsl:attribute>
        <xsl:attribute name="printable">false</xsl:attribute>
      </xsl:if>   

        <script language="javascript">
			function ReturnPage() {
				// The HREF URL passed in has !! in place of the &amp;.  this was need to be able to pass it to the web plugin.
				// Reverse this and replace the !! with &amp; here.
				var url = "<xsl:value-of select="HREF"/>";
				var split_url = url.split("!");
				var end_count = split_url.length;
				var href = "";
				for(count=0; count &lt; end_count-1; count++) {
					href += split_url[count] + "&amp;";
				}
				href += split_url[end_count-1];
				document.location.href = href;
			}
			</script>
      
			<xsl:choose>
				<xsl:when test="WSManError != 0 and WSManError !='' and WSManError != 'null'">
					<PageTitle alert="false">
						<xsl:attribute name="display"><xsl:value-of select="$strActionPerformed"/><xsl:call-template name="GetMessage"><xsl:with-param name="ErrorID" select="ErrorCode"/><xsl:with-param name="WSManError" select="WSManError"/></xsl:call-template></xsl:attribute>
					</PageTitle>
				</xsl:when>
				<xsl:otherwise>
      		<AlertMessage alert="true">
			       <xsl:choose>
					        <xsl:when test="contains(normalize-space($StatusID) , '3')">
					   	        <xsl:attribute name="display"><xsl:value-of select="$strTitle1"/></xsl:attribute>
						    </xsl:when>
							<xsl:otherwise>
							     <xsl:attribute name="display"><xsl:call-template name="GetMessage"><xsl:with-param name="ErrorID" select="ErrorCode"/><xsl:with-param name="WSManError" select="WSManError"/></xsl:call-template></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
				  <xsl:attribute name="status">
				      <xsl:choose>
					      <!-- sev(1)  means 'ok' and sev(2) means 'non-critical' and sev(3) means 'critical'-->
						  <xsl:when test="contains(normalize-space($StatusID) , '1')">2</xsl:when>
						  <xsl:when test="contains(normalize-space($StatusID) , '2')">3</xsl:when>
						  <xsl:when test="contains(normalize-space($StatusID) , '3')">4</xsl:when>
						  <xsl:otherwise>4</xsl:otherwise>
					  </xsl:choose>
				  </xsl:attribute>
		    </AlertMessage>
			 <xsl:choose>
			  <xsl:when test="contains(normalize-space($StatusID) , '3')">
			    <SubHeader>
				    <xsl:attribute name="display"><xsl:value-of select="$strTitle2"/><xsl:call-template name="GetMessage"><xsl:with-param name="ErrorID" select="ErrorCode"/><xsl:with-param name="WSManError" select="WSManError"/></xsl:call-template></xsl:attribute>
			    </SubHeader>
			    <!-- Devendra: Commented out for new Adaptec messages. -->
			    <!--<xsl:if test="ErrorCode != 2226">-->
			    <xsl:if test="ErrorCode &lt; 2226 or ErrorCode &gt;2231">
				    <SubHeader>
					    <xsl:attribute name="display"><xsl:value-of select="$strWhy"/></xsl:attribute>
				    </SubHeader>
				    <ListData>
					    <Data>
						    <xsl:attribute name="display">-</xsl:attribute>
						    <xsl:attribute name="value"><xsl:value-of select="$strWhy1"/></xsl:attribute>
					    </Data>
					    <Data>
						    <xsl:attribute name="display">-</xsl:attribute>
						    <xsl:attribute name="value"><xsl:value-of select="$strWhy2"/></xsl:attribute>
					    </Data>
					    <Data>
						    <xsl:attribute name="display">-</xsl:attribute>
						    <xsl:attribute name="value"><xsl:value-of select="$strWhy3"/></xsl:attribute>
					    </Data>
				    </ListData>
			    </xsl:if>
			  </xsl:when>
            </xsl:choose>			  
        </xsl:otherwise>
      </xsl:choose>

      <!--BottomCustomButton>
				<Data>
					<xsl:attribute name="href">javascript:ReturnPage()</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
				</Data>
			</BottomCustomButton-->
      
			<BottomCustomButton>
				<Data>
					<xsl:choose>
						<xsl:when test="HREF != 'null'">
							<xsl:attribute name="href">javascript:ReturnPage()</xsl:attribute>
						</xsl:when>
						<xsl:when test="BackTo != 'null'">
					        <xsl:attribute name="href"><xsl:call-template name="ReturnPage"><xsl:with-param name="BackTo" select="/OMA/BackTo"/></xsl:call-template></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin&amp;help=adprin</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="display"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
				</Data>
			</BottomCustomButton>
		</DataArea>
	</xsl:template>
  
  <xsl:template name="ReturnPage">
          <xsl:param name="defaultBackPage">./DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin&amp;help=stprhl</xsl:param>
          <xsl:param name="BackTo">
          </xsl:param>
          <xsl:choose>
            <xsl:when test="BackTo and BackTo='/'"><xsl:value-of select="$defaultBackPage"/></xsl:when>
            <xsl:when test="BackTo and BackTo!=''"><xsl:value-of select="translate($BackTo,'!','&amp;')"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$defaultBackPage"/></xsl:otherwise>
          </xsl:choose>
  </xsl:template>
 
</xsl:stylesheet>
