<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:import href="Utils.xsl"/>
<xsl:output method="xml"/>
<xsl:strip-space elements="*"/>
<xsl:template match="/OMA">

<DataArea exportdata="false" onLoad="true" enctype="true" validate="true">
      
      
       <!--xsl:attribute name="submit">./UploadCertificateWebPlugin</xsl:attribute>
       <xsl:attribute name="submitdisplay"><xsl:value-of select="$strUpload"/></xsl:attribute-->
       <BottomCustomButton>
				<Data formSubmit="true" id="submitbuttoncontent">
					<xsl:attribute name="display"><xsl:value-of select="$strUpload"/></xsl:attribute>
					<xsl:attribute name="href">javascript:SubmitPage()</xsl:attribute>
				</Data>
	</BottomCustomButton>
        <BottomCustomButton>
		        <Data formSubmit="true">
				   <xsl:attribute name="display"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
				   <xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.CertificateClientSettingsWebPlugin</xsl:attribute>
		       </Data>
		      </BottomCustomButton>


       
	   
	    <xsl:call-template name="scripts"/>
		<script language="javascript">
		   function initializationRoutine()
	           { 
		        document.getElementById("PKCS12Encrypted").checked=false;
			document.getElementById("Base64").checked=true;
                        document.getElementById("Decryptionpassword").disabled = true;
		   }
                   function SubmitPage()
                   {	
                      document.getElementById("dataarea").encoding = "multipart/form-data";
                      document.getElementById("dataarea").enctype = "multipart/form-data";
                      var FileFormat = "Base64";
                      var Decryptionpassword="";
                      var CertificateType="Server";
		      if(document.getElementById("PKCS12Encrypted").checked == true)
			  { 
			     FileFormat  = "PKCS12Encrypted";
                             Decryptionpassword=document.getElementById("Decryptionpassword").value;
		          }
                      var url = "./UploadCertificateWebPlugin?FileFormat="+FileFormat+"&amp;Decryptionpassword="+Decryptionpassword+"&amp;CertificateType=Client";
		      document.getElementById("dataarea").action = url;
                      formSubmit();
            }

		   function OnPKCS12EncryptedSelected()
		   {  
		      if(document.getElementById("PKCS12Encrypted").checked == true)
			  { 
			     document.getElementById("Base64").checked=false;
                             document.getElementById("Decryptionpassword").disabled =false;
                             document.getElementById("Decryptionpassword").value="";
		          }
		   }
		   function OnBase64Selected()
		   {  
		          if(document.getElementById("Base64").checked == true)
			  {
			      document.getElementById("PKCS12Encrypted").checked=false;
                              document.getElementById("Decryptionpassword").disabled = true;
                              document.getElementById("Decryptionpassword").value="";
			  }
		   }
                   function validate()
                   {
                      if(document.getElementById("Base64").checked == false &amp;&amp;  document.getElementById("PKCS12Encrypted").checked==false)
                      {
                         alert('<xsl:value-of select="$strSelectFormatofFile"/>'); 
                         return false;
                      }
                      if(document.getElementById("PKCS12Encrypted").checked== true &amp;&amp; document.getElementById("Decryptionpassword").value=="")
                      {
                        alert('<xsl:value-of select="$strPasswordNotEntered"/>')
                        return false;
                      }
                      if(document.getElementById("FilePath").value=="")
                      {
                         alert('<xsl:value-of select="$strEnterFilePath"/>'); 
                         return false;
                      }
                     
                     return true;
                   }
		   
		   		   
		</script>
	   <PageTitle>
               <xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/></xsl:attribute>
       </PageTitle>
	  
	   <xsl:call-template name="CertificateOptionRows"/>
</DataArea>
        
</xsl:template>
 <xsl:template name="CertificateOptionRows">
    <TableData name="T1" ignoreJumpbar="true">
	   <Header>
	      <Data name="Options" editable="false" type="ustring" align="left"  noborderright="true">
				   <xsl:attribute name="value"><xsl:value-of select="$strSubHeader"/></xsl:attribute>
		</Data>
		<Data></Data>
	   </Header>
         
		 	<Row>
                <Data><xsl:attribute name="value"><xsl:value-of select="$strLabelCetrifitaceFormat"/></xsl:attribute></Data>
                <Data name="Base64" type="radio" event="onclick" handler="OnBase64Selected()" state="0">
             	         <xsl:attribute name="value"><xsl:value-of select="$strBase64"/></xsl:attribute>
		   		         <xsl:attribute name="returnvalue"/>
                </Data>
			</Row>
            <Row>	
                <Data></Data>			
                <Data name="PKCS12Encrypted" type="radio" event="onclick" handler="OnPKCS12EncryptedSelected()" state="0">
             	    <xsl:attribute name="value"><xsl:value-of select="$strPKCS12Encrypted"/></xsl:attribute>
				    <xsl:attribute name="returnvalue"/> 
          	    </Data>
            </Row>
                  <Row>
                       <Data><xsl:attribute name="value"><xsl:value-of select="$strLabelDecryptionPassword"/></xsl:attribute></Data>
                       <Data name="Decryptionpassword" type="password" maxlength="32" size="32" align="left"/>
                  </Row>
                  <Row>
		          
		  <Data><xsl:attribute name="value"><xsl:value-of select="$strLabelFilePath"/></xsl:attribute></Data>
		           <Data name="FilePath" type="file" maxlength="32" size="32" align="left">
                               <xsl:attribute name="returnvalue"/>
                           </Data>


                  </Row>
	</TableData>
 </xsl:template>
</xsl:stylesheet>

