<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:import href="Utils.xsl"/>
<xsl:output method="xml"/>
<xsl:strip-space elements="*"/>
<xsl:template match="/OMA">

<DataArea exportdata="false" onLoad="true">
       
	   
	    <xsl:call-template name="scripts"/>
		<script language="javascript">
		   function initializationRoutine()
	        { 

                    
		        document.getElementById("CreateSelfSigned").checked=true;
			  document.getElementById("ClientUploadCertificate").checked=false;
                    

		   }
		   function OnCreareSelfSignedSelected()
		   {  
		      if(document.getElementById("CreateSelfSigned").checked == true)
			  { 
			    document.getElementById("ClientUploadCertificate").checked=false;
                      

		      }
		   }
               function OnClientuploadSelected()
		   {  
		      if(document.getElementById("ClientUploadCertificate").checked == true)
			  {
			    document.getElementById("CreateSelfSigned").checked=false;
                      
			  }
		   }

		  
		   
		   function SubmitSelection()
		   {
		    	 
		     if(document.getElementById("CreateSelfSigned").checked == true)
			 {
			   document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CreateSelfSignedCertificateSettingsWebPlugin&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin!help=stprhl");
			 }
                   if(document.getElementById("ClientUploadCertificate").checked == true)
			 { //used same webplugin as for server
			   document.location.href = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CertificateClientUploadpageWebPlugin&amp;BackTo=./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin!help=stprhl");
			 }
                  
                }
		   
		</script>
	   <PageTitle>
               <xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/></xsl:attribute>
               
       </PageTitle>
       <xsl:if test="//ErrorCode &gt; -1">
        <AlertMessage> 
           <xsl:attribute name="display">       
                <xsl:choose>
                 
                 <xsl:when test="//UploadStatus = '1' and //ErrorCode = '0'"><xsl:value-of select="$strUploadSuccess"/></xsl:when>
                 <xsl:when test="//UploadStatus = '1' and //ErrorCode &gt; 0"><xsl:value-of select="$strUploadFailure"/></xsl:when>
                 <xsl:when test="//ErrorCode = '0'"><xsl:value-of select="$strCreateSuccess"/></xsl:when>
                 <xsl:when test="//ErrorCode &gt; 0"><xsl:value-of select="$strCreateFailure"/></xsl:when>
                 <xsl:otherwise><xsl:value-of select="$strOperationFailure"/></xsl:otherwise>
                </xsl:choose>
          </xsl:attribute>
           <xsl:attribute name="status">
                  <xsl:choose>                 
                 <xsl:when test="//ErrorCode = '0'">2</xsl:when>
                 <xsl:when test="//ErrorCode &gt; 0">4</xsl:when>
                 
                 <xsl:otherwise>4</xsl:otherwise>
                </xsl:choose>
           </xsl:attribute>
         </AlertMessage>
       </xsl:if>
	   <BottomCustomButton>
			<Data formSubmit="true" display="{$strContinue}" href="javascript:SubmitSelection() " id="submitbuttoncontent"/>
		</BottomCustomButton>
	   <xsl:call-template name="CertificateOptionRows"/>
          <BottomCustomButton>
		   <Data formSubmit="true">
				<xsl:attribute name="display"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.DisplayEncryptionWebplugin&amp;help=stprhl</xsl:attribute>
		   </Data>
		</BottomCustomButton>

</DataArea>
        
</xsl:template>
 <xsl:template name="CertificateOptionRows">
    <TableData name="T4" ignoreJumpbar="true">
	   <Header>
	      <Data name="Options" editable="false" type="ustring" align="left">
				   <xsl:attribute name="value"><xsl:value-of select="$strOptions"/></xsl:attribute>
		  </Data>
	   </Header>
		<Row>  
           <Data name="CreateSelfSigned" type="radio" event="onclick" handler="OnCreareSelfSignedSelected()" state="0">
             	<xsl:attribute name="value"><xsl:value-of select="$strCreateSelfSigned"/></xsl:attribute>
				<xsl:attribute name="returnvalue"/>
  	       </Data>
	    </Row>
		<Row>  
           <Data name="ClientUploadCertificate" type="radio" event="onclick" handler="OnClientuploadSelected()" state="0">
             	<xsl:attribute name="value"><xsl:value-of select="$strClientUploadCertificate"/></xsl:attribute>
				<xsl:attribute name="returnvalue"/>
  	       </Data>
	    </Row>
          

	</TableData>
 </xsl:template>
</xsl:stylesheet>

