<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:import href="Utils.xsl"/>

<xsl:template match="/OMA">
	<xsl:call-template name="success"/>
</xsl:template>
<xsl:template name="errorhandler">
<xsl:choose>
				<xsl:when test="(/OMA/cacheLunResponseCode != '0')">
					<xsl:call-template name="failure"><xsl:with-param name="respCode">cacheLunResponseCode</xsl:with-param>
				</xsl:call-template>
				</xsl:when>
				<xsl:when test="(/OMA/cacheusageResponseCode != '0') or (//OMA/cluster_status/aggregate_stats/@bytes_configured ='0')">
					<xsl:call-template name="failure"><xsl:with-param name="respCode">cacheusageResponseCode</xsl:with-param></xsl:call-template>
				</xsl:when>
				<xsl:when test="(/OMA/cacheLunstatsResponseCode != '0')">
					<xsl:call-template name="failure"><xsl:with-param name="respCode">cacheLunstatsResponseCode</xsl:with-param></xsl:call-template>
				</xsl:when>
				<xsl:otherwise></xsl:otherwise>
				
				
			</xsl:choose>
</xsl:template>
<xsl:template name="failure">
<xsl:param name="respCode"/>
	
		<xsl:choose>
		  <xsl:when test="($respCode = 'cacheLunResponseCode')">
		  	 <AlertMessage>
				<xsl:attribute name="display"><xsl:value-of select="$strcachelunNA"/></xsl:attribute>
			</AlertMessage>
		 </xsl:when>
		  <xsl:when test="($respCode = 'cacheusageResponseCode')">
		  	 <AlertMessage>
				<xsl:attribute name="display"><xsl:value-of select="$strcacheusageNA"/></xsl:attribute>
			  </AlertMessage>
		 </xsl:when>
		 <xsl:when test="($respCode = 'cacheLunstatsResponseCode')">
		  	 <AlertMessage>
				<xsl:attribute name="display"><xsl:value-of select="$strcacheLunstatsNA"/></xsl:attribute>
			 </AlertMessage>
		 </xsl:when>
		<xsl:otherwise>
			
		</xsl:otherwise>
		
		</xsl:choose>

		
	</xsl:template>

	
	<xsl:template name="success">
	
		<script language="javascript"> 
			var cacheusage='<xsl:value-of select="//OMA/cacheusage"/>';
			var cachediskperf='<xsl:value-of select="//OMA/cachediskperf"/>';
			var cacheperfdata_available='<xsl:value-of select="//cacheperfdata_available"/>';
			var expandlinegraph='<xsl:value-of select="//OMA/expandlinegraph"/>';
			var expandpiegraph='<xsl:value-of select="//OMA/expandpiegraph"/>';
			var cacheusageResponseError1 = '<xsl:value-of select="//OMA/cacheusageResponseCode"/>';
			var cacheusageResponseError2 = '<xsl:value-of select="//OMA/cluster_status/aggregate_stats/@bytes_configured"/>';
			var cacheLunResponseCodeError1 = '<xsl:value-of select="//OMA/cacheLunResponseCode"/>';
			var cacheLunstatsResponseCodeError2 = '<xsl:value-of select="//OMA/cacheLunstatsResponseCode"/>';
			var metaStartVal,metaEndVal,metaSteps,metaRows,metaCols;
			 var titlepart1,titlepart2,title;
	     
			function getCacheLunBackendPath(path)
			{
				for (var i = 0; i &lt; CacheLunPath.length; i++) { 
					
					
					if( path  == CacheLunPath[i][1])
						{	
						  return CacheLunPath[i][0]; //return diskname or disk partition
						}					
											
					}
				
				return 'NA';

			}
			function getCacheLun(path,partitionwwn)
			{	
				
				for (var i = 0; i &lt; CacheLunPath.length; i++) { 
									
					if( partitionwwn == CacheLunPath[i][2] || path  == CacheLunPath[i][0] ||  path  == CacheLunPath[i][1])
						{	
						  return CacheLunPath[i][1]; //return cachelunname
						}					
									
					}
				
				return 'NA';
			}
			
			 function initStatsData() 
			{
						setStringsForGraphLabel('<xsl:value-of select="$strLabelDay"/>','<xsl:value-of select="$strLabelTime"/>','<xsl:value-of select="$strAvg"/>');
						var cacheusageErr=false,cacheLUNErr=false;
						var lunRowIndex=0;
						<xsl:for-each select="//OMA/FluidCachedDisks/DCStorageObject/CacheLunName">
							createCacheLunBackEndPath('<xsl:value-of select="../CacheLunBackendPath"/>','<xsl:value-of select="."/>','<xsl:value-of select="../PartitionWWN"/>',lunRowIndex);
							lunRowIndex++;
						</xsl:for-each>
						var diskSelection='<xsl:value-of select="//OMA/FluidCachedDisks/DCStorageObject/CacheLunBackendPath"/>';
						var diskSelectionLunName='<xsl:value-of select="//OMA/FluidCachedDisks/DCStorageObject/CacheLunName"/>';
						var partitionWWN='<xsl:value-of select="//OMA/FluidCachedDisks/DCStorageObject/PartitionWWN"/>';
						<xsl:variable name="CacheLunBackendPath"><xsl:value-of select="//OMA/cachediskperf/@cachelunpath"/></xsl:variable>
						var CacheLunBackendPath='<xsl:value-of select="$CacheLunBackendPath"/>';

						if(CacheLunBackendPath!="")
							{diskSelection=getCacheLunBackendPath(CacheLunBackendPath);
							 diskSelectionLunName=getCacheLun(CacheLunBackendPath);
							}
						titlepart1=diskSelectionLunName;
						titlepart2="( "+ '<xsl:value-of select="$strFCDDeviceName"/>'+ diskSelection+" )" + "<xsl:value-of select="$strFluidCacheDiskChartHeaderPart2"/>";
					
						if((cacheusageResponseError1 !=0) || (cacheusageResponseError2 == 0))
						   	cacheusageErr=true;
						   
						if((cacheLunResponseCodeError1 !=0) || (cacheLunstatsResponseCodeError2 !=0 ))
						    cacheLUNErr=true;
							
						if( (!cacheusageErr) &amp;&amp;(cacheusage=="true" || expandpiegraph=="true")) // Plot piechart if user selects this option
							computeAndPlotPieGraph();
						
						if(cacheperfdata_available=="false")
							alert("<xsl:value-of select="$strCachePerfDataNotAvailable"/>");
						else if( (!cacheLUNErr) &amp;&amp; (cachediskperf=="true" || expandlinegraph=="true"))
								computeAndPlotLineGraph(titlepart1,titlepart2);		// Plot the Line chart if user selects cache Vs Disk option
						
						}	
				function parseRWGraph()
				{
					 var graphindex=0; // 0-- read/write Graph
					 var plotRW=true;
					<xsl:choose>
						<xsl:when test="//RW/xport">

					 metaStartVal ='<xsl:value-of select="//RW/xport/meta/start"/>';
					 metaEndVal   ='<xsl:value-of select="//RW/xport/meta/end"/>';
					 metaSteps    ='<xsl:value-of select="//RW/xport/meta/step"/>';
					 metaRows	    ='<xsl:value-of select="//RW/xport/meta/rows"/>';
					 metaCols	    ='<xsl:value-of select="//RW/xport/meta/columns"/>';
					 storeMetaData(graphindex,"rw",metaStartVal,metaEndVal,metaSteps,metaRows,metaCols);

					 //Create Legend Array and store the legend names
					createLegendObjectArray(graphindex); // 0-- read/write Graph
					var entryindex=0;
					<xsl:for-each select="//RW/xport/meta/legend/entry">
						createLegendEntriesArray(graphindex,entryindex,'<xsl:value-of select="."/>');
						entryindex++;
					</xsl:for-each>

					//Create array to hold x-axis(Epoch Time)values and y-axis(Bytes) values
					var rowindex=0; colindex=0;var sum=0,y_axisVal,x_axisVal,cnt,countNAN,rowNANCount=0;
					createXAxisObject(graphindex);
					<xsl:for-each select="//RW/xport/data/row">
						colindex=0;countNAN=0;
						x_axisVal	='<xsl:value-of select="t"/>';
						 cnt	='<xsl:value-of select="count(child::node())"/>'; 
						createXAxisObjectArray(graphindex,rowindex,x_axisVal);//Check if this is required
						<xsl:for-each select="child::node()">
							var node='<xsl:value-of select="name()"/>';
							//countNAN=0;
							if(node != 't')//ignoring time column
							{ 	
								if(isNaN(parseFloat(('<xsl:value-of select="."/>'))))
									countNAN++;
								else
								{
									y_axisVal=parseFloat(('<xsl:value-of select="."/>'));
									createxmlObjectArray(graphindex,rowindex,colindex,x_axisVal,y_axisVal);
									colindex++;
								}
								
							}
						</xsl:for-each>
						
						if(countNAN==legendEntry[graphindex].length)
							rowNANCount++;

						rowindex++;
				   </xsl:for-each>
					
					 computeAverageForAllLegend(graphindex,rowNANCount);
				</xsl:when>
				<xsl:otherwise>
					plotRW=false;
				</xsl:otherwise>
				</xsl:choose>
					return plotRW;
					
				}
				
				function parseIOPSGraph()
				{
					 var graphindex=1; // 0-- read/write Graph
					 var plotIOPS=true;
					<xsl:choose>
						<xsl:when test="//IOPS/xport">
							 metaStartVal ='<xsl:value-of select="//IOPS/xport/meta/start"/>';
							 metaEndVal   ='<xsl:value-of select="//IOPS/xport/meta/end"/>';
							 metaSteps    ='<xsl:value-of select="//IOPS/xport/meta/step"/>';
							 metaRows	    ='<xsl:value-of select="//IOPS/xport/meta/rows"/>';
							 metaCols	    ='<xsl:value-of select="//IOPS/xport/meta/columns"/>';
							 storeMetaData(graphindex,"rw",metaStartVal,metaEndVal,metaSteps,metaRows,metaCols);

							 //Create Legend Array and store the legend names
							createLegendObjectArray(graphindex); // 1-- IOPS Graph
							var entryindex=0;
							<xsl:for-each select="//IOPS/xport/meta/legend/entry">
								createLegendEntriesArray(graphindex,entryindex,'<xsl:value-of select="."/>');
								entryindex++;
							</xsl:for-each>

							//Create array to hold x-axis(Epoch Time)values and y-axis(Bytes) values
							var rowindex=0; colindex=0;var sum=0,y_axisVal,countNAN,rowNANCount=0;
							createXAxisObject(graphindex);
							<xsl:for-each select="//IOPS/xport/data/row">
							colindex=0;countNAN=0;
							var  x_axisVal	='<xsl:value-of select="t"/>';
							var cnt	='<xsl:value-of select="count(child::node())"/>'; 
							createXAxisObjectArray(graphindex,rowindex,x_axisVal);//Check if this is required
							<xsl:for-each select="child::node()">
							var node='<xsl:value-of select="name()"/>';
				
							if(node != 't')//ignoring time column
							{ 	
								if(isNaN(parseFloat(('<xsl:value-of select="."/>'))))
									countNAN++;
								else
								{
								y_axisVal=parseFloat(('<xsl:value-of select="."/>'));
								createxmlObjectArray(graphindex,rowindex,colindex,x_axisVal,y_axisVal);
								colindex++;
								}
								

							}
							</xsl:for-each>

							if(countNAN==legendEntry[graphindex].length)
							rowNANCount++;

							rowindex++;
				  		 </xsl:for-each>
						
				  		 computeAverageForAllLegend(graphindex,rowNANCount);
						</xsl:when>
						<xsl:otherwise>
							plotIOPS=false;
						</xsl:otherwise>
					</xsl:choose>
					return plotIOPS;
		
				}


				// create the plot data and plot  the Line Graph
				function computeAndPlotLineGraph(titlepart1,titlepart2)
				{  

				 var  rwtitle,iopstitle,plotRW,plotIOPS;
				 plotRW=	parseRWGraph();
				 plotIOPS=	parseIOPSGraph();
				 rwtitle="<xsl:value-of select="$strFluidCacheDiskChartHeaderPart1"/>" ;
				 iopstitle="<xsl:value-of select="$strFluidCacheDiskIOPSChartHeader"/>";
				if(expandlinegraph=="true")//if plot in new window 
					{
						if(plotRW)
						{	
							plotGraph(0,true,rwtitle,titlepart1,titlepart2,'linecontainer1'); //false indicates plot in same window
						}
						else if(plotIOPS)
						{	
							plotGraph(1,true,iopstitle,titlepart1,titlepart2,'linecontainer1');
						}
						
					}
					else	
					{   
							if(plotRW)
							plotGraph(0,false,rwtitle,titlepart1,titlepart2,'container2'); //false indicates plot in same window
							
							if(plotIOPS)
							plotGraph(1,false,iopstitle,titlepart1,titlepart2,'container3');
					  
					}
							
				}
				// create the plot data and plot  the Pie Graph
				function computeAndPlotPieGraph()
				{
					var entryindex=0,diskIndex=0,percentageOfCacheUsage=0,totalCacheUsage=0;
							var aggregate_stats='<xsl:value-of select="//cluster_status/aggregate_stats/@bytes_configured"/>';
							storeAggregateBytes(aggregate_stats);									
							<xsl:for-each select="//cluster_status/cs/storage_path">
								//storage_path_stats
								<xsl:if test="storage_path_stats/@name = 'current'">
									var path='<xsl:value-of select="@path"/>';
									var state='<xsl:value-of select="@available"/>';
									var wwn='<xsl:value-of select="@wwn"/>'
									path=getCacheLun(path,wwn);
									if(path !='NA')
									{	
										createLegendEntriesArray_Pie(entryindex,path);
										percentageOfCacheUsage='<xsl:value-of select="storage_path_stats/@total_bytes_referenced"/>';
										totalCacheUsage=parseFloat(totalCacheUsage)+parseFloat(percentageOfCacheUsage);
										percentageOfCacheUsage=parseFloat(percentageOfCacheUsage/aggregate_stats);
										cacheDiskArray(diskIndex,percentageOfCacheUsage);
									}
								</xsl:if>
								entryindex++;diskIndex++;
							</xsl:for-each>
							//Compute the unused cachepool
							var unusedcache=0;
							if(parseInt(totalCacheUsage) &lt; aggregate_stats)
							{
								unusedcache=parseInt(aggregate_stats)-parseInt(totalCacheUsage);
								percentageOfCacheUsage=parseFloat(unusedcache/aggregate_stats);
								cacheDiskArray(diskIndex,percentageOfCacheUsage);
								createLegendEntriesArray_Pie(entryindex,'<xsl:value-of select="$strUnusedCache"/>');
							}
							//setLegendEntriesArray_Pie();
							plotPieChart(expandpiegraph);
				
				}
		</script>
	
	<xsl:choose>
		<xsl:when test="//OMA/expandlinegraph = 'true' or //OMA/expandpiegraph = 'true'">
			<xsl:if test="//OMA/expandlinegraph = 'true'">
				<xsl:call-template name="plotNewWin">
					<xsl:with-param name="graphtype">line</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="//OMA/expandpiegraph = 'true'">
				<xsl:call-template name="plotNewWin">
					<xsl:with-param name="graphtype">pie</xsl:with-param>
				</xsl:call-template>
			</xsl:if>

		</xsl:when>
		<xsl:otherwise>
			<DataArea onLoad="true" statistics="true" exportdata="false" email="true">
				<xsl:attribute name="expandview"><xsl:value-of select="$strExpandView"/></xsl:attribute>
				<xsl:attribute name="plotgraph"><xsl:value-of select="$strplotgraph"/></xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strCacheStatistics"/></xsl:attribute>
			</PageTitle>
				<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.sm.webplugins.CacheStatsWebPlugin&amp;cacheusage=<xsl:value-of select="//OMA/cacheusage"/>&amp;cachediskperf=<xsl:value-of select="//OMA/cachediskperf"/>&amp;diskselection=<xsl:value-of select="//OMA/cachediskperf/@cachelunpath"/>&amp;timeinterval=<xsl:value-of select="//OMA/cachediskperf/@timeinterval"/>&amp;timeunit=<xsl:value-of select="//OMA/cachediskperf/@timeunit"/>&amp;help=fldcsta</xsl:attribute>
				</Data>
			</CustomButton>
			
			<xsl:call-template name="errorhandler"/>
				<SummaryData statistics="true">
					<xsl:if test="(//OMA/cacheusageResponseCode = '0') and (//OMA/cluster_status/aggregate_stats/@bytes_configured !='0')">					
						<Section name="pie"><xsl:attribute name="display"><xsl:value-of select="$strCachePoolUtil"/></xsl:attribute>
					
							<xsl:if test="//OMA/cacheusage='true'">
								<xsl:attribute name="plotpiegraph">true</xsl:attribute>		
							</xsl:if>
						</Section>
					</xsl:if>  
					
					<Section name="line"><xsl:attribute name="display"><xsl:value-of select="$strCacheDiskPerf"/></xsl:attribute>
						<xsl:if test="//OMA/cachediskperf='true'">
							<xsl:attribute name="plotlinegraph">true</xsl:attribute>		
						</xsl:if>

					<ListData>
						
						<Data id="diskselection" name="diskselection" type="select"> 
						<xsl:attribute name="display"><xsl:value-of select="$strCacheLun"/></xsl:attribute>
							<xsl:variable name="CacheLunBackendPath"><xsl:value-of select="//OMA/cachediskperf/@cachelunpath"/></xsl:variable>
												
						<xsl:for-each select="//OMA/FluidCachedDisks/DCStorageObject/CacheLunBackendPath">
						
							<Choice>
									<xsl:variable name="retval"><xsl:value-of select="../CacheLunName"/></xsl:variable>
									<xsl:attribute name="value"><xsl:value-of select="../CacheLunName"/></xsl:attribute>
									<xsl:attribute name="returnvalue"><xsl:value-of select="../CacheLunName"/></xsl:attribute>
									 <xsl:if test="$CacheLunBackendPath=$retval">
									 	<xsl:attribute name="default">true</xsl:attribute>
									 </xsl:if>
							</Choice>	
						
						</xsl:for-each>					
						</Data>
					
					<Data id="timeinterval" type="editbox" size="2" maxlength="2" name="timeinterval" splcase="true">
					<xsl:attribute name="display"><xsl:value-of select="$strTimeInterval"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
								<xsl:when test="//OMA/cachediskperf='true'"><xsl:value-of select="//OMA/cachediskperf/@timeinterval"/></xsl:when>
								<xsl:otherwise>12</xsl:otherwise>
						    </xsl:choose>
					</xsl:attribute>
					
					<ExtraItem id="timeunit" name="timeunit" type="select">
							
						<xsl:variable name="retval">
								<xsl:choose>
										  <xsl:when test="//OMA/cachediskperf='true'"><xsl:value-of select="//OMA/cachediskperf/@timeunit"/></xsl:when>
										  <xsl:otherwise>min</xsl:otherwise>
								</xsl:choose>

							</xsl:variable>
							<Choice>
								<xsl:attribute name="value"><xsl:value-of select="$strMinF"/></xsl:attribute>
								<xsl:attribute name="returnvalue">min</xsl:attribute>
								<xsl:if test="$retval='min'">
								<xsl:attribute name="default">true</xsl:attribute>
								</xsl:if>
							</Choice>
                                           <Choice>
								<xsl:attribute name="value"><xsl:value-of select="$strHourF"/></xsl:attribute>
								<xsl:attribute name="returnvalue">h</xsl:attribute>
								<xsl:if test="$retval='h'">
									<xsl:attribute name="default">true</xsl:attribute>
								</xsl:if>
							</Choice>
                                          <Choice>
								<xsl:attribute name="value"><xsl:value-of select="$strDayF"/></xsl:attribute>
								<xsl:attribute name="returnvalue">d</xsl:attribute>
								<xsl:if test="$retval='d'">
								<xsl:attribute name="default">true</xsl:attribute>
								</xsl:if>
							</Choice>
                                           <Choice>
								<xsl:attribute name="value"><xsl:value-of select="$strWeekF"/></xsl:attribute>
								<xsl:attribute name="returnvalue">w</xsl:attribute>
								<xsl:if test="$retval='w'">
								<xsl:attribute name="default">true</xsl:attribute>
								</xsl:if>
							</Choice>
                                          <Choice>
								<xsl:attribute name="value"><xsl:value-of select="$strMonthF"/></xsl:attribute>
								<xsl:attribute name="returnvalue">mon</xsl:attribute>
								<xsl:if test="$retval='mon'">
								<xsl:attribute name="default">true</xsl:attribute>
								</xsl:if>
							</Choice>
                                           <!--Choice>
								<xsl:attribute name="value"><xsl:value-of select="$strYearF"/></xsl:attribute>
								<xsl:attribute name="returnvalue">y</xsl:attribute>
								<xsl:if test="$retval='y'">
								<xsl:attribute name="default">true</xsl:attribute>
								</xsl:if>
							</Choice-->

 
						</ExtraItem>
					<ExtraItem type="button">
						<xsl:attribute name="href">javascript:submitData()</xsl:attribute> 
						<xsl:attribute name="value"><xsl:value-of select="$strplotgraph"/></xsl:attribute>
						<xsl:attribute name="tablebutton">true</xsl:attribute>
					</ExtraItem>
					</Data>
					<xsl:if test="//OMA/cachediskperf='true'">
                              	<xsl:for-each select="//OMA/FluidCachedDisks/DCStorageObject/CacheLunBackendPath">
							<xsl:variable name="CachePath"><xsl:value-of select="../CacheLunName"/></xsl:variable>
							<xsl:if test="//OMA/cachediskperf/@cachelunpath = $CachePath">
			 					<Data name="State" editable="false" type="ustring">
									<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:call-template name="GetFluidCacheState"><xsl:with-param name="state"><xsl:value-of select="../ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
								</Data>
								
		            
							</xsl:if>
						</xsl:for-each>	
					</xsl:if>
			  	 </ListData>					
				</Section>			
				
				</SummaryData>
			
			
			<script type="text/javascript" src="/oma/js/highcharts.js"></script>
			<script type="text/javascript" src="/oma/js/prototype-adapter.js"></script>
			<script type="text/javascript" src="/oma/js/plotstatisticsdata.js"></script>
			
			<script language="javascript"> 
				
				function submitData()
				{	
					if (!validateData())
					{
						return;

					}

					document.dataarea.action = top.gnv.appendVID("./DataArea?plugin=com.dell.sm.webplugins.CacheStatsWebPlugin&amp;cachediskperf=true&amp;help=fldcsta")+"#line";
					document.dataarea.submit();			
									
				}
			
				function expandGraph(graphindex,graphtype,vid)
				{	var graphPopUpWin ;
					var diskselection=document.getElementById("diskselection").value;
					var timeinterval=document.getElementById("timeinterval").value;
					var timeunit=document.getElementById("timeunit").value;
					if(graphtype=="line")
					{
					 var url="./OMSAView?plugin=com.dell.sm.webplugins.CacheStatsWebPlugin&amp;expandlinegraph=true&amp;cacheusage=false&amp;cachediskperf=true&amp;graphindex="+graphindex+"&amp;diskselection="+diskselection+"&amp;timeinterval="+timeinterval+"&amp;timeunit="+timeunit+"&amp;vid=<xsl:value-of select="VID"/>";
					  					 
					}
					if(graphtype=="pie")
					{
					  url="./OMSAView?plugin=com.dell.sm.webplugins.CacheStatsWebPlugin&amp;expandpiegraph=true&amp;cacheusage=true&amp;cachediskperf=false&amp;vid=<xsl:value-of select="VID"/>";
					}
			    	graphPopUpWin = window.open(url, 0, config='height=550,width=780,scrollbars=yes,toolbar=no,menubar=no,resizable=yes,location=no,directories=no,status=no');
				    graphPopUpWin.focus();		
				}
				function validateData()
				{
					if(document.getElementById("timeinterval")==null || document.getElementById("timeinterval").value=='')
					{	alert("<xsl:value-of select="$strinvalidtimeerror1"/>");
						return false;
					}
					else 
					if(document.getElementById("timeinterval")==null || isNotWholeNumber(document.getElementById("timeinterval").value)==true || document.getElementById("timeinterval").value &lt; 1)
						{	
                            var     errorMsg =""; 
							var TimeUnit = document.getElementById("timeunit").value ;
                                          if( TimeUnit =="min")
								{
								     errorMsg="<xsl:value-of select="$strMinF"/>";
								}
							if( TimeUnit =="h")
								{
   								     errorMsg="<xsl:value-of select="$strHourF"/>";
								}
							if( TimeUnit =="d")
								{
   									 errorMsg="<xsl:value-of select="$strDayF"/>";
								}
							if( TimeUnit =="w")
								{
    									errorMsg="<xsl:value-of select="$strWeekF"/>";
								}
							if( TimeUnit =="mon")
								{
    									errorMsg="<xsl:value-of select="$strMonthF"/>";
							}
							if( TimeUnit =="y")
								{
   									 errorMsg="<xsl:value-of select="$strYearF"/>";
								}



							alert("<xsl:value-of select="$strinvalidtimeerror2"/>"+" "+errorMsg);
                                          document.getElementById("timeinterval").value="";
							return false;
						}

					
					
					return true;
				}

				function initializationRoutine()
				{		
					
					initStatsData();
							
				}//end init
		
		
			</script>
		

		</DataArea>
		</xsl:otherwise>
	</xsl:choose>

</xsl:template>
	
	
<xsl:template name="plotNewWin">
<xsl:param name="graphtype"/>
	<HTML>
	<title>
	<xsl:choose>
		<xsl:when test="$graphtype='line'">
			<xsl:value-of select="$strCacheDiskPerf"/>
		</xsl:when>
			
		<xsl:when test="$graphtype='pie'">
			<xsl:value-of select="$strCachePoolUtil"/>
		</xsl:when>

	</xsl:choose>
	</title>
	
	<script type="text/javascript" src="/oma/js/prototype.js"></script> 
	<script type="text/javascript" src="/oma/js/prototype-adapter.js"></script>
	<script type="text/javascript" src="/oma/js/highcharts.js"></script>
	<script type="text/javascript" src="/oma/js/plotstatisticsdata.js"></script>
	<body  onload="initStatsData();">
		<xsl:choose>
		<xsl:when test="$graphtype='line'">
			<div id="linecontainer1" style="min-width: 400px; height: 500px; margin: 0 auto"></div>
		</xsl:when>
		<xsl:when test="$graphtype='pie'">
			<div id="piecontainer" style="min-width: 400px; height: 500px; margin: 0 auto"></div>			

		</xsl:when>

	</xsl:choose>

		
	</body>
	</HTML>
</xsl:template>

</xsl:stylesheet>

