<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
    <xsl:include href="../common/adtbl.xsl"/>


<xsl:template match="/">
<DataArea>
     <xsl:choose>
	    <xsl:when test="(count(/*/ArrayDisks) &gt; 0) and (count(/*/ArrayDisks[@MaxSlotLength != '']) &gt; 0) ">
  	         <xsl:apply-templates select="/*/ArrayDisks"/>
	    </xsl:when>
        <xsl:otherwise><xsl:value-of select="$strNoEnclosure"/></xsl:otherwise>
     </xsl:choose>	
</DataArea>
</xsl:template>

<xsl:template match="ArrayDisks">
     <TableData>
	    
        <SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="@EnclosureName"/><xsl:value-of select="$strTitle2"/><xsl:value-of select="@ControllerName"/></xsl:attribute>
	    </SubHeader>
		
        <Header>
	    	<xsl:call-template name="SlotOccupancyHeaders"/>
        </Header>
		
		<xsl:call-template name="SlotOccupancyRows"/>
	
     </TableData>		
	 <TableData>
	     <xsl:if test="count(/*/ArrayDisks/DCStorageObject/ObjID) &gt; 0">
	     <SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strOccupiedPDDetails"/></xsl:attribute>
	    </SubHeader>
	    </xsl:if>	
	    <Header>
		    <xsl:call-template name="ArrayDiskTableHeader"/>
		</Header>
		<xsl:choose>
		<xsl:when test="DCStorageObject/EnclosureID">
		<xsl:for-each select="DCStorageObject[ObjID != '']">
				<xsl:sort select="Channel" data-type="number" order="ascending"/>
				<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
				<xsl:sort select="TargetID" data-type="number" order="ascending"/>
				<xsl:call-template name="ArrayDiskTableRows"/>
		</xsl:for-each>
		</xsl:when>
		</xsl:choose>
      </TableData>
</xsl:template>	

<xsl:template name="SlotOccupancyHeaders">
	      <Data name="ID" columnspacing="true" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
		  </Data>
		  <Data name="SlotCount" columnspacing="true" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strSlotCount"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strSlotCount"/></xsl:attribute>
		  </Data>
		  <Data name="OccupiedSlotCount" columnspacing="true" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strOccupiedSlotCount"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strOccupiedSlotCount"/></xsl:attribute>
		  </Data>
		  <Data name="EmptySlotCount" columnspacing="true" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strEmptySlotCount"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strEmptySlotCount"/></xsl:attribute>
		  </Data>
		  <Data name="OccupiedSlots" columnspacing="true" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strOccupiedSlots"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strOccupiedSlots"/></xsl:attribute>
		  </Data>
		  <Data name="EmptySlots" columnspacing="true" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strEmptySlots"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strEmptySlots"/></xsl:attribute>
		  </Data>
</xsl:template>


<xsl:template name="SlotOccupancyRows">

     <xsl:variable name="VAR_OccupiedSlots">
	     <xsl:for-each select="DCStorageObject[ObjID != '' and  ObjState != '1024']">
	     <xsl:sort select="TargetID" data-type="number" order="ascending"/>
		       <xsl:value-of select="TargetID"/>
			   <xsl:if test="position() != last()">
			   	   <xsl:text>,</xsl:text>
			   </xsl:if>
	     </xsl:for-each>
    </xsl:variable> 
	<xsl:variable name="VAR_EmptySlots">
	     <xsl:for-each select="DCStorageObject[not(ObjID) or  ObjState = '1024']">
	     <xsl:sort select="TargetID" data-type="number" order="ascending"/>
		       <xsl:value-of select="TargetID"/>
			   <xsl:if test="position() != last()">
			   	   <xsl:text>,</xsl:text>
			   </xsl:if>
	     </xsl:for-each>
    </xsl:variable> 
	<Row height="30px">
	   <Data name="ID" type="ustring" columnspacing="true" align="center" ignoreonweb="true">
				<xsl:attribute name="value"><xsl:value-of select="@Channel"/>:<xsl:value-of select="@EnclosureID"/></xsl:attribute>
	   </Data>
	   <Data name="SlotCount" type="ustring" columnspacing="true" align="center" ignoreonweb="true">
				<xsl:attribute name="value"><xsl:value-of select="@MaxSlotLength"/></xsl:attribute>
	   </Data>
	   <Data name="OccupiedSlotCount" type="ustring" columnspacing="true" align="center" ignoreonweb="true">
				<xsl:attribute name="value"><xsl:value-of select="count(DCStorageObject[ObjID != '' and  ObjState != '1024'])"/></xsl:attribute>
	   </Data>
	   <Data name="EmptySlotCount" type="ustring" columnspacing="true" align="center" ignoreonweb="true">
				<xsl:attribute name="value"><xsl:value-of select="count(DCStorageObject[not(ObjID) or  ObjState = '1024'])"/></xsl:attribute>
	   </Data>
	   <xsl:choose>
	   <xsl:when test = "$VAR_OccupiedSlots != ''">
	      <Data name="OccupiedSlots" type="ustring" columnspacing="true" align="center" ignoreonweb="true">
			<xsl:attribute name="value"><xsl:value-of select="$VAR_OccupiedSlots"/></xsl:attribute>	
          </Data>
       </xsl:when>
	   <xsl:otherwise>
	     <Data name="OccupiedSlots" type="ustring" columnspacing="true" align="center" ignoreonweb="true">
	      <xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>	
		 </Data> 
	   </xsl:otherwise>
       </xsl:choose>
       <xsl:choose>
	    <xsl:when test = "$VAR_EmptySlots != ''">	  
	     <Data name="EmptySlots" type="ustring" columnspacing="true" align="center" ignoreonweb="true">
			<xsl:attribute name="value"><xsl:value-of select="$VAR_EmptySlots"/></xsl:attribute>	
         </Data>
        </xsl:when>
	    <xsl:otherwise>
	      <Data name="EmptySlots" type="ustring" columnspacing="true" align="center" ignoreonweb="true">
	         <xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>	
		  </Data>  
	    </xsl:otherwise>
      </xsl:choose>	    
    </Row>
</xsl:template>

<xsl:template match="OMAUserRights"/>
<xsl:template match="*"/>

</xsl:stylesheet>
