<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:include href="../common/Utils.xsl"/>
    <xsl:include href="../common/pstbl.xsl"/>
    <xsl:include href="../en/globals.xsl"/>
    <xsl:template match="OMA">
        <DataArea>
            <PageTitle>
                <xsl:if test="count(PowerSupply/DCStorageObject)='0'">
                    <xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="PowerSupply/@EnclosureId"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="count(PowerSupply/DCStorageObject) > '1'">
                    <xsl:attribute name="display"><xsl:value-of select="$strTitle2"/><xsl:value-of select="PowerSupply/@EnclosureId"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="count(PowerSupply/DCStorageObject)='1'">
                    <xsl:attribute name="display"><xsl:value-of select="$strTitle3"/><xsl:value-of select="PowerSupply/DCStorageObject/Index"/> in Enclosure <xsl:value-of select="PowerSupply/@EnclosureId"/></xsl:attribute>
                </xsl:if>
            </PageTitle>
            <xsl:choose>
                <xsl:when test="count(PowerSupply/DCStorageObject)!=0">
                    <TableData>
                        <Header>
                            <xsl:call-template name="PSTableHeader"/>
                        </Header>
                        <xsl:for-each select="PowerSupply/DCStorageObject">
							<xsl:sort select="Index" data-type="number" order="ascending"/>
                            <xsl:call-template name="PSTableRows"/>
                        </xsl:for-each>
                    </TableData>
                </xsl:when>
            </xsl:choose>
        </DataArea>
    </xsl:template>
    <xsl:template match="//PowerSupply/DCStorageObject">
        <Row>
            <Data>
                <xsl:attribute name="value"><xsl:value-of select="Index"/></xsl:attribute>
            </Data>
            <Data>
                <xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
            </Data>
            <Data>
                <xsl:attribute name="value"><xsl:call-template name="imagedesc"><xsl:with-param name="ObjStatus"><xsl:value-of select="ObjStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
            </Data>
            <Data>
                <xsl:attribute name="value"><xsl:value-of select="EnclosureID"/></xsl:attribute>
            </Data>
            <Data>
                <xsl:attribute name="value"><xsl:value-of select="PartNo"/></xsl:attribute>
            </Data>
        </Row>
    </xsl:template>
    <xsl:template match="OMAUserRights"/>
    <xsl:template match="*"/>
</xsl:stylesheet>
