<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:template match="OMA">
		<DataArea>
			<xsl:variable name="slotNum">
				<xsl:choose>
					<xsl:when test="LockedDrives/@PCISlotNo = '-1' or LockedDrives/@PCISlotNo = '2147483648' or LockedDrives/@PCISlotNo = '0' ">
						<xsl:value-of select="$strEmbedded"/>
					</xsl:when>
					<xsl:when test="LockedDrives/@PCISlotNo = '2147483649'">
						<xsl:value-of select="'Not Available'"/>
					</xsl:when>
						<xsl:otherwise>Slot <xsl:value-of select="LockedDrives/@PCISlotNo"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>	

			<PageTitle>
				<xsl:choose>
					<xsl:when test="count(/*/LockedDrives/DCStorageObject[not(UnlockForeignDKMStatus)]) > 0">
						<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="LockedDrives/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle2"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</PageTitle>

			<xsl:if test="count(/*/LockedDrives/DCStorageObject[not(UnlockForeignDKMStatus)]) > 0">
				<TableData>
					<Header>
                             		<xsl:call-template name="ForeigLockedDrivesHeader"/>
					</Header>
                        	<xsl:for-each select="/*/LockedDrives/DCStorageObject[not(UnlockForeignDKMStatus)]">
						            <xsl:sort select="Index" data-type="number" order="ascending"/>
                            		<xsl:call-template name="ForeigLockedDrivesRow"/>
                            </xsl:for-each>
				</TableData>
			</xsl:if>
		</DataArea>
	</xsl:template>

	<xsl:template match="OMAUserRights"/>
	<xsl:template match="*"/>

      <xsl:template name="ForeigLockedDrivesHeader">
		<Data name="Id" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strLabelSecurityKeyIdentifier"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strLabelSecurityKeyIdentifier"/></xsl:attribute>
		</Data>
		<Data name="Status" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strLockedPhysicalDisks"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strLockedPhysicalDisks"/></xsl:attribute>
		</Data>
	</xsl:template>

      <xsl:template name="ForeigLockedDrivesRow">
		<Row>
            	<Data editable="false" type="ustring">
                     <xsl:attribute name="value"><xsl:value-of select="SecurityKeyId"/></xsl:attribute>
		    	</Data>
		    	<Data editable="false" type="ustring">
			   <xsl:attribute name="value"><xsl:value-of select="DIDList"/></xsl:attribute>
		    	</Data>
          	</Row>
	</xsl:template>
</xsl:stylesheet>


