<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../common/ctrltbl.xsl"/>
	<xsl:include href="../common/chnltbl.xsl"/>
	<xsl:include href="../common/adtbl.xsl"/>
	<xsl:include href="../common/vdtbl.xsl"/>
      <xsl:include href="../common/fcdtbl.xsl"/>
     	<xsl:include href="../common/vdparttbl.xsl"/>
	<xsl:include href="../common/btrytbl.xsl"/>
	<!-- DFCT140720 - CLI: Enclosure info not seen under controller details using omreport command  -->
	<!-- Indravijay J. Gohil Adding in the necessary templates to be able to display the enclosure info on CLI-->
	<xsl:include href="../common/encltbl.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:template match="/">
		<DataArea>
			<xsl:variable name="slotNum">
				<xsl:choose>
					<xsl:when test="/*/Controllers/DCStorageObject/PCISlot = '-1' or /*/Controllers/DCStorageObject/PCISlot = '2147483648' or /*/Controllers/DCStorageObject/PCISlot = '0' ">
						<xsl:value-of select="$strEmbedded"/>
					</xsl:when>
					<xsl:when test="/*/Controllers/DCStorageObject/PCISlot = '2147483649'">
					<xsl:value-of select="'Not Available'"/>
					</xsl:when>
					<xsl:otherwise>Slot <xsl:value-of select="/*/Controllers/DCStorageObject/PCISlot"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<!-- Determine which form of the cli was invoked.  This determines the page title. -->
			<xsl:choose>
				<xsl:when test="count(//UserInputError)>0">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="//UserInputError"/></xsl:attribute>
					</PageTitle>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="count(/*/Controllers/DCStorageObject)>1">
							<!--						<xsl:when test="/*/Controllers/@System='true'"> -->
							<PageTitle>
								<xsl:attribute name="display"><xsl:value-of select="$strTitle2"/></xsl:attribute>
							</PageTitle>
						</xsl:when>
						<xsl:when test="count(/*/Controllers/DCStorageObject)=1">
							<PageTitle>
								<xsl:attribute name="display"><xsl:value-of select="$strTitle3"/><xsl:value-of select="/*/Controllers/DCStorageObject/Name"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
							</PageTitle>
						</xsl:when>
						<xsl:otherwise>
							<PageTitle>
								<xsl:attribute name="display"><xsl:value-of select="$strTitle4"/></xsl:attribute>
							</PageTitle>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="count(/*/Controllers/DCStorageObject)>0">
						<xsl:apply-templates select="/*/Controllers"/>
					</xsl:if>					
					<xsl:apply-templates select="/*/Channels"/>
					<xsl:apply-templates select="/*/VirtualDisks"/>
                              <xsl:apply-templates select="/*/Partitions"/>
					<xsl:apply-templates select="/*/ArrayDisks"/>
					<xsl:apply-templates select="/*/Batteries"/>
					<!-- DFCT140720 - CLI: Enclosure info not seen under controller details using omreport command  -->
					<!-- Indravijay J. Gohil Adding in the necessary templates to be able to display the enclosure info on CLI-->
					<xsl:apply-templates select="/*/Enclosures"/>
				</xsl:otherwise>
			</xsl:choose>
		</DataArea>
	</xsl:template>
	<xsl:template match="Batteries">
		<TableData>
			<!-- DFCT140515  CLI :omreport says "Batteries" instead of "Battery"  -->
			<!-- Indravijay J. Gohil Changing batteries to battery-->
			<SubHeader display="Battery"></SubHeader>
			<Header>
				<xsl:call-template name="BatteryTableHeader">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</Header>
			<xsl:for-each select="DCStorageObject">
				<xsl:call-template name="BatteryTableRows">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
		</TableData>
	</xsl:template>
	<xsl:template match="Controllers">
		<!-- BITS131577: the controller table header will be displayed specific to each controller; earlier it was generic for all controllers  -->
			<xsl:for-each select="DCStorageObject">
				<xsl:sort select="GlobalNo" data-type="number" order="ascending"/>
				<TableData>
					<SubHeader display="Controller"/>
					<Header>
						<xsl:call-template name="ControllerTableHeader">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</Header>
						<xsl:call-template name="ControllerTableRows">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
				</TableData>
			</xsl:for-each>
		
	</xsl:template>

	<xsl:template match="Channels">
		<xsl:choose>
			<xsl:when test="substring(DCStorageObject/AttributesMask,26,1)='1'">
				<TableData>
					<xsl:choose>
				      <xsl:when test="DCStorageObject/BusProtocol != '9'">
					      <SubHeader display="Connectors"/>
				      </xsl:when>
				      <xsl:otherwise>
					      <SubHeader display="PCIe SSD Extender"/>
				      </xsl:otherwise>
				   </xsl:choose>
					<Header>
						<xsl:call-template name="ChannelTableHeader">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="DCStorageObject[1]">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:call-template name="ChannelTableRows">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>

				<!-- Provide the below path health table only in the case if connector in multipath -->
				<TableData>
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeader5"/></xsl:attribute>
					</SubHeader>
					<Header>
						<xsl:call-template name="PathHealthCommonTableHeader"/>
					</Header>
					<xsl:for-each select="DCStorageObject[1]">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:call-template name="PathHealthConnector0TableRows"/>
					</xsl:for-each>
					<Header>
						<xsl:call-template name="PathHealthCommonTableHeader"/>
					</Header>
					<xsl:for-each select="DCStorageObject[2]">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:call-template name="PathHealthConnector1TableRows"/>
					</xsl:for-each>
				</TableData>
			</xsl:when>
			<xsl:otherwise>
				<TableData>
				   <xsl:choose>
				      <xsl:when test="DCStorageObject/BusProtocol != '9'">
					     <SubHeader display="Connectors"/>
				      </xsl:when>
				      <xsl:otherwise>
					      <SubHeader display="PCIe SSD Extender"/>
				      </xsl:otherwise>
				   </xsl:choose>
				   <Header>
						<xsl:call-template name="ChannelTableHeader">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="DCStorageObject">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:call-template name="ChannelTableRows">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="VirtualDisks">
		<TableData>
			<SubHeader display="Virtual Disks"/>
			<Header>
				<xsl:call-template name="VirtualDiskTableHeader">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</Header>
			<xsl:for-each select="DCStorageObject">
				<xsl:sort select="LogicalDriveNum" data-type="number" order="ascending"/>
				<xsl:call-template name="VirtualDiskTableRows">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
		</TableData>
	</xsl:template>
      <xsl:template match="Partitions">
		<TableData>
			<SubHeader display="Partitions"/>
			<Header>
				<xsl:call-template name="VirtualDiskPartitionTableHeader">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</Header>
			<xsl:for-each select="DCStorageObject">
				
				<xsl:call-template name="VirtualDiskPartitionTableRows">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
		</TableData>
	</xsl:template>
	 
	<xsl:template match="ArrayDisks">
		<TableData>
			<xsl:choose>
                    <xsl:when test="DCStorageObject/MediaType = '4'">
                         <SubHeader display="Tape Drives"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <SubHeader display="Physical Disks"/>

                    </xsl:otherwise>   
                  </xsl:choose>  
			<Header>
				<xsl:call-template name="ArrayDiskTableHeader">
					<xsl:with-param name="tasks">false</xsl:with-param>
					<xsl:with-param name="expanded">true</xsl:with-param>
					<xsl:with-param name="VAR_TAPE_LIBRARIES"><xsl:choose><xsl:when test="DCStorageObject/MediaType= '4'">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:with-param>
				</xsl:call-template>
			</Header>
			<xsl:choose>
				<xsl:when test="DCStorageObject/EnclosureID">
					<xsl:for-each select="DCStorageObject">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
						<xsl:sort select="TargetID" data-type="number" order="ascending"/>
						<xsl:call-template name="ArrayDiskTableRows">
							<xsl:with-param name="tasks">false</xsl:with-param>
							<xsl:with-param name="expanded">true</xsl:with-param>
							<xsl:with-param name="VAR_TAPE_LIBRARIES"><xsl:choose><xsl:when test="MediaType= '4'">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:for-each select="DCStorageObject">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:sort select="TargetID" data-type="number" order="ascending"/>
						<xsl:call-template name="ArrayDiskTableRows">
							<xsl:with-param name="tasks">false</xsl:with-param>
							<xsl:with-param name="expanded">true</xsl:with-param>
							<xsl:with-param name="VAR_TAPE_LIBRARIES"><xsl:choose><xsl:when test="MediaType= '4'">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:with-param>

						</xsl:call-template>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</TableData>
	</xsl:template>
	<!-- DFCT140720 - CLI: Enclosure info not seen under controller details using omreport command  -->
	<!-- Indravijay J. Gohil Adding in the necessary templates to be able to display the enclosure info on CLI-->
	<xsl:template match="Enclosures">
		<TableData>
			<SubHeader display="Enclosure(s)"/>
			<Header>
				<xsl:call-template name="EnclosureTableHeader">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</Header>
			<xsl:for-each select="DCStorageObject">
				<xsl:call-template name="EnclosureTableRows">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
		</TableData>
	</xsl:template>
	<!--



						<Header>
							<xsl:call-template name="ControllerTableHeader">
								<xsl:with-param name="tasks">false</xsl:with-param>
							</xsl:call-template>
						</Header>
						<xsl:for-each select="/*/Controllers/DCStorageObject">
							<xsl:call-template name="ControllerTableRows">
								<xsl:with-param name="tasks">false</xsl:with-param>
							</xsl:call-template>
						</xsl:for-each>
					</TableData>
					<xsl:if test="count(//Channels/DCStorageObject)!=0">
					<SubHeader>
						<xsl:attribute name="display">Controller <xsl:value-of select="//Controllers/DCStorageObject/Name"/> Channels</xsl:attribute>
					</SubHeader>
						<TableData>
							<Header>
								<xsl:call-template name="ChannelTableHeader">
									<xsl:with-param name="tasks">false</xsl:with-param>
								</xsl:call-template>
							</Header>
							<xsl:for-each select="/*/Channels/DCStorageObject">
								<xsl:call-template name="ChannelTableRows">
									<xsl:with-param name="tasks">false</xsl:with-param>
								</xsl:call-template>
							</xsl:for-each>
						</TableData>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<TableData>
						<Header>
							<Data>
								<xsl:attribute name="value">No controllers detected on system</xsl:attribute>
							</Data>
						</Header>
					</TableData>
				</xsl:otherwise>
			</xsl:choose>
		</DataArea>
-->

	<xsl:template name="PathHealthCommonTableHeader">
		<Data name="Status" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
		</Data>
		<Data name="Name" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
		</Data>
		<Data name="State" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
		</Data>
	</xsl:template>

	<xsl:template name="PathHealthConnector0TableRows">
		<Row>
			<Data type="status" align="right">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="substring(AttributesMask,28,1)='1'">4</xsl:when>
						<xsl:when test="substring(AttributesMask,27,1)='1' or substring(AttributesMask,24,1)='1'">2</xsl:when>
						<xsl:when test="substring(AttributesMask,25,1)='1'">3</xsl:when>
						<xsl:otherwise>2</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="Connector0" editable="false" type="ustring" display="Connector0" align="left">
				<xsl:attribute name="value"><xsl:value-of select="$strConnector0"/></xsl:attribute>
			</Data>
			<Data name="State1" editable="false" type="ustring" display="State1" align="left">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="substring(AttributesMask,28,1)='1'"><xsl:value-of select="$strDisconnected"/></xsl:when>
						<xsl:when test="substring(AttributesMask,27,1)='1' or substring(AttributesMask,24,1)='1'"><xsl:value-of select="$strAvailable"/></xsl:when>
						<xsl:when test="substring(AttributesMask,25,1)='1'"><xsl:value-of select="$strDegraded"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strAvailable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>

	<xsl:template name="PathHealthConnector1TableRows">
		<Row>
			<Data type="status" align="right">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="substring(AttributesMask,27,1)='1'">4</xsl:when>
						<xsl:when test="substring(AttributesMask,28,1)='1' or substring(AttributesMask,25,1)='1'">2</xsl:when>
						<xsl:when test="substring(AttributesMask,24,1)='1'">3</xsl:when>
						<xsl:otherwise>2</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="Connector1" editable="false" type="ustring" display="Connector1" align="left">
				<xsl:attribute name="value"><xsl:value-of select="$strConnector1"/></xsl:attribute>
			</Data>
			<Data name="State2" editable="false" type="ustring" display="State2" align="left">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="substring(AttributesMask,27,1)='1'"><xsl:value-of select="$strDisconnected"/></xsl:when>
						<xsl:when test="substring(AttributesMask,28,1)='1' or substring(AttributesMask,25,1)='1'"><xsl:value-of select="$strAvailable"/></xsl:when>
						<xsl:when test="substring(AttributesMask,24,1)='1'"><xsl:value-of select="$strDegraded"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strAvailable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>

	<xsl:template match="OMAUserRights"/>
	<xsl:template match="*"/>
</xsl:stylesheet>
