<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../common/chnltbl.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:template match="/">
		<DataArea>
			<xsl:variable name="slotNum">
				<xsl:choose>
					<xsl:when test="//Channels/@PCISlotNo = '-1' or //Channels/@PCISlotNo = '2147483648' or //Channels/@PCISlotNo = '0' ">
						<xsl:value-of select="$strEmbedded"/>
					</xsl:when>
					<xsl:when test="//Channels/@PCISlotNo = '2147483649'">
					<xsl:value-of select="'Not Available'"/>
					</xsl:when>
					<xsl:otherwise>Slot <xsl:value-of select="//Channels/@PCISlotNo"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="count(//Channels/DCStorageObject)!=0">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="//Channels/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
					</PageTitle>
					<xsl:apply-templates select="//Channels"/>
					</xsl:when>
				<xsl:otherwise>
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strHeader1"/></xsl:attribute>
					</PageTitle>
				</xsl:otherwise>
			</xsl:choose>							
		</DataArea>
	</xsl:template>
	<xsl:template match="Channels">
		<xsl:choose>
			<xsl:when test="substring(DCStorageObject/AttributesMask,26,1)='1'">
				<TableData>
					<Header>
						<xsl:call-template name="ChannelTableHeader">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="DCStorageObject[1]">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:call-template name="ChannelTableRows">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>

				<!-- Provide the below path health table only in the case if connector in multipath -->
				<TableData>
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeader5"/></xsl:attribute>
					</SubHeader>
					<Header>
						<xsl:call-template name="PathHealthCommonTableHeader"/>
					</Header>
					<xsl:for-each select="DCStorageObject[1]">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:call-template name="PathHealthConnector0TableRows"/>
					</xsl:for-each>
					<Header>
						<xsl:call-template name="PathHealthCommonTableHeader"/>
					</Header>
					<xsl:for-each select="DCStorageObject[2]">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:call-template name="PathHealthConnector1TableRows"/>
					</xsl:for-each>
				</TableData>
			</xsl:when>
			<xsl:otherwise>
				<TableData>
					<Header>
						<xsl:call-template name="ChannelTableHeader">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="DCStorageObject">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:call-template name="ChannelTableRows">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="PathHealthCommonTableHeader">
		<Data name="Status" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
		</Data>
		<Data name="Name" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
		</Data>
		<Data name="State" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
		</Data>
	</xsl:template>

	<xsl:template name="PathHealthConnector0TableRows">
		<Row>
			<Data type="status" align="right">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="substring(AttributesMask,28,1)='1'">4</xsl:when>
						<xsl:when test="substring(AttributesMask,27,1)='1' or substring(AttributesMask,24,1)='1'">2</xsl:when>
						<xsl:when test="substring(AttributesMask,25,1)='1'">3</xsl:when>
						<xsl:otherwise>2</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="Connector0" editable="false" type="ustring" display="Connector0" align="left">
				<xsl:attribute name="value"><xsl:value-of select="$strConnector0"/></xsl:attribute>
			</Data>
			<Data name="State1" editable="false" type="ustring" display="State1" align="left">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="substring(AttributesMask,28,1)='1'"><xsl:value-of select="$strDisconnected"/></xsl:when>
						<xsl:when test="substring(AttributesMask,27,1)='1' or substring(AttributesMask,24,1)='1'"><xsl:value-of select="$strAvailable"/></xsl:when>
						<xsl:when test="substring(AttributesMask,25,1)='1'"><xsl:value-of select="$strDegraded"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strAvailable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>

	<xsl:template name="PathHealthConnector1TableRows">
		<Row>
			<Data type="status" align="right">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="substring(AttributesMask,27,1)='1'">4</xsl:when>
						<xsl:when test="substring(AttributesMask,28,1)='1' or substring(AttributesMask,25,1)='1'">2</xsl:when>
						<xsl:when test="substring(AttributesMask,24,1)='1'">3</xsl:when>
						<xsl:otherwise>2</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="Connector1" editable="false" type="ustring" display="Connector1" align="left">
				<xsl:attribute name="value"><xsl:value-of select="$strConnector1"/></xsl:attribute>
			</Data>
			<Data name="State2" editable="false" type="ustring" display="State2" align="left">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="substring(AttributesMask,27,1)='1'"><xsl:value-of select="$strDisconnected"/></xsl:when>
						<xsl:when test="substring(AttributesMask,28,1)='1' or substring(AttributesMask,25,1)='1'"><xsl:value-of select="$strAvailable"/></xsl:when>
						<xsl:when test="substring(AttributesMask,24,1)='1'"><xsl:value-of select="$strDegraded"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strAvailable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
	<xsl:template match="OMAUserRights"/>
	<xsl:template match="*"/>
</xsl:stylesheet>


